/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.library.metrics.MetricsComponentDependencyGraph;
import com.tngtech.archunit.library.metrics.MetricsComponents;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ComponentDependencyMetrics {
    private final Map<String, SingleComponentMetrics> metricsByComponentIdentifier;

    ComponentDependencyMetrics(MetricsComponents<JavaClass> components, Function<JavaClass, Collection<JavaClass>> getDependencies) {
        MetricsComponentDependencyGraph<JavaClass> graph = MetricsComponentDependencyGraph.of(components, getDependencies);
        ImmutableMap.Builder<String, SingleComponentMetrics> metricsByComponentIdentifierBuilder = ImmutableMap.builder();
        for (MetricsComponent metricsComponent : components) {
            metricsByComponentIdentifierBuilder.put(metricsComponent.getIdentifier(), new SingleComponentMetrics(metricsComponent, graph));
        }
        this.metricsByComponentIdentifier = metricsByComponentIdentifierBuilder.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getEfferentCoupling(String componentIdentifier) {
        return this.getComponentMetrics(componentIdentifier).getEfferentCoupling();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getAfferentCoupling(String componentIdentifier) {
        return this.getComponentMetrics(componentIdentifier).getAfferentCoupling();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getInstability(String componentIdentifier) {
        return this.getComponentMetrics(componentIdentifier).getInstability();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getAbstractness(String componentIdentifier) {
        return this.getComponentMetrics(componentIdentifier).getAbstractness();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getNormalizedDistanceFromMainSequence(String componentIdentifier) {
        return this.getComponentMetrics(componentIdentifier).getNormalizedDistanceFromMainSequence();
    }

    private SingleComponentMetrics getComponentMetrics(String componentIdentifier) {
        SingleComponentMetrics result = this.metricsByComponentIdentifier.get(componentIdentifier);
        Preconditions.checkArgument(result != null, "Unknown component with identifier '" + componentIdentifier + "'");
        return result;
    }

    private static class SingleComponentMetrics {
        private final int efferentCoupling;
        private final int afferentCoupling;
        private final double instability;
        private final double abstractness;
        private final double normalizedDistanceFromMainSequence;

        SingleComponentMetrics(MetricsComponent<JavaClass> component, MetricsComponentDependencyGraph<JavaClass> graph) {
            this.efferentCoupling = graph.getDirectDependenciesFrom(component).size();
            this.afferentCoupling = graph.getDirectDependenciesTo(component).size();
            this.instability = SingleComponentMetrics.divideSafely(this.efferentCoupling, this.efferentCoupling + this.afferentCoupling, 1.0);
            ContainedPublicClasses classes = new ContainedPublicClasses(component);
            this.abstractness = SingleComponentMetrics.divideSafely(classes.numberOfAbstractClasses, classes.numberOfAllClasses, 0.0);
            this.normalizedDistanceFromMainSequence = Math.abs(this.instability + this.abstractness - 1.0);
        }

        int getEfferentCoupling() {
            return this.efferentCoupling;
        }

        int getAfferentCoupling() {
            return this.afferentCoupling;
        }

        double getInstability() {
            return this.instability;
        }

        double getAbstractness() {
            return this.abstractness;
        }

        double getNormalizedDistanceFromMainSequence() {
            return this.normalizedDistanceFromMainSequence;
        }

        private static double divideSafely(int dividend, int divisor, double replacementValue) {
            return divisor != 0 ? (double)dividend / (double)divisor : replacementValue;
        }

        private static class ContainedPublicClasses {
            final int numberOfAbstractClasses;
            final int numberOfAllClasses;

            ContainedPublicClasses(MetricsComponent<JavaClass> component) {
                int numberOfAbstractClasses = 0;
                int numberOfAllClasses = 0;
                for (JavaClass javaClass : component) {
                    if (!javaClass.getModifiers().contains((Object)JavaModifier.PUBLIC)) continue;
                    ++numberOfAllClasses;
                    if (!javaClass.getModifiers().contains((Object)JavaModifier.ABSTRACT)) continue;
                    ++numberOfAbstractClasses;
                }
                this.numberOfAbstractClasses = numberOfAbstractClasses;
                this.numberOfAllClasses = numberOfAllClasses;
            }
        }
    }
}

