/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal.parse;

import jakarta.persistence.metamodel.EntityType;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.grammars.graph.GraphLanguageLexer;
import org.hibernate.grammars.graph.GraphLanguageParser;
import org.hibernate.graph.InvalidGraphException;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.internal.parse.EntityNameResolver;
import org.hibernate.graph.internal.parse.EntityNameResolverSessionFactory;
import org.hibernate.graph.internal.parse.GraphParser;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;

public class GraphParsing {
    public static <T> RootGraphImplementor<T> parse(Class<T> entityClass, String graphText, SessionFactoryImplementor sessionFactory) {
        if (graphText == null) {
            return null;
        }
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphText));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        if (graphContext.typeIndicator() != null) {
            throw new InvalidGraphException("Expecting graph text to not include an entity name : " + graphText);
        }
        EntityType entityType = sessionFactory.getJpaMetamodel().entity(entityClass);
        return GraphParsing.parse(entityType, graphContext.attributeList(), sessionFactory);
    }

    public static <T> RootGraphImplementor<T> parse(EntityDomainType<T> entityDomainType, String graphText, SessionFactoryImplementor sessionFactory) {
        if (graphText == null) {
            return null;
        }
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphText));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        if (graphContext.typeIndicator() != null) {
            throw new InvalidGraphException("Expecting graph text to not include an entity name : " + graphText);
        }
        return GraphParsing.parse(entityDomainType, graphContext.attributeList(), sessionFactory);
    }

    public static <T> RootGraphImplementor<T> parse(String entityName, String graphText, SessionFactoryImplementor sessionFactory) {
        if (graphText == null) {
            return null;
        }
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphText));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        if (graphContext.typeIndicator() != null) {
            throw new InvalidGraphException("Expecting graph text to not include an entity name : " + graphText);
        }
        EntityType entityType = sessionFactory.getJpaMetamodel().entity(entityName);
        return GraphParsing.parse(entityType, graphContext.attributeList(), sessionFactory);
    }

    public static <T> RootGraphImplementor<T> parse(String graphText, SessionFactoryImplementor sessionFactory) {
        if (graphText == null) {
            return null;
        }
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphText));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        if (graphContext.typeIndicator() == null) {
            throw new InvalidGraphException("Expecting graph text to include an entity name : " + graphText);
        }
        String entityName = graphContext.typeIndicator().TYPE_NAME().getText();
        EntityType entityType = sessionFactory.getJpaMetamodel().entity(entityName);
        return GraphParsing.parse(entityType, graphContext.attributeList(), sessionFactory);
    }

    public static <T> RootGraphImplementor<T> parse(EntityDomainType<T> rootType, GraphLanguageParser.AttributeListContext attributeListContext, SessionFactoryImplementor sessionFactory) {
        return GraphParsing.parse(rootType, attributeListContext, new EntityNameResolverSessionFactory(sessionFactory));
    }

    public static <T> RootGraphImplementor<T> parse(EntityDomainType<T> rootType, GraphLanguageParser.AttributeListContext attributeListContext, EntityNameResolver entityNameResolver) {
        return GraphParsing.parse(null, rootType, attributeListContext, entityNameResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RootGraphImplementor<T> parse(@Nullable String name, EntityDomainType<T> rootType, GraphLanguageParser.AttributeListContext attributeListContext, EntityNameResolver entityNameResolver) {
        RootGraphImpl<T> targetGraph = new RootGraphImpl<T>(name, rootType);
        GraphParser visitor = new GraphParser(entityNameResolver);
        visitor.getGraphStack().push(targetGraph);
        try {
            visitor.visitAttributeList(attributeListContext);
        }
        finally {
            visitor.getGraphStack().pop();
            assert (visitor.getGraphStack().isEmpty());
        }
        return targetGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseInto(GraphImplementor<?> targetGraph, CharSequence graphString, SessionFactoryImplementor sessionFactory) {
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphString.toString()));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        if (graphContext.typeIndicator() != null) {
            // empty if block
        }
        GraphParser visitor = new GraphParser(sessionFactory);
        visitor.getGraphStack().push(targetGraph);
        try {
            visitor.visitAttributeList(graphContext.attributeList());
        }
        finally {
            visitor.getGraphStack().pop();
            assert (visitor.getGraphStack().isEmpty());
        }
    }
}

