/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHDomainParametersID;
import org.bouncycastle.crypto.asymmetric.DHDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.DhBasicAgreement;
import org.bouncycastle.crypto.fips.DhKeyPairGenerator;
import org.bouncycastle.crypto.fips.DhParametersGenerator;
import org.bouncycastle.crypto.fips.DhuBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementFactory;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.MqvBasicAgreement;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DhKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.DhuPublicParameters;
import org.bouncycastle.crypto.internal.params.MqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.MqvPublicParameters;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public final class FipsDH {
    private static final int MIN_FIPS_KEY_STRENGTH = 2048;
    static final FipsEngineProvider<DhBasicAgreement> AGREEMENT_PROVIDER;
    static final FipsEngineProvider<MqvBasicAgreement> MQV_PROVIDER;
    static final FipsEngineProvider<DhuBasicAgreement> DHU_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    private static final FipsAlgorithm ALGORITHM_DH;
    private static final FipsAlgorithm ALGORITHM_MQV;
    private static final FipsAlgorithm ALGORITHM_DHU;
    public static final AgreementParameters DH;
    public static final MQVAgreementParametersBuilder MQV;
    public static final DHUAgreementParametersBuilder DHU;

    private FipsDH() {
    }

    private static void validateKeyPair(FipsAlgorithm fipsAlgorithm, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        Variations variations = fipsAlgorithm == ALGORITHM ? Variations.DH : (Variations)fipsAlgorithm.basicVariation();
        switch (variations) {
            case DH: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        DhBasicAgreement dhBasicAgreement = new DhBasicAgreement();
                        dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        dhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        dhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case MQV: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        MqvBasicAgreement mqvBasicAgreement = new MqvBasicAgreement();
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger2 = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        BigInteger bigInteger3 = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !bigInteger.equals(bigInteger2) && bigInteger2.equals(bigInteger3);
                    }
                });
                break;
            }
            case DHU: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        DhuBasicAgreement dhuBasicAgreement = new DhuBasicAgreement();
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray2 = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        byte[] byArray3 = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !Arrays.areEqual(byArray, byArray2) && Arrays.areEqual(byArray2, byArray3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled DH algorithm: " + fipsAlgorithm.getName());
            }
        }
    }

    private static void ffPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            @Override
            void evaluate() throws Exception {
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
                if (!dhPublicKeyParameters.getY().equals(dhPrivateKeyParameters.getParameters().getG().modPow(dhPrivateKeyParameters.getX(), dhPrivateKeyParameters.getParameters().getP()))) {
                    this.fail("FF primitive 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        DHDomainParameters dHDomainParameters = DHDomainParametersIndex.lookupDomainParameters(DomainParameterID.ffdhe2048);
        DhParameters dhParameters = new DhParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ());
        BigInteger bigInteger = new BigInteger("80d54802e42ce811d122ce2657c303013fc33c2f08f8ff1a9c4ebfd1", 16);
        BigInteger bigInteger2 = new BigInteger("f9a4d8edb52efa7ffd00bc2e632b79c69eba8949f7ba23a6feb2d27278e96cbd7fe158484286c07f91144a268539eeffb306844898c5efa845070489bcdc756c6858dcb242629f91b2714a33c0efebcb4b0832dba33b12db491dcded86f497094a52a3091a4bdf832d4f36cb0cd7ab05e24b2adea4d746806d9776cebe45b0938c8a7f323db0497f865e8d992839ce018d54b68c5808a97fb035c83c304690e6fff83dfd13be0186bdf0531cc416f9189fe87b1c92ce569578e9f55c874c0111a1e155f4dd876069424d38c94beb47f890d082eb9183a7ce3c6819c420ca91ba969549835314df899fc766ac2acc9d6b9de5b0a9570ca4cfb6187e049fbe6f10", 16);
        return new AsymmetricCipherKeyPair(new DhPublicKeyParameters(bigInteger2, dhParameters), new DhPrivateKeyParameters(bigInteger, dhParameters));
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DhParameters dhParameters = dhPrivateKeyParameters.getParameters();
        BigInteger bigInteger = dhPrivateKeyParameters.getX().multiply(BigInteger.valueOf(7L)).mod(dhPrivateKeyParameters.getX());
        if (bigInteger.compareTo(BigInteger.valueOf(2L)) < 0) {
            bigInteger = new BigInteger("0102030405060708090a0b0c0d0e0f101112131415161718", 16);
        }
        DhPrivateKeyParameters dhPrivateKeyParameters2 = new DhPrivateKeyParameters(bigInteger, dhParameters);
        DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(dhParameters.getG().modPow(bigInteger, dhParameters.getP()), dhParameters);
        return new AsymmetricCipherKeyPair(dhPublicKeyParameters, dhPrivateKeyParameters2);
    }

    private static DhParameters getDomainParams(DHDomainParameters dHDomainParameters) {
        return new DhParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getM(), dHDomainParameters.getL(), dHDomainParameters.getJ());
    }

    private static DhPrivateKeyParameters getLwKey(final AsymmetricDHPrivateKey asymmetricDHPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DhPrivateKeyParameters>(){

            @Override
            public DhPrivateKeyParameters run() {
                return new DhPrivateKeyParameters(asymmetricDHPrivateKey.getX(), FipsDH.getDomainParams(asymmetricDHPrivateKey.getDomainParameters()));
            }
        });
    }

    static {
        ALGORITHM = new FipsAlgorithm("DH");
        ALGORITHM_DH = new FipsAlgorithm("DH", (Enum)Variations.DH);
        ALGORITHM_MQV = new FipsAlgorithm("DH", (Enum)Variations.MQV);
        ALGORITHM_DHU = new FipsAlgorithm("DH", (Enum)Variations.DHU);
        DH = new AgreementParameters();
        MQV = new MQVAgreementParametersBuilder();
        DHU = new DHUAgreementParametersBuilder();
        FipsDH.ffPrimitiveZTest();
        AGREEMENT_PROVIDER = new AgreementProvider();
        MQV_PROVIDER = new MqvProvider();
        DHU_PROVIDER = new DhuProvider();
        AGREEMENT_PROVIDER.createEngine();
        MQV_PROVIDER.createEngine();
        DHU_PROVIDER.createEngine();
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters() {
            this(null);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM, fipsAlgorithm);
        }

        private AgreementParameters(FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM, pRF, byArray);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(fipsAlgorithm, agreementKDFParametersBuilder, byArray, n);
        }

        public AgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new AgreementParameters(fipsAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new AgreementParameters(pRF, byArray);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new AgreementParameters(this.getAlgorithm(), agreementKDFParametersBuilder, byArray, n);
        }
    }

    private static class AgreementProvider
    extends FipsEngineProvider<DhBasicAgreement> {
        static final BigInteger expected = new BigInteger("b9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6e", 16);

        private AgreementProvider() {
        }

        @Override
        public DhBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_DH, new DhBasicAgreement(), new VariantKatTest<DhBasicAgreement>(){

                @Override
                void evaluate(DhBasicAgreement dhBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT DH agreement not verified");
                    }
                }
            });
        }
    }

    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final AgreementParameters agreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhPrivateKeyParameters dhPrivateKeyParameters = FipsDH.getLwKey(asymmetricDHPrivateKey);
            final DhBasicAgreement dhBasicAgreement = (DhBasicAgreement)AGREEMENT_PROVIDER.createEngine();
            dhBasicAgreement.init(dhPrivateKeyParameters);
            return new FipsAgreement<AgreementParameters>(){

                @Override
                public AgreementParameters getParameters() {
                    return agreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    int n = dhBasicAgreement.getFieldSize();
                    BigInteger bigInteger = dhBasicAgreement.calculateAgreement(dhPublicKeyParameters);
                    byte[] byArray = BigIntegers.asUnsignedByteArray(n, bigInteger);
                    return FipsKDF.processZBytes(byArray, agreementParameters);
                }
            };
        }
    }

    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final DHUAgreementParameters dHUAgreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhuPrivateParameters dhuPrivateParameters = new DhuPrivateParameters(FipsDH.getLwKey(asymmetricDHPrivateKey), FipsDH.getLwKey(dHUAgreementParameters.ephemeralPrivateKey));
            final DhuBasicAgreement dhuBasicAgreement = (DhuBasicAgreement)DHU_PROVIDER.createEngine();
            dhuBasicAgreement.init(dhuPrivateParameters);
            return new FipsAgreement<DHUAgreementParameters>(){

                @Override
                public DHUAgreementParameters getParameters() {
                    return dHUAgreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    DhuPublicParameters dhuPublicParameters = new DhuPublicParameters(dhPublicKeyParameters, new DhPublicKeyParameters(dHUAgreementParameters.otherPartyEphemeralKey.getY(), dhPublicKeyParameters.getParameters()));
                    byte[] byArray = dhuBasicAgreement.calculateAgreement(dhuPublicParameters);
                    return FipsKDF.processZBytes(byArray, dHUAgreementParameters);
                }
            };
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_DHU, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_DHU, pRF, byArray);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(ALGORITHM_DHU, agreementKDFParametersBuilder, byArray, n);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new DHUAgreementParameters((AsymmetricDHPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricDHPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new DHUAgreementParameters(null, asymmetricDHPrivateKey, asymmetricDHPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2) {
            return new DHUAgreementParameters(asymmetricDHPublicKey, asymmetricDHPrivateKey, asymmetricDHPublicKey2, null);
        }
    }

    private static class DhuProvider
    extends FipsEngineProvider<DhuBasicAgreement> {
        static final byte[] expected = Hex.decode("b9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6eb9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6e");

        private DhuProvider() {
        }

        @Override
        public DhuBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_DHU, new DhuBasicAgreement(), new VariantKatTest<DhuBasicAgreement>(){

                @Override
                void evaluate(DhuBasicAgreement dhuBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    byte[] byArray = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!Arrays.areEqual(expected, byArray)) {
                        this.fail("KAT DH DHU agreement not verified");
                    }
                }
            });
        }
    }

    public static final class DomainGenParameters
    extends FipsParameters {
        private final int L;
        private final int N;
        private final int certainty;
        private final BigInteger p;
        private final BigInteger q;
        private final byte[] seed;
        private final int usageIndex;

        public DomainGenParameters(int n) {
            this(n, n > 1024 ? 256 : 160, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public DomainGenParameters(int n, int n2) {
            this(n, n > 1024 ? 256 : 160, n2);
        }

        public DomainGenParameters(int n, int n2, int n3) {
            this(n, n2, n3, null, null, null, -1);
        }

        public DomainGenParameters(int n, int n2, int n3, int n4) {
            this(n, n2, n3, null, null, null, n4);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, null, -1);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, Arrays.clone(byArray), n);
        }

        private DomainGenParameters(int n, int n2, int n3, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n4) {
            super(ALGORITHM);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && bigInteger == null && n3 < PrimeCertaintyCalculator.getDefaultCertainty(n)) {
                throw new FipsUnapprovedOperationError("Prime generation certainty " + n3 + " inadequate for parameters of " + n + " bits", this.getAlgorithm());
            }
            if (n4 > 255) {
                throw new IllegalArgumentException("Usage index must be in range 0 to 255 (or -1 to ignore)");
            }
            this.L = n;
            this.N = n2;
            this.certainty = n3;
            this.p = bigInteger;
            this.q = bigInteger2;
            this.seed = byArray;
            this.usageIndex = n4;
        }
    }

    public static enum DomainParameterID implements DHDomainParametersID
    {
        ffdhe2048("ffdhe2048"),
        ffdhe3072("ffdhe3072"),
        ffdhe4096("ffdhe4096"),
        ffdhe6144("ffdhe6144"),
        ffdhe8192("ffdhe8192"),
        modp2048("modp2048"),
        modp3072("modp3072"),
        modp4096("modp4096"),
        modp6144("modp6144"),
        modp8192("modp8192");

        private final String name;

        private DomainParameterID(String string2) {
            this.name = string2;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;
        private final FipsDigestAlgorithm digestAlgorithm;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            this(FipsSHS.Algorithm.SHA256, domainGenParameters, secureRandom);
        }

        public DomainParametersGenerator(FipsDigestAlgorithm fipsDigestAlgorithm, DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n = domainGenParameters.L;
                if (n < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to create parameters with unapproved key size [" + n + "]", ALGORITHM);
                }
                Utils.validateRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n), ALGORITHM, "Attempt to create parameters with unapproved RNG");
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DHDomainParameters generateDomainParameters() {
            if (this.parameters.L < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new FipsUnapprovedOperationError("Requested DH parameter strength too small for approved mode: " + this.parameters.L);
                }
                DhParametersGenerator dhParametersGenerator = new DhParametersGenerator();
                dhParametersGenerator.init(this.parameters.L, this.parameters.certainty, this.random);
                DhParameters dhParameters = dhParametersGenerator.generateParameters();
                return new DHDomainParameters(dhParameters.getP(), dhParameters.getQ(), dhParameters.getG(), dhParameters.getJ(), null);
            }
            FipsDSA.DomainGenParameters domainGenParameters = new FipsDSA.DomainGenParameters(this.parameters.L, this.parameters.N, this.parameters.certainty, this.parameters.p, this.parameters.q, this.parameters.seed, this.parameters.usageIndex);
            FipsDSA.DomainParametersGenerator domainParametersGenerator = new FipsDSA.DomainParametersGenerator(this.digestAlgorithm, domainGenParameters, this.random);
            DSADomainParameters dSADomainParameters = domainParametersGenerator.generateDomainParameters();
            DSAValidationParameters dSAValidationParameters = dSADomainParameters.getValidationParameters();
            if (dSAValidationParameters != null) {
                return new DHDomainParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG(), null, new DHValidationParameters(dSAValidationParameters.getSeed(), dSAValidationParameters.getCounter(), dSAValidationParameters.getUsageIndex()));
            }
            return new DHDomainParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final DHDomainParameters domainParameters;

        public KeyGenParameters(DHDomainParameters dHDomainParameters) {
            this(ALGORITHM, dHDomainParameters);
        }

        public KeyGenParameters(AgreementParameters agreementParameters, DHDomainParameters dHDomainParameters) {
            this(agreementParameters.getAlgorithm(), dHDomainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder mQVAgreementParametersBuilder, DHDomainParameters dHDomainParameters) {
            this(mQVAgreementParametersBuilder.getAlgorithm(), dHDomainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder dHUAgreementParametersBuilder, DHDomainParameters dHDomainParameters) {
            this(dHUAgreementParametersBuilder.getAlgorithm(), dHDomainParameters);
        }

        private KeyGenParameters(FipsAlgorithm fipsAlgorithm, DHDomainParameters dHDomainParameters) {
            super(fipsAlgorithm);
            this.domainParameters = dHDomainParameters;
        }

        public DHDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator {
        private final DhKeyPairGenerator engine = new DhKeyPairGenerator();
        private final DHDomainParameters domainParameters;
        private final DhKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n = keyGenParameters.domainParameters.getP().bitLength();
                if (n < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to create key of less than 2048 bits", keyGenParameters.getAlgorithm());
                }
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n), ALGORITHM);
            }
            this.param = new DhKeyGenerationParameters(secureRandom, FipsDH.getDomainParams(keyGenParameters.getDomainParameters()));
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        public AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = (FipsAlgorithm)this.getParameters().getAlgorithm();
            FipsDH.validateKeyPair(fipsAlgorithm, asymmetricCipherKeyPair);
            return new AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey>(new AsymmetricDHPublicKey(fipsAlgorithm, this.domainParameters, dhPublicKeyParameters.getY()), new AsymmetricDHPrivateKey(fipsAlgorithm, this.domainParameters, dhPrivateKeyParameters.getX()));
        }
    }

    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final MQVAgreementParameters mQVAgreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhPrivateKeyParameters dhPrivateKeyParameters = FipsDH.getLwKey(asymmetricDHPrivateKey);
            final MqvBasicAgreement mqvBasicAgreement = (MqvBasicAgreement)MQV_PROVIDER.createEngine();
            mqvBasicAgreement.init(new MqvPrivateParameters(dhPrivateKeyParameters, mQVAgreementParameters.ephemeralPrivateKey == null ? dhPrivateKeyParameters : FipsDH.getLwKey(mQVAgreementParameters.ephemeralPrivateKey)));
            return new FipsAgreement<MQVAgreementParameters>(){

                @Override
                public MQVAgreementParameters getParameters() {
                    return mQVAgreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    int n = mqvBasicAgreement.getFieldSize();
                    AsymmetricDHPublicKey asymmetricDHPublicKey2 = mQVAgreementParameters.getOtherPartyEphemeralKey();
                    BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters(dhPublicKeyParameters, new DhPublicKeyParameters(asymmetricDHPublicKey2.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey2.getDomainParameters()))));
                    byte[] byArray = BigIntegers.asUnsignedByteArray(n, bigInteger);
                    return FipsKDF.processZBytes(byArray, mQVAgreementParameters);
                }
            };
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_MQV, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_MQV, pRF, byArray);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(ALGORITHM_MQV, agreementKDFParametersBuilder, byArray, n);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new MQVAgreementParameters((AsymmetricDHPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricDHPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new MQVAgreementParameters(null, asymmetricDHPrivateKey, asymmetricDHPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2) {
            return new MQVAgreementParameters(asymmetricDHPublicKey, asymmetricDHPrivateKey, asymmetricDHPublicKey2, null);
        }
    }

    private static class MqvProvider
    extends FipsEngineProvider<MqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("fb6ad631bae112b5d2a24fa6e821cd3b1f5e70c352b66b83d348a1e4c825bb3b58048f8b1551ee01880d0e513b55e62b2f5389946716561bdb922b86841c311ebe34debb24f0f21a09fa5e383787b36d7c1998b4d6aa9a895859258217c303fedabceb7fe8f1021330a1780e93aca20088394d15b98dfbf5ef3820678feaca7b5c58ebf2b72f0ed4cddd4d8c70ef3a6d34c88f18d4f7bcdca07d5d8194f9db00f7f900c9bf7d7c25cccc94dd94c4a7dc03c3b6fa77dcf2725d3f850da278a5d1d16cf99e2abedbb5ba444bd0bdf7d6decef0d1d1f72f17e255ec9a4edb1c5db833fb65e8b604b00bd542043ed2562c1e1f5cce36fbfe4ba400e61c32622d6dd7", 16);

        private MqvProvider() {
        }

        @Override
        public MqvBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_MQV, new MqvBasicAgreement(), new VariantKatTest<MqvBasicAgreement>(){

                @Override
                void evaluate(MqvBasicAgreement mqvBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!expected.equals(bigInteger)) {
                        this.fail("KAT DH MQV agreement not verified");
                    }
                }
            });
        }
    }

    private static enum Variations {
        DH,
        MQV,
        DHU;

    }
}

