/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.search.HighlightBase;
import org.opensearch.client.opensearch.core.search.HighlightField;
import org.opensearch.client.opensearch.core.search.HighlighterEncoder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Highlight
extends HighlightBase
implements ToCopyableBuilder<Builder, Highlight> {
    @Nullable
    private final HighlighterEncoder encoder;
    @Nonnull
    private final Map<String, HighlightField> fields;
    public static final JsonpDeserializer<Highlight> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Highlight::setupHighlightDeserializer);

    private Highlight(Builder builder) {
        super(builder);
        this.encoder = builder.encoder;
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
    }

    public static Highlight of(Function<Builder, ObjectBuilder<Highlight>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final HighlighterEncoder encoder() {
        return this.encoder;
    }

    @Nonnull
    public final Map<String, HighlightField> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.encoder != null) {
            generator.writeKey("encoder");
            this.encoder.serialize(generator, mapper);
        }
        generator.writeKey("fields");
        generator.writeStartObject();
        for (Map.Entry<String, HighlightField> item0 : this.fields.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHighlightDeserializer(ObjectDeserializer<Builder> op) {
        Highlight.setupHighlightBaseDeserializer(op);
        op.add(Builder::encoder, HighlighterEncoder._DESERIALIZER, "encoder");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(HighlightField._DESERIALIZER), "fields");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.encoder);
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Highlight other = (Highlight)o;
        return Objects.equals(this.encoder, other.encoder) && this.fields.equals(other.fields);
    }

    public static class Builder
    extends HighlightBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, Highlight> {
        @Nullable
        private HighlighterEncoder encoder;
        private Map<String, HighlightField> fields;

        public Builder() {
        }

        private Builder(Highlight o) {
            super(o);
            this.encoder = o.encoder;
            this.fields = Builder._mapCopy(o.fields);
        }

        private Builder(Builder o) {
            super(o);
            this.encoder = o.encoder;
            this.fields = Builder._mapCopy(o.fields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder encoder(@Nullable HighlighterEncoder value) {
            this.encoder = value;
            return this;
        }

        @Nonnull
        public final Builder fields(Map<String, HighlightField> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, HighlightField value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, Function<HighlightField.Builder, ObjectBuilder<HighlightField>> fn) {
            return this.fields(key, fn.apply(new HighlightField.Builder()).build());
        }

        @Override
        @Nonnull
        public Highlight build() {
            this._checkSingleUse();
            return new Highlight(this);
        }
    }
}

