/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.model.util.LowMemoryNotificationView;

public class MemoryMonitor {
    private static final int LOW_MEMORY_THRESHOLD_BYTES = 200048576;
    @Nonnull
    private final LowMemoryNotificationView view;
    private boolean displayedLowMemoryNotification;

    public MemoryMonitor(@Nonnull LowMemoryNotificationView view) {
        this.view = (LowMemoryNotificationView)Preconditions.checkNotNull((Object)view);
    }

    public MemoryStatus checkMemory() {
        long freeMem = MemoryMonitor.getFreeMemoryInBytes();
        if (freeMem < 200048576L) {
            this.displayLowMemoryNotification();
            return MemoryStatus.MEMORY_LOW;
        }
        return MemoryStatus.MEMORY_OK;
    }

    private static long getFreeMemoryInBytes() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory();
    }

    private synchronized void resumeThreads() {
        this.notifyAll();
    }

    private synchronized void displayLowMemoryNotification() {
        if (!this.displayedLowMemoryNotification) {
            this.displayedLowMemoryNotification = true;
            SwingUtilities.invokeLater(() -> {
                this.view.displayLowMemoryNotification();
                this.resumeThreads();
            });
            this.pauseCurrentThreadIfNotEdt();
        }
    }

    private void pauseCurrentThreadIfNotEdt() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum MemoryStatus {
        MEMORY_LOW,
        MEMORY_OK;

    }
}

