/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.paths.FileWithoutExtensionReference;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorSymbolReferenceProvider$Companion$findExistingFileFromReferences$;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "<init>", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "Companion", "intellij.markdown.model"})
public final class HeaderAnchorSymbolReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element2, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        if (!(element2 instanceof MarkdownLinkDestination)) {
            return CollectionsKt.emptyList();
        }
        if (MarkdownLinkDefinition.Companion.isUnderCommentWrapper((PsiElement)element2)) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)element2));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange range = textRange;
        String elementText = ((MarkdownLinkDestination)element2).getText();
        Intrinsics.checkNotNull((Object)elementText);
        TextRange textRange2 = HeaderAnchorSymbolReferenceProvider.Companion.calculateAnchorTextRange(elementText, range);
        if (textRange2 == null) {
            return CollectionsKt.emptyList();
        }
        TextRange anchorTextRange = textRange2;
        String string = anchorTextRange.substring(elementText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String anchor = string2;
        boolean hasPrefix = anchorTextRange.getStartOffset() != range.getStartOffset();
        PsiFile referencedFile = HeaderAnchorSymbolReferenceProvider.Companion.findExistingFileFromReferences((PsiElement)element2);
        if (hasPrefix && referencedFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = (PsiElement)element2;
        PsiFile psiFile = referencedFile;
        if (psiFile == null) {
            psiFile = ((MarkdownLinkDestination)element2).getContainingFile();
        }
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile2);
        HeaderAnchorLinkDestinationReference reference = new HeaderAnchorLinkDestinationReference(psiElement, anchorTextRange, anchor, psiFile2);
        return CollectionsKt.listOf((Object)reference);
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider$Companion;", "", "<init>", "()V", "calculateAnchorTextRange", "Lcom/intellij/openapi/util/TextRange;", "elementText", "", "valueTextRange", "findExistingFileFromReferences", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.model"})
    @SourceDebugExtension(value={"SMAP\nHeaderAnchorSymbolReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderAnchorSymbolReferenceProvider.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n37#2:79\n36#2,3:80\n477#3:83\n1#4:84\n*S KotlinDebug\n*F\n+ 1 HeaderAnchorSymbolReferenceProvider.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider$Companion\n*L\n68#1:79\n68#1:80,3\n73#1:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final TextRange calculateAnchorTextRange(String elementText, TextRange valueTextRange) {
            int anchorOffset = StringsKt.indexOf$default((CharSequence)elementText, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (anchorOffset == -1) {
                return null;
            }
            int endOffset = valueTextRange.getEndOffset();
            int endIndex = endOffset <= anchorOffset ? anchorOffset + 1 : endOffset;
            return new TextRange(anchorOffset + 1, endIndex);
        }

        private final PsiFile findExistingFileFromReferences(PsiElement element2) {
            PsiFile psiFile;
            FileWithoutExtensionReference fileWithoutExtensionReference;
            Sequence references;
            List list2 = PsiReferenceService.getService().getReferences(element2, PsiReferenceService.Hints.NO_HINTS);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getReferences(...)");
            List elementReferences = list2;
            Collection $this$toTypedArray$iv = elementReferences;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
            PsiFile file = FileReferenceUtil.findFile((PsiReference[])Arrays.copyOf(psiReferenceArray, psiReferenceArray.length));
            if (file != null) {
                return file;
            }
            Sequence $this$filterIsInstance$iv = references = CollectionsKt.asSequence((Iterable)elementReferences);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findExistingFileFromReferences$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            FileWithoutExtensionReference fileWithoutExtensionReference2 = fileWithoutExtensionReference = (FileWithoutExtensionReference)((Object)SequencesKt.firstOrNull((Sequence)sequence));
            if (fileWithoutExtensionReference2 != null) {
                FileWithoutExtensionReference it = fileWithoutExtensionReference2;
                boolean bl = false;
                PsiElement psiElement = it.resolve();
                psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

