/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.parameterInfo;

import com.intellij.codeInsight.parameterInfo.ParameterFlag;
import com.intellij.lang.parameterInfo.ParameterInfoUtilsBase;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.codeInsight.parameterInfo.ParameterHints;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyParameterInfoUtils {
    @Nullable
    public static PyArgumentList findArgumentList(PsiFile file, int contextOffset, int parameterListStart) {
        PyArgumentList argumentList = (PyArgumentList)ParameterInfoUtilsBase.findParentOfType((PsiFile)file, (int)(contextOffset - 1), PyArgumentList.class);
        if (argumentList != null && parameterListStart >= 0 && argumentList.getTextRange().getStartOffset() != parameterListStart) {
            return (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)argumentList, PyArgumentList.class);
        }
        return argumentList;
    }

    public static List<Pair<PyCallExpression, PyCallableType>> findCallCandidates(PyArgumentList argumentList) {
        PyCallExpression call;
        if (argumentList != null && (call = argumentList.getCallExpression()) != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(argumentList.getProject(), argumentList.getContainingFile());
            PyResolveContext resolveContext = PyResolveContext.defaultContext(typeEvalContext).withRemote();
            return call.multiResolveCallee(resolveContext).stream().filter(callableType -> callableType.getParameters(typeEvalContext) != null).map(callableType -> Pair.createNonNull((Object)call, (Object)callableType)).collect(Collectors.toList());
        }
        return null;
    }

    public static List<ParameterDescription> buildParameterListHint(@NotNull List<PyCallableParameter> parameters, final @NotNull Map<Integer, PyCallableParameter> indexToNamedParameter, final @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, final @NotNull Map<Integer, EnumSet<ParameterFlag>> hintFlags, final @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(0);
        }
        if (indexToNamedParameter == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(1);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(2);
        }
        if (hintFlags == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(4);
        }
        final int[] currentParameterIndex = new int[]{0};
        final ArrayList<ParameterDescription> parameterDescriptions = new ArrayList<ParameterDescription>();
        ParamHelper.walkDownParameters(parameters, new ParamHelper.ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(parameterDescriptions.size(), EnumSet.noneOf(ParameterFlag.class));
                ParameterDescription parameterDescription = new ParameterDescription();
                parameterDescription.setFullRepresentation("(");
                parameterDescriptions.add(parameterDescription);
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(parameterDescriptions.size(), EnumSet.noneOf(ParameterFlag.class));
                ParameterDescription parameterDescription = new ParameterDescription();
                parameterDescription.setFullRepresentation(last ? ")" : "), ");
                parameterDescriptions.add(parameterDescription);
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                this.visitNonPsiParameter(PyCallableParameterImpl.psi(param), first, last);
            }

            @Override
            public void visitSlashParameter(@NotNull PySlashParameter param, boolean first, boolean last) {
                if (param == null) {
                    1.$$$reportNull$$$0(0);
                }
                hintFlags.put(parameterDescriptions.size(), EnumSet.noneOf(ParameterFlag.class));
                currentParameterIndex[0] = currentParameterIndex[0] + 1;
                ParameterDescription parameterDescription = new ParameterDescription("/", "", last);
                parameterDescriptions.add(parameterDescription);
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                hintFlags.put(parameterDescriptions.size(), EnumSet.noneOf(ParameterFlag.class));
                currentParameterIndex[0] = currentParameterIndex[0] + 1;
                ParameterDescription parameterDescription = new ParameterDescription("*", "", last);
                parameterDescriptions.add(parameterDescription);
            }

            @Override
            public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
                String annotation;
                if (parameter == null) {
                    1.$$$reportNull$$$0(1);
                }
                indexToNamedParameter.put(currentParameterIndex[0], parameter);
                StringBuilder stringBuilder = new StringBuilder();
                ParameterDescription parameterDescription = new ParameterDescription(parameter.getName(), "", last);
                if (parameter.getParameter() instanceof PyNamedParameter && (annotation = ((PyNamedParameter)parameter.getParameter()).getAnnotationValue()) != null) {
                    String annotationText = ParamHelper.getNameInSignature(parameter) + ": " + annotation.replaceAll("\n", "").replaceAll("\\s+", " ");
                    parameterDescription.setAnnotation(last ? annotationText : annotationText + ", ");
                }
                stringBuilder.append(parameter.getPresentableText(true, context, type2 -> type2 == null || type2 instanceof PyStructuralType));
                if (!last) {
                    stringBuilder.append(", ");
                }
                int hintIndex = parameterDescriptions.size();
                parameterToHintIndex.put(parameter, hintIndex);
                hintFlags.put(hintIndex, EnumSet.noneOf(ParameterFlag.class));
                currentParameterIndex[0] = currentParameterIndex[0] + 1;
                parameterDescription.setFullRepresentation(stringBuilder.toString());
                parameterDescriptions.add(parameterDescription);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "param";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/codeInsight/parameterInfo/PyParameterInfoUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSlashParameter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNonPsiParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return parameterDescriptions;
    }

    public static void highlightParameter(@NotNull PyCallableParameter parameter, @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, @NotNull Map<Integer, EnumSet<ParameterFlag>> hintFlags, boolean mustHighlight) {
        if (parameter == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(5);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(6);
        }
        if (hintFlags == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(7);
        }
        Integer hintIndex = parameterToHintIndex.get(parameter);
        if (mustHighlight && hintIndex != null && hintFlags.containsKey(hintIndex)) {
            hintFlags.get(hintIndex).add(ParameterFlag.HIGHLIGHT);
        }
    }

    @NotNull
    public static List<PyCallableParameter> getFlattenedTupleParameterComponents(@NotNull PyTupleParameter parameter) {
        if (parameter == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(8);
        }
        ArrayList<PyCallableParameter> results = new ArrayList<PyCallableParameter>();
        for (PyParameter component2 : parameter.getContents()) {
            if (component2 instanceof PyNamedParameter) {
                results.add(PyCallableParameterImpl.psi(component2));
                continue;
            }
            if (!(component2 instanceof PyTupleParameter)) continue;
            results.addAll(PyParameterInfoUtils.getFlattenedTupleParameterComponents((PyTupleParameter)component2));
        }
        ArrayList<PyCallableParameter> arrayList = results;
        if (arrayList == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static int collectHighlights(@NotNull PyCallExpression.PyArgumentsMapping mapping, @NotNull List<PyCallableParameter> parameterList, @NotNull Map<PyCallableParameter, Integer> parameterHintToIndex, @NotNull Map<Integer, EnumSet<ParameterFlag>> hintFlags, @NotNull List<PyExpression> flatArgs, int currentParamOffset) {
        if (mapping == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(10);
        }
        if (parameterList == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(11);
        }
        if (parameterHintToIndex == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(12);
        }
        if (hintFlags == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(13);
        }
        if (flatArgs == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(14);
        }
        PyCallableType callableType = mapping.getCallableType();
        assert (callableType != null);
        int lastParamIndex = callableType.getImplicitOffset();
        Map<PyExpression, PyCallableParameter> mappedParameters = mapping.getMappedParameters();
        Map<PyExpression, PyCallableParameter> mappedTupleParameters = mapping.getMappedTupleParameters();
        for (PyExpression arg : flatArgs) {
            boolean mustHighlight = arg.getTextRange().contains(currentParamOffset);
            PyExpression seeker = arg;
            while (!(seeker instanceof PyArgumentList) && seeker instanceof PyExpression && !mappedParameters.containsKey(seeker)) {
                seeker = seeker.getParent();
            }
            if (seeker instanceof PyExpression) {
                Iterator<PyCallableParameter> parameter = mappedParameters.get(seeker);
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                if (parameter == null) continue;
                PyParameterInfoUtils.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                continue;
            }
            if (PyCallExpressionHelper.isVariadicPositionalArgument(arg)) {
                for (PyCallableParameter parameter : mapping.getParametersMappedToVariadicPositionalArguments()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoUtils.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            if (PyCallExpressionHelper.isVariadicKeywordArgument(arg)) {
                for (PyCallableParameter parameter : mapping.getParametersMappedToVariadicKeywordArguments()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoUtils.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            PyTupleParameter tupleParameter = Optional.ofNullable(mappedTupleParameters.get(arg)).map(PyCallableParameter::getParameter).map(psi -> PyUtil.as(psi, PyTupleParameter.class)).orElse(null);
            if (tupleParameter == null) continue;
            for (PyCallableParameter parameter : PyParameterInfoUtils.getFlattenedTupleParameterComponents(tupleParameter)) {
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                PyParameterInfoUtils.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
            }
        }
        return lastParamIndex;
    }

    public static void highlightNext(@NotNull PyCallableType callableType, @NotNull List<PyCallableParameter> parameterList, @NotNull Map<Integer, PyCallableParameter> indexToNamedParameter, @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, @NotNull Map<Integer, EnumSet<ParameterFlag>> hintFlags, boolean isArgsEmpty, int lastParamIndex) {
        if (callableType == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(15);
        }
        if (parameterList == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(16);
        }
        if (indexToNamedParameter == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(17);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(18);
        }
        if (hintFlags == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(19);
        }
        boolean canOfferNext = true;
        for (EnumSet<ParameterFlag> set : hintFlags.values()) {
            if (!set.contains(ParameterFlag.HIGHLIGHT)) continue;
            canOfferNext = false;
            break;
        }
        if (canOfferNext) {
            PyCallableParameter parameter;
            int highlightIndex = Integer.MAX_VALUE;
            if (isArgsEmpty) {
                highlightIndex = callableType.getImplicitOffset();
            } else if (lastParamIndex < parameterList.size() - 1) {
                highlightIndex = !indexToNamedParameter.containsKey(lastParamIndex) || indexToNamedParameter.get(lastParamIndex).isPositionalContainer() ? lastParamIndex : lastParamIndex + 1;
            } else if (lastParamIndex == parameterList.size() - 1 && ((parameter = indexToNamedParameter.get(lastParamIndex)).isPositionalContainer() || parameter.isKeywordContainer())) {
                highlightIndex = lastParamIndex;
            }
            if (indexToNamedParameter.containsKey(highlightIndex)) {
                hintFlags.get(parameterToHintIndex.get(indexToNamedParameter.get(highlightIndex))).add(ParameterFlag.HIGHLIGHT);
            }
        }
    }

    public static void highlightParameters(PyCallExpression callExpression, PyCallableType callableType, List<PyCallableParameter> parameters, PyCallExpression.PyArgumentsMapping mapping, Map<Integer, PyCallableParameter> indexToNamedParameter, Map<PyCallableParameter, Integer> parameterToHintIndex, Map<Integer, EnumSet<ParameterFlag>> hintFlags, int currentParamOffset) {
        for (int i = 0; i < callableType.getImplicitOffset(); ++i) {
            if (!indexToNamedParameter.containsKey(i)) continue;
            PyCallableParameter parameter = indexToNamedParameter.get(i);
            hintFlags.get(parameterToHintIndex.get(parameter)).add(ParameterFlag.DISABLE);
        }
        List<PyExpression> flattenedArguments = PyUtil.flattenedParensAndLists(callExpression.getArguments());
        int lastParamIndex = PyParameterInfoUtils.collectHighlights(mapping, parameters, parameterToHintIndex, hintFlags, flattenedArguments, currentParamOffset);
        PyParameterInfoUtils.highlightNext(callableType, parameters, indexToNamedParameter, parameterToHintIndex, hintFlags, flattenedArguments.isEmpty(), lastParamIndex);
    }

    public static int findCurrentParameter(@NotNull PyArgumentList argumentList, int allegedCursorOffset, PsiFile file) {
        if (argumentList == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(20);
        }
        CharSequence chars = file.getViewProvider().getContents();
        List<PyExpression> flattenedArguments = PyUtil.flattenedParensAndLists(argumentList.getArguments());
        int offset = -1;
        for (PyExpression argument : flattenedArguments) {
            TextRange range = argument.getTextRange();
            int left = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(range.getStartOffset() - 1), (String)" \t\r\n");
            int right = CharArrayUtil.shiftForwardCarefully((CharSequence)chars, (int)range.getEndOffset(), (String)" \t\r\n");
            if (argument.getParent() instanceof PyListLiteralExpression || argument.getParent() instanceof PyTupleExpression) {
                right = CharArrayUtil.shiftForward((CharSequence)chars, (int)range.getEndOffset(), (String)" \t\r\n])");
            }
            if (left > allegedCursorOffset || right < allegedCursorOffset) continue;
            offset = range.getStartOffset();
            break;
        }
        return offset;
    }

    @Nullable
    public static ParameterHints buildParameterHints(@NotNull Pair<PyCallExpression, PyCallableType> callAndCallee, int currentParamOffset) {
        if (callAndCallee == null) {
            PyParameterInfoUtils.$$$reportNull$$$0(21);
        }
        PyCallExpression callExpression = (PyCallExpression)callAndCallee.getFirst();
        PyPsiUtils.assertValid((PsiElement)callExpression);
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(callExpression.getProject(), callExpression.getContainingFile());
        PyCallableType callableType = (PyCallableType)callAndCallee.getSecond();
        List<PyCallableParameter> parameters = callableType.getParameters(typeEvalContext);
        if (parameters == null) {
            return null;
        }
        PyCallExpression.PyArgumentsMapping mapping = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)callExpression, callableType, typeEvalContext);
        if (mapping.getCallableType() == null) {
            return null;
        }
        HashMap<Integer, PyCallableParameter> indexToNamedParameter = new HashMap<Integer, PyCallableParameter>(parameters.size());
        HashMap<PyCallableParameter, Integer> parameterToHintIndex = new HashMap<PyCallableParameter, Integer>();
        HashMap<Integer, EnumSet<ParameterFlag>> hintFlags = new HashMap<Integer, EnumSet<ParameterFlag>>();
        List<ParameterDescription> hintsAndAnnotations = PyParameterInfoUtils.buildParameterListHint(parameters, indexToNamedParameter, parameterToHintIndex, hintFlags, typeEvalContext);
        PyParameterInfoUtils.highlightParameters(callExpression, callableType, parameters, mapping, indexToNamedParameter, parameterToHintIndex, hintFlags, currentParamOffset);
        return new ParameterHints(hintsAndAnnotations, hintFlags);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexToNamedParameter";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterToHintIndex";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintFlags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/parameterInfo/PyParameterInfoUtils";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterHintToIndex";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatArgs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callAndCallee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/parameterInfo/PyParameterInfoUtils";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlattenedTupleParameterComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterListHint";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightParameter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFlattenedTupleParameterComponents";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightNext";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentParameter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterHints";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static class CallInfo {
        private final PyCallExpression call;
        private final PyCallableType callee;
        private boolean isVisible;

        public CallInfo(PyCallExpression call, PyCallableType callee, boolean isVisible) {
            this.call = call;
            this.callee = callee;
            this.isVisible = isVisible;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public Pair<PyCallExpression, PyCallableType> getCallandCalleePair() {
            return new Pair((Object)this.call, (Object)this.callee);
        }
    }

    public static class ParameterDescription {
        private String name = "";
        private String annotation = "";
        private boolean isLast = false;
        private String fullRepresentation = "";

        public ParameterDescription() {
        }

        public ParameterDescription(String name2, String annotation, boolean isLast) {
            this.name = name2;
            this.annotation = annotation;
            this.isLast = isLast;
        }

        public void setFullRepresentation(String fullRepresentation) {
            this.fullRepresentation = fullRepresentation;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String getFullRepresentation(boolean showHints) {
            StringBuilder stringBuilder = new StringBuilder();
            if (showHints) {
                if (!this.fullRepresentation.isEmpty()) {
                    stringBuilder.append(this.fullRepresentation);
                    return stringBuilder.toString();
                }
                stringBuilder.append(this.name);
                if (!this.annotation.isEmpty()) {
                    stringBuilder.append(": ").append(this.annotation);
                }
            } else {
                stringBuilder.append(this.name);
            }
            if (!this.isLast) {
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }
}

