/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.clouds.impl.runtime.ui;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteServersServiceViewContributor
extends RemoteServersServiceViewContributor {
    private final ServiceViewDescriptor myContributorDescriptor = new DefaultRemoteServersServiceViewDescriptor();

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(0);
        }
        ServiceViewDescriptor serviceViewDescriptor = this.myContributorDescriptor;
        if (serviceViewDescriptor == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    public boolean accept(@NotNull RemoteServer server) {
        if (server == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(2);
        }
        return DefaultRemoteServersServiceViewContributor.isDefaultRemoteServer(server);
    }

    public void selectLog(@NotNull AbstractTreeNode deploymentNode, @NotNull String logName) {
        ServersTreeStructure.DeploymentNodeImpl node;
        if (deploymentNode == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (logName == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(4);
        }
        if ((node = (ServersTreeStructure.DeploymentNodeImpl)ObjectUtils.tryCast((Object)deploymentNode, ServersTreeStructure.DeploymentNodeImpl.class)) == null) {
            return;
        }
        ServerConnection connection = node.getConnection();
        if (connection == null) {
            return;
        }
        Project project = Objects.requireNonNull(node.getProject());
        DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(project, node.getDeployment());
        if (logManager == null) {
            return;
        }
        for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
            if (!logName.equals(loggingComponent.getPresentableName())) continue;
            ServersTreeStructure.DeploymentLogNode logNode = new ServersTreeStructure.DeploymentLogNode(project, loggingComponent, node);
            ServiceViewManager.getInstance((Project)project).select((Object)logNode, DefaultRemoteServersServiceViewContributor.class, true, true);
        }
    }

    @NotNull
    public RemoteServersServiceViewContributor.ActionGroups getActionGroups() {
        RemoteServersServiceViewContributor.ActionGroups actionGroups = RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS;
        if (actionGroups == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(5);
        }
        return actionGroups;
    }

    public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new ServersTreeStructure.DeploymentNodeImpl(serverNode.getProject(), connection, serverNode, deployment, (ServersTreeStructure.DeploymentNodeProducer)this);
    }

    private static boolean isDefaultRemoteServer(RemoteServer<?> server) {
        String toolWindowId = server.getConfiguration().getCustomToolWindowId();
        if (toolWindowId == null) {
            toolWindowId = server.getType().getCustomToolWindowId();
        }
        return toolWindowId == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/clouds/impl/runtime/ui/DefaultRemoteServersServiceViewContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/clouds/impl/runtime/ui/DefaultRemoteServersServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectLog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    private static class DefaultRemoteServersServiceViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewToolWindowDescriptor {
        DefaultRemoteServersServiceViewDescriptor() {
            super("Clouds", AllIcons.General.Balloon);
        }

        public ActionGroup getToolbarActions() {
            return DefaultRemoteServersServiceViewContributor.getToolbarActions((RemoteServersServiceViewContributor.ActionGroups)RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }

        public ActionGroup getPopupActions() {
            return DefaultRemoteServersServiceViewContributor.getPopupActions((RemoteServersServiceViewContributor.ActionGroups)RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            if (string == null) {
                DefaultRemoteServersServiceViewDescriptor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = AllIcons.Toolwindows.ToolWindowServices;
            if (icon == null) {
                DefaultRemoteServersServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String title;
            String string = title = this.getToolWindowId();
            if (string == null) {
                DefaultRemoteServersServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isExclusionAllowed() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/platform/clouds/impl/runtime/ui/DefaultRemoteServersServiceViewContributor$DefaultRemoteServersServiceViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

