/**
 * SECTION:favourite-details
 * @short_description: Favourite status for a contact.
 * 
 * <para>This allows user-defined favourite contacts to be specified. A contact is a favourite if the user has selected them as such; the semantics of &apos;favourite&apos; are left unspecified by folks. Typically, a user might select the contacts that they talk to most frequently as their favourite contacts in an instant messaging program, for example.</para>
 */
/**
 * folks_favourite_details_change_is_favourite:
 * @self: the <link linkend="FolksFavouriteDetails"><type>FolksFavouriteDetails</type></link> instance
 * @is_favourite: (in): &nbsp;.  <para><code>true</code> if the contact is a favourite; <code>false</code> otherwise </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change whether the contact is a user-defined favourite.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> directly, as this method gives error notification and will only return once the favouriteness has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the favouriteness failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-favourite-details-change-is-favourite-finish"><function>folks_favourite_details_change_is_favourite_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_favourite_details_change_is_favourite_finish:
 * @self: the <link linkend="FolksFavouriteDetails"><type>FolksFavouriteDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change whether the contact is a user-defined favourite.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> directly, as this method gives error notification and will only return once the favouriteness has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the favouriteness failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-favourite-details-change-is-favourite"><function>folks_favourite_details_change_is_favourite()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksFavouriteDetails:is-favourite:
 * 
 * Whether this contact is a user-defined favourite.
 */
/**
 * folks_favourite_details_get_is_favourite:
 * @self: the <link linkend="FolksFavouriteDetails"><type>FolksFavouriteDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> property.
 * 
 * Whether this contact is a user-defined favourite.
 * 
 * Returns: the value of the <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> property
 */
/**
 * folks_favourite_details_set_is_favourite:
 * @self: the <link linkend="FolksFavouriteDetails"><type>FolksFavouriteDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> property
 * 
 * Set the value of the <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> property to @value.
 * 
 * Whether this contact is a user-defined favourite.
 */
/**
 * FolksFavouriteDetails:
 * 
 * Favourite status for a contact.
 * 
 * <para>This allows user-defined favourite contacts to be specified. A contact is a favourite if the user has selected them as such; the semantics of &apos;favourite&apos; are left unspecified by folks. Typically, a user might select the contacts that they talk to most frequently as their favourite contacts in an instant messaging program, for example.</para>
 */
/**
 * FolksFavouriteDetailsIface:
 * @change_is_favourite: virtual method called by <link linkend="folks-favourite-details-change-is-favourite"><function>folks_favourite_details_change_is_favourite()</function></link>
 * @change_is_favourite_finish: asynchronous finish function for <structfield>change_is_favourite</structfield>, called by <link linkend="folks-favourite-details-change-is-favourite"><function>folks_favourite_details_change_is_favourite()</function></link>
 * @get_is_favourite: getter method for the abstract property <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link>
 * @set_is_favourite: setter method for the abstract property <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksFavouriteDetails"><type>FolksFavouriteDetails</type></link> implementations.
 */
