/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

public final class Interval {
    public static final Interval INFINITY_INTERVAL = new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final double low;
    private final double high;

    public Interval(Interval interval) {
        this.low = interval.low;
        this.high = interval.high;
    }

    public Interval(double low, double high) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        if (Double.isNaN(low) || Double.isNaN(high)) {
            throw new IllegalArgumentException("The interval endpoints must be different than NaN");
        }
        this.low = low;
        this.high = high;
    }

    public int compareTo(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        if (this.high < interval.low) {
            return -1;
        }
        if (interval.high < this.low) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Double timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("Timestamp cannot be null.");
        }
        if (timestamp < this.low) {
            return 1;
        }
        if (timestamp > this.high) {
            return -1;
        }
        return 0;
    }

    public double getLow() {
        return this.low;
    }

    public double getHigh() {
        return this.high;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Interval interval = (Interval)obj;
            if (this.low == interval.low && this.high == interval.high) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.low) ^ Double.doubleToLongBits(this.low) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.high) ^ Double.doubleToLongBits(this.high) >>> 32);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.low);
        sb.append(", ");
        sb.append(this.high);
        sb.append(']');
        return sb.toString();
    }
}

