/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.ot.table.Charstring;
import jogamp.graph.font.typecast.ot.table.CharstringType2;
import jogamp.graph.font.typecast.ot.table.GlyphDescription;
import jogamp.graph.font.typecast.t2.T2Interpreter;

public final class OTGlyph {
    private final short _leftSideBearing;
    private final int _advanceWidth;
    private Point[] _points;
    AABBox _bbox;

    public OTGlyph(GlyphDescription glyphDescription, short s, int n) {
        this._leftSideBearing = s;
        this._advanceWidth = n;
        this.describe(glyphDescription);
    }

    public OTGlyph(Charstring charstring, short s, int n) {
        this._leftSideBearing = s;
        this._advanceWidth = n;
        if (charstring instanceof CharstringType2) {
            T2Interpreter t2Interpreter = new T2Interpreter();
            this._points = t2Interpreter.execute((CharstringType2)charstring);
        }
    }

    public final void clearPointData() {
        this._points = null;
    }

    public final AABBox getBBox() {
        return this._bbox;
    }

    public final int getAdvanceWidth() {
        return this._advanceWidth;
    }

    public final short getLeftSideBearing() {
        return this._leftSideBearing;
    }

    public final Point getPoint(int n) {
        return this._points[n];
    }

    public final int getPointCount() {
        return null != this._points ? this._points.length : 0;
    }

    private final void describe(GlyphDescription glyphDescription) {
        int n = 0;
        this._points = new Point[glyphDescription.getPointCount()];
        for (int i = 0; i < glyphDescription.getPointCount(); ++i) {
            boolean bl;
            boolean bl2 = bl = glyphDescription.getEndPtOfContours(n) == i;
            if (bl) {
                ++n;
            }
            this._points[i] = new Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        this._bbox = new AABBox(glyphDescription.getXMinimum(), glyphDescription.getYMinimum(), 0.0f, glyphDescription.getXMaximum(), glyphDescription.getYMaximum(), 0.0f);
    }
}

