/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This class contains a stack of transforms and concatenates them by
composition.


The transforms are composed in reverse order with the back being applied first: $ T_0 o T_1 = T_0(T_1(x)) $ Transforms are stored in a queue, in the following order: $ T_0, T_1, ... , T_N-1 $

Transforms are added via AddTransform(). This adds the transforms to the back of the queue.

The only parameters of the transform at the back of the queue are
exposed and optimizable for registration.

Inverse: The inverse transform is created by retrieving the inverse
from each sub transform and adding them to a composite transform in
reverse order. The m_TransformsToOptimizeFlags is copied in reverse
for the inverse.


See:
 itk::CompositeTransform


C++ includes: sitkCompositeTransform.h
*/
public class CompositeTransform extends Transform {
  private transient long swigCPtr;

  protected CompositeTransform(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CompositeTransform_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CompositeTransform obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CompositeTransform obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::CompositeTransform::~CompositeTransform() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CompositeTransform(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CompositeTransform::CompositeTransform(unsigned int dimensions)

Construct an empty CompositeTransform.


The created CompositeTransform is initialized with zero transforms. Additional transforms of
dimensions can be added.

*/
public  CompositeTransform(long dimensions) {
    this(SimpleITKJNI.new_CompositeTransform__SWIG_0(dimensions), true);
  }

  /**
itk::simple::CompositeTransform::CompositeTransform(unsigned int dimensions)

Construct an empty CompositeTransform.


The created CompositeTransform is initialized with zero transforms. Additional transforms of
dimensions can be added.

*/
public  CompositeTransform(Transform arg0) {
    this(SimpleITKJNI.new_CompositeTransform__SWIG_1(Transform.getCPtr(arg0), arg0), true);
  }

  /**
itk::simple::CompositeTransform::CompositeTransform(unsigned int dimensions)

Construct an empty CompositeTransform.


The created CompositeTransform is initialized with zero transforms. Additional transforms of
dimensions can be added.

*/
public  CompositeTransform(CompositeTransform arg0) {
    this(SimpleITKJNI.new_CompositeTransform__SWIG_2(CompositeTransform.getCPtr(arg0), arg0), true);
  }

  /**
itk::simple::CompositeTransform::CompositeTransform(unsigned int dimensions)

Construct an empty CompositeTransform.


The created CompositeTransform is initialized with zero transforms. Additional transforms of
dimensions can be added.

*/
public  CompositeTransform(VectorOfTransform arg0) {
    this(SimpleITKJNI.new_CompositeTransform__SWIG_3(VectorOfTransform.getCPtr(arg0), arg0), true);
  }

  /**
std::string itk::simple::CompositeTransform::GetName() const override

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CompositeTransform_getName(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CompositeTransform::FlattenTransform()

Removes nested composite transforms.


If this transform contains additional composite transforms, then these
nested composite transformed are removed, while preserving the order
of the regular transforms and transferring ownership to the parent CompositeTransform.

Nested composite transform may not be written to a file.

*/
public  void flattenTransform() {
    SimpleITKJNI.CompositeTransform_flattenTransform(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CompositeTransform::AddTransform(Transform t)

Add a transform to the back of the stack.


A deep-copy of the transform is performed. The added transform will
have the optimizable parameters, while the other parameters are part
of the fixed parameters.

*/
public  void addTransform(Transform t) {
    SimpleITKJNI.CompositeTransform_addTransform(swigCPtr, this, Transform.getCPtr(t), t);
  }

  /**
unsigned int itk::simple::CompositeTransform::GetNumberOfTransforms() const

The number of transforms in the stack.

*/
public  long getNumberOfTransforms() {
    return SimpleITKJNI.CompositeTransform_getNumberOfTransforms(swigCPtr, this);
  }

  /**
void itk::simple::CompositeTransform::ClearTransforms()

Remove all transforms from the stack.

*/
public  void clearTransforms() {
    SimpleITKJNI.CompositeTransform_clearTransforms(swigCPtr, this);
  }

  /**
void itk::simple::CompositeTransform::RemoveTransform()

Remove the active transform at the back.


If the stack is empty an exception will be thrown.

*/
public  void removeTransform() {
    SimpleITKJNI.CompositeTransform_removeTransform(swigCPtr, this);
  }

  /**
Transform itk::simple::CompositeTransform::GetBackTransform()

Get a copy of the back transform.


If the stack is empty an exception will be thrown.

*/
public  Transform getBackTransform() {
    return new Transform(SimpleITKJNI.CompositeTransform_getBackTransform(swigCPtr, this), true);
  }

  /**
Transform itk::simple::CompositeTransform::GetNthTransform(unsigned int n)

Get a copy of a transform in the stack.


If n is equal or greater than the number of transforms, then an
exception will be thrown.

*/
public  Transform getNthTransform(long n) {
    return new Transform(SimpleITKJNI.CompositeTransform_getNthTransform(swigCPtr, this, n), true);
  }

}
