/*
 *  Stress test for case insensitive regexp normalization, canon bitmap
 *  block edges.
 */

/*@include util-regexp.js@*/

/*---
{
    "slow": true
}
---*/

/*===
1023 [\u03ff-\u03ff] F893 T1 F129 T1 F64512
1024 [\u03ff-\u0400] F893 T1 F129 T2 F79 T1 F64431
1025 [\u03ff-\u0401] F893 T1 F129 T3 F78 T2 F64430
1026 [\u03ff-\u0402] F893 T1 F129 T4 F77 T3 F64429
1027 [\u03ff-\u0403] F893 T1 F129 T5 F76 T4 F64428
1028 [\u03ff-\u0404] F893 T1 F129 T6 F75 T5 F64427
1029 [\u03ff-\u0405] F893 T1 F129 T7 F74 T6 F64426
1030 [\u03ff-\u0406] F893 T1 F129 T8 F73 T7 F64425
1031 [\u03ff-\u0407] F893 T1 F129 T9 F72 T8 F64424
1032 [\u03ff-\u0408] F893 T1 F129 T10 F71 T9 F64423
1033 [\u03ff-\u0409] F893 T1 F129 T11 F70 T10 F64422
1034 [\u03ff-\u040a] F893 T1 F129 T12 F69 T11 F64421
1035 [\u03ff-\u040b] F893 T1 F129 T13 F68 T12 F64420
1036 [\u03ff-\u040c] F893 T1 F129 T14 F67 T13 F64419
1037 [\u03ff-\u040d] F893 T1 F129 T15 F66 T14 F64418
1038 [\u03ff-\u040e] F893 T1 F129 T16 F65 T15 F64417
1039 [\u03ff-\u040f] F893 T1 F129 T17 F64 T16 F64416
1040 [\u03ff-\u0410] F893 T1 F129 T18 F31 T1 F31 T16 F64416
1041 [\u03ff-\u0411] F893 T1 F129 T19 F30 T2 F30 T16 F64416
1042 [\u03ff-\u0412] F893 T1 F129 T20 F29 T3 F29 T16 F6176 T1 F58239
1043 [\u03ff-\u0413] F893 T1 F129 T21 F28 T4 F28 T16 F6176 T1 F58239
1044 [\u03ff-\u0414] F893 T1 F129 T22 F27 T5 F27 T16 F6176 T2 F58238
1045 [\u03ff-\u0415] F893 T1 F129 T23 F26 T6 F26 T16 F6176 T2 F58238
1046 [\u03ff-\u0416] F893 T1 F129 T24 F25 T7 F25 T16 F6176 T2 F58238
1047 [\u03ff-\u0417] F893 T1 F129 T25 F24 T8 F24 T16 F6176 T2 F58238
1048 [\u03ff-\u0418] F893 T1 F129 T26 F23 T9 F23 T16 F6176 T2 F58238
1049 [\u03ff-\u0419] F893 T1 F129 T27 F22 T10 F22 T16 F6176 T2 F58238
1050 [\u03ff-\u041a] F893 T1 F129 T28 F21 T11 F21 T16 F6176 T2 F58238
1051 [\u03ff-\u041b] F893 T1 F129 T29 F20 T12 F20 T16 F6176 T2 F58238
1052 [\u03ff-\u041c] F893 T1 F129 T30 F19 T13 F19 T16 F6176 T2 F58238
1053 [\u03ff-\u041d] F893 T1 F129 T31 F18 T14 F18 T16 F6176 T2 F58238
1054 [\u03ff-\u041e] F893 T1 F129 T32 F17 T15 F17 T16 F6176 T3 F58237
1055 [\u03ff-\u041f] F893 T1 F129 T33 F16 T16 F16 T16 F6176 T3 F58237
1056 [\u03ff-\u0420] F893 T1 F129 T34 F15 T17 F15 T16 F6176 T3 F58237
1057 [\u03ff-\u0421] F893 T1 F129 T35 F14 T18 F14 T16 F6176 T4 F58236
1024 [\u0400-\u0400] F1024 T1 F79 T1 F64431
1025 [\u0400-\u0401] F1024 T2 F78 T2 F64430
1026 [\u0400-\u0402] F1024 T3 F77 T3 F64429
1027 [\u0400-\u0403] F1024 T4 F76 T4 F64428
1028 [\u0400-\u0404] F1024 T5 F75 T5 F64427
1029 [\u0400-\u0405] F1024 T6 F74 T6 F64426
1030 [\u0400-\u0406] F1024 T7 F73 T7 F64425
1031 [\u0400-\u0407] F1024 T8 F72 T8 F64424
1032 [\u0400-\u0408] F1024 T9 F71 T9 F64423
1033 [\u0400-\u0409] F1024 T10 F70 T10 F64422
1034 [\u0400-\u040a] F1024 T11 F69 T11 F64421
1035 [\u0400-\u040b] F1024 T12 F68 T12 F64420
1036 [\u0400-\u040c] F1024 T13 F67 T13 F64419
1037 [\u0400-\u040d] F1024 T14 F66 T14 F64418
1038 [\u0400-\u040e] F1024 T15 F65 T15 F64417
1039 [\u0400-\u040f] F1024 T16 F64 T16 F64416
1040 [\u0400-\u0410] F1024 T17 F31 T1 F31 T16 F64416
1041 [\u0400-\u0411] F1024 T18 F30 T2 F30 T16 F64416
1042 [\u0400-\u0412] F1024 T19 F29 T3 F29 T16 F6176 T1 F58239
1043 [\u0400-\u0413] F1024 T20 F28 T4 F28 T16 F6176 T1 F58239
1044 [\u0400-\u0414] F1024 T21 F27 T5 F27 T16 F6176 T2 F58238
1045 [\u0400-\u0415] F1024 T22 F26 T6 F26 T16 F6176 T2 F58238
1046 [\u0400-\u0416] F1024 T23 F25 T7 F25 T16 F6176 T2 F58238
1047 [\u0400-\u0417] F1024 T24 F24 T8 F24 T16 F6176 T2 F58238
1048 [\u0400-\u0418] F1024 T25 F23 T9 F23 T16 F6176 T2 F58238
1049 [\u0400-\u0419] F1024 T26 F22 T10 F22 T16 F6176 T2 F58238
1050 [\u0400-\u041a] F1024 T27 F21 T11 F21 T16 F6176 T2 F58238
1051 [\u0400-\u041b] F1024 T28 F20 T12 F20 T16 F6176 T2 F58238
1052 [\u0400-\u041c] F1024 T29 F19 T13 F19 T16 F6176 T2 F58238
1053 [\u0400-\u041d] F1024 T30 F18 T14 F18 T16 F6176 T2 F58238
1054 [\u0400-\u041e] F1024 T31 F17 T15 F17 T16 F6176 T3 F58237
1055 [\u0400-\u041f] F1024 T32 F16 T16 F16 T16 F6176 T3 F58237
1056 [\u0400-\u0420] F1024 T33 F15 T17 F15 T16 F6176 T3 F58237
1057 [\u0400-\u0421] F1024 T34 F14 T18 F14 T16 F6176 T4 F58236
1025 [\u0401-\u0401] F1025 T1 F79 T1 F64430
1026 [\u0401-\u0402] F1025 T2 F78 T2 F64429
1027 [\u0401-\u0403] F1025 T3 F77 T3 F64428
1028 [\u0401-\u0404] F1025 T4 F76 T4 F64427
1029 [\u0401-\u0405] F1025 T5 F75 T5 F64426
1030 [\u0401-\u0406] F1025 T6 F74 T6 F64425
1031 [\u0401-\u0407] F1025 T7 F73 T7 F64424
1032 [\u0401-\u0408] F1025 T8 F72 T8 F64423
1033 [\u0401-\u0409] F1025 T9 F71 T9 F64422
1034 [\u0401-\u040a] F1025 T10 F70 T10 F64421
1035 [\u0401-\u040b] F1025 T11 F69 T11 F64420
1036 [\u0401-\u040c] F1025 T12 F68 T12 F64419
1037 [\u0401-\u040d] F1025 T13 F67 T13 F64418
1038 [\u0401-\u040e] F1025 T14 F66 T14 F64417
1039 [\u0401-\u040f] F1025 T15 F65 T15 F64416
1040 [\u0401-\u0410] F1025 T16 F31 T1 F32 T15 F64416
1041 [\u0401-\u0411] F1025 T17 F30 T2 F31 T15 F64416
1042 [\u0401-\u0412] F1025 T18 F29 T3 F30 T15 F6176 T1 F58239
1043 [\u0401-\u0413] F1025 T19 F28 T4 F29 T15 F6176 T1 F58239
1044 [\u0401-\u0414] F1025 T20 F27 T5 F28 T15 F6176 T2 F58238
1045 [\u0401-\u0415] F1025 T21 F26 T6 F27 T15 F6176 T2 F58238
1046 [\u0401-\u0416] F1025 T22 F25 T7 F26 T15 F6176 T2 F58238
1047 [\u0401-\u0417] F1025 T23 F24 T8 F25 T15 F6176 T2 F58238
1048 [\u0401-\u0418] F1025 T24 F23 T9 F24 T15 F6176 T2 F58238
1049 [\u0401-\u0419] F1025 T25 F22 T10 F23 T15 F6176 T2 F58238
1050 [\u0401-\u041a] F1025 T26 F21 T11 F22 T15 F6176 T2 F58238
1051 [\u0401-\u041b] F1025 T27 F20 T12 F21 T15 F6176 T2 F58238
1052 [\u0401-\u041c] F1025 T28 F19 T13 F20 T15 F6176 T2 F58238
1053 [\u0401-\u041d] F1025 T29 F18 T14 F19 T15 F6176 T2 F58238
1054 [\u0401-\u041e] F1025 T30 F17 T15 F18 T15 F6176 T3 F58237
1055 [\u0401-\u041f] F1025 T31 F16 T16 F17 T15 F6176 T3 F58237
1056 [\u0401-\u0420] F1025 T32 F15 T17 F16 T15 F6176 T3 F58237
1057 [\u0401-\u0421] F1025 T33 F14 T18 F15 T15 F6176 T4 F58236
1055 [\u041f-\u041f] F1055 T1 F31 T1 F64448
1056 [\u041f-\u0420] F1055 T2 F30 T2 F64447
1057 [\u041f-\u0421] F1055 T3 F29 T3 F6209 T1 F58236
1058 [\u041f-\u0422] F1055 T4 F28 T4 F6208 T3 F58234
1059 [\u041f-\u0423] F1055 T5 F27 T5 F6207 T3 F58234
1060 [\u041f-\u0424] F1055 T6 F26 T6 F6206 T3 F58234
1056 [\u0420-\u0420] F1056 T1 F31 T1 F64447
1057 [\u0420-\u0421] F1056 T2 F30 T2 F6209 T1 F58236
1058 [\u0420-\u0422] F1056 T3 F29 T3 F6208 T3 F58234
1059 [\u0420-\u0423] F1056 T4 F28 T4 F6207 T3 F58234
1060 [\u0420-\u0424] F1056 T5 F27 T5 F6206 T3 F58234
1057 [\u0421-\u0421] F1057 T1 F31 T1 F6209 T1 F58236
1058 [\u0421-\u0422] F1057 T2 F30 T2 F6208 T3 F58234
1059 [\u0421-\u0423] F1057 T3 F29 T3 F6207 T3 F58234
1060 [\u0421-\u0424] F1057 T4 F28 T4 F6206 T3 F58234
1023 [\u03ff-\u041f] F893 T1 F129 T33 F16 T16 F16 T16 F6176 T3 F58237
1024 [\u0400-\u041f] F1024 T32 F16 T16 F16 T16 F6176 T3 F58237
1025 [\u0401-\u041f] F1025 T31 F16 T16 F17 T15 F6176 T3 F58237
1026 [\u0402-\u041f] F1026 T30 F16 T16 F18 T14 F6176 T3 F58237
1027 [\u0403-\u041f] F1027 T29 F16 T16 F19 T13 F6176 T3 F58237
1028 [\u0404-\u041f] F1028 T28 F16 T16 F20 T12 F6176 T3 F58237
1029 [\u0405-\u041f] F1029 T27 F16 T16 F21 T11 F6176 T3 F58237
1030 [\u0406-\u041f] F1030 T26 F16 T16 F22 T10 F6176 T3 F58237
1031 [\u0407-\u041f] F1031 T25 F16 T16 F23 T9 F6176 T3 F58237
1032 [\u0408-\u041f] F1032 T24 F16 T16 F24 T8 F6176 T3 F58237
1033 [\u0409-\u041f] F1033 T23 F16 T16 F25 T7 F6176 T3 F58237
1034 [\u040a-\u041f] F1034 T22 F16 T16 F26 T6 F6176 T3 F58237
1035 [\u040b-\u041f] F1035 T21 F16 T16 F27 T5 F6176 T3 F58237
1036 [\u040c-\u041f] F1036 T20 F16 T16 F28 T4 F6176 T3 F58237
1037 [\u040d-\u041f] F1037 T19 F16 T16 F29 T3 F6176 T3 F58237
1038 [\u040e-\u041f] F1038 T18 F16 T16 F30 T2 F6176 T3 F58237
1039 [\u040f-\u041f] F1039 T17 F16 T16 F31 T1 F6176 T3 F58237
1040 [\u0410-\u041f] F1040 T16 F16 T16 F6208 T3 F58237
1041 [\u0411-\u041f] F1041 T15 F17 T15 F6208 T3 F58237
1042 [\u0412-\u041f] F1042 T14 F18 T14 F6208 T3 F58237
1043 [\u0413-\u041f] F1043 T13 F19 T13 F6209 T2 F58237
1044 [\u0414-\u041f] F1044 T12 F20 T12 F6209 T2 F58237
1045 [\u0415-\u041f] F1045 T11 F21 T11 F6210 T1 F58237
1046 [\u0416-\u041f] F1046 T10 F22 T10 F6210 T1 F58237
1047 [\u0417-\u041f] F1047 T9 F23 T9 F6210 T1 F58237
1048 [\u0418-\u041f] F1048 T8 F24 T8 F6210 T1 F58237
1049 [\u0419-\u041f] F1049 T7 F25 T7 F6210 T1 F58237
1050 [\u041a-\u041f] F1050 T6 F26 T6 F6210 T1 F58237
1051 [\u041b-\u041f] F1051 T5 F27 T5 F6210 T1 F58237
1052 [\u041c-\u041f] F1052 T4 F28 T4 F6210 T1 F58237
1053 [\u041d-\u041f] F1053 T3 F29 T3 F6210 T1 F58237
1054 [\u041e-\u041f] F1054 T2 F30 T2 F6210 T1 F58237
1055 [\u041f-\u041f] F1055 T1 F31 T1 F64448
1023 [\u03ff-\u0420] F893 T1 F129 T34 F15 T17 F15 T16 F6176 T3 F58237
1024 [\u0400-\u0420] F1024 T33 F15 T17 F15 T16 F6176 T3 F58237
1025 [\u0401-\u0420] F1025 T32 F15 T17 F16 T15 F6176 T3 F58237
1026 [\u0402-\u0420] F1026 T31 F15 T17 F17 T14 F6176 T3 F58237
1027 [\u0403-\u0420] F1027 T30 F15 T17 F18 T13 F6176 T3 F58237
1028 [\u0404-\u0420] F1028 T29 F15 T17 F19 T12 F6176 T3 F58237
1029 [\u0405-\u0420] F1029 T28 F15 T17 F20 T11 F6176 T3 F58237
1030 [\u0406-\u0420] F1030 T27 F15 T17 F21 T10 F6176 T3 F58237
1031 [\u0407-\u0420] F1031 T26 F15 T17 F22 T9 F6176 T3 F58237
1032 [\u0408-\u0420] F1032 T25 F15 T17 F23 T8 F6176 T3 F58237
1033 [\u0409-\u0420] F1033 T24 F15 T17 F24 T7 F6176 T3 F58237
1034 [\u040a-\u0420] F1034 T23 F15 T17 F25 T6 F6176 T3 F58237
1035 [\u040b-\u0420] F1035 T22 F15 T17 F26 T5 F6176 T3 F58237
1036 [\u040c-\u0420] F1036 T21 F15 T17 F27 T4 F6176 T3 F58237
1037 [\u040d-\u0420] F1037 T20 F15 T17 F28 T3 F6176 T3 F58237
1038 [\u040e-\u0420] F1038 T19 F15 T17 F29 T2 F6176 T3 F58237
1039 [\u040f-\u0420] F1039 T18 F15 T17 F30 T1 F6176 T3 F58237
1040 [\u0410-\u0420] F1040 T17 F15 T17 F6207 T3 F58237
1041 [\u0411-\u0420] F1041 T16 F16 T16 F6207 T3 F58237
1042 [\u0412-\u0420] F1042 T15 F17 T15 F6207 T3 F58237
1043 [\u0413-\u0420] F1043 T14 F18 T14 F6208 T2 F58237
1044 [\u0414-\u0420] F1044 T13 F19 T13 F6208 T2 F58237
1045 [\u0415-\u0420] F1045 T12 F20 T12 F6209 T1 F58237
1046 [\u0416-\u0420] F1046 T11 F21 T11 F6209 T1 F58237
1047 [\u0417-\u0420] F1047 T10 F22 T10 F6209 T1 F58237
1048 [\u0418-\u0420] F1048 T9 F23 T9 F6209 T1 F58237
1049 [\u0419-\u0420] F1049 T8 F24 T8 F6209 T1 F58237
1050 [\u041a-\u0420] F1050 T7 F25 T7 F6209 T1 F58237
1051 [\u041b-\u0420] F1051 T6 F26 T6 F6209 T1 F58237
1052 [\u041c-\u0420] F1052 T5 F27 T5 F6209 T1 F58237
1053 [\u041d-\u0420] F1053 T4 F28 T4 F6209 T1 F58237
1054 [\u041e-\u0420] F1054 T3 F29 T3 F6209 T1 F58237
1055 [\u041f-\u0420] F1055 T2 F30 T2 F64447
1056 [\u0420-\u0420] F1056 T1 F31 T1 F64447
1023 [\u03ff-\u0421] F893 T1 F129 T35 F14 T18 F14 T16 F6176 T4 F58236
1024 [\u0400-\u0421] F1024 T34 F14 T18 F14 T16 F6176 T4 F58236
1025 [\u0401-\u0421] F1025 T33 F14 T18 F15 T15 F6176 T4 F58236
1026 [\u0402-\u0421] F1026 T32 F14 T18 F16 T14 F6176 T4 F58236
1027 [\u0403-\u0421] F1027 T31 F14 T18 F17 T13 F6176 T4 F58236
1028 [\u0404-\u0421] F1028 T30 F14 T18 F18 T12 F6176 T4 F58236
1029 [\u0405-\u0421] F1029 T29 F14 T18 F19 T11 F6176 T4 F58236
1030 [\u0406-\u0421] F1030 T28 F14 T18 F20 T10 F6176 T4 F58236
1031 [\u0407-\u0421] F1031 T27 F14 T18 F21 T9 F6176 T4 F58236
1032 [\u0408-\u0421] F1032 T26 F14 T18 F22 T8 F6176 T4 F58236
1033 [\u0409-\u0421] F1033 T25 F14 T18 F23 T7 F6176 T4 F58236
1034 [\u040a-\u0421] F1034 T24 F14 T18 F24 T6 F6176 T4 F58236
1035 [\u040b-\u0421] F1035 T23 F14 T18 F25 T5 F6176 T4 F58236
1036 [\u040c-\u0421] F1036 T22 F14 T18 F26 T4 F6176 T4 F58236
1037 [\u040d-\u0421] F1037 T21 F14 T18 F27 T3 F6176 T4 F58236
1038 [\u040e-\u0421] F1038 T20 F14 T18 F28 T2 F6176 T4 F58236
1039 [\u040f-\u0421] F1039 T19 F14 T18 F29 T1 F6176 T4 F58236
1040 [\u0410-\u0421] F1040 T18 F14 T18 F6206 T4 F58236
1041 [\u0411-\u0421] F1041 T17 F15 T17 F6206 T4 F58236
1042 [\u0412-\u0421] F1042 T16 F16 T16 F6206 T4 F58236
1043 [\u0413-\u0421] F1043 T15 F17 T15 F6207 T3 F58236
1044 [\u0414-\u0421] F1044 T14 F18 T14 F6207 T3 F58236
1045 [\u0415-\u0421] F1045 T13 F19 T13 F6208 T2 F58236
1046 [\u0416-\u0421] F1046 T12 F20 T12 F6208 T2 F58236
1047 [\u0417-\u0421] F1047 T11 F21 T11 F6208 T2 F58236
1048 [\u0418-\u0421] F1048 T10 F22 T10 F6208 T2 F58236
1049 [\u0419-\u0421] F1049 T9 F23 T9 F6208 T2 F58236
1050 [\u041a-\u0421] F1050 T8 F24 T8 F6208 T2 F58236
1051 [\u041b-\u0421] F1051 T7 F25 T7 F6208 T2 F58236
1052 [\u041c-\u0421] F1052 T6 F26 T6 F6208 T2 F58236
1053 [\u041d-\u0421] F1053 T5 F27 T5 F6208 T2 F58236
1054 [\u041e-\u0421] F1054 T4 F28 T4 F6208 T2 F58236
1055 [\u041f-\u0421] F1055 T3 F29 T3 F6209 T1 F58236
1056 [\u0420-\u0421] F1056 T2 F30 T2 F6209 T1 F58236
1057 [\u0421-\u0421] F1057 T1 F31 T1 F6209 T1 F58236
===*/

// 1024-1055 is continuous
// 1056-1097 is not

function test() {
    var re;
    var i;

    // Pin lower edge to interesting values, run upper edge.
    for (i = 1023; i <= 1057; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1023, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1024; i <= 1057; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1024, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1025; i <= 1057; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1025, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1055; i <= 1060; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1055, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1056; i <= 1060; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1056, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1057; i <= 1060; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(1057, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }

    // Pin upper edge, run lower edge.
    for (i = 1023; i <= 1055; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(i, 1055);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1023; i <= 1056; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(i, 1056);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
    for (i = 1023; i <= 1057; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(i, 1057);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }
}

try {
    test();
} catch (e) {
    print(e.stack || e);
}
