/* Constant multiply table for TILE-Gx.
   Copyright (C) 2011, 2012
   Free Software Foundation, Inc.
   Contributed by Walter Lee (walt@tilera.com)

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "expr.h"
#include "optabs.h"
#include "tilegx-multiply.h"

const enum insn_code tilegx_multiply_insn_seq_decode_opcode[] = {
  CODE_FOR_nothing /* must be first */ ,
  CODE_FOR_adddi3,
  CODE_FOR_subdi3,
  CODE_FOR_insn_shl1add,
  CODE_FOR_insn_shl2add,
  CODE_FOR_insn_shl3add,
  CODE_FOR_ashldi3
};

const struct tilegx_multiply_insn_seq tilegx_multiply_insn_seq_table[] = {
  {-9223372036854775807ll - 1 /* 0x8000000000000000 */ ,
   {{6, 1, 63}}			/* shli r2, r1, 63 */
   },
  {-9223372036854775807ll /* 0x8000000000000001 */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {-9223372036854775806ll /* 0x8000000000000002 */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {-9223372036854775805ll /* 0x8000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775804ll /* 0x8000000000000004 */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {-9223372036854775803ll /* 0x8000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775802ll /* 0x8000000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-9223372036854775801ll /* 0x8000000000000007 */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {-9223372036854775800ll /* 0x8000000000000008 */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {-9223372036854775799ll /* 0x8000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775798ll /* 0x800000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-9223372036854775792ll /* 0x8000000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775776ll /* 0x8000000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775744ll /* 0x8000000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775680ll /* 0x8000000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775552ll /* 0x8000000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854775296ll /* 0x8000000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854774784ll /* 0x8000000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854773760ll /* 0x8000000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854771712ll /* 0x8000000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854767616ll /* 0x8000000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854759424ll /* 0x8000000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854743040ll /* 0x8000000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854710272ll /* 0x8000000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854644736ll /* 0x8000000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854513664ll /* 0x8000000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036854251520ll /* 0x8000000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036853727232ll /* 0x8000000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036852678656ll /* 0x8000000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036850581504ll /* 0x8000000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036846387200ll /* 0x8000000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036837998592ll /* 0x8000000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036821221376ll /* 0x8000000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036787666944ll /* 0x8000000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036720558080ll /* 0x8000000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036586340352ll /* 0x8000000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372036317904896ll /* 0x8000000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372035781033984ll /* 0x8000000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372034707292160ll /* 0x8000000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372032559808512ll /* 0x8000000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372028264841216ll /* 0x8000000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372019674906624ll /* 0x8000000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223372002495037440ll /* 0x8000000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223371968135299072ll /* 0x8000001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223371899415822336ll /* 0x8000002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223371761976868864ll /* 0x8000004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223371487098961920ll /* 0x8000008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223370937343148032ll /* 0x8000010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223369837831520256ll /* 0x8000020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223367638808264704ll /* 0x8000040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223363240761753600ll /* 0x8000080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223354444668731392ll /* 0x8000100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223336852482686976ll /* 0x8000200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223301668110598144ll /* 0x8000400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223231299366420480ll /* 0x8000800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9223090561878065152ll /* 0x8001000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9222809086901354496ll /* 0x8002000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9222246136947933184ll /* 0x8004000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9221120237041090560ll /* 0x8008000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9218868437227405312ll /* 0x8010000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9214364837600034816ll /* 0x8020000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9205357638345293824ll /* 0x8040000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9187343239835811840ll /* 0x8080000000000000 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9151314442816847872ll /* 0x8100000000000000 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-9079256848778919936ll /* 0x8200000000000000 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-8935141660703064064ll /* 0x8400000000000000 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-8646911284551352320ll /* 0x8800000000000000 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-8070450532247928832ll /* 0x9000000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 60}}			/* shli r3, r2, 60 */
   },
  {-6917529027641081857ll /* 0x9fffffffffffffff */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 61},			/* shli r3, r2, 61 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {-6917529027641081856ll /* 0xa000000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 61}}			/* shli r3, r2, 61 */
   },
  {-4611686018427387912ll /* 0xbffffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 62},			/* shli r3, r2, 62 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4611686018427387911ll /* 0xbffffffffffffff9 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4611686018427387908ll /* 0xbffffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 62},			/* shli r3, r2, 62 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4611686018427387907ll /* 0xbffffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 62},			/* shli r3, r2, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {-4611686018427387906ll /* 0xbffffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 62},			/* shli r3, r2, 62 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4611686018427387905ll /* 0xbfffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387904ll /* 0xc000000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 62}}			/* shli r3, r2, 62 */
   },
  {-4611686018427387903ll /* 0xc000000000000001 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4611686018427387902ll /* 0xc000000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387901ll /* 0xc000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387900ll /* 0xc000000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387899ll /* 0xc000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387898ll /* 0xc000000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 62},			/* shli r3, r2, 62 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4611686018427387896ll /* 0xc000000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4611686018427387895ll /* 0xc000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3458764513820540929ll /* 0xcfffffffffffffff */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693960ll /* 0xdffffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 61},			/* shli r3, r2, 61 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2305843009213693959ll /* 0xdffffffffffffff9 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2305843009213693956ll /* 0xdffffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 61},			/* shli r3, r2, 61 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2305843009213693955ll /* 0xdffffffffffffffd */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2305843009213693954ll /* 0xdffffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 61},			/* shli r3, r2, 61 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2305843009213693953ll /* 0xdfffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693952ll /* 0xe000000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 61}}			/* shli r3, r2, 61 */
   },
  {-2305843009213693951ll /* 0xe000000000000001 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2305843009213693950ll /* 0xe000000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693949ll /* 0xe000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693948ll /* 0xe000000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693947ll /* 0xe000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693944ll /* 0xe000000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2305843009213693943ll /* 0xe000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1729382256910270465ll /* 0xe7ffffffffffffff */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846984ll /* 0xeffffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 60},			/* shli r3, r2, 60 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1152921504606846983ll /* 0xeffffffffffffff9 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1152921504606846980ll /* 0xeffffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 60},			/* shli r3, r2, 60 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1152921504606846979ll /* 0xeffffffffffffffd */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1152921504606846978ll /* 0xeffffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 60},			/* shli r3, r2, 60 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1152921504606846977ll /* 0xefffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846976ll /* 0xf000000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 60}}			/* shli r3, r2, 60 */
   },
  {-1152921504606846975ll /* 0xf000000000000001 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1152921504606846974ll /* 0xf000000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846973ll /* 0xf000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846972ll /* 0xf000000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846971ll /* 0xf000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846968ll /* 0xf000000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1152921504606846967ll /* 0xf000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-864691128455135233ll /* 0xf3ffffffffffffff */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423496ll /* 0xf7fffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 59},			/* shli r3, r2, 59 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-576460752303423495ll /* 0xf7fffffffffffff9 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-576460752303423492ll /* 0xf7fffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 59},			/* shli r3, r2, 59 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-576460752303423491ll /* 0xf7fffffffffffffd */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-576460752303423490ll /* 0xf7fffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 59},			/* shli r3, r2, 59 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-576460752303423489ll /* 0xf7ffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423488ll /* 0xf800000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 59}}			/* shli r3, r2, 59 */
   },
  {-576460752303423487ll /* 0xf800000000000001 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-576460752303423486ll /* 0xf800000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423485ll /* 0xf800000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423484ll /* 0xf800000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423483ll /* 0xf800000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423480ll /* 0xf800000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-576460752303423479ll /* 0xf800000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-432345564227567617ll /* 0xf9ffffffffffffff */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711752ll /* 0xfbfffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 58},			/* shli r3, r2, 58 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-288230376151711751ll /* 0xfbfffffffffffff9 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-288230376151711748ll /* 0xfbfffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 58},			/* shli r3, r2, 58 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-288230376151711747ll /* 0xfbfffffffffffffd */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-288230376151711746ll /* 0xfbfffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 58},			/* shli r3, r2, 58 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-288230376151711745ll /* 0xfbffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711744ll /* 0xfc00000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 58}}			/* shli r3, r2, 58 */
   },
  {-288230376151711743ll /* 0xfc00000000000001 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-288230376151711742ll /* 0xfc00000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711741ll /* 0xfc00000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711740ll /* 0xfc00000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711739ll /* 0xfc00000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711736ll /* 0xfc00000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-288230376151711735ll /* 0xfc00000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-216172782113783809ll /* 0xfcffffffffffffff */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855880ll /* 0xfdfffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 57},			/* shli r3, r2, 57 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-144115188075855879ll /* 0xfdfffffffffffff9 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-144115188075855876ll /* 0xfdfffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 57},			/* shli r3, r2, 57 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-144115188075855875ll /* 0xfdfffffffffffffd */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-144115188075855874ll /* 0xfdfffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 57},			/* shli r3, r2, 57 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-144115188075855873ll /* 0xfdffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855872ll /* 0xfe00000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 57}}			/* shli r3, r2, 57 */
   },
  {-144115188075855871ll /* 0xfe00000000000001 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-144115188075855870ll /* 0xfe00000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855869ll /* 0xfe00000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855868ll /* 0xfe00000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855867ll /* 0xfe00000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855864ll /* 0xfe00000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-144115188075855863ll /* 0xfe00000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-108086391056891905ll /* 0xfe7fffffffffffff */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927944ll /* 0xfefffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 56},			/* shli r3, r2, 56 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-72057594037927943ll /* 0xfefffffffffffff9 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-72057594037927940ll /* 0xfefffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 56},			/* shli r3, r2, 56 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-72057594037927939ll /* 0xfefffffffffffffd */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-72057594037927938ll /* 0xfefffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 56},			/* shli r3, r2, 56 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-72057594037927937ll /* 0xfeffffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927936ll /* 0xff00000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 56}}			/* shli r3, r2, 56 */
   },
  {-72057594037927935ll /* 0xff00000000000001 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-72057594037927934ll /* 0xff00000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927933ll /* 0xff00000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927932ll /* 0xff00000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927931ll /* 0xff00000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927928ll /* 0xff00000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-72057594037927927ll /* 0xff00000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-54043195528445953ll /* 0xff3fffffffffffff */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963976ll /* 0xff7ffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 55},			/* shli r3, r2, 55 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-36028797018963975ll /* 0xff7ffffffffffff9 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-36028797018963972ll /* 0xff7ffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 55},			/* shli r3, r2, 55 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-36028797018963971ll /* 0xff7ffffffffffffd */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-36028797018963970ll /* 0xff7ffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 55},			/* shli r3, r2, 55 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-36028797018963969ll /* 0xff7fffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963968ll /* 0xff80000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 55}}			/* shli r3, r2, 55 */
   },
  {-36028797018963967ll /* 0xff80000000000001 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-36028797018963966ll /* 0xff80000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963965ll /* 0xff80000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963964ll /* 0xff80000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963963ll /* 0xff80000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963960ll /* 0xff80000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-36028797018963959ll /* 0xff80000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-27021597764222977ll /* 0xff9fffffffffffff */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481992ll /* 0xffbffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 54},			/* shli r3, r2, 54 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-18014398509481991ll /* 0xffbffffffffffff9 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-18014398509481988ll /* 0xffbffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 54},			/* shli r3, r2, 54 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-18014398509481987ll /* 0xffbffffffffffffd */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-18014398509481986ll /* 0xffbffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 54},			/* shli r3, r2, 54 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-18014398509481985ll /* 0xffbfffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481984ll /* 0xffc0000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 54}}			/* shli r3, r2, 54 */
   },
  {-18014398509481983ll /* 0xffc0000000000001 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-18014398509481982ll /* 0xffc0000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481981ll /* 0xffc0000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481980ll /* 0xffc0000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481979ll /* 0xffc0000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481976ll /* 0xffc0000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-18014398509481975ll /* 0xffc0000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-13510798882111489ll /* 0xffcfffffffffffff */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254741000ll /* 0xffdffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 53},			/* shli r3, r2, 53 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-9007199254740999ll /* 0xffdffffffffffff9 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-9007199254740996ll /* 0xffdffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 53},			/* shli r3, r2, 53 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-9007199254740995ll /* 0xffdffffffffffffd */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-9007199254740994ll /* 0xffdffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 53},			/* shli r3, r2, 53 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-9007199254740993ll /* 0xffdfffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740992ll /* 0xffe0000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 53}}			/* shli r3, r2, 53 */
   },
  {-9007199254740991ll /* 0xffe0000000000001 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-9007199254740990ll /* 0xffe0000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740989ll /* 0xffe0000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740988ll /* 0xffe0000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740987ll /* 0xffe0000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740984ll /* 0xffe0000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9007199254740983ll /* 0xffe0000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-6755399441055745ll /* 0xffe7ffffffffffff */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370504ll /* 0xffeffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 52},			/* shli r3, r2, 52 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4503599627370503ll /* 0xffeffffffffffff9 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4503599627370500ll /* 0xffeffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 52},			/* shli r3, r2, 52 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4503599627370499ll /* 0xffeffffffffffffd */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4503599627370498ll /* 0xffeffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 52},			/* shli r3, r2, 52 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4503599627370497ll /* 0xffefffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370496ll /* 0xfff0000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 52}}			/* shli r3, r2, 52 */
   },
  {-4503599627370495ll /* 0xfff0000000000001 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4503599627370494ll /* 0xfff0000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370493ll /* 0xfff0000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370492ll /* 0xfff0000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370491ll /* 0xfff0000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370488ll /* 0xfff0000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4503599627370487ll /* 0xfff0000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3377699720527873ll /* 0xfff3ffffffffffff */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685256ll /* 0xfff7fffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 51},			/* shli r3, r2, 51 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2251799813685255ll /* 0xfff7fffffffffff9 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2251799813685252ll /* 0xfff7fffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 51},			/* shli r3, r2, 51 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2251799813685251ll /* 0xfff7fffffffffffd */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2251799813685250ll /* 0xfff7fffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 51},			/* shli r3, r2, 51 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2251799813685249ll /* 0xfff7ffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685248ll /* 0xfff8000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 51}}			/* shli r3, r2, 51 */
   },
  {-2251799813685247ll /* 0xfff8000000000001 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2251799813685246ll /* 0xfff8000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685245ll /* 0xfff8000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685244ll /* 0xfff8000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685243ll /* 0xfff8000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685240ll /* 0xfff8000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2251799813685239ll /* 0xfff8000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1688849860263937ll /* 0xfff9ffffffffffff */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842632ll /* 0xfffbfffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 50},			/* shli r3, r2, 50 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1125899906842631ll /* 0xfffbfffffffffff9 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1125899906842628ll /* 0xfffbfffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 50},			/* shli r3, r2, 50 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1125899906842627ll /* 0xfffbfffffffffffd */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1125899906842626ll /* 0xfffbfffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 50},			/* shli r3, r2, 50 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1125899906842625ll /* 0xfffbffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842624ll /* 0xfffc000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 50}}			/* shli r3, r2, 50 */
   },
  {-1125899906842623ll /* 0xfffc000000000001 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1125899906842622ll /* 0xfffc000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842621ll /* 0xfffc000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842620ll /* 0xfffc000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842619ll /* 0xfffc000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842616ll /* 0xfffc000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1125899906842615ll /* 0xfffc000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-844424930131969ll /* 0xfffcffffffffffff */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421320ll /* 0xfffdfffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 49},			/* shli r3, r2, 49 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-562949953421319ll /* 0xfffdfffffffffff9 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-562949953421316ll /* 0xfffdfffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 49},			/* shli r3, r2, 49 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-562949953421315ll /* 0xfffdfffffffffffd */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-562949953421314ll /* 0xfffdfffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 49},			/* shli r3, r2, 49 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-562949953421313ll /* 0xfffdffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421312ll /* 0xfffe000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 49}}			/* shli r3, r2, 49 */
   },
  {-562949953421311ll /* 0xfffe000000000001 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-562949953421310ll /* 0xfffe000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421309ll /* 0xfffe000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421308ll /* 0xfffe000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421307ll /* 0xfffe000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421304ll /* 0xfffe000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-562949953421303ll /* 0xfffe000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-422212465065985ll /* 0xfffe7fffffffffff */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710664ll /* 0xfffefffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 48},			/* shli r3, r2, 48 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-281474976710663ll /* 0xfffefffffffffff9 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-281474976710660ll /* 0xfffefffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 48},			/* shli r3, r2, 48 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-281474976710659ll /* 0xfffefffffffffffd */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-281474976710658ll /* 0xfffefffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 48},			/* shli r3, r2, 48 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-281474976710657ll /* 0xfffeffffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710656ll /* 0xffff000000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 48}}			/* shli r3, r2, 48 */
   },
  {-281474976710655ll /* 0xffff000000000001 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-281474976710654ll /* 0xffff000000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710653ll /* 0xffff000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710652ll /* 0xffff000000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710651ll /* 0xffff000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710648ll /* 0xffff000000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-281474976710647ll /* 0xffff000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-211106232532993ll /* 0xffff3fffffffffff */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355336ll /* 0xffff7ffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 47},			/* shli r3, r2, 47 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-140737488355335ll /* 0xffff7ffffffffff9 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-140737488355332ll /* 0xffff7ffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 47},			/* shli r3, r2, 47 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-140737488355331ll /* 0xffff7ffffffffffd */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-140737488355330ll /* 0xffff7ffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 47},			/* shli r3, r2, 47 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-140737488355329ll /* 0xffff7fffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355328ll /* 0xffff800000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 47}}			/* shli r3, r2, 47 */
   },
  {-140737488355327ll /* 0xffff800000000001 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-140737488355326ll /* 0xffff800000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355325ll /* 0xffff800000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355324ll /* 0xffff800000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355323ll /* 0xffff800000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355320ll /* 0xffff800000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-140737488355319ll /* 0xffff800000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-105553116266497ll /* 0xffff9fffffffffff */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177672ll /* 0xffffbffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 46},			/* shli r3, r2, 46 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-70368744177671ll /* 0xffffbffffffffff9 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-70368744177668ll /* 0xffffbffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 46},			/* shli r3, r2, 46 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-70368744177667ll /* 0xffffbffffffffffd */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-70368744177666ll /* 0xffffbffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 46},			/* shli r3, r2, 46 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-70368744177665ll /* 0xffffbfffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177664ll /* 0xffffc00000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 46}}			/* shli r3, r2, 46 */
   },
  {-70368744177663ll /* 0xffffc00000000001 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-70368744177662ll /* 0xffffc00000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177661ll /* 0xffffc00000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177660ll /* 0xffffc00000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177659ll /* 0xffffc00000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177656ll /* 0xffffc00000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-70368744177655ll /* 0xffffc00000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-52776558133249ll /* 0xffffcfffffffffff */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088840ll /* 0xffffdffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 45},			/* shli r3, r2, 45 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-35184372088839ll /* 0xffffdffffffffff9 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-35184372088836ll /* 0xffffdffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 45},			/* shli r3, r2, 45 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-35184372088835ll /* 0xffffdffffffffffd */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-35184372088834ll /* 0xffffdffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 45},			/* shli r3, r2, 45 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-35184372088833ll /* 0xffffdfffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088832ll /* 0xffffe00000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 45}}			/* shli r3, r2, 45 */
   },
  {-35184372088831ll /* 0xffffe00000000001 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-35184372088830ll /* 0xffffe00000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088829ll /* 0xffffe00000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088828ll /* 0xffffe00000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088827ll /* 0xffffe00000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088824ll /* 0xffffe00000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-35184372088823ll /* 0xffffe00000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-26388279066625ll /* 0xffffe7ffffffffff */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044424ll /* 0xffffeffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 44},			/* shli r3, r2, 44 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-17592186044423ll /* 0xffffeffffffffff9 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-17592186044420ll /* 0xffffeffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 44},			/* shli r3, r2, 44 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-17592186044419ll /* 0xffffeffffffffffd */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-17592186044418ll /* 0xffffeffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 44},			/* shli r3, r2, 44 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-17592186044417ll /* 0xffffefffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044416ll /* 0xfffff00000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 44}}			/* shli r3, r2, 44 */
   },
  {-17592186044415ll /* 0xfffff00000000001 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-17592186044414ll /* 0xfffff00000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044413ll /* 0xfffff00000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044412ll /* 0xfffff00000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044411ll /* 0xfffff00000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044408ll /* 0xfffff00000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17592186044407ll /* 0xfffff00000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-13194139533313ll /* 0xfffff3ffffffffff */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022216ll /* 0xfffff7fffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 43},			/* shli r3, r2, 43 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-8796093022215ll /* 0xfffff7fffffffff9 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8796093022212ll /* 0xfffff7fffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 43},			/* shli r3, r2, 43 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-8796093022211ll /* 0xfffff7fffffffffd */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8796093022210ll /* 0xfffff7fffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 43},			/* shli r3, r2, 43 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-8796093022209ll /* 0xfffff7ffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022208ll /* 0xfffff80000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 43}}			/* shli r3, r2, 43 */
   },
  {-8796093022207ll /* 0xfffff80000000001 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8796093022206ll /* 0xfffff80000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022205ll /* 0xfffff80000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022204ll /* 0xfffff80000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022203ll /* 0xfffff80000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022200ll /* 0xfffff80000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8796093022199ll /* 0xfffff80000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-6597069766657ll /* 0xfffff9ffffffffff */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511112ll /* 0xfffffbfffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 42},			/* shli r3, r2, 42 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4398046511111ll /* 0xfffffbfffffffff9 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4398046511108ll /* 0xfffffbfffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 42},			/* shli r3, r2, 42 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4398046511107ll /* 0xfffffbfffffffffd */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4398046511106ll /* 0xfffffbfffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 42},			/* shli r3, r2, 42 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4398046511105ll /* 0xfffffbffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511104ll /* 0xfffffc0000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 42}}			/* shli r3, r2, 42 */
   },
  {-4398046511103ll /* 0xfffffc0000000001 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4398046511102ll /* 0xfffffc0000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511101ll /* 0xfffffc0000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511100ll /* 0xfffffc0000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511099ll /* 0xfffffc0000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511096ll /* 0xfffffc0000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4398046511095ll /* 0xfffffc0000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3298534883329ll /* 0xfffffcffffffffff */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255560ll /* 0xfffffdfffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 41},			/* shli r3, r2, 41 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2199023255559ll /* 0xfffffdfffffffff9 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2199023255556ll /* 0xfffffdfffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 41},			/* shli r3, r2, 41 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2199023255555ll /* 0xfffffdfffffffffd */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2199023255554ll /* 0xfffffdfffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 41},			/* shli r3, r2, 41 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2199023255553ll /* 0xfffffdffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255552ll /* 0xfffffe0000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 41}}			/* shli r3, r2, 41 */
   },
  {-2199023255551ll /* 0xfffffe0000000001 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2199023255550ll /* 0xfffffe0000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255549ll /* 0xfffffe0000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255548ll /* 0xfffffe0000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255547ll /* 0xfffffe0000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255544ll /* 0xfffffe0000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2199023255543ll /* 0xfffffe0000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1649267441665ll /* 0xfffffe7fffffffff */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627784ll /* 0xfffffefffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 40},			/* shli r3, r2, 40 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1099511627783ll /* 0xfffffefffffffff9 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1099511627780ll /* 0xfffffefffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 40},			/* shli r3, r2, 40 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1099511627779ll /* 0xfffffefffffffffd */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1099511627778ll /* 0xfffffefffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 40},			/* shli r3, r2, 40 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1099511627777ll /* 0xfffffeffffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627776ll /* 0xffffff0000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 40}}			/* shli r3, r2, 40 */
   },
  {-1099511627775ll /* 0xffffff0000000001 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1099511627774ll /* 0xffffff0000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627773ll /* 0xffffff0000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627772ll /* 0xffffff0000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627771ll /* 0xffffff0000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627768ll /* 0xffffff0000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1099511627767ll /* 0xffffff0000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-824633720833ll /* 0xffffff3fffffffff */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813896ll /* 0xffffff7ffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 39},			/* shli r3, r2, 39 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-549755813895ll /* 0xffffff7ffffffff9 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-549755813892ll /* 0xffffff7ffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 39},			/* shli r3, r2, 39 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-549755813891ll /* 0xffffff7ffffffffd */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-549755813890ll /* 0xffffff7ffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 39},			/* shli r3, r2, 39 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-549755813889ll /* 0xffffff7fffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813888ll /* 0xffffff8000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 39}}			/* shli r3, r2, 39 */
   },
  {-549755813887ll /* 0xffffff8000000001 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-549755813886ll /* 0xffffff8000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813885ll /* 0xffffff8000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813884ll /* 0xffffff8000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813883ll /* 0xffffff8000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813880ll /* 0xffffff8000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-549755813879ll /* 0xffffff8000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-412316860417ll /* 0xffffff9fffffffff */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906952ll /* 0xffffffbffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 38},			/* shli r3, r2, 38 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-274877906951ll /* 0xffffffbffffffff9 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-274877906948ll /* 0xffffffbffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 38},			/* shli r3, r2, 38 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-274877906947ll /* 0xffffffbffffffffd */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-274877906946ll /* 0xffffffbffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 38},			/* shli r3, r2, 38 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-274877906945ll /* 0xffffffbfffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906944ll /* 0xffffffc000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 38}}			/* shli r3, r2, 38 */
   },
  {-274877906943ll /* 0xffffffc000000001 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-274877906942ll /* 0xffffffc000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906941ll /* 0xffffffc000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906940ll /* 0xffffffc000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906939ll /* 0xffffffc000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906936ll /* 0xffffffc000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-274877906935ll /* 0xffffffc000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-206158430209ll /* 0xffffffcfffffffff */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953480ll /* 0xffffffdffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 37},			/* shli r3, r2, 37 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-137438953479ll /* 0xffffffdffffffff9 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-137438953476ll /* 0xffffffdffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 37},			/* shli r3, r2, 37 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-137438953475ll /* 0xffffffdffffffffd */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-137438953474ll /* 0xffffffdffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 37},			/* shli r3, r2, 37 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-137438953473ll /* 0xffffffdfffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953472ll /* 0xffffffe000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 37}}			/* shli r3, r2, 37 */
   },
  {-137438953471ll /* 0xffffffe000000001 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-137438953470ll /* 0xffffffe000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953469ll /* 0xffffffe000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953468ll /* 0xffffffe000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953467ll /* 0xffffffe000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953464ll /* 0xffffffe000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-137438953463ll /* 0xffffffe000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-103079215105ll /* 0xffffffe7ffffffff */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476744ll /* 0xffffffeffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 36},			/* shli r3, r2, 36 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-68719476743ll /* 0xffffffeffffffff9 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-68719476740ll /* 0xffffffeffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 36},			/* shli r3, r2, 36 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-68719476739ll /* 0xffffffeffffffffd */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-68719476738ll /* 0xffffffeffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 36},			/* shli r3, r2, 36 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-68719476737ll /* 0xffffffefffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476736ll /* 0xfffffff000000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 36}}			/* shli r3, r2, 36 */
   },
  {-68719476735ll /* 0xfffffff000000001 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-68719476734ll /* 0xfffffff000000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476733ll /* 0xfffffff000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476732ll /* 0xfffffff000000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476731ll /* 0xfffffff000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476728ll /* 0xfffffff000000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-68719476727ll /* 0xfffffff000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-51539607553ll /* 0xfffffff3ffffffff */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738376ll /* 0xfffffff7fffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 35},			/* shli r3, r2, 35 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-34359738375ll /* 0xfffffff7fffffff9 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-34359738372ll /* 0xfffffff7fffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 35},			/* shli r3, r2, 35 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-34359738371ll /* 0xfffffff7fffffffd */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-34359738370ll /* 0xfffffff7fffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 35},			/* shli r3, r2, 35 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-34359738369ll /* 0xfffffff7ffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738368ll /* 0xfffffff800000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 35}}			/* shli r3, r2, 35 */
   },
  {-34359738367ll /* 0xfffffff800000001 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-34359738366ll /* 0xfffffff800000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738365ll /* 0xfffffff800000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738364ll /* 0xfffffff800000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738363ll /* 0xfffffff800000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738360ll /* 0xfffffff800000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34359738359ll /* 0xfffffff800000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-25769803777ll /* 0xfffffff9ffffffff */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869192ll /* 0xfffffffbfffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 34},			/* shli r3, r2, 34 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-17179869191ll /* 0xfffffffbfffffff9 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-17179869188ll /* 0xfffffffbfffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 34},			/* shli r3, r2, 34 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-17179869187ll /* 0xfffffffbfffffffd */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-17179869186ll /* 0xfffffffbfffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 34},			/* shli r3, r2, 34 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-17179869185ll /* 0xfffffffbffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869184ll /* 0xfffffffc00000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 34}}			/* shli r3, r2, 34 */
   },
  {-17179869183ll /* 0xfffffffc00000001 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-17179869182ll /* 0xfffffffc00000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869181ll /* 0xfffffffc00000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869180ll /* 0xfffffffc00000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869179ll /* 0xfffffffc00000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869176ll /* 0xfffffffc00000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-17179869175ll /* 0xfffffffc00000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-12884901889ll /* 0xfffffffcffffffff */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934600ll /* 0xfffffffdfffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 33},			/* shli r3, r2, 33 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-8589934599ll /* 0xfffffffdfffffff9 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8589934596ll /* 0xfffffffdfffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 33},			/* shli r3, r2, 33 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-8589934595ll /* 0xfffffffdfffffffd */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8589934594ll /* 0xfffffffdfffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 33},			/* shli r3, r2, 33 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-8589934593ll /* 0xfffffffdffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934592ll /* 0xfffffffe00000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 33}}			/* shli r3, r2, 33 */
   },
  {-8589934591ll /* 0xfffffffe00000001 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8589934590ll /* 0xfffffffe00000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934589ll /* 0xfffffffe00000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934588ll /* 0xfffffffe00000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934587ll /* 0xfffffffe00000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934584ll /* 0xfffffffe00000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8589934583ll /* 0xfffffffe00000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-6442450945ll /* 0xfffffffe7fffffff */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967304ll /* 0xfffffffefffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 32},			/* shli r3, r2, 32 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4294967303ll /* 0xfffffffefffffff9 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4294967300ll /* 0xfffffffefffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 32},			/* shli r3, r2, 32 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4294967299ll /* 0xfffffffefffffffd */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4294967298ll /* 0xfffffffefffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 32},			/* shli r3, r2, 32 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4294967297ll /* 0xfffffffeffffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967296ll /* 0xffffffff00000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 32}}			/* shli r3, r2, 32 */
   },
  {-4294967295ll /* 0xffffffff00000001 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4294967294ll /* 0xffffffff00000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967293ll /* 0xffffffff00000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967292ll /* 0xffffffff00000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967291ll /* 0xffffffff00000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967288ll /* 0xffffffff00000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4294967287ll /* 0xffffffff00000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3221225473ll /* 0xffffffff3fffffff */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483656ll /* 0xffffffff7ffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 31},			/* shli r3, r2, 31 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2147483655ll /* 0xffffffff7ffffff9 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2147483652ll /* 0xffffffff7ffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 31},			/* shli r3, r2, 31 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2147483651ll /* 0xffffffff7ffffffd */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2147483650ll /* 0xffffffff7ffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 31},			/* shli r3, r2, 31 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2147483649ll /* 0xffffffff7fffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483648ll /* 0xffffffff80000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 31}}			/* shli r3, r2, 31 */
   },
  {-2147483647ll /* 0xffffffff80000001 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2147483646ll /* 0xffffffff80000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483645ll /* 0xffffffff80000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483644ll /* 0xffffffff80000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483643ll /* 0xffffffff80000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483640ll /* 0xffffffff80000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2147483639ll /* 0xffffffff80000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1610612737ll /* 0xffffffff9fffffff */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741832ll /* 0xffffffffbffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1073741831ll /* 0xffffffffbffffff9 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1073741828ll /* 0xffffffffbffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1073741827ll /* 0xffffffffbffffffd */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1073741826ll /* 0xffffffffbffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1073741825ll /* 0xffffffffbfffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741824ll /* 0xffffffffc0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30}}			/* shli r3, r2, 30 */
   },
  {-1073741823ll /* 0xffffffffc0000001 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1073741822ll /* 0xffffffffc0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741821ll /* 0xffffffffc0000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741820ll /* 0xffffffffc0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741819ll /* 0xffffffffc0000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741816ll /* 0xffffffffc0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741815ll /* 0xffffffffc0000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-805306369ll /* 0xffffffffcfffffff */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870920ll /* 0xffffffffdffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-536870919ll /* 0xffffffffdffffff9 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-536870916ll /* 0xffffffffdffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-536870915ll /* 0xffffffffdffffffd */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-536870914ll /* 0xffffffffdffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-536870913ll /* 0xffffffffdfffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870912ll /* 0xffffffffe0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {-536870911ll /* 0xffffffffe0000001 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-536870910ll /* 0xffffffffe0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870909ll /* 0xffffffffe0000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870908ll /* 0xffffffffe0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870907ll /* 0xffffffffe0000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870904ll /* 0xffffffffe0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870903ll /* 0xffffffffe0000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-402653185ll /* 0xffffffffe7ffffff */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435464ll /* 0xffffffffeffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-268435463ll /* 0xffffffffeffffff9 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-268435460ll /* 0xffffffffeffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-268435459ll /* 0xffffffffeffffffd */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-268435458ll /* 0xffffffffeffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-268435457ll /* 0xffffffffefffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435456ll /* 0xfffffffff0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {-268435455ll /* 0xfffffffff0000001 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-268435454ll /* 0xfffffffff0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435453ll /* 0xfffffffff0000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435452ll /* 0xfffffffff0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435451ll /* 0xfffffffff0000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435448ll /* 0xfffffffff0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435447ll /* 0xfffffffff0000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-201326593ll /* 0xfffffffff3ffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217736ll /* 0xfffffffff7fffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-134217735ll /* 0xfffffffff7fffff9 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-134217732ll /* 0xfffffffff7fffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-134217731ll /* 0xfffffffff7fffffd */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-134217730ll /* 0xfffffffff7fffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-134217729ll /* 0xfffffffff7ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217728ll /* 0xfffffffff8000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {-134217727ll /* 0xfffffffff8000001 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-134217726ll /* 0xfffffffff8000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217725ll /* 0xfffffffff8000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217724ll /* 0xfffffffff8000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217723ll /* 0xfffffffff8000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217720ll /* 0xfffffffff8000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217719ll /* 0xfffffffff8000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-100663297ll /* 0xfffffffff9ffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108872ll /* 0xfffffffffbfffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-67108871ll /* 0xfffffffffbfffff9 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-67108868ll /* 0xfffffffffbfffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-67108867ll /* 0xfffffffffbfffffd */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-67108866ll /* 0xfffffffffbfffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-67108865ll /* 0xfffffffffbffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108864ll /* 0xfffffffffc000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {-67108863ll /* 0xfffffffffc000001 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-67108862ll /* 0xfffffffffc000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108861ll /* 0xfffffffffc000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108860ll /* 0xfffffffffc000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108859ll /* 0xfffffffffc000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108856ll /* 0xfffffffffc000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108855ll /* 0xfffffffffc000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-50331649ll /* 0xfffffffffcffffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554440ll /* 0xfffffffffdfffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-33554439ll /* 0xfffffffffdfffff9 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-33554436ll /* 0xfffffffffdfffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-33554435ll /* 0xfffffffffdfffffd */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-33554434ll /* 0xfffffffffdfffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-33554433ll /* 0xfffffffffdffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554432ll /* 0xfffffffffe000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {-33554431ll /* 0xfffffffffe000001 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-33554430ll /* 0xfffffffffe000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554429ll /* 0xfffffffffe000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554428ll /* 0xfffffffffe000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554427ll /* 0xfffffffffe000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554424ll /* 0xfffffffffe000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554423ll /* 0xfffffffffe000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-25165825ll /* 0xfffffffffe7fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777224ll /* 0xfffffffffefffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-16777223ll /* 0xfffffffffefffff9 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16777220ll /* 0xfffffffffefffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-16777219ll /* 0xfffffffffefffffd */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16777218ll /* 0xfffffffffefffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-16777217ll /* 0xfffffffffeffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777216ll /* 0xffffffffff000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {-16777215ll /* 0xffffffffff000001 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-16777214ll /* 0xffffffffff000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777213ll /* 0xffffffffff000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777212ll /* 0xffffffffff000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777211ll /* 0xffffffffff000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777208ll /* 0xffffffffff000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777207ll /* 0xffffffffff000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-12582913ll /* 0xffffffffff3fffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388616ll /* 0xffffffffff7ffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-8388615ll /* 0xffffffffff7ffff9 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8388612ll /* 0xffffffffff7ffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-8388611ll /* 0xffffffffff7ffffd */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8388610ll /* 0xffffffffff7ffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-8388609ll /* 0xffffffffff7fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388608ll /* 0xffffffffff800000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {-8388607ll /* 0xffffffffff800001 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8388606ll /* 0xffffffffff800002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388605ll /* 0xffffffffff800003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388604ll /* 0xffffffffff800004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388603ll /* 0xffffffffff800005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388600ll /* 0xffffffffff800008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388599ll /* 0xffffffffff800009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-6291457ll /* 0xffffffffff9fffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194312ll /* 0xffffffffffbffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4194311ll /* 0xffffffffffbffff9 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4194308ll /* 0xffffffffffbffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4194307ll /* 0xffffffffffbffffd */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4194306ll /* 0xffffffffffbffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4194305ll /* 0xffffffffffbfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194304ll /* 0xffffffffffc00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {-4194303ll /* 0xffffffffffc00001 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4194302ll /* 0xffffffffffc00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194301ll /* 0xffffffffffc00003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194300ll /* 0xffffffffffc00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194299ll /* 0xffffffffffc00005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194296ll /* 0xffffffffffc00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194295ll /* 0xffffffffffc00009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3145729ll /* 0xffffffffffcfffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097160ll /* 0xffffffffffdffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2097159ll /* 0xffffffffffdffff9 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2097156ll /* 0xffffffffffdffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2097155ll /* 0xffffffffffdffffd */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2097154ll /* 0xffffffffffdffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2097153ll /* 0xffffffffffdfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097152ll /* 0xffffffffffe00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {-2097151ll /* 0xffffffffffe00001 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2097150ll /* 0xffffffffffe00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097149ll /* 0xffffffffffe00003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097148ll /* 0xffffffffffe00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097147ll /* 0xffffffffffe00005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097144ll /* 0xffffffffffe00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097143ll /* 0xffffffffffe00009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1572865ll /* 0xffffffffffe7ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048584ll /* 0xffffffffffeffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1048583ll /* 0xffffffffffeffff9 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1048580ll /* 0xffffffffffeffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1048579ll /* 0xffffffffffeffffd */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1048578ll /* 0xffffffffffeffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1048577ll /* 0xffffffffffefffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048576ll /* 0xfffffffffff00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {-1048575ll /* 0xfffffffffff00001 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1048574ll /* 0xfffffffffff00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048573ll /* 0xfffffffffff00003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048572ll /* 0xfffffffffff00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048571ll /* 0xfffffffffff00005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048568ll /* 0xfffffffffff00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048567ll /* 0xfffffffffff00009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-786433ll /* 0xfffffffffff3ffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524296ll /* 0xfffffffffff7fff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-524295ll /* 0xfffffffffff7fff9 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-524292ll /* 0xfffffffffff7fffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-524291ll /* 0xfffffffffff7fffd */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-524290ll /* 0xfffffffffff7fffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-524289ll /* 0xfffffffffff7ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524288ll /* 0xfffffffffff80000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {-524287ll /* 0xfffffffffff80001 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-524286ll /* 0xfffffffffff80002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524285ll /* 0xfffffffffff80003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524284ll /* 0xfffffffffff80004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524283ll /* 0xfffffffffff80005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524280ll /* 0xfffffffffff80008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524279ll /* 0xfffffffffff80009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-393217ll /* 0xfffffffffff9ffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262152ll /* 0xfffffffffffbfff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-262151ll /* 0xfffffffffffbfff9 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262148ll /* 0xfffffffffffbfffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-262147ll /* 0xfffffffffffbfffd */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262146ll /* 0xfffffffffffbfffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-262145ll /* 0xfffffffffffbffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262144ll /* 0xfffffffffffc0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {-262143ll /* 0xfffffffffffc0001 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-262142ll /* 0xfffffffffffc0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262141ll /* 0xfffffffffffc0003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262140ll /* 0xfffffffffffc0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262139ll /* 0xfffffffffffc0005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262136ll /* 0xfffffffffffc0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262135ll /* 0xfffffffffffc0009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-196609ll /* 0xfffffffffffcffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131080ll /* 0xfffffffffffdfff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-131079ll /* 0xfffffffffffdfff9 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-131076ll /* 0xfffffffffffdfffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-131075ll /* 0xfffffffffffdfffd */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-131074ll /* 0xfffffffffffdfffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-131073ll /* 0xfffffffffffdffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131072ll /* 0xfffffffffffe0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {-131071ll /* 0xfffffffffffe0001 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-131070ll /* 0xfffffffffffe0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131069ll /* 0xfffffffffffe0003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131068ll /* 0xfffffffffffe0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131067ll /* 0xfffffffffffe0005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131064ll /* 0xfffffffffffe0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131063ll /* 0xfffffffffffe0009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-98305ll /* 0xfffffffffffe7fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65544ll /* 0xfffffffffffefff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-65543ll /* 0xfffffffffffefff9 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-65540ll /* 0xfffffffffffefffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-65539ll /* 0xfffffffffffefffd */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-65538ll /* 0xfffffffffffefffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-65537ll /* 0xfffffffffffeffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65536ll /* 0xffffffffffff0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {-65535ll /* 0xffffffffffff0001 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-65534ll /* 0xffffffffffff0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65533ll /* 0xffffffffffff0003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65532ll /* 0xffffffffffff0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65531ll /* 0xffffffffffff0005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65528ll /* 0xffffffffffff0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65527ll /* 0xffffffffffff0009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-49153ll /* 0xffffffffffff3fff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32776ll /* 0xffffffffffff7ff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-32775ll /* 0xffffffffffff7ff9 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-32772ll /* 0xffffffffffff7ffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-32771ll /* 0xffffffffffff7ffd */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-32770ll /* 0xffffffffffff7ffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-32769ll /* 0xffffffffffff7fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32768ll /* 0xffffffffffff8000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {-32767ll /* 0xffffffffffff8001 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-32766ll /* 0xffffffffffff8002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32765ll /* 0xffffffffffff8003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32764ll /* 0xffffffffffff8004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32763ll /* 0xffffffffffff8005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32760ll /* 0xffffffffffff8008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32759ll /* 0xffffffffffff8009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-24577ll /* 0xffffffffffff9fff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16392ll /* 0xffffffffffffbff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-16391ll /* 0xffffffffffffbff9 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16388ll /* 0xffffffffffffbffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-16387ll /* 0xffffffffffffbffd */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16386ll /* 0xffffffffffffbffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-16385ll /* 0xffffffffffffbfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16384ll /* 0xffffffffffffc000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {-16383ll /* 0xffffffffffffc001 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-16382ll /* 0xffffffffffffc002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16381ll /* 0xffffffffffffc003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16380ll /* 0xffffffffffffc004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16379ll /* 0xffffffffffffc005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16376ll /* 0xffffffffffffc008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16375ll /* 0xffffffffffffc009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-12289ll /* 0xffffffffffffcfff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8200ll /* 0xffffffffffffdff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-8199ll /* 0xffffffffffffdff9 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8196ll /* 0xffffffffffffdffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-8195ll /* 0xffffffffffffdffd */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8194ll /* 0xffffffffffffdffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-8193ll /* 0xffffffffffffdfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8192ll /* 0xffffffffffffe000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {-8191ll /* 0xffffffffffffe001 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8190ll /* 0xffffffffffffe002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8189ll /* 0xffffffffffffe003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8188ll /* 0xffffffffffffe004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8187ll /* 0xffffffffffffe005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8184ll /* 0xffffffffffffe008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8183ll /* 0xffffffffffffe009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-6145ll /* 0xffffffffffffe7ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4104ll /* 0xffffffffffffeff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-4103ll /* 0xffffffffffffeff9 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4100ll /* 0xffffffffffffeffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-4099ll /* 0xffffffffffffeffd */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4098ll /* 0xffffffffffffeffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-4097ll /* 0xffffffffffffefff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4096ll /* 0xfffffffffffff000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {-4095ll /* 0xfffffffffffff001 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4094ll /* 0xfffffffffffff002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4093ll /* 0xfffffffffffff003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4092ll /* 0xfffffffffffff004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4091ll /* 0xfffffffffffff005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4088ll /* 0xfffffffffffff008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4087ll /* 0xfffffffffffff009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3073ll /* 0xfffffffffffff3ff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3072ll /* 0xfffffffffffff400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2056ll /* 0xfffffffffffff7f8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-2055ll /* 0xfffffffffffff7f9 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2052ll /* 0xfffffffffffff7fc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-2051ll /* 0xfffffffffffff7fd */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2050ll /* 0xfffffffffffff7fe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-2049ll /* 0xfffffffffffff7ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2048ll /* 0xfffffffffffff800 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {-2047ll /* 0xfffffffffffff801 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2046ll /* 0xfffffffffffff802 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2045ll /* 0xfffffffffffff803 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2044ll /* 0xfffffffffffff804 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2043ll /* 0xfffffffffffff805 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2040ll /* 0xfffffffffffff808 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2039ll /* 0xfffffffffffff809 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1537ll /* 0xfffffffffffff9ff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1032ll /* 0xfffffffffffffbf8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-1031ll /* 0xfffffffffffffbf9 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1028ll /* 0xfffffffffffffbfc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-1027ll /* 0xfffffffffffffbfd */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1026ll /* 0xfffffffffffffbfe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-1025ll /* 0xfffffffffffffbff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1024ll /* 0xfffffffffffffc00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {-1023ll /* 0xfffffffffffffc01 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1022ll /* 0xfffffffffffffc02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1021ll /* 0xfffffffffffffc03 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1020ll /* 0xfffffffffffffc04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1019ll /* 0xfffffffffffffc05 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1018ll /* 0xfffffffffffffc06 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-1017ll /* 0xfffffffffffffc07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1016ll /* 0xfffffffffffffc08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1015ll /* 0xfffffffffffffc09 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1014ll /* 0xfffffffffffffc0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-1013ll /* 0xfffffffffffffc0b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-1012ll /* 0xfffffffffffffc0c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-1011ll /* 0xfffffffffffffc0d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-1010ll /* 0xfffffffffffffc0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1009ll /* 0xfffffffffffffc0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1008ll /* 0xfffffffffffffc10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1007ll /* 0xfffffffffffffc11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1006ll /* 0xfffffffffffffc12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-1005ll /* 0xfffffffffffffc13 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* shl1add r5, r4, r1 */
   },
  {-1004ll /* 0xfffffffffffffc14 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-1003ll /* 0xfffffffffffffc15 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-1001ll /* 0xfffffffffffffc17 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1000ll /* 0xfffffffffffffc18 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-999ll /* 0xfffffffffffffc19 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-997ll /* 0xfffffffffffffc1b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-996ll /* 0xfffffffffffffc1c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 1, 3},			/* shl2add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-994ll /* 0xfffffffffffffc1e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-993ll /* 0xfffffffffffffc1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-992ll /* 0xfffffffffffffc20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-991ll /* 0xfffffffffffffc21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-990ll /* 0xfffffffffffffc22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-988ll /* 0xfffffffffffffc24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-987ll /* 0xfffffffffffffc25 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-984ll /* 0xfffffffffffffc28 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-983ll /* 0xfffffffffffffc29 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-979ll /* 0xfffffffffffffc2d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-976ll /* 0xfffffffffffffc30 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-975ll /* 0xfffffffffffffc31 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-969ll /* 0xfffffffffffffc37 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-968ll /* 0xfffffffffffffc38 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 1, 3},			/* shl3add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-967ll /* 0xfffffffffffffc39 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-965ll /* 0xfffffffffffffc3b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-964ll /* 0xfffffffffffffc3c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 1, 3},			/* shl2add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-963ll /* 0xfffffffffffffc3d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 1},			/* shl1add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-962ll /* 0xfffffffffffffc3e */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-961ll /* 0xfffffffffffffc3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-960ll /* 0xfffffffffffffc40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-959ll /* 0xfffffffffffffc41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-958ll /* 0xfffffffffffffc42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-957ll /* 0xfffffffffffffc43 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-956ll /* 0xfffffffffffffc44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-955ll /* 0xfffffffffffffc45 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-953ll /* 0xfffffffffffffc47 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-952ll /* 0xfffffffffffffc48 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-951ll /* 0xfffffffffffffc49 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-945ll /* 0xfffffffffffffc4f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {-944ll /* 0xfffffffffffffc50 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-943ll /* 0xfffffffffffffc51 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-942ll /* 0xfffffffffffffc52 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {-940ll /* 0xfffffffffffffc54 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-936ll /* 0xfffffffffffffc58 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-935ll /* 0xfffffffffffffc59 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-929ll /* 0xfffffffffffffc5f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-928ll /* 0xfffffffffffffc60 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-925ll /* 0xfffffffffffffc63 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-924ll /* 0xfffffffffffffc64 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-920ll /* 0xfffffffffffffc68 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-919ll /* 0xfffffffffffffc69 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-916ll /* 0xfffffffffffffc6c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-913ll /* 0xfffffffffffffc6f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-912ll /* 0xfffffffffffffc70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-911ll /* 0xfffffffffffffc71 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-910ll /* 0xfffffffffffffc72 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-905ll /* 0xfffffffffffffc77 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-904ll /* 0xfffffffffffffc78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-903ll /* 0xfffffffffffffc79 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-902ll /* 0xfffffffffffffc7a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-901ll /* 0xfffffffffffffc7b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-900ll /* 0xfffffffffffffc7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-899ll /* 0xfffffffffffffc7d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-898ll /* 0xfffffffffffffc7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-897ll /* 0xfffffffffffffc7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-896ll /* 0xfffffffffffffc80 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-895ll /* 0xfffffffffffffc81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-894ll /* 0xfffffffffffffc82 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-893ll /* 0xfffffffffffffc83 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-892ll /* 0xfffffffffffffc84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-891ll /* 0xfffffffffffffc85 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-890ll /* 0xfffffffffffffc86 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-889ll /* 0xfffffffffffffc87 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-888ll /* 0xfffffffffffffc88 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-887ll /* 0xfffffffffffffc89 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-886ll /* 0xfffffffffffffc8a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-884ll /* 0xfffffffffffffc8c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-881ll /* 0xfffffffffffffc8f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-880ll /* 0xfffffffffffffc90 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-879ll /* 0xfffffffffffffc91 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 1}}			/* shl1add r5, r4, r1 */
   },
  {-873ll /* 0xfffffffffffffc97 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-872ll /* 0xfffffffffffffc98 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-868ll /* 0xfffffffffffffc9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-865ll /* 0xfffffffffffffc9f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-864ll /* 0xfffffffffffffca0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-863ll /* 0xfffffffffffffca1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-861ll /* 0xfffffffffffffca3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-860ll /* 0xfffffffffffffca4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-856ll /* 0xfffffffffffffca8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-855ll /* 0xfffffffffffffca9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-847ll /* 0xfffffffffffffcb1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-837ll /* 0xfffffffffffffcbb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-835ll /* 0xfffffffffffffcbd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-834ll /* 0xfffffffffffffcbe */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {-832ll /* 0xfffffffffffffcc0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {-831ll /* 0xfffffffffffffcc1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-829ll /* 0xfffffffffffffcc3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-828ll /* 0xfffffffffffffcc4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-827ll /* 0xfffffffffffffcc5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-824ll /* 0xfffffffffffffcc8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-823ll /* 0xfffffffffffffcc9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-819ll /* 0xfffffffffffffccd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-816ll /* 0xfffffffffffffcd0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-815ll /* 0xfffffffffffffcd1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-803ll /* 0xfffffffffffffcdd */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-801ll /* 0xfffffffffffffcdf */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-800ll /* 0xfffffffffffffce0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-799ll /* 0xfffffffffffffce1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-797ll /* 0xfffffffffffffce3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-796ll /* 0xfffffffffffffce4 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-795ll /* 0xfffffffffffffce5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-793ll /* 0xfffffffffffffce7 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-792ll /* 0xfffffffffffffce8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-791ll /* 0xfffffffffffffce9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-789ll /* 0xfffffffffffffceb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-788ll /* 0xfffffffffffffcec */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-785ll /* 0xfffffffffffffcef */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-784ll /* 0xfffffffffffffcf0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-783ll /* 0xfffffffffffffcf1 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-781ll /* 0xfffffffffffffcf3 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-780ll /* 0xfffffffffffffcf4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-779ll /* 0xfffffffffffffcf5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-777ll /* 0xfffffffffffffcf7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-776ll /* 0xfffffffffffffcf8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-775ll /* 0xfffffffffffffcf9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-774ll /* 0xfffffffffffffcfa */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-773ll /* 0xfffffffffffffcfb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-772ll /* 0xfffffffffffffcfc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-771ll /* 0xfffffffffffffcfd */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* shl1add r5, r4, r4 */
   },
  {-770ll /* 0xfffffffffffffcfe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-769ll /* 0xfffffffffffffcff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-768ll /* 0xfffffffffffffd00 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-767ll /* 0xfffffffffffffd01 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-766ll /* 0xfffffffffffffd02 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-765ll /* 0xfffffffffffffd03 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-764ll /* 0xfffffffffffffd04 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-763ll /* 0xfffffffffffffd05 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-762ll /* 0xfffffffffffffd06 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-761ll /* 0xfffffffffffffd07 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-760ll /* 0xfffffffffffffd08 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-759ll /* 0xfffffffffffffd09 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-757ll /* 0xfffffffffffffd0b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-756ll /* 0xfffffffffffffd0c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-755ll /* 0xfffffffffffffd0d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-753ll /* 0xfffffffffffffd0f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-752ll /* 0xfffffffffffffd10 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-751ll /* 0xfffffffffffffd11 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-749ll /* 0xfffffffffffffd13 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 1, 3},			/* shl3add r4, r1, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-748ll /* 0xfffffffffffffd14 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-744ll /* 0xfffffffffffffd18 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-743ll /* 0xfffffffffffffd19 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-741ll /* 0xfffffffffffffd1b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-739ll /* 0xfffffffffffffd1d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-737ll /* 0xfffffffffffffd1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-736ll /* 0xfffffffffffffd20 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-735ll /* 0xfffffffffffffd21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-732ll /* 0xfffffffffffffd24 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-729ll /* 0xfffffffffffffd27 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-728ll /* 0xfffffffffffffd28 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-720ll /* 0xfffffffffffffd30 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-719ll /* 0xfffffffffffffd31 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-715ll /* 0xfffffffffffffd35 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-712ll /* 0xfffffffffffffd38 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-711ll /* 0xfffffffffffffd39 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-708ll /* 0xfffffffffffffd3c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-707ll /* 0xfffffffffffffd3d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-705ll /* 0xfffffffffffffd3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-704ll /* 0xfffffffffffffd40 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {-703ll /* 0xfffffffffffffd41 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-701ll /* 0xfffffffffffffd43 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-700ll /* 0xfffffffffffffd44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-699ll /* 0xfffffffffffffd45 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-695ll /* 0xfffffffffffffd49 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-693ll /* 0xfffffffffffffd4b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-692ll /* 0xfffffffffffffd4c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-688ll /* 0xfffffffffffffd50 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-680ll /* 0xfffffffffffffd58 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-679ll /* 0xfffffffffffffd59 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-675ll /* 0xfffffffffffffd5d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-673ll /* 0xfffffffffffffd5f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-672ll /* 0xfffffffffffffd60 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-671ll /* 0xfffffffffffffd61 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-667ll /* 0xfffffffffffffd65 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-664ll /* 0xfffffffffffffd68 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-660ll /* 0xfffffffffffffd6c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-659ll /* 0xfffffffffffffd6d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-657ll /* 0xfffffffffffffd6f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-656ll /* 0xfffffffffffffd70 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-655ll /* 0xfffffffffffffd71 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-651ll /* 0xfffffffffffffd75 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-650ll /* 0xfffffffffffffd76 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-649ll /* 0xfffffffffffffd77 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-648ll /* 0xfffffffffffffd78 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-647ll /* 0xfffffffffffffd79 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-645ll /* 0xfffffffffffffd7b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-644ll /* 0xfffffffffffffd7c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-643ll /* 0xfffffffffffffd7d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-642ll /* 0xfffffffffffffd7e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-641ll /* 0xfffffffffffffd7f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-640ll /* 0xfffffffffffffd80 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {-639ll /* 0xfffffffffffffd81 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-638ll /* 0xfffffffffffffd82 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-637ll /* 0xfffffffffffffd83 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-636ll /* 0xfffffffffffffd84 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-635ll /* 0xfffffffffffffd85 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-634ll /* 0xfffffffffffffd86 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-633ll /* 0xfffffffffffffd87 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-632ll /* 0xfffffffffffffd88 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-631ll /* 0xfffffffffffffd89 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-630ll /* 0xfffffffffffffd8a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-629ll /* 0xfffffffffffffd8b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-627ll /* 0xfffffffffffffd8d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-625ll /* 0xfffffffffffffd8f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-624ll /* 0xfffffffffffffd90 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-620ll /* 0xfffffffffffffd94 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-619ll /* 0xfffffffffffffd95 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-616ll /* 0xfffffffffffffd98 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-615ll /* 0xfffffffffffffd99 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-613ll /* 0xfffffffffffffd9b */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 3},			/* shl2add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-612ll /* 0xfffffffffffffd9c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-611ll /* 0xfffffffffffffd9d */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-609ll /* 0xfffffffffffffd9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-608ll /* 0xfffffffffffffda0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-607ll /* 0xfffffffffffffda1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-604ll /* 0xfffffffffffffda4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-603ll /* 0xfffffffffffffda5 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-600ll /* 0xfffffffffffffda8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-599ll /* 0xfffffffffffffda9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-595ll /* 0xfffffffffffffdad */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-594ll /* 0xfffffffffffffdae */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-593ll /* 0xfffffffffffffdaf */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-592ll /* 0xfffffffffffffdb0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-591ll /* 0xfffffffffffffdb1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-589ll /* 0xfffffffffffffdb3 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-588ll /* 0xfffffffffffffdb4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 3},			/* shl2add r4, r3, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-585ll /* 0xfffffffffffffdb7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-584ll /* 0xfffffffffffffdb8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-583ll /* 0xfffffffffffffdb9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-581ll /* 0xfffffffffffffdbb */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {4, 3, 3},			/* shl2add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-580ll /* 0xfffffffffffffdbc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-579ll /* 0xfffffffffffffdbd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-578ll /* 0xfffffffffffffdbe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-577ll /* 0xfffffffffffffdbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-576ll /* 0xfffffffffffffdc0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {-575ll /* 0xfffffffffffffdc1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-574ll /* 0xfffffffffffffdc2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-573ll /* 0xfffffffffffffdc3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-572ll /* 0xfffffffffffffdc4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-571ll /* 0xfffffffffffffdc5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-569ll /* 0xfffffffffffffdc7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-568ll /* 0xfffffffffffffdc8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-567ll /* 0xfffffffffffffdc9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-566ll /* 0xfffffffffffffdca */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-565ll /* 0xfffffffffffffdcb */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-564ll /* 0xfffffffffffffdcc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-563ll /* 0xfffffffffffffdcd */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-561ll /* 0xfffffffffffffdcf */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-560ll /* 0xfffffffffffffdd0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-559ll /* 0xfffffffffffffdd1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-558ll /* 0xfffffffffffffdd2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-557ll /* 0xfffffffffffffdd3 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-556ll /* 0xfffffffffffffdd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-555ll /* 0xfffffffffffffdd5 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-553ll /* 0xfffffffffffffdd7 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-552ll /* 0xfffffffffffffdd8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-551ll /* 0xfffffffffffffdd9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-549ll /* 0xfffffffffffffddb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-548ll /* 0xfffffffffffffddc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-547ll /* 0xfffffffffffffddd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-546ll /* 0xfffffffffffffdde */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-545ll /* 0xfffffffffffffddf */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-544ll /* 0xfffffffffffffde0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-543ll /* 0xfffffffffffffde1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-542ll /* 0xfffffffffffffde2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-540ll /* 0xfffffffffffffde4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-539ll /* 0xfffffffffffffde5 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-536ll /* 0xfffffffffffffde8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-535ll /* 0xfffffffffffffde9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-533ll /* 0xfffffffffffffdeb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-532ll /* 0xfffffffffffffdec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-531ll /* 0xfffffffffffffded */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-530ll /* 0xfffffffffffffdee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-529ll /* 0xfffffffffffffdef */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-528ll /* 0xfffffffffffffdf0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-527ll /* 0xfffffffffffffdf1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-526ll /* 0xfffffffffffffdf2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-525ll /* 0xfffffffffffffdf3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-524ll /* 0xfffffffffffffdf4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-523ll /* 0xfffffffffffffdf5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-522ll /* 0xfffffffffffffdf6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-521ll /* 0xfffffffffffffdf7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-520ll /* 0xfffffffffffffdf8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-519ll /* 0xfffffffffffffdf9 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-518ll /* 0xfffffffffffffdfa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-517ll /* 0xfffffffffffffdfb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-516ll /* 0xfffffffffffffdfc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-515ll /* 0xfffffffffffffdfd */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-514ll /* 0xfffffffffffffdfe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-513ll /* 0xfffffffffffffdff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-512ll /* 0xfffffffffffffe00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {-511ll /* 0xfffffffffffffe01 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-510ll /* 0xfffffffffffffe02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-509ll /* 0xfffffffffffffe03 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-508ll /* 0xfffffffffffffe04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-507ll /* 0xfffffffffffffe05 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-506ll /* 0xfffffffffffffe06 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-505ll /* 0xfffffffffffffe07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-504ll /* 0xfffffffffffffe08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-503ll /* 0xfffffffffffffe09 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-502ll /* 0xfffffffffffffe0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-501ll /* 0xfffffffffffffe0b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-500ll /* 0xfffffffffffffe0c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-499ll /* 0xfffffffffffffe0d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-498ll /* 0xfffffffffffffe0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-497ll /* 0xfffffffffffffe0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-496ll /* 0xfffffffffffffe10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-495ll /* 0xfffffffffffffe11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-494ll /* 0xfffffffffffffe12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-493ll /* 0xfffffffffffffe13 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* shl1add r5, r4, r1 */
   },
  {-492ll /* 0xfffffffffffffe14 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-491ll /* 0xfffffffffffffe15 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-489ll /* 0xfffffffffffffe17 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-488ll /* 0xfffffffffffffe18 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-487ll /* 0xfffffffffffffe19 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-485ll /* 0xfffffffffffffe1b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-484ll /* 0xfffffffffffffe1c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 1, 3},			/* shl2add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-483ll /* 0xfffffffffffffe1d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 1},			/* shl1add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-482ll /* 0xfffffffffffffe1e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-481ll /* 0xfffffffffffffe1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-480ll /* 0xfffffffffffffe20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-479ll /* 0xfffffffffffffe21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-478ll /* 0xfffffffffffffe22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-477ll /* 0xfffffffffffffe23 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-476ll /* 0xfffffffffffffe24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-475ll /* 0xfffffffffffffe25 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-472ll /* 0xfffffffffffffe28 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-471ll /* 0xfffffffffffffe29 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-468ll /* 0xfffffffffffffe2c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-467ll /* 0xfffffffffffffe2d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-465ll /* 0xfffffffffffffe2f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {-464ll /* 0xfffffffffffffe30 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-463ll /* 0xfffffffffffffe31 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-462ll /* 0xfffffffffffffe32 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-460ll /* 0xfffffffffffffe34 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-457ll /* 0xfffffffffffffe37 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-456ll /* 0xfffffffffffffe38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-455ll /* 0xfffffffffffffe39 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-454ll /* 0xfffffffffffffe3a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-453ll /* 0xfffffffffffffe3b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-452ll /* 0xfffffffffffffe3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-451ll /* 0xfffffffffffffe3d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-450ll /* 0xfffffffffffffe3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-449ll /* 0xfffffffffffffe3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-448ll /* 0xfffffffffffffe40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-447ll /* 0xfffffffffffffe41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-446ll /* 0xfffffffffffffe42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-445ll /* 0xfffffffffffffe43 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-444ll /* 0xfffffffffffffe44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-443ll /* 0xfffffffffffffe45 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-442ll /* 0xfffffffffffffe46 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-441ll /* 0xfffffffffffffe47 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-440ll /* 0xfffffffffffffe48 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-439ll /* 0xfffffffffffffe49 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-438ll /* 0xfffffffffffffe4a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-436ll /* 0xfffffffffffffe4c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-433ll /* 0xfffffffffffffe4f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-432ll /* 0xfffffffffffffe50 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-431ll /* 0xfffffffffffffe51 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-429ll /* 0xfffffffffffffe53 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-428ll /* 0xfffffffffffffe54 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-424ll /* 0xfffffffffffffe58 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-423ll /* 0xfffffffffffffe59 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-419ll /* 0xfffffffffffffe5d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-418ll /* 0xfffffffffffffe5e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {-417ll /* 0xfffffffffffffe5f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-416ll /* 0xfffffffffffffe60 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-415ll /* 0xfffffffffffffe61 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-413ll /* 0xfffffffffffffe63 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-412ll /* 0xfffffffffffffe64 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-411ll /* 0xfffffffffffffe65 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-409ll /* 0xfffffffffffffe67 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-408ll /* 0xfffffffffffffe68 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-407ll /* 0xfffffffffffffe69 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-405ll /* 0xfffffffffffffe6b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-404ll /* 0xfffffffffffffe6c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-403ll /* 0xfffffffffffffe6d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-401ll /* 0xfffffffffffffe6f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-400ll /* 0xfffffffffffffe70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-399ll /* 0xfffffffffffffe71 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-397ll /* 0xfffffffffffffe73 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-396ll /* 0xfffffffffffffe74 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-395ll /* 0xfffffffffffffe75 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-393ll /* 0xfffffffffffffe77 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-392ll /* 0xfffffffffffffe78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-391ll /* 0xfffffffffffffe79 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-390ll /* 0xfffffffffffffe7a */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-389ll /* 0xfffffffffffffe7b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-388ll /* 0xfffffffffffffe7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-387ll /* 0xfffffffffffffe7d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* shl1add r5, r4, r4 */
   },
  {-386ll /* 0xfffffffffffffe7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-385ll /* 0xfffffffffffffe7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-384ll /* 0xfffffffffffffe80 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-383ll /* 0xfffffffffffffe81 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-382ll /* 0xfffffffffffffe82 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-381ll /* 0xfffffffffffffe83 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-380ll /* 0xfffffffffffffe84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-379ll /* 0xfffffffffffffe85 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-378ll /* 0xfffffffffffffe86 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-377ll /* 0xfffffffffffffe87 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-376ll /* 0xfffffffffffffe88 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-375ll /* 0xfffffffffffffe89 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-373ll /* 0xfffffffffffffe8b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-372ll /* 0xfffffffffffffe8c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-371ll /* 0xfffffffffffffe8d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-369ll /* 0xfffffffffffffe8f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-368ll /* 0xfffffffffffffe90 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-367ll /* 0xfffffffffffffe91 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-365ll /* 0xfffffffffffffe93 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 1, 3},			/* shl3add r4, r1, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-364ll /* 0xfffffffffffffe94 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-361ll /* 0xfffffffffffffe97 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-360ll /* 0xfffffffffffffe98 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-359ll /* 0xfffffffffffffe99 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-357ll /* 0xfffffffffffffe9b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-356ll /* 0xfffffffffffffe9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-355ll /* 0xfffffffffffffe9d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-353ll /* 0xfffffffffffffe9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-352ll /* 0xfffffffffffffea0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-351ll /* 0xfffffffffffffea1 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-349ll /* 0xfffffffffffffea3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-348ll /* 0xfffffffffffffea4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-347ll /* 0xfffffffffffffea5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-344ll /* 0xfffffffffffffea8 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-343ll /* 0xfffffffffffffea9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-341ll /* 0xfffffffffffffeab */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-340ll /* 0xfffffffffffffeac */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-339ll /* 0xfffffffffffffead */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-337ll /* 0xfffffffffffffeaf */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-336ll /* 0xfffffffffffffeb0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-335ll /* 0xfffffffffffffeb1 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-333ll /* 0xfffffffffffffeb3 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-332ll /* 0xfffffffffffffeb4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-331ll /* 0xfffffffffffffeb5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-330ll /* 0xfffffffffffffeb6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-329ll /* 0xfffffffffffffeb7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-328ll /* 0xfffffffffffffeb8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-327ll /* 0xfffffffffffffeb9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-325ll /* 0xfffffffffffffebb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-324ll /* 0xfffffffffffffebc */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-323ll /* 0xfffffffffffffebd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-322ll /* 0xfffffffffffffebe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-321ll /* 0xfffffffffffffebf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-320ll /* 0xfffffffffffffec0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {-319ll /* 0xfffffffffffffec1 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-318ll /* 0xfffffffffffffec2 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-317ll /* 0xfffffffffffffec3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-316ll /* 0xfffffffffffffec4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-315ll /* 0xfffffffffffffec5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-314ll /* 0xfffffffffffffec6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-313ll /* 0xfffffffffffffec7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-312ll /* 0xfffffffffffffec8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-311ll /* 0xfffffffffffffec9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-310ll /* 0xfffffffffffffeca */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-309ll /* 0xfffffffffffffecb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-307ll /* 0xfffffffffffffecd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-306ll /* 0xfffffffffffffece */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-305ll /* 0xfffffffffffffecf */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-304ll /* 0xfffffffffffffed0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-303ll /* 0xfffffffffffffed1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-301ll /* 0xfffffffffffffed3 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-300ll /* 0xfffffffffffffed4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-299ll /* 0xfffffffffffffed5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-297ll /* 0xfffffffffffffed7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-296ll /* 0xfffffffffffffed8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-295ll /* 0xfffffffffffffed9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-293ll /* 0xfffffffffffffedb */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-292ll /* 0xfffffffffffffedc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-291ll /* 0xfffffffffffffedd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-290ll /* 0xfffffffffffffede */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {-289ll /* 0xfffffffffffffedf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-288ll /* 0xfffffffffffffee0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {-287ll /* 0xfffffffffffffee1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-286ll /* 0xfffffffffffffee2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-285ll /* 0xfffffffffffffee3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-284ll /* 0xfffffffffffffee4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-283ll /* 0xfffffffffffffee5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-281ll /* 0xfffffffffffffee7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-280ll /* 0xfffffffffffffee8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-279ll /* 0xfffffffffffffee9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-278ll /* 0xfffffffffffffeea */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-277ll /* 0xfffffffffffffeeb */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-276ll /* 0xfffffffffffffeec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-275ll /* 0xfffffffffffffeed */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-274ll /* 0xfffffffffffffeee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-273ll /* 0xfffffffffffffeef */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-272ll /* 0xfffffffffffffef0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-271ll /* 0xfffffffffffffef1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-270ll /* 0xfffffffffffffef2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-269ll /* 0xfffffffffffffef3 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-268ll /* 0xfffffffffffffef4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-267ll /* 0xfffffffffffffef5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-266ll /* 0xfffffffffffffef6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-265ll /* 0xfffffffffffffef7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-264ll /* 0xfffffffffffffef8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-263ll /* 0xfffffffffffffef9 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262ll /* 0xfffffffffffffefa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-261ll /* 0xfffffffffffffefb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-260ll /* 0xfffffffffffffefc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-259ll /* 0xfffffffffffffefd */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-258ll /* 0xfffffffffffffefe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-257ll /* 0xfffffffffffffeff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-256ll /* 0xffffffffffffff00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {-255ll /* 0xffffffffffffff01 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-254ll /* 0xffffffffffffff02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-253ll /* 0xffffffffffffff03 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-252ll /* 0xffffffffffffff04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-251ll /* 0xffffffffffffff05 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-250ll /* 0xffffffffffffff06 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-249ll /* 0xffffffffffffff07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-248ll /* 0xffffffffffffff08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-247ll /* 0xffffffffffffff09 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-246ll /* 0xffffffffffffff0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-245ll /* 0xffffffffffffff0b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-244ll /* 0xffffffffffffff0c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-243ll /* 0xffffffffffffff0d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-242ll /* 0xffffffffffffff0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-241ll /* 0xffffffffffffff0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-240ll /* 0xffffffffffffff10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-239ll /* 0xffffffffffffff11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-238ll /* 0xffffffffffffff12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-237ll /* 0xffffffffffffff13 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* shl1add r5, r4, r1 */
   },
  {-236ll /* 0xffffffffffffff14 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-235ll /* 0xffffffffffffff15 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-234ll /* 0xffffffffffffff16 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-233ll /* 0xffffffffffffff17 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-232ll /* 0xffffffffffffff18 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-231ll /* 0xffffffffffffff19 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {-230ll /* 0xffffffffffffff1a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-229ll /* 0xffffffffffffff1b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-228ll /* 0xffffffffffffff1c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-227ll /* 0xffffffffffffff1d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-226ll /* 0xffffffffffffff1e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-225ll /* 0xffffffffffffff1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-224ll /* 0xffffffffffffff20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-223ll /* 0xffffffffffffff21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-222ll /* 0xffffffffffffff22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-221ll /* 0xffffffffffffff23 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-220ll /* 0xffffffffffffff24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-219ll /* 0xffffffffffffff25 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-218ll /* 0xffffffffffffff26 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-217ll /* 0xffffffffffffff27 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-216ll /* 0xffffffffffffff28 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-215ll /* 0xffffffffffffff29 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-214ll /* 0xffffffffffffff2a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-213ll /* 0xffffffffffffff2b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-212ll /* 0xffffffffffffff2c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-211ll /* 0xffffffffffffff2d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-210ll /* 0xffffffffffffff2e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {-209ll /* 0xffffffffffffff2f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-208ll /* 0xffffffffffffff30 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-207ll /* 0xffffffffffffff31 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-205ll /* 0xffffffffffffff33 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-204ll /* 0xffffffffffffff34 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-203ll /* 0xffffffffffffff35 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-202ll /* 0xffffffffffffff36 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-201ll /* 0xffffffffffffff37 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-200ll /* 0xffffffffffffff38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-199ll /* 0xffffffffffffff39 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-198ll /* 0xffffffffffffff3a */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-197ll /* 0xffffffffffffff3b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-196ll /* 0xffffffffffffff3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-195ll /* 0xffffffffffffff3d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* shl1add r5, r4, r4 */
   },
  {-194ll /* 0xffffffffffffff3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-193ll /* 0xffffffffffffff3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-192ll /* 0xffffffffffffff40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-191ll /* 0xffffffffffffff41 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-190ll /* 0xffffffffffffff42 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-189ll /* 0xffffffffffffff43 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-188ll /* 0xffffffffffffff44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-187ll /* 0xffffffffffffff45 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-186ll /* 0xffffffffffffff46 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-185ll /* 0xffffffffffffff47 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-184ll /* 0xffffffffffffff48 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-183ll /* 0xffffffffffffff49 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-181ll /* 0xffffffffffffff4b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-180ll /* 0xffffffffffffff4c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-179ll /* 0xffffffffffffff4d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-178ll /* 0xffffffffffffff4e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-177ll /* 0xffffffffffffff4f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-176ll /* 0xffffffffffffff50 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-175ll /* 0xffffffffffffff51 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-173ll /* 0xffffffffffffff53 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-172ll /* 0xffffffffffffff54 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-171ll /* 0xffffffffffffff55 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-170ll /* 0xffffffffffffff56 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-169ll /* 0xffffffffffffff57 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-168ll /* 0xffffffffffffff58 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-167ll /* 0xffffffffffffff59 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-165ll /* 0xffffffffffffff5b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-164ll /* 0xffffffffffffff5c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-163ll /* 0xffffffffffffff5d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-162ll /* 0xffffffffffffff5e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-161ll /* 0xffffffffffffff5f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-160ll /* 0xffffffffffffff60 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {-159ll /* 0xffffffffffffff61 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-158ll /* 0xffffffffffffff62 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-157ll /* 0xffffffffffffff63 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-156ll /* 0xffffffffffffff64 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-155ll /* 0xffffffffffffff65 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-154ll /* 0xffffffffffffff66 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-153ll /* 0xffffffffffffff67 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {-152ll /* 0xffffffffffffff68 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-151ll /* 0xffffffffffffff69 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-150ll /* 0xffffffffffffff6a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-149ll /* 0xffffffffffffff6b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-148ll /* 0xffffffffffffff6c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {-147ll /* 0xffffffffffffff6d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-146ll /* 0xffffffffffffff6e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-145ll /* 0xffffffffffffff6f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-144ll /* 0xffffffffffffff70 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {-143ll /* 0xffffffffffffff71 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-142ll /* 0xffffffffffffff72 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-141ll /* 0xffffffffffffff73 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-140ll /* 0xffffffffffffff74 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-139ll /* 0xffffffffffffff75 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-138ll /* 0xffffffffffffff76 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-137ll /* 0xffffffffffffff77 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-136ll /* 0xffffffffffffff78 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {-135ll /* 0xffffffffffffff79 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134ll /* 0xffffffffffffff7a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-133ll /* 0xffffffffffffff7b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-132ll /* 0xffffffffffffff7c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-131ll /* 0xffffffffffffff7d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-130ll /* 0xffffffffffffff7e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-129ll /* 0xffffffffffffff7f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-128ll /* 0xffffffffffffff80 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {-127ll /* 0xffffffffffffff81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-126ll /* 0xffffffffffffff82 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-125ll /* 0xffffffffffffff83 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-124ll /* 0xffffffffffffff84 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-123ll /* 0xffffffffffffff85 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-122ll /* 0xffffffffffffff86 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-121ll /* 0xffffffffffffff87 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-120ll /* 0xffffffffffffff88 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-119ll /* 0xffffffffffffff89 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-118ll /* 0xffffffffffffff8a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-117ll /* 0xffffffffffffff8b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-116ll /* 0xffffffffffffff8c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-115ll /* 0xffffffffffffff8d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-114ll /* 0xffffffffffffff8e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-113ll /* 0xffffffffffffff8f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-112ll /* 0xffffffffffffff90 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-111ll /* 0xffffffffffffff91 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-110ll /* 0xffffffffffffff92 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-109ll /* 0xffffffffffffff93 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-108ll /* 0xffffffffffffff94 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-107ll /* 0xffffffffffffff95 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {-106ll /* 0xffffffffffffff96 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {-105ll /* 0xffffffffffffff97 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-104ll /* 0xffffffffffffff98 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-103ll /* 0xffffffffffffff99 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {-102ll /* 0xffffffffffffff9a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {-101ll /* 0xffffffffffffff9b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-100ll /* 0xffffffffffffff9c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-99ll /* 0xffffffffffffff9d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* shl1add r5, r4, r4 */
   },
  {-98ll /* 0xffffffffffffff9e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-97ll /* 0xffffffffffffff9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-96ll /* 0xffffffffffffffa0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-95ll /* 0xffffffffffffffa1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-94ll /* 0xffffffffffffffa2 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-93ll /* 0xffffffffffffffa3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-92ll /* 0xffffffffffffffa4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-91ll /* 0xffffffffffffffa5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-90ll /* 0xffffffffffffffa6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-89ll /* 0xffffffffffffffa7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-88ll /* 0xffffffffffffffa8 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-87ll /* 0xffffffffffffffa9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-86ll /* 0xffffffffffffffaa */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-85ll /* 0xffffffffffffffab */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {-84ll /* 0xffffffffffffffac */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-83ll /* 0xffffffffffffffad */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-82ll /* 0xffffffffffffffae */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {-81ll /* 0xffffffffffffffaf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {-80ll /* 0xffffffffffffffb0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {-79ll /* 0xffffffffffffffb1 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-78ll /* 0xffffffffffffffb2 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-77ll /* 0xffffffffffffffb3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-76ll /* 0xffffffffffffffb4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-75ll /* 0xffffffffffffffb5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-74ll /* 0xffffffffffffffb6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-73ll /* 0xffffffffffffffb7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-72ll /* 0xffffffffffffffb8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {-71ll /* 0xffffffffffffffb9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-70ll /* 0xffffffffffffffba */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-69ll /* 0xffffffffffffffbb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {-68ll /* 0xffffffffffffffbc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {-67ll /* 0xffffffffffffffbd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-66ll /* 0xffffffffffffffbe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-65ll /* 0xffffffffffffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-64ll /* 0xffffffffffffffc0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {-63ll /* 0xffffffffffffffc1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-62ll /* 0xffffffffffffffc2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-61ll /* 0xffffffffffffffc3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-60ll /* 0xffffffffffffffc4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-59ll /* 0xffffffffffffffc5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-58ll /* 0xffffffffffffffc6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-57ll /* 0xffffffffffffffc7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-56ll /* 0xffffffffffffffc8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-55ll /* 0xffffffffffffffc9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-54ll /* 0xffffffffffffffca */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-53ll /* 0xffffffffffffffcb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {-52ll /* 0xffffffffffffffcc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-51ll /* 0xffffffffffffffcd */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* shl1add r5, r4, r4 */
   },
  {-50ll /* 0xffffffffffffffce */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-49ll /* 0xffffffffffffffcf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-48ll /* 0xffffffffffffffd0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-47ll /* 0xffffffffffffffd1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-46ll /* 0xffffffffffffffd2 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-45ll /* 0xffffffffffffffd3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-44ll /* 0xffffffffffffffd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-43ll /* 0xffffffffffffffd5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {-42ll /* 0xffffffffffffffd6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-41ll /* 0xffffffffffffffd7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {-40ll /* 0xffffffffffffffd8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {-39ll /* 0xffffffffffffffd9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-38ll /* 0xffffffffffffffda */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-37ll /* 0xffffffffffffffdb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {-36ll /* 0xffffffffffffffdc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {-35ll /* 0xffffffffffffffdd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34ll /* 0xffffffffffffffde */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {-33ll /* 0xffffffffffffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32ll /* 0xffffffffffffffe0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {-31ll /* 0xffffffffffffffe1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-30ll /* 0xffffffffffffffe2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-29ll /* 0xffffffffffffffe3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-28ll /* 0xffffffffffffffe4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-27ll /* 0xffffffffffffffe5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-26ll /* 0xffffffffffffffe6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-25ll /* 0xffffffffffffffe7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-24ll /* 0xffffffffffffffe8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-23ll /* 0xffffffffffffffe9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-22ll /* 0xffffffffffffffea */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-21ll /* 0xffffffffffffffeb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-20ll /* 0xffffffffffffffec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {-19ll /* 0xffffffffffffffed */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-18ll /* 0xffffffffffffffee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {-17ll /* 0xffffffffffffffef */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16ll /* 0xfffffffffffffff0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {-15ll /* 0xfffffffffffffff1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-14ll /* 0xfffffffffffffff2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-13ll /* 0xfffffffffffffff3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-12ll /* 0xfffffffffffffff4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-11ll /* 0xfffffffffffffff5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-10ll /* 0xfffffffffffffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9ll /* 0xfffffffffffffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2}}			/* shl3add r3, r2, r2 */
   },
  {-8ll /* 0xfffffffffffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {-7ll /* 0xfffffffffffffff9 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-6ll /* 0xfffffffffffffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-5ll /* 0xfffffffffffffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2}}			/* shl2add r3, r2, r2 */
   },
  {-4ll /* 0xfffffffffffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {-3ll /* 0xfffffffffffffffd */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2ll /* 0xfffffffffffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {-1ll /* 0xffffffffffffffff */ ,
   {{2, 0, 1}}			/* sub r2, zero, r1 */
   },
  {2ll /* 0x2 */ ,
   {{6, 1, 1}}			/* shli r2, r1, 1 */
   },
  {3ll /* 0x3 */ ,
   {{3, 1, 1}}			/* shl1add r2, r1, r1 */
   },
  {4ll /* 0x4 */ ,
   {{6, 1, 2}}			/* shli r2, r1, 2 */
   },
  {5ll /* 0x5 */ ,
   {{4, 1, 1}}			/* shl2add r2, r1, r1 */
   },
  {6ll /* 0x6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {7ll /* 0x7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8ll /* 0x8 */ ,
   {{6, 1, 3}}			/* shli r2, r1, 3 */
   },
  {9ll /* 0x9 */ ,
   {{5, 1, 1}}			/* shl3add r2, r1, r1 */
   },
  {10ll /* 0xa */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {11ll /* 0xb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1}}			/* shl1add r3, r2, r1 */
   },
  {12ll /* 0xc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {13ll /* 0xd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1}}			/* shl2add r3, r2, r1 */
   },
  {14ll /* 0xe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {15ll /* 0xf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16ll /* 0x10 */ ,
   {{6, 1, 4}}			/* shli r2, r1, 4 */
   },
  {17ll /* 0x11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {18ll /* 0x12 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {19ll /* 0x13 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1}}			/* shl1add r3, r2, r1 */
   },
  {20ll /* 0x14 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {21ll /* 0x15 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1}}			/* shl2add r3, r2, r1 */
   },
  {22ll /* 0x16 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {23ll /* 0x17 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {24ll /* 0x18 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {25ll /* 0x19 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1}}			/* shl3add r3, r2, r1 */
   },
  {26ll /* 0x1a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {27ll /* 0x1b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2}}			/* shl3add r3, r2, r2 */
   },
  {28ll /* 0x1c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {29ll /* 0x1d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {30ll /* 0x1e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {31ll /* 0x1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {32ll /* 0x20 */ ,
   {{6, 1, 5}}			/* shli r2, r1, 5 */
   },
  {33ll /* 0x21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {34ll /* 0x22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {35ll /* 0x23 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36ll /* 0x24 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {37ll /* 0x25 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1}}			/* shl2add r3, r2, r1 */
   },
  {38ll /* 0x26 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {39ll /* 0x27 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {40ll /* 0x28 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {41ll /* 0x29 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1}}			/* shl3add r3, r2, r1 */
   },
  {42ll /* 0x2a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {43ll /* 0x2b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {44ll /* 0x2c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {45ll /* 0x2d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2}}			/* shl3add r3, r2, r2 */
   },
  {46ll /* 0x2e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {47ll /* 0x2f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {48ll /* 0x30 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {49ll /* 0x31 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {50ll /* 0x32 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {51ll /* 0x33 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {52ll /* 0x34 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {53ll /* 0x35 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {54ll /* 0x36 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {55ll /* 0x37 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {56ll /* 0x38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {57ll /* 0x39 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {58ll /* 0x3a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {59ll /* 0x3b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {60ll /* 0x3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {61ll /* 0x3d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {62ll /* 0x3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {63ll /* 0x3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {64ll /* 0x40 */ ,
   {{6, 1, 6}}			/* shli r2, r1, 6 */
   },
  {65ll /* 0x41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {66ll /* 0x42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {67ll /* 0x43 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68ll /* 0x44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {69ll /* 0x45 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70ll /* 0x46 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {71ll /* 0x47 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {72ll /* 0x48 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {73ll /* 0x49 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1}}			/* shl3add r3, r2, r1 */
   },
  {74ll /* 0x4a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {75ll /* 0x4b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {76ll /* 0x4c */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {77ll /* 0x4d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {78ll /* 0x4e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {79ll /* 0x4f */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {80ll /* 0x50 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {81ll /* 0x51 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2}}			/* shl3add r3, r2, r2 */
   },
  {82ll /* 0x52 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {83ll /* 0x53 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 1}}			/* shl1add r4, r3, r1 */
   },
  {84ll /* 0x54 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {85ll /* 0x55 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {86ll /* 0x56 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {87ll /* 0x57 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {88ll /* 0x58 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {89ll /* 0x59 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {90ll /* 0x5a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {91ll /* 0x5b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {3, 3, 1}}			/* shl1add r4, r3, r1 */
   },
  {92ll /* 0x5c */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {93ll /* 0x5d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {94ll /* 0x5e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {95ll /* 0x5f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {96ll /* 0x60 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {97ll /* 0x61 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {98ll /* 0x62 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {99ll /* 0x63 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {100ll /* 0x64 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {101ll /* 0x65 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 1}}			/* shl2add r4, r3, r1 */
   },
  {102ll /* 0x66 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {103ll /* 0x67 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {104ll /* 0x68 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {105ll /* 0x69 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {106ll /* 0x6a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {107ll /* 0x6b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {108ll /* 0x6c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {109ll /* 0x6d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 1}}			/* shl2add r4, r3, r1 */
   },
  {110ll /* 0x6e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {111ll /* 0x6f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {112ll /* 0x70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {113ll /* 0x71 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {114ll /* 0x72 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {115ll /* 0x73 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {116ll /* 0x74 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {117ll /* 0x75 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {118ll /* 0x76 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {119ll /* 0x77 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {120ll /* 0x78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {121ll /* 0x79 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {122ll /* 0x7a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {123ll /* 0x7b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {124ll /* 0x7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {125ll /* 0x7d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {126ll /* 0x7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {127ll /* 0x7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {128ll /* 0x80 */ ,
   {{6, 1, 7}}			/* shli r2, r1, 7 */
   },
  {129ll /* 0x81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {130ll /* 0x82 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {131ll /* 0x83 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {132ll /* 0x84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {133ll /* 0x85 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134ll /* 0x86 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {135ll /* 0x87 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {136ll /* 0x88 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {137ll /* 0x89 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {138ll /* 0x8a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {139ll /* 0x8b */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {140ll /* 0x8c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {141ll /* 0x8d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {142ll /* 0x8e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {143ll /* 0x8f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {144ll /* 0x90 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {145ll /* 0x91 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {146ll /* 0x92 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {147ll /* 0x93 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 1}}			/* shl1add r4, r3, r1 */
   },
  {148ll /* 0x94 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {149ll /* 0x95 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 1}}			/* shl2add r4, r3, r1 */
   },
  {150ll /* 0x96 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {151ll /* 0x97 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {152ll /* 0x98 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {153ll /* 0x99 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {154ll /* 0x9a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {155ll /* 0x9b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {156ll /* 0x9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {157ll /* 0x9d */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {158ll /* 0x9e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {159ll /* 0x9f */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {160ll /* 0xa0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {161ll /* 0xa1 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {162ll /* 0xa2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {163ll /* 0xa3 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {3, 3, 1}}			/* shl1add r4, r3, r1 */
   },
  {164ll /* 0xa4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {165ll /* 0xa5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {166ll /* 0xa6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {167ll /* 0xa7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {168ll /* 0xa8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {169ll /* 0xa9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {170ll /* 0xaa */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {171ll /* 0xab */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {172ll /* 0xac */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {173ll /* 0xad */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {174ll /* 0xae */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {175ll /* 0xaf */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {176ll /* 0xb0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {177ll /* 0xb1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {178ll /* 0xb2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {179ll /* 0xb3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {180ll /* 0xb4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {181ll /* 0xb5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 1}}			/* shl2add r4, r3, r1 */
   },
  {182ll /* 0xb6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {183ll /* 0xb7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {184ll /* 0xb8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {185ll /* 0xb9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {186ll /* 0xba */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {187ll /* 0xbb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {188ll /* 0xbc */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {189ll /* 0xbd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {190ll /* 0xbe */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {191ll /* 0xbf */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {192ll /* 0xc0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {193ll /* 0xc1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {194ll /* 0xc2 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {195ll /* 0xc3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {196ll /* 0xc4 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {197ll /* 0xc5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {198ll /* 0xc6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {199ll /* 0xc7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {200ll /* 0xc8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {201ll /* 0xc9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {202ll /* 0xca */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {203ll /* 0xcb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {204ll /* 0xcc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {205ll /* 0xcd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {206ll /* 0xce */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {207ll /* 0xcf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {208ll /* 0xd0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {209ll /* 0xd1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {210ll /* 0xd2 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {211ll /* 0xd3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {212ll /* 0xd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {213ll /* 0xd5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {214ll /* 0xd6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {215ll /* 0xd7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {216ll /* 0xd8 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {217ll /* 0xd9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {218ll /* 0xda */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {219ll /* 0xdb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {220ll /* 0xdc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {221ll /* 0xdd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {222ll /* 0xde */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {223ll /* 0xdf */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {224ll /* 0xe0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {225ll /* 0xe1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {226ll /* 0xe2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {227ll /* 0xe3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {228ll /* 0xe4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {229ll /* 0xe5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {230ll /* 0xe6 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {231ll /* 0xe7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 8},			/* shli r4, r1, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {232ll /* 0xe8 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {233ll /* 0xe9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {234ll /* 0xea */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {235ll /* 0xeb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {236ll /* 0xec */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {237ll /* 0xed */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {238ll /* 0xee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {239ll /* 0xef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {240ll /* 0xf0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {241ll /* 0xf1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {242ll /* 0xf2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {243ll /* 0xf3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {244ll /* 0xf4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {245ll /* 0xf5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {246ll /* 0xf6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {247ll /* 0xf7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {248ll /* 0xf8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {249ll /* 0xf9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {250ll /* 0xfa */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {251ll /* 0xfb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {252ll /* 0xfc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {253ll /* 0xfd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {254ll /* 0xfe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {255ll /* 0xff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {256ll /* 0x100 */ ,
   {{6, 1, 8}}			/* shli r2, r1, 8 */
   },
  {257ll /* 0x101 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {258ll /* 0x102 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {259ll /* 0x103 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {260ll /* 0x104 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {261ll /* 0x105 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262ll /* 0x106 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {263ll /* 0x107 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {264ll /* 0x108 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {265ll /* 0x109 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {266ll /* 0x10a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {267ll /* 0x10b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {268ll /* 0x10c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {269ll /* 0x10d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {270ll /* 0x10e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {271ll /* 0x10f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {272ll /* 0x110 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {273ll /* 0x111 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {274ll /* 0x112 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {275ll /* 0x113 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {276ll /* 0x114 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {277ll /* 0x115 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {278ll /* 0x116 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {279ll /* 0x117 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {280ll /* 0x118 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {281ll /* 0x119 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {282ll /* 0x11a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {283ll /* 0x11b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {284ll /* 0x11c */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {285ll /* 0x11d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {286ll /* 0x11e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {287ll /* 0x11f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {288ll /* 0x120 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {289ll /* 0x121 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {290ll /* 0x122 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {291ll /* 0x123 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {292ll /* 0x124 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {293ll /* 0x125 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 1}}			/* shl2add r4, r3, r1 */
   },
  {294ll /* 0x126 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {295ll /* 0x127 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {296ll /* 0x128 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {297ll /* 0x129 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {298ll /* 0x12a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {299ll /* 0x12b */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {300ll /* 0x12c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {301ll /* 0x12d */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {302ll /* 0x12e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {303ll /* 0x12f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {304ll /* 0x130 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {305ll /* 0x131 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {306ll /* 0x132 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {307ll /* 0x133 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {308ll /* 0x134 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {309ll /* 0x135 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {310ll /* 0x136 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {311ll /* 0x137 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {312ll /* 0x138 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {313ll /* 0x139 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {314ll /* 0x13a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {315ll /* 0x13b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {316ll /* 0x13c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {317ll /* 0x13d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {318ll /* 0x13e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {319ll /* 0x13f */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {320ll /* 0x140 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {321ll /* 0x141 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {322ll /* 0x142 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {323ll /* 0x143 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {324ll /* 0x144 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {325ll /* 0x145 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {326ll /* 0x146 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {327ll /* 0x147 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {328ll /* 0x148 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {329ll /* 0x149 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {330ll /* 0x14a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {331ll /* 0x14b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {332ll /* 0x14c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {333ll /* 0x14d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {334ll /* 0x14e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {335ll /* 0x14f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {336ll /* 0x150 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {337ll /* 0x151 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {338ll /* 0x152 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {339ll /* 0x153 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {340ll /* 0x154 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {341ll /* 0x155 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {342ll /* 0x156 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {343ll /* 0x157 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {344ll /* 0x158 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {345ll /* 0x159 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {346ll /* 0x15a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {347ll /* 0x15b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {348ll /* 0x15c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 2},			/* shli r4, r2, 2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {349ll /* 0x15d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {350ll /* 0x15e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {351ll /* 0x15f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {352ll /* 0x160 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {353ll /* 0x161 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {354ll /* 0x162 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {355ll /* 0x163 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {356ll /* 0x164 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {357ll /* 0x165 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {358ll /* 0x166 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {359ll /* 0x167 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {360ll /* 0x168 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {361ll /* 0x169 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {362ll /* 0x16a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {363ll /* 0x16b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {364ll /* 0x16c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 2},			/* shli r4, r1, 2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {365ll /* 0x16d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {366ll /* 0x16e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {367ll /* 0x16f */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {368ll /* 0x170 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {369ll /* 0x171 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {370ll /* 0x172 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {371ll /* 0x173 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {372ll /* 0x174 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {373ll /* 0x175 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {374ll /* 0x176 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {375ll /* 0x177 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {376ll /* 0x178 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {377ll /* 0x179 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {378ll /* 0x17a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {379ll /* 0x17b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {380ll /* 0x17c */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {381ll /* 0x17d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {382ll /* 0x17e */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {383ll /* 0x17f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {384ll /* 0x180 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {385ll /* 0x181 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {386ll /* 0x182 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {387ll /* 0x183 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {388ll /* 0x184 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {389ll /* 0x185 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {390ll /* 0x186 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {391ll /* 0x187 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {392ll /* 0x188 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {393ll /* 0x189 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {394ll /* 0x18a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {395ll /* 0x18b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {396ll /* 0x18c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {397ll /* 0x18d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {398ll /* 0x18e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {399ll /* 0x18f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {400ll /* 0x190 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {401ll /* 0x191 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {402ll /* 0x192 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {403ll /* 0x193 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {404ll /* 0x194 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {405ll /* 0x195 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {406ll /* 0x196 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {407ll /* 0x197 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {408ll /* 0x198 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {409ll /* 0x199 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {410ll /* 0x19a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {411ll /* 0x19b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {412ll /* 0x19c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {413ll /* 0x19d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {414ll /* 0x19e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {415ll /* 0x19f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {416ll /* 0x1a0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {417ll /* 0x1a1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {418ll /* 0x1a2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {419ll /* 0x1a3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {420ll /* 0x1a4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {421ll /* 0x1a5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {422ll /* 0x1a6 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {423ll /* 0x1a7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {424ll /* 0x1a8 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {425ll /* 0x1a9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {426ll /* 0x1aa */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {427ll /* 0x1ab */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {428ll /* 0x1ac */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {429ll /* 0x1ad */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {430ll /* 0x1ae */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {431ll /* 0x1af */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {432ll /* 0x1b0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {433ll /* 0x1b1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {434ll /* 0x1b2 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {435ll /* 0x1b3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {436ll /* 0x1b4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {437ll /* 0x1b5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {438ll /* 0x1b6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {439ll /* 0x1b7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {440ll /* 0x1b8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {441ll /* 0x1b9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {442ll /* 0x1ba */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {443ll /* 0x1bb */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {444ll /* 0x1bc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {445ll /* 0x1bd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {446ll /* 0x1be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {447ll /* 0x1bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {448ll /* 0x1c0 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {449ll /* 0x1c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {450ll /* 0x1c2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {451ll /* 0x1c3 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {452ll /* 0x1c4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {453ll /* 0x1c5 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {454ll /* 0x1c6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {455ll /* 0x1c7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {456ll /* 0x1c8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {457ll /* 0x1c9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {458ll /* 0x1ca */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {459ll /* 0x1cb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {460ll /* 0x1cc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {461ll /* 0x1cd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {462ll /* 0x1ce */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {463ll /* 0x1cf */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {464ll /* 0x1d0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {465ll /* 0x1d1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {467ll /* 0x1d3 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {468ll /* 0x1d4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {469ll /* 0x1d5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {470ll /* 0x1d6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {471ll /* 0x1d7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {472ll /* 0x1d8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {473ll /* 0x1d9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {475ll /* 0x1db */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {476ll /* 0x1dc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {477ll /* 0x1dd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {478ll /* 0x1de */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {479ll /* 0x1df */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {480ll /* 0x1e0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {481ll /* 0x1e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {482ll /* 0x1e2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {483ll /* 0x1e3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {484ll /* 0x1e4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {485ll /* 0x1e5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {486ll /* 0x1e6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {487ll /* 0x1e7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {488ll /* 0x1e8 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {489ll /* 0x1e9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {490ll /* 0x1ea */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {491ll /* 0x1eb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {492ll /* 0x1ec */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {493ll /* 0x1ed */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {494ll /* 0x1ee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {495ll /* 0x1ef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {496ll /* 0x1f0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {497ll /* 0x1f1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {498ll /* 0x1f2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {499ll /* 0x1f3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {500ll /* 0x1f4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {501ll /* 0x1f5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {502ll /* 0x1f6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {503ll /* 0x1f7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {504ll /* 0x1f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {505ll /* 0x1f9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {506ll /* 0x1fa */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {507ll /* 0x1fb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {508ll /* 0x1fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {509ll /* 0x1fd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {510ll /* 0x1fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {511ll /* 0x1ff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {512ll /* 0x200 */ ,
   {{6, 1, 9}}			/* shli r2, r1, 9 */
   },
  {513ll /* 0x201 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {514ll /* 0x202 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {515ll /* 0x203 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {516ll /* 0x204 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {517ll /* 0x205 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {518ll /* 0x206 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {519ll /* 0x207 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {520ll /* 0x208 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {521ll /* 0x209 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {522ll /* 0x20a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {523ll /* 0x20b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {524ll /* 0x20c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {525ll /* 0x20d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {526ll /* 0x20e */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {527ll /* 0x20f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {528ll /* 0x210 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {529ll /* 0x211 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {530ll /* 0x212 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {531ll /* 0x213 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {532ll /* 0x214 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {533ll /* 0x215 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {534ll /* 0x216 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {535ll /* 0x217 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {536ll /* 0x218 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {537ll /* 0x219 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {538ll /* 0x21a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {539ll /* 0x21b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {540ll /* 0x21c */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {541ll /* 0x21d */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {542ll /* 0x21e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {543ll /* 0x21f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {544ll /* 0x220 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {545ll /* 0x221 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {546ll /* 0x222 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {547ll /* 0x223 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {548ll /* 0x224 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {549ll /* 0x225 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {550ll /* 0x226 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {551ll /* 0x227 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {552ll /* 0x228 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {553ll /* 0x229 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {554ll /* 0x22a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {555ll /* 0x22b */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {556ll /* 0x22c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {557ll /* 0x22d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {558ll /* 0x22e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {559ll /* 0x22f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {560ll /* 0x230 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {561ll /* 0x231 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {562ll /* 0x232 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {563ll /* 0x233 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {564ll /* 0x234 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {565ll /* 0x235 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {566ll /* 0x236 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {567ll /* 0x237 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {568ll /* 0x238 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {569ll /* 0x239 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {570ll /* 0x23a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {571ll /* 0x23b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {572ll /* 0x23c */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {573ll /* 0x23d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {574ll /* 0x23e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {575ll /* 0x23f */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {576ll /* 0x240 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {577ll /* 0x241 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {578ll /* 0x242 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {579ll /* 0x243 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {580ll /* 0x244 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {581ll /* 0x245 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {582ll /* 0x246 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {583ll /* 0x247 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {584ll /* 0x248 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {585ll /* 0x249 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {586ll /* 0x24a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {587ll /* 0x24b */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {588ll /* 0x24c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {589ll /* 0x24d */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {590ll /* 0x24e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {591ll /* 0x24f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {592ll /* 0x250 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {593ll /* 0x251 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {594ll /* 0x252 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {595ll /* 0x253 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {596ll /* 0x254 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {597ll /* 0x255 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {598ll /* 0x256 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {599ll /* 0x257 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {600ll /* 0x258 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {601ll /* 0x259 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {602ll /* 0x25a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {603ll /* 0x25b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {604ll /* 0x25c */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {605ll /* 0x25d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {606ll /* 0x25e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {607ll /* 0x25f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {608ll /* 0x260 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {609ll /* 0x261 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {610ll /* 0x262 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {611ll /* 0x263 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {612ll /* 0x264 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {613ll /* 0x265 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {614ll /* 0x266 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {615ll /* 0x267 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {616ll /* 0x268 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {617ll /* 0x269 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {619ll /* 0x26b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {620ll /* 0x26c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {621ll /* 0x26d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {623ll /* 0x26f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {624ll /* 0x270 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {625ll /* 0x271 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {626ll /* 0x272 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {627ll /* 0x273 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {628ll /* 0x274 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {629ll /* 0x275 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {630ll /* 0x276 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {631ll /* 0x277 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {632ll /* 0x278 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {633ll /* 0x279 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {634ll /* 0x27a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {635ll /* 0x27b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {636ll /* 0x27c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {637ll /* 0x27d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {638ll /* 0x27e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {639ll /* 0x27f */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {640ll /* 0x280 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {641ll /* 0x281 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {642ll /* 0x282 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {643ll /* 0x283 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {644ll /* 0x284 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {645ll /* 0x285 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {646ll /* 0x286 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {647ll /* 0x287 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {648ll /* 0x288 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {649ll /* 0x289 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {650ll /* 0x28a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {651ll /* 0x28b */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {652ll /* 0x28c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {653ll /* 0x28d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {654ll /* 0x28e */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {655ll /* 0x28f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {656ll /* 0x290 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {657ll /* 0x291 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {658ll /* 0x292 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {659ll /* 0x293 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {660ll /* 0x294 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {661ll /* 0x295 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {662ll /* 0x296 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {663ll /* 0x297 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {664ll /* 0x298 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {665ll /* 0x299 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {666ll /* 0x29a */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {667ll /* 0x29b */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {668ll /* 0x29c */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {669ll /* 0x29d */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 1},			/* shl1add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {670ll /* 0x29e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {671ll /* 0x29f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {672ll /* 0x2a0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {673ll /* 0x2a1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {674ll /* 0x2a2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {675ll /* 0x2a3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {676ll /* 0x2a4 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {677ll /* 0x2a5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {679ll /* 0x2a7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 2, 4}}			/* shl3add r5, r2, r4 */
   },
  {680ll /* 0x2a8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {681ll /* 0x2a9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {682ll /* 0x2aa */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {684ll /* 0x2ac */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 2},			/* shli r4, r2, 2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {685ll /* 0x2ad */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {688ll /* 0x2b0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 1, 1},			/* shl2add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {689ll /* 0x2b1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {690ll /* 0x2b2 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {692ll /* 0x2b4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {693ll /* 0x2b5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 1},			/* shl3add r3, r1, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {694ll /* 0x2b6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 3},			/* shl2add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {695ll /* 0x2b7 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {696ll /* 0x2b8 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {697ll /* 0x2b9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {699ll /* 0x2bb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {700ll /* 0x2bc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {701ll /* 0x2bd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {702ll /* 0x2be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {703ll /* 0x2bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {704ll /* 0x2c0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {705ll /* 0x2c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {706ll /* 0x2c2 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {707ll /* 0x2c3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {708ll /* 0x2c4 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {709ll /* 0x2c5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {710ll /* 0x2c6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {711ll /* 0x2c7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {712ll /* 0x2c8 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {713ll /* 0x2c9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {714ll /* 0x2ca */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 3},			/* shl2add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {715ll /* 0x2cb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {716ll /* 0x2cc */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {717ll /* 0x2cd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {719ll /* 0x2cf */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 4, 1}}			/* sub r5, r4, r1 */
   },
  {720ll /* 0x2d0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {721ll /* 0x2d1 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {722ll /* 0x2d2 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {723ll /* 0x2d3 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {724ll /* 0x2d4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {725ll /* 0x2d5 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {726ll /* 0x2d6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {727ll /* 0x2d7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {728ll /* 0x2d8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {729ll /* 0x2d9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3}}			/* shl3add r4, r3, r3 */
   },
  {730ll /* 0x2da */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {731ll /* 0x2db */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 1}}			/* shl1add r5, r4, r1 */
   },
  {733ll /* 0x2dd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {735ll /* 0x2df */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {736ll /* 0x2e0 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {737ll /* 0x2e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {738ll /* 0x2e2 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {739ll /* 0x2e3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {740ll /* 0x2e4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {741ll /* 0x2e5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {743ll /* 0x2e7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {744ll /* 0x2e8 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {745ll /* 0x2e9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {747ll /* 0x2eb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {748ll /* 0x2ec */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {749ll /* 0x2ed */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {750ll /* 0x2ee */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {752ll /* 0x2f0 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {753ll /* 0x2f1 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {755ll /* 0x2f3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {756ll /* 0x2f4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {757ll /* 0x2f5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {758ll /* 0x2f6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {759ll /* 0x2f7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {760ll /* 0x2f8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {761ll /* 0x2f9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {762ll /* 0x2fa */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {763ll /* 0x2fb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {764ll /* 0x2fc */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {765ll /* 0x2fd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {766ll /* 0x2fe */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {767ll /* 0x2ff */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {768ll /* 0x300 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {769ll /* 0x301 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {770ll /* 0x302 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {771ll /* 0x303 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {772ll /* 0x304 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {773ll /* 0x305 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {774ll /* 0x306 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {775ll /* 0x307 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {776ll /* 0x308 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {777ll /* 0x309 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {778ll /* 0x30a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {779ll /* 0x30b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {780ll /* 0x30c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {781ll /* 0x30d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {782ll /* 0x30e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {783ll /* 0x30f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {784ll /* 0x310 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {785ll /* 0x311 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 1, 2},			/* shl3add r4, r1, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {786ll /* 0x312 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {787ll /* 0x313 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 1, 3},			/* shl1add r4, r1, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {788ll /* 0x314 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {789ll /* 0x315 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 2, 4}}			/* shl3add r5, r2, r4 */
   },
  {790ll /* 0x316 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {791ll /* 0x317 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {792ll /* 0x318 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {793ll /* 0x319 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {794ll /* 0x31a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {795ll /* 0x31b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {796ll /* 0x31c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {797ll /* 0x31d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {798ll /* 0x31e */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {799ll /* 0x31f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {800ll /* 0x320 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {801ll /* 0x321 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {802ll /* 0x322 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {803ll /* 0x323 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {804ll /* 0x324 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {805ll /* 0x325 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {806ll /* 0x326 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {807ll /* 0x327 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {808ll /* 0x328 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {809ll /* 0x329 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* shl2add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {810ll /* 0x32a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {811ll /* 0x32b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {812ll /* 0x32c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {813ll /* 0x32d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {815ll /* 0x32f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {816ll /* 0x330 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {817ll /* 0x331 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {818ll /* 0x332 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {819ll /* 0x333 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {820ll /* 0x334 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {821ll /* 0x335 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {822ll /* 0x336 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {823ll /* 0x337 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {824ll /* 0x338 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {825ll /* 0x339 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {827ll /* 0x33b */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {828ll /* 0x33c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {829ll /* 0x33d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {831ll /* 0x33f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {832ll /* 0x340 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {833ll /* 0x341 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {834ll /* 0x342 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 2},			/* shl1add r4, r2, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {835ll /* 0x343 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {836ll /* 0x344 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* shl3add r4, r2, r2 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {837ll /* 0x345 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {838ll /* 0x346 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {840ll /* 0x348 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {841ll /* 0x349 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {842ll /* 0x34a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {843ll /* 0x34b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {844ll /* 0x34c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {845ll /* 0x34d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {846ll /* 0x34e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {848ll /* 0x350 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 2, 2},			/* shl2add r4, r2, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {849ll /* 0x351 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {850ll /* 0x352 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {852ll /* 0x354 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {853ll /* 0x355 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {855ll /* 0x357 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {856ll /* 0x358 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {857ll /* 0x359 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {858ll /* 0x35a */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {859ll /* 0x35b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {861ll /* 0x35d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {862ll /* 0x35e */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {863ll /* 0x35f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 1}}			/* sub r5, r4, r1 */
   },
  {864ll /* 0x360 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {865ll /* 0x361 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 1, 4}}			/* add r5, r1, r4 */
   },
  {866ll /* 0x362 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {867ll /* 0x363 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {868ll /* 0x364 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {869ll /* 0x365 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {870ll /* 0x366 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {871ll /* 0x367 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {872ll /* 0x368 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {873ll /* 0x369 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {875ll /* 0x36b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {876ll /* 0x36c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {877ll /* 0x36d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {879ll /* 0x36f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {880ll /* 0x370 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {881ll /* 0x371 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 2},			/* shl1add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {882ll /* 0x372 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {884ll /* 0x374 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {885ll /* 0x375 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {888ll /* 0x378 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {889ll /* 0x379 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {890ll /* 0x37a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {891ll /* 0x37b */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {892ll /* 0x37c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {893ll /* 0x37d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {894ll /* 0x37e */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {895ll /* 0x37f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {896ll /* 0x380 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {897ll /* 0x381 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {898ll /* 0x382 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {899ll /* 0x383 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {900ll /* 0x384 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {901ll /* 0x385 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {902ll /* 0x386 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {903ll /* 0x387 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {904ll /* 0x388 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {905ll /* 0x389 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {906ll /* 0x38a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {908ll /* 0x38c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {3, 3, 3},			/* shl1add r4, r3, r3 */
    {3, 4, 2}}			/* shl1add r5, r4, r2 */
   },
  {909ll /* 0x38d */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {910ll /* 0x38e */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {911ll /* 0x38f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {912ll /* 0x390 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {913ll /* 0x391 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* shl1add r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {915ll /* 0x393 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {916ll /* 0x394 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {917ll /* 0x395 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 3, 2},			/* shl3add r4, r3, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {918ll /* 0x396 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {919ll /* 0x397 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {920ll /* 0x398 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {924ll /* 0x39c */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {925ll /* 0x39d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {927ll /* 0x39f */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {4, 3, 2},			/* shl2add r4, r3, r2 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {928ll /* 0x3a0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {929ll /* 0x3a1 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* shl2add r4, r1, r2 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {932ll /* 0x3a4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {4, 4, 2}}			/* shl2add r5, r4, r2 */
   },
  {935ll /* 0x3a7 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {936ll /* 0x3a8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* shl3add r4, r2, r3 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {937ll /* 0x3a9 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {939ll /* 0x3ab */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {941ll /* 0x3ad */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {943ll /* 0x3af */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {944ll /* 0x3b0 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {945ll /* 0x3b1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {948ll /* 0x3b4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {949ll /* 0x3b5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {950ll /* 0x3b6 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {951ll /* 0x3b7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {952ll /* 0x3b8 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {953ll /* 0x3b9 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {955ll /* 0x3bb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {4, 4, 4}}			/* shl2add r5, r4, r4 */
   },
  {956ll /* 0x3bc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {957ll /* 0x3bd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {958ll /* 0x3be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {959ll /* 0x3bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {960ll /* 0x3c0 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {961ll /* 0x3c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {962ll /* 0x3c2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {963ll /* 0x3c3 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {964ll /* 0x3c4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {4, 3, 4}}			/* shl2add r5, r3, r4 */
   },
  {965ll /* 0x3c5 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {966ll /* 0x3c6 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* shl1add r4, r3, r2 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {967ll /* 0x3c7 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {968ll /* 0x3c8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {5, 3, 4}}			/* shl3add r5, r3, r4 */
   },
  {969ll /* 0x3c9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* shl1add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {970ll /* 0x3ca */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {971ll /* 0x3cb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 2},			/* shl2add r3, r2, r2 */
    {5, 3, 1},			/* shl3add r4, r3, r1 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {972ll /* 0x3cc */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {973ll /* 0x3cd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {5, 3, 3},			/* shl3add r4, r3, r3 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {975ll /* 0x3cf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {976ll /* 0x3d0 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {979ll /* 0x3d3 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {980ll /* 0x3d4 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* shl1add r4, r2, r3 */
    {3, 4, 3}}			/* shl1add r5, r4, r3 */
   },
  {981ll /* 0x3d5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {4, 3, 1},			/* shl2add r4, r3, r1 */
    {5, 4, 4}}			/* shl3add r5, r4, r4 */
   },
  {983ll /* 0x3d7 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {984ll /* 0x3d8 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {985ll /* 0x3d9 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* shl3add r5, r4, r1 */
   },
  {987ll /* 0x3db */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {988ll /* 0x3dc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {989ll /* 0x3dd */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {990ll /* 0x3de */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {991ll /* 0x3df */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {992ll /* 0x3e0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {993ll /* 0x3e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {994ll /* 0x3e2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* shl1add r5, r3, r4 */
   },
  {996ll /* 0x3e4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {997ll /* 0x3e5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* shl3add r4, r2, r1 */
    {4, 4, 3}}			/* shl2add r5, r4, r3 */
   },
  {999ll /* 0x3e7 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1000ll /* 0x3e8 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {1001ll /* 0x3e9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* shl2add r4, r2, r1 */
    {5, 4, 3}}			/* shl3add r5, r4, r3 */
   },
  {1003ll /* 0x3eb */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {1004ll /* 0x3ec */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {1005ll /* 0x3ed */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {1006ll /* 0x3ee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1007ll /* 0x3ef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1008ll /* 0x3f0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1009ll /* 0x3f1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {1010ll /* 0x3f2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* shl3add r5, r4, r2 */
   },
  {1011ll /* 0x3f3 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1012ll /* 0x3f4 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {1013ll /* 0x3f5 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* shl2add r5, r4, r1 */
   },
  {1014ll /* 0x3f6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1015ll /* 0x3f7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1016ll /* 0x3f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1017ll /* 0x3f9 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1018ll /* 0x3fa */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {1019ll /* 0x3fb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1020ll /* 0x3fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1021ll /* 0x3fd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1022ll /* 0x3fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1023ll /* 0x3ff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1024ll /* 0x400 */ ,
   {{6, 1, 10}}			/* shli r2, r1, 10 */
   },
  {1025ll /* 0x401 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1026ll /* 0x402 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1027ll /* 0x403 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1028ll /* 0x404 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1029ll /* 0x405 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1030ll /* 0x406 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1031ll /* 0x407 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1032ll /* 0x408 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1033ll /* 0x409 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1034ll /* 0x40a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1036ll /* 0x40c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {1040ll /* 0x410 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1041ll /* 0x411 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1042ll /* 0x412 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1044ll /* 0x414 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {1048ll /* 0x418 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {1056ll /* 0x420 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1057ll /* 0x421 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* shl2add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1060ll /* 0x424 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {1064ll /* 0x428 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {1088ll /* 0x440 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1089ll /* 0x441 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* shl3add r3, r1, r2 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1090ll /* 0x442 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {3, 3, 2}}			/* shl1add r4, r3, r2 */
   },
  {1092ll /* 0x444 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {1096ll /* 0x448 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {1152ll /* 0x480 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {1280ll /* 0x500 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {1312ll /* 0x520 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {1320ll /* 0x528 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {1344ll /* 0x540 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {1536ll /* 0x600 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {1664ll /* 0x680 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {2039ll /* 0x7f7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2040ll /* 0x7f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2041ll /* 0x7f9 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2043ll /* 0x7fb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2044ll /* 0x7fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2045ll /* 0x7fd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2046ll /* 0x7fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2047ll /* 0x7ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2048ll /* 0x800 */ ,
   {{6, 1, 11}}			/* shli r2, r1, 11 */
   },
  {2049ll /* 0x801 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2050ll /* 0x802 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2051ll /* 0x803 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2052ll /* 0x804 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2053ll /* 0x805 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2054ll /* 0x806 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2055ll /* 0x807 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2056ll /* 0x808 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2057ll /* 0x809 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2058ll /* 0x80a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2064ll /* 0x810 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2080ll /* 0x820 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2112ll /* 0x840 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2176ll /* 0x880 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2184ll /* 0x888 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {2304ll /* 0x900 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {2320ll /* 0x910 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {5, 3, 2}}			/* shl3add r4, r3, r2 */
   },
  {2560ll /* 0xa00 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {2592ll /* 0xa20 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {2880ll /* 0xb40 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {3072ll /* 0xc00 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {3328ll /* 0xd00 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {4087ll /* 0xff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4088ll /* 0xff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4089ll /* 0xff9 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4091ll /* 0xffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4092ll /* 0xffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4093ll /* 0xffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4094ll /* 0xffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4095ll /* 0xfff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4096ll /* 0x1000 */ ,
   {{6, 1, 12}}			/* shli r2, r1, 12 */
   },
  {4097ll /* 0x1001 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4098ll /* 0x1002 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4099ll /* 0x1003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4100ll /* 0x1004 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4101ll /* 0x1005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4102ll /* 0x1006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4103ll /* 0x1007 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4104ll /* 0x1008 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4105ll /* 0x1009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4106ll /* 0x100a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4108ll /* 0x100c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {4112ll /* 0x1010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4128ll /* 0x1020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4160ll /* 0x1040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4224ll /* 0x1080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4352ll /* 0x1100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4608ll /* 0x1200 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {4864ll /* 0x1300 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {3, 2, 1},			/* shl1add r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {5120ll /* 0x1400 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {6144ll /* 0x1800 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {6400ll /* 0x1900 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {6656ll /* 0x1a00 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {4, 2, 1},			/* shl2add r3, r2, r1 */
    {6, 3, 9}}			/* shli r4, r3, 9 */
   },
  {7169ll /* 0x1c01 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* shl3add r4, r2, r3 */
   },
  {8183ll /* 0x1ff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8184ll /* 0x1ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8185ll /* 0x1ff9 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {8187ll /* 0x1ffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8188ll /* 0x1ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8189ll /* 0x1ffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8190ll /* 0x1ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8191ll /* 0x1fff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8192ll /* 0x2000 */ ,
   {{6, 1, 13}}			/* shli r2, r1, 13 */
   },
  {8193ll /* 0x2001 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8194ll /* 0x2002 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {8195ll /* 0x2003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8196ll /* 0x2004 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {8197ll /* 0x2005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8198ll /* 0x2006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8199ll /* 0x2007 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {8200ll /* 0x2008 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {8201ll /* 0x2009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8202ll /* 0x200a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8204ll /* 0x200c */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {4, 2, 3}}			/* shl2add r4, r2, r3 */
   },
  {8208ll /* 0x2010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8224ll /* 0x2020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8256ll /* 0x2040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8320ll /* 0x2080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8448ll /* 0x2100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8704ll /* 0x2200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9216ll /* 0x2400 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {9217ll /* 0x2401 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {10240ll /* 0x2800 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {10248ll /* 0x2808 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {3, 1, 2},			/* shl1add r3, r1, r2 */
    {4, 3, 2}}			/* shl2add r4, r3, r2 */
   },
  {10368ll /* 0x2880 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {12288ll /* 0x3000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {16375ll /* 0x3ff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16376ll /* 0x3ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16377ll /* 0x3ff9 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {16379ll /* 0x3ffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16380ll /* 0x3ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16381ll /* 0x3ffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16382ll /* 0x3ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16383ll /* 0x3fff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16384ll /* 0x4000 */ ,
   {{6, 1, 14}}			/* shli r2, r1, 14 */
   },
  {16385ll /* 0x4001 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {16386ll /* 0x4002 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {16387ll /* 0x4003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16388ll /* 0x4004 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {16389ll /* 0x4005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16390ll /* 0x4006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {16391ll /* 0x4007 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {16392ll /* 0x4008 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {16393ll /* 0x4009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16394ll /* 0x400a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {16400ll /* 0x4010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16416ll /* 0x4020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16448ll /* 0x4040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16512ll /* 0x4080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16640ll /* 0x4100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16896ll /* 0x4200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17408ll /* 0x4400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18432ll /* 0x4800 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {20480ll /* 0x5000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {24576ll /* 0x6000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {25600ll /* 0x6400 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {5, 2, 1},			/* shl3add r3, r2, r1 */
    {6, 3, 10}}			/* shli r4, r3, 10 */
   },
  {32759ll /* 0x7ff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32760ll /* 0x7ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32761ll /* 0x7ff9 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {32763ll /* 0x7ffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32764ll /* 0x7ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32765ll /* 0x7ffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32766ll /* 0x7ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32767ll /* 0x7fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {32768ll /* 0x8000 */ ,
   {{6, 1, 15}}			/* shli r2, r1, 15 */
   },
  {32769ll /* 0x8001 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {32770ll /* 0x8002 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {32771ll /* 0x8003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32772ll /* 0x8004 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {32773ll /* 0x8005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32774ll /* 0x8006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {32775ll /* 0x8007 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {32776ll /* 0x8008 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {32777ll /* 0x8009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32778ll /* 0x800a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {32784ll /* 0x8010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32800ll /* 0x8020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32832ll /* 0x8040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32896ll /* 0x8080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33024ll /* 0x8100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33280ll /* 0x8200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33792ll /* 0x8400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34816ll /* 0x8800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36864ll /* 0x9000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {40960ll /* 0xa000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {49152ll /* 0xc000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {65527ll /* 0xfff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65528ll /* 0xfff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65529ll /* 0xfff9 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {65531ll /* 0xfffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65532ll /* 0xfffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65533ll /* 0xfffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65534ll /* 0xfffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65535ll /* 0xffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {65536ll /* 0x10000 */ ,
   {{6, 1, 16}}			/* shli r2, r1, 16 */
   },
  {65537ll /* 0x10001 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {65538ll /* 0x10002 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {65539ll /* 0x10003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65540ll /* 0x10004 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {65541ll /* 0x10005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65542ll /* 0x10006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {65543ll /* 0x10007 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {65544ll /* 0x10008 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {65545ll /* 0x10009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65546ll /* 0x1000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {65552ll /* 0x10010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65568ll /* 0x10020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65600ll /* 0x10040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65664ll /* 0x10080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65792ll /* 0x10100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {66048ll /* 0x10200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {66560ll /* 0x10400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67584ll /* 0x10800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69632ll /* 0x11000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {73728ll /* 0x12000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {81920ll /* 0x14000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {98304ll /* 0x18000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {131063ll /* 0x1fff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131064ll /* 0x1fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131065ll /* 0x1fff9 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {131067ll /* 0x1fffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131068ll /* 0x1fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131069ll /* 0x1fffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131070ll /* 0x1fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131071ll /* 0x1ffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {131072ll /* 0x20000 */ ,
   {{6, 1, 17}}			/* shli r2, r1, 17 */
   },
  {131073ll /* 0x20001 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {131074ll /* 0x20002 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {131075ll /* 0x20003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131076ll /* 0x20004 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {131077ll /* 0x20005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131078ll /* 0x20006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {131079ll /* 0x20007 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {131080ll /* 0x20008 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {131081ll /* 0x20009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131082ll /* 0x2000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {131088ll /* 0x20010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131104ll /* 0x20020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131136ll /* 0x20040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131200ll /* 0x20080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131328ll /* 0x20100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131584ll /* 0x20200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {132096ll /* 0x20400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {133120ll /* 0x20800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {135168ll /* 0x21000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {139264ll /* 0x22000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {147456ll /* 0x24000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {163840ll /* 0x28000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {196608ll /* 0x30000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {262135ll /* 0x3fff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262136ll /* 0x3fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262137ll /* 0x3fff9 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {262139ll /* 0x3fffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262140ll /* 0x3fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262141ll /* 0x3fffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262142ll /* 0x3fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262143ll /* 0x3ffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {262144ll /* 0x40000 */ ,
   {{6, 1, 18}}			/* shli r2, r1, 18 */
   },
  {262145ll /* 0x40001 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {262146ll /* 0x40002 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {262147ll /* 0x40003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262148ll /* 0x40004 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {262149ll /* 0x40005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262150ll /* 0x40006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {262151ll /* 0x40007 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {262152ll /* 0x40008 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {262153ll /* 0x40009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262154ll /* 0x4000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {262160ll /* 0x40010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262176ll /* 0x40020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262208ll /* 0x40040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262272ll /* 0x40080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262400ll /* 0x40100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262656ll /* 0x40200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {263168ll /* 0x40400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {264192ll /* 0x40800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {266240ll /* 0x41000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {270336ll /* 0x42000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {278528ll /* 0x44000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {294912ll /* 0x48000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {327680ll /* 0x50000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {393216ll /* 0x60000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {524279ll /* 0x7fff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524280ll /* 0x7fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524281ll /* 0x7fff9 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {524283ll /* 0x7fffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524284ll /* 0x7fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524285ll /* 0x7fffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524286ll /* 0x7fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524287ll /* 0x7ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {524288ll /* 0x80000 */ ,
   {{6, 1, 19}}			/* shli r2, r1, 19 */
   },
  {524289ll /* 0x80001 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {524290ll /* 0x80002 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {524291ll /* 0x80003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524292ll /* 0x80004 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {524293ll /* 0x80005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524294ll /* 0x80006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {524295ll /* 0x80007 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {524296ll /* 0x80008 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {524297ll /* 0x80009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524298ll /* 0x8000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {524304ll /* 0x80010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524320ll /* 0x80020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524352ll /* 0x80040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524416ll /* 0x80080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524544ll /* 0x80100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524800ll /* 0x80200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {525312ll /* 0x80400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {526336ll /* 0x80800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {528384ll /* 0x81000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {532480ll /* 0x82000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {540672ll /* 0x84000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {557056ll /* 0x88000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {589824ll /* 0x90000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {655360ll /* 0xa0000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {786432ll /* 0xc0000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {1048567ll /* 0xffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048568ll /* 0xffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048569ll /* 0xffff9 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1048571ll /* 0xffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048572ll /* 0xffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048573ll /* 0xffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048574ll /* 0xffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048575ll /* 0xfffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1048576ll /* 0x100000 */ ,
   {{6, 1, 20}}			/* shli r2, r1, 20 */
   },
  {1048577ll /* 0x100001 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1048578ll /* 0x100002 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1048579ll /* 0x100003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048580ll /* 0x100004 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1048581ll /* 0x100005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048582ll /* 0x100006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1048583ll /* 0x100007 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1048584ll /* 0x100008 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1048585ll /* 0x100009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048586ll /* 0x10000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1048592ll /* 0x100010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048608ll /* 0x100020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048640ll /* 0x100040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048704ll /* 0x100080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048832ll /* 0x100100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1049088ll /* 0x100200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1049600ll /* 0x100400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1050624ll /* 0x100800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1052672ll /* 0x101000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1056768ll /* 0x102000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1064960ll /* 0x104000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1081344ll /* 0x108000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1114112ll /* 0x110000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1179648ll /* 0x120000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {1310720ll /* 0x140000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {1572864ll /* 0x180000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {2097143ll /* 0x1ffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097144ll /* 0x1ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097145ll /* 0x1ffff9 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2097147ll /* 0x1ffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097148ll /* 0x1ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097149ll /* 0x1ffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097150ll /* 0x1ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097151ll /* 0x1fffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2097152ll /* 0x200000 */ ,
   {{6, 1, 21}}			/* shli r2, r1, 21 */
   },
  {2097153ll /* 0x200001 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2097154ll /* 0x200002 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2097155ll /* 0x200003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097156ll /* 0x200004 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2097157ll /* 0x200005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097158ll /* 0x200006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2097159ll /* 0x200007 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2097160ll /* 0x200008 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2097161ll /* 0x200009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097162ll /* 0x20000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2097168ll /* 0x200010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097184ll /* 0x200020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097216ll /* 0x200040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097280ll /* 0x200080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097408ll /* 0x200100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097664ll /* 0x200200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2098176ll /* 0x200400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2099200ll /* 0x200800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2101248ll /* 0x201000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2105344ll /* 0x202000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2113536ll /* 0x204000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2129920ll /* 0x208000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2162688ll /* 0x210000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2228224ll /* 0x220000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2359296ll /* 0x240000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {2621440ll /* 0x280000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {3145728ll /* 0x300000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {4194295ll /* 0x3ffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194296ll /* 0x3ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194297ll /* 0x3ffff9 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4194299ll /* 0x3ffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194300ll /* 0x3ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194301ll /* 0x3ffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194302ll /* 0x3ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194303ll /* 0x3fffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4194304ll /* 0x400000 */ ,
   {{6, 1, 22}}			/* shli r2, r1, 22 */
   },
  {4194305ll /* 0x400001 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4194306ll /* 0x400002 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4194307ll /* 0x400003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194308ll /* 0x400004 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4194309ll /* 0x400005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194310ll /* 0x400006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4194311ll /* 0x400007 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4194312ll /* 0x400008 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4194313ll /* 0x400009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194314ll /* 0x40000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4194320ll /* 0x400010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194336ll /* 0x400020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194368ll /* 0x400040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194432ll /* 0x400080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194560ll /* 0x400100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194816ll /* 0x400200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4195328ll /* 0x400400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4196352ll /* 0x400800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4198400ll /* 0x401000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4202496ll /* 0x402000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4210688ll /* 0x404000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4227072ll /* 0x408000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4259840ll /* 0x410000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4325376ll /* 0x420000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4456448ll /* 0x440000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4718592ll /* 0x480000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {5242880ll /* 0x500000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {6291456ll /* 0x600000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {8388599ll /* 0x7ffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388600ll /* 0x7ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388601ll /* 0x7ffff9 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {8388603ll /* 0x7ffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388604ll /* 0x7ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388605ll /* 0x7ffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388606ll /* 0x7ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388607ll /* 0x7fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8388608ll /* 0x800000 */ ,
   {{6, 1, 23}}			/* shli r2, r1, 23 */
   },
  {8388609ll /* 0x800001 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8388610ll /* 0x800002 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {8388611ll /* 0x800003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388612ll /* 0x800004 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {8388613ll /* 0x800005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388614ll /* 0x800006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8388615ll /* 0x800007 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {8388616ll /* 0x800008 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {8388617ll /* 0x800009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388618ll /* 0x80000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8388624ll /* 0x800010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388640ll /* 0x800020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388672ll /* 0x800040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388736ll /* 0x800080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388864ll /* 0x800100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8389120ll /* 0x800200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8389632ll /* 0x800400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8390656ll /* 0x800800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8392704ll /* 0x801000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8396800ll /* 0x802000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8404992ll /* 0x804000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8421376ll /* 0x808000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8454144ll /* 0x810000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8519680ll /* 0x820000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8650752ll /* 0x840000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8912896ll /* 0x880000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9437184ll /* 0x900000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {10485760ll /* 0xa00000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {11796480ll /* 0xb40000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 18}}			/* shli r4, r3, 18 */
   },
  {12582912ll /* 0xc00000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {16777207ll /* 0xfffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777208ll /* 0xfffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777209ll /* 0xfffff9 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {16777211ll /* 0xfffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777212ll /* 0xfffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777213ll /* 0xfffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777214ll /* 0xfffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777215ll /* 0xffffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16777216ll /* 0x1000000 */ ,
   {{6, 1, 24}}			/* shli r2, r1, 24 */
   },
  {16777217ll /* 0x1000001 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {16777218ll /* 0x1000002 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {16777219ll /* 0x1000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777220ll /* 0x1000004 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {16777221ll /* 0x1000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777222ll /* 0x1000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {16777223ll /* 0x1000007 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {16777224ll /* 0x1000008 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {16777225ll /* 0x1000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777226ll /* 0x100000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {16777232ll /* 0x1000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777248ll /* 0x1000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777280ll /* 0x1000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777344ll /* 0x1000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777472ll /* 0x1000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777728ll /* 0x1000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16778240ll /* 0x1000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16779264ll /* 0x1000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16781312ll /* 0x1001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16785408ll /* 0x1002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16793600ll /* 0x1004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16809984ll /* 0x1008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16842752ll /* 0x1010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16908288ll /* 0x1020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17039360ll /* 0x1040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17301504ll /* 0x1080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17825792ll /* 0x1100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18874368ll /* 0x1200000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {20971520ll /* 0x1400000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {23592960ll /* 0x1680000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {5, 2, 2},			/* shl3add r3, r2, r2 */
    {6, 3, 19}}			/* shli r4, r3, 19 */
   },
  {25165824ll /* 0x1800000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {33554423ll /* 0x1fffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554424ll /* 0x1fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554425ll /* 0x1fffff9 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {33554427ll /* 0x1fffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554428ll /* 0x1fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554429ll /* 0x1fffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554430ll /* 0x1fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554431ll /* 0x1ffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {33554432ll /* 0x2000000 */ ,
   {{6, 1, 25}}			/* shli r2, r1, 25 */
   },
  {33554433ll /* 0x2000001 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {33554434ll /* 0x2000002 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {33554435ll /* 0x2000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554436ll /* 0x2000004 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {33554437ll /* 0x2000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554438ll /* 0x2000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {33554439ll /* 0x2000007 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {33554440ll /* 0x2000008 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {33554441ll /* 0x2000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554442ll /* 0x200000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {33554448ll /* 0x2000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554464ll /* 0x2000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554496ll /* 0x2000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554560ll /* 0x2000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554688ll /* 0x2000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554944ll /* 0x2000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33555456ll /* 0x2000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33556480ll /* 0x2000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33558528ll /* 0x2001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33562624ll /* 0x2002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33570816ll /* 0x2004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33587200ll /* 0x2008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33619968ll /* 0x2010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33685504ll /* 0x2020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33816576ll /* 0x2040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34078720ll /* 0x2080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34603008ll /* 0x2100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35651584ll /* 0x2200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {37748736ll /* 0x2400000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {41943040ll /* 0x2800000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {50331648ll /* 0x3000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {67108855ll /* 0x3fffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108856ll /* 0x3fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108857ll /* 0x3fffff9 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {67108859ll /* 0x3fffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108860ll /* 0x3fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108861ll /* 0x3fffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108862ll /* 0x3fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108863ll /* 0x3ffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {67108864ll /* 0x4000000 */ ,
   {{6, 1, 26}}			/* shli r2, r1, 26 */
   },
  {67108865ll /* 0x4000001 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {67108866ll /* 0x4000002 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {67108867ll /* 0x4000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108868ll /* 0x4000004 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {67108869ll /* 0x4000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108870ll /* 0x4000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {67108871ll /* 0x4000007 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {67108872ll /* 0x4000008 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {67108873ll /* 0x4000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108874ll /* 0x400000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {67108880ll /* 0x4000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108896ll /* 0x4000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108928ll /* 0x4000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108992ll /* 0x4000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109120ll /* 0x4000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109376ll /* 0x4000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109888ll /* 0x4000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67110912ll /* 0x4000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67112960ll /* 0x4001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67117056ll /* 0x4002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67125248ll /* 0x4004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67141632ll /* 0x4008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67174400ll /* 0x4010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67239936ll /* 0x4020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67371008ll /* 0x4040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67633152ll /* 0x4080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68157440ll /* 0x4100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69206016ll /* 0x4200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {71303168ll /* 0x4400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {75497472ll /* 0x4800000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {83886080ll /* 0x5000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {100663296ll /* 0x6000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {134217719ll /* 0x7fffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217720ll /* 0x7fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217721ll /* 0x7fffff9 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {134217723ll /* 0x7fffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217724ll /* 0x7fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217725ll /* 0x7fffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217726ll /* 0x7fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217727ll /* 0x7ffffff */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {134217728ll /* 0x8000000 */ ,
   {{6, 1, 27}}			/* shli r2, r1, 27 */
   },
  {134217729ll /* 0x8000001 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {134217730ll /* 0x8000002 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {134217731ll /* 0x8000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217732ll /* 0x8000004 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {134217733ll /* 0x8000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217734ll /* 0x8000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {134217735ll /* 0x8000007 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {134217736ll /* 0x8000008 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {134217737ll /* 0x8000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217738ll /* 0x800000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {134217744ll /* 0x8000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217760ll /* 0x8000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217792ll /* 0x8000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217856ll /* 0x8000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217984ll /* 0x8000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134218240ll /* 0x8000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134218752ll /* 0x8000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134219776ll /* 0x8000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134221824ll /* 0x8001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134225920ll /* 0x8002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134234112ll /* 0x8004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134250496ll /* 0x8008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134283264ll /* 0x8010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134348800ll /* 0x8020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134479872ll /* 0x8040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134742016ll /* 0x8080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {135266304ll /* 0x8100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {136314880ll /* 0x8200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {138412032ll /* 0x8400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {142606336ll /* 0x8800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {150994944ll /* 0x9000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {167772160ll /* 0xa000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {201326592ll /* 0xc000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {268435447ll /* 0xffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435448ll /* 0xffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435449ll /* 0xffffff9 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {268435451ll /* 0xffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435452ll /* 0xffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435453ll /* 0xffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435454ll /* 0xffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435455ll /* 0xfffffff */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {268435456ll /* 0x10000000 */ ,
   {{6, 1, 28}}			/* shli r2, r1, 28 */
   },
  {268435457ll /* 0x10000001 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {268435458ll /* 0x10000002 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {268435459ll /* 0x10000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435460ll /* 0x10000004 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {268435461ll /* 0x10000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435462ll /* 0x10000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {268435463ll /* 0x10000007 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {268435464ll /* 0x10000008 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {268435465ll /* 0x10000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435466ll /* 0x1000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {268435472ll /* 0x10000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435488ll /* 0x10000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435520ll /* 0x10000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435584ll /* 0x10000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435712ll /* 0x10000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435968ll /* 0x10000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268436480ll /* 0x10000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268437504ll /* 0x10000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268439552ll /* 0x10001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268443648ll /* 0x10002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268451840ll /* 0x10004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268468224ll /* 0x10008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268500992ll /* 0x10010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268566528ll /* 0x10020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268697600ll /* 0x10040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268959744ll /* 0x10080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {269484032ll /* 0x10100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {270532608ll /* 0x10200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {272629760ll /* 0x10400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {276824064ll /* 0x10800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {285212672ll /* 0x11000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {301989888ll /* 0x12000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {335544320ll /* 0x14000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {402653184ll /* 0x18000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {536870903ll /* 0x1ffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870904ll /* 0x1ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870905ll /* 0x1ffffff9 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {536870907ll /* 0x1ffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870908ll /* 0x1ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870909ll /* 0x1ffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870910ll /* 0x1ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870911ll /* 0x1fffffff */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {536870912ll /* 0x20000000 */ ,
   {{6, 1, 29}}			/* shli r2, r1, 29 */
   },
  {536870913ll /* 0x20000001 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {536870914ll /* 0x20000002 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {536870915ll /* 0x20000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870916ll /* 0x20000004 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {536870917ll /* 0x20000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870918ll /* 0x20000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {536870919ll /* 0x20000007 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {536870920ll /* 0x20000008 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {536870921ll /* 0x20000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870922ll /* 0x2000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {536870928ll /* 0x20000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870944ll /* 0x20000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870976ll /* 0x20000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871040ll /* 0x20000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871168ll /* 0x20000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871424ll /* 0x20000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871936ll /* 0x20000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536872960ll /* 0x20000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536875008ll /* 0x20001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536879104ll /* 0x20002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536887296ll /* 0x20004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536903680ll /* 0x20008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536936448ll /* 0x20010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537001984ll /* 0x20020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537133056ll /* 0x20040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537395200ll /* 0x20080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537919488ll /* 0x20100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {538968064ll /* 0x20200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {541065216ll /* 0x20400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {545259520ll /* 0x20800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {553648128ll /* 0x21000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {570425344ll /* 0x22000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {603979776ll /* 0x24000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {671088640ll /* 0x28000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {805306368ll /* 0x30000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {1073741815ll /* 0x3ffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741816ll /* 0x3ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741817ll /* 0x3ffffff9 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1073741819ll /* 0x3ffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741820ll /* 0x3ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741821ll /* 0x3ffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741822ll /* 0x3ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741823ll /* 0x3fffffff */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1073741824ll /* 0x40000000 */ ,
   {{6, 1, 30}}			/* shli r2, r1, 30 */
   },
  {1073741825ll /* 0x40000001 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1073741826ll /* 0x40000002 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1073741827ll /* 0x40000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741828ll /* 0x40000004 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1073741829ll /* 0x40000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741830ll /* 0x40000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1073741831ll /* 0x40000007 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1073741832ll /* 0x40000008 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1073741833ll /* 0x40000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741834ll /* 0x4000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1073741840ll /* 0x40000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741856ll /* 0x40000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741888ll /* 0x40000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741952ll /* 0x40000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742080ll /* 0x40000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742336ll /* 0x40000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742848ll /* 0x40000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073743872ll /* 0x40000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073745920ll /* 0x40001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073750016ll /* 0x40002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073758208ll /* 0x40004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073774592ll /* 0x40008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073807360ll /* 0x40010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073872896ll /* 0x40020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074003968ll /* 0x40040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074266112ll /* 0x40080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074790400ll /* 0x40100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1075838976ll /* 0x40200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1077936128ll /* 0x40400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1082130432ll /* 0x40800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1090519040ll /* 0x41000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1107296256ll /* 0x42000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1140850688ll /* 0x44000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1207959552ll /* 0x48000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {1342177280ll /* 0x50000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {1610612736ll /* 0x60000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {2147483639ll /* 0x7ffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483640ll /* 0x7ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483641ll /* 0x7ffffff9 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2147483643ll /* 0x7ffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483644ll /* 0x7ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483645ll /* 0x7ffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483646ll /* 0x7ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483647ll /* 0x7fffffff */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2147483648ll /* 0x80000000 */ ,
   {{6, 1, 31}}			/* shli r2, r1, 31 */
   },
  {2147483649ll /* 0x80000001 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2147483650ll /* 0x80000002 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2147483651ll /* 0x80000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483652ll /* 0x80000004 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2147483653ll /* 0x80000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483654ll /* 0x80000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2147483655ll /* 0x80000007 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2147483656ll /* 0x80000008 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2147483657ll /* 0x80000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483658ll /* 0x8000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2147483664ll /* 0x80000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483680ll /* 0x80000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483712ll /* 0x80000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483776ll /* 0x80000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147483904ll /* 0x80000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147484160ll /* 0x80000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147484672ll /* 0x80000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147485696ll /* 0x80000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147487744ll /* 0x80001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147491840ll /* 0x80002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147500032ll /* 0x80004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147516416ll /* 0x80008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147549184ll /* 0x80010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147614720ll /* 0x80020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2147745792ll /* 0x80040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2148007936ll /* 0x80080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2148532224ll /* 0x80100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2149580800ll /* 0x80200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2151677952ll /* 0x80400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2155872256ll /* 0x80800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2164260864ll /* 0x81000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2181038080ll /* 0x82000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2214592512ll /* 0x84000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2281701376ll /* 0x88000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2415919104ll /* 0x90000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {2684354560ll /* 0xa0000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {3221225472ll /* 0xc0000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 30}}			/* shli r3, r2, 30 */
   },
  {4294967287ll /* 0xfffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967288ll /* 0xfffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967289ll /* 0xfffffff9 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4294967291ll /* 0xfffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967292ll /* 0xfffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967293ll /* 0xfffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967294ll /* 0xfffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4294967295ll /* 0xffffffff */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4294967296ll /* 0x100000000 */ ,
   {{6, 1, 32}}			/* shli r2, r1, 32 */
   },
  {4294967297ll /* 0x100000001 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4294967298ll /* 0x100000002 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4294967299ll /* 0x100000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967300ll /* 0x100000004 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4294967301ll /* 0x100000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967302ll /* 0x100000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4294967303ll /* 0x100000007 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4294967304ll /* 0x100000008 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4294967305ll /* 0x100000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967306ll /* 0x10000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4294967312ll /* 0x100000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967328ll /* 0x100000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967360ll /* 0x100000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967424ll /* 0x100000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967552ll /* 0x100000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294967808ll /* 0x100000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294968320ll /* 0x100000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294969344ll /* 0x100000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294971392ll /* 0x100001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294975488ll /* 0x100002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4294983680ll /* 0x100004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4295000064ll /* 0x100008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4295032832ll /* 0x100010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4295098368ll /* 0x100020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4295229440ll /* 0x100040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4295491584ll /* 0x100080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4296015872ll /* 0x100100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4297064448ll /* 0x100200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4299161600ll /* 0x100400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4303355904ll /* 0x100800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4311744512ll /* 0x101000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4328521728ll /* 0x102000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4362076160ll /* 0x104000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4429185024ll /* 0x108000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4563402752ll /* 0x110000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 32},			/* shli r3, r1, 32 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4831838208ll /* 0x120000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {5368709120ll /* 0x140000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 30}}			/* shli r3, r2, 30 */
   },
  {6442450944ll /* 0x180000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 31}}			/* shli r3, r2, 31 */
   },
  {8589934583ll /* 0x1fffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934584ll /* 0x1fffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934585ll /* 0x1fffffff9 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {8589934587ll /* 0x1fffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934588ll /* 0x1fffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934589ll /* 0x1fffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934590ll /* 0x1fffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8589934591ll /* 0x1ffffffff */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8589934592ll /* 0x200000000 */ ,
   {{6, 1, 33}}			/* shli r2, r1, 33 */
   },
  {8589934593ll /* 0x200000001 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8589934594ll /* 0x200000002 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {8589934595ll /* 0x200000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934596ll /* 0x200000004 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {8589934597ll /* 0x200000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934598ll /* 0x200000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8589934599ll /* 0x200000007 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {8589934600ll /* 0x200000008 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {8589934601ll /* 0x200000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934602ll /* 0x20000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8589934608ll /* 0x200000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934624ll /* 0x200000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934656ll /* 0x200000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934720ll /* 0x200000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589934848ll /* 0x200000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589935104ll /* 0x200000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589935616ll /* 0x200000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589936640ll /* 0x200000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589938688ll /* 0x200001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589942784ll /* 0x200002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589950976ll /* 0x200004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8589967360ll /* 0x200008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8590000128ll /* 0x200010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8590065664ll /* 0x200020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8590196736ll /* 0x200040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8590458880ll /* 0x200080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8590983168ll /* 0x200100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8592031744ll /* 0x200200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8594128896ll /* 0x200400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8598323200ll /* 0x200800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8606711808ll /* 0x201000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8623489024ll /* 0x202000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8657043456ll /* 0x204000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8724152320ll /* 0x208000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8858370048ll /* 0x210000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9126805504ll /* 0x220000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 33},			/* shli r3, r1, 33 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9663676416ll /* 0x240000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 30}}			/* shli r3, r2, 30 */
   },
  {10737418240ll /* 0x280000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 31}}			/* shli r3, r2, 31 */
   },
  {12884901888ll /* 0x300000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 32}}			/* shli r3, r2, 32 */
   },
  {17179869175ll /* 0x3fffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869176ll /* 0x3fffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869177ll /* 0x3fffffff9 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {17179869179ll /* 0x3fffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869180ll /* 0x3fffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869181ll /* 0x3fffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869182ll /* 0x3fffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17179869183ll /* 0x3ffffffff */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {17179869184ll /* 0x400000000 */ ,
   {{6, 1, 34}}			/* shli r2, r1, 34 */
   },
  {17179869185ll /* 0x400000001 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {17179869186ll /* 0x400000002 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {17179869187ll /* 0x400000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869188ll /* 0x400000004 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {17179869189ll /* 0x400000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869190ll /* 0x400000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {17179869191ll /* 0x400000007 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {17179869192ll /* 0x400000008 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {17179869193ll /* 0x400000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869194ll /* 0x40000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {17179869200ll /* 0x400000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869216ll /* 0x400000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869248ll /* 0x400000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869312ll /* 0x400000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869440ll /* 0x400000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179869696ll /* 0x400000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179870208ll /* 0x400000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179871232ll /* 0x400000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179873280ll /* 0x400001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179877376ll /* 0x400002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179885568ll /* 0x400004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179901952ll /* 0x400008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17179934720ll /* 0x400010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17180000256ll /* 0x400020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17180131328ll /* 0x400040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17180393472ll /* 0x400080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17180917760ll /* 0x400100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17181966336ll /* 0x400200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17184063488ll /* 0x400400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17188257792ll /* 0x400800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17196646400ll /* 0x401000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17213423616ll /* 0x402000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17246978048ll /* 0x404000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17314086912ll /* 0x408000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17448304640ll /* 0x410000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17716740096ll /* 0x420000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18253611008ll /* 0x440000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 34},			/* shli r3, r1, 34 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {19327352832ll /* 0x480000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 31}}			/* shli r3, r2, 31 */
   },
  {21474836480ll /* 0x500000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 32}}			/* shli r3, r2, 32 */
   },
  {25769803776ll /* 0x600000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 33}}			/* shli r3, r2, 33 */
   },
  {34359738359ll /* 0x7fffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738360ll /* 0x7fffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738361ll /* 0x7fffffff9 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {34359738363ll /* 0x7fffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738364ll /* 0x7fffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738365ll /* 0x7fffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738366ll /* 0x7fffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {34359738367ll /* 0x7ffffffff */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {34359738368ll /* 0x800000000 */ ,
   {{6, 1, 35}}			/* shli r2, r1, 35 */
   },
  {34359738369ll /* 0x800000001 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {34359738370ll /* 0x800000002 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {34359738371ll /* 0x800000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738372ll /* 0x800000004 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {34359738373ll /* 0x800000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738374ll /* 0x800000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {34359738375ll /* 0x800000007 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {34359738376ll /* 0x800000008 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {34359738377ll /* 0x800000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738378ll /* 0x80000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {34359738384ll /* 0x800000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738400ll /* 0x800000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738432ll /* 0x800000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738496ll /* 0x800000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738624ll /* 0x800000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359738880ll /* 0x800000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359739392ll /* 0x800000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359740416ll /* 0x800000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359742464ll /* 0x800001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359746560ll /* 0x800002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359754752ll /* 0x800004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359771136ll /* 0x800008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359803904ll /* 0x800010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34359869440ll /* 0x800020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34360000512ll /* 0x800040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34360262656ll /* 0x800080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34360786944ll /* 0x800100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34361835520ll /* 0x800200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34363932672ll /* 0x800400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34368126976ll /* 0x800800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34376515584ll /* 0x801000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34393292800ll /* 0x802000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34426847232ll /* 0x804000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34493956096ll /* 0x808000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34628173824ll /* 0x810000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34896609280ll /* 0x820000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35433480192ll /* 0x840000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36507222016ll /* 0x880000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 35},			/* shli r3, r1, 35 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {38654705664ll /* 0x900000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 32}}			/* shli r3, r2, 32 */
   },
  {42949672960ll /* 0xa00000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 33}}			/* shli r3, r2, 33 */
   },
  {51539607552ll /* 0xc00000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 34}}			/* shli r3, r2, 34 */
   },
  {68719476727ll /* 0xffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476728ll /* 0xffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476729ll /* 0xffffffff9 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {68719476731ll /* 0xffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476732ll /* 0xffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476733ll /* 0xffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476734ll /* 0xffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {68719476735ll /* 0xfffffffff */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {68719476736ll /* 0x1000000000 */ ,
   {{6, 1, 36}}			/* shli r2, r1, 36 */
   },
  {68719476737ll /* 0x1000000001 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {68719476738ll /* 0x1000000002 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {68719476739ll /* 0x1000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476740ll /* 0x1000000004 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {68719476741ll /* 0x1000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476742ll /* 0x1000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {68719476743ll /* 0x1000000007 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {68719476744ll /* 0x1000000008 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {68719476745ll /* 0x1000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476746ll /* 0x100000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {68719476752ll /* 0x1000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476768ll /* 0x1000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476800ll /* 0x1000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476864ll /* 0x1000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719476992ll /* 0x1000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719477248ll /* 0x1000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719477760ll /* 0x1000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719478784ll /* 0x1000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719480832ll /* 0x1000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719484928ll /* 0x1000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719493120ll /* 0x1000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719509504ll /* 0x1000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719542272ll /* 0x1000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719607808ll /* 0x1000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68719738880ll /* 0x1000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68720001024ll /* 0x1000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68720525312ll /* 0x1000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68721573888ll /* 0x1000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68723671040ll /* 0x1000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68727865344ll /* 0x1000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68736253952ll /* 0x1001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68753031168ll /* 0x1002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68786585600ll /* 0x1004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68853694464ll /* 0x1008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68987912192ll /* 0x1010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69256347648ll /* 0x1020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69793218560ll /* 0x1040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70866960384ll /* 0x1080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {73014444032ll /* 0x1100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 36},			/* shli r3, r1, 36 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {77309411328ll /* 0x1200000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 33}}			/* shli r3, r2, 33 */
   },
  {85899345920ll /* 0x1400000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 34}}			/* shli r3, r2, 34 */
   },
  {103079215104ll /* 0x1800000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 35}}			/* shli r3, r2, 35 */
   },
  {137438953463ll /* 0x1ffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953464ll /* 0x1ffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953465ll /* 0x1ffffffff9 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {137438953467ll /* 0x1ffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953468ll /* 0x1ffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953469ll /* 0x1ffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953470ll /* 0x1ffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {137438953471ll /* 0x1fffffffff */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {137438953472ll /* 0x2000000000 */ ,
   {{6, 1, 37}}			/* shli r2, r1, 37 */
   },
  {137438953473ll /* 0x2000000001 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {137438953474ll /* 0x2000000002 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {137438953475ll /* 0x2000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953476ll /* 0x2000000004 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {137438953477ll /* 0x2000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953478ll /* 0x2000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {137438953479ll /* 0x2000000007 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {137438953480ll /* 0x2000000008 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {137438953481ll /* 0x2000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953482ll /* 0x200000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {137438953488ll /* 0x2000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953504ll /* 0x2000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953536ll /* 0x2000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953600ll /* 0x2000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953728ll /* 0x2000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438953984ll /* 0x2000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438954496ll /* 0x2000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438955520ll /* 0x2000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438957568ll /* 0x2000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438961664ll /* 0x2000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438969856ll /* 0x2000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137438986240ll /* 0x2000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137439019008ll /* 0x2000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137439084544ll /* 0x2000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137439215616ll /* 0x2000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137439477760ll /* 0x2000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137440002048ll /* 0x2000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137441050624ll /* 0x2000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137443147776ll /* 0x2000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137447342080ll /* 0x2000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137455730688ll /* 0x2001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137472507904ll /* 0x2002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137506062336ll /* 0x2004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137573171200ll /* 0x2008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137707388928ll /* 0x2010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {137975824384ll /* 0x2020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {138512695296ll /* 0x2040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {139586437120ll /* 0x2080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {141733920768ll /* 0x2100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {146028888064ll /* 0x2200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 37},			/* shli r3, r1, 37 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {154618822656ll /* 0x2400000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 34}}			/* shli r3, r2, 34 */
   },
  {171798691840ll /* 0x2800000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 35}}			/* shli r3, r2, 35 */
   },
  {206158430208ll /* 0x3000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 36}}			/* shli r3, r2, 36 */
   },
  {274877906935ll /* 0x3ffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906936ll /* 0x3ffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906937ll /* 0x3ffffffff9 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {274877906939ll /* 0x3ffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906940ll /* 0x3ffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906941ll /* 0x3ffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906942ll /* 0x3ffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {274877906943ll /* 0x3fffffffff */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {274877906944ll /* 0x4000000000 */ ,
   {{6, 1, 38}}			/* shli r2, r1, 38 */
   },
  {274877906945ll /* 0x4000000001 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {274877906946ll /* 0x4000000002 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {274877906947ll /* 0x4000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877906948ll /* 0x4000000004 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {274877906949ll /* 0x4000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877906950ll /* 0x4000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {274877906951ll /* 0x4000000007 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {274877906952ll /* 0x4000000008 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {274877906953ll /* 0x4000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877906954ll /* 0x400000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {274877906960ll /* 0x4000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877906976ll /* 0x4000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877907008ll /* 0x4000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877907072ll /* 0x4000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877907200ll /* 0x4000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877907456ll /* 0x4000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877907968ll /* 0x4000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877908992ll /* 0x4000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877911040ll /* 0x4000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877915136ll /* 0x4000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877923328ll /* 0x4000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877939712ll /* 0x4000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274877972480ll /* 0x4000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274878038016ll /* 0x4000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274878169088ll /* 0x4000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274878431232ll /* 0x4000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274878955520ll /* 0x4000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274880004096ll /* 0x4000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274882101248ll /* 0x4000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274886295552ll /* 0x4000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274894684160ll /* 0x4001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274911461376ll /* 0x4002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {274945015808ll /* 0x4004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {275012124672ll /* 0x4008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {275146342400ll /* 0x4010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {275414777856ll /* 0x4020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {275951648768ll /* 0x4040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {277025390592ll /* 0x4080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {279172874240ll /* 0x4100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {283467841536ll /* 0x4200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {292057776128ll /* 0x4400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 38},			/* shli r3, r1, 38 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {309237645312ll /* 0x4800000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 35}}			/* shli r3, r2, 35 */
   },
  {343597383680ll /* 0x5000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 36}}			/* shli r3, r2, 36 */
   },
  {412316860416ll /* 0x6000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 37}}			/* shli r3, r2, 37 */
   },
  {549755813879ll /* 0x7ffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813880ll /* 0x7ffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813881ll /* 0x7ffffffff9 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {549755813883ll /* 0x7ffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813884ll /* 0x7ffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813885ll /* 0x7ffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813886ll /* 0x7ffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {549755813887ll /* 0x7fffffffff */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {549755813888ll /* 0x8000000000 */ ,
   {{6, 1, 39}}			/* shli r2, r1, 39 */
   },
  {549755813889ll /* 0x8000000001 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {549755813890ll /* 0x8000000002 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {549755813891ll /* 0x8000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755813892ll /* 0x8000000004 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {549755813893ll /* 0x8000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755813894ll /* 0x8000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {549755813895ll /* 0x8000000007 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {549755813896ll /* 0x8000000008 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {549755813897ll /* 0x8000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755813898ll /* 0x800000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {549755813904ll /* 0x8000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755813920ll /* 0x8000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755813952ll /* 0x8000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755814016ll /* 0x8000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755814144ll /* 0x8000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755814400ll /* 0x8000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755814912ll /* 0x8000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755815936ll /* 0x8000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755817984ll /* 0x8000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755822080ll /* 0x8000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755830272ll /* 0x8000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755846656ll /* 0x8000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755879424ll /* 0x8000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549755944960ll /* 0x8000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549756076032ll /* 0x8000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549756338176ll /* 0x8000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549756862464ll /* 0x8000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549757911040ll /* 0x8000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549760008192ll /* 0x8000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549764202496ll /* 0x8000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549772591104ll /* 0x8001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549789368320ll /* 0x8002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549822922752ll /* 0x8004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {549890031616ll /* 0x8008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {550024249344ll /* 0x8010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {550292684800ll /* 0x8020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {550829555712ll /* 0x8040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {551903297536ll /* 0x8080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {554050781184ll /* 0x8100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {558345748480ll /* 0x8200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {566935683072ll /* 0x8400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {584115552256ll /* 0x8800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 39},			/* shli r3, r1, 39 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {618475290624ll /* 0x9000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 36}}			/* shli r3, r2, 36 */
   },
  {687194767360ll /* 0xa000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 37}}			/* shli r3, r2, 37 */
   },
  {824633720832ll /* 0xc000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 38}}			/* shli r3, r2, 38 */
   },
  {1099511627767ll /* 0xfffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627768ll /* 0xfffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627769ll /* 0xfffffffff9 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1099511627771ll /* 0xfffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627772ll /* 0xfffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627773ll /* 0xfffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627774ll /* 0xfffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1099511627775ll /* 0xffffffffff */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1099511627776ll /* 0x10000000000 */ ,
   {{6, 1, 40}}			/* shli r2, r1, 40 */
   },
  {1099511627777ll /* 0x10000000001 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1099511627778ll /* 0x10000000002 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1099511627779ll /* 0x10000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627780ll /* 0x10000000004 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1099511627781ll /* 0x10000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627782ll /* 0x10000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1099511627783ll /* 0x10000000007 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1099511627784ll /* 0x10000000008 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1099511627785ll /* 0x10000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627786ll /* 0x1000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1099511627792ll /* 0x10000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627808ll /* 0x10000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627840ll /* 0x10000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511627904ll /* 0x10000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511628032ll /* 0x10000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511628288ll /* 0x10000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511628800ll /* 0x10000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511629824ll /* 0x10000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511631872ll /* 0x10000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511635968ll /* 0x10000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511644160ll /* 0x10000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511660544ll /* 0x10000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511693312ll /* 0x10000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511758848ll /* 0x10000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099511889920ll /* 0x10000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099512152064ll /* 0x10000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099512676352ll /* 0x10000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099513724928ll /* 0x10000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099515822080ll /* 0x10000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099520016384ll /* 0x10000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099528404992ll /* 0x10001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099545182208ll /* 0x10002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099578736640ll /* 0x10004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099645845504ll /* 0x10008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1099780063232ll /* 0x10010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1100048498688ll /* 0x10020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1100585369600ll /* 0x10040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1101659111424ll /* 0x10080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1103806595072ll /* 0x10100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1108101562368ll /* 0x10200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1116691496960ll /* 0x10400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1133871366144ll /* 0x10800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1168231104512ll /* 0x11000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 40},			/* shli r3, r1, 40 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1236950581248ll /* 0x12000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 37}}			/* shli r3, r2, 37 */
   },
  {1374389534720ll /* 0x14000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 38}}			/* shli r3, r2, 38 */
   },
  {1649267441664ll /* 0x18000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 39}}			/* shli r3, r2, 39 */
   },
  {2199023255543ll /* 0x1fffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255544ll /* 0x1fffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255545ll /* 0x1fffffffff9 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2199023255547ll /* 0x1fffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255548ll /* 0x1fffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255549ll /* 0x1fffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255550ll /* 0x1fffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2199023255551ll /* 0x1ffffffffff */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2199023255552ll /* 0x20000000000 */ ,
   {{6, 1, 41}}			/* shli r2, r1, 41 */
   },
  {2199023255553ll /* 0x20000000001 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2199023255554ll /* 0x20000000002 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2199023255555ll /* 0x20000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255556ll /* 0x20000000004 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2199023255557ll /* 0x20000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255558ll /* 0x20000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2199023255559ll /* 0x20000000007 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2199023255560ll /* 0x20000000008 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2199023255561ll /* 0x20000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255562ll /* 0x2000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2199023255568ll /* 0x20000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255584ll /* 0x20000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255616ll /* 0x20000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255680ll /* 0x20000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023255808ll /* 0x20000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023256064ll /* 0x20000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023256576ll /* 0x20000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023257600ll /* 0x20000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023259648ll /* 0x20000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023263744ll /* 0x20000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023271936ll /* 0x20000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023288320ll /* 0x20000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023321088ll /* 0x20000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023386624ll /* 0x20000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023517696ll /* 0x20000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199023779840ll /* 0x20000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199024304128ll /* 0x20000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199025352704ll /* 0x20000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199027449856ll /* 0x20000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199031644160ll /* 0x20000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199040032768ll /* 0x20001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199056809984ll /* 0x20002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199090364416ll /* 0x20004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199157473280ll /* 0x20008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199291691008ll /* 0x20010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2199560126464ll /* 0x20020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2200096997376ll /* 0x20040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2201170739200ll /* 0x20080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2203318222848ll /* 0x20100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2207613190144ll /* 0x20200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2216203124736ll /* 0x20400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2233382993920ll /* 0x20800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2267742732288ll /* 0x21000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2336462209024ll /* 0x22000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 41},			/* shli r3, r1, 41 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2473901162496ll /* 0x24000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 38}}			/* shli r3, r2, 38 */
   },
  {2748779069440ll /* 0x28000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 39}}			/* shli r3, r2, 39 */
   },
  {3298534883328ll /* 0x30000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 40}}			/* shli r3, r2, 40 */
   },
  {4398046511095ll /* 0x3fffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511096ll /* 0x3fffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511097ll /* 0x3fffffffff9 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4398046511099ll /* 0x3fffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511100ll /* 0x3fffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511101ll /* 0x3fffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511102ll /* 0x3fffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4398046511103ll /* 0x3ffffffffff */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4398046511104ll /* 0x40000000000 */ ,
   {{6, 1, 42}}			/* shli r2, r1, 42 */
   },
  {4398046511105ll /* 0x40000000001 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4398046511106ll /* 0x40000000002 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4398046511107ll /* 0x40000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511108ll /* 0x40000000004 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4398046511109ll /* 0x40000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511110ll /* 0x40000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4398046511111ll /* 0x40000000007 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4398046511112ll /* 0x40000000008 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4398046511113ll /* 0x40000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511114ll /* 0x4000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4398046511120ll /* 0x40000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511136ll /* 0x40000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511168ll /* 0x40000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511232ll /* 0x40000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511360ll /* 0x40000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046511616ll /* 0x40000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046512128ll /* 0x40000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046513152ll /* 0x40000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046515200ll /* 0x40000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046519296ll /* 0x40000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046527488ll /* 0x40000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046543872ll /* 0x40000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046576640ll /* 0x40000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046642176ll /* 0x40000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398046773248ll /* 0x40000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398047035392ll /* 0x40000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398047559680ll /* 0x40000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398048608256ll /* 0x40000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398050705408ll /* 0x40000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398054899712ll /* 0x40000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398063288320ll /* 0x40001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398080065536ll /* 0x40002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398113619968ll /* 0x40004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398180728832ll /* 0x40008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398314946560ll /* 0x40010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4398583382016ll /* 0x40020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4399120252928ll /* 0x40040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4400193994752ll /* 0x40080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4402341478400ll /* 0x40100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4406636445696ll /* 0x40200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4415226380288ll /* 0x40400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4432406249472ll /* 0x40800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4466765987840ll /* 0x41000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4535485464576ll /* 0x42000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4672924418048ll /* 0x44000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 42},			/* shli r3, r1, 42 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4947802324992ll /* 0x48000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 39}}			/* shli r3, r2, 39 */
   },
  {5497558138880ll /* 0x50000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 40}}			/* shli r3, r2, 40 */
   },
  {6597069766656ll /* 0x60000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 41}}			/* shli r3, r2, 41 */
   },
  {8796093022199ll /* 0x7fffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022200ll /* 0x7fffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022201ll /* 0x7fffffffff9 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {8796093022203ll /* 0x7fffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022204ll /* 0x7fffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022205ll /* 0x7fffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022206ll /* 0x7fffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8796093022207ll /* 0x7ffffffffff */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8796093022208ll /* 0x80000000000 */ ,
   {{6, 1, 43}}			/* shli r2, r1, 43 */
   },
  {8796093022209ll /* 0x80000000001 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8796093022210ll /* 0x80000000002 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {8796093022211ll /* 0x80000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022212ll /* 0x80000000004 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {8796093022213ll /* 0x80000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022214ll /* 0x80000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8796093022215ll /* 0x80000000007 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {8796093022216ll /* 0x80000000008 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {8796093022217ll /* 0x80000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022218ll /* 0x8000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {8796093022224ll /* 0x80000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022240ll /* 0x80000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022272ll /* 0x80000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022336ll /* 0x80000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022464ll /* 0x80000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093022720ll /* 0x80000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093023232ll /* 0x80000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093024256ll /* 0x80000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093026304ll /* 0x80000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093030400ll /* 0x80000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093038592ll /* 0x80000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093054976ll /* 0x80000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093087744ll /* 0x80000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093153280ll /* 0x80000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093284352ll /* 0x80000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796093546496ll /* 0x80000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796094070784ll /* 0x80000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796095119360ll /* 0x80000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796097216512ll /* 0x80000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796101410816ll /* 0x80000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796109799424ll /* 0x80001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796126576640ll /* 0x80002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796160131072ll /* 0x80004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796227239936ll /* 0x80008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796361457664ll /* 0x80010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8796629893120ll /* 0x80020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8797166764032ll /* 0x80040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8798240505856ll /* 0x80080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8800387989504ll /* 0x80100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8804682956800ll /* 0x80200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8813272891392ll /* 0x80400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8830452760576ll /* 0x80800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8864812498944ll /* 0x81000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8933531975680ll /* 0x82000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9070970929152ll /* 0x84000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9345848836096ll /* 0x88000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 43},			/* shli r3, r1, 43 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9895604649984ll /* 0x90000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 40}}			/* shli r3, r2, 40 */
   },
  {10995116277760ll /* 0xa0000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 41}}			/* shli r3, r2, 41 */
   },
  {13194139533312ll /* 0xc0000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 42}}			/* shli r3, r2, 42 */
   },
  {17592186044407ll /* 0xffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044408ll /* 0xffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044409ll /* 0xffffffffff9 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {17592186044411ll /* 0xffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044412ll /* 0xffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044413ll /* 0xffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044414ll /* 0xffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {17592186044415ll /* 0xfffffffffff */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {17592186044416ll /* 0x100000000000 */ ,
   {{6, 1, 44}}			/* shli r2, r1, 44 */
   },
  {17592186044417ll /* 0x100000000001 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {17592186044418ll /* 0x100000000002 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {17592186044419ll /* 0x100000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044420ll /* 0x100000000004 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {17592186044421ll /* 0x100000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044422ll /* 0x100000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {17592186044423ll /* 0x100000000007 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {17592186044424ll /* 0x100000000008 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {17592186044425ll /* 0x100000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044426ll /* 0x10000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {17592186044432ll /* 0x100000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044448ll /* 0x100000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044480ll /* 0x100000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044544ll /* 0x100000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044672ll /* 0x100000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186044928ll /* 0x100000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186045440ll /* 0x100000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186046464ll /* 0x100000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186048512ll /* 0x100000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186052608ll /* 0x100000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186060800ll /* 0x100000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186077184ll /* 0x100000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186109952ll /* 0x100000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186175488ll /* 0x100000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186306560ll /* 0x100000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592186568704ll /* 0x100000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592187092992ll /* 0x100000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592188141568ll /* 0x100000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592190238720ll /* 0x100000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592194433024ll /* 0x100000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592202821632ll /* 0x100001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592219598848ll /* 0x100002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592253153280ll /* 0x100004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592320262144ll /* 0x100008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592454479872ll /* 0x100010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17592722915328ll /* 0x100020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17593259786240ll /* 0x100040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17594333528064ll /* 0x100080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17596481011712ll /* 0x100100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17600775979008ll /* 0x100200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17609365913600ll /* 0x100400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17626545782784ll /* 0x100800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17660905521152ll /* 0x101000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17729624997888ll /* 0x102000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17867063951360ll /* 0x104000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18141941858304ll /* 0x108000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18691697672192ll /* 0x110000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 44},			/* shli r3, r1, 44 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {19791209299968ll /* 0x120000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 41}}			/* shli r3, r2, 41 */
   },
  {21990232555520ll /* 0x140000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 42}}			/* shli r3, r2, 42 */
   },
  {26388279066624ll /* 0x180000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 43}}			/* shli r3, r2, 43 */
   },
  {35184372088823ll /* 0x1ffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088824ll /* 0x1ffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088825ll /* 0x1ffffffffff9 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {35184372088827ll /* 0x1ffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088828ll /* 0x1ffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088829ll /* 0x1ffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088830ll /* 0x1ffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {35184372088831ll /* 0x1fffffffffff */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {35184372088832ll /* 0x200000000000 */ ,
   {{6, 1, 45}}			/* shli r2, r1, 45 */
   },
  {35184372088833ll /* 0x200000000001 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {35184372088834ll /* 0x200000000002 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {35184372088835ll /* 0x200000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088836ll /* 0x200000000004 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {35184372088837ll /* 0x200000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088838ll /* 0x200000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {35184372088839ll /* 0x200000000007 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {35184372088840ll /* 0x200000000008 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {35184372088841ll /* 0x200000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088842ll /* 0x20000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {35184372088848ll /* 0x200000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088864ll /* 0x200000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088896ll /* 0x200000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372088960ll /* 0x200000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372089088ll /* 0x200000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372089344ll /* 0x200000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372089856ll /* 0x200000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372090880ll /* 0x200000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372092928ll /* 0x200000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372097024ll /* 0x200000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372105216ll /* 0x200000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372121600ll /* 0x200000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372154368ll /* 0x200000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372219904ll /* 0x200000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372350976ll /* 0x200000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184372613120ll /* 0x200000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184373137408ll /* 0x200000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184374185984ll /* 0x200000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184376283136ll /* 0x200000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184380477440ll /* 0x200000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184388866048ll /* 0x200001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184405643264ll /* 0x200002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184439197696ll /* 0x200004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184506306560ll /* 0x200008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184640524288ll /* 0x200010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35184908959744ll /* 0x200020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35185445830656ll /* 0x200040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35186519572480ll /* 0x200080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35188667056128ll /* 0x200100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35192962023424ll /* 0x200200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35201551958016ll /* 0x200400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35218731827200ll /* 0x200800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35253091565568ll /* 0x201000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35321811042304ll /* 0x202000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35459249995776ll /* 0x204000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35734127902720ll /* 0x208000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36283883716608ll /* 0x210000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {37383395344384ll /* 0x220000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 45},			/* shli r3, r1, 45 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {39582418599936ll /* 0x240000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 42}}			/* shli r3, r2, 42 */
   },
  {43980465111040ll /* 0x280000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 43}}			/* shli r3, r2, 43 */
   },
  {52776558133248ll /* 0x300000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 44}}			/* shli r3, r2, 44 */
   },
  {70368744177655ll /* 0x3ffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177656ll /* 0x3ffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177657ll /* 0x3ffffffffff9 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {70368744177659ll /* 0x3ffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177660ll /* 0x3ffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177661ll /* 0x3ffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177662ll /* 0x3ffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {70368744177663ll /* 0x3fffffffffff */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {70368744177664ll /* 0x400000000000 */ ,
   {{6, 1, 46}}			/* shli r2, r1, 46 */
   },
  {70368744177665ll /* 0x400000000001 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {70368744177666ll /* 0x400000000002 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {70368744177667ll /* 0x400000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177668ll /* 0x400000000004 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {70368744177669ll /* 0x400000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177670ll /* 0x400000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {70368744177671ll /* 0x400000000007 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {70368744177672ll /* 0x400000000008 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {70368744177673ll /* 0x400000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177674ll /* 0x40000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {70368744177680ll /* 0x400000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177696ll /* 0x400000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177728ll /* 0x400000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177792ll /* 0x400000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744177920ll /* 0x400000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744178176ll /* 0x400000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744178688ll /* 0x400000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744179712ll /* 0x400000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744181760ll /* 0x400000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744185856ll /* 0x400000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744194048ll /* 0x400000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744210432ll /* 0x400000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744243200ll /* 0x400000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744308736ll /* 0x400000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744439808ll /* 0x400000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368744701952ll /* 0x400000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368745226240ll /* 0x400000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368746274816ll /* 0x400000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368748371968ll /* 0x400000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368752566272ll /* 0x400000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368760954880ll /* 0x400001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368777732096ll /* 0x400002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368811286528ll /* 0x400004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70368878395392ll /* 0x400008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70369012613120ll /* 0x400010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70369281048576ll /* 0x400020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70369817919488ll /* 0x400040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70370891661312ll /* 0x400080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70373039144960ll /* 0x400100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70377334112256ll /* 0x400200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70385924046848ll /* 0x400400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70403103916032ll /* 0x400800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70437463654400ll /* 0x401000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70506183131136ll /* 0x402000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70643622084608ll /* 0x404000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70918499991552ll /* 0x408000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {71468255805440ll /* 0x410000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72567767433216ll /* 0x420000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {74766790688768ll /* 0x440000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 46},			/* shli r3, r1, 46 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {79164837199872ll /* 0x480000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 43}}			/* shli r3, r2, 43 */
   },
  {87960930222080ll /* 0x500000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 44}}			/* shli r3, r2, 44 */
   },
  {105553116266496ll /* 0x600000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 45}}			/* shli r3, r2, 45 */
   },
  {140737488355319ll /* 0x7ffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355320ll /* 0x7ffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355321ll /* 0x7ffffffffff9 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {140737488355323ll /* 0x7ffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355324ll /* 0x7ffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355325ll /* 0x7ffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355326ll /* 0x7ffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {140737488355327ll /* 0x7fffffffffff */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {140737488355328ll /* 0x800000000000 */ ,
   {{6, 1, 47}}			/* shli r2, r1, 47 */
   },
  {140737488355329ll /* 0x800000000001 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {140737488355330ll /* 0x800000000002 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {140737488355331ll /* 0x800000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355332ll /* 0x800000000004 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {140737488355333ll /* 0x800000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355334ll /* 0x800000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {140737488355335ll /* 0x800000000007 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {140737488355336ll /* 0x800000000008 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {140737488355337ll /* 0x800000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355338ll /* 0x80000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {140737488355344ll /* 0x800000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355360ll /* 0x800000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355392ll /* 0x800000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355456ll /* 0x800000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355584ll /* 0x800000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488355840ll /* 0x800000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488356352ll /* 0x800000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488357376ll /* 0x800000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488359424ll /* 0x800000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488363520ll /* 0x800000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488371712ll /* 0x800000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488388096ll /* 0x800000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488420864ll /* 0x800000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488486400ll /* 0x800000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488617472ll /* 0x800000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737488879616ll /* 0x800000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737489403904ll /* 0x800000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737490452480ll /* 0x800000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737492549632ll /* 0x800000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737496743936ll /* 0x800000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737505132544ll /* 0x800001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737521909760ll /* 0x800002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737555464192ll /* 0x800004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737622573056ll /* 0x800008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140737756790784ll /* 0x800010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140738025226240ll /* 0x800020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140738562097152ll /* 0x800040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140739635838976ll /* 0x800080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140741783322624ll /* 0x800100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140746078289920ll /* 0x800200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140754668224512ll /* 0x800400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140771848093696ll /* 0x800800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140806207832064ll /* 0x801000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {140874927308800ll /* 0x802000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {141012366262272ll /* 0x804000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {141287244169216ll /* 0x808000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {141836999983104ll /* 0x810000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {142936511610880ll /* 0x820000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {145135534866432ll /* 0x840000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {149533581377536ll /* 0x880000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 47},			/* shli r3, r1, 47 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {158329674399744ll /* 0x900000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 44}}			/* shli r3, r2, 44 */
   },
  {175921860444160ll /* 0xa00000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 45}}			/* shli r3, r2, 45 */
   },
  {211106232532992ll /* 0xc00000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 46}}			/* shli r3, r2, 46 */
   },
  {281474976710647ll /* 0xfffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710648ll /* 0xfffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710649ll /* 0xfffffffffff9 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {281474976710651ll /* 0xfffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710652ll /* 0xfffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710653ll /* 0xfffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710654ll /* 0xfffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {281474976710655ll /* 0xffffffffffff */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {281474976710656ll /* 0x1000000000000 */ ,
   {{6, 1, 48}}			/* shli r2, r1, 48 */
   },
  {281474976710657ll /* 0x1000000000001 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {281474976710658ll /* 0x1000000000002 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {281474976710659ll /* 0x1000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710660ll /* 0x1000000000004 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {281474976710661ll /* 0x1000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710662ll /* 0x1000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {281474976710663ll /* 0x1000000000007 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {281474976710664ll /* 0x1000000000008 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {281474976710665ll /* 0x1000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710666ll /* 0x100000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {281474976710672ll /* 0x1000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710688ll /* 0x1000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710720ll /* 0x1000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710784ll /* 0x1000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976710912ll /* 0x1000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976711168ll /* 0x1000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976711680ll /* 0x1000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976712704ll /* 0x1000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976714752ll /* 0x1000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976718848ll /* 0x1000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976727040ll /* 0x1000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976743424ll /* 0x1000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976776192ll /* 0x1000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976841728ll /* 0x1000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474976972800ll /* 0x1000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474977234944ll /* 0x1000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474977759232ll /* 0x1000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474978807808ll /* 0x1000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474980904960ll /* 0x1000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474985099264ll /* 0x1000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281474993487872ll /* 0x1000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281475010265088ll /* 0x1000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281475043819520ll /* 0x1000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281475110928384ll /* 0x1000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281475245146112ll /* 0x1000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281475513581568ll /* 0x1000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281476050452480ll /* 0x1000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281477124194304ll /* 0x1000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281479271677952ll /* 0x1000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281483566645248ll /* 0x1000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281492156579840ll /* 0x1000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281509336449024ll /* 0x1000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281543696187392ll /* 0x1001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281612415664128ll /* 0x1002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {281749854617600ll /* 0x1004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {282024732524544ll /* 0x1008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {282574488338432ll /* 0x1010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {283673999966208ll /* 0x1020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {285873023221760ll /* 0x1040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {290271069732864ll /* 0x1080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {299067162755072ll /* 0x1100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 48},			/* shli r3, r1, 48 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {316659348799488ll /* 0x1200000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 45}}			/* shli r3, r2, 45 */
   },
  {351843720888320ll /* 0x1400000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 46}}			/* shli r3, r2, 46 */
   },
  {422212465065984ll /* 0x1800000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 47}}			/* shli r3, r2, 47 */
   },
  {562949953421303ll /* 0x1fffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421304ll /* 0x1fffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421305ll /* 0x1fffffffffff9 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {562949953421307ll /* 0x1fffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421308ll /* 0x1fffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421309ll /* 0x1fffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421310ll /* 0x1fffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {562949953421311ll /* 0x1ffffffffffff */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {562949953421312ll /* 0x2000000000000 */ ,
   {{6, 1, 49}}			/* shli r2, r1, 49 */
   },
  {562949953421313ll /* 0x2000000000001 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {562949953421314ll /* 0x2000000000002 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {562949953421315ll /* 0x2000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421316ll /* 0x2000000000004 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {562949953421317ll /* 0x2000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421318ll /* 0x2000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {562949953421319ll /* 0x2000000000007 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {562949953421320ll /* 0x2000000000008 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {562949953421321ll /* 0x2000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421322ll /* 0x200000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {562949953421328ll /* 0x2000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421344ll /* 0x2000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421376ll /* 0x2000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421440ll /* 0x2000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421568ll /* 0x2000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953421824ll /* 0x2000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953422336ll /* 0x2000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953423360ll /* 0x2000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953425408ll /* 0x2000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953429504ll /* 0x2000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953437696ll /* 0x2000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953454080ll /* 0x2000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953486848ll /* 0x2000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953552384ll /* 0x2000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953683456ll /* 0x2000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949953945600ll /* 0x2000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949954469888ll /* 0x2000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949955518464ll /* 0x2000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949957615616ll /* 0x2000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949961809920ll /* 0x2000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949970198528ll /* 0x2000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562949986975744ll /* 0x2000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562950020530176ll /* 0x2000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562950087639040ll /* 0x2000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562950221856768ll /* 0x2000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562950490292224ll /* 0x2000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562951027163136ll /* 0x2000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562952100904960ll /* 0x2000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562954248388608ll /* 0x2000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562958543355904ll /* 0x2000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562967133290496ll /* 0x2000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {562984313159680ll /* 0x2000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {563018672898048ll /* 0x2001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {563087392374784ll /* 0x2002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {563224831328256ll /* 0x2004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {563499709235200ll /* 0x2008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {564049465049088ll /* 0x2010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {565148976676864ll /* 0x2020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {567347999932416ll /* 0x2040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {571746046443520ll /* 0x2080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {580542139465728ll /* 0x2100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {598134325510144ll /* 0x2200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 49},			/* shli r3, r1, 49 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {633318697598976ll /* 0x2400000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 46}}			/* shli r3, r2, 46 */
   },
  {703687441776640ll /* 0x2800000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 47}}			/* shli r3, r2, 47 */
   },
  {844424930131968ll /* 0x3000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 48}}			/* shli r3, r2, 48 */
   },
  {1125899906842615ll /* 0x3fffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842616ll /* 0x3fffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842617ll /* 0x3fffffffffff9 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1125899906842619ll /* 0x3fffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842620ll /* 0x3fffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842621ll /* 0x3fffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842622ll /* 0x3fffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1125899906842623ll /* 0x3ffffffffffff */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1125899906842624ll /* 0x4000000000000 */ ,
   {{6, 1, 50}}			/* shli r2, r1, 50 */
   },
  {1125899906842625ll /* 0x4000000000001 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1125899906842626ll /* 0x4000000000002 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1125899906842627ll /* 0x4000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842628ll /* 0x4000000000004 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1125899906842629ll /* 0x4000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842630ll /* 0x4000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1125899906842631ll /* 0x4000000000007 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1125899906842632ll /* 0x4000000000008 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1125899906842633ll /* 0x4000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842634ll /* 0x400000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1125899906842640ll /* 0x4000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842656ll /* 0x4000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842688ll /* 0x4000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842752ll /* 0x4000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906842880ll /* 0x4000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906843136ll /* 0x4000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906843648ll /* 0x4000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906844672ll /* 0x4000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906846720ll /* 0x4000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906850816ll /* 0x4000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906859008ll /* 0x4000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906875392ll /* 0x4000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906908160ll /* 0x4000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899906973696ll /* 0x4000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899907104768ll /* 0x4000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899907366912ll /* 0x4000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899907891200ll /* 0x4000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899908939776ll /* 0x4000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899911036928ll /* 0x4000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899915231232ll /* 0x4000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899923619840ll /* 0x4000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899940397056ll /* 0x4000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125899973951488ll /* 0x4000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125900041060352ll /* 0x4000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125900175278080ll /* 0x4000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125900443713536ll /* 0x4000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125900980584448ll /* 0x4000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125902054326272ll /* 0x4000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125904201809920ll /* 0x4000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125908496777216ll /* 0x4000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125917086711808ll /* 0x4000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125934266580992ll /* 0x4000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1125968626319360ll /* 0x4001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1126037345796096ll /* 0x4002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1126174784749568ll /* 0x4004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1126449662656512ll /* 0x4008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1126999418470400ll /* 0x4010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1128098930098176ll /* 0x4020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1130297953353728ll /* 0x4040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1134695999864832ll /* 0x4080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1143492092887040ll /* 0x4100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1161084278931456ll /* 0x4200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1196268651020288ll /* 0x4400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 50},			/* shli r3, r1, 50 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1266637395197952ll /* 0x4800000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 47}}			/* shli r3, r2, 47 */
   },
  {1407374883553280ll /* 0x5000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 48}}			/* shli r3, r2, 48 */
   },
  {1688849860263936ll /* 0x6000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 49}}			/* shli r3, r2, 49 */
   },
  {2251799813685239ll /* 0x7fffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685240ll /* 0x7fffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685241ll /* 0x7fffffffffff9 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2251799813685243ll /* 0x7fffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685244ll /* 0x7fffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685245ll /* 0x7fffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685246ll /* 0x7fffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2251799813685247ll /* 0x7ffffffffffff */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2251799813685248ll /* 0x8000000000000 */ ,
   {{6, 1, 51}}			/* shli r2, r1, 51 */
   },
  {2251799813685249ll /* 0x8000000000001 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2251799813685250ll /* 0x8000000000002 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2251799813685251ll /* 0x8000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685252ll /* 0x8000000000004 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2251799813685253ll /* 0x8000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685254ll /* 0x8000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2251799813685255ll /* 0x8000000000007 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2251799813685256ll /* 0x8000000000008 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2251799813685257ll /* 0x8000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685258ll /* 0x800000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2251799813685264ll /* 0x8000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685280ll /* 0x8000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685312ll /* 0x8000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685376ll /* 0x8000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685504ll /* 0x8000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813685760ll /* 0x8000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813686272ll /* 0x8000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813687296ll /* 0x8000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813689344ll /* 0x8000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813693440ll /* 0x8000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813701632ll /* 0x8000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813718016ll /* 0x8000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813750784ll /* 0x8000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813816320ll /* 0x8000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799813947392ll /* 0x8000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799814209536ll /* 0x8000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799814733824ll /* 0x8000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799815782400ll /* 0x8000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799817879552ll /* 0x8000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799822073856ll /* 0x8000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799830462464ll /* 0x8000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799847239680ll /* 0x8000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799880794112ll /* 0x8000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251799947902976ll /* 0x8000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251800082120704ll /* 0x8000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251800350556160ll /* 0x8000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251800887427072ll /* 0x8000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251801961168896ll /* 0x8000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251804108652544ll /* 0x8000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251808403619840ll /* 0x8000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251816993554432ll /* 0x8000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251834173423616ll /* 0x8000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251868533161984ll /* 0x8001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2251937252638720ll /* 0x8002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2252074691592192ll /* 0x8004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2252349569499136ll /* 0x8008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2252899325313024ll /* 0x8010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2253998836940800ll /* 0x8020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2256197860196352ll /* 0x8040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2260595906707456ll /* 0x8080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2269391999729664ll /* 0x8100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2286984185774080ll /* 0x8200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2322168557862912ll /* 0x8400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2392537302040576ll /* 0x8800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 51},			/* shli r3, r1, 51 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2533274790395904ll /* 0x9000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 48}}			/* shli r3, r2, 48 */
   },
  {2814749767106560ll /* 0xa000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 49}}			/* shli r3, r2, 49 */
   },
  {3377699720527872ll /* 0xc000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 50}}			/* shli r3, r2, 50 */
   },
  {4503599627370487ll /* 0xffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370488ll /* 0xffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370489ll /* 0xffffffffffff9 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4503599627370491ll /* 0xffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370492ll /* 0xffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370493ll /* 0xffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370494ll /* 0xffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4503599627370495ll /* 0xfffffffffffff */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4503599627370496ll /* 0x10000000000000 */ ,
   {{6, 1, 52}}			/* shli r2, r1, 52 */
   },
  {4503599627370497ll /* 0x10000000000001 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4503599627370498ll /* 0x10000000000002 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4503599627370499ll /* 0x10000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370500ll /* 0x10000000000004 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4503599627370501ll /* 0x10000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370502ll /* 0x10000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4503599627370503ll /* 0x10000000000007 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4503599627370504ll /* 0x10000000000008 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4503599627370505ll /* 0x10000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370506ll /* 0x1000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4503599627370512ll /* 0x10000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370528ll /* 0x10000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370560ll /* 0x10000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370624ll /* 0x10000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627370752ll /* 0x10000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627371008ll /* 0x10000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627371520ll /* 0x10000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627372544ll /* 0x10000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627374592ll /* 0x10000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627378688ll /* 0x10000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627386880ll /* 0x10000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627403264ll /* 0x10000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627436032ll /* 0x10000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627501568ll /* 0x10000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627632640ll /* 0x10000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599627894784ll /* 0x10000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599628419072ll /* 0x10000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599629467648ll /* 0x10000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599631564800ll /* 0x10000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599635759104ll /* 0x10000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599644147712ll /* 0x10000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599660924928ll /* 0x10000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599694479360ll /* 0x10000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599761588224ll /* 0x10000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503599895805952ll /* 0x10000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503600164241408ll /* 0x10000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503600701112320ll /* 0x10000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503601774854144ll /* 0x10000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503603922337792ll /* 0x10000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503608217305088ll /* 0x10000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503616807239680ll /* 0x10000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503633987108864ll /* 0x10000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503668346847232ll /* 0x10001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503737066323968ll /* 0x10002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4503874505277440ll /* 0x10004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4504149383184384ll /* 0x10008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4504699138998272ll /* 0x10010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4505798650626048ll /* 0x10020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4507997673881600ll /* 0x10040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4512395720392704ll /* 0x10080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4521191813414912ll /* 0x10100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4538783999459328ll /* 0x10200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4573968371548160ll /* 0x10400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4644337115725824ll /* 0x10800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4785074604081152ll /* 0x11000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 52},			/* shli r3, r1, 52 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {5066549580791808ll /* 0x12000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 49}}			/* shli r3, r2, 49 */
   },
  {5629499534213120ll /* 0x14000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 50}}			/* shli r3, r2, 50 */
   },
  {6755399441055744ll /* 0x18000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 51}}			/* shli r3, r2, 51 */
   },
  {9007199254740983ll /* 0x1ffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740984ll /* 0x1ffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740985ll /* 0x1ffffffffffff9 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {9007199254740987ll /* 0x1ffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740988ll /* 0x1ffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740989ll /* 0x1ffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740990ll /* 0x1ffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9007199254740991ll /* 0x1fffffffffffff */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {9007199254740992ll /* 0x20000000000000 */ ,
   {{6, 1, 53}}			/* shli r2, r1, 53 */
   },
  {9007199254740993ll /* 0x20000000000001 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {9007199254740994ll /* 0x20000000000002 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {9007199254740995ll /* 0x20000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254740996ll /* 0x20000000000004 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {9007199254740997ll /* 0x20000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254740998ll /* 0x20000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {9007199254740999ll /* 0x20000000000007 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {9007199254741000ll /* 0x20000000000008 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {9007199254741001ll /* 0x20000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741002ll /* 0x2000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {9007199254741008ll /* 0x20000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741024ll /* 0x20000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741056ll /* 0x20000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741120ll /* 0x20000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741248ll /* 0x20000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254741504ll /* 0x20000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254742016ll /* 0x20000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254743040ll /* 0x20000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254745088ll /* 0x20000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254749184ll /* 0x20000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254757376ll /* 0x20000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254773760ll /* 0x20000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254806528ll /* 0x20000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199254872064ll /* 0x20000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199255003136ll /* 0x20000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199255265280ll /* 0x20000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199255789568ll /* 0x20000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199256838144ll /* 0x20000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199258935296ll /* 0x20000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199263129600ll /* 0x20000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199271518208ll /* 0x20000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199288295424ll /* 0x20000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199321849856ll /* 0x20000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199388958720ll /* 0x20000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199523176448ll /* 0x20000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007199791611904ll /* 0x20000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007200328482816ll /* 0x20000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007201402224640ll /* 0x20000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007203549708288ll /* 0x20000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007207844675584ll /* 0x20000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007216434610176ll /* 0x20000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007233614479360ll /* 0x20000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007267974217728ll /* 0x20001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007336693694464ll /* 0x20002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007474132647936ll /* 0x20004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9007749010554880ll /* 0x20008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9008298766368768ll /* 0x20010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9009398277996544ll /* 0x20020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9011597301252096ll /* 0x20040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9015995347763200ll /* 0x20080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9024791440785408ll /* 0x20100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9042383626829824ll /* 0x20200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9077567998918656ll /* 0x20400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9147936743096320ll /* 0x20800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9288674231451648ll /* 0x21000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9570149208162304ll /* 0x22000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 53},			/* shli r3, r1, 53 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {10133099161583616ll /* 0x24000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 50}}			/* shli r3, r2, 50 */
   },
  {11258999068426240ll /* 0x28000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 51}}			/* shli r3, r2, 51 */
   },
  {13510798882111488ll /* 0x30000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 52}}			/* shli r3, r2, 52 */
   },
  {18014398509481975ll /* 0x3ffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481976ll /* 0x3ffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481977ll /* 0x3ffffffffffff9 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {18014398509481979ll /* 0x3ffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481980ll /* 0x3ffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481981ll /* 0x3ffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481982ll /* 0x3ffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {18014398509481983ll /* 0x3fffffffffffff */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {18014398509481984ll /* 0x40000000000000 */ ,
   {{6, 1, 54}}			/* shli r2, r1, 54 */
   },
  {18014398509481985ll /* 0x40000000000001 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {18014398509481986ll /* 0x40000000000002 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {18014398509481987ll /* 0x40000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509481988ll /* 0x40000000000004 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {18014398509481989ll /* 0x40000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509481990ll /* 0x40000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {18014398509481991ll /* 0x40000000000007 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {18014398509481992ll /* 0x40000000000008 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {18014398509481993ll /* 0x40000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509481994ll /* 0x4000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {18014398509482000ll /* 0x40000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509482016ll /* 0x40000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509482048ll /* 0x40000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509482112ll /* 0x40000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509482240ll /* 0x40000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509482496ll /* 0x40000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509483008ll /* 0x40000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509484032ll /* 0x40000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509486080ll /* 0x40000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509490176ll /* 0x40000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509498368ll /* 0x40000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509514752ll /* 0x40000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509547520ll /* 0x40000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509613056ll /* 0x40000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398509744128ll /* 0x40000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398510006272ll /* 0x40000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398510530560ll /* 0x40000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398511579136ll /* 0x40000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398513676288ll /* 0x40000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398517870592ll /* 0x40000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398526259200ll /* 0x40000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398543036416ll /* 0x40000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398576590848ll /* 0x40000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398643699712ll /* 0x40000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014398777917440ll /* 0x40000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014399046352896ll /* 0x40000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014399583223808ll /* 0x40000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014400656965632ll /* 0x40000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014402804449280ll /* 0x40000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014407099416576ll /* 0x40000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014415689351168ll /* 0x40000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014432869220352ll /* 0x40000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014467228958720ll /* 0x40001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014535948435456ll /* 0x40002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014673387388928ll /* 0x40004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18014948265295872ll /* 0x40008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18015498021109760ll /* 0x40010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18016597532737536ll /* 0x40020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18018796555993088ll /* 0x40040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18023194602504192ll /* 0x40080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18031990695526400ll /* 0x40100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18049582881570816ll /* 0x40200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18084767253659648ll /* 0x40400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18155135997837312ll /* 0x40800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18295873486192640ll /* 0x41000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18577348462903296ll /* 0x42000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {19140298416324608ll /* 0x44000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 54},			/* shli r3, r1, 54 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {20266198323167232ll /* 0x48000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 51}}			/* shli r3, r2, 51 */
   },
  {22517998136852480ll /* 0x50000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 52}}			/* shli r3, r2, 52 */
   },
  {27021597764222976ll /* 0x60000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 53}}			/* shli r3, r2, 53 */
   },
  {36028797018963959ll /* 0x7ffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963960ll /* 0x7ffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963961ll /* 0x7ffffffffffff9 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {36028797018963963ll /* 0x7ffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963964ll /* 0x7ffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963965ll /* 0x7ffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963966ll /* 0x7ffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {36028797018963967ll /* 0x7fffffffffffff */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {36028797018963968ll /* 0x80000000000000 */ ,
   {{6, 1, 55}}			/* shli r2, r1, 55 */
   },
  {36028797018963969ll /* 0x80000000000001 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {36028797018963970ll /* 0x80000000000002 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {36028797018963971ll /* 0x80000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018963972ll /* 0x80000000000004 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {36028797018963973ll /* 0x80000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018963974ll /* 0x80000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {36028797018963975ll /* 0x80000000000007 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {36028797018963976ll /* 0x80000000000008 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {36028797018963977ll /* 0x80000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018963978ll /* 0x8000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {36028797018963984ll /* 0x80000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964000ll /* 0x80000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964032ll /* 0x80000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964096ll /* 0x80000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964224ll /* 0x80000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964480ll /* 0x80000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018964992ll /* 0x80000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018966016ll /* 0x80000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018968064ll /* 0x80000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018972160ll /* 0x80000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018980352ll /* 0x80000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797018996736ll /* 0x80000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797019029504ll /* 0x80000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797019095040ll /* 0x80000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797019226112ll /* 0x80000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797019488256ll /* 0x80000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797020012544ll /* 0x80000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797021061120ll /* 0x80000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797023158272ll /* 0x80000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797027352576ll /* 0x80000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797035741184ll /* 0x80000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797052518400ll /* 0x80000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797086072832ll /* 0x80000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797153181696ll /* 0x80000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797287399424ll /* 0x80000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028797555834880ll /* 0x80000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028798092705792ll /* 0x80000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028799166447616ll /* 0x80000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028801313931264ll /* 0x80000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028805608898560ll /* 0x80000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028814198833152ll /* 0x80000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028831378702336ll /* 0x80000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028865738440704ll /* 0x80001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36028934457917440ll /* 0x80002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36029071896870912ll /* 0x80004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36029346774777856ll /* 0x80008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36029896530591744ll /* 0x80010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36030996042219520ll /* 0x80020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36033195065475072ll /* 0x80040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36037593111986176ll /* 0x80080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36046389205008384ll /* 0x80100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36063981391052800ll /* 0x80200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36099165763141632ll /* 0x80400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36169534507319296ll /* 0x80800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36310271995674624ll /* 0x81000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36591746972385280ll /* 0x82000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {37154696925806592ll /* 0x84000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {38280596832649216ll /* 0x88000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 55},			/* shli r3, r1, 55 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {40532396646334464ll /* 0x90000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 52}}			/* shli r3, r2, 52 */
   },
  {45035996273704960ll /* 0xa0000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 53}}			/* shli r3, r2, 53 */
   },
  {54043195528445952ll /* 0xc0000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 54}}			/* shli r3, r2, 54 */
   },
  {72057594037927927ll /* 0xfffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927928ll /* 0xfffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927929ll /* 0xfffffffffffff9 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {72057594037927931ll /* 0xfffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927932ll /* 0xfffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927933ll /* 0xfffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927934ll /* 0xfffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {72057594037927935ll /* 0xffffffffffffff */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {72057594037927936ll /* 0x100000000000000 */ ,
   {{6, 1, 56}}			/* shli r2, r1, 56 */
   },
  {72057594037927937ll /* 0x100000000000001 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {72057594037927938ll /* 0x100000000000002 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {72057594037927939ll /* 0x100000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037927940ll /* 0x100000000000004 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {72057594037927941ll /* 0x100000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037927942ll /* 0x100000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {72057594037927943ll /* 0x100000000000007 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {72057594037927944ll /* 0x100000000000008 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {72057594037927945ll /* 0x100000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037927946ll /* 0x10000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {72057594037927952ll /* 0x100000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037927968ll /* 0x100000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037928000ll /* 0x100000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037928064ll /* 0x100000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037928192ll /* 0x100000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037928448ll /* 0x100000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037928960ll /* 0x100000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037929984ll /* 0x100000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037932032ll /* 0x100000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037936128ll /* 0x100000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037944320ll /* 0x100000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037960704ll /* 0x100000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594037993472ll /* 0x100000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594038059008ll /* 0x100000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594038190080ll /* 0x100000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594038452224ll /* 0x100000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594038976512ll /* 0x100000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594040025088ll /* 0x100000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594042122240ll /* 0x100000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594046316544ll /* 0x100000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594054705152ll /* 0x100000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594071482368ll /* 0x100000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594105036800ll /* 0x100000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594172145664ll /* 0x100000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594306363392ll /* 0x100000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057594574798848ll /* 0x100000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057595111669760ll /* 0x100000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057596185411584ll /* 0x100000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057598332895232ll /* 0x100000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057602627862528ll /* 0x100000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057611217797120ll /* 0x100000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057628397666304ll /* 0x100000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057662757404672ll /* 0x100001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057731476881408ll /* 0x100002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72057868915834880ll /* 0x100004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72058143793741824ll /* 0x100008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72058693549555712ll /* 0x100010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72059793061183488ll /* 0x100020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72061992084439040ll /* 0x100040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72066390130950144ll /* 0x100080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72075186223972352ll /* 0x100100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72092778410016768ll /* 0x100200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72127962782105600ll /* 0x100400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72198331526283264ll /* 0x100800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72339069014638592ll /* 0x101000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {72620543991349248ll /* 0x102000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {73183493944770560ll /* 0x104000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {74309393851613184ll /* 0x108000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {76561193665298432ll /* 0x110000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 56},			/* shli r3, r1, 56 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {81064793292668928ll /* 0x120000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 53}}			/* shli r3, r2, 53 */
   },
  {90071992547409920ll /* 0x140000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 54}}			/* shli r3, r2, 54 */
   },
  {108086391056891904ll /* 0x180000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 55}}			/* shli r3, r2, 55 */
   },
  {144115188075855863ll /* 0x1fffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855864ll /* 0x1fffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855865ll /* 0x1fffffffffffff9 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {144115188075855867ll /* 0x1fffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855868ll /* 0x1fffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855869ll /* 0x1fffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855870ll /* 0x1fffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {144115188075855871ll /* 0x1ffffffffffffff */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {144115188075855872ll /* 0x200000000000000 */ ,
   {{6, 1, 57}}			/* shli r2, r1, 57 */
   },
  {144115188075855873ll /* 0x200000000000001 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {144115188075855874ll /* 0x200000000000002 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {144115188075855875ll /* 0x200000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075855876ll /* 0x200000000000004 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {144115188075855877ll /* 0x200000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075855878ll /* 0x200000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {144115188075855879ll /* 0x200000000000007 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {144115188075855880ll /* 0x200000000000008 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {144115188075855881ll /* 0x200000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075855882ll /* 0x20000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {144115188075855888ll /* 0x200000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075855904ll /* 0x200000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075855936ll /* 0x200000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075856000ll /* 0x200000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075856128ll /* 0x200000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075856384ll /* 0x200000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075856896ll /* 0x200000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075857920ll /* 0x200000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075859968ll /* 0x200000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075864064ll /* 0x200000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075872256ll /* 0x200000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075888640ll /* 0x200000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075921408ll /* 0x200000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188075986944ll /* 0x200000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188076118016ll /* 0x200000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188076380160ll /* 0x200000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188076904448ll /* 0x200000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188077953024ll /* 0x200000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188080050176ll /* 0x200000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188084244480ll /* 0x200000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188092633088ll /* 0x200000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188109410304ll /* 0x200000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188142964736ll /* 0x200000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188210073600ll /* 0x200000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188344291328ll /* 0x200000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115188612726784ll /* 0x200000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115189149597696ll /* 0x200000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115190223339520ll /* 0x200000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115192370823168ll /* 0x200000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115196665790464ll /* 0x200000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115205255725056ll /* 0x200000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115222435594240ll /* 0x200000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115256795332608ll /* 0x200001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115325514809344ll /* 0x200002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115462953762816ll /* 0x200004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144115737831669760ll /* 0x200008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144116287587483648ll /* 0x200010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144117387099111424ll /* 0x200020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144119586122366976ll /* 0x200040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144123984168878080ll /* 0x200080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144132780261900288ll /* 0x200100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144150372447944704ll /* 0x200200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144185556820033536ll /* 0x200400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144255925564211200ll /* 0x200800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144396663052566528ll /* 0x201000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {144678138029277184ll /* 0x202000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {145241087982698496ll /* 0x204000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {146366987889541120ll /* 0x208000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {148618787703226368ll /* 0x210000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {153122387330596864ll /* 0x220000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 57},			/* shli r3, r1, 57 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {162129586585337856ll /* 0x240000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 54}}			/* shli r3, r2, 54 */
   },
  {180143985094819840ll /* 0x280000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 55}}			/* shli r3, r2, 55 */
   },
  {216172782113783808ll /* 0x300000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 56}}			/* shli r3, r2, 56 */
   },
  {288230376151711735ll /* 0x3fffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711736ll /* 0x3fffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711737ll /* 0x3fffffffffffff9 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {288230376151711739ll /* 0x3fffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711740ll /* 0x3fffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711741ll /* 0x3fffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711742ll /* 0x3fffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {288230376151711743ll /* 0x3ffffffffffffff */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {288230376151711744ll /* 0x400000000000000 */ ,
   {{6, 1, 58}}			/* shli r2, r1, 58 */
   },
  {288230376151711745ll /* 0x400000000000001 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {288230376151711746ll /* 0x400000000000002 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {288230376151711747ll /* 0x400000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711748ll /* 0x400000000000004 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {288230376151711749ll /* 0x400000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711750ll /* 0x400000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {288230376151711751ll /* 0x400000000000007 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {288230376151711752ll /* 0x400000000000008 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {288230376151711753ll /* 0x400000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711754ll /* 0x40000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {288230376151711760ll /* 0x400000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711776ll /* 0x400000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711808ll /* 0x400000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151711872ll /* 0x400000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151712000ll /* 0x400000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151712256ll /* 0x400000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151712768ll /* 0x400000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151713792ll /* 0x400000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151715840ll /* 0x400000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151719936ll /* 0x400000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151728128ll /* 0x400000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151744512ll /* 0x400000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151777280ll /* 0x400000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151842816ll /* 0x400000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376151973888ll /* 0x400000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376152236032ll /* 0x400000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376152760320ll /* 0x400000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376153808896ll /* 0x400000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376155906048ll /* 0x400000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376160100352ll /* 0x400000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376168488960ll /* 0x400000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376185266176ll /* 0x400000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376218820608ll /* 0x400000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376285929472ll /* 0x400000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376420147200ll /* 0x400000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230376688582656ll /* 0x400000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230377225453568ll /* 0x400000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230378299195392ll /* 0x400000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230380446679040ll /* 0x400000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230384741646336ll /* 0x400000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230393331580928ll /* 0x400000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230410511450112ll /* 0x400000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230444871188480ll /* 0x400001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230513590665216ll /* 0x400002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230651029618688ll /* 0x400004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288230925907525632ll /* 0x400008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288231475663339520ll /* 0x400010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288232575174967296ll /* 0x400020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288234774198222848ll /* 0x400040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288239172244733952ll /* 0x400080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288247968337756160ll /* 0x400100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288265560523800576ll /* 0x400200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288300744895889408ll /* 0x400400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288371113640067072ll /* 0x400800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288511851128422400ll /* 0x401000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {288793326105133056ll /* 0x402000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {289356276058554368ll /* 0x404000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {290482175965396992ll /* 0x408000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {292733975779082240ll /* 0x410000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {297237575406452736ll /* 0x420000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {306244774661193728ll /* 0x440000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 58},			/* shli r3, r1, 58 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {324259173170675712ll /* 0x480000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 55}}			/* shli r3, r2, 55 */
   },
  {360287970189639680ll /* 0x500000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 56}}			/* shli r3, r2, 56 */
   },
  {432345564227567616ll /* 0x600000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 57}}			/* shli r3, r2, 57 */
   },
  {576460752303423479ll /* 0x7fffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423480ll /* 0x7fffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423481ll /* 0x7fffffffffffff9 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {576460752303423483ll /* 0x7fffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423484ll /* 0x7fffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423485ll /* 0x7fffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423486ll /* 0x7fffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {576460752303423487ll /* 0x7ffffffffffffff */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {576460752303423488ll /* 0x800000000000000 */ ,
   {{6, 1, 59}}			/* shli r2, r1, 59 */
   },
  {576460752303423489ll /* 0x800000000000001 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {576460752303423490ll /* 0x800000000000002 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {576460752303423491ll /* 0x800000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423492ll /* 0x800000000000004 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {576460752303423493ll /* 0x800000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423494ll /* 0x800000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {576460752303423495ll /* 0x800000000000007 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {576460752303423496ll /* 0x800000000000008 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {576460752303423497ll /* 0x800000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423498ll /* 0x80000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {576460752303423504ll /* 0x800000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423520ll /* 0x800000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423552ll /* 0x800000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423616ll /* 0x800000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303423744ll /* 0x800000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303424000ll /* 0x800000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303424512ll /* 0x800000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303425536ll /* 0x800000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303427584ll /* 0x800000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303431680ll /* 0x800000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303439872ll /* 0x800000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303456256ll /* 0x800000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303489024ll /* 0x800000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303554560ll /* 0x800000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303685632ll /* 0x800000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752303947776ll /* 0x800000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752304472064ll /* 0x800000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752305520640ll /* 0x800000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752307617792ll /* 0x800000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752311812096ll /* 0x800000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752320200704ll /* 0x800000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752336977920ll /* 0x800000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752370532352ll /* 0x800000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752437641216ll /* 0x800000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752571858944ll /* 0x800000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460752840294400ll /* 0x800000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460753377165312ll /* 0x800000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460754450907136ll /* 0x800000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460756598390784ll /* 0x800000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460760893358080ll /* 0x800000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460769483292672ll /* 0x800000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460786663161856ll /* 0x800000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460821022900224ll /* 0x800001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576460889742376960ll /* 0x800002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576461027181330432ll /* 0x800004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576461302059237376ll /* 0x800008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576461851815051264ll /* 0x800010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576462951326679040ll /* 0x800020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576465150349934592ll /* 0x800040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576469548396445696ll /* 0x800080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576478344489467904ll /* 0x800100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576495936675512320ll /* 0x800200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576531121047601152ll /* 0x800400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576601489791778816ll /* 0x800800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {576742227280134144ll /* 0x801000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {577023702256844800ll /* 0x802000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {577586652210266112ll /* 0x804000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {578712552117108736ll /* 0x808000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {580964351930793984ll /* 0x810000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {585467951558164480ll /* 0x820000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {594475150812905472ll /* 0x840000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {612489549322387456ll /* 0x880000000000000 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {6, 1, 59},			/* shli r3, r1, 59 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {648518346341351424ll /* 0x900000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 56}}			/* shli r3, r2, 56 */
   },
  {720575940379279360ll /* 0xa00000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 57}}			/* shli r3, r2, 57 */
   },
  {864691128455135232ll /* 0xc00000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 58}}			/* shli r3, r2, 58 */
   },
  {1152921504606846967ll /* 0xffffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846968ll /* 0xffffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846969ll /* 0xffffffffffffff9 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {1152921504606846971ll /* 0xffffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846972ll /* 0xffffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846973ll /* 0xffffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846974ll /* 0xffffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1152921504606846975ll /* 0xfffffffffffffff */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1152921504606846976ll /* 0x1000000000000000 */ ,
   {{6, 1, 60}}			/* shli r2, r1, 60 */
   },
  {1152921504606846977ll /* 0x1000000000000001 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1152921504606846978ll /* 0x1000000000000002 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {1152921504606846979ll /* 0x1000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606846980ll /* 0x1000000000000004 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {1152921504606846981ll /* 0x1000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606846982ll /* 0x1000000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1152921504606846983ll /* 0x1000000000000007 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {1152921504606846984ll /* 0x1000000000000008 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {1152921504606846985ll /* 0x1000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606846986ll /* 0x100000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {1152921504606846992ll /* 0x1000000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606847008ll /* 0x1000000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606847040ll /* 0x1000000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606847104ll /* 0x1000000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606847232ll /* 0x1000000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606847488ll /* 0x1000000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606848000ll /* 0x1000000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606849024ll /* 0x1000000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606851072ll /* 0x1000000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606855168ll /* 0x1000000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606863360ll /* 0x1000000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606879744ll /* 0x1000000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606912512ll /* 0x1000000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504606978048ll /* 0x1000000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504607109120ll /* 0x1000000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504607371264ll /* 0x1000000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504607895552ll /* 0x1000000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504608944128ll /* 0x1000000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504611041280ll /* 0x1000000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504615235584ll /* 0x1000000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504623624192ll /* 0x1000000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504640401408ll /* 0x1000000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504673955840ll /* 0x1000000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504741064704ll /* 0x1000000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921504875282432ll /* 0x1000000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921505143717888ll /* 0x1000000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921505680588800ll /* 0x1000000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921506754330624ll /* 0x1000000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921508901814272ll /* 0x1000000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921513196781568ll /* 0x1000000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921521786716160ll /* 0x1000000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921538966585344ll /* 0x1000000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921573326323712ll /* 0x1000001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921642045800448ll /* 0x1000002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152921779484753920ll /* 0x1000004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152922054362660864ll /* 0x1000008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152922604118474752ll /* 0x1000010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152923703630102528ll /* 0x1000020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152925902653358080ll /* 0x1000040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152930300699869184ll /* 0x1000080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152939096792891392ll /* 0x1000100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152956688978935808ll /* 0x1000200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1152991873351024640ll /* 0x1000400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1153062242095202304ll /* 0x1000800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1153202979583557632ll /* 0x1001000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1153484454560268288ll /* 0x1002000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1154047404513689600ll /* 0x1004000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1155173304420532224ll /* 0x1008000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1157425104234217472ll /* 0x1010000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1161928703861587968ll /* 0x1020000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1170935903116328960ll /* 0x1040000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1188950301625810944ll /* 0x1080000000000000 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1224979098644774912ll /* 0x1100000000000000 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {6, 1, 60},			/* shli r3, r1, 60 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1297036692682702848ll /* 0x1200000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 57}}			/* shli r3, r2, 57 */
   },
  {1441151880758558720ll /* 0x1400000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 58}}			/* shli r3, r2, 58 */
   },
  {1729382256910270464ll /* 0x1800000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 59}}			/* shli r3, r2, 59 */
   },
  {2305843009213693943ll /* 0x1ffffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693944ll /* 0x1ffffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693945ll /* 0x1ffffffffffffff9 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {2305843009213693947ll /* 0x1ffffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693948ll /* 0x1ffffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693949ll /* 0x1ffffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693950ll /* 0x1ffffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2305843009213693951ll /* 0x1fffffffffffffff */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2305843009213693952ll /* 0x2000000000000000 */ ,
   {{6, 1, 61}}			/* shli r2, r1, 61 */
   },
  {2305843009213693953ll /* 0x2000000000000001 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2305843009213693954ll /* 0x2000000000000002 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {2305843009213693955ll /* 0x2000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213693956ll /* 0x2000000000000004 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {2305843009213693957ll /* 0x2000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213693958ll /* 0x2000000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2305843009213693959ll /* 0x2000000000000007 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {2305843009213693960ll /* 0x2000000000000008 */ ,
   {{6, 1, 61},			/* shli r2, r1, 61 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {2305843009213693961ll /* 0x2000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213693962ll /* 0x200000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {2305843009213693968ll /* 0x2000000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213693984ll /* 0x2000000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213694016ll /* 0x2000000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213694080ll /* 0x2000000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213694208ll /* 0x2000000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213694464ll /* 0x2000000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213694976ll /* 0x2000000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213696000ll /* 0x2000000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213698048ll /* 0x2000000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213702144ll /* 0x2000000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213710336ll /* 0x2000000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213726720ll /* 0x2000000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213759488ll /* 0x2000000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213825024ll /* 0x2000000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009213956096ll /* 0x2000000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009214218240ll /* 0x2000000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009214742528ll /* 0x2000000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009215791104ll /* 0x2000000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009217888256ll /* 0x2000000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009222082560ll /* 0x2000000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009230471168ll /* 0x2000000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009247248384ll /* 0x2000000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009280802816ll /* 0x2000000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009347911680ll /* 0x2000000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009482129408ll /* 0x2000000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843009750564864ll /* 0x2000000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843010287435776ll /* 0x2000000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843011361177600ll /* 0x2000000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843013508661248ll /* 0x2000000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843017803628544ll /* 0x2000000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843026393563136ll /* 0x2000000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843043573432320ll /* 0x2000000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843077933170688ll /* 0x2000001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843146652647424ll /* 0x2000002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843284091600896ll /* 0x2000004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305843558969507840ll /* 0x2000008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305844108725321728ll /* 0x2000010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305845208236949504ll /* 0x2000020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305847407260205056ll /* 0x2000040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305851805306716160ll /* 0x2000080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305860601399738368ll /* 0x2000100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305878193585782784ll /* 0x2000200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305913377957871616ll /* 0x2000400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2305983746702049280ll /* 0x2000800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2306124484190404608ll /* 0x2001000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2306405959167115264ll /* 0x2002000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2306968909120536576ll /* 0x2004000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2308094809027379200ll /* 0x2008000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2310346608841064448ll /* 0x2010000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2314850208468434944ll /* 0x2020000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2323857407723175936ll /* 0x2040000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2341871806232657920ll /* 0x2080000000000000 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2377900603251621888ll /* 0x2100000000000000 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2449958197289549824ll /* 0x2200000000000000 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {6, 1, 61},			/* shli r3, r1, 61 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2594073385365405696ll /* 0x2400000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 58}}			/* shli r3, r2, 58 */
   },
  {2882303761517117440ll /* 0x2800000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 59}}			/* shli r3, r2, 59 */
   },
  {3458764513820540928ll /* 0x3000000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 60}}			/* shli r3, r2, 60 */
   },
  {4611686018427387895ll /* 0x3ffffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387896ll /* 0x3ffffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387897ll /* 0x3ffffffffffffff9 */ ,
   {{6, 1, 59},			/* shli r2, r1, 59 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {4611686018427387899ll /* 0x3ffffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387900ll /* 0x3ffffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387901ll /* 0x3ffffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387902ll /* 0x3ffffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4611686018427387903ll /* 0x3fffffffffffffff */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4611686018427387904ll /* 0x4000000000000000 */ ,
   {{6, 1, 62}}			/* shli r2, r1, 62 */
   },
  {4611686018427387905ll /* 0x4000000000000001 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4611686018427387906ll /* 0x4000000000000002 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {3, 1, 2}}			/* shl1add r3, r1, r2 */
   },
  {4611686018427387907ll /* 0x4000000000000003 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427387908ll /* 0x4000000000000004 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {4, 1, 2}}			/* shl2add r3, r1, r2 */
   },
  {4611686018427387909ll /* 0x4000000000000005 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427387910ll /* 0x4000000000000006 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4611686018427387911ll /* 0x4000000000000007 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* shl3add r4, r1, r3 */
   },
  {4611686018427387912ll /* 0x4000000000000008 */ ,
   {{6, 1, 62},			/* shli r2, r1, 62 */
    {5, 1, 2}}			/* shl3add r3, r1, r2 */
   },
  {4611686018427387913ll /* 0x4000000000000009 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427387914ll /* 0x400000000000000a */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {3, 2, 3}}			/* shl1add r4, r2, r3 */
   },
  {4611686018427387920ll /* 0x4000000000000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427387936ll /* 0x4000000000000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427387968ll /* 0x4000000000000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427388032ll /* 0x4000000000000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427388160ll /* 0x4000000000000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427388416ll /* 0x4000000000000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427388928ll /* 0x4000000000000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427389952ll /* 0x4000000000000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427392000ll /* 0x4000000000001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427396096ll /* 0x4000000000002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427404288ll /* 0x4000000000004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427420672ll /* 0x4000000000008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427453440ll /* 0x4000000000010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427518976ll /* 0x4000000000020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427650048ll /* 0x4000000000040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018427912192ll /* 0x4000000000080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018428436480ll /* 0x4000000000100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018429485056ll /* 0x4000000000200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018431582208ll /* 0x4000000000400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018435776512ll /* 0x4000000000800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018444165120ll /* 0x4000000001000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018460942336ll /* 0x4000000002000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018494496768ll /* 0x4000000004000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018561605632ll /* 0x4000000008000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018695823360ll /* 0x4000000010000000 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686018964258816ll /* 0x4000000020000000 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686019501129728ll /* 0x4000000040000000 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686020574871552ll /* 0x4000000080000000 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686022722355200ll /* 0x4000000100000000 */ ,
   {{6, 1, 32},			/* shli r2, r1, 32 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686027017322496ll /* 0x4000000200000000 */ ,
   {{6, 1, 33},			/* shli r2, r1, 33 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686035607257088ll /* 0x4000000400000000 */ ,
   {{6, 1, 34},			/* shli r2, r1, 34 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686052787126272ll /* 0x4000000800000000 */ ,
   {{6, 1, 35},			/* shli r2, r1, 35 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686087146864640ll /* 0x4000001000000000 */ ,
   {{6, 1, 36},			/* shli r2, r1, 36 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686155866341376ll /* 0x4000002000000000 */ ,
   {{6, 1, 37},			/* shli r2, r1, 37 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686293305294848ll /* 0x4000004000000000 */ ,
   {{6, 1, 38},			/* shli r2, r1, 38 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611686568183201792ll /* 0x4000008000000000 */ ,
   {{6, 1, 39},			/* shli r2, r1, 39 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611687117939015680ll /* 0x4000010000000000 */ ,
   {{6, 1, 40},			/* shli r2, r1, 40 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611688217450643456ll /* 0x4000020000000000 */ ,
   {{6, 1, 41},			/* shli r2, r1, 41 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611690416473899008ll /* 0x4000040000000000 */ ,
   {{6, 1, 42},			/* shli r2, r1, 42 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611694814520410112ll /* 0x4000080000000000 */ ,
   {{6, 1, 43},			/* shli r2, r1, 43 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611703610613432320ll /* 0x4000100000000000 */ ,
   {{6, 1, 44},			/* shli r2, r1, 44 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611721202799476736ll /* 0x4000200000000000 */ ,
   {{6, 1, 45},			/* shli r2, r1, 45 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611756387171565568ll /* 0x4000400000000000 */ ,
   {{6, 1, 46},			/* shli r2, r1, 46 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611826755915743232ll /* 0x4000800000000000 */ ,
   {{6, 1, 47},			/* shli r2, r1, 47 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4611967493404098560ll /* 0x4001000000000000 */ ,
   {{6, 1, 48},			/* shli r2, r1, 48 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4612248968380809216ll /* 0x4002000000000000 */ ,
   {{6, 1, 49},			/* shli r2, r1, 49 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4612811918334230528ll /* 0x4004000000000000 */ ,
   {{6, 1, 50},			/* shli r2, r1, 50 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4613937818241073152ll /* 0x4008000000000000 */ ,
   {{6, 1, 51},			/* shli r2, r1, 51 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4616189618054758400ll /* 0x4010000000000000 */ ,
   {{6, 1, 52},			/* shli r2, r1, 52 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4620693217682128896ll /* 0x4020000000000000 */ ,
   {{6, 1, 53},			/* shli r2, r1, 53 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4629700416936869888ll /* 0x4040000000000000 */ ,
   {{6, 1, 54},			/* shli r2, r1, 54 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4647714815446351872ll /* 0x4080000000000000 */ ,
   {{6, 1, 55},			/* shli r2, r1, 55 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4683743612465315840ll /* 0x4100000000000000 */ ,
   {{6, 1, 56},			/* shli r2, r1, 56 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4755801206503243776ll /* 0x4200000000000000 */ ,
   {{6, 1, 57},			/* shli r2, r1, 57 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4899916394579099648ll /* 0x4400000000000000 */ ,
   {{6, 1, 58},			/* shli r2, r1, 58 */
    {6, 1, 62},			/* shli r3, r1, 62 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {5188146770730811392ll /* 0x4800000000000000 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 2, 59}}			/* shli r3, r2, 59 */
   },
  {5764607523034234880ll /* 0x5000000000000000 */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 2, 60}}			/* shli r3, r2, 60 */
   },
  {6917529027641081855ll /* 0x5fffffffffffffff */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 61},			/* shli r3, r2, 61 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {6917529027641081856ll /* 0x6000000000000000 */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 2, 61}}			/* shli r3, r2, 61 */
   },
  {9223372036854775799ll /* 0x7ffffffffffffff7 */ ,
   {{5, 1, 1},			/* shl3add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775800ll /* 0x7ffffffffffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775801ll /* 0x7ffffffffffffff9 */ ,
   {{6, 1, 60},			/* shli r2, r1, 60 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* shl3add r4, r3, r1 */
   },
  {9223372036854775803ll /* 0x7ffffffffffffffb */ ,
   {{4, 1, 1},			/* shl2add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775804ll /* 0x7ffffffffffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775805ll /* 0x7ffffffffffffffd */ ,
   {{3, 1, 1},			/* shl1add r2, r1, r1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775806ll /* 0x7ffffffffffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 63},			/* shli r3, r1, 63 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {9223372036854775807ll /* 0x7fffffffffffffff */ ,
   {{6, 1, 63},			/* shli r2, r1, 63 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   }
};

const int tilegx_multiply_insn_seq_table_size =
  (int) (sizeof tilegx_multiply_insn_seq_table
         / sizeof tilegx_multiply_insn_seq_table[0]);
