/*
 * Soft:        Keepalived is a failover program for the LVS project
 *              <www.linuxvirtualserver.org>. It monitor & manipulate
 *              a loadbalanced server pool using multi-layer checks.
 *
 * Part:        Config read completion notification include file.
 *
 * Author:      Quentin Armitage, <quentin@armitage.org.uk>
 *
 *              This program is distributed in the hope that it will be useful,
 *              but WITHOUT ANY WARRANTY; without even the implied warranty of
 *              MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *              See the GNU General Public License for more details.
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 *
 * Copyright (C) 2021-2021 Alexandre Cassen, <acassen@gmail.com>
 */

#ifndef _CONFIG_NOTIFY_H
#define _CONFIG_NOTIFY_H

#include "config.h"

#include <stdbool.h>
#include <stdio.h>

extern void queue_reload(void);
extern void open_config_read_fd(void);
extern void notify_config_read(void);
#ifndef _ONE_PROCESS_DEBUG_
extern void save_config(bool, const char *, void(*)(FILE *));
#endif
#ifdef THREAD_DUMP
extern void register_config_notify_addresses(void);
#endif
#endif
