/**
 * @license
 * Copyright (C) 2011 The Libphonenumber Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview String constants of region codes for testing.
 * @author Nikolaos Trogkanis
 */

goog.provide('i18n.phonenumbers.RegionCode');


/**
 * Enum containing string constants of region codes for easier testing.
 *
 * @enum {string}
 */
i18n.phonenumbers.RegionCode = {
  // Region code for global networks (e.g. +800 numbers).
  UN001: '001',
  AD: 'AD',
  AE: 'AE',
  AO: 'AO',
  AQ: 'AQ',
  AR: 'AR',
  AM: 'AM',
  AU: 'AU',
  BB: 'BB',
  BR: 'BR',
  BS: 'BS',
  BY: 'BY',
  CA: 'CA',
  CH: 'CH',
  CL: 'CL',
  CN: 'CN',
  CO: 'CO',
  CS: 'CS',
  CX: 'CX',
  DE: 'DE',
  FR: 'FR',
  GB: 'GB',
  HU: 'HU',
  IT: 'IT',
  JP: 'JP',
  KR: 'KR',
  MX: 'MX',
  NZ: 'NZ',
  PL: 'PL',
  RE: 'RE',
  RU: 'RU',
  SE: 'SE',
  SG: 'SG',
  US: 'US',
  UZ: 'UZ',
  YT: 'YT',
  ZW: 'ZW',
  // Official code for the unknown region.
  ZZ: 'ZZ'
};
