/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#include "stdafx.h"

#include "Doc/SchemaTypesDoc/CCollectMethodDoc.h"
#include "Doc/SchemaTypesDoc/CMethodDoc.h"
#include "Doc/SchemaTypesDoc/CActionClassDoc.h"

using namespace Caf;

/// Definition of an action class that may be generated by the provider
CActionClassDoc::CActionClassDoc() :
	_isInitialized(false) {}
CActionClassDoc::~CActionClassDoc() {}

/// Initializes the object with everything required by this
/// container. Once initialized, this object cannot
/// be changed (i.e. it is immutable).
void CActionClassDoc::initialize(
	const std::string namespaceVal,
	const std::string name,
	const std::string version,
	const SmartPtrCCollectMethodDoc collectMethod,
	const std::deque<SmartPtrCMethodDoc> methodCollection,
	const std::string displayName,
	const std::string description) {
	if (! _isInitialized) {
		_namespaceVal = namespaceVal;
		_name = name;
		_version = version;
		_collectMethod = collectMethod;
		_methodCollection = methodCollection;
		_displayName = displayName;
		_description = description;

		_isInitialized = true;
	}
}

/// Accessor for the NamespaceVal
std::string CActionClassDoc::getNamespaceVal() const {
	return _namespaceVal;
}

/// Accessor for the Name
std::string CActionClassDoc::getName() const {
	return _name;
}

/// Accessor for the Version
std::string CActionClassDoc::getVersion() const {
	return _version;
}

/// Accessor for the CollectMethod
SmartPtrCCollectMethodDoc CActionClassDoc::getCollectMethod() const {
	return _collectMethod;
}

/// Accessor for the Method
std::deque<SmartPtrCMethodDoc> CActionClassDoc::getMethodCollection() const {
	return _methodCollection;
}

/// A hint as to what this class should be called when displaying it to a human
std::string CActionClassDoc::getDisplayName() const {
	return _displayName;
}

/// A phrase to describe the class for mouse-over text, etc
std::string CActionClassDoc::getDescription() const {
	return _description;
}






