/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T> {
    private final Map<Object, Boolean> exceptions = new HashMap<Object, Boolean>();
    private final HashMap<T, Boolean> selectionChanges = new HashMap();

    public DefaultSelectionModel() {
        super(null);
    }

    public DefaultSelectionModel(ProvidesKey<T> keyProvider) {
        super(keyProvider);
    }

    public void clearExceptions() {
        this.exceptions.clear();
        this.selectionChanges.clear();
        this.scheduleSelectionChangeEvent();
    }

    public abstract boolean isDefaultSelected(T var1);

    @Override
    public boolean isSelected(T object) {
        this.resolveChanges();
        Object key = this.getKey(object);
        Boolean exception = this.exceptions.get(key);
        if (exception != null) {
            return exception;
        }
        return this.isDefaultSelected(object);
    }

    @Override
    public void setSelected(T object, boolean selected) {
        this.selectionChanges.put(object, selected);
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    protected Map<Object, Boolean> getExceptions(Map<Object, Boolean> output) {
        output.clear();
        output.putAll(this.exceptions);
        return output;
    }

    private void resolveChanges() {
        boolean changed = false;
        for (Map.Entry<T, Boolean> entry : this.selectionChanges.entrySet()) {
            T object = entry.getKey();
            boolean selected = entry.getValue();
            boolean defaultSelected = this.isDefaultSelected(object);
            Object key = this.getKey(object);
            Boolean previousException = this.exceptions.get(key);
            if (defaultSelected == selected) {
                if (previousException == null) continue;
                this.exceptions.remove(key);
                changed = true;
                continue;
            }
            if (previousException == Boolean.valueOf(selected)) continue;
            this.exceptions.put(key, selected);
            changed = true;
        }
        this.selectionChanges.clear();
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }
}

