/* gnulib.h - definitions and prototypes for the GNUish MS-DOS library
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/lib/RCS/gnulib.h 1.0 90/09/11 01:55:29 tho Exp $
 */

/* Memory allocation: (xmalloc.c, xrealloc.c)  */

extern void *xmalloc (size_t bytes);
extern void *xrealloc (void *buffer, size_t bytes);


/* Error messages: (error.c) */

extern void error (int status, int errnum, char *message, ...);


/* Globbing: (glob.c)  */

extern char **glob_filename (char *pathname);
extern char **glob_vector (char *pat, char *dir);
extern int glob_match (char *pattern, char *text, int dot_special);
extern int glob_pattern_p (char *pattern);


/* Prettier filenames: (_cwild.c)  */

extern char *msdos_format_filename (char *name);



/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
