/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_NV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_nxtVal(FILE * const f, fpos_t * const pos)

	Seek to next value and parse it

	*pos is updated with the position of the line actually read

ob: cfgi_nxtVal
ty: L
su: inifile/2
sh: Parse next value
lo: Read the next lines until either a valid line containing a value is found
	or the section ends.\par
	\tok{cfgi_ini.pos} is updated with the beginning of the found line.
re: cfg_brkNxtVal
fi: cfgi_nv.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_NV.C 1.3 1999/12/13 02:22:12 ska Exp ska $";
#endif

int cfgi_nxtVal(FILE * const f)
{	int rv;

	DBG_ENTER("cfgi_nxtVal", Suppl_inifile2)

	assert(f);

	/* Ignore ill-formed lines and comments */
	while((rv = cfgi_brkNxtVal(f)) == CFG_ERR_LINE
	 || rv == CFG_ERR_COMMENT)
		chkHeap

	DBG_RETURN_I( rv)
}
