/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.test.interop.InteropTest;
import org.apache.xml.security.test.utils.resolver.OfflineResolver;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class IBMTest
extends InteropTest {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$interop$IBMTest == null ? (class$org$apache$xml$security$test$interop$IBMTest = IBMTest.class$("org.apache.xml.security.test.interop.IBMTest")) : class$org$apache$xml$security$test$interop$IBMTest).getName());
    static final String kentsDir = "data/com/ibm/xss4j-20030127/";
    static /* synthetic */ Class class$org$apache$xml$security$test$interop$IBMTest;

    public static Test suite() {
        TestSuite testSuite = new TestSuite(class$org$apache$xml$security$test$interop$IBMTest == null ? (class$org$apache$xml$security$test$interop$IBMTest = IBMTest.class$("org.apache.xml.security.test.interop.IBMTest")) : class$org$apache$xml$security$test$interop$IBMTest);
        return testSuite;
    }

    public IBMTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$interop$IBMTest == null ? (class$org$apache$xml$security$test$interop$IBMTest = IBMTest.class$("org.apache.xml.security.test.interop.IBMTest")) : class$org$apache$xml$security$test$interop$IBMTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void test_enveloping_hmac() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloping-hmac.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        byte[] byArray = JavaUtils.getBytesFromFile((String)"data/com/ibm/xss4j-20030127/enveloping-hmac.key");
        boolean bl2 = false;
        try {
            bl2 = this.verifyHMAC(string, offlineResolver, bl, byArray);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_detached_dsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/detached-dsa.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_detached_rsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/detached-rsa.sig";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_enveloped_dsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloped-dsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_enveloped_rsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloped-rsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_enveloping_dsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloping-dsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_enveloping_rsa() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloping-rsa.sig";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        IBMTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_enveloping_dsa_soaped_broken() throws Exception {
        String string = "data/com/ibm/xss4j-20030127/enveloping-dsa-soaped-broken.sig";
        if (!new File(string).exists()) {
            System.err.println("Couldn't find: " + string + " and couldn't do the test");
            return;
        }
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (bl2) {
            log.error((Object)("Verification failed for " + string + ", had to be broken but was successful"));
        }
        IBMTest.assertTrue((String)string, (!bl2 ? 1 : 0) != 0);
    }

    public void _not_active_test_enveloping_exclusive() throws Exception {
    }

    public void _not_active_test_enveloping_exclusive_soaped() throws Exception {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

