//
// Copyright (c) 2020, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "nscq/logger.hpp"
#include "nscq/nscq.h"

namespace nscq {

enum class warning {
    none = NSCQ_RC_SUCCESS,
    rdt_init_failure = NSCQ_RC_WARNING_RDT_INIT_FAILURE,
};

auto warn(warning w) -> void;
auto consume_warning() -> warning;

// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define NSCQ_WARN(w, fmt, ...)                       \
    do {                                             \
        warn(w);                                     \
        NSCQ_LOG_WARN("{}: " fmt, w, ##__VA_ARGS__); \
    } while (0)

} // namespace nscq
