/*
 * BRender PIX image demuxer
 * Copyright (c) 2014 Michael Niedermayer
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "img2.h"
#include "libavutil/intreadwrite.h"

static int brender_read_probe(AVProbeData *p)
{
    static const uint8_t brender_magic[16] = {
        0,0,0,0x12,0,0,0,8,0,0,0,2,0,0,0,2
    };

    if (memcmp(p->buf, brender_magic, sizeof(brender_magic)))
        return 0;

    if (AV_RB32(p->buf+16) != 0x03 &&
        AV_RB32(p->buf+16) != 0x3D)
        return 0;

    return AVPROBE_SCORE_MAX-10;
}

static const AVClass image2_brender_pix_class = {
#ifdef IDE_COMPILE
    "brender_pix demuxer",
    av_default_item_name,
    ff_img_options,
    LIBAVUTIL_VERSION_INT,
#else
	.class_name = "brender_pix demuxer",
    .item_name  = av_default_item_name,
    .option     = ff_img_options,
    .version    = LIBAVUTIL_VERSION_INT,
#endif
};

AVInputFormat ff_image2_brender_pix_demuxer = {
#ifdef IDE_COMPILE
    "brender_pix",
    "BRender PIX image",
    0, 0, 0, &image2_brender_pix_class,
    0, 0, AV_CODEC_ID_BRENDER_PIX,
    sizeof(VideoDemuxData),
    brender_read_probe,
    ff_img_read_header,
    ff_img_read_packet,
#else
	.name           = "brender_pix",
    .long_name      = NULL_IF_CONFIG_SMALL("BRender PIX image"),
    .priv_data_size = sizeof(VideoDemuxData),
    .read_probe     = brender_read_probe,
    .read_header    = ff_img_read_header,
    .read_packet    = ff_img_read_packet,
    .raw_codec_id   = AV_CODEC_ID_BRENDER_PIX,
    .priv_class     = &image2_brender_pix_class,
#endif
};
