// ---------------------------------------------------------------------------
// - cucd.hxx                                                                -
// - standard platform library -  private unicode database definitions       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2021 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (AFNIX_PLATFORM_PROCID == AFNIX_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

namespace afnix {

  // the plane size
  const long  UCD_PSIZE_0000   = 27922;
  // the plane data
  const s_cucd UCD_PLANE_0000[] = {
    {
      0x00000000,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000001,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000002,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000003,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000004,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000005,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000006,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000007,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000008,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000009,
      "<control>",
      0x60, 0, 0x0B, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000A,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000B,
      "<control>",
      0x60, 0, 0x0B, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000C,
      "<control>",
      0x60, 0, 0x0C, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000D,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000E,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000000F,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000010,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000011,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000012,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000013,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000014,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000015,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000016,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000017,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000018,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000019,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001A,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001B,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001C,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001D,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001E,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000001F,
      "<control>",
      0x60, 0, 0x0B, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000020,
      "SPACE",
      0x50, 0, 0x0C, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000021,
      "EXCLAMATION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000022,
      "QUOTATION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000023,
      "NUMBER SIGN",
      0x36, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000024,
      "DOLLAR SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000025,
      "PERCENT SIGN",
      0x36, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000026,
      "AMPERSAND",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000027,
      "APOSTROPHE",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000028,
      "LEFT PARENTHESIS",
      0x32, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000029,
      "RIGHT PARENTHESIS",
      0x33, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002A,
      "ASTERISK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002B,
      "PLUS SIGN",
      0x40, 0, 0x04, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002C,
      "COMMA",
      0x36, 0, 0x07, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002D,
      "HYPHEN-MINUS",
      0x31, 0, 0x04, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002E,
      "FULL STOP",
      0x36, 0, 0x07, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000002F,
      "SOLIDUS",
      0x36, 0, 0x07, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000030,
      "DIGIT ZERO",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000031,
      "DIGIT ONE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000032,
      "DIGIT TWO",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000033,
      "DIGIT THREE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000034,
      "DIGIT FOUR",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000035,
      "DIGIT FIVE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000036,
      "DIGIT SIX",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000037,
      "DIGIT SEVEN",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000038,
      "DIGIT EIGHT",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000039,
      "DIGIT NINE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003A,
      "COLON",
      0x36, 0, 0x07, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003B,
      "SEMICOLON",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003C,
      "LESS-THAN SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003D,
      "EQUALS SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003E,
      "GREATER-THAN SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000003F,
      "QUESTION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000040,
      "COMMERCIAL AT",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000041,
      "LATIN CAPITAL LETTER A",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000061, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000042,
      "LATIN CAPITAL LETTER B",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000062, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000043,
      "LATIN CAPITAL LETTER C",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000063, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000044,
      "LATIN CAPITAL LETTER D",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000064, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000045,
      "LATIN CAPITAL LETTER E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000065, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000046,
      "LATIN CAPITAL LETTER F",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000066, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000047,
      "LATIN CAPITAL LETTER G",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000067, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000048,
      "LATIN CAPITAL LETTER H",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000068, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000049,
      "LATIN CAPITAL LETTER I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000069, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004A,
      "LATIN CAPITAL LETTER J",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004B,
      "LATIN CAPITAL LETTER K",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004C,
      "LATIN CAPITAL LETTER L",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004D,
      "LATIN CAPITAL LETTER M",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004E,
      "LATIN CAPITAL LETTER N",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000004F,
      "LATIN CAPITAL LETTER O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000006F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000050,
      "LATIN CAPITAL LETTER P",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000070, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000051,
      "LATIN CAPITAL LETTER Q",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000071, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000052,
      "LATIN CAPITAL LETTER R",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000072, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000053,
      "LATIN CAPITAL LETTER S",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000073, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000054,
      "LATIN CAPITAL LETTER T",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000074, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000055,
      "LATIN CAPITAL LETTER U",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000075, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000056,
      "LATIN CAPITAL LETTER V",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000076, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000057,
      "LATIN CAPITAL LETTER W",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000077, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000058,
      "LATIN CAPITAL LETTER X",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000078, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000059,
      "LATIN CAPITAL LETTER Y",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000079, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005A,
      "LATIN CAPITAL LETTER Z",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000007A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005B,
      "LEFT SQUARE BRACKET",
      0x32, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005C,
      "REVERSE SOLIDUS",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005D,
      "RIGHT SQUARE BRACKET",
      0x33, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005E,
      "CIRCUMFLEX ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000005F,
      "LOW LINE",
      0x30, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000060,
      "GRAVE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000061,
      "LATIN SMALL LETTER A",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000041, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000041, 0x00000000, 0x00000000}
    },
    {
      0x00000062,
      "LATIN SMALL LETTER B",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000042, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000042, 0x00000000, 0x00000000}
    },
    {
      0x00000063,
      "LATIN SMALL LETTER C",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000043, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000043, 0x00000000, 0x00000000}
    },
    {
      0x00000064,
      "LATIN SMALL LETTER D",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000044, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000044, 0x00000000, 0x00000000}
    },
    {
      0x00000065,
      "LATIN SMALL LETTER E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000045, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000045, 0x00000000, 0x00000000}
    },
    {
      0x00000066,
      "LATIN SMALL LETTER F",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000046, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000046, 0x00000000, 0x00000000}
    },
    {
      0x00000067,
      "LATIN SMALL LETTER G",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000047, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000047, 0x00000000, 0x00000000}
    },
    {
      0x00000068,
      "LATIN SMALL LETTER H",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000048, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000048, 0x00000000, 0x00000000}
    },
    {
      0x00000069,
      "LATIN SMALL LETTER I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000049, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000049, 0x00000000, 0x00000000}
    },
    {
      0x0000006A,
      "LATIN SMALL LETTER J",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004A, 0x00000000, 0x00000000}
    },
    {
      0x0000006B,
      "LATIN SMALL LETTER K",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004B, 0x00000000, 0x00000000}
    },
    {
      0x0000006C,
      "LATIN SMALL LETTER L",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004C, 0x00000000, 0x00000000}
    },
    {
      0x0000006D,
      "LATIN SMALL LETTER M",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004D, 0x00000000, 0x00000000}
    },
    {
      0x0000006E,
      "LATIN SMALL LETTER N",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004E, 0x00000000, 0x00000000}
    },
    {
      0x0000006F,
      "LATIN SMALL LETTER O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000004F, 0x00000000, 0x00000000}
    },
    {
      0x00000070,
      "LATIN SMALL LETTER P",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000050, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000050, 0x00000000, 0x00000000}
    },
    {
      0x00000071,
      "LATIN SMALL LETTER Q",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000051, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000051, 0x00000000, 0x00000000}
    },
    {
      0x00000072,
      "LATIN SMALL LETTER R",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000052, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000052, 0x00000000, 0x00000000}
    },
    {
      0x00000073,
      "LATIN SMALL LETTER S",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000053, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000053, 0x00000000, 0x00000000}
    },
    {
      0x00000074,
      "LATIN SMALL LETTER T",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000054, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000054, 0x00000000, 0x00000000}
    },
    {
      0x00000075,
      "LATIN SMALL LETTER U",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000055, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000055, 0x00000000, 0x00000000}
    },
    {
      0x00000076,
      "LATIN SMALL LETTER V",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000056, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000056, 0x00000000, 0x00000000}
    },
    {
      0x00000077,
      "LATIN SMALL LETTER W",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000057, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000057, 0x00000000, 0x00000000}
    },
    {
      0x00000078,
      "LATIN SMALL LETTER X",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000058, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000058, 0x00000000, 0x00000000}
    },
    {
      0x00000079,
      "LATIN SMALL LETTER Y",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000059, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000059, 0x00000000, 0x00000000}
    },
    {
      0x0000007A,
      "LATIN SMALL LETTER Z",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000005A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000005A, 0x00000000, 0x00000000}
    },
    {
      0x0000007B,
      "LEFT CURLY BRACKET",
      0x32, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000007C,
      "VERTICAL LINE",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000007D,
      "RIGHT CURLY BRACKET",
      0x33, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000007E,
      "TILDE",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000007F,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000080,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000081,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000082,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000083,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000084,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000085,
      "<control>",
      0x60, 0, 0x0A, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000086,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000087,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000088,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000089,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008A,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008B,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008C,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008D,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008E,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000008F,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000090,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000091,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000092,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000093,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000094,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000095,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000096,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000097,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000098,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000099,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009A,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009B,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009C,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009D,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009E,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000009F,
      "<control>",
      0x60, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A0,
      "NO-BREAK SPACE",
      0x50, 0, 0x07, 0x00,
      0x02,
      {0x00000020, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A1,
      "INVERTED EXCLAMATION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A2,
      "CENT SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A3,
      "POUND SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A4,
      "CURRENCY SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A5,
      "YEN SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A6,
      "BROKEN BAR",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A7,
      "SECTION SIGN",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A8,
      "DIAERESIS",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000A9,
      "COPYRIGHT SIGN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AA,
      "FEMININE ORDINAL INDICATOR",
      0x04, 0, 0x00, 0x00,
      0x08,
      {0x00000061, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AB,
      "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
      0x34, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AC,
      "NOT SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AD,
      "SOFT HYPHEN",
      0x61, 0, 0x09, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AE,
      "REGISTERED SIGN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000AF,
      "MACRON",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B0,
      "DEGREE SIGN",
      0x43, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B1,
      "PLUS-MINUS SIGN",
      0x40, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B2,
      "SUPERSCRIPT TWO",
      0x22, 0, 0x03, 0x00,
      0x08,
      {0x00000032, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B3,
      "SUPERSCRIPT THREE",
      0x22, 0, 0x03, 0x00,
      0x08,
      {0x00000033, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B4,
      "ACUTE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B5,
      "MICRO SIGN",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003BC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039C, 0x00000000, 0x00000000}
    },
    {
      0x000000B6,
      "PILCROW SIGN",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B7,
      "MIDDLE DOT",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B8,
      "CEDILLA",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000B9,
      "SUPERSCRIPT ONE",
      0x22, 0, 0x03, 0x00,
      0x08,
      {0x00000031, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BA,
      "MASCULINE ORDINAL INDICATOR",
      0x04, 0, 0x00, 0x00,
      0x08,
      {0x0000006F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BB,
      "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
      0x35, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BC,
      "VULGAR FRACTION ONE QUARTER",
      0x22, 0, 0x0D, 0x00,
      0x0F,
      {0x00000031, 0x00002044, 0x00000034,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BD,
      "VULGAR FRACTION ONE HALF",
      0x22, 0, 0x0D, 0x00,
      0x0F,
      {0x00000031, 0x00002044, 0x00000032,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BE,
      "VULGAR FRACTION THREE QUARTERS",
      0x22, 0, 0x0D, 0x00,
      0x0F,
      {0x00000033, 0x00002044, 0x00000034,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000BF,
      "INVERTED QUESTION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C0,
      "LATIN CAPITAL LETTER A WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C1,
      "LATIN CAPITAL LETTER A WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C2,
      "LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C3,
      "LATIN CAPITAL LETTER A WITH TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C4,
      "LATIN CAPITAL LETTER A WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C5,
      "LATIN CAPITAL LETTER A WITH RING ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x0000030A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C6,
      "LATIN CAPITAL LETTER AE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C7,
      "LATIN CAPITAL LETTER C WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000043, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C8,
      "LATIN CAPITAL LETTER E WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000C9,
      "LATIN CAPITAL LETTER E WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000E9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CA,
      "LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000EA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CB,
      "LATIN CAPITAL LETTER E WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000EB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CC,
      "LATIN CAPITAL LETTER I WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000EC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CD,
      "LATIN CAPITAL LETTER I WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000ED, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CE,
      "LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000EE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000CF,
      "LATIN CAPITAL LETTER I WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000EF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D0,
      "LATIN CAPITAL LETTER ETH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D1,
      "LATIN CAPITAL LETTER N WITH TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004E, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D2,
      "LATIN CAPITAL LETTER O WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D3,
      "LATIN CAPITAL LETTER O WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D4,
      "LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D5,
      "LATIN CAPITAL LETTER O WITH TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D6,
      "LATIN CAPITAL LETTER O WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D7,
      "MULTIPLICATION SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D8,
      "LATIN CAPITAL LETTER O WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000D9,
      "LATIN CAPITAL LETTER U WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000F9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DA,
      "LATIN CAPITAL LETTER U WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DB,
      "LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DC,
      "LATIN CAPITAL LETTER U WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DD,
      "LATIN CAPITAL LETTER Y WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000059, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DE,
      "LATIN CAPITAL LETTER THORN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000DF,
      "LATIN SMALL LETTER SHARP S",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000053, 0x00000053, 0x00000000},
      {0x000000DF, 0x00000000, 0x00000000},
      {0x00000053, 0x00000073, 0x00000000}
    },
    {
      0x000000E0,
      "LATIN SMALL LETTER A WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C0, 0x00000000, 0x00000000}
    },
    {
      0x000000E1,
      "LATIN SMALL LETTER A WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C1, 0x00000000, 0x00000000}
    },
    {
      0x000000E2,
      "LATIN SMALL LETTER A WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C2, 0x00000000, 0x00000000}
    },
    {
      0x000000E3,
      "LATIN SMALL LETTER A WITH TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C3, 0x00000000, 0x00000000}
    },
    {
      0x000000E4,
      "LATIN SMALL LETTER A WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C4, 0x00000000, 0x00000000}
    },
    {
      0x000000E5,
      "LATIN SMALL LETTER A WITH RING ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x0000030A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C5, 0x00000000, 0x00000000}
    },
    {
      0x000000E6,
      "LATIN SMALL LETTER AE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C6, 0x00000000, 0x00000000}
    },
    {
      0x000000E7,
      "LATIN SMALL LETTER C WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000063, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C7, 0x00000000, 0x00000000}
    },
    {
      0x000000E8,
      "LATIN SMALL LETTER E WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C8, 0x00000000, 0x00000000}
    },
    {
      0x000000E9,
      "LATIN SMALL LETTER E WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000C9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000C9, 0x00000000, 0x00000000}
    },
    {
      0x000000EA,
      "LATIN SMALL LETTER E WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CA, 0x00000000, 0x00000000}
    },
    {
      0x000000EB,
      "LATIN SMALL LETTER E WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CB, 0x00000000, 0x00000000}
    },
    {
      0x000000EC,
      "LATIN SMALL LETTER I WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CC, 0x00000000, 0x00000000}
    },
    {
      0x000000ED,
      "LATIN SMALL LETTER I WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CD, 0x00000000, 0x00000000}
    },
    {
      0x000000EE,
      "LATIN SMALL LETTER I WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CE, 0x00000000, 0x00000000}
    },
    {
      0x000000EF,
      "LATIN SMALL LETTER I WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000CF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000CF, 0x00000000, 0x00000000}
    },
    {
      0x000000F0,
      "LATIN SMALL LETTER ETH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D0, 0x00000000, 0x00000000}
    },
    {
      0x000000F1,
      "LATIN SMALL LETTER N WITH TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006E, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D1, 0x00000000, 0x00000000}
    },
    {
      0x000000F2,
      "LATIN SMALL LETTER O WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D2, 0x00000000, 0x00000000}
    },
    {
      0x000000F3,
      "LATIN SMALL LETTER O WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D3, 0x00000000, 0x00000000}
    },
    {
      0x000000F4,
      "LATIN SMALL LETTER O WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D4, 0x00000000, 0x00000000}
    },
    {
      0x000000F5,
      "LATIN SMALL LETTER O WITH TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D5, 0x00000000, 0x00000000}
    },
    {
      0x000000F6,
      "LATIN SMALL LETTER O WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D6, 0x00000000, 0x00000000}
    },
    {
      0x000000F7,
      "DIVISION SIGN",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000000F8,
      "LATIN SMALL LETTER O WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D8, 0x00000000, 0x00000000}
    },
    {
      0x000000F9,
      "LATIN SMALL LETTER U WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000D9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000D9, 0x00000000, 0x00000000}
    },
    {
      0x000000FA,
      "LATIN SMALL LETTER U WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000DA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000DA, 0x00000000, 0x00000000}
    },
    {
      0x000000FB,
      "LATIN SMALL LETTER U WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000DB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000DB, 0x00000000, 0x00000000}
    },
    {
      0x000000FC,
      "LATIN SMALL LETTER U WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000DC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000DC, 0x00000000, 0x00000000}
    },
    {
      0x000000FD,
      "LATIN SMALL LETTER Y WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000079, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000DD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000DD, 0x00000000, 0x00000000}
    },
    {
      0x000000FE,
      "LATIN SMALL LETTER THORN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000000DE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000DE, 0x00000000, 0x00000000}
    },
    {
      0x000000FF,
      "LATIN SMALL LETTER Y WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000079, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000178, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000178, 0x00000000, 0x00000000}
    },
    {
      0x00000100,
      "LATIN CAPITAL LETTER A WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000101, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000101,
      "LATIN SMALL LETTER A WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000100, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000100, 0x00000000, 0x00000000}
    },
    {
      0x00000102,
      "LATIN CAPITAL LETTER A WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000103, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000103,
      "LATIN SMALL LETTER A WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000102, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000102, 0x00000000, 0x00000000}
    },
    {
      0x00000104,
      "LATIN CAPITAL LETTER A WITH OGONEK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000105, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000105,
      "LATIN SMALL LETTER A WITH OGONEK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000104, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000104, 0x00000000, 0x00000000}
    },
    {
      0x00000106,
      "LATIN CAPITAL LETTER C WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000043, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000107, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000107,
      "LATIN SMALL LETTER C WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000063, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000106, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000106, 0x00000000, 0x00000000}
    },
    {
      0x00000108,
      "LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000043, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000109, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000109,
      "LATIN SMALL LETTER C WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000063, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000108, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000108, 0x00000000, 0x00000000}
    },
    {
      0x0000010A,
      "LATIN CAPITAL LETTER C WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000043, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000010B,
      "LATIN SMALL LETTER C WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000063, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000010A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010A, 0x00000000, 0x00000000}
    },
    {
      0x0000010C,
      "LATIN CAPITAL LETTER C WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000043, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000010D,
      "LATIN SMALL LETTER C WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000063, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000010C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010C, 0x00000000, 0x00000000}
    },
    {
      0x0000010E,
      "LATIN CAPITAL LETTER D WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000044, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000010F,
      "LATIN SMALL LETTER D WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000064, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000010E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000010E, 0x00000000, 0x00000000}
    },
    {
      0x00000110,
      "LATIN CAPITAL LETTER D WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000111, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000111,
      "LATIN SMALL LETTER D WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000110, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000110, 0x00000000, 0x00000000}
    },
    {
      0x00000112,
      "LATIN CAPITAL LETTER E WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000113, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000113,
      "LATIN SMALL LETTER E WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000112, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000112, 0x00000000, 0x00000000}
    },
    {
      0x00000114,
      "LATIN CAPITAL LETTER E WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000115, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000115,
      "LATIN SMALL LETTER E WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000114, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000114, 0x00000000, 0x00000000}
    },
    {
      0x00000116,
      "LATIN CAPITAL LETTER E WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000117, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000117,
      "LATIN SMALL LETTER E WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000116, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000116, 0x00000000, 0x00000000}
    },
    {
      0x00000118,
      "LATIN CAPITAL LETTER E WITH OGONEK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000119, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000119,
      "LATIN SMALL LETTER E WITH OGONEK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000118, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000118, 0x00000000, 0x00000000}
    },
    {
      0x0000011A,
      "LATIN CAPITAL LETTER E WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000011B,
      "LATIN SMALL LETTER E WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000011A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011A, 0x00000000, 0x00000000}
    },
    {
      0x0000011C,
      "LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000011D,
      "LATIN SMALL LETTER G WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000011C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011C, 0x00000000, 0x00000000}
    },
    {
      0x0000011E,
      "LATIN CAPITAL LETTER G WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000011F,
      "LATIN SMALL LETTER G WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000011E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000011E, 0x00000000, 0x00000000}
    },
    {
      0x00000120,
      "LATIN CAPITAL LETTER G WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000121, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000121,
      "LATIN SMALL LETTER G WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000120, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000120, 0x00000000, 0x00000000}
    },
    {
      0x00000122,
      "LATIN CAPITAL LETTER G WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000123, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000123,
      "LATIN SMALL LETTER G WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000122, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000122, 0x00000000, 0x00000000}
    },
    {
      0x00000124,
      "LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000048, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000125, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000125,
      "LATIN SMALL LETTER H WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000068, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000124, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000124, 0x00000000, 0x00000000}
    },
    {
      0x00000126,
      "LATIN CAPITAL LETTER H WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000127, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000127,
      "LATIN SMALL LETTER H WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000126, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000126, 0x00000000, 0x00000000}
    },
    {
      0x00000128,
      "LATIN CAPITAL LETTER I WITH TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000129, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000129,
      "LATIN SMALL LETTER I WITH TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000128, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000128, 0x00000000, 0x00000000}
    },
    {
      0x0000012A,
      "LATIN CAPITAL LETTER I WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000012B,
      "LATIN SMALL LETTER I WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000012A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012A, 0x00000000, 0x00000000}
    },
    {
      0x0000012C,
      "LATIN CAPITAL LETTER I WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000012D,
      "LATIN SMALL LETTER I WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000012C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012C, 0x00000000, 0x00000000}
    },
    {
      0x0000012E,
      "LATIN CAPITAL LETTER I WITH OGONEK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000012F,
      "LATIN SMALL LETTER I WITH OGONEK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000012E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000012E, 0x00000000, 0x00000000}
    },
    {
      0x00000130,
      "LATIN CAPITAL LETTER I WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000130, 0x00000000, 0x00000000},
      {0x00000069, 0x00000307, 0x00000000},
      {0x00000130, 0x00000000, 0x00000000}
    },
    {
      0x00000131,
      "LATIN SMALL LETTER DOTLESS I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000049, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000049, 0x00000000, 0x00000000}
    },
    {
      0x00000132,
      "LATIN CAPITAL LIGATURE IJ",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x00000049, 0x0000004A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000133, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000133,
      "LATIN SMALL LIGATURE IJ",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x00000069, 0x0000006A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000132, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000132, 0x00000000, 0x00000000}
    },
    {
      0x00000134,
      "LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004A, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000135, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000135,
      "LATIN SMALL LETTER J WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006A, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000134, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000134, 0x00000000, 0x00000000}
    },
    {
      0x00000136,
      "LATIN CAPITAL LETTER K WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004B, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000137, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000137,
      "LATIN SMALL LETTER K WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006B, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000136, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000136, 0x00000000, 0x00000000}
    },
    {
      0x00000138,
      "LATIN SMALL LETTER KRA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000139,
      "LATIN CAPITAL LETTER L WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004C, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000013A,
      "LATIN SMALL LETTER L WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006C, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000139, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000139, 0x00000000, 0x00000000}
    },
    {
      0x0000013B,
      "LATIN CAPITAL LETTER L WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004C, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000013C,
      "LATIN SMALL LETTER L WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006C, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000013B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013B, 0x00000000, 0x00000000}
    },
    {
      0x0000013D,
      "LATIN CAPITAL LETTER L WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004C, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000013E,
      "LATIN SMALL LETTER L WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006C, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000013D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013D, 0x00000000, 0x00000000}
    },
    {
      0x0000013F,
      "LATIN CAPITAL LETTER L WITH MIDDLE DOT",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x0000004C, 0x000000B7, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000140, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000140,
      "LATIN SMALL LETTER L WITH MIDDLE DOT",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x0000006C, 0x000000B7, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000013F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000013F, 0x00000000, 0x00000000}
    },
    {
      0x00000141,
      "LATIN CAPITAL LETTER L WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000142, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000142,
      "LATIN SMALL LETTER L WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000141, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000141, 0x00000000, 0x00000000}
    },
    {
      0x00000143,
      "LATIN CAPITAL LETTER N WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004E, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000144, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000144,
      "LATIN SMALL LETTER N WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006E, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000143, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000143, 0x00000000, 0x00000000}
    },
    {
      0x00000145,
      "LATIN CAPITAL LETTER N WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004E, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000146, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000146,
      "LATIN SMALL LETTER N WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006E, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000145, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000145, 0x00000000, 0x00000000}
    },
    {
      0x00000147,
      "LATIN CAPITAL LETTER N WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004E, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000148, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000148,
      "LATIN SMALL LETTER N WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006E, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000147, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000147, 0x00000000, 0x00000000}
    },
    {
      0x00000149,
      "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000002BC, 0x0000006E, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000002BC, 0x0000004E, 0x00000000},
      {0x00000149, 0x00000000, 0x00000000},
      {0x000002BC, 0x0000004E, 0x00000000}
    },
    {
      0x0000014A,
      "LATIN CAPITAL LETTER ENG",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000014B,
      "LATIN SMALL LETTER ENG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000014A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014A, 0x00000000, 0x00000000}
    },
    {
      0x0000014C,
      "LATIN CAPITAL LETTER O WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000014D,
      "LATIN SMALL LETTER O WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000014C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014C, 0x00000000, 0x00000000}
    },
    {
      0x0000014E,
      "LATIN CAPITAL LETTER O WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000014F,
      "LATIN SMALL LETTER O WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000014E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000014E, 0x00000000, 0x00000000}
    },
    {
      0x00000150,
      "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000151, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000151,
      "LATIN SMALL LETTER O WITH DOUBLE ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000150, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000150, 0x00000000, 0x00000000}
    },
    {
      0x00000152,
      "LATIN CAPITAL LIGATURE OE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000153, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000153,
      "LATIN SMALL LIGATURE OE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000152, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000152, 0x00000000, 0x00000000}
    },
    {
      0x00000154,
      "LATIN CAPITAL LETTER R WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000052, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000155, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000155,
      "LATIN SMALL LETTER R WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000072, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000154, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000154, 0x00000000, 0x00000000}
    },
    {
      0x00000156,
      "LATIN CAPITAL LETTER R WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000052, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000157, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000157,
      "LATIN SMALL LETTER R WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000072, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000156, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000156, 0x00000000, 0x00000000}
    },
    {
      0x00000158,
      "LATIN CAPITAL LETTER R WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000052, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000159, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000159,
      "LATIN SMALL LETTER R WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000072, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000158, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000158, 0x00000000, 0x00000000}
    },
    {
      0x0000015A,
      "LATIN CAPITAL LETTER S WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000053, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000015B,
      "LATIN SMALL LETTER S WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000073, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000015A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015A, 0x00000000, 0x00000000}
    },
    {
      0x0000015C,
      "LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000053, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000015D,
      "LATIN SMALL LETTER S WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000073, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000015C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015C, 0x00000000, 0x00000000}
    },
    {
      0x0000015E,
      "LATIN CAPITAL LETTER S WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000053, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000015F,
      "LATIN SMALL LETTER S WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000073, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000015E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000015E, 0x00000000, 0x00000000}
    },
    {
      0x00000160,
      "LATIN CAPITAL LETTER S WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000053, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000161, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000161,
      "LATIN SMALL LETTER S WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000073, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000160, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000160, 0x00000000, 0x00000000}
    },
    {
      0x00000162,
      "LATIN CAPITAL LETTER T WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000054, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000163, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000163,
      "LATIN SMALL LETTER T WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000074, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000162, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000162, 0x00000000, 0x00000000}
    },
    {
      0x00000164,
      "LATIN CAPITAL LETTER T WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000054, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000165, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000165,
      "LATIN SMALL LETTER T WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000074, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000164, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000164, 0x00000000, 0x00000000}
    },
    {
      0x00000166,
      "LATIN CAPITAL LETTER T WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000167, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000167,
      "LATIN SMALL LETTER T WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000166, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000166, 0x00000000, 0x00000000}
    },
    {
      0x00000168,
      "LATIN CAPITAL LETTER U WITH TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000169, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000169,
      "LATIN SMALL LETTER U WITH TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000168, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000168, 0x00000000, 0x00000000}
    },
    {
      0x0000016A,
      "LATIN CAPITAL LETTER U WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000016B,
      "LATIN SMALL LETTER U WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000016A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016A, 0x00000000, 0x00000000}
    },
    {
      0x0000016C,
      "LATIN CAPITAL LETTER U WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000016D,
      "LATIN SMALL LETTER U WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000016C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016C, 0x00000000, 0x00000000}
    },
    {
      0x0000016E,
      "LATIN CAPITAL LETTER U WITH RING ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x0000030A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000016F,
      "LATIN SMALL LETTER U WITH RING ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x0000030A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000016E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000016E, 0x00000000, 0x00000000}
    },
    {
      0x00000170,
      "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000171, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000171,
      "LATIN SMALL LETTER U WITH DOUBLE ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000170, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000170, 0x00000000, 0x00000000}
    },
    {
      0x00000172,
      "LATIN CAPITAL LETTER U WITH OGONEK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000173, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000173,
      "LATIN SMALL LETTER U WITH OGONEK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000172, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000172, 0x00000000, 0x00000000}
    },
    {
      0x00000174,
      "LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000057, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000175, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000175,
      "LATIN SMALL LETTER W WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000077, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000174, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000174, 0x00000000, 0x00000000}
    },
    {
      0x00000176,
      "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000059, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000177, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000177,
      "LATIN SMALL LETTER Y WITH CIRCUMFLEX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000079, 0x00000302, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000176, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000176, 0x00000000, 0x00000000}
    },
    {
      0x00000178,
      "LATIN CAPITAL LETTER Y WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000059, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000000FF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000179,
      "LATIN CAPITAL LETTER Z WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000005A, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000017A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000017A,
      "LATIN SMALL LETTER Z WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000007A, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000179, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000179, 0x00000000, 0x00000000}
    },
    {
      0x0000017B,
      "LATIN CAPITAL LETTER Z WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000005A, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000017C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000017C,
      "LATIN SMALL LETTER Z WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000007A, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000017B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000017B, 0x00000000, 0x00000000}
    },
    {
      0x0000017D,
      "LATIN CAPITAL LETTER Z WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000005A, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000017E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000017E,
      "LATIN SMALL LETTER Z WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000007A, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000017D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000017D, 0x00000000, 0x00000000}
    },
    {
      0x0000017F,
      "LATIN SMALL LETTER LONG S",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x00000073, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000053, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000053, 0x00000000, 0x00000000}
    },
    {
      0x00000180,
      "LATIN SMALL LETTER B WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000243, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000243, 0x00000000, 0x00000000}
    },
    {
      0x00000181,
      "LATIN CAPITAL LETTER B WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000253, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000182,
      "LATIN CAPITAL LETTER B WITH TOPBAR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000183, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000183,
      "LATIN SMALL LETTER B WITH TOPBAR",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000182, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000182, 0x00000000, 0x00000000}
    },
    {
      0x00000184,
      "LATIN CAPITAL LETTER TONE SIX",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000185, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000185,
      "LATIN SMALL LETTER TONE SIX",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000184, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000184, 0x00000000, 0x00000000}
    },
    {
      0x00000186,
      "LATIN CAPITAL LETTER OPEN O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000254, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000187,
      "LATIN CAPITAL LETTER C WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000188, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000188,
      "LATIN SMALL LETTER C WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000187, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000187, 0x00000000, 0x00000000}
    },
    {
      0x00000189,
      "LATIN CAPITAL LETTER AFRICAN D",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000256, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000018A,
      "LATIN CAPITAL LETTER D WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000257, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000018B,
      "LATIN CAPITAL LETTER D WITH TOPBAR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000018C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000018C,
      "LATIN SMALL LETTER D WITH TOPBAR",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000018B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000018B, 0x00000000, 0x00000000}
    },
    {
      0x0000018D,
      "LATIN SMALL LETTER TURNED DELTA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000018E,
      "LATIN CAPITAL LETTER REVERSED E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000018F,
      "LATIN CAPITAL LETTER SCHWA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000259, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000190,
      "LATIN CAPITAL LETTER OPEN E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000025B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000191,
      "LATIN CAPITAL LETTER F WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000192, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000192,
      "LATIN SMALL LETTER F WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000191, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000191, 0x00000000, 0x00000000}
    },
    {
      0x00000193,
      "LATIN CAPITAL LETTER G WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000260, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000194,
      "LATIN CAPITAL LETTER GAMMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000263, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000195,
      "LATIN SMALL LETTER HV",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F6, 0x00000000, 0x00000000}
    },
    {
      0x00000196,
      "LATIN CAPITAL LETTER IOTA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000269, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000197,
      "LATIN CAPITAL LETTER I WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000268, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000198,
      "LATIN CAPITAL LETTER K WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000199, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000199,
      "LATIN SMALL LETTER K WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000198, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000198, 0x00000000, 0x00000000}
    },
    {
      0x0000019A,
      "LATIN SMALL LETTER L WITH BAR",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000023D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000023D, 0x00000000, 0x00000000}
    },
    {
      0x0000019B,
      "LATIN SMALL LETTER LAMBDA WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000019C,
      "LATIN CAPITAL LETTER TURNED M",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000026F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000019D,
      "LATIN CAPITAL LETTER N WITH LEFT HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000272, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000019E,
      "LATIN SMALL LETTER N WITH LONG RIGHT LEG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000220, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000220, 0x00000000, 0x00000000}
    },
    {
      0x0000019F,
      "LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000275, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A0,
      "LATIN CAPITAL LETTER O WITH HORN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x0000031B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A1,
      "LATIN SMALL LETTER O WITH HORN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x0000031B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A0, 0x00000000, 0x00000000}
    },
    {
      0x000001A2,
      "LATIN CAPITAL LETTER OI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A3,
      "LATIN SMALL LETTER OI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A2, 0x00000000, 0x00000000}
    },
    {
      0x000001A4,
      "LATIN CAPITAL LETTER P WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A5,
      "LATIN SMALL LETTER P WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A4, 0x00000000, 0x00000000}
    },
    {
      0x000001A6,
      "LATIN LETTER YR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000280, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A7,
      "LATIN CAPITAL LETTER TONE TWO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001A8,
      "LATIN SMALL LETTER TONE TWO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A7, 0x00000000, 0x00000000}
    },
    {
      0x000001A9,
      "LATIN CAPITAL LETTER ESH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000283, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001AA,
      "LATIN LETTER REVERSED ESH LOOP",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001AB,
      "LATIN SMALL LETTER T WITH PALATAL HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001AC,
      "LATIN CAPITAL LETTER T WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001AD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001AD,
      "LATIN SMALL LETTER T WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001AC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001AC, 0x00000000, 0x00000000}
    },
    {
      0x000001AE,
      "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000288, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001AF,
      "LATIN CAPITAL LETTER U WITH HORN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x0000031B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B0,
      "LATIN SMALL LETTER U WITH HORN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x0000031B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001AF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001AF, 0x00000000, 0x00000000}
    },
    {
      0x000001B1,
      "LATIN CAPITAL LETTER UPSILON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000028A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B2,
      "LATIN CAPITAL LETTER V WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000028B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B3,
      "LATIN CAPITAL LETTER Y WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B4,
      "LATIN SMALL LETTER Y WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B3, 0x00000000, 0x00000000}
    },
    {
      0x000001B5,
      "LATIN CAPITAL LETTER Z WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B6,
      "LATIN SMALL LETTER Z WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B5, 0x00000000, 0x00000000}
    },
    {
      0x000001B7,
      "LATIN CAPITAL LETTER EZH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000292, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B8,
      "LATIN CAPITAL LETTER EZH REVERSED",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001B9,
      "LATIN SMALL LETTER EZH REVERSED",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B8, 0x00000000, 0x00000000}
    },
    {
      0x000001BA,
      "LATIN SMALL LETTER EZH WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001BB,
      "LATIN LETTER TWO WITH STROKE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001BC,
      "LATIN CAPITAL LETTER TONE FIVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001BD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001BD,
      "LATIN SMALL LETTER TONE FIVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001BC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001BC, 0x00000000, 0x00000000}
    },
    {
      0x000001BE,
      "LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001BF,
      "LATIN LETTER WYNN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F7, 0x00000000, 0x00000000}
    },
    {
      0x000001C0,
      "LATIN LETTER DENTAL CLICK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001C1,
      "LATIN LETTER LATERAL CLICK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001C2,
      "LATIN LETTER ALVEOLAR CLICK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001C3,
      "LATIN LETTER RETROFLEX CLICK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001C4,
      "LATIN CAPITAL LETTER DZ WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x00000044, 0x0000017D, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001C6, 0x00000000, 0x00000000},
      {0x000001C5, 0x00000000, 0x00000000}
    },
    {
      0x000001C5,
      "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
      0x02, 0, 0x00, 0x00,
      0x10,
      {0x00000044, 0x0000017E, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001C4, 0x00000000, 0x00000000},
      {0x000001C6, 0x00000000, 0x00000000},
      {0x000001C5, 0x00000000, 0x00000000}
    },
    {
      0x000001C6,
      "LATIN SMALL LETTER DZ WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x00000064, 0x0000017E, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001C4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001C5, 0x00000000, 0x00000000}
    },
    {
      0x000001C7,
      "LATIN CAPITAL LETTER LJ",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x0000004C, 0x0000004A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001C9, 0x00000000, 0x00000000},
      {0x000001C8, 0x00000000, 0x00000000}
    },
    {
      0x000001C8,
      "LATIN CAPITAL LETTER L WITH SMALL LETTER J",
      0x02, 0, 0x00, 0x00,
      0x10,
      {0x0000004C, 0x0000006A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001C7, 0x00000000, 0x00000000},
      {0x000001C9, 0x00000000, 0x00000000},
      {0x000001C8, 0x00000000, 0x00000000}
    },
    {
      0x000001C9,
      "LATIN SMALL LETTER LJ",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x0000006C, 0x0000006A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001C7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001C8, 0x00000000, 0x00000000}
    },
    {
      0x000001CA,
      "LATIN CAPITAL LETTER NJ",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x0000004E, 0x0000004A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001CC, 0x00000000, 0x00000000},
      {0x000001CB, 0x00000000, 0x00000000}
    },
    {
      0x000001CB,
      "LATIN CAPITAL LETTER N WITH SMALL LETTER J",
      0x02, 0, 0x00, 0x00,
      0x10,
      {0x0000004E, 0x0000006A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001CA, 0x00000000, 0x00000000},
      {0x000001CC, 0x00000000, 0x00000000},
      {0x000001CB, 0x00000000, 0x00000000}
    },
    {
      0x000001CC,
      "LATIN SMALL LETTER NJ",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x0000006E, 0x0000006A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001CA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001CB, 0x00000000, 0x00000000}
    },
    {
      0x000001CD,
      "LATIN CAPITAL LETTER A WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001CE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001CE,
      "LATIN SMALL LETTER A WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001CD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001CD, 0x00000000, 0x00000000}
    },
    {
      0x000001CF,
      "LATIN CAPITAL LETTER I WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001D0,
      "LATIN SMALL LETTER I WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001CF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001CF, 0x00000000, 0x00000000}
    },
    {
      0x000001D1,
      "LATIN CAPITAL LETTER O WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001D2,
      "LATIN SMALL LETTER O WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001D1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D1, 0x00000000, 0x00000000}
    },
    {
      0x000001D3,
      "LATIN CAPITAL LETTER U WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001D4,
      "LATIN SMALL LETTER U WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001D3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D3, 0x00000000, 0x00000000}
    },
    {
      0x000001D5,
      "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000DC, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001D6,
      "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000FC, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001D5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D5, 0x00000000, 0x00000000}
    },
    {
      0x000001D7,
      "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000DC, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001D8,
      "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000FC, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001D7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D7, 0x00000000, 0x00000000}
    },
    {
      0x000001D9,
      "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000DC, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001DA,
      "LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000FC, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001D9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001D9, 0x00000000, 0x00000000}
    },
    {
      0x000001DB,
      "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000DC, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001DC,
      "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000FC, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001DB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DB, 0x00000000, 0x00000000}
    },
    {
      0x000001DD,
      "LATIN SMALL LETTER TURNED E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000018E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000018E, 0x00000000, 0x00000000}
    },
    {
      0x000001DE,
      "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000C4, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001DF,
      "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000E4, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001DE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001DE, 0x00000000, 0x00000000}
    },
    {
      0x000001E0,
      "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000226, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001E1,
      "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000227, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001E0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E0, 0x00000000, 0x00000000}
    },
    {
      0x000001E2,
      "LATIN CAPITAL LETTER AE WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000C6, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001E3,
      "LATIN SMALL LETTER AE WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000E6, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001E2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E2, 0x00000000, 0x00000000}
    },
    {
      0x000001E4,
      "LATIN CAPITAL LETTER G WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001E5,
      "LATIN SMALL LETTER G WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001E4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E4, 0x00000000, 0x00000000}
    },
    {
      0x000001E6,
      "LATIN CAPITAL LETTER G WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001E7,
      "LATIN SMALL LETTER G WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001E6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E6, 0x00000000, 0x00000000}
    },
    {
      0x000001E8,
      "LATIN CAPITAL LETTER K WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004B, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001E9,
      "LATIN SMALL LETTER K WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006B, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001E8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001E8, 0x00000000, 0x00000000}
    },
    {
      0x000001EA,
      "LATIN CAPITAL LETTER O WITH OGONEK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001EB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001EB,
      "LATIN SMALL LETTER O WITH OGONEK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001EA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001EA, 0x00000000, 0x00000000}
    },
    {
      0x000001EC,
      "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000001EA, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001ED, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001ED,
      "LATIN SMALL LETTER O WITH OGONEK AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000001EB, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001EC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001EC, 0x00000000, 0x00000000}
    },
    {
      0x000001EE,
      "LATIN CAPITAL LETTER EZH WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000001B7, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001EF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001EF,
      "LATIN SMALL LETTER EZH WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000292, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001EE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001EE, 0x00000000, 0x00000000}
    },
    {
      0x000001F0,
      "LATIN SMALL LETTER J WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006A, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000004A, 0x0000030C, 0x00000000},
      {0x000001F0, 0x00000000, 0x00000000},
      {0x0000004A, 0x0000030C, 0x00000000}
    },
    {
      0x000001F1,
      "LATIN CAPITAL LETTER DZ",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x00000044, 0x0000005A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F3, 0x00000000, 0x00000000},
      {0x000001F2, 0x00000000, 0x00000000}
    },
    {
      0x000001F2,
      "LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
      0x02, 0, 0x00, 0x00,
      0x10,
      {0x00000044, 0x0000007A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F1, 0x00000000, 0x00000000},
      {0x000001F3, 0x00000000, 0x00000000},
      {0x000001F2, 0x00000000, 0x00000000}
    },
    {
      0x000001F3,
      "LATIN SMALL LETTER DZ",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x00000064, 0x0000007A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F2, 0x00000000, 0x00000000}
    },
    {
      0x000001F4,
      "LATIN CAPITAL LETTER G WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000047, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001F5,
      "LATIN SMALL LETTER G WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000067, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F4, 0x00000000, 0x00000000}
    },
    {
      0x000001F6,
      "LATIN CAPITAL LETTER HWAIR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000195, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001F7,
      "LATIN CAPITAL LETTER WYNN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001BF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001F8,
      "LATIN CAPITAL LETTER N WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004E, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001F9,
      "LATIN SMALL LETTER N WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006E, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001F8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001F8, 0x00000000, 0x00000000}
    },
    {
      0x000001FA,
      "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000C5, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001FB,
      "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000E5, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001FA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FA, 0x00000000, 0x00000000}
    },
    {
      0x000001FC,
      "LATIN CAPITAL LETTER AE WITH ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000C6, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001FD,
      "LATIN SMALL LETTER AE WITH ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000E6, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001FC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FC, 0x00000000, 0x00000000}
    },
    {
      0x000001FE,
      "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000D8, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000001FF,
      "LATIN SMALL LETTER O WITH STROKE AND ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000F8, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001FE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001FE, 0x00000000, 0x00000000}
    },
    {
      0x00000200,
      "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000201, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000201,
      "LATIN SMALL LETTER A WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000200, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000200, 0x00000000, 0x00000000}
    },
    {
      0x00000202,
      "LATIN CAPITAL LETTER A WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000203, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000203,
      "LATIN SMALL LETTER A WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000202, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000202, 0x00000000, 0x00000000}
    },
    {
      0x00000204,
      "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000205, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000205,
      "LATIN SMALL LETTER E WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000204, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000204, 0x00000000, 0x00000000}
    },
    {
      0x00000206,
      "LATIN CAPITAL LETTER E WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000207, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000207,
      "LATIN SMALL LETTER E WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000206, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000206, 0x00000000, 0x00000000}
    },
    {
      0x00000208,
      "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000209, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000209,
      "LATIN SMALL LETTER I WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000208, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000208, 0x00000000, 0x00000000}
    },
    {
      0x0000020A,
      "LATIN CAPITAL LETTER I WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000049, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000020B,
      "LATIN SMALL LETTER I WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000069, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000020A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020A, 0x00000000, 0x00000000}
    },
    {
      0x0000020C,
      "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000020D,
      "LATIN SMALL LETTER O WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000020C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020C, 0x00000000, 0x00000000}
    },
    {
      0x0000020E,
      "LATIN CAPITAL LETTER O WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000020F,
      "LATIN SMALL LETTER O WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000020E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000020E, 0x00000000, 0x00000000}
    },
    {
      0x00000210,
      "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000052, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000211, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000211,
      "LATIN SMALL LETTER R WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000072, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000210, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000210, 0x00000000, 0x00000000}
    },
    {
      0x00000212,
      "LATIN CAPITAL LETTER R WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000052, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000213, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000213,
      "LATIN SMALL LETTER R WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000072, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000212, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000212, 0x00000000, 0x00000000}
    },
    {
      0x00000214,
      "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000215, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000215,
      "LATIN SMALL LETTER U WITH DOUBLE GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000214, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000214, 0x00000000, 0x00000000}
    },
    {
      0x00000216,
      "LATIN CAPITAL LETTER U WITH INVERTED BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000055, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000217, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000217,
      "LATIN SMALL LETTER U WITH INVERTED BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000075, 0x00000311, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000216, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000216, 0x00000000, 0x00000000}
    },
    {
      0x00000218,
      "LATIN CAPITAL LETTER S WITH COMMA BELOW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000053, 0x00000326, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000219, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000219,
      "LATIN SMALL LETTER S WITH COMMA BELOW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000073, 0x00000326, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000218, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000218, 0x00000000, 0x00000000}
    },
    {
      0x0000021A,
      "LATIN CAPITAL LETTER T WITH COMMA BELOW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000054, 0x00000326, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000021B,
      "LATIN SMALL LETTER T WITH COMMA BELOW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000074, 0x00000326, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000021A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021A, 0x00000000, 0x00000000}
    },
    {
      0x0000021C,
      "LATIN CAPITAL LETTER YOGH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000021D,
      "LATIN SMALL LETTER YOGH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000021C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021C, 0x00000000, 0x00000000}
    },
    {
      0x0000021E,
      "LATIN CAPITAL LETTER H WITH CARON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000048, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000021F,
      "LATIN SMALL LETTER H WITH CARON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000068, 0x0000030C, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000021E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000021E, 0x00000000, 0x00000000}
    },
    {
      0x00000220,
      "LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000019E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000221,
      "LATIN SMALL LETTER D WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000222,
      "LATIN CAPITAL LETTER OU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000223, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000223,
      "LATIN SMALL LETTER OU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000222, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000222, 0x00000000, 0x00000000}
    },
    {
      0x00000224,
      "LATIN CAPITAL LETTER Z WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000225, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000225,
      "LATIN SMALL LETTER Z WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000224, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000224, 0x00000000, 0x00000000}
    },
    {
      0x00000226,
      "LATIN CAPITAL LETTER A WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000041, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000227, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000227,
      "LATIN SMALL LETTER A WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000061, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000226, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000226, 0x00000000, 0x00000000}
    },
    {
      0x00000228,
      "LATIN CAPITAL LETTER E WITH CEDILLA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000045, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000229, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000229,
      "LATIN SMALL LETTER E WITH CEDILLA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000065, 0x00000327, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000228, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000228, 0x00000000, 0x00000000}
    },
    {
      0x0000022A,
      "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000D6, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000022B,
      "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000F6, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000022A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022A, 0x00000000, 0x00000000}
    },
    {
      0x0000022C,
      "LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000000D5, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000022D,
      "LATIN SMALL LETTER O WITH TILDE AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000000F5, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000022C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022C, 0x00000000, 0x00000000}
    },
    {
      0x0000022E,
      "LATIN CAPITAL LETTER O WITH DOT ABOVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000004F, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000022F,
      "LATIN SMALL LETTER O WITH DOT ABOVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000006F, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000022E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000022E, 0x00000000, 0x00000000}
    },
    {
      0x00000230,
      "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000022E, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000231, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000231,
      "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000022F, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000230, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000230, 0x00000000, 0x00000000}
    },
    {
      0x00000232,
      "LATIN CAPITAL LETTER Y WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000059, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000233, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000233,
      "LATIN SMALL LETTER Y WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000079, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000232, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000232, 0x00000000, 0x00000000}
    },
    {
      0x00000234,
      "LATIN SMALL LETTER L WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000235,
      "LATIN SMALL LETTER N WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000236,
      "LATIN SMALL LETTER T WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000237,
      "LATIN SMALL LETTER DOTLESS J",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000238,
      "LATIN SMALL LETTER DB DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000239,
      "LATIN SMALL LETTER QP DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000023A,
      "LATIN CAPITAL LETTER A WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C65, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000023B,
      "LATIN CAPITAL LETTER C WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000023C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000023C,
      "LATIN SMALL LETTER C WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000023B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000023B, 0x00000000, 0x00000000}
    },
    {
      0x0000023D,
      "LATIN CAPITAL LETTER L WITH BAR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000019A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000023E,
      "LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C66, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000023F,
      "LATIN SMALL LETTER S WITH SWASH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C7E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C7E, 0x00000000, 0x00000000}
    },
    {
      0x00000240,
      "LATIN SMALL LETTER Z WITH SWASH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C7F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C7F, 0x00000000, 0x00000000}
    },
    {
      0x00000241,
      "LATIN CAPITAL LETTER GLOTTAL STOP",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000242, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000242,
      "LATIN SMALL LETTER GLOTTAL STOP",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000241, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000241, 0x00000000, 0x00000000}
    },
    {
      0x00000243,
      "LATIN CAPITAL LETTER B WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000180, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000244,
      "LATIN CAPITAL LETTER U BAR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000289, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000245,
      "LATIN CAPITAL LETTER TURNED V",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000028C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000246,
      "LATIN CAPITAL LETTER E WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000247, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000247,
      "LATIN SMALL LETTER E WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000246, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000246, 0x00000000, 0x00000000}
    },
    {
      0x00000248,
      "LATIN CAPITAL LETTER J WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000249, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000249,
      "LATIN SMALL LETTER J WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000248, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000248, 0x00000000, 0x00000000}
    },
    {
      0x0000024A,
      "LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000024B,
      "LATIN SMALL LETTER Q WITH HOOK TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000024A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024A, 0x00000000, 0x00000000}
    },
    {
      0x0000024C,
      "LATIN CAPITAL LETTER R WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000024D,
      "LATIN SMALL LETTER R WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000024C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024C, 0x00000000, 0x00000000}
    },
    {
      0x0000024E,
      "LATIN CAPITAL LETTER Y WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000024F,
      "LATIN SMALL LETTER Y WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000024E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000024E, 0x00000000, 0x00000000}
    },
    {
      0x00000250,
      "LATIN SMALL LETTER TURNED A",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C6F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C6F, 0x00000000, 0x00000000}
    },
    {
      0x00000251,
      "LATIN SMALL LETTER ALPHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C6D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C6D, 0x00000000, 0x00000000}
    },
    {
      0x00000252,
      "LATIN SMALL LETTER TURNED ALPHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C70, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C70, 0x00000000, 0x00000000}
    },
    {
      0x00000253,
      "LATIN SMALL LETTER B WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000181, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000181, 0x00000000, 0x00000000}
    },
    {
      0x00000254,
      "LATIN SMALL LETTER OPEN O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000186, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000186, 0x00000000, 0x00000000}
    },
    {
      0x00000255,
      "LATIN SMALL LETTER C WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000256,
      "LATIN SMALL LETTER D WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000189, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000189, 0x00000000, 0x00000000}
    },
    {
      0x00000257,
      "LATIN SMALL LETTER D WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000018A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000018A, 0x00000000, 0x00000000}
    },
    {
      0x00000258,
      "LATIN SMALL LETTER REVERSED E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000259,
      "LATIN SMALL LETTER SCHWA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000018F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000018F, 0x00000000, 0x00000000}
    },
    {
      0x0000025A,
      "LATIN SMALL LETTER SCHWA WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000025B,
      "LATIN SMALL LETTER OPEN E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000190, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000190, 0x00000000, 0x00000000}
    },
    {
      0x0000025C,
      "LATIN SMALL LETTER REVERSED OPEN E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AB, 0x00000000, 0x00000000}
    },
    {
      0x0000025D,
      "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000025E,
      "LATIN SMALL LETTER CLOSED REVERSED OPEN E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000025F,
      "LATIN SMALL LETTER DOTLESS J WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000260,
      "LATIN SMALL LETTER G WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000193, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000193, 0x00000000, 0x00000000}
    },
    {
      0x00000261,
      "LATIN SMALL LETTER SCRIPT G",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AC, 0x00000000, 0x00000000}
    },
    {
      0x00000262,
      "LATIN LETTER SMALL CAPITAL G",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000263,
      "LATIN SMALL LETTER GAMMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000194, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000194, 0x00000000, 0x00000000}
    },
    {
      0x00000264,
      "LATIN SMALL LETTER RAMS HORN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000265,
      "LATIN SMALL LETTER TURNED H",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A78D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A78D, 0x00000000, 0x00000000}
    },
    {
      0x00000266,
      "LATIN SMALL LETTER H WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AA, 0x00000000, 0x00000000}
    },
    {
      0x00000267,
      "LATIN SMALL LETTER HENG WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000268,
      "LATIN SMALL LETTER I WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000197, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000197, 0x00000000, 0x00000000}
    },
    {
      0x00000269,
      "LATIN SMALL LETTER IOTA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000196, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000196, 0x00000000, 0x00000000}
    },
    {
      0x0000026A,
      "LATIN LETTER SMALL CAPITAL I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AE, 0x00000000, 0x00000000}
    },
    {
      0x0000026B,
      "LATIN SMALL LETTER L WITH MIDDLE TILDE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C62, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C62, 0x00000000, 0x00000000}
    },
    {
      0x0000026C,
      "LATIN SMALL LETTER L WITH BELT",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7AD, 0x00000000, 0x00000000}
    },
    {
      0x0000026D,
      "LATIN SMALL LETTER L WITH RETROFLEX HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000026E,
      "LATIN SMALL LETTER LEZH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000026F,
      "LATIN SMALL LETTER TURNED M",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000019C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000019C, 0x00000000, 0x00000000}
    },
    {
      0x00000270,
      "LATIN SMALL LETTER TURNED M WITH LONG LEG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000271,
      "LATIN SMALL LETTER M WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C6E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C6E, 0x00000000, 0x00000000}
    },
    {
      0x00000272,
      "LATIN SMALL LETTER N WITH LEFT HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000019D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000019D, 0x00000000, 0x00000000}
    },
    {
      0x00000273,
      "LATIN SMALL LETTER N WITH RETROFLEX HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000274,
      "LATIN LETTER SMALL CAPITAL N",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000275,
      "LATIN SMALL LETTER BARRED O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000019F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000019F, 0x00000000, 0x00000000}
    },
    {
      0x00000276,
      "LATIN LETTER SMALL CAPITAL OE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000277,
      "LATIN SMALL LETTER CLOSED OMEGA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000278,
      "LATIN SMALL LETTER PHI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000279,
      "LATIN SMALL LETTER TURNED R",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000027A,
      "LATIN SMALL LETTER TURNED R WITH LONG LEG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000027B,
      "LATIN SMALL LETTER TURNED R WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000027C,
      "LATIN SMALL LETTER R WITH LONG LEG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000027D,
      "LATIN SMALL LETTER R WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00002C64, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00002C64, 0x00000000, 0x00000000}
    },
    {
      0x0000027E,
      "LATIN SMALL LETTER R WITH FISHHOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000027F,
      "LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000280,
      "LATIN LETTER SMALL CAPITAL R",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A6, 0x00000000, 0x00000000}
    },
    {
      0x00000281,
      "LATIN LETTER SMALL CAPITAL INVERTED R",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000282,
      "LATIN SMALL LETTER S WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7C5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7C5, 0x00000000, 0x00000000}
    },
    {
      0x00000283,
      "LATIN SMALL LETTER ESH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001A9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001A9, 0x00000000, 0x00000000}
    },
    {
      0x00000284,
      "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000285,
      "LATIN SMALL LETTER SQUAT REVERSED ESH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000286,
      "LATIN SMALL LETTER ESH WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000287,
      "LATIN SMALL LETTER TURNED T",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B1, 0x00000000, 0x00000000}
    },
    {
      0x00000288,
      "LATIN SMALL LETTER T WITH RETROFLEX HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001AE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001AE, 0x00000000, 0x00000000}
    },
    {
      0x00000289,
      "LATIN SMALL LETTER U BAR",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000244, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000244, 0x00000000, 0x00000000}
    },
    {
      0x0000028A,
      "LATIN SMALL LETTER UPSILON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B1, 0x00000000, 0x00000000}
    },
    {
      0x0000028B,
      "LATIN SMALL LETTER V WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B2, 0x00000000, 0x00000000}
    },
    {
      0x0000028C,
      "LATIN SMALL LETTER TURNED V",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000245, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000245, 0x00000000, 0x00000000}
    },
    {
      0x0000028D,
      "LATIN SMALL LETTER TURNED W",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000028E,
      "LATIN SMALL LETTER TURNED Y",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000028F,
      "LATIN LETTER SMALL CAPITAL Y",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000290,
      "LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000291,
      "LATIN SMALL LETTER Z WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000292,
      "LATIN SMALL LETTER EZH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000001B7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000001B7, 0x00000000, 0x00000000}
    },
    {
      0x00000293,
      "LATIN SMALL LETTER EZH WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000294,
      "LATIN LETTER GLOTTAL STOP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000295,
      "LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000296,
      "LATIN LETTER INVERTED GLOTTAL STOP",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000297,
      "LATIN LETTER STRETCHED C",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000298,
      "LATIN LETTER BILABIAL CLICK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000299,
      "LATIN LETTER SMALL CAPITAL B",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000029A,
      "LATIN SMALL LETTER CLOSED OPEN E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000029B,
      "LATIN LETTER SMALL CAPITAL G WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000029C,
      "LATIN LETTER SMALL CAPITAL H",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000029D,
      "LATIN SMALL LETTER J WITH CROSSED-TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B2, 0x00000000, 0x00000000}
    },
    {
      0x0000029E,
      "LATIN SMALL LETTER TURNED K",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000A7B0, 0x00000000, 0x00000000}
    },
    {
      0x0000029F,
      "LATIN LETTER SMALL CAPITAL L",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A0,
      "LATIN SMALL LETTER Q WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A1,
      "LATIN LETTER GLOTTAL STOP WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A2,
      "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A3,
      "LATIN SMALL LETTER DZ DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A4,
      "LATIN SMALL LETTER DEZH DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A5,
      "LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A6,
      "LATIN SMALL LETTER TS DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A7,
      "LATIN SMALL LETTER TESH DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A8,
      "LATIN SMALL LETTER TC DIGRAPH WITH CURL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002A9,
      "LATIN SMALL LETTER FENG DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AA,
      "LATIN SMALL LETTER LS DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AB,
      "LATIN SMALL LETTER LZ DIGRAPH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AC,
      "LATIN LETTER BILABIAL PERCUSSIVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AD,
      "LATIN LETTER BIDENTAL PERCUSSIVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AE,
      "LATIN SMALL LETTER TURNED H WITH FISHHOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002AF,
      "LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B0,
      "MODIFIER LETTER SMALL H",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000068, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B1,
      "MODIFIER LETTER SMALL H WITH HOOK",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000266, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B2,
      "MODIFIER LETTER SMALL J",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x0000006A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B3,
      "MODIFIER LETTER SMALL R",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000072, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B4,
      "MODIFIER LETTER SMALL TURNED R",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000279, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B5,
      "MODIFIER LETTER SMALL TURNED R WITH HOOK",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x0000027B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B6,
      "MODIFIER LETTER SMALL CAPITAL INVERTED R",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000281, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B7,
      "MODIFIER LETTER SMALL W",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000077, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B8,
      "MODIFIER LETTER SMALL Y",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000079, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002B9,
      "MODIFIER LETTER PRIME",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BA,
      "MODIFIER LETTER DOUBLE PRIME",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BB,
      "MODIFIER LETTER TURNED COMMA",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BC,
      "MODIFIER LETTER APOSTROPHE",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BD,
      "MODIFIER LETTER REVERSED COMMA",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BE,
      "MODIFIER LETTER RIGHT HALF RING",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002BF,
      "MODIFIER LETTER LEFT HALF RING",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C0,
      "MODIFIER LETTER GLOTTAL STOP",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C1,
      "MODIFIER LETTER REVERSED GLOTTAL STOP",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C2,
      "MODIFIER LETTER LEFT ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C3,
      "MODIFIER LETTER RIGHT ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C4,
      "MODIFIER LETTER UP ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C5,
      "MODIFIER LETTER DOWN ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C6,
      "MODIFIER LETTER CIRCUMFLEX ACCENT",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C7,
      "CARON",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C8,
      "MODIFIER LETTER VERTICAL LINE",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002C9,
      "MODIFIER LETTER MACRON",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CA,
      "MODIFIER LETTER ACUTE ACCENT",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CB,
      "MODIFIER LETTER GRAVE ACCENT",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CC,
      "MODIFIER LETTER LOW VERTICAL LINE",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CD,
      "MODIFIER LETTER LOW MACRON",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CE,
      "MODIFIER LETTER LOW GRAVE ACCENT",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002CF,
      "MODIFIER LETTER LOW ACUTE ACCENT",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D0,
      "MODIFIER LETTER TRIANGULAR COLON",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D1,
      "MODIFIER LETTER HALF TRIANGULAR COLON",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D2,
      "MODIFIER LETTER CENTRED RIGHT HALF RING",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D3,
      "MODIFIER LETTER CENTRED LEFT HALF RING",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D4,
      "MODIFIER LETTER UP TACK",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D5,
      "MODIFIER LETTER DOWN TACK",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D6,
      "MODIFIER LETTER PLUS SIGN",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D7,
      "MODIFIER LETTER MINUS SIGN",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D8,
      "BREVE",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002D9,
      "DOT ABOVE",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000307, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DA,
      "RING ABOVE",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x0000030A, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DB,
      "OGONEK",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000328, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DC,
      "SMALL TILDE",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000303, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DD,
      "DOUBLE ACUTE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DE,
      "MODIFIER LETTER RHOTIC HOOK",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002DF,
      "MODIFIER LETTER CROSS ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E0,
      "MODIFIER LETTER SMALL GAMMA",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000263, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E1,
      "MODIFIER LETTER SMALL L",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x0000006C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E2,
      "MODIFIER LETTER SMALL S",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000073, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E3,
      "MODIFIER LETTER SMALL X",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000078, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E4,
      "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
      0x03, 0, 0x00, 0x00,
      0x08,
      {0x00000295, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E5,
      "MODIFIER LETTER EXTRA-HIGH TONE BAR",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E6,
      "MODIFIER LETTER HIGH TONE BAR",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E7,
      "MODIFIER LETTER MID TONE BAR",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E8,
      "MODIFIER LETTER LOW TONE BAR",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002E9,
      "MODIFIER LETTER EXTRA-LOW TONE BAR",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002EA,
      "MODIFIER LETTER YIN DEPARTING TONE MARK",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002EB,
      "MODIFIER LETTER YANG DEPARTING TONE MARK",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002EC,
      "MODIFIER LETTER VOICING",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002ED,
      "MODIFIER LETTER UNASPIRATED",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002EE,
      "MODIFIER LETTER DOUBLE APOSTROPHE",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002EF,
      "MODIFIER LETTER LOW DOWN ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F0,
      "MODIFIER LETTER LOW UP ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F1,
      "MODIFIER LETTER LOW LEFT ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F2,
      "MODIFIER LETTER LOW RIGHT ARROWHEAD",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F3,
      "MODIFIER LETTER LOW RING",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F4,
      "MODIFIER LETTER MIDDLE GRAVE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F5,
      "MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F6,
      "MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F7,
      "MODIFIER LETTER LOW TILDE",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F8,
      "MODIFIER LETTER RAISED COLON",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002F9,
      "MODIFIER LETTER BEGIN HIGH TONE",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FA,
      "MODIFIER LETTER END HIGH TONE",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FB,
      "MODIFIER LETTER BEGIN LOW TONE",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FC,
      "MODIFIER LETTER END LOW TONE",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FD,
      "MODIFIER LETTER SHELF",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FE,
      "MODIFIER LETTER OPEN SHELF",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000002FF,
      "MODIFIER LETTER LOW LEFT ARROW",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000300,
      "COMBINING GRAVE ACCENT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000301,
      "COMBINING ACUTE ACCENT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000302,
      "COMBINING CIRCUMFLEX ACCENT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000303,
      "COMBINING TILDE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000304,
      "COMBINING MACRON",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000305,
      "COMBINING OVERLINE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000306,
      "COMBINING BREVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000307,
      "COMBINING DOT ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000308,
      "COMBINING DIAERESIS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000309,
      "COMBINING HOOK ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030A,
      "COMBINING RING ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030B,
      "COMBINING DOUBLE ACUTE ACCENT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030C,
      "COMBINING CARON",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030D,
      "COMBINING VERTICAL LINE ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030E,
      "COMBINING DOUBLE VERTICAL LINE ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000030F,
      "COMBINING DOUBLE GRAVE ACCENT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000310,
      "COMBINING CANDRABINDU",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000311,
      "COMBINING INVERTED BREVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000312,
      "COMBINING TURNED COMMA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000313,
      "COMBINING COMMA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000314,
      "COMBINING REVERSED COMMA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000315,
      "COMBINING COMMA ABOVE RIGHT",
      0x10, 232, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000316,
      "COMBINING GRAVE ACCENT BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000317,
      "COMBINING ACUTE ACCENT BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000318,
      "COMBINING LEFT TACK BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000319,
      "COMBINING RIGHT TACK BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031A,
      "COMBINING LEFT ANGLE ABOVE",
      0x10, 232, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031B,
      "COMBINING HORN",
      0x10, 216, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031C,
      "COMBINING LEFT HALF RING BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031D,
      "COMBINING UP TACK BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031E,
      "COMBINING DOWN TACK BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000031F,
      "COMBINING PLUS SIGN BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000320,
      "COMBINING MINUS SIGN BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000321,
      "COMBINING PALATALIZED HOOK BELOW",
      0x10, 202, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000322,
      "COMBINING RETROFLEX HOOK BELOW",
      0x10, 202, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000323,
      "COMBINING DOT BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000324,
      "COMBINING DIAERESIS BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000325,
      "COMBINING RING BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000326,
      "COMBINING COMMA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000327,
      "COMBINING CEDILLA",
      0x10, 202, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000328,
      "COMBINING OGONEK",
      0x10, 202, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000329,
      "COMBINING VERTICAL LINE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032A,
      "COMBINING BRIDGE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032B,
      "COMBINING INVERTED DOUBLE ARCH BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032C,
      "COMBINING CARON BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032D,
      "COMBINING CIRCUMFLEX ACCENT BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032E,
      "COMBINING BREVE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000032F,
      "COMBINING INVERTED BREVE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000330,
      "COMBINING TILDE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000331,
      "COMBINING MACRON BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000332,
      "COMBINING LOW LINE",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000333,
      "COMBINING DOUBLE LOW LINE",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000334,
      "COMBINING TILDE OVERLAY",
      0x10, 1, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000335,
      "COMBINING SHORT STROKE OVERLAY",
      0x10, 1, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000336,
      "COMBINING LONG STROKE OVERLAY",
      0x10, 1, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000337,
      "COMBINING SHORT SOLIDUS OVERLAY",
      0x10, 1, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000338,
      "COMBINING LONG SOLIDUS OVERLAY",
      0x10, 1, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000339,
      "COMBINING RIGHT HALF RING BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033A,
      "COMBINING INVERTED BRIDGE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033B,
      "COMBINING SQUARE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033C,
      "COMBINING SEAGULL BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033D,
      "COMBINING X ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033E,
      "COMBINING VERTICAL TILDE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000033F,
      "COMBINING DOUBLE OVERLINE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000340,
      "COMBINING GRAVE TONE MARK",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000300, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000341,
      "COMBINING ACUTE TONE MARK",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000301, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000342,
      "COMBINING GREEK PERISPOMENI",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000343,
      "COMBINING GREEK KORONIS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000313, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000344,
      "COMBINING GREEK DIALYTIKA TONOS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000308, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000345,
      "COMBINING GREEK YPOGEGRAMMENI",
      0x10, 240, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000399, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000399, 0x00000000, 0x00000000}
    },
    {
      0x00000346,
      "COMBINING BRIDGE ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000347,
      "COMBINING EQUALS SIGN BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000348,
      "COMBINING DOUBLE VERTICAL LINE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000349,
      "COMBINING LEFT ANGLE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034A,
      "COMBINING NOT TILDE ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034B,
      "COMBINING HOMOTHETIC ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034C,
      "COMBINING ALMOST EQUAL TO ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034D,
      "COMBINING LEFT RIGHT ARROW BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034E,
      "COMBINING UPWARDS ARROW BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000034F,
      "COMBINING GRAPHEME JOINER",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000350,
      "COMBINING RIGHT ARROWHEAD ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000351,
      "COMBINING LEFT HALF RING ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000352,
      "COMBINING FERMATA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000353,
      "COMBINING X BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000354,
      "COMBINING LEFT ARROWHEAD BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000355,
      "COMBINING RIGHT ARROWHEAD BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000356,
      "COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000357,
      "COMBINING RIGHT HALF RING ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000358,
      "COMBINING DOT ABOVE RIGHT",
      0x10, 232, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000359,
      "COMBINING ASTERISK BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035A,
      "COMBINING DOUBLE RING BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035B,
      "COMBINING ZIGZAG ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035C,
      "COMBINING DOUBLE BREVE BELOW",
      0x10, 233, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035D,
      "COMBINING DOUBLE BREVE",
      0x10, 234, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035E,
      "COMBINING DOUBLE MACRON",
      0x10, 234, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000035F,
      "COMBINING DOUBLE MACRON BELOW",
      0x10, 233, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000360,
      "COMBINING DOUBLE TILDE",
      0x10, 234, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000361,
      "COMBINING DOUBLE INVERTED BREVE",
      0x10, 234, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000362,
      "COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
      0x10, 233, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000363,
      "COMBINING LATIN SMALL LETTER A",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000364,
      "COMBINING LATIN SMALL LETTER E",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000365,
      "COMBINING LATIN SMALL LETTER I",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000366,
      "COMBINING LATIN SMALL LETTER O",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000367,
      "COMBINING LATIN SMALL LETTER U",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000368,
      "COMBINING LATIN SMALL LETTER C",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000369,
      "COMBINING LATIN SMALL LETTER D",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036A,
      "COMBINING LATIN SMALL LETTER H",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036B,
      "COMBINING LATIN SMALL LETTER M",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036C,
      "COMBINING LATIN SMALL LETTER R",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036D,
      "COMBINING LATIN SMALL LETTER T",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036E,
      "COMBINING LATIN SMALL LETTER V",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000036F,
      "COMBINING LATIN SMALL LETTER X",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000370,
      "GREEK CAPITAL LETTER HETA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000371, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000371,
      "GREEK SMALL LETTER HETA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000370, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000370, 0x00000000, 0x00000000}
    },
    {
      0x00000372,
      "GREEK CAPITAL LETTER ARCHAIC SAMPI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000373, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000373,
      "GREEK SMALL LETTER ARCHAIC SAMPI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000372, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000372, 0x00000000, 0x00000000}
    },
    {
      0x00000374,
      "GREEK NUMERAL SIGN",
      0x03, 0, 0x0D, 0x00,
      0x00,
      {0x000002B9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000375,
      "GREEK LOWER NUMERAL SIGN",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000376,
      "GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000377, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000377,
      "GREEK SMALL LETTER PAMPHYLIAN DIGAMMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000376, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000376, 0x00000000, 0x00000000}
    },
    {
      0x0000037A,
      "GREEK YPOGEGRAMMENI",
      0x03, 0, 0x00, 0x00,
      0x10,
      {0x00000020, 0x00000345, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000037B,
      "GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003FD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003FD, 0x00000000, 0x00000000}
    },
    {
      0x0000037C,
      "GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003FE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003FE, 0x00000000, 0x00000000}
    },
    {
      0x0000037D,
      "GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003FF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003FF, 0x00000000, 0x00000000}
    },
    {
      0x0000037E,
      "GREEK QUESTION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x0000003B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000037F,
      "GREEK CAPITAL LETTER YOT",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003F3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000384,
      "GREEK TONOS",
      0x42, 0, 0x0D, 0x00,
      0x10,
      {0x00000020, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000385,
      "GREEK DIALYTIKA TONOS",
      0x42, 0, 0x0D, 0x00,
      0x00,
      {0x000000A8, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000386,
      "GREEK CAPITAL LETTER ALPHA WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000391, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000387,
      "GREEK ANO TELEIA",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x000000B7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000388,
      "GREEK CAPITAL LETTER EPSILON WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000395, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000389,
      "GREEK CAPITAL LETTER ETA WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000397, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000038A,
      "GREEK CAPITAL LETTER IOTA WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000399, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000038C,
      "GREEK CAPITAL LETTER OMICRON WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000039F, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000038E,
      "GREEK CAPITAL LETTER UPSILON WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000003A5, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000038F,
      "GREEK CAPITAL LETTER OMEGA WITH TONOS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000003A9, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000390,
      "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003CA, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000399, 0x00000308, 0x00000301},
      {0x00000390, 0x00000000, 0x00000000},
      {0x00000399, 0x00000308, 0x00000301}
    },
    {
      0x00000391,
      "GREEK CAPITAL LETTER ALPHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000392,
      "GREEK CAPITAL LETTER BETA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000393,
      "GREEK CAPITAL LETTER GAMMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000394,
      "GREEK CAPITAL LETTER DELTA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000395,
      "GREEK CAPITAL LETTER EPSILON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000396,
      "GREEK CAPITAL LETTER ZETA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000397,
      "GREEK CAPITAL LETTER ETA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000398,
      "GREEK CAPITAL LETTER THETA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000399,
      "GREEK CAPITAL LETTER IOTA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039A,
      "GREEK CAPITAL LETTER KAPPA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039B,
      "GREEK CAPITAL LETTER LAMDA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039C,
      "GREEK CAPITAL LETTER MU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039D,
      "GREEK CAPITAL LETTER NU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039E,
      "GREEK CAPITAL LETTER XI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000039F,
      "GREEK CAPITAL LETTER OMICRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003BF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A0,
      "GREEK CAPITAL LETTER PI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A1,
      "GREEK CAPITAL LETTER RHO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A3,
      "GREEK CAPITAL LETTER SIGMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A4,
      "GREEK CAPITAL LETTER TAU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A5,
      "GREEK CAPITAL LETTER UPSILON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A6,
      "GREEK CAPITAL LETTER PHI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A7,
      "GREEK CAPITAL LETTER CHI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A8,
      "GREEK CAPITAL LETTER PSI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003A9,
      "GREEK CAPITAL LETTER OMEGA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003C9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003AA,
      "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000399, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003AB,
      "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000003A5, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003AC,
      "GREEK SMALL LETTER ALPHA WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003B1, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000386, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000386, 0x00000000, 0x00000000}
    },
    {
      0x000003AD,
      "GREEK SMALL LETTER EPSILON WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003B5, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000388, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000388, 0x00000000, 0x00000000}
    },
    {
      0x000003AE,
      "GREEK SMALL LETTER ETA WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003B7, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000389, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000389, 0x00000000, 0x00000000}
    },
    {
      0x000003AF,
      "GREEK SMALL LETTER IOTA WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003B9, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000038A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000038A, 0x00000000, 0x00000000}
    },
    {
      0x000003B0,
      "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003CB, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A5, 0x00000308, 0x00000301},
      {0x000003B0, 0x00000000, 0x00000000},
      {0x000003A5, 0x00000308, 0x00000301}
    },
    {
      0x000003B1,
      "GREEK SMALL LETTER ALPHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000391, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000391, 0x00000000, 0x00000000}
    },
    {
      0x000003B2,
      "GREEK SMALL LETTER BETA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000392, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000392, 0x00000000, 0x00000000}
    },
    {
      0x000003B3,
      "GREEK SMALL LETTER GAMMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000393, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000393, 0x00000000, 0x00000000}
    },
    {
      0x000003B4,
      "GREEK SMALL LETTER DELTA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000394, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000394, 0x00000000, 0x00000000}
    },
    {
      0x000003B5,
      "GREEK SMALL LETTER EPSILON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000395, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000395, 0x00000000, 0x00000000}
    },
    {
      0x000003B6,
      "GREEK SMALL LETTER ZETA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000396, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000396, 0x00000000, 0x00000000}
    },
    {
      0x000003B7,
      "GREEK SMALL LETTER ETA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000397, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000397, 0x00000000, 0x00000000}
    },
    {
      0x000003B8,
      "GREEK SMALL LETTER THETA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000398, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000398, 0x00000000, 0x00000000}
    },
    {
      0x000003B9,
      "GREEK SMALL LETTER IOTA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000399, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000399, 0x00000000, 0x00000000}
    },
    {
      0x000003BA,
      "GREEK SMALL LETTER KAPPA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039A, 0x00000000, 0x00000000}
    },
    {
      0x000003BB,
      "GREEK SMALL LETTER LAMDA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039B, 0x00000000, 0x00000000}
    },
    {
      0x000003BC,
      "GREEK SMALL LETTER MU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039C, 0x00000000, 0x00000000}
    },
    {
      0x000003BD,
      "GREEK SMALL LETTER NU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039D, 0x00000000, 0x00000000}
    },
    {
      0x000003BE,
      "GREEK SMALL LETTER XI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039E, 0x00000000, 0x00000000}
    },
    {
      0x000003BF,
      "GREEK SMALL LETTER OMICRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039F, 0x00000000, 0x00000000}
    },
    {
      0x000003C0,
      "GREEK SMALL LETTER PI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A0, 0x00000000, 0x00000000}
    },
    {
      0x000003C1,
      "GREEK SMALL LETTER RHO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A1, 0x00000000, 0x00000000}
    },
    {
      0x000003C2,
      "GREEK SMALL LETTER FINAL SIGMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A3, 0x00000000, 0x00000000}
    },
    {
      0x000003C3,
      "GREEK SMALL LETTER SIGMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A3, 0x00000000, 0x00000000}
    },
    {
      0x000003C4,
      "GREEK SMALL LETTER TAU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A4, 0x00000000, 0x00000000}
    },
    {
      0x000003C5,
      "GREEK SMALL LETTER UPSILON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A5, 0x00000000, 0x00000000}
    },
    {
      0x000003C6,
      "GREEK SMALL LETTER PHI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A6, 0x00000000, 0x00000000}
    },
    {
      0x000003C7,
      "GREEK SMALL LETTER CHI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A7, 0x00000000, 0x00000000}
    },
    {
      0x000003C8,
      "GREEK SMALL LETTER PSI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A8, 0x00000000, 0x00000000}
    },
    {
      0x000003C9,
      "GREEK SMALL LETTER OMEGA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A9, 0x00000000, 0x00000000}
    },
    {
      0x000003CA,
      "GREEK SMALL LETTER IOTA WITH DIALYTIKA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003B9, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003AA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AA, 0x00000000, 0x00000000}
    },
    {
      0x000003CB,
      "GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003C5, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003AB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003AB, 0x00000000, 0x00000000}
    },
    {
      0x000003CC,
      "GREEK SMALL LETTER OMICRON WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003BF, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000038C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000038C, 0x00000000, 0x00000000}
    },
    {
      0x000003CD,
      "GREEK SMALL LETTER UPSILON WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003C5, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000038E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000038E, 0x00000000, 0x00000000}
    },
    {
      0x000003CE,
      "GREEK SMALL LETTER OMEGA WITH TONOS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000003C9, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000038F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000038F, 0x00000000, 0x00000000}
    },
    {
      0x000003CF,
      "GREEK CAPITAL KAI SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003D7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003D0,
      "GREEK BETA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003B2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000392, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000392, 0x00000000, 0x00000000}
    },
    {
      0x000003D1,
      "GREEK THETA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003B8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000398, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000398, 0x00000000, 0x00000000}
    },
    {
      0x000003D2,
      "GREEK UPSILON WITH HOOK SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x000003A5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003D3,
      "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000003D2, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003D4,
      "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000003D2, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003D5,
      "GREEK PHI SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003C6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A6, 0x00000000, 0x00000000}
    },
    {
      0x000003D6,
      "GREEK PI SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003C0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A0, 0x00000000, 0x00000000}
    },
    {
      0x000003D7,
      "GREEK KAI SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003CF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003CF, 0x00000000, 0x00000000}
    },
    {
      0x000003D8,
      "GREEK LETTER ARCHAIC KOPPA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003D9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003D9,
      "GREEK SMALL LETTER ARCHAIC KOPPA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003D8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003D8, 0x00000000, 0x00000000}
    },
    {
      0x000003DA,
      "GREEK LETTER STIGMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003DB,
      "GREEK SMALL LETTER STIGMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003DA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DA, 0x00000000, 0x00000000}
    },
    {
      0x000003DC,
      "GREEK LETTER DIGAMMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003DD,
      "GREEK SMALL LETTER DIGAMMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003DC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DC, 0x00000000, 0x00000000}
    },
    {
      0x000003DE,
      "GREEK LETTER KOPPA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003DF,
      "GREEK SMALL LETTER KOPPA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003DE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003DE, 0x00000000, 0x00000000}
    },
    {
      0x000003E0,
      "GREEK LETTER SAMPI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003E1,
      "GREEK SMALL LETTER SAMPI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003E0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E0, 0x00000000, 0x00000000}
    },
    {
      0x000003E2,
      "COPTIC CAPITAL LETTER SHEI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003E3,
      "COPTIC SMALL LETTER SHEI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003E2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E2, 0x00000000, 0x00000000}
    },
    {
      0x000003E4,
      "COPTIC CAPITAL LETTER FEI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003E5,
      "COPTIC SMALL LETTER FEI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003E4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E4, 0x00000000, 0x00000000}
    },
    {
      0x000003E6,
      "COPTIC CAPITAL LETTER KHEI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003E7,
      "COPTIC SMALL LETTER KHEI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003E6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E6, 0x00000000, 0x00000000}
    },
    {
      0x000003E8,
      "COPTIC CAPITAL LETTER HORI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003E9,
      "COPTIC SMALL LETTER HORI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003E8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003E8, 0x00000000, 0x00000000}
    },
    {
      0x000003EA,
      "COPTIC CAPITAL LETTER GANGIA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003EB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003EB,
      "COPTIC SMALL LETTER GANGIA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003EA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003EA, 0x00000000, 0x00000000}
    },
    {
      0x000003EC,
      "COPTIC CAPITAL LETTER SHIMA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003ED, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003ED,
      "COPTIC SMALL LETTER SHIMA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003EC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003EC, 0x00000000, 0x00000000}
    },
    {
      0x000003EE,
      "COPTIC CAPITAL LETTER DEI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003EF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003EF,
      "COPTIC SMALL LETTER DEI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003EE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003EE, 0x00000000, 0x00000000}
    },
    {
      0x000003F0,
      "GREEK KAPPA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003BA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000039A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000039A, 0x00000000, 0x00000000}
    },
    {
      0x000003F1,
      "GREEK RHO SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003C1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003A1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003A1, 0x00000000, 0x00000000}
    },
    {
      0x000003F2,
      "GREEK LUNATE SIGMA SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003C2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003F9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003F9, 0x00000000, 0x00000000}
    },
    {
      0x000003F3,
      "GREEK LETTER YOT",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000037F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000037F, 0x00000000, 0x00000000}
    },
    {
      0x000003F4,
      "GREEK CAPITAL THETA SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x00000398, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003B8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003F5,
      "GREEK LUNATE EPSILON SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x000003B5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000395, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000395, 0x00000000, 0x00000000}
    },
    {
      0x000003F6,
      "GREEK REVERSED LUNATE EPSILON SYMBOL",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003F7,
      "GREEK CAPITAL LETTER SHO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003F8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003F8,
      "GREEK SMALL LETTER SHO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003F7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003F7, 0x00000000, 0x00000000}
    },
    {
      0x000003F9,
      "GREEK CAPITAL LUNATE SIGMA SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x10,
      {0x000003A3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003F2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003FA,
      "GREEK CAPITAL LETTER SAN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003FB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003FB,
      "GREEK SMALL LETTER SAN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000003FA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000003FA, 0x00000000, 0x00000000}
    },
    {
      0x000003FC,
      "GREEK RHO WITH STROKE SYMBOL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003FD,
      "GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000037B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003FE,
      "GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000037C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000003FF,
      "GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000037D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000400,
      "CYRILLIC CAPITAL LETTER IE WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000415, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000450, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000401,
      "CYRILLIC CAPITAL LETTER IO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000415, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000451, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000402,
      "CYRILLIC CAPITAL LETTER DJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000452, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000403,
      "CYRILLIC CAPITAL LETTER GJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000413, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000453, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000404,
      "CYRILLIC CAPITAL LETTER UKRAINIAN IE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000454, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000405,
      "CYRILLIC CAPITAL LETTER DZE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000455, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000406,
      "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000456, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000407,
      "CYRILLIC CAPITAL LETTER YI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000406, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000457, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000408,
      "CYRILLIC CAPITAL LETTER JE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000458, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000409,
      "CYRILLIC CAPITAL LETTER LJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000459, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040A,
      "CYRILLIC CAPITAL LETTER NJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040B,
      "CYRILLIC CAPITAL LETTER TSHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040C,
      "CYRILLIC CAPITAL LETTER KJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000041A, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040D,
      "CYRILLIC CAPITAL LETTER I WITH GRAVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000418, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040E,
      "CYRILLIC CAPITAL LETTER SHORT U",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000423, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000040F,
      "CYRILLIC CAPITAL LETTER DZHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000045F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000410,
      "CYRILLIC CAPITAL LETTER A",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000430, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000411,
      "CYRILLIC CAPITAL LETTER BE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000431, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000412,
      "CYRILLIC CAPITAL LETTER VE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000432, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000413,
      "CYRILLIC CAPITAL LETTER GHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000433, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000414,
      "CYRILLIC CAPITAL LETTER DE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000434, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000415,
      "CYRILLIC CAPITAL LETTER IE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000435, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000416,
      "CYRILLIC CAPITAL LETTER ZHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000436, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000417,
      "CYRILLIC CAPITAL LETTER ZE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000437, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000418,
      "CYRILLIC CAPITAL LETTER I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000438, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000419,
      "CYRILLIC CAPITAL LETTER SHORT I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000418, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000439, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041A,
      "CYRILLIC CAPITAL LETTER KA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041B,
      "CYRILLIC CAPITAL LETTER EL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041C,
      "CYRILLIC CAPITAL LETTER EM",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041D,
      "CYRILLIC CAPITAL LETTER EN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041E,
      "CYRILLIC CAPITAL LETTER O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000041F,
      "CYRILLIC CAPITAL LETTER PE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000043F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000420,
      "CYRILLIC CAPITAL LETTER ER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000440, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000421,
      "CYRILLIC CAPITAL LETTER ES",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000441, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000422,
      "CYRILLIC CAPITAL LETTER TE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000442, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000423,
      "CYRILLIC CAPITAL LETTER U",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000443, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000424,
      "CYRILLIC CAPITAL LETTER EF",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000444, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000425,
      "CYRILLIC CAPITAL LETTER HA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000445, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000426,
      "CYRILLIC CAPITAL LETTER TSE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000446, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000427,
      "CYRILLIC CAPITAL LETTER CHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000447, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000428,
      "CYRILLIC CAPITAL LETTER SHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000448, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000429,
      "CYRILLIC CAPITAL LETTER SHCHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000449, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042A,
      "CYRILLIC CAPITAL LETTER HARD SIGN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042B,
      "CYRILLIC CAPITAL LETTER YERU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042C,
      "CYRILLIC CAPITAL LETTER SOFT SIGN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042D,
      "CYRILLIC CAPITAL LETTER E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042E,
      "CYRILLIC CAPITAL LETTER YU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000042F,
      "CYRILLIC CAPITAL LETTER YA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000044F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000430,
      "CYRILLIC SMALL LETTER A",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000410, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000410, 0x00000000, 0x00000000}
    },
    {
      0x00000431,
      "CYRILLIC SMALL LETTER BE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000411, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000411, 0x00000000, 0x00000000}
    },
    {
      0x00000432,
      "CYRILLIC SMALL LETTER VE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000412, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000412, 0x00000000, 0x00000000}
    },
    {
      0x00000433,
      "CYRILLIC SMALL LETTER GHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000413, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000413, 0x00000000, 0x00000000}
    },
    {
      0x00000434,
      "CYRILLIC SMALL LETTER DE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000414, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000414, 0x00000000, 0x00000000}
    },
    {
      0x00000435,
      "CYRILLIC SMALL LETTER IE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000415, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000415, 0x00000000, 0x00000000}
    },
    {
      0x00000436,
      "CYRILLIC SMALL LETTER ZHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000416, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000416, 0x00000000, 0x00000000}
    },
    {
      0x00000437,
      "CYRILLIC SMALL LETTER ZE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000417, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000417, 0x00000000, 0x00000000}
    },
    {
      0x00000438,
      "CYRILLIC SMALL LETTER I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000418, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000418, 0x00000000, 0x00000000}
    },
    {
      0x00000439,
      "CYRILLIC SMALL LETTER SHORT I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000438, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000419, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000419, 0x00000000, 0x00000000}
    },
    {
      0x0000043A,
      "CYRILLIC SMALL LETTER KA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041A, 0x00000000, 0x00000000}
    },
    {
      0x0000043B,
      "CYRILLIC SMALL LETTER EL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041B, 0x00000000, 0x00000000}
    },
    {
      0x0000043C,
      "CYRILLIC SMALL LETTER EM",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041C, 0x00000000, 0x00000000}
    },
    {
      0x0000043D,
      "CYRILLIC SMALL LETTER EN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041D, 0x00000000, 0x00000000}
    },
    {
      0x0000043E,
      "CYRILLIC SMALL LETTER O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041E, 0x00000000, 0x00000000}
    },
    {
      0x0000043F,
      "CYRILLIC SMALL LETTER PE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000041F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000041F, 0x00000000, 0x00000000}
    },
    {
      0x00000440,
      "CYRILLIC SMALL LETTER ER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000420, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000420, 0x00000000, 0x00000000}
    },
    {
      0x00000441,
      "CYRILLIC SMALL LETTER ES",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000421, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000421, 0x00000000, 0x00000000}
    },
    {
      0x00000442,
      "CYRILLIC SMALL LETTER TE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000422, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000422, 0x00000000, 0x00000000}
    },
    {
      0x00000443,
      "CYRILLIC SMALL LETTER U",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000423, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000423, 0x00000000, 0x00000000}
    },
    {
      0x00000444,
      "CYRILLIC SMALL LETTER EF",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000424, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000424, 0x00000000, 0x00000000}
    },
    {
      0x00000445,
      "CYRILLIC SMALL LETTER HA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000425, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000425, 0x00000000, 0x00000000}
    },
    {
      0x00000446,
      "CYRILLIC SMALL LETTER TSE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000426, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000426, 0x00000000, 0x00000000}
    },
    {
      0x00000447,
      "CYRILLIC SMALL LETTER CHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000427, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000427, 0x00000000, 0x00000000}
    },
    {
      0x00000448,
      "CYRILLIC SMALL LETTER SHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000428, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000428, 0x00000000, 0x00000000}
    },
    {
      0x00000449,
      "CYRILLIC SMALL LETTER SHCHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000429, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000429, 0x00000000, 0x00000000}
    },
    {
      0x0000044A,
      "CYRILLIC SMALL LETTER HARD SIGN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042A, 0x00000000, 0x00000000}
    },
    {
      0x0000044B,
      "CYRILLIC SMALL LETTER YERU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042B, 0x00000000, 0x00000000}
    },
    {
      0x0000044C,
      "CYRILLIC SMALL LETTER SOFT SIGN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042C, 0x00000000, 0x00000000}
    },
    {
      0x0000044D,
      "CYRILLIC SMALL LETTER E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042D, 0x00000000, 0x00000000}
    },
    {
      0x0000044E,
      "CYRILLIC SMALL LETTER YU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042E, 0x00000000, 0x00000000}
    },
    {
      0x0000044F,
      "CYRILLIC SMALL LETTER YA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000042F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000042F, 0x00000000, 0x00000000}
    },
    {
      0x00000450,
      "CYRILLIC SMALL LETTER IE WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000435, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000400, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000400, 0x00000000, 0x00000000}
    },
    {
      0x00000451,
      "CYRILLIC SMALL LETTER IO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000435, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000401, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000401, 0x00000000, 0x00000000}
    },
    {
      0x00000452,
      "CYRILLIC SMALL LETTER DJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000402, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000402, 0x00000000, 0x00000000}
    },
    {
      0x00000453,
      "CYRILLIC SMALL LETTER GJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000433, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000403, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000403, 0x00000000, 0x00000000}
    },
    {
      0x00000454,
      "CYRILLIC SMALL LETTER UKRAINIAN IE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000404, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000404, 0x00000000, 0x00000000}
    },
    {
      0x00000455,
      "CYRILLIC SMALL LETTER DZE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000405, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000405, 0x00000000, 0x00000000}
    },
    {
      0x00000456,
      "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000406, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000406, 0x00000000, 0x00000000}
    },
    {
      0x00000457,
      "CYRILLIC SMALL LETTER YI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000456, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000407, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000407, 0x00000000, 0x00000000}
    },
    {
      0x00000458,
      "CYRILLIC SMALL LETTER JE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000408, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000408, 0x00000000, 0x00000000}
    },
    {
      0x00000459,
      "CYRILLIC SMALL LETTER LJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000409, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000409, 0x00000000, 0x00000000}
    },
    {
      0x0000045A,
      "CYRILLIC SMALL LETTER NJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040A, 0x00000000, 0x00000000}
    },
    {
      0x0000045B,
      "CYRILLIC SMALL LETTER TSHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040B, 0x00000000, 0x00000000}
    },
    {
      0x0000045C,
      "CYRILLIC SMALL LETTER KJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000043A, 0x00000301, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040C, 0x00000000, 0x00000000}
    },
    {
      0x0000045D,
      "CYRILLIC SMALL LETTER I WITH GRAVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000438, 0x00000300, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040D, 0x00000000, 0x00000000}
    },
    {
      0x0000045E,
      "CYRILLIC SMALL LETTER SHORT U",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000443, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040E, 0x00000000, 0x00000000}
    },
    {
      0x0000045F,
      "CYRILLIC SMALL LETTER DZHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000040F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000040F, 0x00000000, 0x00000000}
    },
    {
      0x00000460,
      "CYRILLIC CAPITAL LETTER OMEGA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000461, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000461,
      "CYRILLIC SMALL LETTER OMEGA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000460, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000460, 0x00000000, 0x00000000}
    },
    {
      0x00000462,
      "CYRILLIC CAPITAL LETTER YAT",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000463, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000463,
      "CYRILLIC SMALL LETTER YAT",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000462, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000462, 0x00000000, 0x00000000}
    },
    {
      0x00000464,
      "CYRILLIC CAPITAL LETTER IOTIFIED E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000465, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000465,
      "CYRILLIC SMALL LETTER IOTIFIED E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000464, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000464, 0x00000000, 0x00000000}
    },
    {
      0x00000466,
      "CYRILLIC CAPITAL LETTER LITTLE YUS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000467, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000467,
      "CYRILLIC SMALL LETTER LITTLE YUS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000466, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000466, 0x00000000, 0x00000000}
    },
    {
      0x00000468,
      "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000469, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000469,
      "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000468, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000468, 0x00000000, 0x00000000}
    },
    {
      0x0000046A,
      "CYRILLIC CAPITAL LETTER BIG YUS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000046B,
      "CYRILLIC SMALL LETTER BIG YUS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000046A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046A, 0x00000000, 0x00000000}
    },
    {
      0x0000046C,
      "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000046D,
      "CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000046C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046C, 0x00000000, 0x00000000}
    },
    {
      0x0000046E,
      "CYRILLIC CAPITAL LETTER KSI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000046F,
      "CYRILLIC SMALL LETTER KSI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000046E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000046E, 0x00000000, 0x00000000}
    },
    {
      0x00000470,
      "CYRILLIC CAPITAL LETTER PSI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000471, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000471,
      "CYRILLIC SMALL LETTER PSI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000470, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000470, 0x00000000, 0x00000000}
    },
    {
      0x00000472,
      "CYRILLIC CAPITAL LETTER FITA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000473, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000473,
      "CYRILLIC SMALL LETTER FITA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000472, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000472, 0x00000000, 0x00000000}
    },
    {
      0x00000474,
      "CYRILLIC CAPITAL LETTER IZHITSA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000475, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000475,
      "CYRILLIC SMALL LETTER IZHITSA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000474, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000474, 0x00000000, 0x00000000}
    },
    {
      0x00000476,
      "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000474, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000477, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000477,
      "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000475, 0x0000030F, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000476, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000476, 0x00000000, 0x00000000}
    },
    {
      0x00000478,
      "CYRILLIC CAPITAL LETTER UK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000479, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000479,
      "CYRILLIC SMALL LETTER UK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000478, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000478, 0x00000000, 0x00000000}
    },
    {
      0x0000047A,
      "CYRILLIC CAPITAL LETTER ROUND OMEGA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000047B,
      "CYRILLIC SMALL LETTER ROUND OMEGA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000047A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047A, 0x00000000, 0x00000000}
    },
    {
      0x0000047C,
      "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000047D,
      "CYRILLIC SMALL LETTER OMEGA WITH TITLO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000047C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047C, 0x00000000, 0x00000000}
    },
    {
      0x0000047E,
      "CYRILLIC CAPITAL LETTER OT",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000047F,
      "CYRILLIC SMALL LETTER OT",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000047E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000047E, 0x00000000, 0x00000000}
    },
    {
      0x00000480,
      "CYRILLIC CAPITAL LETTER KOPPA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000481, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000481,
      "CYRILLIC SMALL LETTER KOPPA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000480, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000480, 0x00000000, 0x00000000}
    },
    {
      0x00000482,
      "CYRILLIC THOUSANDS SIGN",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000483,
      "COMBINING CYRILLIC TITLO",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000484,
      "COMBINING CYRILLIC PALATALIZATION",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000485,
      "COMBINING CYRILLIC DASIA PNEUMATA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000486,
      "COMBINING CYRILLIC PSILI PNEUMATA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000487,
      "COMBINING CYRILLIC POKRYTIE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000488,
      "COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
      0x12, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000489,
      "COMBINING CYRILLIC MILLIONS SIGN",
      0x12, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000048A,
      "CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000048B,
      "CYRILLIC SMALL LETTER SHORT I WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000048A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048A, 0x00000000, 0x00000000}
    },
    {
      0x0000048C,
      "CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000048D,
      "CYRILLIC SMALL LETTER SEMISOFT SIGN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000048C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048C, 0x00000000, 0x00000000}
    },
    {
      0x0000048E,
      "CYRILLIC CAPITAL LETTER ER WITH TICK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000048F,
      "CYRILLIC SMALL LETTER ER WITH TICK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000048E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000048E, 0x00000000, 0x00000000}
    },
    {
      0x00000490,
      "CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000491, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000491,
      "CYRILLIC SMALL LETTER GHE WITH UPTURN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000490, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000490, 0x00000000, 0x00000000}
    },
    {
      0x00000492,
      "CYRILLIC CAPITAL LETTER GHE WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000493, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000493,
      "CYRILLIC SMALL LETTER GHE WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000492, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000492, 0x00000000, 0x00000000}
    },
    {
      0x00000494,
      "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000495, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000495,
      "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000494, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000494, 0x00000000, 0x00000000}
    },
    {
      0x00000496,
      "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000497, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000497,
      "CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000496, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000496, 0x00000000, 0x00000000}
    },
    {
      0x00000498,
      "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000499, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000499,
      "CYRILLIC SMALL LETTER ZE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000498, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000498, 0x00000000, 0x00000000}
    },
    {
      0x0000049A,
      "CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000049B,
      "CYRILLIC SMALL LETTER KA WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000049A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049A, 0x00000000, 0x00000000}
    },
    {
      0x0000049C,
      "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000049D,
      "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000049C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049C, 0x00000000, 0x00000000}
    },
    {
      0x0000049E,
      "CYRILLIC CAPITAL LETTER KA WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000049F,
      "CYRILLIC SMALL LETTER KA WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000049E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000049E, 0x00000000, 0x00000000}
    },
    {
      0x000004A0,
      "CYRILLIC CAPITAL LETTER BASHKIR KA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004A1,
      "CYRILLIC SMALL LETTER BASHKIR KA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004A0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A0, 0x00000000, 0x00000000}
    },
    {
      0x000004A2,
      "CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004A3,
      "CYRILLIC SMALL LETTER EN WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004A2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A2, 0x00000000, 0x00000000}
    },
    {
      0x000004A4,
      "CYRILLIC CAPITAL LIGATURE EN GHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004A5,
      "CYRILLIC SMALL LIGATURE EN GHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004A4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A4, 0x00000000, 0x00000000}
    },
    {
      0x000004A6,
      "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004A7,
      "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004A6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A6, 0x00000000, 0x00000000}
    },
    {
      0x000004A8,
      "CYRILLIC CAPITAL LETTER ABKHASIAN HA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004A9,
      "CYRILLIC SMALL LETTER ABKHASIAN HA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004A8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004A8, 0x00000000, 0x00000000}
    },
    {
      0x000004AA,
      "CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004AB,
      "CYRILLIC SMALL LETTER ES WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004AA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AA, 0x00000000, 0x00000000}
    },
    {
      0x000004AC,
      "CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004AD,
      "CYRILLIC SMALL LETTER TE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004AC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AC, 0x00000000, 0x00000000}
    },
    {
      0x000004AE,
      "CYRILLIC CAPITAL LETTER STRAIGHT U",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004AF,
      "CYRILLIC SMALL LETTER STRAIGHT U",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004AE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004AE, 0x00000000, 0x00000000}
    },
    {
      0x000004B0,
      "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004B1,
      "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004B0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B0, 0x00000000, 0x00000000}
    },
    {
      0x000004B2,
      "CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004B3,
      "CYRILLIC SMALL LETTER HA WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004B2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B2, 0x00000000, 0x00000000}
    },
    {
      0x000004B4,
      "CYRILLIC CAPITAL LIGATURE TE TSE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004B5,
      "CYRILLIC SMALL LIGATURE TE TSE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004B4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B4, 0x00000000, 0x00000000}
    },
    {
      0x000004B6,
      "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004B7,
      "CYRILLIC SMALL LETTER CHE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004B6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B6, 0x00000000, 0x00000000}
    },
    {
      0x000004B8,
      "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004B9,
      "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004B8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004B8, 0x00000000, 0x00000000}
    },
    {
      0x000004BA,
      "CYRILLIC CAPITAL LETTER SHHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004BB,
      "CYRILLIC SMALL LETTER SHHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004BA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BA, 0x00000000, 0x00000000}
    },
    {
      0x000004BC,
      "CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004BD,
      "CYRILLIC SMALL LETTER ABKHASIAN CHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004BC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BC, 0x00000000, 0x00000000}
    },
    {
      0x000004BE,
      "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004BF,
      "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004BE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004BE, 0x00000000, 0x00000000}
    },
    {
      0x000004C0,
      "CYRILLIC LETTER PALOCHKA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004C1,
      "CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000416, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004C2,
      "CYRILLIC SMALL LETTER ZHE WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000436, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C1, 0x00000000, 0x00000000}
    },
    {
      0x000004C3,
      "CYRILLIC CAPITAL LETTER KA WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004C4,
      "CYRILLIC SMALL LETTER KA WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C3, 0x00000000, 0x00000000}
    },
    {
      0x000004C5,
      "CYRILLIC CAPITAL LETTER EL WITH TAIL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004C6,
      "CYRILLIC SMALL LETTER EL WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C5, 0x00000000, 0x00000000}
    },
    {
      0x000004C7,
      "CYRILLIC CAPITAL LETTER EN WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004C8,
      "CYRILLIC SMALL LETTER EN WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C7, 0x00000000, 0x00000000}
    },
    {
      0x000004C9,
      "CYRILLIC CAPITAL LETTER EN WITH TAIL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004CA,
      "CYRILLIC SMALL LETTER EN WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C9, 0x00000000, 0x00000000}
    },
    {
      0x000004CB,
      "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004CC,
      "CYRILLIC SMALL LETTER KHAKASSIAN CHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004CB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CB, 0x00000000, 0x00000000}
    },
    {
      0x000004CD,
      "CYRILLIC CAPITAL LETTER EM WITH TAIL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004CE,
      "CYRILLIC SMALL LETTER EM WITH TAIL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004CD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004CD, 0x00000000, 0x00000000}
    },
    {
      0x000004CF,
      "CYRILLIC SMALL LETTER PALOCHKA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004C0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004C0, 0x00000000, 0x00000000}
    },
    {
      0x000004D0,
      "CYRILLIC CAPITAL LETTER A WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000410, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004D1,
      "CYRILLIC SMALL LETTER A WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000430, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004D0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D0, 0x00000000, 0x00000000}
    },
    {
      0x000004D2,
      "CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000410, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004D3,
      "CYRILLIC SMALL LETTER A WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000430, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004D2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D2, 0x00000000, 0x00000000}
    },
    {
      0x000004D4,
      "CYRILLIC CAPITAL LIGATURE A IE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004D5,
      "CYRILLIC SMALL LIGATURE A IE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004D4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D4, 0x00000000, 0x00000000}
    },
    {
      0x000004D6,
      "CYRILLIC CAPITAL LETTER IE WITH BREVE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000415, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004D7,
      "CYRILLIC SMALL LETTER IE WITH BREVE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000435, 0x00000306, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004D6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D6, 0x00000000, 0x00000000}
    },
    {
      0x000004D8,
      "CYRILLIC CAPITAL LETTER SCHWA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004D9,
      "CYRILLIC SMALL LETTER SCHWA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004D8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004D8, 0x00000000, 0x00000000}
    },
    {
      0x000004DA,
      "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000004D8, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004DB,
      "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000004D9, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004DA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DA, 0x00000000, 0x00000000}
    },
    {
      0x000004DC,
      "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000416, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004DD,
      "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000436, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004DC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DC, 0x00000000, 0x00000000}
    },
    {
      0x000004DE,
      "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000417, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004DF,
      "CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000437, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004DE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004DE, 0x00000000, 0x00000000}
    },
    {
      0x000004E0,
      "CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004E1,
      "CYRILLIC SMALL LETTER ABKHASIAN DZE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004E0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E0, 0x00000000, 0x00000000}
    },
    {
      0x000004E2,
      "CYRILLIC CAPITAL LETTER I WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000418, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004E3,
      "CYRILLIC SMALL LETTER I WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000438, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004E2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E2, 0x00000000, 0x00000000}
    },
    {
      0x000004E4,
      "CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000418, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004E5,
      "CYRILLIC SMALL LETTER I WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000438, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004E4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E4, 0x00000000, 0x00000000}
    },
    {
      0x000004E6,
      "CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000041E, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004E7,
      "CYRILLIC SMALL LETTER O WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000043E, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004E6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E6, 0x00000000, 0x00000000}
    },
    {
      0x000004E8,
      "CYRILLIC CAPITAL LETTER BARRED O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004E9,
      "CYRILLIC SMALL LETTER BARRED O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004E8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004E8, 0x00000000, 0x00000000}
    },
    {
      0x000004EA,
      "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x000004E8, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004EB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004EB,
      "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x000004E9, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004EA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004EA, 0x00000000, 0x00000000}
    },
    {
      0x000004EC,
      "CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000042D, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004ED, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004ED,
      "CYRILLIC SMALL LETTER E WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000044D, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004EC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004EC, 0x00000000, 0x00000000}
    },
    {
      0x000004EE,
      "CYRILLIC CAPITAL LETTER U WITH MACRON",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000423, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004EF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004EF,
      "CYRILLIC SMALL LETTER U WITH MACRON",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000443, 0x00000304, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004EE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004EE, 0x00000000, 0x00000000}
    },
    {
      0x000004F0,
      "CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000423, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F1, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004F1,
      "CYRILLIC SMALL LETTER U WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000443, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004F0, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F0, 0x00000000, 0x00000000}
    },
    {
      0x000004F2,
      "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000423, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F3, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004F3,
      "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000443, 0x0000030B, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004F2, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F2, 0x00000000, 0x00000000}
    },
    {
      0x000004F4,
      "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000427, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F5, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004F5,
      "CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000447, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004F4, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F4, 0x00000000, 0x00000000}
    },
    {
      0x000004F6,
      "CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F7, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004F7,
      "CYRILLIC SMALL LETTER GHE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004F6, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F6, 0x00000000, 0x00000000}
    },
    {
      0x000004F8,
      "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x0000042B, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F9, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004F9,
      "CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x0000044B, 0x00000308, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004F8, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004F8, 0x00000000, 0x00000000}
    },
    {
      0x000004FA,
      "CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FB, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004FB,
      "CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004FA, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FA, 0x00000000, 0x00000000}
    },
    {
      0x000004FC,
      "CYRILLIC CAPITAL LETTER HA WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FD, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004FD,
      "CYRILLIC SMALL LETTER HA WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004FC, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FC, 0x00000000, 0x00000000}
    },
    {
      0x000004FE,
      "CYRILLIC CAPITAL LETTER HA WITH STROKE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FF, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000004FF,
      "CYRILLIC SMALL LETTER HA WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x000004FE, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x000004FE, 0x00000000, 0x00000000}
    },
    {
      0x00000500,
      "CYRILLIC CAPITAL LETTER KOMI DE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000501, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000501,
      "CYRILLIC SMALL LETTER KOMI DE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000500, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000500, 0x00000000, 0x00000000}
    },
    {
      0x00000502,
      "CYRILLIC CAPITAL LETTER KOMI DJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000503, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000503,
      "CYRILLIC SMALL LETTER KOMI DJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000502, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000502, 0x00000000, 0x00000000}
    },
    {
      0x00000504,
      "CYRILLIC CAPITAL LETTER KOMI ZJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000505, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000505,
      "CYRILLIC SMALL LETTER KOMI ZJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000504, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000504, 0x00000000, 0x00000000}
    },
    {
      0x00000506,
      "CYRILLIC CAPITAL LETTER KOMI DZJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000507, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000507,
      "CYRILLIC SMALL LETTER KOMI DZJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000506, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000506, 0x00000000, 0x00000000}
    },
    {
      0x00000508,
      "CYRILLIC CAPITAL LETTER KOMI LJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000509, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000509,
      "CYRILLIC SMALL LETTER KOMI LJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000508, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000508, 0x00000000, 0x00000000}
    },
    {
      0x0000050A,
      "CYRILLIC CAPITAL LETTER KOMI NJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000050B,
      "CYRILLIC SMALL LETTER KOMI NJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000050A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050A, 0x00000000, 0x00000000}
    },
    {
      0x0000050C,
      "CYRILLIC CAPITAL LETTER KOMI SJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000050D,
      "CYRILLIC SMALL LETTER KOMI SJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000050C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050C, 0x00000000, 0x00000000}
    },
    {
      0x0000050E,
      "CYRILLIC CAPITAL LETTER KOMI TJE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000050F,
      "CYRILLIC SMALL LETTER KOMI TJE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000050E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000050E, 0x00000000, 0x00000000}
    },
    {
      0x00000510,
      "CYRILLIC CAPITAL LETTER REVERSED ZE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000511, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000511,
      "CYRILLIC SMALL LETTER REVERSED ZE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000510, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000510, 0x00000000, 0x00000000}
    },
    {
      0x00000512,
      "CYRILLIC CAPITAL LETTER EL WITH HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000513, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000513,
      "CYRILLIC SMALL LETTER EL WITH HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000512, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000512, 0x00000000, 0x00000000}
    },
    {
      0x00000514,
      "CYRILLIC CAPITAL LETTER LHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000515, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000515,
      "CYRILLIC SMALL LETTER LHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000514, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000514, 0x00000000, 0x00000000}
    },
    {
      0x00000516,
      "CYRILLIC CAPITAL LETTER RHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000517, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000517,
      "CYRILLIC SMALL LETTER RHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000516, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000516, 0x00000000, 0x00000000}
    },
    {
      0x00000518,
      "CYRILLIC CAPITAL LETTER YAE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000519, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000519,
      "CYRILLIC SMALL LETTER YAE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000518, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000518, 0x00000000, 0x00000000}
    },
    {
      0x0000051A,
      "CYRILLIC CAPITAL LETTER QA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000051B,
      "CYRILLIC SMALL LETTER QA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000051A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051A, 0x00000000, 0x00000000}
    },
    {
      0x0000051C,
      "CYRILLIC CAPITAL LETTER WE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000051D,
      "CYRILLIC SMALL LETTER WE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000051C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051C, 0x00000000, 0x00000000}
    },
    {
      0x0000051E,
      "CYRILLIC CAPITAL LETTER ALEUT KA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000051F,
      "CYRILLIC SMALL LETTER ALEUT KA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000051E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000051E, 0x00000000, 0x00000000}
    },
    {
      0x00000520,
      "CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000521, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000521,
      "CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000520, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000520, 0x00000000, 0x00000000}
    },
    {
      0x00000522,
      "CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000523, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000523,
      "CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000522, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000522, 0x00000000, 0x00000000}
    },
    {
      0x00000524,
      "CYRILLIC CAPITAL LETTER PE WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000525, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000525,
      "CYRILLIC SMALL LETTER PE WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000524, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000524, 0x00000000, 0x00000000}
    },
    {
      0x00000526,
      "CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000527, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000527,
      "CYRILLIC SMALL LETTER SHHA WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000526, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000526, 0x00000000, 0x00000000}
    },
    {
      0x00000528,
      "CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000529, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000529,
      "CYRILLIC SMALL LETTER EN WITH LEFT HOOK",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000528, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000528, 0x00000000, 0x00000000}
    },
    {
      0x0000052A,
      "CYRILLIC CAPITAL LETTER DZZHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000052B,
      "CYRILLIC SMALL LETTER DZZHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000052A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052A, 0x00000000, 0x00000000}
    },
    {
      0x0000052C,
      "CYRILLIC CAPITAL LETTER DCHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000052D,
      "CYRILLIC SMALL LETTER DCHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000052C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052C, 0x00000000, 0x00000000}
    },
    {
      0x0000052E,
      "CYRILLIC CAPITAL LETTER EL WITH DESCENDER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000052F,
      "CYRILLIC SMALL LETTER EL WITH DESCENDER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000052E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000052E, 0x00000000, 0x00000000}
    },
    {
      0x00000531,
      "ARMENIAN CAPITAL LETTER AYB",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000561, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000532,
      "ARMENIAN CAPITAL LETTER BEN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000562, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000533,
      "ARMENIAN CAPITAL LETTER GIM",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000563, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000534,
      "ARMENIAN CAPITAL LETTER DA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000564, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000535,
      "ARMENIAN CAPITAL LETTER ECH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000565, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000536,
      "ARMENIAN CAPITAL LETTER ZA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000566, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000537,
      "ARMENIAN CAPITAL LETTER EH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000567, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000538,
      "ARMENIAN CAPITAL LETTER ET",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000568, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000539,
      "ARMENIAN CAPITAL LETTER TO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000569, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053A,
      "ARMENIAN CAPITAL LETTER ZHE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053B,
      "ARMENIAN CAPITAL LETTER INI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053C,
      "ARMENIAN CAPITAL LETTER LIWN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053D,
      "ARMENIAN CAPITAL LETTER XEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053E,
      "ARMENIAN CAPITAL LETTER CA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000053F,
      "ARMENIAN CAPITAL LETTER KEN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000056F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000540,
      "ARMENIAN CAPITAL LETTER HO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000570, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000541,
      "ARMENIAN CAPITAL LETTER JA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000571, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000542,
      "ARMENIAN CAPITAL LETTER GHAD",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000572, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000543,
      "ARMENIAN CAPITAL LETTER CHEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000573, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000544,
      "ARMENIAN CAPITAL LETTER MEN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000574, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000545,
      "ARMENIAN CAPITAL LETTER YI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000575, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000546,
      "ARMENIAN CAPITAL LETTER NOW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000576, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000547,
      "ARMENIAN CAPITAL LETTER SHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000577, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000548,
      "ARMENIAN CAPITAL LETTER VO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000578, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000549,
      "ARMENIAN CAPITAL LETTER CHA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000579, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054A,
      "ARMENIAN CAPITAL LETTER PEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054B,
      "ARMENIAN CAPITAL LETTER JHEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054C,
      "ARMENIAN CAPITAL LETTER RA",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054D,
      "ARMENIAN CAPITAL LETTER SEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054E,
      "ARMENIAN CAPITAL LETTER VEW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000054F,
      "ARMENIAN CAPITAL LETTER TIWN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000057F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000550,
      "ARMENIAN CAPITAL LETTER REH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000580, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000551,
      "ARMENIAN CAPITAL LETTER CO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000581, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000552,
      "ARMENIAN CAPITAL LETTER YIWN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000582, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000553,
      "ARMENIAN CAPITAL LETTER PIWR",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000583, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000554,
      "ARMENIAN CAPITAL LETTER KEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000584, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000555,
      "ARMENIAN CAPITAL LETTER OH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000585, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000556,
      "ARMENIAN CAPITAL LETTER FEH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000586, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000559,
      "ARMENIAN MODIFIER LETTER LEFT HALF RING",
      0x03, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055A,
      "ARMENIAN APOSTROPHE",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055B,
      "ARMENIAN EMPHASIS MARK",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055C,
      "ARMENIAN EXCLAMATION MARK",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055D,
      "ARMENIAN COMMA",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055E,
      "ARMENIAN QUESTION MARK",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000055F,
      "ARMENIAN ABBREVIATION MARK",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000560,
      "ARMENIAN SMALL LETTER TURNED AYB",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000561,
      "ARMENIAN SMALL LETTER AYB",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000531, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000531, 0x00000000, 0x00000000}
    },
    {
      0x00000562,
      "ARMENIAN SMALL LETTER BEN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000532, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000532, 0x00000000, 0x00000000}
    },
    {
      0x00000563,
      "ARMENIAN SMALL LETTER GIM",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000533, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000533, 0x00000000, 0x00000000}
    },
    {
      0x00000564,
      "ARMENIAN SMALL LETTER DA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000534, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000534, 0x00000000, 0x00000000}
    },
    {
      0x00000565,
      "ARMENIAN SMALL LETTER ECH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000535, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000535, 0x00000000, 0x00000000}
    },
    {
      0x00000566,
      "ARMENIAN SMALL LETTER ZA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000536, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000536, 0x00000000, 0x00000000}
    },
    {
      0x00000567,
      "ARMENIAN SMALL LETTER EH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000537, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000537, 0x00000000, 0x00000000}
    },
    {
      0x00000568,
      "ARMENIAN SMALL LETTER ET",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000538, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000538, 0x00000000, 0x00000000}
    },
    {
      0x00000569,
      "ARMENIAN SMALL LETTER TO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000539, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000539, 0x00000000, 0x00000000}
    },
    {
      0x0000056A,
      "ARMENIAN SMALL LETTER ZHE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053A, 0x00000000, 0x00000000}
    },
    {
      0x0000056B,
      "ARMENIAN SMALL LETTER INI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053B, 0x00000000, 0x00000000}
    },
    {
      0x0000056C,
      "ARMENIAN SMALL LETTER LIWN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053C, 0x00000000, 0x00000000}
    },
    {
      0x0000056D,
      "ARMENIAN SMALL LETTER XEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053D, 0x00000000, 0x00000000}
    },
    {
      0x0000056E,
      "ARMENIAN SMALL LETTER CA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053E, 0x00000000, 0x00000000}
    },
    {
      0x0000056F,
      "ARMENIAN SMALL LETTER KEN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000053F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000053F, 0x00000000, 0x00000000}
    },
    {
      0x00000570,
      "ARMENIAN SMALL LETTER HO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000540, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000540, 0x00000000, 0x00000000}
    },
    {
      0x00000571,
      "ARMENIAN SMALL LETTER JA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000541, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000541, 0x00000000, 0x00000000}
    },
    {
      0x00000572,
      "ARMENIAN SMALL LETTER GHAD",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000542, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000542, 0x00000000, 0x00000000}
    },
    {
      0x00000573,
      "ARMENIAN SMALL LETTER CHEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000543, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000543, 0x00000000, 0x00000000}
    },
    {
      0x00000574,
      "ARMENIAN SMALL LETTER MEN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000544, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000544, 0x00000000, 0x00000000}
    },
    {
      0x00000575,
      "ARMENIAN SMALL LETTER YI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000545, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000545, 0x00000000, 0x00000000}
    },
    {
      0x00000576,
      "ARMENIAN SMALL LETTER NOW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000546, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000546, 0x00000000, 0x00000000}
    },
    {
      0x00000577,
      "ARMENIAN SMALL LETTER SHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000547, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000547, 0x00000000, 0x00000000}
    },
    {
      0x00000578,
      "ARMENIAN SMALL LETTER VO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000548, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000548, 0x00000000, 0x00000000}
    },
    {
      0x00000579,
      "ARMENIAN SMALL LETTER CHA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000549, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000549, 0x00000000, 0x00000000}
    },
    {
      0x0000057A,
      "ARMENIAN SMALL LETTER PEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054A, 0x00000000, 0x00000000}
    },
    {
      0x0000057B,
      "ARMENIAN SMALL LETTER JHEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054B, 0x00000000, 0x00000000}
    },
    {
      0x0000057C,
      "ARMENIAN SMALL LETTER RA",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054C, 0x00000000, 0x00000000}
    },
    {
      0x0000057D,
      "ARMENIAN SMALL LETTER SEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054D, 0x00000000, 0x00000000}
    },
    {
      0x0000057E,
      "ARMENIAN SMALL LETTER VEW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054E, 0x00000000, 0x00000000}
    },
    {
      0x0000057F,
      "ARMENIAN SMALL LETTER TIWN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0000054F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0000054F, 0x00000000, 0x00000000}
    },
    {
      0x00000580,
      "ARMENIAN SMALL LETTER REH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000550, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000550, 0x00000000, 0x00000000}
    },
    {
      0x00000581,
      "ARMENIAN SMALL LETTER CO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000551, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000551, 0x00000000, 0x00000000}
    },
    {
      0x00000582,
      "ARMENIAN SMALL LETTER YIWN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000552, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000552, 0x00000000, 0x00000000}
    },
    {
      0x00000583,
      "ARMENIAN SMALL LETTER PIWR",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000553, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000553, 0x00000000, 0x00000000}
    },
    {
      0x00000584,
      "ARMENIAN SMALL LETTER KEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000554, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000554, 0x00000000, 0x00000000}
    },
    {
      0x00000585,
      "ARMENIAN SMALL LETTER OH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000555, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000555, 0x00000000, 0x00000000}
    },
    {
      0x00000586,
      "ARMENIAN SMALL LETTER FEH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000556, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000556, 0x00000000, 0x00000000}
    },
    {
      0x00000587,
      "ARMENIAN SMALL LIGATURE ECH YIWN",
      0x01, 0, 0x00, 0x00,
      0x10,
      {0x00000565, 0x00000582, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000535, 0x00000552, 0x00000000},
      {0x00000587, 0x00000000, 0x00000000},
      {0x00000535, 0x00000582, 0x00000000}
    },
    {
      0x00000588,
      "ARMENIAN SMALL LETTER YI WITH STROKE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000589,
      "ARMENIAN FULL STOP",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000058A,
      "ARMENIAN HYPHEN",
      0x31, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000058D,
      "RIGHT-FACING ARMENIAN ETERNITY SIGN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000058E,
      "LEFT-FACING ARMENIAN ETERNITY SIGN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000058F,
      "ARMENIAN DRAM SIGN",
      0x41, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000591,
      "HEBREW ACCENT ETNAHTA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000592,
      "HEBREW ACCENT SEGOL",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000593,
      "HEBREW ACCENT SHALSHELET",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000594,
      "HEBREW ACCENT ZAQEF QATAN",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000595,
      "HEBREW ACCENT ZAQEF GADOL",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000596,
      "HEBREW ACCENT TIPEHA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000597,
      "HEBREW ACCENT REVIA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000598,
      "HEBREW ACCENT ZARQA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000599,
      "HEBREW ACCENT PASHTA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059A,
      "HEBREW ACCENT YETIV",
      0x10, 222, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059B,
      "HEBREW ACCENT TEVIR",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059C,
      "HEBREW ACCENT GERESH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059D,
      "HEBREW ACCENT GERESH MUQDAM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059E,
      "HEBREW ACCENT GERSHAYIM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000059F,
      "HEBREW ACCENT QARNEY PARA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A0,
      "HEBREW ACCENT TELISHA GEDOLA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A1,
      "HEBREW ACCENT PAZER",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A2,
      "HEBREW ACCENT ATNAH HAFUKH",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A3,
      "HEBREW ACCENT MUNAH",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A4,
      "HEBREW ACCENT MAHAPAKH",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A5,
      "HEBREW ACCENT MERKHA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A6,
      "HEBREW ACCENT MERKHA KEFULA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A7,
      "HEBREW ACCENT DARGA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A8,
      "HEBREW ACCENT QADMA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005A9,
      "HEBREW ACCENT TELISHA QETANA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AA,
      "HEBREW ACCENT YERAH BEN YOMO",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AB,
      "HEBREW ACCENT OLE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AC,
      "HEBREW ACCENT ILUY",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AD,
      "HEBREW ACCENT DEHI",
      0x10, 222, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AE,
      "HEBREW ACCENT ZINOR",
      0x10, 228, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005AF,
      "HEBREW MARK MASORA CIRCLE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B0,
      "HEBREW POINT SHEVA",
      0x10, 10, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B1,
      "HEBREW POINT HATAF SEGOL",
      0x10, 11, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B2,
      "HEBREW POINT HATAF PATAH",
      0x10, 12, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B3,
      "HEBREW POINT HATAF QAMATS",
      0x10, 13, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B4,
      "HEBREW POINT HIRIQ",
      0x10, 14, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B5,
      "HEBREW POINT TSERE",
      0x10, 15, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B6,
      "HEBREW POINT SEGOL",
      0x10, 16, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B7,
      "HEBREW POINT PATAH",
      0x10, 17, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B8,
      "HEBREW POINT QAMATS",
      0x10, 18, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005B9,
      "HEBREW POINT HOLAM",
      0x10, 19, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BA,
      "HEBREW POINT HOLAM HASER FOR VAV",
      0x10, 19, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BB,
      "HEBREW POINT QUBUTS",
      0x10, 20, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BC,
      "HEBREW POINT DAGESH OR MAPIQ",
      0x10, 21, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BD,
      "HEBREW POINT METEG",
      0x10, 22, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BE,
      "HEBREW PUNCTUATION MAQAF",
      0x31, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005BF,
      "HEBREW POINT RAFE",
      0x10, 23, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C0,
      "HEBREW PUNCTUATION PASEQ",
      0x36, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C1,
      "HEBREW POINT SHIN DOT",
      0x10, 24, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C2,
      "HEBREW POINT SIN DOT",
      0x10, 25, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C3,
      "HEBREW PUNCTUATION SOF PASUQ",
      0x36, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C4,
      "HEBREW MARK UPPER DOT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C5,
      "HEBREW MARK LOWER DOT",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C6,
      "HEBREW PUNCTUATION NUN HAFUKHA",
      0x36, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005C7,
      "HEBREW POINT QAMATS QATAN",
      0x10, 18, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D0,
      "HEBREW LETTER ALEF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D1,
      "HEBREW LETTER BET",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D2,
      "HEBREW LETTER GIMEL",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D3,
      "HEBREW LETTER DALET",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D4,
      "HEBREW LETTER HE",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D5,
      "HEBREW LETTER VAV",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D6,
      "HEBREW LETTER ZAYIN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D7,
      "HEBREW LETTER HET",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D8,
      "HEBREW LETTER TET",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005D9,
      "HEBREW LETTER YOD",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DA,
      "HEBREW LETTER FINAL KAF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DB,
      "HEBREW LETTER KAF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DC,
      "HEBREW LETTER LAMED",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DD,
      "HEBREW LETTER FINAL MEM",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DE,
      "HEBREW LETTER MEM",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005DF,
      "HEBREW LETTER FINAL NUN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E0,
      "HEBREW LETTER NUN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E1,
      "HEBREW LETTER SAMEKH",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E2,
      "HEBREW LETTER AYIN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E3,
      "HEBREW LETTER FINAL PE",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E4,
      "HEBREW LETTER PE",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E5,
      "HEBREW LETTER FINAL TSADI",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E6,
      "HEBREW LETTER TSADI",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E7,
      "HEBREW LETTER QOF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E8,
      "HEBREW LETTER RESH",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005E9,
      "HEBREW LETTER SHIN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005EA,
      "HEBREW LETTER TAV",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005EF,
      "HEBREW YOD TRIANGLE",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005F0,
      "HEBREW LIGATURE YIDDISH DOUBLE VAV",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005F1,
      "HEBREW LIGATURE YIDDISH VAV YOD",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005F2,
      "HEBREW LIGATURE YIDDISH DOUBLE YOD",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005F3,
      "HEBREW PUNCTUATION GERESH",
      0x36, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000005F4,
      "HEBREW PUNCTUATION GERSHAYIM",
      0x36, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000600,
      "ARABIC NUMBER SIGN",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000601,
      "ARABIC SIGN SANAH",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000602,
      "ARABIC FOOTNOTE MARKER",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000603,
      "ARABIC SIGN SAFHA",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000604,
      "ARABIC SIGN SAMVAT",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000605,
      "ARABIC NUMBER MARK ABOVE",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000606,
      "ARABIC-INDIC CUBE ROOT",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000607,
      "ARABIC-INDIC FOURTH ROOT",
      0x40, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000608,
      "ARABIC RAY",
      0x40, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000609,
      "ARABIC-INDIC PER MILLE SIGN",
      0x36, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060A,
      "ARABIC-INDIC PER TEN THOUSAND SIGN",
      0x36, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060B,
      "AFGHANI SIGN",
      0x41, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060C,
      "ARABIC COMMA",
      0x36, 0, 0x07, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060D,
      "ARABIC DATE SEPARATOR",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060E,
      "ARABIC POETIC VERSE SIGN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000060F,
      "ARABIC SIGN MISRA",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000610,
      "ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000611,
      "ARABIC SIGN ALAYHE ASSALLAM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000612,
      "ARABIC SIGN RAHMATULLAH ALAYHE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000613,
      "ARABIC SIGN RADI ALLAHOU ANHU",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000614,
      "ARABIC SIGN TAKHALLUS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000615,
      "ARABIC SMALL HIGH TAH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000616,
      "ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000617,
      "ARABIC SMALL HIGH ZAIN",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000618,
      "ARABIC SMALL FATHA",
      0x10, 30, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000619,
      "ARABIC SMALL DAMMA",
      0x10, 31, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000061A,
      "ARABIC SMALL KASRA",
      0x10, 32, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000061B,
      "ARABIC SEMICOLON",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000061C,
      "ARABIC LETTER MARK",
      0x61, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000061E,
      "ARABIC TRIPLE DOT PUNCTUATION MARK",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000061F,
      "ARABIC QUESTION MARK",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000620,
      "ARABIC LETTER KASHMIRI YEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000621,
      "ARABIC LETTER HAMZA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000622,
      "ARABIC LETTER ALEF WITH MADDA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000627, 0x00000653, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000623,
      "ARABIC LETTER ALEF WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000627, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000624,
      "ARABIC LETTER WAW WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000648, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000625,
      "ARABIC LETTER ALEF WITH HAMZA BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000627, 0x00000655, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000626,
      "ARABIC LETTER YEH WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x0000064A, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000627,
      "ARABIC LETTER ALEF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000628,
      "ARABIC LETTER BEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000629,
      "ARABIC LETTER TEH MARBUTA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062A,
      "ARABIC LETTER TEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062B,
      "ARABIC LETTER THEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062C,
      "ARABIC LETTER JEEM",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062D,
      "ARABIC LETTER HAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062E,
      "ARABIC LETTER KHAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000062F,
      "ARABIC LETTER DAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000630,
      "ARABIC LETTER THAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000631,
      "ARABIC LETTER REH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000632,
      "ARABIC LETTER ZAIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000633,
      "ARABIC LETTER SEEN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000634,
      "ARABIC LETTER SHEEN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000635,
      "ARABIC LETTER SAD",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000636,
      "ARABIC LETTER DAD",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000637,
      "ARABIC LETTER TAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000638,
      "ARABIC LETTER ZAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000639,
      "ARABIC LETTER AIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063A,
      "ARABIC LETTER GHAIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063B,
      "ARABIC LETTER KEHEH WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063C,
      "ARABIC LETTER KEHEH WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063D,
      "ARABIC LETTER FARSI YEH WITH INVERTED V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063E,
      "ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000063F,
      "ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000640,
      "ARABIC TATWEEL",
      0x03, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000641,
      "ARABIC LETTER FEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000642,
      "ARABIC LETTER QAF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000643,
      "ARABIC LETTER KAF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000644,
      "ARABIC LETTER LAM",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000645,
      "ARABIC LETTER MEEM",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000646,
      "ARABIC LETTER NOON",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000647,
      "ARABIC LETTER HEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000648,
      "ARABIC LETTER WAW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000649,
      "ARABIC LETTER ALEF MAKSURA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064A,
      "ARABIC LETTER YEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064B,
      "ARABIC FATHATAN",
      0x10, 27, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064C,
      "ARABIC DAMMATAN",
      0x10, 28, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064D,
      "ARABIC KASRATAN",
      0x10, 29, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064E,
      "ARABIC FATHA",
      0x10, 30, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000064F,
      "ARABIC DAMMA",
      0x10, 31, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000650,
      "ARABIC KASRA",
      0x10, 32, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000651,
      "ARABIC SHADDA",
      0x10, 33, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000652,
      "ARABIC SUKUN",
      0x10, 34, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000653,
      "ARABIC MADDAH ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000654,
      "ARABIC HAMZA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000655,
      "ARABIC HAMZA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000656,
      "ARABIC SUBSCRIPT ALEF",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000657,
      "ARABIC INVERTED DAMMA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000658,
      "ARABIC MARK NOON GHUNNA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000659,
      "ARABIC ZWARAKAY",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065A,
      "ARABIC VOWEL SIGN SMALL V ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065B,
      "ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065C,
      "ARABIC VOWEL SIGN DOT BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065D,
      "ARABIC REVERSED DAMMA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065E,
      "ARABIC FATHA WITH TWO DOTS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000065F,
      "ARABIC WAVY HAMZA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000660,
      "ARABIC-INDIC DIGIT ZERO",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000661,
      "ARABIC-INDIC DIGIT ONE",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000662,
      "ARABIC-INDIC DIGIT TWO",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000663,
      "ARABIC-INDIC DIGIT THREE",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000664,
      "ARABIC-INDIC DIGIT FOUR",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000665,
      "ARABIC-INDIC DIGIT FIVE",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000666,
      "ARABIC-INDIC DIGIT SIX",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000667,
      "ARABIC-INDIC DIGIT SEVEN",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000668,
      "ARABIC-INDIC DIGIT EIGHT",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000669,
      "ARABIC-INDIC DIGIT NINE",
      0x20, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066A,
      "ARABIC PERCENT SIGN",
      0x36, 0, 0x05, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066B,
      "ARABIC DECIMAL SEPARATOR",
      0x36, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066C,
      "ARABIC THOUSANDS SEPARATOR",
      0x36, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066D,
      "ARABIC FIVE POINTED STAR",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066E,
      "ARABIC LETTER DOTLESS BEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000066F,
      "ARABIC LETTER DOTLESS QAF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000670,
      "ARABIC LETTER SUPERSCRIPT ALEF",
      0x10, 35, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000671,
      "ARABIC LETTER ALEF WASLA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000672,
      "ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000673,
      "ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000674,
      "ARABIC LETTER HIGH HAMZA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000675,
      "ARABIC LETTER HIGH HAMZA ALEF",
      0x04, 0, 0x02, 0x00,
      0x10,
      {0x00000627, 0x00000674, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000676,
      "ARABIC LETTER HIGH HAMZA WAW",
      0x04, 0, 0x02, 0x00,
      0x10,
      {0x00000648, 0x00000674, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000677,
      "ARABIC LETTER U WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x10,
      {0x000006C7, 0x00000674, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000678,
      "ARABIC LETTER HIGH HAMZA YEH",
      0x04, 0, 0x02, 0x00,
      0x10,
      {0x0000064A, 0x00000674, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000679,
      "ARABIC LETTER TTEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067A,
      "ARABIC LETTER TTEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067B,
      "ARABIC LETTER BEEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067C,
      "ARABIC LETTER TEH WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067D,
      "ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067E,
      "ARABIC LETTER PEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000067F,
      "ARABIC LETTER TEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000680,
      "ARABIC LETTER BEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000681,
      "ARABIC LETTER HAH WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000682,
      "ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000683,
      "ARABIC LETTER NYEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000684,
      "ARABIC LETTER DYEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000685,
      "ARABIC LETTER HAH WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000686,
      "ARABIC LETTER TCHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000687,
      "ARABIC LETTER TCHEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000688,
      "ARABIC LETTER DDAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000689,
      "ARABIC LETTER DAL WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068A,
      "ARABIC LETTER DAL WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068B,
      "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068C,
      "ARABIC LETTER DAHAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068D,
      "ARABIC LETTER DDAHAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068E,
      "ARABIC LETTER DUL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000068F,
      "ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000690,
      "ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000691,
      "ARABIC LETTER RREH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000692,
      "ARABIC LETTER REH WITH SMALL V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000693,
      "ARABIC LETTER REH WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000694,
      "ARABIC LETTER REH WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000695,
      "ARABIC LETTER REH WITH SMALL V BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000696,
      "ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000697,
      "ARABIC LETTER REH WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000698,
      "ARABIC LETTER JEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000699,
      "ARABIC LETTER REH WITH FOUR DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069A,
      "ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069B,
      "ARABIC LETTER SEEN WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069C,
      "ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069D,
      "ARABIC LETTER SAD WITH TWO DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069E,
      "ARABIC LETTER SAD WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000069F,
      "ARABIC LETTER TAH WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A0,
      "ARABIC LETTER AIN WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A1,
      "ARABIC LETTER DOTLESS FEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A2,
      "ARABIC LETTER FEH WITH DOT MOVED BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A3,
      "ARABIC LETTER FEH WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A4,
      "ARABIC LETTER VEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A5,
      "ARABIC LETTER FEH WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A6,
      "ARABIC LETTER PEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A7,
      "ARABIC LETTER QAF WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A8,
      "ARABIC LETTER QAF WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006A9,
      "ARABIC LETTER KEHEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AA,
      "ARABIC LETTER SWASH KAF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AB,
      "ARABIC LETTER KAF WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AC,
      "ARABIC LETTER KAF WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AD,
      "ARABIC LETTER NG",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AE,
      "ARABIC LETTER KAF WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006AF,
      "ARABIC LETTER GAF",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B0,
      "ARABIC LETTER GAF WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B1,
      "ARABIC LETTER NGOEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B2,
      "ARABIC LETTER GAF WITH TWO DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B3,
      "ARABIC LETTER GUEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B4,
      "ARABIC LETTER GAF WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B5,
      "ARABIC LETTER LAM WITH SMALL V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B6,
      "ARABIC LETTER LAM WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B7,
      "ARABIC LETTER LAM WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B8,
      "ARABIC LETTER LAM WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006B9,
      "ARABIC LETTER NOON WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BA,
      "ARABIC LETTER NOON GHUNNA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BB,
      "ARABIC LETTER RNOON",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BC,
      "ARABIC LETTER NOON WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BD,
      "ARABIC LETTER NOON WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BE,
      "ARABIC LETTER HEH DOACHASHMEE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006BF,
      "ARABIC LETTER TCHEH WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C0,
      "ARABIC LETTER HEH WITH YEH ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x000006D5, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C1,
      "ARABIC LETTER HEH GOAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C2,
      "ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x000006C1, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C3,
      "ARABIC LETTER TEH MARBUTA GOAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C4,
      "ARABIC LETTER WAW WITH RING",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C5,
      "ARABIC LETTER KIRGHIZ OE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C6,
      "ARABIC LETTER OE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C7,
      "ARABIC LETTER U",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C8,
      "ARABIC LETTER YU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006C9,
      "ARABIC LETTER KIRGHIZ YU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CA,
      "ARABIC LETTER WAW WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CB,
      "ARABIC LETTER VE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CC,
      "ARABIC LETTER FARSI YEH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CD,
      "ARABIC LETTER YEH WITH TAIL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CE,
      "ARABIC LETTER YEH WITH SMALL V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006CF,
      "ARABIC LETTER WAW WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D0,
      "ARABIC LETTER E",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D1,
      "ARABIC LETTER YEH WITH THREE DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D2,
      "ARABIC LETTER YEH BARREE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D3,
      "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x000006D2, 0x00000654, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D4,
      "ARABIC FULL STOP",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D5,
      "ARABIC LETTER AE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D6,
      "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D7,
      "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D8,
      "ARABIC SMALL HIGH MEEM INITIAL FORM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006D9,
      "ARABIC SMALL HIGH LAM ALEF",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DA,
      "ARABIC SMALL HIGH JEEM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DB,
      "ARABIC SMALL HIGH THREE DOTS",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DC,
      "ARABIC SMALL HIGH SEEN",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DD,
      "ARABIC END OF AYAH",
      0x61, 0, 0x06, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DE,
      "ARABIC START OF RUB EL HIZB",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006DF,
      "ARABIC SMALL HIGH ROUNDED ZERO",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E0,
      "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E1,
      "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E2,
      "ARABIC SMALL HIGH MEEM ISOLATED FORM",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E3,
      "ARABIC SMALL LOW SEEN",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E4,
      "ARABIC SMALL HIGH MADDA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E5,
      "ARABIC SMALL WAW",
      0x03, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E6,
      "ARABIC SMALL YEH",
      0x03, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E7,
      "ARABIC SMALL HIGH YEH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E8,
      "ARABIC SMALL HIGH NOON",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006E9,
      "ARABIC PLACE OF SAJDAH",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006EA,
      "ARABIC EMPTY CENTRE LOW STOP",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006EB,
      "ARABIC EMPTY CENTRE HIGH STOP",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006EC,
      "ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006ED,
      "ARABIC SMALL LOW MEEM",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006EE,
      "ARABIC LETTER DAL WITH INVERTED V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006EF,
      "ARABIC LETTER REH WITH INVERTED V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F0,
      "EXTENDED ARABIC-INDIC DIGIT ZERO",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F1,
      "EXTENDED ARABIC-INDIC DIGIT ONE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F2,
      "EXTENDED ARABIC-INDIC DIGIT TWO",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F3,
      "EXTENDED ARABIC-INDIC DIGIT THREE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F4,
      "EXTENDED ARABIC-INDIC DIGIT FOUR",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F5,
      "EXTENDED ARABIC-INDIC DIGIT FIVE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F6,
      "EXTENDED ARABIC-INDIC DIGIT SIX",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F7,
      "EXTENDED ARABIC-INDIC DIGIT SEVEN",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F8,
      "EXTENDED ARABIC-INDIC DIGIT EIGHT",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006F9,
      "EXTENDED ARABIC-INDIC DIGIT NINE",
      0x20, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FA,
      "ARABIC LETTER SHEEN WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FB,
      "ARABIC LETTER DAD WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FC,
      "ARABIC LETTER GHAIN WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FD,
      "ARABIC SIGN SINDHI AMPERSAND",
      0x43, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FE,
      "ARABIC SIGN SINDHI POSTPOSITION MEN",
      0x43, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000006FF,
      "ARABIC LETTER HEH WITH INVERTED V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000700,
      "SYRIAC END OF PARAGRAPH",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000701,
      "SYRIAC SUPRALINEAR FULL STOP",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000702,
      "SYRIAC SUBLINEAR FULL STOP",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000703,
      "SYRIAC SUPRALINEAR COLON",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000704,
      "SYRIAC SUBLINEAR COLON",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000705,
      "SYRIAC HORIZONTAL COLON",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000706,
      "SYRIAC COLON SKEWED LEFT",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000707,
      "SYRIAC COLON SKEWED RIGHT",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000708,
      "SYRIAC SUPRALINEAR COLON SKEWED LEFT",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000709,
      "SYRIAC SUBLINEAR COLON SKEWED RIGHT",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000070A,
      "SYRIAC CONTRACTION",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000070B,
      "SYRIAC HARKLEAN OBELUS",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000070C,
      "SYRIAC HARKLEAN METOBELUS",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000070D,
      "SYRIAC HARKLEAN ASTERISCUS",
      0x36, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000070F,
      "SYRIAC ABBREVIATION MARK",
      0x61, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000710,
      "SYRIAC LETTER ALAPH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000711,
      "SYRIAC LETTER SUPERSCRIPT ALAPH",
      0x10, 36, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000712,
      "SYRIAC LETTER BETH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000713,
      "SYRIAC LETTER GAMAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000714,
      "SYRIAC LETTER GAMAL GARSHUNI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000715,
      "SYRIAC LETTER DALATH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000716,
      "SYRIAC LETTER DOTLESS DALATH RISH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000717,
      "SYRIAC LETTER HE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000718,
      "SYRIAC LETTER WAW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000719,
      "SYRIAC LETTER ZAIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071A,
      "SYRIAC LETTER HETH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071B,
      "SYRIAC LETTER TETH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071C,
      "SYRIAC LETTER TETH GARSHUNI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071D,
      "SYRIAC LETTER YUDH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071E,
      "SYRIAC LETTER YUDH HE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000071F,
      "SYRIAC LETTER KAPH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000720,
      "SYRIAC LETTER LAMADH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000721,
      "SYRIAC LETTER MIM",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000722,
      "SYRIAC LETTER NUN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000723,
      "SYRIAC LETTER SEMKATH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000724,
      "SYRIAC LETTER FINAL SEMKATH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000725,
      "SYRIAC LETTER E",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000726,
      "SYRIAC LETTER PE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000727,
      "SYRIAC LETTER REVERSED PE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000728,
      "SYRIAC LETTER SADHE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000729,
      "SYRIAC LETTER QAPH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072A,
      "SYRIAC LETTER RISH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072B,
      "SYRIAC LETTER SHIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072C,
      "SYRIAC LETTER TAW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072D,
      "SYRIAC LETTER PERSIAN BHETH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072E,
      "SYRIAC LETTER PERSIAN GHAMAL",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000072F,
      "SYRIAC LETTER PERSIAN DHALATH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000730,
      "SYRIAC PTHAHA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000731,
      "SYRIAC PTHAHA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000732,
      "SYRIAC PTHAHA DOTTED",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000733,
      "SYRIAC ZQAPHA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000734,
      "SYRIAC ZQAPHA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000735,
      "SYRIAC ZQAPHA DOTTED",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000736,
      "SYRIAC RBASA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000737,
      "SYRIAC RBASA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000738,
      "SYRIAC DOTTED ZLAMA HORIZONTAL",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000739,
      "SYRIAC DOTTED ZLAMA ANGULAR",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073A,
      "SYRIAC HBASA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073B,
      "SYRIAC HBASA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073C,
      "SYRIAC HBASA-ESASA DOTTED",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073D,
      "SYRIAC ESASA ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073E,
      "SYRIAC ESASA BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000073F,
      "SYRIAC RWAHA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000740,
      "SYRIAC FEMININE DOT",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000741,
      "SYRIAC QUSHSHAYA",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000742,
      "SYRIAC RUKKAKHA",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000743,
      "SYRIAC TWO VERTICAL DOTS ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000744,
      "SYRIAC TWO VERTICAL DOTS BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000745,
      "SYRIAC THREE DOTS ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000746,
      "SYRIAC THREE DOTS BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000747,
      "SYRIAC OBLIQUE LINE ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000748,
      "SYRIAC OBLIQUE LINE BELOW",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000749,
      "SYRIAC MUSIC",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000074A,
      "SYRIAC BARREKH",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000074D,
      "SYRIAC LETTER SOGDIAN ZHAIN",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000074E,
      "SYRIAC LETTER SOGDIAN KHAPH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000074F,
      "SYRIAC LETTER SOGDIAN FE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000750,
      "ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000751,
      "ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000752,
      "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000753,
      "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000754,
      "ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000755,
      "ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000756,
      "ARABIC LETTER BEH WITH SMALL V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000757,
      "ARABIC LETTER HAH WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000758,
      "ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000759,
      "ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075A,
      "ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075B,
      "ARABIC LETTER REH WITH STROKE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075C,
      "ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075D,
      "ARABIC LETTER AIN WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075E,
      "ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000075F,
      "ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000760,
      "ARABIC LETTER FEH WITH TWO DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000761,
      "ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000762,
      "ARABIC LETTER KEHEH WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000763,
      "ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000764,
      "ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000765,
      "ARABIC LETTER MEEM WITH DOT ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000766,
      "ARABIC LETTER MEEM WITH DOT BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000767,
      "ARABIC LETTER NOON WITH TWO DOTS BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000768,
      "ARABIC LETTER NOON WITH SMALL TAH",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000769,
      "ARABIC LETTER NOON WITH SMALL V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076A,
      "ARABIC LETTER LAM WITH BAR",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076B,
      "ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076C,
      "ARABIC LETTER REH WITH HAMZA ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076D,
      "ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076E,
      "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000076F,
      "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000770,
      "ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000771,
      "ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000772,
      "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000773,
      "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000774,
      "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000775,
      "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000776,
      "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000777,
      "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000778,
      "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000779,
      "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077A,
      "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077B,
      "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077C,
      "ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077D,
      "ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077E,
      "ARABIC LETTER SEEN WITH INVERTED V",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000077F,
      "ARABIC LETTER KAF WITH TWO DOTS ABOVE",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000780,
      "THAANA LETTER HAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000781,
      "THAANA LETTER SHAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000782,
      "THAANA LETTER NOONU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000783,
      "THAANA LETTER RAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000784,
      "THAANA LETTER BAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000785,
      "THAANA LETTER LHAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000786,
      "THAANA LETTER KAAFU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000787,
      "THAANA LETTER ALIFU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000788,
      "THAANA LETTER VAAVU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000789,
      "THAANA LETTER MEEMU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078A,
      "THAANA LETTER FAAFU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078B,
      "THAANA LETTER DHAALU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078C,
      "THAANA LETTER THAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078D,
      "THAANA LETTER LAAMU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078E,
      "THAANA LETTER GAAFU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000078F,
      "THAANA LETTER GNAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000790,
      "THAANA LETTER SEENU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000791,
      "THAANA LETTER DAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000792,
      "THAANA LETTER ZAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000793,
      "THAANA LETTER TAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000794,
      "THAANA LETTER YAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000795,
      "THAANA LETTER PAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000796,
      "THAANA LETTER JAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000797,
      "THAANA LETTER CHAVIYANI",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000798,
      "THAANA LETTER TTAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000799,
      "THAANA LETTER HHAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079A,
      "THAANA LETTER KHAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079B,
      "THAANA LETTER THAALU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079C,
      "THAANA LETTER ZAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079D,
      "THAANA LETTER SHEENU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079E,
      "THAANA LETTER SAADHU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000079F,
      "THAANA LETTER DAADHU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A0,
      "THAANA LETTER TO",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A1,
      "THAANA LETTER ZO",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A2,
      "THAANA LETTER AINU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A3,
      "THAANA LETTER GHAINU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A4,
      "THAANA LETTER QAAFU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A5,
      "THAANA LETTER WAAVU",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A6,
      "THAANA ABAFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A7,
      "THAANA AABAAFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A8,
      "THAANA IBIFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007A9,
      "THAANA EEBEEFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AA,
      "THAANA UBUFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AB,
      "THAANA OOBOOFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AC,
      "THAANA EBEFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AD,
      "THAANA EYBEYFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AE,
      "THAANA OBOFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007AF,
      "THAANA OABOAFILI",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007B0,
      "THAANA SUKUN",
      0x10, 0, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007B1,
      "THAANA LETTER NAA",
      0x04, 0, 0x02, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C0,
      "NKO DIGIT ZERO",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C1,
      "NKO DIGIT ONE",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C2,
      "NKO DIGIT TWO",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C3,
      "NKO DIGIT THREE",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C4,
      "NKO DIGIT FOUR",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C5,
      "NKO DIGIT FIVE",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C6,
      "NKO DIGIT SIX",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C7,
      "NKO DIGIT SEVEN",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C8,
      "NKO DIGIT EIGHT",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007C9,
      "NKO DIGIT NINE",
      0x20, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CA,
      "NKO LETTER A",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CB,
      "NKO LETTER EE",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CC,
      "NKO LETTER I",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CD,
      "NKO LETTER E",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CE,
      "NKO LETTER U",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007CF,
      "NKO LETTER OO",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D0,
      "NKO LETTER O",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D1,
      "NKO LETTER DAGBASINNA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D2,
      "NKO LETTER N",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D3,
      "NKO LETTER BA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D4,
      "NKO LETTER PA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D5,
      "NKO LETTER TA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D6,
      "NKO LETTER JA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D7,
      "NKO LETTER CHA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D8,
      "NKO LETTER DA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007D9,
      "NKO LETTER RA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DA,
      "NKO LETTER RRA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DB,
      "NKO LETTER SA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DC,
      "NKO LETTER GBA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DD,
      "NKO LETTER FA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DE,
      "NKO LETTER KA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007DF,
      "NKO LETTER LA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E0,
      "NKO LETTER NA WOLOSO",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E1,
      "NKO LETTER MA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E2,
      "NKO LETTER NYA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E3,
      "NKO LETTER NA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E4,
      "NKO LETTER HA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E5,
      "NKO LETTER WA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E6,
      "NKO LETTER YA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E7,
      "NKO LETTER NYA WOLOSO",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E8,
      "NKO LETTER JONA JA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007E9,
      "NKO LETTER JONA CHA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007EA,
      "NKO LETTER JONA RA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007EB,
      "NKO COMBINING SHORT HIGH TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007EC,
      "NKO COMBINING SHORT LOW TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007ED,
      "NKO COMBINING SHORT RISING TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007EE,
      "NKO COMBINING LONG DESCENDING TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007EF,
      "NKO COMBINING LONG HIGH TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F0,
      "NKO COMBINING LONG LOW TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F1,
      "NKO COMBINING LONG RISING TONE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F2,
      "NKO COMBINING NASALIZATION MARK",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F3,
      "NKO COMBINING DOUBLE DOT ABOVE",
      0x10, 230, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F4,
      "NKO HIGH TONE APOSTROPHE",
      0x03, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F5,
      "NKO LOW TONE APOSTROPHE",
      0x03, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F6,
      "NKO SYMBOL OO DENNEN",
      0x43, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F7,
      "NKO SYMBOL GBAKURUNEN",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F8,
      "NKO COMMA",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007F9,
      "NKO EXCLAMATION MARK",
      0x36, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007FA,
      "NKO LAJANYALAN",
      0x03, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007FD,
      "NKO DANTAYALAN",
      0x10, 220, 0x08, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007FE,
      "NKO DOROME SIGN",
      0x41, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000007FF,
      "NKO TAMAN SIGN",
      0x41, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000800,
      "SAMARITAN LETTER ALAF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000801,
      "SAMARITAN LETTER BIT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000802,
      "SAMARITAN LETTER GAMAN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000803,
      "SAMARITAN LETTER DALAT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000804,
      "SAMARITAN LETTER IY",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000805,
      "SAMARITAN LETTER BAA",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000806,
      "SAMARITAN LETTER ZEN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000807,
      "SAMARITAN LETTER IT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000808,
      "SAMARITAN LETTER TIT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00000809,
      "SAMARITAN LETTER YUT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080A,
      "SAMARITAN LETTER KAAF",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080B,
      "SAMARITAN LETTER LABAT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080C,
      "SAMARITAN LETTER MIM",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080D,
      "SAMARITAN LETTER NUN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080E,
      "SAMARITAN LETTER SINGAAT",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0000080F,
      "SAMARITAN LETTER IN",
      0x04, 0, 0x01, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 