/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#include <assert.h>

#include "av1/common/common_data.h"
#include "av1/common/scan.h"

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x4[16]) = {
  0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x4[16]) = {
  0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x4[16]) = {
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x8[32]) = {
  0,  1,  4,  2,  5,  8,  3,  6,  9,  12, 7,  10, 13, 16, 11, 14,
  17, 20, 15, 18, 21, 24, 19, 22, 25, 28, 23, 26, 29, 27, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x8[32]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 1, 5, 9,  13, 17, 21, 25, 29,
  2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x8[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x4[32]) = {
  0,  8, 1,  16, 9,  2, 24, 17, 10, 3, 25, 18, 11, 4,  26, 19,
  12, 5, 27, 20, 13, 6, 28, 21, 14, 7, 29, 22, 15, 30, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x4[32]) = {
  0, 8,  16, 24, 1, 9,  17, 25, 2, 10, 18, 26, 3, 11, 19, 27,
  4, 12, 20, 28, 5, 13, 21, 29, 6, 14, 22, 30, 7, 15, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x4[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x16[64]) = {
  0,  1,  4,  2,  5,  8,  3,  6,  9,  12, 7,  10, 13, 16, 11, 14,
  17, 20, 15, 18, 21, 24, 19, 22, 25, 28, 23, 26, 29, 32, 27, 30,
  33, 36, 31, 34, 37, 40, 35, 38, 41, 44, 39, 42, 45, 48, 43, 46,
  49, 52, 47, 50, 53, 56, 51, 54, 57, 60, 55, 58, 61, 59, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x4[64]) = {
  0,  16, 1,  32, 17, 2,  48, 33, 18, 3,  49, 34, 19, 4,  50, 35,
  20, 5,  51, 36, 21, 6,  52, 37, 22, 7,  53, 38, 23, 8,  54, 39,
  24, 9,  55, 40, 25, 10, 56, 41, 26, 11, 57, 42, 27, 12, 58, 43,
  28, 13, 59, 44, 29, 14, 60, 45, 30, 15, 61, 46, 31, 62, 47, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x16[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x4[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x16[64]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  1, 5, 9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x4[64]) = {
  0,  16, 32, 48, 1,  17, 33, 49, 2,  18, 34, 50, 3,  19, 35, 51,
  4,  20, 36, 52, 5,  21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x32[256]) = {
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 128, 87,  94,  101, 108, 115, 122, 129, 136, 95,  102, 109, 116,
  123, 130, 137, 144, 103, 110, 117, 124, 131, 138, 145, 152, 111, 118, 125,
  132, 139, 146, 153, 160, 119, 126, 133, 140, 147, 154, 161, 168, 127, 134,
  141, 148, 155, 162, 169, 176, 135, 142, 149, 156, 163, 170, 177, 184, 143,
  150, 157, 164, 171, 178, 185, 192, 151, 158, 165, 172, 179, 186, 193, 200,
  159, 166, 173, 180, 187, 194, 201, 208, 167, 174, 181, 188, 195, 202, 209,
  216, 175, 182, 189, 196, 203, 210, 217, 224, 183, 190, 197, 204, 211, 218,
  225, 232, 191, 198, 205, 212, 219, 226, 233, 240, 199, 206, 213, 220, 227,
  234, 241, 248, 207, 214, 221, 228, 235, 242, 249, 215, 222, 229, 236, 243,
  250, 223, 230, 237, 244, 251, 231, 238, 245, 252, 239, 246, 253, 247, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x8[256]) = {
  0,   32,  1,   64,  33,  2,   96,  65,  34,  3,   128, 97,  66,  35,  4,
  160, 129, 98,  67,  36,  5,   192, 161, 130, 99,  68,  37,  6,   224, 193,
  162, 131, 100, 69,  38,  7,   225, 194, 163, 132, 101, 70,  39,  8,   226,
  195, 164, 133, 102, 71,  40,  9,   227, 196, 165, 134, 103, 72,  41,  10,
  228, 197, 166, 135, 104, 73,  42,  11,  229, 198, 167, 136, 105, 74,  43,
  12,  230, 199, 168, 137, 106, 75,  44,  13,  231, 200, 169, 138, 107, 76,
  45,  14,  232, 201, 170, 139, 108, 77,  46,  15,  233, 202, 171, 140, 109,
  78,  47,  16,  234, 203, 172, 141, 110, 79,  48,  17,  235, 204, 173, 142,
  111, 80,  49,  18,  236, 205, 174, 143, 112, 81,  50,  19,  237, 206, 175,
  144, 113, 82,  51,  20,  238, 207, 176, 145, 114, 83,  52,  21,  239, 208,
  177, 146, 115, 84,  53,  22,  240, 209, 178, 147, 116, 85,  54,  23,  241,
  210, 179, 148, 117, 86,  55,  24,  242, 211, 180, 149, 118, 87,  56,  25,
  243, 212, 181, 150, 119, 88,  57,  26,  244, 213, 182, 151, 120, 89,  58,
  27,  245, 214, 183, 152, 121, 90,  59,  28,  246, 215, 184, 153, 122, 91,
  60,  29,  247, 216, 185, 154, 123, 92,  61,  30,  248, 217, 186, 155, 124,
  93,  62,  31,  249, 218, 187, 156, 125, 94,  63,  250, 219, 188, 157, 126,
  95,  251, 220, 189, 158, 127, 252, 221, 190, 159, 253, 222, 191, 254, 223,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x32[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x8[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x32[256]) = {
  0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96,  104, 112,
  120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232,
  240, 248, 1,   9,   17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  97,
  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193, 201, 209, 217,
  225, 233, 241, 249, 2,   10,  18,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 242, 250, 3,   11,  19,  27,  35,  43,  51,  59,  67,
  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187,
  195, 203, 211, 219, 227, 235, 243, 251, 4,   12,  20,  28,  36,  44,  52,
  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172,
  180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 5,   13,  21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 237, 245, 253, 6,   14,  22,
  30,  38,  46,  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142,
  150, 158, 166, 174, 182, 190, 198, 206, 214, 222, 230, 238, 246, 254, 7,
  15,  23,  31,  39,  47,  55,  63,  71,  79,  87,  95,  103, 111, 119, 127,
  135, 143, 151, 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 239, 247,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x8[256]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 1,  33, 65, 97,  129, 161, 193, 225,
  2,  34, 66, 98,  130, 162, 194, 226, 3,  35, 67, 99,  131, 163, 195, 227,
  4,  36, 68, 100, 132, 164, 196, 228, 5,  37, 69, 101, 133, 165, 197, 229,
  6,  38, 70, 102, 134, 166, 198, 230, 7,  39, 71, 103, 135, 167, 199, 231,
  8,  40, 72, 104, 136, 168, 200, 232, 9,  41, 73, 105, 137, 169, 201, 233,
  10, 42, 74, 106, 138, 170, 202, 234, 11, 43, 75, 107, 139, 171, 203, 235,
  12, 44, 76, 108, 140, 172, 204, 236, 13, 45, 77, 109, 141, 173, 205, 237,
  14, 46, 78, 110, 142, 174, 206, 238, 15, 47, 79, 111, 143, 175, 207, 239,
  16, 48, 80, 112, 144, 176, 208, 240, 17, 49, 81, 113, 145, 177, 209, 241,
  18, 50, 82, 114, 146, 178, 210, 242, 19, 51, 83, 115, 147, 179, 211, 243,
  20, 52, 84, 116, 148, 180, 212, 244, 21, 53, 85, 117, 149, 181, 213, 245,
  22, 54, 86, 118, 150, 182, 214, 246, 23, 55, 87, 119, 151, 183, 215, 247,
  24, 56, 88, 120, 152, 184, 216, 248, 25, 57, 89, 121, 153, 185, 217, 249,
  26, 58, 90, 122, 154, 186, 218, 250, 27, 59, 91, 123, 155, 187, 219, 251,
  28, 60, 92, 124, 156, 188, 220, 252, 29, 61, 93, 125, 157, 189, 221, 253,
  30, 62, 94, 126, 158, 190, 222, 254, 31, 63, 95, 127, 159, 191, 223, 255,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x8[64]) = {
  0,  1,  8,  16, 9,  2,  3,  10, 17, 24, 32, 25, 18, 11, 4,  5,
  12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6,  7,  14, 21, 28,
  35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51,
  58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x8[64]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 1, 9,  17, 25, 33, 41, 49, 57,
  2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
  4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
  6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x8[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x16[128]) = {
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 87,  94,  101, 108, 115, 122, 95,  102, 109, 116, 123, 103, 110,
  117, 124, 111, 118, 125, 119, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x8[128]) = {
  0,  16,  1,   32, 17,  2,   48,  33,  18, 3,  64,  49,  34,  19,  4,   80,
  65, 50,  35,  20, 5,   96,  81,  66,  51, 36, 21,  6,   112, 97,  82,  67,
  52, 37,  22,  7,  113, 98,  83,  68,  53, 38, 23,  8,   114, 99,  84,  69,
  54, 39,  24,  9,  115, 100, 85,  70,  55, 40, 25,  10,  116, 101, 86,  71,
  56, 41,  26,  11, 117, 102, 87,  72,  57, 42, 27,  12,  118, 103, 88,  73,
  58, 43,  28,  13, 119, 104, 89,  74,  59, 44, 29,  14,  120, 105, 90,  75,
  60, 45,  30,  15, 121, 106, 91,  76,  61, 46, 31,  122, 107, 92,  77,  62,
  47, 123, 108, 93, 78,  63,  124, 109, 94, 79, 125, 110, 95,  126, 111, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x16[128]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96,  104, 112, 120,
  1, 9,  17, 25, 33, 41, 49, 57, 65, 73, 81, 89, 97,  105, 113, 121,
  2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98,  106, 114, 122,
  3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 99,  107, 115, 123,
  4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 108, 116, 124,
  5, 13, 21, 29, 37, 45, 53, 61, 69, 77, 85, 93, 101, 109, 117, 125,
  6, 14, 22, 30, 38, 46, 54, 62, 70, 78, 86, 94, 102, 110, 118, 126,
  7, 15, 23, 31, 39, 47, 55, 63, 71, 79, 87, 95, 103, 111, 119, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x8[128]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 1,  17, 33, 49, 65, 81, 97,  113,
  2,  18, 34, 50, 66, 82, 98,  114, 3,  19, 35, 51, 67, 83, 99,  115,
  4,  20, 36, 52, 68, 84, 100, 116, 5,  21, 37, 53, 69, 85, 101, 117,
  6,  22, 38, 54, 70, 86, 102, 118, 7,  23, 39, 55, 71, 87, 103, 119,
  8,  24, 40, 56, 72, 88, 104, 120, 9,  25, 41, 57, 73, 89, 105, 121,
  10, 26, 42, 58, 74, 90, 106, 122, 11, 27, 43, 59, 75, 91, 107, 123,
  12, 28, 44, 60, 76, 92, 108, 124, 13, 29, 45, 61, 77, 93, 109, 125,
  14, 30, 46, 62, 78, 94, 110, 126, 15, 31, 47, 63, 79, 95, 111, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x16[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x8[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x32[512]) = {
  0,   1,   16,  2,   17,  32,  3,   18,  33,  48,  4,   19,  34,  49,  64,
  5,   20,  35,  50,  65,  80,  6,   21,  36,  51,  66,  81,  96,  7,   22,
  37,  52,  67,  82,  97,  112, 8,   23,  38,  53,  68,  83,  98,  113, 128,
  9,   24,  39,  54,  69,  84,  99,  114, 129, 144, 10,  25,  40,  55,  70,
  85,  100, 115, 130, 145, 160, 11,  26,  41,  56,  71,  86,  101, 116, 131,
  146, 161, 176, 12,  27,  42,  57,  72,  87,  102, 117, 132, 147, 162, 177,
  192, 13,  28,  43,  58,  73,  88,  103, 118, 133, 148, 163, 178, 193, 208,
  14,  29,  44,  59,  74,  89,  104, 119, 134, 149, 164, 179, 194, 209, 224,
  15,  30,  45,  60,  75,  90,  105, 120, 135, 150, 165, 180, 195, 210, 225,
  240, 31,  46,  61,  76,  91,  106, 121, 136, 151, 166, 181, 196, 211, 226,
  241, 256, 47,  62,  77,  92,  107, 122, 137, 152, 167, 182, 197, 212, 227,
  242, 257, 272, 63,  78,  93,  108, 123, 138, 153, 168, 183, 198, 213, 228,
  243, 258, 273, 288, 79,  94,  109, 124, 139, 154, 169, 184, 199, 214, 229,
  244, 259, 274, 289, 304, 95,  110, 125, 140, 155, 170, 185, 200, 215, 230,
  245, 260, 275, 290, 305, 320, 111, 126, 141, 156, 171, 186, 201, 216, 231,
  246, 261, 276, 291, 306, 321, 336, 127, 142, 157, 172, 187, 202, 217, 232,
  247, 262, 277, 292, 307, 322, 337, 352, 143, 158, 173, 188, 203, 218, 233,
  248, 263, 278, 293, 308, 323, 338, 353, 368, 159, 174, 189, 204, 219, 234,
  249, 264, 279, 294, 309, 324, 339, 354, 369, 384, 175, 190, 205, 220, 235,
  250, 265, 280, 295, 310, 325, 340, 355, 370, 385, 400, 191, 206, 221, 236,
  251, 266, 281, 296, 311, 326, 341, 356, 371, 386, 401, 416, 207, 222, 237,
  252, 267, 282, 297, 312, 327, 342, 357, 372, 387, 402, 417, 432, 223, 238,
  253, 268, 283, 298, 313, 328, 343, 358, 373, 388, 403, 418, 433, 448, 239,
  254, 269, 284, 299, 314, 329, 344, 359, 374, 389, 404, 419, 434, 449, 464,
  255, 270, 285, 300, 315, 330, 345, 360, 375, 390, 405, 420, 435, 450, 465,
  480, 271, 286, 301, 316, 331, 346, 361, 376, 391, 406, 421, 436, 451, 466,
  481, 496, 287, 302, 317, 332, 347, 362, 377, 392, 407, 422, 437, 452, 467,
  482, 497, 303, 318, 333, 348, 363, 378, 393, 408, 423, 438, 453, 468, 483,
  498, 319, 334, 349, 364, 379, 394, 409, 424, 439, 454, 469, 484, 499, 335,
  350, 365, 380, 395, 410, 425, 440, 455, 470, 485, 500, 351, 366, 381, 396,
  411, 426, 441, 456, 471, 486, 501, 367, 382, 397, 412, 427, 442, 457, 472,
  487, 502, 383, 398, 413, 428, 443, 458, 473, 488, 503, 399, 414, 429, 444,
  459, 474, 489, 504, 415, 430, 445, 460, 475, 490, 505, 431, 446, 461, 476,
  491, 506, 447, 462, 477, 492, 507, 463, 478, 493, 508, 479, 494, 509, 495,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x16[512]) = {
  0,   32,  1,   64,  33,  2,   96,  65,  34,  3,   128, 97,  66,  35,  4,
  160, 129, 98,  67,  36,  5,   192, 161, 130, 99,  68,  37,  6,   224, 193,
  162, 131, 100, 69,  38,  7,   256, 225, 194, 163, 132, 101, 70,  39,  8,
  288, 257, 226, 195, 164, 133, 102, 71,  40,  9,   320, 289, 258, 227, 196,
  165, 134, 103, 72,  41,  10,  352, 321, 290, 259, 228, 197, 166, 135, 104,
  73,  42,  11,  384, 353, 322, 291, 260, 229, 198, 167, 136, 105, 74,  43,
  12,  416, 385, 354, 323, 292, 261, 230, 199, 168, 137, 106, 75,  44,  13,
  448, 417, 386, 355, 324, 293, 262, 231, 200, 169, 138, 107, 76,  45,  14,
  480, 449, 418, 387, 356, 325, 294, 263, 232, 201, 170, 139, 108, 77,  46,
  15,  481, 450, 419, 388, 357, 326, 295, 264, 233, 202, 171, 140, 109, 78,
  47,  16,  482, 451, 420, 389, 358, 327, 296, 265, 234, 203, 172, 141, 110,
  79,  48,  17,  483, 452, 421, 390, 359, 328, 297, 266, 235, 204, 173, 142,
  111, 80,  49,  18,  484, 453, 422, 391, 360, 329, 298, 267, 236, 205, 174,
  143, 112, 81,  50,  19,  485, 454, 423, 392, 361, 330, 299, 268, 237, 206,
  175, 144, 113, 82,  51,  20,  486, 455, 424, 393, 362, 331, 300, 269, 238,
  207, 176, 145, 114, 83,  52,  21,  487, 456, 425, 394, 363, 332, 301, 270,
  239, 208, 177, 146, 115, 84,  53,  22,  488, 457, 426, 395, 364, 333, 302,
  271, 240, 209, 178, 147, 116, 85,  54,  23,  489, 458, 427, 396, 365, 334,
  303, 272, 241, 210, 179, 148, 117, 86,  55,  24,  490, 459, 428, 397, 366,
  335, 304, 273, 242, 211, 180, 149, 118, 87,  56,  25,  491, 460, 429, 398,
  367, 336, 305, 274, 243, 212, 181, 150, 119, 88,  57,  26,  492, 461, 430,
  399, 368, 337, 306, 275, 244, 213, 182, 151, 120, 89,  58,  27,  493, 462,
  431, 400, 369, 338, 307, 276, 245, 214, 183, 152, 121, 90,  59,  28,  494,
  463, 432, 401, 370, 339, 308, 277, 246, 215, 184, 153, 122, 91,  60,  29,
  495, 464, 433, 402, 371, 340, 309, 278, 247, 216, 185, 154, 123, 92,  61,
  30,  496, 465, 434, 403, 372, 341, 310, 279, 248, 217, 186, 155, 124, 93,
  62,  31,  497, 466, 435, 404, 373, 342, 311, 280, 249, 218, 187, 156, 125,
  94,  63,  498, 467, 436, 405, 374, 343, 312, 281, 250, 219, 188, 157, 126,
  95,  499, 468, 437, 406, 375, 344, 313, 282, 251, 220, 189, 158, 127, 500,
  469, 438, 407, 376, 345, 314, 283, 252, 221, 190, 159, 501, 470, 439, 408,
  377, 346, 315, 284, 253, 222, 191, 502, 471, 440, 409, 378, 347, 316, 285,
  254, 223, 503, 472, 441, 410, 379, 348, 317, 286, 255, 504, 473, 442, 411,
  380, 349, 318, 287, 505, 474, 443, 412, 381, 350, 319, 506, 475, 444, 413,
  382, 351, 507, 476, 445, 414, 383, 508, 477, 446, 415, 509, 478, 447, 510,
  479, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x32[512]) = {
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464,
  480, 496, 1,   17,  33,  49,  65,  81,  97,  113, 129, 145, 161, 177, 193,
  209, 225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433,
  449, 465, 481, 497, 2,   18,  34,  50,  66,  82,  98,  114, 130, 146, 162,
  178, 194, 210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 402,
  418, 434, 450, 466, 482, 498, 3,   19,  35,  51,  67,  83,  99,  115, 131,
  147, 163, 179, 195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371,
  387, 403, 419, 435, 451, 467, 483, 499, 4,   20,  36,  52,  68,  84,  100,
  116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340,
  356, 372, 388, 404, 420, 436, 452, 468, 484, 500, 5,   21,  37,  53,  69,
  85,  101, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309,
  325, 341, 357, 373, 389, 405, 421, 437, 453, 469, 485, 501, 6,   22,  38,
  54,  70,  86,  102, 118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278,
  294, 310, 326, 342, 358, 374, 390, 406, 422, 438, 454, 470, 486, 502, 7,
  23,  39,  55,  71,  87,  103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  263, 279, 295, 311, 327, 343, 359, 375, 391, 407, 423, 439, 455, 471, 487,
  503, 8,   24,  40,  56,  72,  88,  104, 120, 136, 152, 168, 184, 200, 216,
  232, 248, 264, 280, 296, 312, 328, 344, 360, 376, 392, 408, 424, 440, 456,
  472, 488, 504, 9,   25,  41,  57,  73,  89,  105, 121, 137, 153, 169, 185,
  201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361, 377, 393, 409, 425,
  441, 457, 473, 489, 505, 10,  26,  42,  58,  74,  90,  106, 122, 138, 154,
  170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378, 394,
  410, 426, 442, 458, 474, 490, 506, 11,  27,  43,  59,  75,  91,  107, 123,
  139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363,
  379, 395, 411, 427, 443, 459, 475, 491, 507, 12,  28,  44,  60,  76,  92,
  108, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284, 300, 316, 332,
  348, 364, 380, 396, 412, 428, 444, 460, 476, 492, 508, 13,  29,  45,  61,
  77,  93,  109, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269, 285, 301,
  317, 333, 349, 365, 381, 397, 413, 429, 445, 461, 477, 493, 509, 14,  30,
  46,  62,  78,  94,  110, 126, 142, 158, 174, 190, 206, 222, 238, 254, 270,
  286, 302, 318, 334, 350, 366, 382, 398, 414, 430, 446, 462, 478, 494, 510,
  15,  31,  47,  63,  79,  95,  111, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479,
  495, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x16[512]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480,
  1,  33, 65, 97,  129, 161, 193, 225, 257, 289, 321, 353, 385, 417, 449, 481,
  2,  34, 66, 98,  130, 162, 194, 226, 258, 290, 322, 354, 386, 418, 450, 482,
  3,  35, 67, 99,  131, 163, 195, 227, 259, 291, 323, 355, 387, 419, 451, 483,
  4,  36, 68, 100, 132, 164, 196, 228, 260, 292, 324, 356, 388, 420, 452, 484,
  5,  37, 69, 101, 133, 165, 197, 229, 261, 293, 325, 357, 389, 421, 453, 485,
  6,  38, 70, 102, 134, 166, 198, 230, 262, 294, 326, 358, 390, 422, 454, 486,
  7,  39, 71, 103, 135, 167, 199, 231, 263, 295, 327, 359, 391, 423, 455, 487,
  8,  40, 72, 104, 136, 168, 200, 232, 264, 296, 328, 360, 392, 424, 456, 488,
  9,  41, 73, 105, 137, 169, 201, 233, 265, 297, 329, 361, 393, 425, 457, 489,
  10, 42, 74, 106, 138, 170, 202, 234, 266, 298, 330, 362, 394, 426, 458, 490,
  11, 43, 75, 107, 139, 171, 203, 235, 267, 299, 331, 363, 395, 427, 459, 491,
  12, 44, 76, 108, 140, 172, 204, 236, 268, 300, 332, 364, 396, 428, 460, 492,
  13, 45, 77, 109, 141, 173, 205, 237, 269, 301, 333, 365, 397, 429, 461, 493,
  14, 46, 78, 110, 142, 174, 206, 238, 270, 302, 334, 366, 398, 430, 462, 494,
  15, 47, 79, 111, 143, 175, 207, 239, 271, 303, 335, 367, 399, 431, 463, 495,
  16, 48, 80, 112, 144, 176, 208, 240, 272, 304, 336, 368, 400, 432, 464, 496,
  17, 49, 81, 113, 145, 177, 209, 241, 273, 305, 337, 369, 401, 433, 465, 497,
  18, 50, 82, 114, 146, 178, 210, 242, 274, 306, 338, 370, 402, 434, 466, 498,
  19, 51, 83, 115, 147, 179, 211, 243, 275, 307, 339, 371, 403, 435, 467, 499,
  20, 52, 84, 116, 148, 180, 212, 244, 276, 308, 340, 372, 404, 436, 468, 500,
  21, 53, 85, 117, 149, 181, 213, 245, 277, 309, 341, 373, 405, 437, 469, 501,
  22, 54, 86, 118, 150, 182, 214, 246, 278, 310, 342, 374, 406, 438, 470, 502,
  23, 55, 87, 119, 151, 183, 215, 247, 279, 311, 343, 375, 407, 439, 471, 503,
  24, 56, 88, 120, 152, 184, 216, 248, 280, 312, 344, 376, 408, 440, 472, 504,
  25, 57, 89, 121, 153, 185, 217, 249, 281, 313, 345, 377, 409, 441, 473, 505,
  26, 58, 90, 122, 154, 186, 218, 250, 282, 314, 346, 378, 410, 442, 474, 506,
  27, 59, 91, 123, 155, 187, 219, 251, 283, 315, 347, 379, 411, 443, 475, 507,
  28, 60, 92, 124, 156, 188, 220, 252, 284, 316, 348, 380, 412, 444, 476, 508,
  29, 61, 93, 125, 157, 189, 221, 253, 285, 317, 349, 381, 413, 445, 477, 509,
  30, 62, 94, 126, 158, 190, 222, 254, 286, 318, 350, 382, 414, 446, 478, 510,
  31, 63, 95, 127, 159, 191, 223, 255, 287, 319, 351, 383, 415, 447, 479, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x32[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x16[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x16[256]) = {
  0,   1,   16,  32,  17,  2,   3,   18,  33,  48,  64,  49,  34,  19,  4,
  5,   20,  35,  50,  65,  80,  96,  81,  66,  51,  36,  21,  6,   7,   22,
  37,  52,  67,  82,  97,  112, 128, 113, 98,  83,  68,  53,  38,  23,  8,
  9,   24,  39,  54,  69,  84,  99,  114, 129, 144, 160, 145, 130, 115, 100,
  85,  70,  55,  40,  25,  10,  11,  26,  41,  56,  71,  86,  101, 116, 131,
  146, 161, 176, 192, 177, 162, 147, 132, 117, 102, 87,  72,  57,  42,  27,
  12,  13,  28,  43,  58,  73,  88,  103, 118, 133, 148, 163, 178, 193, 208,
  224, 209, 194, 179, 164, 149, 134, 119, 104, 89,  74,  59,  44,  29,  14,
  15,  30,  45,  60,  75,  90,  105, 120, 135, 150, 165, 180, 195, 210, 225,
  240, 241, 226, 211, 196, 181, 166, 151, 136, 121, 106, 91,  76,  61,  46,
  31,  47,  62,  77,  92,  107, 122, 137, 152, 167, 182, 197, 212, 227, 242,
  243, 228, 213, 198, 183, 168, 153, 138, 123, 108, 93,  78,  63,  79,  94,
  109, 124, 139, 154, 169, 184, 199, 214, 229, 244, 245, 230, 215, 200, 185,
  170, 155, 140, 125, 110, 95,  111, 126, 141, 156, 171, 186, 201, 216, 231,
  246, 247, 232, 217, 202, 187, 172, 157, 142, 127, 143, 158, 173, 188, 203,
  218, 233, 248, 249, 234, 219, 204, 189, 174, 159, 175, 190, 205, 220, 235,
  250, 251, 236, 221, 206, 191, 207, 222, 237, 252, 253, 238, 223, 239, 254,
  255
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x16[256]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  1,  17, 33, 49, 65, 81, 97,  113, 129, 145, 161, 177, 193, 209, 225, 241,
  2,  18, 34, 50, 66, 82, 98,  114, 130, 146, 162, 178, 194, 210, 226, 242,
  3,  19, 35, 51, 67, 83, 99,  115, 131, 147, 163, 179, 195, 211, 227, 243,
  4,  20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244,
  5,  21, 37, 53, 69, 85, 101, 117, 133, 149, 165, 181, 197, 213, 229, 245,
  6,  22, 38, 54, 70, 86, 102, 118, 134, 150, 166, 182, 198, 214, 230, 246,
  7,  23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  8,  24, 40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232, 248,
  9,  25, 41, 57, 73, 89, 105, 121, 137, 153, 169, 185, 201, 217, 233, 249,
  10, 26, 42, 58, 74, 90, 106, 122, 138, 154, 170, 186, 202, 218, 234, 250,
  11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251,
  12, 28, 44, 60, 76, 92, 108, 124, 140, 156, 172, 188, 204, 220, 236, 252,
  13, 29, 45, 61, 77, 93, 109, 125, 141, 157, 173, 189, 205, 221, 237, 253,
  14, 30, 46, 62, 78, 94, 110, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x16[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x32[1024]) = {
  0,   32,   64,  96,   128, 160,  192, 224,  256, 288,  320, 352,  384, 416,
  448, 480,  512, 544,  576, 608,  640, 672,  704, 736,  768, 800,  832, 864,
  896, 928,  960, 992,  1,   33,   65,  97,   129, 161,  193, 225,  257, 289,
  321, 353,  385, 417,  449, 481,  513, 545,  577, 609,  641, 673,  705, 737,
  769, 801,  833, 865,  897, 929,  961, 993,  2,   34,   66,  98,   130, 162,
  194, 226,  258, 290,  322, 354,  386, 418,  450, 482,  514, 546,  578, 610,
  642, 674,  706, 738,  770, 802,  834, 866,  898, 930,  962, 994,  3,   35,
  67,  99,   131, 163,  195, 227,  259, 291,  323, 355,  387, 419,  451, 483,
  515, 547,  579, 611,  643, 675,  707, 739,  771, 803,  835, 867,  899, 931,
  963, 995,  4,   36,   68,  100,  132, 164,  196, 228,  260, 292,  324, 356,
  388, 420,  452, 484,  516, 548,  580, 612,  644, 676,  708, 740,  772, 804,
  836, 868,  900, 932,  964, 996,  5,   37,   69,  101,  133, 165,  197, 229,
  261, 293,  325, 357,  389, 421,  453, 485,  517, 549,  581, 613,  645, 677,
  709, 741,  773, 805,  837, 869,  901, 933,  965, 997,  6,   38,   70,  102,
  134, 166,  198, 230,  262, 294,  326, 358,  390, 422,  454, 486,  518, 550,
  582, 614,  646, 678,  710, 742,  774, 806,  838, 870,  902, 934,  966, 998,
  7,   39,   71,  103,  135, 167,  199, 231,  263, 295,  327, 359,  391, 423,
  455, 487,  519, 551,  583, 615,  647, 679,  711, 743,  775, 807,  839, 871,
  903, 935,  967, 999,  8,   40,   72,  104,  136, 168,  200, 232,  264, 296,
  328, 360,  392, 424,  456, 488,  520, 552,  584, 616,  648, 680,  712, 744,
  776, 808,  840, 872,  904, 936,  968, 1000, 9,   41,   73,  105,  137, 169,
  201, 233,  265, 297,  329, 361,  393, 425,  457, 489,  521, 553,  585, 617,
  649, 681,  713, 745,  777, 809,  841, 873,  905, 937,  969, 1001, 10,  42,
  74,  106,  138, 170,  202, 234,  266, 298,  330, 362,  394, 426,  458, 490,
  522, 554,  586, 618,  650, 682,  714, 746,  778, 810,  842, 874,  906, 938,
  970, 1002, 11,  43,   75,  107,  139, 171,  203, 235,  267, 299,  331, 363,
  395, 427,  459, 491,  523, 555,  587, 619,  651, 683,  715, 747,  779, 811,
  843, 875,  907, 939,  971, 1003, 12,  44,   76,  108,  140, 172,  204, 236,
  268, 300,  332, 364,  396, 428,  460, 492,  524, 556,  588, 620,  652, 684,
  716, 748,  780, 812,  844, 876,  908, 940,  972, 1004, 13,  45,   77,  109,
  141, 173,  205, 237,  269, 301,  333, 365,  397, 429,  461, 493,  525, 557,
  589, 621,  653, 685,  717, 749,  781, 813,  845, 877,  909, 941,  973, 1005,
  14,  46,   78,  110,  142, 174,  206, 238,  270, 302,  334, 366,  398, 430,
  462, 494,  526, 558,  590, 622,  654, 686,  718, 750,  782, 814,  846, 878,
  910, 942,  974, 1006, 15,  47,   79,  111,  143, 175,  207, 239,  271, 303,
  335, 367,  399, 431,  463, 495,  527, 559,  591, 623,  655, 687,  719, 751,
  783, 815,  847, 879,  911, 943,  975, 1007, 16,  48,   80,  112,  144, 176,
  208, 240,  272, 304,  336, 368,  400, 432,  464, 496,  528, 560,  592, 624,
  656, 688,  720, 752,  784, 816,  848, 880,  912, 944,  976, 1008, 17,  49,
  81,  113,  145, 177,  209, 241,  273, 305,  337, 369,  401, 433,  465, 497,
  529, 561,  593, 625,  657, 689,  721, 753,  785, 817,  849, 881,  913, 945,
  977, 1009, 18,  50,   82,  114,  146, 178,  210, 242,  274, 306,  338, 370,
  402, 434,  466, 498,  530, 562,  594, 626,  658, 690,  722, 754,  786, 818,
  850, 882,  914, 946,  978, 1010, 19,  51,   83,  115,  147, 179,  211, 243,
  275, 307,  339, 371,  403, 435,  467, 499,  531, 563,  595, 627,  659, 691,
  723, 755,  787, 819,  851, 883,  915, 947,  979, 1011, 20,  52,   84,  116,
  148, 180,  212, 244,  276, 308,  340, 372,  404, 436,  468, 500,  532, 564,
  596, 628,  660, 692,  724, 756,  788, 820,  852, 884,  916, 948,  980, 1012,
  21,  53,   85,  117,  149, 181,  213, 245,  277, 309,  341, 373,  405, 437,
  469, 501,  533, 565,  597, 629,  661, 693,  725, 757,  789, 821,  853, 885,
  917, 949,  981, 1013, 22,  54,   86,  118,  150, 182,  214, 246,  278, 310,
  342, 374,  406, 438,  470, 502,  534, 566,  598, 630,  662, 694,  726, 758,
  790, 822,  854, 886,  918, 950,  982, 1014, 23,  55,   87,  119,  151, 183,
  215, 247,  279, 311,  343, 375,  407, 439,  471, 503,  535, 567,  599, 631,
  663, 695,  727, 759,  791, 823,  855, 887,  919, 951,  983, 1015, 24,  56,
  88,  120,  152, 184,  216, 248,  280, 312,  344, 376,  408, 440,  472, 504,
  536, 568,  600, 632,  664, 696,  728, 760,  792, 824,  856, 888,  920, 952,
  984, 1016, 25,  57,   89,  121,  153, 185,  217, 249,  281, 313,  345, 377,
  409, 441,  473, 505,  537, 569,  601, 633,  665, 697,  729, 761,  793, 825,
  857, 889,  921, 953,  985, 1017, 26,  58,   90,  122,  154, 186,  218, 250,
  282, 314,  346, 378,  410, 442,  474, 506,  538, 570,  602, 634,  666, 698,
  730, 762,  794, 826,  858, 890,  922, 954,  986, 1018, 27,  59,   91,  123,
  155, 187,  219, 251,  283, 315,  347, 379,  411, 443,  475, 507,  539, 571,
  603, 635,  667, 699,  731, 763,  795, 827,  859, 891,  923, 955,  987, 1019,
  28,  60,   92,  124,  156, 188,  220, 252,  284, 316,  348, 380,  412, 444,
  476, 508,  540, 572,  604, 636,  668, 700,  732, 764,  796, 828,  860, 892,
  924, 956,  988, 1020, 29,  61,   93,  125,  157, 189,  221, 253,  285, 317,
  349, 381,  413, 445,  477, 509,  541, 573,  605, 637,  669, 701,  733, 765,
  797, 829,  861, 893,  925, 957,  989, 1021, 30,  62,   94,  126,  158, 190,
  222, 254,  286, 318,  350, 382,  414, 446,  478, 510,  542, 574,  606, 638,
  670, 702,  734, 766,  798, 830,  862, 894,  926, 958,  990, 1022, 31,  63,
  95,  127,  159, 191,  223, 255,  287, 319,  351, 383,  415, 447,  479, 511,
  543, 575,  607, 639,  671, 703,  735, 767,  799, 831,  863, 895,  927, 959,
  991, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x32[1024]) = {
  0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,
  13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
  26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
  39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
  52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
  65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
  78,   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
  91,   92,   93,   94,   95,   96,   97,   98,   99,   100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,
  156,  157,  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,  168,
  169,  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
  208,  209,  210,  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  249,  250,  251,  252,  253,  254,  255,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  420,  421,  422,  423,  424,  425,  426,  427,  428,
  429,  430,  431,  432,  433,  434,  435,  436,  437,  438,  439,  440,  441,
  442,  443,  444,  445,  446,  447,  448,  449,  450,  451,  452,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,  465,  466,  467,
  468,  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,  479,  480,
  481,  482,  483,  484,  485,  486,  487,  488,  489,  490,  491,  492,  493,
  494,  495,  496,  497,  498,  499,  500,  501,  502,  503,  504,  505,  506,
  507,  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,  518,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,  532,
  533,  534,  535,  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  551,  552,  553,  554,  555,  556,  557,  558,
  559,  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,  573,  574,  575,  576,  577,  578,  579,  580,  581,  582,  583,  584,
  585,  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,  610,
  611,  612,  613,  614,  615,  616,  617,  618,  619,  620,  621,  622,  623,
  624,  625,  626,  627,  628,  629,  630,  631,  632,  633,  634,  635,  636,
  637,  638,  639,  640,  641,  642,  643,  644,  645,  646,  647,  648,  649,
  650,  651,  652,  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
  676,  677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,
  689,  690,  691,  692,  693,  694,  695,  696,  697,  698,  699,  700,  701,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,  712,  713,  714,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,  727,
  728,  729,  730,  731,  732,  733,  734,  735,  736,  737,  738,  739,  740,
  741,  742,  743,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,
  754,  755,  756,  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  767,  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,  778,  779,
  780,  781,  782,  783,  784,  785,  786,  787,  788,  789,  790,  791,  792,
  793,  794,  795,  796,  797,  798,  799,  800,  801,  802,  803,  804,  805,
  806,  807,  808,  809,  810,  811,  812,  813,  814,  815,  816,  817,  818,
  819,  820,  821,  822,  823,  824,  825,  826,  827,  828,  829,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,  842,  843,  844,
  845,  846,  847,  848,  849,  850,  851,  852,  853,  854,  855,  856,  857,
  858,  859,  860,  861,  862,  863,  864,  865,  866,  867,  868,  869,  870,
  871,  872,  873,  874,  875,  876,  877,  878,  879,  880,  881,  882,  883,
  884,  885,  886,  887,  888,  889,  890,  891,  892,  893,  894,  895,  896,
  897,  898,  899,  900,  901,  902,  903,  904,  905,  906,  907,  908,  909,
  910,  911,  912,  913,  914,  915,  916,  917,  918,  919,  920,  921,  922,
  923,  924,  925,  926,  927,  928,  929,  930,  931,  932,  933,  934,  935,
  936,  937,  938,  939,  940,  941,  942,  943,  944,  945,  946,  947,  948,
  949,  950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,
  962,  963,  964,  965,  966,  967,  968,  969,  970,  971,  972,  973,  974,
  975,  976,  977,  978,  979,  980,  981,  982,  983,  984,  985,  986,  987,
  988,  989,  990,  991,  992,  993,  994,  995,  996,  997,  998,  999,  1000,
  1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
  1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x32[1024]) = {
  0,    1,    32,   64,   33,   2,   3,    34,   65,   96,   128,  97,  66,
  35,   4,    5,    36,   67,   98,  129,  160,  192,  161,  130,  99,  68,
  37,   6,    7,    38,   69,   100, 131,  162,  193,  224,  256,  225, 194,
  163,  132,  101,  70,   39,   8,   9,    40,   71,   102,  133,  164, 195,
  226,  257,  288,  320,  289,  258, 227,  196,  165,  134,  103,  72,  41,
  10,   11,   42,   73,   104,  135, 166,  197,  228,  259,  290,  321, 352,
  384,  353,  322,  291,  260,  229, 198,  167,  136,  105,  74,   43,  12,
  13,   44,   75,   106,  137,  168, 199,  230,  261,  292,  323,  354, 385,
  416,  448,  417,  386,  355,  324, 293,  262,  231,  200,  169,  138, 107,
  76,   45,   14,   15,   46,   77,  108,  139,  170,  201,  232,  263, 294,
  325,  356,  387,  418,  449,  480, 512,  481,  450,  419,  388,  357, 326,
  295,  264,  233,  202,  171,  140, 109,  78,   47,   16,   17,   48,  79,
  110,  141,  172,  203,  234,  265, 296,  327,  358,  389,  420,  451, 482,
  513,  544,  576,  545,  514,  483, 452,  421,  390,  359,  328,  297, 266,
  235,  204,  173,  142,  111,  80,  49,   18,   19,   50,   81,   112, 143,
  174,  205,  236,  267,  298,  329, 360,  391,  422,  453,  484,  515, 546,
  577,  608,  640,  609,  578,  547, 516,  485,  454,  423,  392,  361, 330,
  299,  268,  237,  206,  175,  144, 113,  82,   51,   20,   21,   52,  83,
  114,  145,  176,  207,  238,  269, 300,  331,  362,  393,  424,  455, 486,
  517,  548,  579,  610,  641,  672, 704,  673,  642,  611,  580,  549, 518,
  487,  456,  425,  394,  363,  332, 301,  270,  239,  208,  177,  146, 115,
  84,   53,   22,   23,   54,   85,  116,  147,  178,  209,  240,  271, 302,
  333,  364,  395,  426,  457,  488, 519,  550,  581,  612,  643,  674, 705,
  736,  768,  737,  706,  675,  644, 613,  582,  551,  520,  489,  458, 427,
  396,  365,  334,  303,  272,  241, 210,  179,  148,  117,  86,   55,  24,
  25,   56,   87,   118,  149,  180, 211,  242,  273,  304,  335,  366, 397,
  428,  459,  490,  521,  552,  583, 614,  645,  676,  707,  738,  769, 800,
  832,  801,  770,  739,  708,  677, 646,  615,  584,  553,  522,  491, 460,
  429,  398,  367,  336,  305,  274, 243,  212,  181,  150,  119,  88,  57,
  26,   27,   58,   89,   120,  151, 182,  213,  244,  275,  306,  337, 368,
  399,  430,  461,  492,  523,  554, 585,  616,  647,  678,  709,  740, 771,
  802,  833,  864,  896,  865,  834, 803,  772,  741,  710,  679,  648, 617,
  586,  555,  524,  493,  462,  431, 400,  369,  338,  307,  276,  245, 214,
  183,  152,  121,  90,   59,   28,  29,   60,   91,   122,  153,  184, 215,
  246,  277,  308,  339,  370,  401, 432,  463,  494,  525,  556,  587, 618,
  649,  680,  711,  742,  773,  804, 835,  866,  897,  928,  960,  929, 898,
  867,  836,  805,  774,  743,  712, 681,  650,  619,  588,  557,  526, 495,
  464,  433,  402,  371,  340,  309, 278,  247,  216,  185,  154,  123, 92,
  61,   30,   31,   62,   93,   124, 155,  186,  217,  248,  279,  310, 341,
  372,  403,  434,  465,  496,  527, 558,  589,  620,  651,  682,  713, 744,
  775,  806,  837,  868,  899,  930, 961,  992,  993,  962,  931,  900, 869,
  838,  807,  776,  745,  714,  683, 652,  621,  590,  559,  528,  497, 466,
  435,  404,  373,  342,  311,  280, 249,  218,  187,  156,  125,  94,  63,
  95,   126,  157,  188,  219,  250, 281,  312,  343,  374,  405,  436, 467,
  498,  529,  560,  591,  622,  653, 684,  715,  746,  777,  808,  839, 870,
  901,  932,  963,  994,  995,  964, 933,  902,  871,  840,  809,  778, 747,
  716,  685,  654,  623,  592,  561, 530,  499,  468,  437,  406,  375, 344,
  313,  282,  251,  220,  189,  158, 127,  159,  190,  221,  252,  283, 314,
  345,  376,  407,  438,  469,  500, 531,  562,  593,  624,  655,  686, 717,
  748,  779,  810,  841,  872,  903, 934,  965,  996,  997,  966,  935, 904,
  873,  842,  811,  780,  749,  718, 687,  656,  625,  594,  563,  532, 501,
  470,  439,  408,  377,  346,  315, 284,  253,  222,  191,  223,  254, 285,
  316,  347,  378,  409,  440,  471, 502,  533,  564,  595,  626,  657, 688,
  719,  750,  781,  812,  843,  874, 905,  936,  967,  998,  999,  968, 937,
  906,  875,  844,  813,  782,  751, 720,  689,  658,  627,  596,  565, 534,
  503,  472,  441,  410,  379,  348, 317,  286,  255,  287,  318,  349, 380,
  411,  442,  473,  504,  535,  566, 597,  628,  659,  690,  721,  752, 783,
  814,  845,  876,  907,  938,  969, 1000, 1001, 970,  939,  908,  877, 846,
  815,  784,  753,  722,  691,  660, 629,  598,  567,  536,  505,  474, 443,
  412,  381,  350,  319,  351,  382, 413,  444,  475,  506,  537,  568, 599,
  630,  661,  692,  723,  754,  785, 816,  847,  878,  909,  940,  971, 1002,
  1003, 972,  941,  910,  879,  848, 817,  786,  755,  724,  693,  662, 631,
  600,  569,  538,  507,  476,  445, 414,  383,  415,  446,  477,  508, 539,
  570,  601,  632,  663,  694,  725, 756,  787,  818,  849,  880,  911, 942,
  973,  1004, 1005, 974,  943,  912, 881,  850,  819,  788,  757,  726, 695,
  664,  633,  602,  571,  540,  509, 478,  447,  479,  510,  541,  572, 603,
  634,  665,  696,  727,  758,  789, 820,  851,  882,  913,  944,  975, 1006,
  1007, 976,  945,  914,  883,  852, 821,  790,  759,  728,  697,  666, 635,
  604,  573,  542,  511,  543,  574, 605,  636,  667,  698,  729,  760, 791,
  822,  853,  884,  915,  946,  977, 1008, 1009, 978,  947,  916,  885, 854,
  823,  792,  761,  730,  699,  668, 637,  606,  575,  607,  638,  669, 700,
  731,  762,  793,  824,  855,  886, 917,  948,  979,  1010, 1011, 980, 949,
  918,  887,  856,  825,  794,  763, 732,  701,  670,  639,  671,  702, 733,
  764,  795,  826,  857,  888,  919, 950,  981,  1012, 1013, 982,  951, 920,
  889,  858,  827,  796,  765,  734, 703,  735,  766,  797,  828,  859, 890,
  921,  952,  983,  1014, 1015, 984, 953,  922,  891,  860,  829,  798, 767,
  799,  830,  861,  892,  923,  954, 985,  1016, 1017, 986,  955,  924, 893,
  862,  831,  863,  894,  925,  956, 987,  1018, 1019, 988,  957,  926, 895,
  927,  958,  989,  1020, 1021, 990, 959,  991,  1022, 1023
};

// Neighborhood 2-tuples for various scans and blocksizes,
// in {top, left} order for each position in corresponding scan order.
DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 0,  0, 4, 4, 1, 4, 1,  1,  2,  2,  2,  5, 5,
  8, 8, 8, 9, 12, 6, 9, 3, 6, 7, 10, 10, 13, 11, 14, 0, 0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 4, 4,  8,  8, 0, 0, 1, 4, 5,  8,  9,  12, 1,
  1, 2, 5, 6, 9, 10, 13, 2, 2, 3, 6, 7, 10, 11, 14, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 1, 1, 2,  2, 0, 0, 1,  4,  2,  5,  3,  6, 4,
  4, 5, 8, 6, 9, 7, 10, 8, 8, 9, 12, 10, 13, 11, 14, 0, 0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  4,  1,  1,  4,  4,  2,  5,  5,  8,  6,
  9,  2,  2,  8,  8,  3,  6,  9,  12, 7,  10, 10, 13, 12, 12, 13, 16,
  11, 14, 14, 17, 15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21,
  24, 22, 25, 23, 26, 24, 24, 25, 28, 26, 29, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0, 0, 0,  0,  4,  4,  8,  8,  12, 12, 16, 16, 20, 20, 24, 24, 0,
  0, 1, 4,  5,  8,  9,  12, 13, 16, 17, 20, 21, 24, 25, 28, 1,  1,
  2, 5, 6,  9,  10, 13, 14, 17, 18, 21, 22, 25, 26, 29, 2,  2,  3,
  6, 7, 10, 11, 14, 15, 18, 19, 22, 23, 26, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  0,  0,  1,  4,  2,  5,  3,  6,  4,
  4,  5,  8,  6,  9,  7,  10, 8,  8,  9,  12, 10, 13, 11, 14, 12, 12,
  13, 16, 14, 17, 15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21,
  24, 22, 25, 23, 26, 24, 24, 25, 28, 26, 29, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0, 1,  8,  1,  1,  8,  8,  2,  9,  9, 16, 10,
  17, 2,  2,  16, 16, 3, 10, 17, 24, 11, 18, 18, 25, 3,  3, 4,  11,
  19, 26, 12, 19, 4,  4, 20, 27, 5,  12, 13, 20, 21, 28, 5, 5,  6,
  13, 14, 21, 22, 29, 6, 6,  7,  14, 15, 22, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 0,  0,  1,  8,  9,  16, 17, 24, 1,
  1,  2,  9,  10, 17, 18, 25, 2,  2,  3,  10, 11, 18, 19, 26, 3,  3,
  4,  11, 12, 19, 20, 27, 4,  4,  5,  12, 13, 20, 21, 28, 5,  5,  6,
  13, 14, 21, 22, 29, 6,  6,  7,  14, 15, 22, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  0,
  0,  1,  8,  2,  9,  3,  10, 4,  11, 5,  12, 6,  13, 7,  14, 8,  8,
  9,  16, 10, 17, 11, 18, 12, 19, 13, 20, 14, 21, 15, 22, 16, 16, 17,
  24, 18, 25, 19, 26, 20, 27, 21, 28, 22, 29, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  4,  1,  1,  4,  4,  2,  5,  5,  8,  6,  9,  2,
  2,  8,  8,  3,  6,  9,  12, 7,  10, 10, 13, 12, 12, 13, 16, 11, 14, 14, 17,
  15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21, 24, 22, 25, 23, 26, 24,
  24, 25, 28, 26, 29, 27, 30, 28, 28, 29, 32, 30, 33, 31, 34, 32, 32, 33, 36,
  34, 37, 35, 38, 36, 36, 37, 40, 38, 41, 39, 42, 40, 40, 41, 44, 42, 45, 43,
  46, 44, 44, 45, 48, 46, 49, 47, 50, 48, 48, 49, 52, 50, 53, 51, 54, 52, 52,
  53, 56, 54, 57, 55, 58, 56, 56, 57, 60, 58, 61, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  16, 1,  1,  16, 16, 2,  17, 17, 32, 18, 33, 2,
  2,  32, 32, 3,  18, 33, 48, 19, 34, 34, 49, 3,  3,  4,  19, 35, 50, 20, 35,
  4,  4,  36, 51, 5,  20, 21, 36, 37, 52, 5,  5,  6,  21, 22, 37, 38, 53, 6,
  6,  7,  22, 23, 38, 39, 54, 7,  7,  8,  23, 24, 39, 40, 55, 8,  8,  9,  24,
  25, 40, 41, 56, 9,  9,  10, 25, 26, 41, 42, 57, 10, 10, 11, 26, 27, 42, 43,
  58, 11, 11, 12, 27, 28, 43, 44, 59, 12, 12, 13, 28, 29, 44, 45, 60, 13, 13,
  14, 29, 30, 45, 46, 61, 14, 14, 15, 30, 31, 46, 47, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  0,  0,  1,  4,  2,  5,  3,  6,  4,  4,  5,
  8,  6,  9,  7,  10, 8,  8,  9,  12, 10, 13, 11, 14, 12, 12, 13, 16, 14, 17,
  15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21, 24, 22, 25, 23, 26, 24,
  24, 25, 28, 26, 29, 27, 30, 28, 28, 29, 32, 30, 33, 31, 34, 32, 32, 33, 36,
  34, 37, 35, 38, 36, 36, 37, 40, 38, 41, 39, 42, 40, 40, 41, 44, 42, 45, 43,
  46, 44, 44, 45, 48, 46, 49, 47, 50, 48, 48, 49, 52, 50, 53, 51, 54, 52, 52,
  53, 56, 54, 57, 55, 58, 56, 56, 57, 60, 58, 61, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,
  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 0,  0,  1,  16, 2,  17,
  3,  18, 4,  19, 5,  20, 6,  21, 7,  22, 8,  23, 9,  24, 10, 25, 11, 26, 12,
  27, 13, 28, 14, 29, 15, 30, 16, 16, 17, 32, 18, 33, 19, 34, 20, 35, 21, 36,
  22, 37, 23, 38, 24, 39, 25, 40, 26, 41, 27, 42, 28, 43, 29, 44, 30, 45, 31,
  46, 32, 32, 33, 48, 34, 49, 35, 50, 36, 51, 37, 52, 38, 53, 39, 54, 40, 55,
  41, 56, 42, 57, 43, 58, 44, 59, 45, 60, 46, 61, 47, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  4,  4,  8,  8,  12, 12, 16, 16, 20, 20, 24, 24, 28, 28, 32,
  32, 36, 36, 40, 40, 44, 44, 48, 48, 52, 52, 56, 56, 0,  0,  1,  4,  5,  8,
  9,  12, 13, 16, 17, 20, 21, 24, 25, 28, 29, 32, 33, 36, 37, 40, 41, 44, 45,
  48, 49, 52, 53, 56, 57, 60, 1,  1,  2,  5,  6,  9,  10, 13, 14, 17, 18, 21,
  22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 53, 54, 57, 58,
  61, 2,  2,  3,  6,  7,  10, 11, 14, 15, 18, 19, 22, 23, 26, 27, 30, 31, 34,
  35, 38, 39, 42, 43, 46, 47, 50, 51, 54, 55, 58, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  16, 16, 32, 32, 0,  0,  1,  16, 17, 32, 33, 48, 1,  1,  2,
  17, 18, 33, 34, 49, 2,  2,  3,  18, 19, 34, 35, 50, 3,  3,  4,  19, 20, 35,
  36, 51, 4,  4,  5,  20, 21, 36, 37, 52, 5,  5,  6,  21, 22, 37, 38, 53, 6,
  6,  7,  22, 23, 38, 39, 54, 7,  7,  8,  23, 24, 39, 40, 55, 8,  8,  9,  24,
  25, 40, 41, 56, 9,  9,  10, 25, 26, 41, 42, 57, 10, 10, 11, 26, 27, 42, 43,
  58, 11, 11, 12, 27, 28, 43, 44, 59, 12, 12, 13, 28, 29, 44, 45, 60, 13, 13,
  14, 29, 30, 45, 46, 61, 14, 14, 15, 30, 31, 46, 47, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   8,   8,   8,   2,   2,   2,
  9,   9,   16,  16,  16,  3,   3,   3,   10,  10,  17,  17,  24,  24,  24,
  4,   4,   4,   11,  11,  18,  18,  25,  25,  32,  32,  32,  5,   5,   5,
  12,  12,  19,  19,  26,  26,  33,  33,  40,  40,  40,  6,   6,   6,   13,
  13,  20,  20,  27,  27,  34,  34,  41,  41,  48,  48,  48,  7,   14,  14,
  21,  21,  28,  28,  35,  35,  42,  42,  49,  49,  56,  56,  56,  15,  22,
  22,  29,  29,  36,  36,  43,  43,  50,  50,  57,  57,  64,  64,  64,  23,
  30,  30,  37,  37,  44,  44,  51,  51,  58,  58,  65,  65,  72,  72,  72,
  31,  38,  38,  45,  45,  52,  52,  59,  59,  66,  66,  73,  73,  80,  80,
  80,  39,  46,  46,  53,  53,  60,  60,  67,  67,  74,  74,  81,  81,  88,
  88,  88,  47,  54,  54,  61,  61,  68,  68,  75,  75,  82,  82,  89,  89,
  96,  96,  96,  55,  62,  62,  69,  69,  76,  76,  83,  83,  90,  90,  97,
  97,  104, 104, 104, 63,  70,  70,  77,  77,  84,  84,  91,  91,  98,  98,
  105, 105, 112, 112, 112, 71,  78,  78,  85,  85,  92,  92,  99,  99,  106,
  106, 113, 113, 120, 120, 120, 79,  86,  86,  93,  93,  100, 100, 107, 107,
  114, 114, 121, 121, 128, 128, 128, 87,  94,  94,  101, 101, 108, 108, 115,
  115, 122, 122, 129, 129, 136, 136, 136, 95,  102, 102, 109, 109, 116, 116,
  123, 123, 130, 130, 137, 137, 144, 144, 144, 103, 110, 110, 117, 117, 124,
  124, 131, 131, 138, 138, 145, 145, 152, 152, 152, 111, 118, 118, 125, 125,
  132, 132, 139, 139, 146, 146, 153, 153, 160, 160, 160, 119, 126, 126, 133,
  133, 140, 140, 147, 147, 154, 154, 161, 161, 168, 168, 168, 127, 134, 134,
  141, 141, 148, 148, 155, 155, 162, 162, 169, 169, 176, 176, 176, 135, 142,
  142, 149, 149, 156, 156, 163, 163, 170, 170, 177, 177, 184, 184, 184, 143,
  150, 150, 157, 157, 164, 164, 171, 171, 178, 178, 185, 185, 192, 192, 192,
  151, 158, 158, 165, 165, 172, 172, 179, 179, 186, 186, 193, 193, 200, 200,
  200, 159, 166, 166, 173, 173, 180, 180, 187, 187, 194, 194, 201, 201, 208,
  208, 208, 167, 174, 174, 181, 181, 188, 188, 195, 195, 202, 202, 209, 209,
  216, 216, 216, 175, 182, 182, 189, 189, 196, 196, 203, 203, 210, 210, 217,
  217, 224, 224, 224, 183, 190, 190, 197, 197, 204, 204, 211, 211, 218, 218,
  225, 225, 232, 232, 232, 191, 198, 198, 205, 205, 212, 212, 219, 219, 226,
  226, 233, 233, 240, 240, 240, 199, 206, 206, 213, 213, 220, 220, 227, 227,
  234, 234, 241, 241, 248, 207, 214, 214, 221, 221, 228, 228, 235, 235, 242,
  242, 249, 215, 222, 222, 229, 229, 236, 236, 243, 243, 250, 223, 230, 230,
  237, 237, 244, 244, 251, 231, 238, 238, 245, 245, 252, 239, 246, 246, 253,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   32,  32,  32,  2,   2,   2,
  33,  33,  64,  64,  64,  3,   3,   3,   34,  34,  65,  65,  96,  96,  96,
  4,   4,   4,   35,  35,  66,  66,  97,  97,  128, 128, 128, 5,   5,   5,
  36,  36,  67,  67,  98,  98,  129, 129, 160, 160, 160, 6,   6,   6,   37,
  37,  68,  68,  99,  99,  130, 130, 161, 161, 192, 192, 192, 7,   7,   7,
  38,  38,  69,  69,  100, 100, 131, 131, 162, 162, 193, 193, 224, 8,   8,
  8,   39,  39,  70,  70,  101, 101, 132, 132, 163, 163, 194, 194, 225, 9,
  9,   9,   40,  40,  71,  71,  102, 102, 133, 133, 164, 164, 195, 195, 226,
  10,  10,  10,  41,  41,  72,  72,  103, 103, 134, 134, 165, 165, 196, 196,
  227, 11,  11,  11,  42,  42,  73,  73,  104, 104, 135, 135, 166, 166, 197,
  197, 228, 12,  12,  12,  43,  43,  74,  74,  105, 105, 136, 136, 167, 167,
  198, 198, 229, 13,  13,  13,  44,  44,  75,  75,  106, 106, 137, 137, 168,
  168, 199, 199, 230, 14,  14,  14,  45,  45,  76,  76,  107, 107, 138, 138,
  169, 169, 200, 200, 231, 15,  15,  15,  46,  46,  77,  77,  108, 108, 139,
  139, 170, 170, 201, 201, 232, 16,  16,  16,  47,  47,  78,  78,  109, 109,
  140, 140, 171, 171, 202, 202, 233, 17,  17,  17,  48,  48,  79,  79,  110,
  110, 141, 141, 172, 172, 203, 203, 234, 18,  18,  18,  49,  49,  80,  80,
  111, 111, 142, 142, 173, 173, 204, 204, 235, 19,  19,  19,  50,  50,  81,
  81,  112, 112, 143, 143, 174, 174, 205, 205, 236, 20,  20,  20,  51,  51,
  82,  82,  113, 113, 144, 144, 175, 175, 206, 206, 237, 21,  21,  21,  52,
  52,  83,  83,  114, 114, 145, 145, 176, 176, 207, 207, 238, 22,  22,  22,
  53,  53,  84,  84,  115, 115, 146, 146, 177, 177, 208, 208, 239, 23,  23,
  23,  54,  54,  85,  85,  116, 116, 147, 147, 178, 178, 209, 209, 240, 24,
  24,  24,  55,  55,  86,  86,  117, 117, 148, 148, 179, 179, 210, 210, 241,
  25,  25,  25,  56,  56,  87,  87,  118, 118, 149, 149, 180, 180, 211, 211,
  242, 26,  26,  26,  57,  57,  88,  88,  119, 119, 150, 150, 181, 181, 212,
  212, 243, 27,  27,  27,  58,  58,  89,  89,  120, 120, 151, 151, 182, 182,
  213, 213, 244, 28,  28,  28,  59,  59,  90,  90,  121, 121, 152, 152, 183,
  183, 214, 214, 245, 29,  29,  29,  60,  60,  91,  91,  122, 122, 153, 153,
  184, 184, 215, 215, 246, 30,  30,  30,  61,  61,  92,  92,  123, 123, 154,
  154, 185, 185, 216, 216, 247, 31,  62,  62,  93,  93,  124, 124, 155, 155,
  186, 186, 217, 217, 248, 63,  94,  94,  125, 125, 156, 156, 187, 187, 218,
  218, 249, 95,  126, 126, 157, 157, 188, 188, 219, 219, 250, 127, 158, 158,
  189, 189, 220, 220, 251, 159, 190, 190, 221, 221, 252, 191, 222, 222, 253,
  223, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   0,   0,   1,   8,   2,   9,   3,   10,  4,   11,  5,   12,  6,   13,
  7,   14,  8,   8,   9,   16,  10,  17,  11,  18,  12,  19,  13,  20,  14,
  21,  15,  22,  16,  16,  17,  24,  18,  25,  19,  26,  20,  27,  21,  28,
  22,  29,  23,  30,  24,  24,  25,  32,  26,  33,  27,  34,  28,  35,  29,
  36,  30,  37,  31,  38,  32,  32,  33,  40,  34,  41,  35,  42,  36,  43,
  37,  44,  38,  45,  39,  46,  40,  40,  41,  48,  42,  49,  43,  50,  44,
  51,  45,  52,  46,  53,  47,  54,  48,  48,  49,  56,  50,  57,  51,  58,
  52,  59,  53,  60,  54,  61,  55,  62,  56,  56,  57,  64,  58,  65,  59,
  66,  60,  67,  61,  68,  62,  69,  63,  70,  64,  64,  65,  72,  66,  73,
  67,  74,  68,  75,  69,  76,  70,  77,  71,  78,  72,  72,  73,  80,  74,
  81,  75,  82,  76,  83,  77,  84,  78,  85,  79,  86,  80,  80,  81,  88,
  82,  89,  83,  90,  84,  91,  85,  92,  86,  93,  87,  94,  88,  88,  89,
  96,  90,  97,  91,  98,  92,  99,  93,  100, 94,  101, 95,  102, 96,  96,
  97,  104, 98,  105, 99,  106, 100, 107, 101, 108, 102, 109, 103, 110, 104,
  104, 105, 112, 106, 113, 107, 114, 108, 115, 109, 116, 110, 117, 111, 118,
  112, 112, 113, 120, 114, 121, 115, 122, 116, 123, 117, 124, 118, 125, 119,
  126, 120, 120, 121, 128, 122, 129, 123, 130, 124, 131, 125, 132, 126, 133,
  127, 134, 128, 128, 129, 136, 130, 137, 131, 138, 132, 139, 133, 140, 134,
  141, 135, 142, 136, 136, 137, 144, 138, 145, 139, 146, 140, 147, 141, 148,
  142, 149, 143, 150, 144, 144, 145, 152, 146, 153, 147, 154, 148, 155, 149,
  156, 150, 157, 151, 158, 152, 152, 153, 160, 154, 161, 155, 162, 156, 163,
  157, 164, 158, 165, 159, 166, 160, 160, 161, 168, 162, 169, 163, 170, 164,
  171, 165, 172, 166, 173, 167, 174, 168, 168, 169, 176, 170, 177, 171, 178,
  172, 179, 173, 180, 174, 181, 175, 182, 176, 176, 177, 184, 178, 185, 179,
  186, 180, 187, 181, 188, 182, 189, 183, 190, 184, 184, 185, 192, 186, 193,
  187, 194, 188, 195, 189, 196, 190, 197, 191, 198, 192, 192, 193, 200, 194,
  201, 195, 202, 196, 203, 197, 204, 198, 205, 199, 206, 200, 200, 201, 208,
  202, 209, 203, 210, 204, 211, 205, 212, 206, 213, 207, 214, 208, 208, 209,
  216, 210, 217, 211, 218, 212, 219, 213, 220, 214, 221, 215, 222, 216, 216,
  217, 224, 218, 225, 219, 226, 220, 227, 221, 228, 222, 229, 223, 230, 224,
  224, 225, 232, 226, 233, 227, 234, 228, 235, 229, 236, 230, 237, 231, 238,
  232, 232, 233, 240, 234, 241, 235, 242, 236, 243, 237, 244, 238, 245, 239,
  246, 240, 240, 241, 248, 242, 249, 243, 250, 244, 251, 245, 252, 246, 253,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  19,  20,  20,  21,
  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  28,
  29,  29,  30,  30,  0,   0,   1,   32,  2,   33,  3,   34,  4,   35,  5,
  36,  6,   37,  7,   38,  8,   39,  9,   40,  10,  41,  11,  42,  12,  43,
  13,  44,  14,  45,  15,  46,  16,  47,  17,  48,  18,  49,  19,  50,  20,
  51,  21,  52,  22,  53,  23,  54,  24,  55,  25,  56,  26,  57,  27,  58,
  28,  59,  29,  60,  30,  61,  31,  62,  32,  32,  33,  64,  34,  65,  35,
  66,  36,  67,  37,  68,  38,  69,  39,  70,  40,  71,  41,  72,  42,  73,
  43,  74,  44,  75,  45,  76,  46,  77,  47,  78,  48,  79,  49,  80,  50,
  81,  51,  82,  52,  83,  53,  84,  54,  85,  55,  86,  56,  87,  57,  88,
  58,  89,  59,  90,  60,  91,  61,  92,  62,  93,  63,  94,  64,  64,  65,
  96,  66,  97,  67,  98,  68,  99,  69,  100, 70,  101, 71,  102, 72,  103,
  73,  104, 74,  105, 75,  106, 76,  107, 77,  108, 78,  109, 79,  110, 80,
  111, 81,  112, 82,  113, 83,  114, 84,  115, 85,  116, 86,  117, 87,  118,
  88,  119, 89,  120, 90,  121, 91,  122, 92,  123, 93,  124, 94,  125, 95,
  126, 96,  96,  97,  128, 98,  129, 99,  130, 100, 131, 101, 132, 102, 133,
  103, 134, 104, 135, 105, 136, 106, 137, 107, 138, 108, 139, 109, 140, 110,
  141, 111, 142, 112, 143, 113, 144, 114, 145, 115, 146, 116, 147, 117, 148,
  118, 149, 119, 150, 120, 151, 121, 152, 122, 153, 123, 154, 124, 155, 125,
  156, 126, 157, 127, 158, 128, 128, 129, 160, 130, 161, 131, 162, 132, 163,
  133, 164, 134, 165, 135, 166, 136, 167, 137, 168, 138, 169, 139, 170, 140,
  171, 141, 172, 142, 173, 143, 174, 144, 175, 145, 176, 146, 177, 147, 178,
  148, 179, 149, 180, 150, 181, 151, 182, 152, 183, 153, 184, 154, 185, 155,
  186, 156, 187, 157, 188, 158, 189, 159, 190, 160, 160, 161, 192, 162, 193,
  163, 194, 164, 195, 165, 196, 166, 197, 167, 198, 168, 199, 169, 200, 170,
  201, 171, 202, 172, 203, 173, 204, 174, 205, 175, 206, 176, 207, 177, 208,
  178, 209, 179, 210, 180, 211, 181, 212, 182, 213, 183, 214, 184, 215, 185,
  216, 186, 217, 187, 218, 188, 219, 189, 220, 190, 221, 191, 222, 192, 192,
  193, 224, 194, 225, 195, 226, 196, 227, 197, 228, 198, 229, 199, 230, 200,
  231, 201, 232, 202, 233, 203, 234, 204, 235, 205, 236, 206, 237, 207, 238,
  208, 239, 209, 240, 210, 241, 211, 242, 212, 243, 213, 244, 214, 245, 215,
  246, 216, 247, 217, 248, 218, 249, 219, 250, 220, 251, 221, 252, 222, 253,
  223, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   8,   8,   16,  16,  24,  24,  32,  32,  40,  40,  48,
  48,  56,  56,  64,  64,  72,  72,  80,  80,  88,  88,  96,  96,  104, 104,
  112, 112, 120, 120, 128, 128, 136, 136, 144, 144, 152, 152, 160, 160, 168,
  168, 176, 176, 184, 184, 192, 192, 200, 200, 208, 208, 216, 216, 224, 224,
  232, 232, 240, 240, 0,   0,   1,   8,   9,   16,  17,  24,  25,  32,  33,
  40,  41,  48,  49,  56,  57,  64,  65,  72,  73,  80,  81,  88,  89,  96,
  97,  104, 105, 112, 113, 120, 121, 128, 129, 136, 137, 144, 145, 152, 153,
  160, 161, 168, 169, 176, 177, 184, 185, 192, 193, 200, 201, 208, 209, 216,
  217, 224, 225, 232, 233, 240, 241, 248, 1,   1,   2,   9,   10,  17,  18,
  25,  26,  33,  34,  41,  42,  49,  50,  57,  58,  65,  66,  73,  74,  81,
  82,  89,  90,  97,  98,  105, 106, 113, 114, 121, 122, 129, 130, 137, 138,
  145, 146, 153, 154, 161, 162, 169, 170, 177, 178, 185, 186, 193, 194, 201,
  202, 209, 210, 217, 218, 225, 226, 233, 234, 241, 242, 249, 2,   2,   3,
  10,  11,  18,  19,  26,  27,  34,  35,  42,  43,  50,  51,  58,  59,  66,
  67,  74,  75,  82,  83,  90,  91,  98,  99,  106, 107, 114, 115, 122, 123,
  130, 131, 138, 139, 146, 147, 154, 155, 162, 163, 170, 171, 178, 179, 186,
  187, 194, 195, 202, 203, 210, 211, 218, 219, 226, 227, 234, 235, 242, 243,
  250, 3,   3,   4,   11,  12,  19,  20,  27,  28,  35,  36,  43,  44,  51,
  52,  59,  60,  67,  68,  75,  76,  83,  84,  91,  92,  99,  100, 107, 108,
  115, 116, 123, 124, 131, 132, 139, 140, 147, 148, 155, 156, 163, 164, 171,
  172, 179, 180, 187, 188, 195, 196, 203, 204, 211, 212, 219, 220, 227, 228,
  235, 236, 243, 244, 251, 4,   4,   5,   12,  13,  20,  21,  28,  29,  36,
  37,  44,  45,  52,  53,  60,  61,  68,  69,  76,  77,  84,  85,  92,  93,
  100, 101, 108, 109, 116, 117, 124, 125, 132, 133, 140, 141, 148, 149, 156,
  157, 164, 165, 172, 173, 180, 181, 188, 189, 196, 197, 204, 205, 212, 213,
  220, 221, 228, 229, 236, 237, 244, 245, 252, 5,   5,   6,   13,  14,  21,
  22,  29,  30,  37,  38,  45,  46,  53,  54,  61,  62,  69,  70,  77,  78,
  85,  86,  93,  94,  101, 102, 109, 110, 117, 118, 125, 126, 133, 134, 141,
  142, 149, 150, 157, 158, 165, 166, 173, 174, 181, 182, 189, 190, 197, 198,
  205, 206, 213, 214, 221, 222, 229, 230, 237, 238, 245, 246, 253, 6,   6,
  7,   14,  15,  22,  23,  30,  31,  38,  39,  46,  47,  54,  55,  62,  63,
  70,  71,  78,  79,  86,  87,  94,  95,  102, 103, 110, 111, 118, 119, 126,
  127, 134, 135, 142, 143, 150, 151, 158, 159, 166, 167, 174, 175, 182, 183,
  190, 191, 198, 199, 206, 207, 214, 215, 222, 223, 230, 231, 238, 239, 246,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  32, 32, 64, 64,  96,  96,  128, 128, 160, 160, 192, 192,
  0,  0,  1,  32, 33, 64, 65, 96,  97,  128, 129, 160, 161, 192, 193, 224,
  1,  1,  2,  33, 34, 65, 66, 97,  98,  129, 130, 161, 162, 193, 194, 225,
  2,  2,  3,  34, 35, 66, 67, 98,  99,  130, 131, 162, 163, 194, 195, 226,
  3,  3,  4,  35, 36, 67, 68, 99,  100, 131, 132, 163, 164, 195, 196, 227,
  4,  4,  5,  36, 37, 68, 69, 100, 101, 132, 133, 164, 165, 196, 197, 228,
  5,  5,  6,  37, 38, 69, 70, 101, 102, 133, 134, 165, 166, 197, 198, 229,
  6,  6,  7,  38, 39, 70, 71, 102, 103, 134, 135, 166, 167, 198, 199, 230,
  7,  7,  8,  39, 40, 71, 72, 103, 104, 135, 136, 167, 168, 199, 200, 231,
  8,  8,  9,  40, 41, 72, 73, 104, 105, 136, 137, 168, 169, 200, 201, 232,
  9,  9,  10, 41, 42, 73, 74, 105, 106, 137, 138, 169, 170, 201, 202, 233,
  10, 10, 11, 42, 43, 74, 75, 106, 107, 138, 139, 170, 171, 202, 203, 234,
  11, 11, 12, 43, 44, 75, 76, 107, 108, 139, 140, 171, 172, 203, 204, 235,
  12, 12, 13, 44, 45, 76, 77, 108, 109, 140, 141, 172, 173, 204, 205, 236,
  13, 13, 14, 45, 46, 77, 78, 109, 110, 141, 142, 173, 174, 205, 206, 237,
  14, 14, 15, 46, 47, 78, 79, 110, 111, 142, 143, 174, 175, 206, 207, 238,
  15, 15, 16, 47, 48, 79, 80, 111, 112, 143, 144, 175, 176, 207, 208, 239,
  16, 16, 17, 48, 49, 80, 81, 112, 113, 144, 145, 176, 177, 208, 209, 240,
  17, 17, 18, 49, 50, 81, 82, 113, 114, 145, 146, 177, 178, 209, 210, 241,
  18, 18, 19, 50, 51, 82, 83, 114, 115, 146, 147, 178, 179, 210, 211, 242,
  19, 19, 20, 51, 52, 83, 84, 115, 116, 147, 148, 179, 180, 211, 212, 243,
  20, 20, 21, 52, 53, 84, 85, 116, 117, 148, 149, 180, 181, 212, 213, 244,
  21, 21, 22, 53, 54, 85, 86, 117, 118, 149, 150, 181, 182, 213, 214, 245,
  22, 22, 23, 54, 55, 86, 87, 118, 119, 150, 151, 182, 183, 214, 215, 246,
  23, 23, 24, 55, 56, 87, 88, 119, 120, 151, 152, 183, 184, 215, 216, 247,
  24, 24, 25, 56, 57, 88, 89, 120, 121, 152, 153, 184, 185, 216, 217, 248,
  25, 25, 26, 57, 58, 89, 90, 121, 122, 153, 154, 185, 186, 217, 218, 249,
  26, 26, 27, 58, 59, 90, 91, 122, 123, 154, 155, 186, 187, 218, 219, 250,
  27, 27, 28, 59, 60, 91, 92, 123, 124, 155, 156, 187, 188, 219, 220, 251,
  28, 28, 29, 60, 61, 92, 93, 124, 125, 156, 157, 188, 189, 220, 221, 252,
  29, 29, 30, 61, 62, 93, 94, 125, 126, 157, 158, 189, 190, 221, 222, 253,
  30, 30, 31, 62, 63, 94, 95, 126, 127, 158, 159, 190, 191, 222, 223, 254,
  0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 0,  0,  1,
  8,  9,  16, 17, 24, 25, 32, 33, 40, 41, 48, 49, 56, 1,  1,  2,  9,  10, 17,
  18, 25, 26, 33, 34, 41, 42, 49, 50, 57, 2,  2,  3,  10, 11, 18, 19, 26, 27,
  34, 35, 42, 43, 50, 51, 58, 3,  3,  4,  11, 12, 19, 20, 27, 28, 35, 36, 43,
  44, 51, 52, 59, 4,  4,  5,  12, 13, 20, 21, 28, 29, 36, 37, 44, 45, 52, 53,
  60, 5,  5,  6,  13, 14, 21, 22, 29, 30, 37, 38, 45, 46, 53, 54, 61, 6,  6,
  7,  14, 15, 22, 23, 30, 31, 38, 39, 46, 47, 54, 55, 62, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  0,  0,  1,
  8,  2,  9,  3,  10, 4,  11, 5,  12, 6,  13, 7,  14, 8,  8,  9,  16, 10, 17,
  11, 18, 12, 19, 13, 20, 14, 21, 15, 22, 16, 16, 17, 24, 18, 25, 19, 26, 20,
  27, 21, 28, 22, 29, 23, 30, 24, 24, 25, 32, 26, 33, 27, 34, 28, 35, 29, 36,
  30, 37, 31, 38, 32, 32, 33, 40, 34, 41, 35, 42, 36, 43, 37, 44, 38, 45, 39,
  46, 40, 40, 41, 48, 42, 49, 43, 50, 44, 51, 45, 52, 46, 53, 47, 54, 48, 48,
  49, 56, 50, 57, 51, 58, 52, 59, 53, 60, 54, 61, 55, 62, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  8,  8,  1,  8,  1,  1,  2,  2,  2,  9,  9,  16, 16,
  16, 24, 24, 17, 24, 10, 17, 3,  10, 3,  3,  4,  4,  4,  11, 11, 18, 18, 25,
  25, 32, 32, 32, 40, 40, 33, 40, 26, 33, 19, 26, 12, 19, 5,  12, 5,  5,  6,
  6,  6,  13, 13, 20, 20, 27, 27, 34, 34, 41, 41, 48, 48, 48, 49, 56, 42, 49,
  35, 42, 28, 35, 21, 28, 14, 21, 7,  14, 15, 22, 22, 29, 29, 36, 36, 43, 43,
  50, 50, 57, 51, 58, 44, 51, 37, 44, 30, 37, 23, 30, 31, 38, 38, 45, 45, 52,
  52, 59, 53, 60, 46, 53, 39, 46, 47, 54, 54, 61, 55, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   8,   8,   8,   2,   2,   2,
  9,   9,   16,  16,  16,  3,   3,   3,   10,  10,  17,  17,  24,  24,  24,
  4,   4,   4,   11,  11,  18,  18,  25,  25,  32,  32,  32,  5,   5,   5,
  12,  12,  19,  19,  26,  26,  33,  33,  40,  40,  40,  6,   6,   6,   13,
  13,  20,  20,  27,  27,  34,  34,  41,  41,  48,  48,  48,  7,   14,  14,
  21,  21,  28,  28,  35,  35,  42,  42,  49,  49,  56,  56,  56,  15,  22,
  22,  29,  29,  36,  36,  43,  43,  50,  50,  57,  57,  64,  64,  64,  23,
  30,  30,  37,  37,  44,  44,  51,  51,  58,  58,  65,  65,  72,  72,  72,
  31,  38,  38,  45,  45,  52,  52,  59,  59,  66,  66,  73,  73,  80,  80,
  80,  39,  46,  46,  53,  53,  60,  60,  67,  67,  74,  74,  81,  81,  88,
  88,  88,  47,  54,  54,  61,  61,  68,  68,  75,  75,  82,  82,  89,  89,
  96,  96,  96,  55,  62,  62,  69,  69,  76,  76,  83,  83,  90,  90,  97,
  97,  104, 104, 104, 63,  70,  70,  77,  77,  84,  84,  91,  91,  98,  98,
  105, 105, 112, 112, 112, 71,  78,  78,  85,  85,  92,  92,  99,  99,  106,
  106, 113, 113, 120, 79,  86,  86,  93,  93,  100, 100, 107, 107, 114, 114,
  121, 87,  94,  94,  101, 101, 108, 108, 115, 115, 122, 95,  102, 102, 109,
  109, 116, 116, 123, 103, 110, 110, 117, 117, 124, 111, 118, 118, 125, 119,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,  1,  1,   1,   16,  16,  16,  2,   2,   2,
  17,  17,  32,  32,  32,  3,  3,  3,   18,  18,  33,  33,  48,  48,  48,
  4,   4,   4,   19,  19,  34, 34, 49,  49,  64,  64,  64,  5,   5,   5,
  20,  20,  35,  35,  50,  50, 65, 65,  80,  80,  80,  6,   6,   6,   21,
  21,  36,  36,  51,  51,  66, 66, 81,  81,  96,  96,  96,  7,   7,   7,
  22,  22,  37,  37,  52,  52, 67, 67,  82,  82,  97,  97,  112, 8,   8,
  8,   23,  23,  38,  38,  53, 53, 68,  68,  83,  83,  98,  98,  113, 9,
  9,   9,   24,  24,  39,  39, 54, 54,  69,  69,  84,  84,  99,  99,  114,
  10,  10,  10,  25,  25,  40, 40, 55,  55,  70,  70,  85,  85,  100, 100,
  115, 11,  11,  11,  26,  26, 41, 41,  56,  56,  71,  71,  86,  86,  101,
  101, 116, 12,  12,  12,  27, 27, 42,  42,  57,  57,  72,  72,  87,  87,
  102, 102, 117, 13,  13,  13, 28, 28,  43,  43,  58,  58,  73,  73,  88,
  88,  103, 103, 118, 14,  14, 14, 29,  29,  44,  44,  59,  59,  74,  74,
  89,  89,  104, 104, 119, 15, 30, 30,  45,  45,  60,  60,  75,  75,  90,
  90,  105, 105, 120, 31,  46, 46, 61,  61,  76,  76,  91,  91,  106, 106,
  121, 47,  62,  62,  77,  77, 92, 92,  107, 107, 122, 63,  78,  78,  93,
  93,  108, 108, 123, 79,  94, 94, 109, 109, 124, 95,  110, 110, 125, 111,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 24, 24,  32,  32,  40,  40,  48,  48,
  56, 56, 64, 64, 72, 72, 80, 80, 88, 88,  96,  96,  104, 104, 112, 112,
  0,  0,  1,  8,  9,  16, 17, 24, 25, 32,  33,  40,  41,  48,  49,  56,
  57, 64, 65, 72, 73, 80, 81, 88, 89, 96,  97,  104, 105, 112, 113, 120,
  1,  1,  2,  9,  10, 17, 18, 25, 26, 33,  34,  41,  42,  49,  50,  57,
  58, 65, 66, 73, 74, 81, 82, 89, 90, 97,  98,  105, 106, 113, 114, 121,
  2,  2,  3,  10, 11, 18, 19, 26, 27, 34,  35,  42,  43,  50,  51,  58,
  59, 66, 67, 74, 75, 82, 83, 90, 91, 98,  99,  106, 107, 114, 115, 122,
  3,  3,  4,  11, 12, 19, 20, 27, 28, 35,  36,  43,  44,  51,  52,  59,
  60, 67, 68, 75, 76, 83, 84, 91, 92, 99,  100, 107, 108, 115, 116, 123,
  4,  4,  5,  12, 13, 20, 21, 28, 29, 36,  37,  44,  45,  52,  53,  60,
  61, 68, 69, 76, 77, 84, 85, 92, 93, 100, 101, 108, 109, 116, 117, 124,
  5,  5,  6,  13, 14, 21, 22, 29, 30, 37,  38,  45,  46,  53,  54,  61,
  62, 69, 70, 77, 78, 85, 86, 93, 94, 101, 102, 109, 110, 117, 118, 125,
  6,  6,  7,  14, 15, 22, 23, 30, 31, 38,  39,  46,  47,  54,  55,  62,
  63, 70, 71, 78, 79, 86, 87, 94, 95, 102, 103, 110, 111, 118, 119, 126,
  0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  16, 16, 32, 32, 48, 48, 64, 64, 80, 80,  96,  96,
  0,  0,  1,  16, 17, 32, 33, 48, 49, 64, 65, 80, 81, 96,  97,  112,
  1,  1,  2,  17, 18, 33, 34, 49, 50, 65, 66, 81, 82, 97,  98,  113,
  2,  2,  3,  18, 19, 34, 35, 50, 51, 66, 67, 82, 83, 98,  99,  114,
  3,  3,  4,  19, 20, 35, 36, 51, 52, 67, 68, 83, 84, 99,  100, 115,
  4,  4,  5,  20, 21, 36, 37, 52, 53, 68, 69, 84, 85, 100, 101, 116,
  5,  5,  6,  21, 22, 37, 38, 53, 54, 69, 70, 85, 86, 101, 102, 117,
  6,  6,  7,  22, 23, 38, 39, 54, 55, 70, 71, 86, 87, 102, 103, 118,
  7,  7,  8,  23, 24, 39, 40, 55, 56, 71, 72, 87, 88, 103, 104, 119,
  8,  8,  9,  24, 25, 40, 41, 56, 57, 72, 73, 88, 89, 104, 105, 120,
  9,  9,  10, 25, 26, 41, 42, 57, 58, 73, 74, 89, 90, 105, 106, 121,
  10, 10, 11, 26, 27, 42, 43, 58, 59, 74, 75, 90, 91, 106, 107, 122,
  11, 11, 12, 27, 28, 43, 44, 59, 60, 75, 76, 91, 92, 107, 108, 123,
  12, 12, 13, 28, 29, 44, 45, 60, 61, 76, 77, 92, 93, 108, 109, 124,
  13, 13, 14, 29, 30, 45, 46, 61, 62, 77, 78, 93, 94, 109, 110, 125,
  14, 14, 15, 30, 31, 46, 47, 62, 63, 78, 79, 94, 95, 110, 111, 126,
  0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   0,   0,   1,   8,   2,   9,   3,   10,  4,   11,  5,   12,  6,   13,
  7,   14,  8,   8,   9,   16,  10,  17,  11,  18,  12,  19,  13,  20,  14,
  21,  15,  22,  16,  16,  17,  24,  18,  25,  19,  26,  20,  27,  21,  28,
  22,  29,  23,  30,  24,  24,  25,  32,  26,  33,  27,  34,  28,  35,  29,
  36,  30,  37,  31,  38,  32,  32,  33,  40,  34,  41,  35,  42,  36,  43,
  37,  44,  38,  45,  39,  46,  40,  40,  41,  48,  42,  49,  43,  50,  44,
  51,  45,  52,  46,  53,  47,  54,  48,  48,  49,  56,  50,  57,  51,  58,
  52,  59,  53,  60,  54,  61,  55,  62,  56,  56,  57,  64,  58,  65,  59,
  66,  60,  67,  61,  68,  62,  69,  63,  70,  64,  64,  65,  72,  66,  73,
  67,  74,  68,  75,  69,  76,  70,  77,  71,  78,  72,  72,  73,  80,  74,
  81,  75,  82,  76,  83,  77,  84,  78,  85,  79,  86,  80,  80,  81,  88,
  82,  89,  83,  90,  84,  91,  85,  92,  86,  93,  87,  94,  88,  88,  89,
  96,  90,  97,  91,  98,  92,  99,  93,  100, 94,  101, 95,  102, 96,  96,
  97,  104, 98,  105, 99,  106, 100, 107, 101, 108, 102, 109, 103, 110, 104,
  104, 105, 112, 106, 113, 107, 114, 108, 115, 109, 116, 110, 117, 111, 118,
  112, 112, 113, 120, 114, 121, 115, 122, 116, 123, 117, 124, 118, 125, 119,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   16,  16,  16,  2,   2,   2,
  17,  17,  32,  32,  32,  3,   3,   3,   18,  18,  33,  33,  48,  48,  48,
  4,   4,   4,   19,  19,  34,  34,  49,  49,  64,  64,  64,  5,   5,   5,
  20,  20,  35,  35,  50,  50,  65,  65,  80,  80,  80,  6,   6,   6,   21,
  21,  36,  36,  51,  51,  66,  66,  81,  81,  96,  96,  96,  7,   7,   7,
  22,  22,  37,  37,  52,  52,  67,  67,  82,  82,  97,  97,  112, 112, 112,
  8,   8,   8,   23,  23,  38,  38,  53,  53,  68,  68,  83,  83,  98,  98,
  113, 113, 128, 128, 128, 9,   9,   9,   24,  24,  39,  39,  54,  54,  69,
  69,  84,  84,  99,  99,  114, 114, 129, 129, 144, 144, 144, 10,  10,  10,
  25,  25,  40,  40,  55,  55,  70,  70,  85,  85,  100, 100, 115, 115, 130,
  130, 145, 145, 160, 160, 160, 11,  11,  11,  26,  26,  41,  41,  56,  56,
  71,  71,  86,  86,  101, 101, 116, 116, 131, 131, 146, 146, 161, 161, 176,
  176, 176, 12,  12,  12,  27,  27,  42,  42,  57,  57,  72,  72,  87,  87,
  102, 102, 117, 117, 132, 132, 147, 147, 162, 162, 177, 177, 192, 192, 192,
  13,  13,  13,  28,  28,  43,  43,  58,  58,  73,  73,  88,  88,  103, 103,
  118, 118, 133, 133, 148, 148, 163, 163, 178, 178, 193, 193, 208, 208, 208,
  14,  14,  14,  29,  29,  44,  44,  59,  59,  74,  74,  89,  89,  104, 104,
  119, 119, 134, 134, 149, 149, 164, 164, 179, 179, 194, 194, 209, 209, 224,
  224, 224, 15,  30,  30,  45,  45,  60,  60,  75,  75,  90,  90,  105, 105,
  120, 120, 135, 135, 150, 150, 165, 165, 180, 180, 195, 195, 210, 210, 225,
  225, 240, 240, 240, 31,  46,  46,  61,  61,  76,  76,  91,  91,  106, 106,
  121, 121, 136, 136, 151, 151, 166, 166, 181, 181, 196, 196, 211, 211, 226,
  226, 241, 241, 256, 256, 256, 47,  62,  62,  77,  77,  92,  92,  107, 107,
  122, 122, 137, 137, 152, 152, 167, 167, 182, 182, 197, 197, 212, 212, 227,
  227, 242, 242, 257, 257, 272, 272, 272, 63,  78,  78,  93,  93,  108, 108,
  123, 123, 138, 138, 153, 153, 168, 168, 183, 183, 198, 198, 213, 213, 228,
  228, 243, 243, 258, 258, 273, 273, 288, 288, 288, 79,  94,  94,  109, 109,
  124, 124, 139, 139, 154, 154, 169, 169, 184, 184, 199, 199, 214, 214, 229,
  229, 244, 244, 259, 259, 274, 274, 289, 289, 304, 304, 304, 95,  110, 110,
  125, 125, 140, 140, 155, 155, 170, 170, 185, 185, 200, 200, 215, 215, 230,
  230, 245, 245, 260, 260, 275, 275, 290, 290, 305, 305, 320, 320, 320, 111,
  126, 126, 141, 141, 156, 156, 171, 171, 186, 186, 201, 201, 216, 216, 231,
  231, 246, 246, 261, 261, 276, 276, 291, 291, 306, 306, 321, 321, 336, 336,
  336, 127, 142, 142, 157, 157, 172, 172, 187, 187, 202, 202, 217, 217, 232,
  232, 247, 247, 262, 262, 277, 277, 292, 292, 307, 307, 322, 322, 337, 337,
  352, 352, 352, 143, 158, 158, 173, 173, 188, 188, 203, 203, 218, 218, 233,
  233, 248, 248, 263, 263, 278, 278, 293, 293, 308, 308, 323, 323, 338, 338,
  353, 353, 368, 368, 368, 159, 174, 174, 189, 189, 204, 204, 219, 219, 234,
  234, 249, 249, 264, 264, 279, 279, 294, 294, 309, 309, 324, 324, 339, 339,
  354, 354, 369, 369, 384, 384, 384, 175, 190, 190, 205, 205, 220, 220, 235,
  235, 250, 250, 265, 265, 280, 280, 295, 295, 310, 310, 325, 325, 340, 340,
  355, 355, 370, 370, 385, 385, 400, 400, 400, 191, 206, 206, 221, 221, 236,
  236, 251, 251, 266, 266, 281, 281, 296, 296, 311, 311, 326, 326, 341, 341,
  356, 356, 371, 371, 386, 386, 401, 401, 416, 416, 416, 207, 222, 222, 237,
  237, 252, 252, 267, 267, 282, 282, 297, 297, 312, 312, 327, 327, 342, 342,
  357, 357, 372, 372, 387, 387, 402, 402, 417, 417, 432, 432, 432, 223, 238,
  238, 253, 253, 268, 268, 283, 283, 298, 298, 313, 313, 328, 328, 343, 343,
  358, 358, 373, 373, 388, 388, 403, 403, 418, 418, 433, 433, 448, 448, 448,
  239, 254, 254, 269, 269, 284, 284, 299, 299, 314, 314, 329, 329, 344, 344,
  359, 359, 374, 374, 389, 389, 404, 404, 419, 419, 434, 434, 449, 449, 464,
  464, 464, 255, 270, 270, 285, 285, 300, 300, 315, 315, 330, 330, 345, 345,
  360, 360, 375, 375, 390, 390, 405, 405, 420, 420, 435, 435, 450, 450, 465,
  465, 480, 480, 480, 271, 286, 286, 301, 301, 316, 316, 331, 331, 346, 346,
  361, 361, 376, 376, 391, 391, 406, 406, 421, 421, 436, 436, 451, 451, 466,
  466, 481, 481, 496, 287, 302, 302, 317, 317, 332, 332, 347, 347, 362, 362,
  377, 377, 392, 392, 407, 407, 422, 422, 437, 437, 452, 452, 467, 467, 482,
  482, 497, 303, 318, 318, 333, 333, 348, 348, 363, 363, 378, 378, 393, 393,
  408, 408, 423, 423, 438, 438, 453, 453, 468, 468, 483, 483, 498, 319, 334,
  334, 349, 349, 364, 364, 379, 379, 394, 394, 409, 409, 424, 424, 439, 439,
  454, 454, 469, 469, 484, 484, 499, 335, 350, 350, 365, 365, 380, 380, 395,
  395, 410, 410, 425, 425, 440, 440, 455, 455, 470, 470, 485, 485, 500, 351,
  366, 366, 381, 381, 396, 396, 411, 411, 426, 426, 441, 441, 456, 456, 471,
  471, 486, 486, 501, 367, 382, 382, 397, 397, 412, 412, 427, 427, 442, 442,
  457, 457, 472, 472, 487, 487, 502, 383, 398, 398, 413, 413, 428, 428, 443,
  443, 458, 458, 473, 473, 488, 488, 503, 399, 414, 414, 429, 429, 444, 444,
  459, 459, 474, 474, 489, 489, 504, 415, 430, 430, 445, 445, 460, 460, 475,
  475, 490, 490, 505, 431, 446, 446, 461, 461, 476, 476, 491, 491, 506, 447,
  462, 462, 477, 477, 492, 492, 507, 463, 478, 478, 493, 493, 508, 479, 494,
  494, 509, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   32,  32,  32,  2,   2,   2,
  33,  33,  64,  64,  64,  3,   3,   3,   34,  34,  65,  65,  96,  96,  96,
  4,   4,   4,   35,  35,  66,  66,  97,  97,  128, 128, 128, 5,   5,   5,
  36,  36,  67,  67,  98,  98,  129, 129, 160, 160, 160, 6,   6,   6,   37,
  37,  68,  68,  99,  99,  130, 130, 161, 161, 192, 192, 192, 7,   7,   7,
  38,  38,  69,  69,  100, 100, 131, 131, 162, 162, 193, 193, 224, 224, 224,
  8,   8,   8,   39,  39,  70,  70,  101, 101, 132, 132, 163, 163, 194, 194,
  225, 225, 256, 256, 256, 9,   9,   9,   40,  40,  71,  71,  102, 102, 133,
  133, 164, 164, 195, 195, 226, 226, 257, 257, 288, 288, 288, 10,  10,  10,
  41,  41,  72,  72,  103, 103, 134, 134, 165, 165, 196, 196, 227, 227, 258,
  258, 289, 289, 320, 320, 320, 11,  11,  11,  42,  42,  73,  73,  104, 104,
  135, 135, 166, 166, 197, 197, 228, 228, 259, 259, 290, 290, 321, 321, 352,
  352, 352, 12,  12,  12,  43,  43,  74,  74,  105, 105, 136, 136, 167, 167,
  198, 198, 229, 229, 260, 260, 291, 291, 322, 322, 353, 353, 384, 384, 384,
  13,  13,  13,  44,  44,  75,  75,  106, 106, 137, 137, 168, 168, 199, 199,
  230, 230, 261, 261, 292, 292, 323, 323, 354, 354, 385, 385, 416, 416, 416,
  14,  14,  14,  45,  45,  76,  76,  107, 107, 138, 138, 169, 169, 200, 200,
  231, 231, 262, 262, 293, 293, 324, 324, 355, 355, 386, 386, 417, 417, 448,
  448, 448, 15,  15,  15,  46,  46,  77,  77,  108, 108, 139, 139, 170, 170,
  201, 201, 232, 232, 263, 263, 294, 294, 325, 325, 356, 356, 387, 387, 418,
  418, 449, 449, 480, 16,  16,  16,  47,  47,  78,  78,  109, 109, 140, 140,
  171, 171, 202, 202, 233, 233, 264, 264, 295, 295, 326, 326, 357, 357, 388,
  388, 419, 419, 450, 450, 481, 17,  17,  17,  48,  48,  79,  79,  110, 110,
  141, 141, 172, 172, 203, 203, 234, 234, 265, 265, 296, 296, 327, 327, 358,
  358, 389, 389, 420, 420, 451, 451, 482, 18,  18,  18,  49,  49,  80,  80,
  111, 111, 142, 142, 173, 173, 204, 204, 235, 235, 266, 266, 297, 297, 328,
  328, 359, 359, 390, 390, 421, 421, 452, 452, 483, 19,  19,  19,  50,  50,
  81,  81,  112, 112, 143, 143, 174, 174, 205, 205, 236, 236, 267, 267, 298,
  298, 329, 329, 360, 360, 391, 391, 422, 422, 453, 453, 484, 20,  20,  20,
  51,  51,  82,  82,  113, 113, 144, 144, 175, 175, 206, 206, 237, 237, 268,
  268, 299, 299, 330, 330, 361, 361, 392, 392, 423, 423, 454, 454, 485, 21,
  21,  21,  52,  52,  83,  83,  114, 114, 145, 145, 176, 176, 207, 207, 238,
  238, 269, 269, 300, 300, 331, 331, 362, 362, 393, 393, 424, 424, 455, 455,
  486, 22,  22,  22,  53,  53,  84,  84,  115, 115, 146, 146, 177, 177, 208,
  208, 239, 239, 270, 270, 301, 301, 332, 332, 363, 363, 394, 394, 425, 425,
  456, 456, 487, 23,  23,  23,  54,  54,  85,  85,  116, 116, 147, 147, 178,
  178, 209, 209, 240, 240, 271, 271, 302, 302, 333, 333, 364, 364, 395, 395,
  426, 426, 457, 457, 488, 24,  24,  24,  55,  55,  86,  86,  117, 117, 148,
  148, 179, 179, 210, 210, 241, 241, 272, 272, 303, 303, 334, 334, 365, 365,
  396, 396, 427, 427, 458, 458, 489, 25,  25,  25,  56,  56,  87,  87,  118,
  118, 149, 149, 180, 180, 211, 211, 242, 242, 273, 273, 304, 304, 335, 335,
  366, 366, 397, 397, 428, 428, 459, 459, 490, 26,  26,  26,  57,  57,  88,
  88,  119, 119, 150, 150, 181, 181, 212, 212, 243, 243, 274, 274, 305, 305,
  336, 336, 367, 367, 398, 398, 429, 429, 460, 460, 491, 27,  27,  27,  58,
  58,  89,  89,  120, 120, 151, 151, 182, 182, 213, 213, 244, 244, 275, 275,
  306, 306, 337, 337, 368, 368, 399, 399, 430, 430, 461, 461, 492, 28,  28,
  28,  59,  59,  90,  90,  121, 121, 152, 152, 183, 183, 214, 214, 245, 245,
  276, 276, 307, 307, 338, 338, 369, 369, 400, 400, 431, 431, 462, 462, 493,
  29,  29,  29,  60,  60,  91,  91,  122, 122, 153, 153, 184, 184, 215, 215,
  246, 246, 277, 277, 308, 308, 339, 339, 370, 370, 401, 401, 432, 432, 463,
  463, 494, 30,  30,  30,  61,  61,  92,  92,  123, 123, 154, 154, 185, 185,
  216, 216, 247, 247, 278, 278, 309, 309, 340, 340, 371, 371, 402, 402, 433,
  433, 464, 464, 495, 31,  62,  62,  93,  93,  124, 124, 155, 155, 186, 186,
  217, 217, 248, 248, 279, 279, 310, 310, 341, 341, 372, 372, 403, 403, 434,
  434, 465, 465, 496, 63,  94,  94,  125, 125, 156, 156, 187, 187, 218, 218,
  249, 249, 280, 280, 311, 311, 342, 342, 373, 373, 404, 404, 435, 435, 466,
  466, 497, 95,  126, 126, 157, 157, 188, 188, 219, 219, 250, 250, 281, 281,
  312, 312, 343, 343, 374, 374, 405, 405, 436, 436, 467, 467, 498, 127, 158,
  158, 189, 189, 220, 220, 251, 251, 282, 282, 313, 313, 344, 344, 375, 375,
  406, 406, 437, 437, 468, 468, 499, 159, 190, 190, 221, 221, 252, 252, 283,
  283, 314, 314, 345, 345, 376, 376, 407, 407, 438, 438, 469, 469, 500, 191,
  222, 222, 253, 253, 284, 284, 315, 315, 346, 346, 377, 377, 408, 408, 439,
  439, 470, 470, 501, 223, 254, 254, 285, 285, 316, 316, 347, 347, 378, 378,
  409, 409, 440, 440, 471, 471, 502, 255, 286, 286, 317, 317, 348, 348, 379,
  379, 410, 410, 441, 441, 472, 472, 503, 287, 318, 318, 349, 349, 380, 380,
  411, 411, 442, 442, 473, 473, 504, 319, 350, 350, 381, 381, 412, 412, 443,
  443, 474, 474, 505, 351, 382, 382, 413, 413, 444, 444, 475, 475, 506, 383,
  414, 414, 445, 445, 476, 476, 507, 415, 446, 446, 477, 477, 508, 447, 478,
  478, 509, 479, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  16,  32,  32,  48,  48,  64,  64,  80,  80,  96,
  96,  112, 112, 128, 128, 144, 144, 160, 160, 176, 176, 192, 192, 208, 208,
  224, 224, 240, 240, 256, 256, 272, 272, 288, 288, 304, 304, 320, 320, 336,
  336, 352, 352, 368, 368, 384, 384, 400, 400, 416, 416, 432, 432, 448, 448,
  464, 464, 480, 480, 0,   0,   1,   16,  17,  32,  33,  48,  49,  64,  65,
  80,  81,  96,  97,  112, 113, 128, 129, 144, 145, 160, 161, 176, 177, 192,
  193, 208, 209, 224, 225, 240, 241, 256, 257, 272, 273, 288, 289, 304, 305,
  320, 321, 336, 337, 352, 353, 368, 369, 384, 385, 400, 401, 416, 417, 432,
  433, 448, 449, 464, 465, 480, 481, 496, 1,   1,   2,   17,  18,  33,  34,
  49,  50,  65,  66,  81,  82,  97,  98,  113, 114, 129, 130, 145, 146, 161,
  162, 177, 178, 193, 194, 209, 210, 225, 226, 241, 242, 257, 258, 273, 274,
  289, 290, 305, 306, 321, 322, 337, 338, 353, 354, 369, 370, 385, 386, 401,
  402, 417, 418, 433, 434, 449, 450, 465, 466, 481, 482, 497, 2,   2,   3,
  18,  19,  34,  35,  50,  51,  66,  67,  82,  83,  98,  99,  114, 115, 130,
  131, 146, 147, 162, 163, 178, 179, 194, 195, 210, 211, 226, 227, 242, 243,
  258, 259, 274, 275, 290, 291, 306, 307, 322, 323, 338, 339, 354, 355, 370,
  371, 386, 387, 402, 403, 418, 419, 434, 435, 450, 451, 466, 467, 482, 483,
  498, 3,   3,   4,   19,  20,  35,  36,  51,  52,  67,  68,  83,  84,  99,
  100, 115, 116, 131, 132, 147, 148, 163, 164, 179, 180, 195, 196, 211, 212,
  227, 228, 243, 244, 259, 260, 275, 276, 291, 292, 307, 308, 323, 324, 339,
  340, 355, 356, 371, 372, 387, 388, 403, 404, 419, 420, 435, 436, 451, 452,
  467, 468, 483, 484, 499, 4,   4,   5,   20,  21,  36,  37,  52,  53,  68,
  69,  84,  85,  100, 101, 116, 117, 132, 133, 148, 149, 164, 165, 180, 181,
  196, 197, 212, 213, 228, 229, 244, 245, 260, 261, 276, 277, 292, 293, 308,
  309, 324, 325, 340, 341, 356, 357, 372, 373, 388, 389, 404, 405, 420, 421,
  436, 437, 452, 453, 468, 469, 484, 485, 500, 5,   5,   6,   21,  22,  37,
  38,  53,  54,  69,  70,  85,  86,  101, 102, 117, 118, 133, 134, 149, 150,
  165, 166, 181, 182, 197, 198, 213, 214, 229, 230, 245, 246, 261, 262, 277,
  278, 293, 294, 309, 310, 325, 326, 341, 342, 357, 358, 373, 374, 389, 390,
  405, 406, 421, 422, 437, 438, 453, 454, 469, 470, 485, 486, 501, 6,   6,
  7,   22,  23,  38,  39,  54,  55,  70,  71,  86,  87,  102, 103, 118, 119,
  134, 135, 150, 151, 166, 167, 182, 183, 198, 199, 214, 215, 230, 231, 246,
  247, 262, 263, 278, 279, 294, 295, 310, 311, 326, 327, 342, 343, 358, 359,
  374, 375, 390, 391, 406, 407, 422, 423, 438, 439, 454, 455, 470, 471, 486,
  487, 502, 7,   7,   8,   23,  24,  39,  40,  55,  56,  71,  72,  87,  88,
  103, 104, 119, 120, 135, 136, 151, 152, 167, 168, 183, 184, 199, 200, 215,
  216, 231, 232, 247, 248, 263, 264, 279, 280, 295, 296, 311, 312, 327, 328,
  343, 344, 359, 360, 375, 376, 391, 392, 407, 408, 423, 424, 439, 440, 455,
  456, 471, 472, 487, 488, 503, 8,   8,   9,   24,  25,  40,  41,  56,  57,
  72,  73,  88,  89,  104, 105, 120, 121, 136, 137, 152, 153, 168, 169, 184,
  185, 200, 201, 216, 217, 232, 233, 248, 249, 264, 265, 280, 281, 296, 297,
  312, 313, 328, 329, 344, 345, 360, 361, 376, 377, 392, 393, 408, 409, 424,
  425, 440, 441, 456, 457, 472, 473, 488, 489, 504, 9,   9,   10,  25,  26,
  41,  42,  57,  58,  73,  74,  89,  90,  105, 106, 121, 122, 137, 138, 153,
  154, 169, 170, 185, 186, 201, 202, 217, 218, 233, 234, 249, 250, 265, 266,
  281, 282, 297, 298, 313, 314, 329, 330, 345, 346, 361, 362, 377, 378, 393,
  394, 409, 410, 425, 426, 441, 442, 457, 458, 473, 474, 489, 490, 505, 10,
  10,  11,  26,  27,  42,  43,  58,  59,  74,  75,  90,  91,  106, 107, 122,
  123, 138, 139, 154, 155, 170, 171, 186, 187, 202, 203, 218, 219, 234, 235,
  250, 251, 266, 267, 282, 283, 298, 299, 314, 315, 330, 331, 346, 347, 362,
  363, 378, 379, 394, 395, 410, 411, 426, 427, 442, 443, 458, 459, 474, 475,
  490, 491, 506, 11,  11,  12,  27,  28,  43,  44,  59,  60,  75,  76,  91,
  92,  107, 108, 123, 124, 139, 140, 155, 156, 171, 172, 187, 188, 203, 204,
  219, 220, 235, 236, 251, 252, 267, 268, 283, 284, 299, 300, 315, 316, 331,
  332, 347, 348, 363, 364, 379, 380, 395, 396, 411, 412, 427, 428, 443, 444,
  459, 460, 475, 476, 491, 492, 507, 12,  12,  13,  28,  29,  44,  45,  60,
  61,  76,  77,  92,  93,  108, 109, 124, 125, 140, 141, 156, 157, 172, 173,
  188, 189, 204, 205, 220, 221, 236, 237, 252, 253, 268, 269, 284, 285, 300,
  301, 316, 317, 332, 333, 348, 349, 364, 365, 380, 381, 396, 397, 412, 413,
  428, 429, 444, 445, 460, 461, 476, 477, 492, 493, 508, 13,  13,  14,  29,
  30,  45,  46,  61,  62,  77,  78,  93,  94,  109, 110, 125, 126, 141, 142,
  157, 158, 173, 174, 189, 190, 205, 206, 221, 222, 237, 238, 253, 254, 269,
  270, 285, 286, 301, 302, 317, 318, 333, 334, 349, 350, 365, 366, 381, 382,
  397, 398, 413, 414, 429, 430, 445, 446, 461, 462, 477, 478, 493, 494, 509,
  14,  14,  15,  30,  31,  46,  47,  62,  63,  78,  79,  94,  95,  110, 111,
  126, 127, 142, 143, 158, 159, 174, 175, 190, 191, 206, 207, 222, 223, 238,
  239, 254, 255, 270, 271, 286, 287, 302, 303, 318, 319, 334, 335, 350, 351,
  366, 367, 382, 383, 398, 399, 414, 415, 430, 431, 446, 447, 462, 463, 478,
  479, 494, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   32,  32,  64,  64,  96,  96,  128, 128, 160, 160, 192,
  192, 224, 224, 256, 256, 288, 288, 320, 320, 352, 352, 384, 384, 416, 416,
  448, 448, 0,   0,   1,   32,  33,  64,  65,  96,  97,  128, 129, 160, 161,
  192, 193, 224, 225, 256, 257, 288, 289, 320, 321, 352, 353, 384, 385, 416,
  417, 448, 449, 480, 1,   1,   2,   33,  34,  65,  66,  97,  98,  129, 130,
  161, 162, 193, 194, 225, 226, 257, 258, 289, 290, 321, 322, 353, 354, 385,
  386, 417, 418, 449, 450, 481, 2,   2,   3,   34,  35,  66,  67,  98,  99,
  130, 131, 162, 163, 194, 195, 226, 227, 258, 259, 290, 291, 322, 323, 354,
  355, 386, 387, 418, 419, 450, 451, 482, 3,   3,   4,   35,  36,  67,  68,
  99,  100, 131, 132, 163, 164, 195, 196, 227, 228, 259, 260, 291, 292, 323,
  324, 355, 356, 387, 388, 419, 420, 451, 452, 483, 4,   4,   5,   36,  37,
  68,  69,  100, 101, 132, 133, 164, 165, 196, 197, 228, 229, 260, 261, 292,
  293, 324, 325, 356, 357, 388, 389, 420, 421, 452, 453, 484, 5,   5,   6,
  37,  38,  69,  70,  101, 102, 133, 134, 165, 166, 197, 198, 229, 230, 261,
  262, 293, 294, 325, 326, 357, 358, 389, 390, 421, 422, 453, 454, 485, 6,
  6,   7,   38,  39,  70,  71,  102, 103, 134, 135, 166, 167, 198, 199, 230,
  231, 262, 263, 294, 295, 326, 327, 358, 359, 390, 391, 422, 423, 454, 455,
  486, 7,   7,   8,   39,  40,  71,  72,  103, 104, 135, 136, 167, 168, 199,
  200, 231, 232, 263, 264, 295, 296, 327, 328, 359, 360, 391, 392, 423, 424,
  455, 456, 487, 8,   8,   9,   40,  41,  72,  73,  104, 105, 136, 137, 168,
  169, 200, 201, 232, 233, 264, 265, 296, 297, 328, 329, 360, 361, 392, 393,
  424, 425, 456, 457, 488, 9,   9,   10,  41,  42,  73,  74,  105, 106, 137,
  138, 169, 170, 201, 202, 233, 234, 265, 266, 297, 298, 329, 330, 361, 362,
  393, 394, 425, 426, 457, 458, 489, 10,  10,  11,  42,  43,  74,  75,  106,
  107, 138, 139, 170, 171, 202, 203, 234, 235, 266, 267, 298, 299, 330, 331,
  362, 363, 394, 395, 426, 427, 458, 459, 490, 11,  11,  12,  43,  44,  75,
  76,  107, 108, 139, 140, 171, 172, 203, 204, 235, 236, 267, 268, 299, 300,
  331, 332, 363, 364, 395, 396, 427, 428, 459, 460, 491, 12,  12,  13,  44,
  45,  76,  77,  108, 109, 140, 141, 172, 173, 204, 205, 236, 237, 268, 269,
  300, 301, 332, 333, 364, 365, 396, 397, 428, 429, 460, 461, 492, 13,  13,
  14,  45,  46,  77,  78,  109, 110, 141, 142, 173, 174, 205, 206, 237, 238,
  269, 270, 301, 302, 333, 334, 365, 366, 397, 398, 429, 430, 461, 462, 493,
  14,  14,  15,  46,  47,  78,  79,  110, 111, 142, 143, 174, 175, 206, 207,
  238, 239, 270, 271, 302, 303, 334, 335, 366, 367, 398, 399, 430, 431, 462,
  463, 494, 15,  15,  16,  47,  48,  79,  80,  111, 112, 143, 144, 175, 176,
  207, 208, 239, 240, 271, 272, 303, 304, 335, 336, 367, 368, 399, 400, 431,
  432, 463, 464, 495, 16,  16,  17,  48,  49,  80,  81,  112, 113, 144, 145,
  176, 177, 208, 209, 240, 241, 272, 273, 304, 305, 336, 337, 368, 369, 400,
  401, 432, 433, 464, 465, 496, 17,  17,  18,  49,  50,  81,  82,  113, 114,
  145, 146, 177, 178, 209, 210, 241, 242, 273, 274, 305, 306, 337, 338, 369,
  370, 401, 402, 433, 434, 465, 466, 497, 18,  18,  19,  50,  51,  82,  83,
  114, 115, 146, 147, 178, 179, 210, 211, 242, 243, 274, 275, 306, 307, 338,
  339, 370, 371, 402, 403, 434, 435, 466, 467, 498, 19,  19,  20,  51,  52,
  83,  84,  115, 116, 147, 148, 179, 180, 211, 212, 243, 244, 275, 276, 307,
  308, 339, 340, 371, 372, 403, 404, 435, 436, 467, 468, 499, 20,  20,  21,
  52,  53,  84,  85,  116, 117, 148, 149, 180, 181, 212, 213, 244, 245, 276,
  277, 308, 309, 340, 341, 372, 373, 404, 405, 436, 437, 468, 469, 500, 21,
  21,  22,  53,  54,  85,  86,  117, 118, 149, 150, 181, 182, 213, 214, 245,
  246, 277, 278, 309, 310, 341, 342, 373, 374, 405, 406, 437, 438, 469, 470,
  501, 22,  22,  23,  54,  55,  86,  87,  118, 119, 150, 151, 182, 183, 214,
  215, 246, 247, 278, 279, 310, 311, 342, 343, 374, 375, 406, 407, 438, 439,
  470, 471, 502, 23,  23,  24,  55,  56,  87,  88,  119, 120, 151, 152, 183,
  184, 215, 216, 247, 248, 279, 280, 311, 312, 343, 344, 375, 376, 407, 408,
  439, 440, 471, 472, 503, 24,  24,  25,  56,  57,  88,  89,  120, 121, 152,
  153, 184, 185, 216, 217, 248, 249, 280, 281, 312, 313, 344, 345, 376, 377,
  408, 409, 440, 441, 472, 473, 504, 25,  25,  26,  57,  58,  89,  90,  121,
  122, 153, 154, 185, 186, 217, 218, 249, 250, 281, 282, 313, 314, 345, 346,
  377, 378, 409, 410, 441, 442, 473, 474, 505, 26,  26,  27,  58,  59,  90,
  91,  122, 123, 154, 155, 186, 187, 218, 219, 250, 251, 282, 283, 314, 315,
  346, 347, 378, 379, 410, 411, 442, 443, 474, 475, 506, 27,  27,  28,  59,
  60,  91,  92,  123, 124, 155, 156, 187, 188, 219, 220, 251, 252, 283, 284,
  315, 316, 347, 348, 379, 380, 411, 412, 443, 444, 475, 476, 507, 28,  28,
  29,  60,  61,  92,  93,  124, 125, 156, 157, 188, 189, 220, 221, 252, 253,
  284, 285, 316, 317, 348, 349, 380, 381, 412, 413, 444, 445, 476, 477, 508,
  29,  29,  30,  61,  62,  93,  94,  125, 126, 157, 158, 189, 190, 221, 222,
  253, 254, 285, 286, 317, 318, 349, 350, 381, 382, 413, 414, 445, 446, 477,
  478, 509, 30,  30,  31,  62,  63,  94,  95,  126, 127, 158, 159, 190, 191,
  222, 223, 254, 255, 286, 287, 318, 319, 350, 351, 382, 383, 414, 415, 446,
  447, 478, 479, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 112, 112, 113, 128, 114, 129, 115, 130, 116, 131, 117, 132, 118, 133,
  119, 134, 120, 135, 121, 136, 122, 137, 123, 138, 124, 139, 125, 140, 126,
  141, 127, 142, 128, 128, 129, 144, 130, 145, 131, 146, 132, 147, 133, 148,
  134, 149, 135, 150, 136, 151, 137, 152, 138, 153, 139, 154, 140, 155, 141,
  156, 142, 157, 143, 158, 144, 144, 145, 160, 146, 161, 147, 162, 148, 163,
  149, 164, 150, 165, 151, 166, 152, 167, 153, 168, 154, 169, 155, 170, 156,
  171, 157, 172, 158, 173, 159, 174, 160, 160, 161, 176, 162, 177, 163, 178,
  164, 179, 165, 180, 166, 181, 167, 182, 168, 183, 169, 184, 170, 185, 171,
  186, 172, 187, 173, 188, 174, 189, 175, 190, 176, 176, 177, 192, 178, 193,
  179, 194, 180, 195, 181, 196, 182, 197, 183, 198, 184, 199, 185, 200, 186,
  201, 187, 202, 188, 203, 189, 204, 190, 205, 191, 206, 192, 192, 193, 208,
  194, 209, 195, 210, 196, 211, 197, 212, 198, 213, 199, 214, 200, 215, 201,
  216, 202, 217, 203, 218, 204, 219, 205, 220, 206, 221, 207, 222, 208, 208,
  209, 224, 210, 225, 211, 226, 212, 227, 213, 228, 214, 229, 215, 230, 216,
  231, 217, 232, 218, 233, 219, 234, 220, 235, 221, 236, 222, 237, 223, 238,
  224, 224, 225, 240, 226, 241, 227, 242, 228, 243, 229, 244, 230, 245, 231,
  246, 232, 247, 233, 248, 234, 249, 235, 250, 236, 251, 237, 252, 238, 253,
  239, 254, 240, 240, 241, 256, 242, 257, 243, 258, 244, 259, 245, 260, 246,
  261, 247, 262, 248, 263, 249, 264, 250, 265, 251, 266, 252, 267, 253, 268,
  254, 269, 255, 270, 256, 256, 257, 272, 258, 273, 259, 274, 260, 275, 261,
  276, 262, 277, 263, 278, 264, 279, 265, 280, 266, 281, 267, 282, 268, 283,
  269, 284, 270, 285, 271, 286, 272, 272, 273, 288, 274, 289, 275, 290, 276,
  291, 277, 292, 278, 293, 279, 294, 280, 295, 281, 296, 282, 297, 283, 298,
  284, 299, 285, 300, 286, 301, 287, 302, 288, 288, 289, 304, 290, 305, 291,
  306, 292, 307, 293, 308, 294, 309, 295, 310, 296, 311, 297, 312, 298, 313,
  299, 314, 300, 315, 301, 316, 302, 317, 303, 318, 304, 304, 305, 320, 306,
  321, 307, 322, 308, 323, 309, 324, 310, 325, 311, 326, 312, 327, 313, 328,
  314, 329, 315, 330, 316, 331, 317, 332, 318, 333, 319, 334, 320, 320, 321,
  336, 322, 337, 323, 338, 324, 339, 325, 340, 326, 341, 327, 342, 328, 343,
  329, 344, 330, 345, 331, 346, 332, 347, 333, 348, 334, 349, 335, 350, 336,
  336, 337, 352, 338, 353, 339, 354, 340, 355, 341, 356, 342, 357, 343, 358,
  344, 359, 345, 360, 346, 361, 347, 362, 348, 363, 349, 364, 350, 365, 351,
  366, 352, 352, 353, 368, 354, 369, 355, 370, 356, 371, 357, 372, 358, 373,
  359, 374, 360, 375, 361, 376, 362, 377, 363, 378, 364, 379, 365, 380, 366,
  381, 367, 382, 368, 368, 369, 384, 370, 385, 371, 386, 372, 387, 373, 388,
  374, 389, 375, 390, 376, 391, 377, 392, 378, 393, 379, 394, 380, 395, 381,
  396, 382, 397, 383, 398, 384, 384, 385, 400, 386, 401, 387, 402, 388, 403,
  389, 404, 390, 405, 391, 406, 392, 407, 393, 408, 394, 409, 395, 410, 396,
  411, 397, 412, 398, 413, 399, 414, 400, 400, 401, 416, 402, 417, 403, 418,
  404, 419, 405, 420, 406, 421, 407, 422, 408, 423, 409, 424, 410, 425, 411,
  426, 412, 427, 413, 428, 414, 429, 415, 430, 416, 416, 417, 432, 418, 433,
  419, 434, 420, 435, 421, 436, 422, 437, 423, 438, 424, 439, 425, 440, 426,
  441, 427, 442, 428, 443, 429, 444, 430, 445, 431, 446, 432, 432, 433, 448,
  434, 449, 435, 450, 436, 451, 437, 452, 438, 453, 439, 454, 440, 455, 441,
  456, 442, 457, 443, 458, 444, 459, 445, 460, 446, 461, 447, 462, 448, 448,
  449, 464, 450, 465, 451, 466, 452, 467, 453, 468, 454, 469, 455, 470, 456,
  471, 457, 472, 458, 473, 459, 474, 460, 475, 461, 476, 462, 477, 463, 478,
  464, 464, 465, 480, 466, 481, 467, 482, 468, 483, 469, 484, 470, 485, 471,
  486, 472, 487, 473, 488, 474, 489, 475, 490, 476, 491, 477, 492, 478, 493,
  479, 494, 480, 480, 481, 496, 482, 497, 483, 498, 484, 499, 485, 500, 486,
  501, 487, 502, 488, 503, 489, 504, 490, 505, 491, 506, 492, 507, 493, 508,
  494, 509, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  19,  20,  20,  21,
  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  28,
  29,  29,  30,  30,  0,   0,   1,   32,  2,   33,  3,   34,  4,   35,  5,
  36,  6,   37,  7,   38,  8,   39,  9,   40,  10,  41,  11,  42,  12,  43,
  13,  44,  14,  45,  15,  46,  16,  47,  17,  48,  18,  49,  19,  50,  20,
  51,  21,  52,  22,  53,  23,  54,  24,  55,  25,  56,  26,  57,  27,  58,
  28,  59,  29,  60,  30,  61,  31,  62,  32,  32,  33,  64,  34,  65,  35,
  66,  36,  67,  37,  68,  38,  69,  39,  70,  40,  71,  41,  72,  42,  73,
  43,  74,  44,  75,  45,  76,  46,  77,  47,  78,  48,  79,  49,  80,  50,
  81,  51,  82,  52,  83,  53,  84,  54,  85,  55,  86,  56,  87,  57,  88,
  58,  89,  59,  90,  60,  91,  61,  92,  62,  93,  63,  94,  64,  64,  65,
  96,  66,  97,  67,  98,  68,  99,  69,  100, 70,  101, 71,  102, 72,  103,
  73,  104, 74,  105, 75,  106, 76,  107, 77,  108, 78,  109, 79,  110, 80,
  111, 81,  112, 82,  113, 83,  114, 84,  115, 85,  116, 86,  117, 87,  118,
  88,  119, 89,  120, 90,  121, 91,  122, 92,  123, 93,  124, 94,  125, 95,
  126, 96,  96,  97,  128, 98,  129, 99,  130, 100, 131, 101, 132, 102, 133,
  103, 134, 104, 135, 105, 136, 106, 137, 107, 138, 108, 139, 109, 140, 110,
  141, 111, 142, 112, 143, 113, 144, 114, 145, 115, 146, 116, 147, 117, 148,
  118, 149, 119, 150, 120, 151, 121, 152, 122, 153, 123, 154, 124, 155, 125,
  156, 126, 157, 127, 158, 128, 128, 129, 160, 130, 161, 131, 162, 132, 163,
  133, 164, 134, 165, 135, 166, 136, 167, 137, 168, 138, 169, 139, 170, 140,
  171, 141, 172, 142, 173, 143, 174, 144, 175, 145, 176, 146, 177, 147, 178,
  148, 179, 149, 180, 150, 181, 151, 182, 152, 183, 153, 184, 154, 185, 155,
  186, 156, 187, 157, 188, 158, 189, 159, 190, 160, 160, 161, 192, 162, 193,
  163, 194, 164, 195, 165, 196, 166, 197, 167, 198, 168, 199, 169, 200, 170,
  201, 171, 202, 172, 203, 173, 204, 174, 205, 175, 206, 176, 207, 177, 208,
  178, 209, 179, 210, 180, 211, 181, 212, 182, 213, 183, 214, 184, 215, 185,
  216, 186, 217, 187, 218, 188, 219, 189, 220, 190, 221, 191, 222, 192, 192,
  193, 224, 194, 225, 195, 226, 196, 227, 197, 228, 198, 229, 199, 230, 200,
  231, 201, 232, 202, 233, 203, 234, 204, 235, 205, 236, 206, 237, 207, 238,
  208, 239, 209, 240, 210, 241, 211, 242, 212, 243, 213, 244, 214, 245, 215,
  246, 216, 247, 217, 248, 218, 249, 219, 250, 220, 251, 221, 252, 222, 253,
  223, 254, 224, 224, 225, 256, 226, 257, 227, 258, 228, 259, 229, 260, 230,
  261, 231, 262, 232, 263, 233, 264, 234, 265, 235, 266, 236, 267, 237, 268,
  238, 269, 239, 270, 240, 271, 241, 272, 242, 273, 243, 274, 244, 275, 245,
  276, 246, 277, 247, 278, 248, 279, 249, 280, 250, 281, 251, 282, 252, 283,
  253, 284, 254, 285, 255, 286, 256, 256, 257, 288, 258, 289, 259, 290, 260,
  291, 261, 292, 262, 293, 263, 294, 264, 295, 265, 296, 266, 297, 267, 298,
  268, 299, 269, 300, 270, 301, 271, 302, 272, 303, 273, 304, 274, 305, 275,
  306, 276, 307, 277, 308, 278, 309, 279, 310, 280, 311, 281, 312, 282, 313,
  283, 314, 284, 315, 285, 316, 286, 317, 287, 318, 288, 288, 289, 320, 290,
  321, 291, 322, 292, 323, 293, 324, 294, 325, 295, 326, 296, 327, 297, 328,
  298, 329, 299, 330, 300, 331, 301, 332, 302, 333, 303, 334, 304, 335, 305,
  336, 306, 337, 307, 338, 308, 339, 309, 340, 310, 341, 311, 342, 312, 343,
  313, 344, 314, 345, 315, 346, 316, 347, 317, 348, 318, 349, 319, 350, 320,
  320, 321, 352, 322, 353, 323, 354, 324, 355, 325, 356, 326, 357, 327, 358,
  328, 359, 329, 360, 330, 361, 331, 362, 332, 363, 333, 364, 334, 365, 335,
  366, 336, 367, 337, 368, 338, 369, 339, 370, 340, 371, 341, 372, 342, 373,
  343, 374, 344, 375, 345, 376, 346, 377, 347, 378, 348, 379, 349, 380, 350,
  381, 351, 382, 352, 352, 353, 384, 354, 385, 355, 386, 356, 387, 357, 388,
  358, 389, 359, 390, 360, 391, 361, 392, 362, 393, 363, 394, 364, 395, 365,
  396, 366, 397, 367, 398, 368, 399, 369, 400, 370, 401, 371, 402, 372, 403,
  373, 404, 374, 405, 375, 406, 376, 407, 377, 408, 378, 409, 379, 410, 380,
  411, 381, 412, 382, 413, 383, 414, 384, 384, 385, 416, 386, 417, 387, 418,
  388, 419, 389, 420, 390, 421, 391, 422, 392, 423, 393, 424, 394, 425, 395,
  426, 396, 427, 397, 428, 398, 429, 399, 430, 400, 431, 401, 432, 402, 433,
  403, 434, 404, 435, 405, 436, 406, 437, 407, 438, 408, 439, 409, 440, 410,
  441, 411, 442, 412, 443, 413, 444, 414, 445, 415, 446, 416, 416, 417, 448,
  418, 449, 419, 450, 420, 451, 421, 452, 422, 453, 423, 454, 424, 455, 425,
  456, 426, 457, 427, 458, 428, 459, 429, 460, 430, 461, 431, 462, 432, 463,
  433, 464, 434, 465, 435, 466, 436, 467, 437, 468, 438, 469, 439, 470, 440,
  471, 441, 472, 442, 473, 443, 474, 444, 475, 445, 476, 446, 477, 447, 478,
  448, 448, 449, 480, 450, 481, 451, 482, 452, 483, 453, 484, 454, 485, 455,
  486, 456, 487, 457, 488, 458, 489, 459, 490, 460, 491, 461, 492, 462, 493,
  463, 494, 464, 495, 465, 496, 466, 497, 467, 498, 468, 499, 469, 500, 470,
  501, 471, 502, 472, 503, 473, 504, 474, 505, 475, 506, 476, 507, 477, 508,
  478, 509, 479, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  16,  32,  32,  48,  48,  64,  64,  80,  80,  96,
  96,  112, 112, 128, 128, 144, 144, 160, 160, 176, 176, 192, 192, 208, 208,
  224, 224, 0,   0,   1,   16,  17,  32,  33,  48,  49,  64,  65,  80,  81,
  96,  97,  112, 113, 128, 129, 144, 145, 160, 161, 176, 177, 192, 193, 208,
  209, 224, 225, 240, 1,   1,   2,   17,  18,  33,  34,  49,  50,  65,  66,
  81,  82,  97,  98,  113, 114, 129, 130, 145, 146, 161, 162, 177, 178, 193,
  194, 209, 210, 225, 226, 241, 2,   2,   3,   18,  19,  34,  35,  50,  51,
  66,  67,  82,  83,  98,  99,  114, 115, 130, 131, 146, 147, 162, 163, 178,
  179, 194, 195, 210, 211, 226, 227, 242, 3,   3,   4,   19,  20,  35,  36,
  51,  52,  67,  68,  83,  84,  99,  100, 115, 116, 131, 132, 147, 148, 163,
  164, 179, 180, 195, 196, 211, 212, 227, 228, 243, 4,   4,   5,   20,  21,
  36,  37,  52,  53,  68,  69,  84,  85,  100, 101, 116, 117, 132, 133, 148,
  149, 164, 165, 180, 181, 196, 197, 212, 213, 228, 229, 244, 5,   5,   6,
  21,  22,  37,  38,  53,  54,  69,  70,  85,  86,  101, 102, 117, 118, 133,
  134, 149, 150, 165, 166, 181, 182, 197, 198, 213, 214, 229, 230, 245, 6,
  6,   7,   22,  23,  38,  39,  54,  55,  70,  71,  86,  87,  102, 103, 118,
  119, 134, 135, 150, 151, 166, 167, 182, 183, 198, 199, 214, 215, 230, 231,
  246, 7,   7,   8,   23,  24,  39,  40,  55,  56,  71,  72,  87,  88,  103,
  104, 119, 120, 135, 136, 151, 152, 167, 168, 183, 184, 199, 200, 215, 216,
  231, 232, 247, 8,   8,   9,   24,  25,  40,  41,  56,  57,  72,  73,  88,
  89,  104, 105, 120, 121, 136, 137, 152, 153, 168, 169, 184, 185, 200, 201,
  216, 217, 232, 233, 248, 9,   9,   10,  25,  26,  41,  42,  57,  58,  73,
  74,  89,  90,  105, 106, 121, 122, 137, 138, 153, 154, 169, 170, 185, 186,
  201, 202, 217, 218, 233, 234, 249, 10,  10,  11,  26,  27,  42,  43,  58,
  59,  74,  75,  90,  91,  106, 107, 122, 123, 138, 139, 154, 155, 170, 171,
  186, 187, 202, 203, 218, 219, 234, 235, 250, 11,  11,  12,  27,  28,  43,
  44,  59,  60,  75,  76,  91,  92,  107, 108, 123, 124, 139, 140, 155, 156,
  171, 172, 187, 188, 203, 204, 219, 220, 235, 236, 251, 12,  12,  13,  28,
  29,  44,  45,  60,  61,  76,  77,  92,  93,  108, 109, 124, 125, 140, 141,
  156, 157, 172, 173, 188, 189, 204, 205, 220, 221, 236, 237, 252, 13,  13,
  14,  29,  30,  45,  46,  61,  62,  77,  78,  93,  94,  109, 110, 125, 126,
  141, 142, 157, 158, 173, 174, 189, 190, 205, 206, 221, 222, 237, 238, 253,
  14,  14,  15,  30,  31,  46,  47,  62,  63,  78,  79,  94,  95,  110, 111,
  126, 127, 142, 143, 158, 159, 174, 175, 190, 191, 206, 207, 222, 223, 238,
  239, 254, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 112, 112, 113, 128, 114, 129, 115, 130, 116, 131, 117, 132, 118, 133,
  119, 134, 120, 135, 121, 136, 122, 137, 123, 138, 124, 139, 125, 140, 126,
  141, 127, 142, 128, 128, 129, 144, 130, 145, 131, 146, 132, 147, 133, 148,
  134, 149, 135, 150, 136, 151, 137, 152, 138, 153, 139, 154, 140, 155, 141,
  156, 142, 157, 143, 158, 144, 144, 145, 160, 146, 161, 147, 162, 148, 163,
  149, 164, 150, 165, 151, 166, 152, 167, 153, 168, 154, 169, 155, 170, 156,
  171, 157, 172, 158, 173, 159, 174, 160, 160, 161, 176, 162, 177, 163, 178,
  164, 179, 165, 180, 166, 181, 167, 182, 168, 183, 169, 184, 170, 185, 171,
  186, 172, 187, 173, 188, 174, 189, 175, 190, 176, 176, 177, 192, 178, 193,
  179, 194, 180, 195, 181, 196, 182, 197, 183, 198, 184, 199, 185, 200, 186,
  201, 187, 202, 188, 203, 189, 204, 190, 205, 191, 206, 192, 192, 193, 208,
  194, 209, 195, 210, 196, 211, 197, 212, 198, 213, 199, 214, 200, 215, 201,
  216, 202, 217, 203, 218, 204, 219, 205, 220, 206, 221, 207, 222, 208, 208,
  209, 224, 210, 225, 211, 226, 212, 227, 213, 228, 214, 229, 215, 230, 216,
  231, 217, 232, 218, 233, 219, 234, 220, 235, 221, 236, 222, 237, 223, 238,
  224, 224, 225, 240, 226, 241, 227, 242, 228, 243, 229, 244, 230, 245, 231,
  246, 232, 247, 233, 248, 234, 249, 235, 250, 236, 251, 237, 252, 238, 253,
  239, 254, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   16,  16,  1,   16,  1,   1,   2,   2,   2,
  17,  17,  32,  32,  32,  48,  48,  33,  48,  18,  33,  3,   18,  3,   3,
  4,   4,   4,   19,  19,  34,  34,  49,  49,  64,  64,  64,  80,  80,  65,
  80,  50,  65,  35,  50,  20,  35,  5,   20,  5,   5,   6,   6,   6,   21,
  21,  36,  36,  51,  51,  66,  66,  81,  81,  96,  96,  96,  112, 112, 97,
  112, 82,  97,  67,  82,  52,  67,  37,  52,  22,  37,  7,   22,  7,   7,
  8,   8,   8,   23,  23,  38,  38,  53,  53,  68,  68,  83,  83,  98,  98,
  113, 113, 128, 128, 128, 144, 144, 129, 144, 114, 129, 99,  114, 84,  99,
  69,  84,  54,  69,  39,  54,  24,  39,  9,   24,  9,   9,   10,  10,  10,
  25,  25,  40,  40,  55,  55,  70,  70,  85,  85,  100, 100, 115, 115, 130,
  130, 145, 145, 160, 160, 160, 176, 176, 161, 176, 146, 161, 131, 146, 116,
  131, 101, 116, 86,  101, 71,  86,  56,  71,  41,  56,  26,  41,  11,  26,
  11,  11,  12,  12,  12,  27,  27,  42,  42,  57,  57,  72,  72,  87,  87,
  102, 102, 117, 117, 132, 132, 147, 147, 162, 162, 177, 177, 192, 192, 192,
  208, 208, 193, 208, 178, 193, 163, 178, 148, 163, 133, 148, 118, 133, 103,
  118, 88,  103, 73,  88,  58,  73,  43,  58,  28,  43,  13,  28,  13,  13,
  14,  14,  14,  29,  29,  44,  44,  59,  59,  74,  74,  89,  89,  104, 104,
  119, 119, 134, 134, 149, 149, 164, 164, 179, 179, 194, 194, 209, 209, 224,
  224, 224, 225, 240, 210, 225, 195, 210, 180, 195, 165, 180, 150, 165, 135,
  150, 120, 135, 105, 120, 90,  105, 75,  90,  60,  75,  45,  60,  30,  45,
  15,  30,  31,  46,  46,  61,  61,  76,  76,  91,  91,  106, 106, 121, 121,
  136, 136, 151, 151, 166, 166, 181, 181, 196, 196, 211, 211, 226, 226, 241,
  227, 242, 212, 227, 197, 212, 182, 197, 167, 182, 152, 167, 137, 152, 122,
  137, 107, 122, 92,  107, 77,  92,  62,  77,  47,  62,  63,  78,  78,  93,
  93,  108, 108, 123, 123, 138, 138, 153, 153, 168, 168, 183, 183, 198, 198,
  213, 213, 228, 228, 243, 229, 244, 214, 229, 199, 214, 184, 199, 169, 184,
  154, 169, 139, 154, 124, 139, 109, 124, 94,  109, 79,  94,  95,  110, 110,
  125, 125, 140, 140, 155, 155, 170, 170, 185, 185, 200, 200, 215, 215, 230,
  230, 245, 231, 246, 216, 231, 201, 216, 186, 201, 171, 186, 156, 171, 141,
  156, 126, 141, 111, 126, 127, 142, 142, 157, 157, 172, 172, 187, 187, 202,
  202, 217, 217, 232, 232, 247, 233, 248, 218, 233, 203, 218, 188, 203, 173,
  188, 158, 173, 143, 158, 159, 174, 174, 189, 189, 204, 204, 219, 219, 234,
  234, 249, 235, 250, 220, 235, 205, 220, 190, 205, 175, 190, 191, 206, 206,
  221, 221, 236, 236, 251, 237, 252, 222, 237, 207, 222, 223, 238, 238, 253,
  239, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    32,  32,   64,  64,   96,  96,   128, 128,  160, 160,
  192, 192,  224, 224,  256, 256,  288, 288,  320, 320,  352, 352,  384, 384,
  416, 416,  448, 448,  480, 480,  512, 512,  544, 544,  576, 576,  608, 608,
  640, 640,  672, 672,  704, 704,  736, 736,  768, 768,  800, 800,  832, 832,
  864, 864,  896, 896,  928, 928,  960, 960,  0,   0,    1,   32,   33,  64,
  65,  96,   97,  128,  129, 160,  161, 192,  193, 224,  225, 256,  257, 288,
  289, 320,  321, 352,  353, 384,  385, 416,  417, 448,  449, 480,  481, 512,
  513, 544,  545, 576,  577, 608,  609, 640,  641, 672,  673, 704,  705, 736,
  737, 768,  769, 800,  801, 832,  833, 864,  865, 896,  897, 928,  929, 960,
  961, 992,  1,   1,    2,   33,   34,  65,   66,  97,   98,  129,  130, 161,
  162, 193,  194, 225,  226, 257,  258, 289,  290, 321,  322, 353,  354, 385,
  386, 417,  418, 449,  450, 481,  482, 513,  514, 545,  546, 577,  578, 609,
  610, 641,  642, 673,  674, 705,  706, 737,  738, 769,  770, 801,  802, 833,
  834, 865,  866, 897,  898, 929,  930, 961,  962, 993,  2,   2,    3,   34,
  35,  66,   67,  98,   99,  130,  131, 162,  163, 194,  195, 226,  227, 258,
  259, 290,  291, 322,  323, 354,  355, 386,  387, 418,  419, 450,  451, 482,
  483, 514,  515, 546,  547, 578,  579, 610,  611, 642,  643, 674,  675, 706,
  707, 738,  739, 770,  771, 802,  803, 834,  835, 866,  867, 898,  899, 930,
  931, 962,  963, 994,  3,   3,    4,   35,   36,  67,   68,  99,   100, 131,
  132, 163,  164, 195,  196, 227,  228, 259,  260, 291,  292, 323,  324, 355,
  356, 387,  388, 419,  420, 451,  452, 483,  484, 515,  516, 547,  548, 579,
  580, 611,  612, 643,  644, 675,  676, 707,  708, 739,  740, 771,  772, 803,
  804, 835,  836, 867,  868, 899,  900, 931,  932, 963,  964, 995,  4,   4,
  5,   36,   37,  68,   69,  100,  101, 132,  133, 164,  165, 196,  197, 228,
  229, 260,  261, 292,  293, 324,  325, 356,  357, 388,  389, 420,  421, 452,
  453, 484,  485, 516,  517, 548,  549, 580,  581, 612,  613, 644,  645, 676,
  677, 708,  709, 740,  741, 772,  773, 804,  805, 836,  837, 868,  869, 900,
  901, 932,  933, 964,  965, 996,  5,   5,    6,   37,   38,  69,   70,  101,
  102, 133,  134, 165,  166, 197,  198, 229,  230, 261,  262, 293,  294, 325,
  326, 357,  358, 389,  390, 421,  422, 453,  454, 485,  486, 517,  518, 549,
  550, 581,  582, 613,  614, 645,  646, 677,  678, 709,  710, 741,  742, 773,
  774, 805,  806, 837,  838, 869,  870, 901,  902, 933,  934, 965,  966, 997,
  6,   6,    7,   38,   39,  70,   71,  102,  103, 134,  135, 166,  167, 198,
  199, 230,  231, 262,  263, 294,  295, 326,  327, 358,  359, 390,  391, 422,
  423, 454,  455, 486,  487, 518,  519, 550,  551, 582,  583, 614,  615, 646,
  647, 678,  679, 710,  711, 742,  743, 774,  775, 806,  807, 838,  839, 870,
  871, 902,  903, 934,  935, 966,  967, 998,  7,   7,    8,   39,   40,  71,
  72,  103,  104, 135,  136, 167,  168, 199,  200, 231,  232, 263,  264, 295,
  296, 327,  328, 359,  360, 391,  392, 423,  424, 455,  456, 487,  488, 519,
  520, 551,  552, 583,  584, 615,  616, 647,  648, 679,  680, 711,  712, 743,
  744, 775,  776, 807,  808, 839,  840, 871,  872, 903,  904, 935,  936, 967,
  968, 999,  8,   8,    9,   40,   41,  72,   73,  104,  105, 136,  137, 168,
  169, 200,  201, 232,  233, 264,  265, 296,  297, 328,  329, 360,  361, 392,
  393, 424,  425, 456,  457, 488,  489, 520,  521, 552,  553, 584,  585, 616,
  617, 648,  649, 680,  681, 712,  713, 744,  745, 776,  777, 808,  809, 840,
  841, 872,  873, 904,  905, 936,  937, 968,  969, 1000, 9,   9,    10,  41,
  42,  73,   74,  105,  106, 137,  138, 169,  170, 201,  202, 233,  234, 265,
  266, 297,  298, 329,  330, 361,  362, 393,  394, 425,  426, 457,  458, 489,
  490, 521,  522, 553,  554, 585,  586, 617,  618, 649,  650, 681,  682, 713,
  714, 745,  746, 777,  778, 809,  810, 841,  842, 873,  874, 905,  906, 937,
  938, 969,  970, 1001, 10,  10,   11,  42,   43,  74,   75,  106,  107, 138,
  139, 170,  171, 202,  203, 234,  235, 266,  267, 298,  299, 330,  331, 362,
  363, 394,  395, 426,  427, 458,  459, 490,  491, 522,  523, 554,  555, 586,
  587, 618,  619, 650,  651, 682,  683, 714,  715, 746,  747, 778,  779, 810,
  811, 842,  843, 874,  875, 906,  907, 938,  939, 970,  971, 1002, 11,  11,
  12,  43,   44,  75,   76,  107,  108, 139,  140, 171,  172, 203,  204, 235,
  236, 267,  268, 299,  300, 331,  332, 363,  364, 395,  396, 427,  428, 459,
  460, 491,  492, 523,  524, 555,  556, 587,  588, 619,  620, 651,  652, 683,
  684, 715,  716, 747,  748, 779,  780, 811,  812, 843,  844, 875,  876, 907,
  908, 939,  940, 971,  972, 1003, 12,  12,   13,  44,   45,  76,   77,  108,
  109, 140,  141, 172,  173, 204,  205, 236,  237, 268,  269, 300,  301, 332,
  333, 364,  365, 396,  397, 428,  429, 460,  461, 492,  493, 524,  525, 556,
  557, 588,  589, 620,  621, 652,  653, 684,  685, 716,  717, 748,  749, 780,
  781, 812,  813, 844,  845, 876,  877, 908,  909, 940,  941, 972,  973, 1004,
  13,  13,   14,  45,   46,  77,   78,  109,  110, 141,  142, 173,  174, 205,
  206, 237,  238, 269,  270, 301,  302, 333,  334, 365,  366, 397,  398, 429,
  430, 461,  462, 493,  494, 525,  526, 557,  558, 589,  590, 621,  622, 653,
  654, 685,  686, 717,  718, 749,  750, 781,  782, 813,  814, 845,  846, 877,
  878, 909,  910, 941,  942, 973,  974, 1005, 14,  14,   15,  46,   47,  78,
  79,  110,  111, 142,  143, 174,  175, 206,  207, 238,  239, 270,  271, 302,
  303, 334,  335, 366,  367, 398,  399, 430,  431, 462,  463, 494,  495, 526,
  527, 558,  559, 590,  591, 622,  623, 654,  655, 686,  687, 718,  719, 750,
  751, 782,  783, 814,  815, 846,  847, 878,  879, 910,  911, 942,  943, 974,
  975, 1006, 15,  15,   16,  47,   48,  79,   80,  111,  112, 143,  144, 175,
  176, 207,  208, 239,  240, 271,  272, 303,  304, 335,  336, 367,  368, 399,
  400, 431,  432, 463,  464, 495,  496, 527,  528, 559,  560, 591,  592, 623,
  624, 655,  656, 687,  688, 719,  720, 751,  752, 783,  784, 815,  816, 847,
  848, 879,  880, 911,  912, 943,  944, 975,  976, 1007, 16,  16,   17,  48,
  49,  80,   81,  112,  113, 144,  145, 176,  177, 208,  209, 240,  241, 272,
  273, 304,  305, 336,  337, 368,  369, 400,  401, 432,  433, 464,  465, 496,
  497, 528,  529, 560,  561, 592,  593, 624,  625, 656,  657, 688,  689, 720,
  721, 752,  753, 784,  785, 816,  817, 848,  849, 880,  881, 912,  913, 944,
  945, 976,  977, 1008, 17,  17,   18,  49,   50,  81,   82,  113,  114, 145,
  146, 177,  178, 209,  210, 241,  242, 273,  274, 305,  306, 337,  338, 369,
  370, 401,  402, 433,  434, 465,  466, 497,  498, 529,  530, 561,  562, 593,
  594, 625,  626, 657,  658, 689,  690, 721,  722, 753,  754, 785,  786, 817,
  818, 849,  850, 881,  882, 913,  914, 945,  946, 977,  978, 1009, 18,  18,
  19,  50,   51,  82,   83,  114,  115, 146,  147, 178,  179, 210,  211, 242,
  243, 274,  275, 306,  307, 338,  339, 370,  371, 402,  403, 434,  435, 466,
  467, 498,  499, 530,  531, 562,  563, 594,  595, 626,  627, 658,  659, 690,
  691, 722,  723, 754,  755, 786,  787, 818,  819, 850,  851, 882,  883, 914,
  915, 946,  947, 978,  979, 1010, 19,  19,   20,  51,   52,  83,   84,  115,
  116, 147,  148, 179,  180, 211,  212, 243,  244, 275,  276, 307,  308, 339,
  340, 371,  372, 403,  404, 435,  436, 467,  468, 499,  500, 531,  532, 563,
  564, 595,  596, 627,  628, 659,  660, 691,  692, 723,  724, 755,  756, 787,
  788, 819,  820, 851,  852, 883,  884, 915,  916, 947,  948, 979,  980, 1011,
  20,  20,   21,  52,   53,  84,   85,  116,  117, 148,  149, 180,  181, 212,
  213, 244,  245, 276,  277, 308,  309, 340,  341, 372,  373, 404,  405, 436,
  437, 468,  469, 500,  501, 532,  533, 564,  565, 596,  597, 628,  629, 660,
  661, 692,  693, 724,  725, 756,  757, 788,  789, 820,  821, 852,  853, 884,
  885, 916,  917, 948,  949, 980,  981, 1012, 21,  21,   22,  53,   54,  85,
  86,  117,  118, 149,  150, 181,  182, 213,  214, 245,  246, 277,  278, 309,
  310, 341,  342, 373,  374, 405,  406, 437,  438, 469,  470, 501,  502, 533,
  534, 565,  566, 597,  598, 629,  630, 661,  662, 693,  694, 725,  726, 757,
  758, 789,  790, 821,  822, 853,  854, 885,  886, 917,  918, 949,  950, 981,
  982, 1013, 22,  22,   23,  54,   55,  86,   87,  118,  119, 150,  151, 182,
  183, 214,  215, 246,  247, 278,  279, 310,  311, 342,  343, 374,  375, 406,
  407, 438,  439, 470,  471, 502,  503, 534,  535, 566,  567, 598,  599, 630,
  631, 662,  663, 694,  695, 726,  727, 758,  759, 790,  791, 822,  823, 854,
  855, 886,  887, 918,  919, 950,  951, 982,  983, 1014, 23,  23,   24,  55,
  56,  87,   88,  119,  120, 151,  152, 183,  184, 215,  216, 247,  248, 279,
  280, 311,  312, 343,  344, 375,  376, 407,  408, 439,  440, 471,  472, 503,
  504, 535,  536, 567,  568, 599,  600, 631,  632, 663,  664, 695,  696, 727,
  728, 759,  760, 791,  792, 823,  824, 855,  856, 887,  888, 919,  920, 951,
  952, 983,  984, 1015, 24,  24,   25,  56,   57,  88,   89,  120,  121, 152,
  153, 184,  185, 216,  217, 248,  249, 280,  281, 312,  313, 344,  345, 376,
  377, 408,  409, 440,  441, 472,  473, 504,  505, 536,  537, 568,  569, 600,
  601, 632,  633, 664,  665, 696,  697, 728,  729, 760,  761, 792,  793, 824,
  825, 856,  857, 888,  889, 920,  921, 952,  953, 984,  985, 1016, 25,  25,
  26,  57,   58,  89,   90,  121,  122, 153,  154, 185,  186, 217,  218, 249,
  250, 281,  282, 313,  314, 345,  346, 377,  378, 409,  410, 441,  442, 473,
  474, 505,  506, 537,  538, 569,  570, 601,  602, 633,  634, 665,  666, 697,
  698, 729,  730, 761,  762, 793,  794, 825,  826, 857,  858, 889,  890, 921,
  922, 953,  954, 985,  986, 1017, 26,  26,   27,  58,   59,  90,   91,  122,
  123, 154,  155, 186,  187, 218,  219, 250,  251, 282,  283, 314,  315, 346,
  347, 378,  379, 410,  411, 442,  443, 474,  475, 506,  507, 538,  539, 570,
  571, 602,  603, 634,  635, 666,  667, 698,  699, 730,  731, 762,  763, 794,
  795, 826,  827, 858,  859, 890,  891, 922,  923, 954,  955, 986,  987, 1018,
  27,  27,   28,  59,   60,  91,   92,  123,  124, 155,  156, 187,  188, 219,
  220, 251,  252, 283,  284, 315,  316, 347,  348, 379,  380, 411,  412, 443,
  444, 475,  476, 507,  508, 539,  540, 571,  572, 603,  604, 635,  636, 667,
  668, 699,  700, 731,  732, 763,  764, 795,  796, 827,  828, 859,  860, 891,
  892, 923,  924, 955,  956, 987,  988, 1019, 28,  28,   29,  60,   61,  92,
  93,  124,  125, 156,  157, 188,  189, 220,  221, 252,  253, 284,  285, 316,
  317, 348,  349, 380,  381, 412,  413, 444,  445, 476,  477, 508,  509, 540,
  541, 572,  573, 604,  605, 636,  637, 668,  669, 700,  701, 732,  733, 764,
  765, 796,  797, 828,  829, 860,  861, 892,  893, 924,  925, 956,  957, 988,
  989, 1020, 29,  29,   30,  61,   62,  93,   94,  125,  126, 157,  158, 189,
  190, 221,  222, 253,  254, 285,  286, 317,  318, 349,  350, 381,  382, 413,
  414, 445,  446, 477,  478, 509,  510, 541,  542, 573,  574, 605,  606, 637,
  638, 669,  670, 701,  702, 733,  734, 765,  766, 797,  798, 829,  830, 861,
  862, 893,  894, 925,  926, 957,  958, 989,  990, 1021, 30,  30,   31,  62,
  63,  94,   95,  126,  127, 158,  159, 190,  191, 222,  223, 254,  255, 286,
  287, 318,  319, 350,  351, 382,  383, 414,  415, 446,  447, 478,  479, 510,
  511, 542,  543, 574,  575, 606,  607, 638,  639, 670,  671, 702,  703, 734,
  735, 766,  767, 798,  799, 830,  831, 862,  863, 894,  895, 926,  927, 958,
  959, 990,  991, 1022, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    1,   1,    2,   2,    3,   3,    4,   4,    5,   5,
  6,   6,    7,   7,    8,   8,    9,   9,    10,  10,   11,  11,   12,  12,
  13,  13,   14,  14,   15,  15,   16,  16,   17,  17,   18,  18,   19,  19,
  20,  20,   21,  21,   22,  22,   23,  23,   24,  24,   25,  25,   26,  26,
  27,  27,   28,  28,   29,  29,   30,  30,   0,   0,    1,   32,   2,   33,
  3,   34,   4,   35,   5,   36,   6,   37,   7,   38,   8,   39,   9,   40,
  10,  41,   11,  42,   12,  43,   13,  44,   14,  45,   15,  46,   16,  47,
  17,  48,   18,  49,   19,  50,   20,  51,   21,  52,   22,  53,   23,  54,
  24,  55,   25,  56,   26,  57,   27,  58,   28,  59,   29,  60,   30,  61,
  31,  62,   32,  32,   33,  64,   34,  65,   35,  66,   36,  67,   37,  68,
  38,  69,   39,  70,   40,  71,   41,  72,   42,  73,   43,  74,   44,  75,
  45,  76,   46,  77,   47,  78,   48,  79,   49,  80,   50,  81,   51,  82,
  52,  83,   53,  84,   54,  85,   55,  86,   56,  87,   57,  88,   58,  89,
  59,  90,   60,  91,   61,  92,   62,  93,   63,  94,   64,  64,   65,  96,
  66,  97,   67,  98,   68,  99,   69,  100,  70,  101,  71,  102,  72,  103,
  73,  104,  74,  105,  75,  106,  76,  107,  77,  108,  78,  109,  79,  110,
  80,  111,  81,  112,  82,  113,  83,  114,  84,  115,  85,  116,  86,  117,
  87,  118,  88,  119,  89,  120,  90,  121,  91,  122,  92,  123,  93,  124,
  94,  125,  95,  126,  96,  96,   97,  128,  98,  129,  99,  130,  100, 131,
  101, 132,  102, 133,  103, 134,  104, 135,  105, 136,  106, 137,  107, 138,
  108, 139,  109, 140,  110, 141,  111, 142,  112, 143,  113, 144,  114, 145,
  115, 146,  116, 147,  117, 148,  118, 149,  119, 150,  120, 151,  121, 152,
  122, 153,  123, 154,  124, 155,  125, 156,  126, 157,  127, 158,  128, 128,
  129, 160,  130, 161,  131, 162,  132, 163,  133, 164,  134, 165,  135, 166,
  136, 167,  137, 168,  138, 169,  139, 170,  140, 171,  141, 172,  142, 173,
  143, 174,  144, 175,  145, 176,  146, 177,  147, 178,  148, 179,  149, 180,
  150, 181,  151, 182,  152, 183,  153, 184,  154, 185,  155, 186,  156, 187,
  157, 188,  158, 189,  159, 190,  160, 160,  161, 192,  162, 193,  163, 194,
  164, 195,  165, 196,  166, 197,  167, 198,  168, 199,  169, 200,  170, 201,
  171, 202,  172, 203,  173, 204,  174, 205,  175, 206,  176, 207,  177, 208,
  178, 209,  179, 210,  180, 211,  181, 212,  182, 213,  183, 214,  184, 215,
  185, 216,  186, 217,  187, 218,  188, 219,  189, 220,  190, 221,  191, 222,
  192, 192,  193, 224,  194, 225,  195, 226,  196, 227,  197, 228,  198, 229,
  199, 230,  200, 231,  201, 232,  202, 233,  203, 234,  204, 235,  205, 236,
  206, 237,  207, 238,  208, 239,  209, 240,  210, 241,  211, 242,  212, 243,
  213, 244,  214, 245,  215, 246,  216, 247,  217, 248,  218, 249,  219, 250,
  220, 251,  221, 252,  222, 253,  223, 254,  224, 224,  225, 256,  226, 257,
  227, 258,  228, 259,  229, 260,  230, 261,  231, 262,  232, 263,  233, 264,
  234, 265,  235, 266,  236, 267,  237, 268,  238, 269,  239, 270,  240, 271,
  241, 272,  242, 273,  243, 274,  244, 275,  245, 276,  246, 277,  247, 278,
  248, 279,  249, 280,  250, 281,  251, 282,  252, 283,  253, 284,  254, 285,
  255, 286,  256, 256,  257, 288,  258, 289,  259, 290,  260, 291,  261, 292,
  262, 293,  263, 294,  264, 295,  265, 296,  266, 297,  267, 298,  268, 299,
  269, 300,  270, 301,  271, 302,  272, 303,  273, 304,  274, 305,  275, 306,
  276, 307,  277, 308,  278, 309,  279, 310,  280, 311,  281, 312,  282, 313,
  283, 314,  284, 315,  285, 316,  286, 317,  287, 318,  288, 288,  289, 320,
  290, 321,  291, 322,  292, 323,  293, 324,  294, 325,  295, 326,  296, 327,
  297, 328,  298, 329,  299, 330,  300, 331,  301, 332,  302, 333,  303, 334,
  304, 335,  305, 336,  306, 337,  307, 338,  308, 339,  309, 340,  310, 341,
  311, 342,  312, 343,  313, 344,  314, 345,  315, 346,  316, 347,  317, 348,
  318, 349,  319, 350,  320, 320,  321, 352,  322, 353,  323, 354,  324, 355,
  325, 356,  326, 357,  327, 358,  328, 359,  329, 360,  330, 361,  331, 362,
  332, 363,  333, 364,  334, 365,  335, 366,  336, 367,  337, 368,  338, 369,
  339, 370,  340, 371,  341, 372,  342, 373,  343, 374,  344, 375,  345, 376,
  346, 377,  347, 378,  348, 379,  349, 380,  350, 381,  351, 382,  352, 352,
  353, 384,  354, 385,  355, 386,  356, 387,  357, 388,  358, 389,  359, 390,
  360, 391,  361, 392,  362, 393,  363, 394,  364, 395,  365, 396,  366, 397,
  367, 398,  368, 399,  369, 400,  370, 401,  371, 402,  372, 403,  373, 404,
  374, 405,  375, 406,  376, 407,  377, 408,  378, 409,  379, 410,  380, 411,
  381, 412,  382, 413,  383, 414,  384, 384,  385, 416,  386, 417,  387, 418,
  388, 419,  389, 420,  390, 421,  391, 422,  392, 423,  393, 424,  394, 425,
  395, 426,  396, 427,  397, 428,  398, 429,  399, 430,  400, 431,  401, 432,
  402, 433,  403, 434,  404, 435,  405, 436,  406, 437,  407, 438,  408, 439,
  409, 440,  410, 441,  411, 442,  412, 443,  413, 444,  414, 445,  415, 446,
  416, 416,  417, 448,  418, 449,  419, 450,  420, 451,  421, 452,  422, 453,
  423, 454,  424, 455,  425, 456,  426, 457,  427, 458,  428, 459,  429, 460,
  430, 461,  431, 462,  432, 463,  433, 464,  434, 465,  435, 466,  436, 467,
  437, 468,  438, 469,  439, 470,  440, 471,  441, 472,  442, 473,  443, 474,
  444, 475,  445, 476,  446, 477,  447, 478,  448, 448,  449, 480,  450, 481,
  451, 482,  452, 483,  453, 484,  454, 485,  455, 486,  456, 487,  457, 488,
  458, 489,  459, 490,  460, 491,  461, 492,  462, 493,  463, 494,  464, 495,
  465, 496,  466, 497,  467, 498,  468, 499,  469, 500,  470, 501,  471, 502,
  472, 503,  473, 504,  474, 505,  475, 506,  476, 507,  477, 508,  478, 509,
  479, 510,  480, 480,  481, 512,  482, 513,  483, 514,  484, 515,  485, 516,
  486, 517,  487, 518,  488, 519,  489, 520,  490, 521,  491, 522,  492, 523,
  493, 524,  494, 525,  495, 526,  496, 527,  497, 528,  498, 529,  499, 530,
  500, 531,  501, 532,  502, 533,  503, 534,  504, 535,  505, 536,  506, 537,
  507, 538,  508, 539,  509, 540,  510, 541,  511, 542,  512, 512,  513, 544,
  514, 545,  515, 546,  516, 547,  517, 548,  518, 549,  519, 550,  520, 551,
  521, 552,  522, 553,  523, 554,  524, 555,  525, 556,  526, 557,  527, 558,
  528, 559,  529, 560,  530, 561,  531, 562,  532, 563,  533, 564,  534, 565,
  535, 566,  536, 567,  537, 568,  538, 569,  539, 570,  540, 571,  541, 572,
  542, 573,  543, 574,  544, 544,  545, 576,  546, 577,  547, 578,  548, 579,
  549, 580,  550, 581,  551, 582,  552, 583,  553, 584,  554, 585,  555, 586,
  556, 587,  557, 588,  558, 589,  559, 590,  560, 591,  561, 592,  562, 593,
  563, 594,  564, 595,  565, 596,  566, 597,  567, 598,  568, 599,  569, 600,
  570, 601,  571, 602,  572, 603,  573, 604,  574, 605,  575, 606,  576, 576,
  577, 608,  578, 609,  579, 610,  580, 611,  581, 612,  582, 613,  583, 614,
  584, 615,  585, 616,  586, 617,  587, 618,  588, 619,  589, 620,  590, 621,
  591, 622,  592, 623,  593, 624,  594, 625,  595, 626,  596, 627,  597, 628,
  598, 629,  599, 630,  600, 631,  601, 632,  602, 633,  603, 634,  604, 635,
  605, 636,  606, 637,  607, 638,  608, 608,  609, 640,  610, 641,  611, 642,
  612, 643,  613, 644,  614, 645,  615, 646,  616, 647,  617, 648,  618, 649,
  619, 650,  620, 651,  621, 652,  622, 653,  623, 654,  624, 655,  625, 656,
  626, 657,  627, 658,  628, 659,  629, 660,  630, 661,  631, 662,  632, 663,
  633, 664,  634, 665,  635, 666,  636, 667,  637, 668,  638, 669,  639, 670,
  640, 640,  641, 672,  642, 673,  643, 674,  644, 675,  645, 676,  646, 677,
  647, 678,  648, 679,  649, 680,  650, 681,  651, 682,  652, 683,  653, 684,
  654, 685,  655, 686,  656, 687,  657, 688,  658, 689,  659, 690,  660, 691,
  661, 692,  662, 693,  663, 694,  664, 695,  665, 696,  666, 697,  667, 698,
  668, 699,  669, 700,  670, 701,  671, 702,  672, 672,  673, 704,  674, 705,
  675, 706,  676, 707,  677, 708,  678, 709,  679, 710,  680, 711,  681, 712,
  682, 713,  683, 714,  684, 715,  685, 716,  686, 717,  687, 718,  688, 719,
  689, 720,  690, 721,  691, 722,  692, 723,  693, 724,  694, 725,  695, 726,
  696, 727,  697, 728,  698, 729,  699, 730,  700, 731,  701, 732,  702, 733,
  703, 734,  704, 704,  705, 736,  706, 737,  707, 738,  708, 739,  709, 740,
  710, 741,  711, 742,  712, 743,  713, 744,  714, 745,  715, 746,  716, 747,
  717, 748,  718, 749,  719, 750,  720, 751,  721, 752,  722, 753,  723, 754,
  724, 755,  725, 756,  726, 757,  727, 758,  728, 759,  729, 760,  730, 761,
  731, 762,  732, 763,  733, 764,  734, 765,  735, 766,  736, 736,  737, 768,
  738, 769,  739, 770,  740, 771,  741, 772,  742, 773,  743, 774,  744, 775,
  745, 776,  746, 777,  747, 778,  748, 779,  749, 780,  750, 781,  751, 782,
  752, 783,  753, 784,  754, 785,  755, 786,  756, 787,  757, 788,  758, 789,
  759, 790,  760, 791,  761, 792,  762, 793,  763, 794,  764, 795,  765, 796,
  766, 797,  767, 798,  768, 768,  769, 800,  770, 801,  771, 802,  772, 803,
  773, 804,  774, 805,  775, 806,  776, 807,  777, 808,  778, 809,  779, 810,
  780, 811,  781, 812,  782, 813,  783, 814,  784, 815,  785, 816,  786, 817,
  787, 818,  788, 819,  789, 820,  790, 821,  791, 822,  792, 823,  793, 824,
  794, 825,  795, 826,  796, 827,  797, 828,  798, 829,  799, 830,  800, 800,
  801, 832,  802, 833,  803, 834,  804, 835,  805, 836,  806, 837,  807, 838,
  808, 839,  809, 840,  810, 841,  811, 842,  812, 843,  813, 844,  814, 845,
  815, 846,  816, 847,  817, 848,  818, 849,  819, 850,  820, 851,  821, 852,
  822, 853,  823, 854,  824, 855,  825, 856,  826, 857,  827, 858,  828, 859,
  829, 860,  830, 861,  831, 862,  832, 832,  833, 864,  834, 865,  835, 866,
  836, 867,  837, 868,  838, 869,  839, 870,  840, 871,  841, 872,  842, 873,
  843, 874,  844, 875,  845, 876,  846, 877,  847, 878,  848, 879,  849, 880,
  850, 881,  851, 882,  852, 883,  853, 884,  854, 885,  855, 886,  856, 887,
  857, 888,  858, 889,  859, 890,  860, 891,  861, 892,  862, 893,  863, 894,
  864, 864,  865, 896,  866, 897,  867, 898,  868, 899,  869, 900,  870, 901,
  871, 902,  872, 903,  873, 904,  874, 905,  875, 906,  876, 907,  877, 908,
  878, 909,  879, 910,  880, 911,  881, 912,  882, 913,  883, 914,  884, 915,
  885, 916,  886, 917,  887, 918,  888, 919,  889, 920,  890, 921,  891, 922,
  892, 923,  893, 924,  894, 925,  895, 926,  896, 896,  897, 928,  898, 929,
  899, 930,  900, 931,  901, 932,  902, 933,  903, 934,  904, 935,  905, 936,
  906, 937,  907, 938,  908, 939,  909, 940,  910, 941,  911, 942,  912, 943,
  913, 944,  914, 945,  915, 946,  916, 947,  917, 948,  918, 949,  919, 950,
  920, 951,  921, 952,  922, 953,  923, 954,  924, 955,  925, 956,  926, 957,
  927, 958,  928, 928,  929, 960,  930, 961,  931, 962,  932, 963,  933, 964,
  934, 965,  935, 966,  936, 967,  937, 968,  938, 969,  939, 970,  940, 971,
  941, 972,  942, 973,  943, 974,  944, 975,  945, 976,  946, 977,  947, 978,
  948, 979,  949, 980,  950, 981,  951, 982,  952, 983,  953, 984,  954, 985,
  955, 986,  956, 987,  957, 988,  958, 989,  959, 990,  960, 960,  961, 992,
  962, 993,  963, 994,  964, 995,  965, 996,  966, 997,  967, 998,  968, 999,
  969, 1000, 970, 1001, 971, 1002, 972, 1003, 973, 1004, 974, 1005, 975, 1006,
  976, 1007, 977, 1008, 978, 1009, 979, 1010, 980, 1011, 981, 1012, 982, 1013,
  983, 1014, 984, 1015, 985, 1016, 986, 1017, 987, 1018, 988, 1019, 989, 1020,
  990, 1021, 991, 1022, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    0,   0,    32,  32,   1,   32,  1,   1,    2,   2,
  2,   33,   33,  64,   64,  64,   96,  96,   65,  96,  34,  65,   3,   34,
  3,   3,    4,   4,    4,   35,   35,  66,   66,  97,  97,  128,  128, 128,
  160, 160,  129, 160,  98,  129,  67,  98,   36,  67,  5,   36,   5,   5,
  6,   6,    6,   37,   37,  68,   68,  99,   99,  130, 130, 161,  161, 192,
  192, 192,  224, 224,  193, 224,  162, 193,  131, 162, 100, 131,  69,  100,
  38,  69,   7,   38,   7,   7,    8,   8,    8,   39,  39,  70,   70,  101,
  101, 132,  132, 163,  163, 194,  194, 225,  225, 256, 256, 256,  288, 288,
  257, 288,  226, 257,  195, 226,  164, 195,  133, 164, 102, 133,  71,  102,
  40,  71,   9,   40,   9,   9,    10,  10,   10,  41,  41,  72,   72,  103,
  103, 134,  134, 165,  165, 196,  196, 227,  227, 258, 258, 289,  289, 320,
  320, 320,  352, 352,  321, 352,  290, 321,  259, 290, 228, 259,  197, 228,
  166, 197,  135, 166,  104, 135,  73,  104,  42,  73,  11,  42,   11,  11,
  12,  12,   12,  43,   43,  74,   74,  105,  105, 136, 136, 167,  167, 198,
  198, 229,  229, 260,  260, 291,  291, 322,  322, 353, 353, 384,  384, 384,
  416, 416,  385, 416,  354, 385,  323, 354,  292, 323, 261, 292,  230, 261,
  199, 230,  168, 199,  137, 168,  106, 137,  75,  106, 44,  75,   13,  44,
  13,  13,   14,  14,   14,  45,   45,  76,   76,  107, 107, 138,  138, 169,
  169, 200,  200, 231,  231, 262,  262, 293,  293, 324, 324, 355,  355, 386,
  386, 417,  417, 448,  448, 448,  480, 480,  449, 480, 418, 449,  387, 418,
  356, 387,  325, 356,  294, 325,  263, 294,  232, 263, 201, 232,  170, 201,
  139, 170,  108, 139,  77,  108,  46,  77,   15,  46,  15,  15,   16,  16,
  16,  47,   47,  78,   78,  109,  109, 140,  140, 171, 171, 202,  202, 233,
  233, 264,  264, 295,  295, 326,  326, 357,  357, 388, 388, 419,  419, 450,
  450, 481,  481, 512,  512, 512,  544, 544,  513, 544, 482, 513,  451, 482,
  420, 451,  389, 420,  358, 389,  327, 358,  296, 327, 265, 296,  234, 265,
  203, 234,  172, 203,  141, 172,  110, 141,  79,  110, 48,  79,   17,  48,
  17,  17,   18,  18,   18,  49,   49,  80,   80,  111, 111, 142,  142, 173,
  173, 204,  204, 235,  235, 266,  266, 297,  297, 328, 328, 359,  359, 390,
  390, 421,  421, 452,  452, 483,  483, 514,  514, 545, 545, 576,  576, 576,
  608, 608,  577, 608,  546, 577,  515, 546,  484, 515, 453, 484,  422, 453,
  391, 422,  360, 391,  329, 360,  298, 329,  267, 298, 236, 267,  205, 236,
  174, 205,  143, 174,  112, 143,  81,  112,  50,  81,  19,  50,   19,  19,
  20,  20,   20,  51,   51,  82,   82,  113,  113, 144, 144, 175,  175, 206,
  206, 237,  237, 268,  268, 299,  299, 330,  330, 361, 361, 392,  392, 423,
  423, 454,  454, 485,  485, 516,  516, 547,  547, 578, 578, 609,  609, 640,
  640, 640,  672, 672,  641, 672,  610, 641,  579, 610, 548, 579,  517, 548,
  486, 517,  455, 486,  424, 455,  393, 424,  362, 393, 331, 362,  300, 331,
  269, 300,  238, 269,  207, 238,  176, 207,  145, 176, 114, 145,  83,  114,
  52,  83,   21,  52,   21,  21,   22,  22,   22,  53,  53,  84,   84,  115,
  115, 146,  146, 177,  177, 208,  208, 239,  239, 270, 270, 301,  301, 332,
  332, 363,  363, 394,  394, 425,  425, 456,  456, 487, 487, 518,  518, 549,
  549, 580,  580, 611,  611, 642,  642, 673,  673, 704, 704, 704,  736, 736,
  705, 736,  674, 705,  643, 674,  612, 643,  581, 612, 550, 581,  519, 550,
  488, 519,  457, 488,  426, 457,  395, 426,  364, 395, 333, 364,  302, 333,
  271, 302,  240, 271,  209, 240,  178, 209,  147, 178, 116, 147,  85,  116,
  54,  85,   23,  54,   23,  23,   24,  24,   24,  55,  55,  86,   86,  117,
  117, 148,  148, 179,  179, 210,  210, 241,  241, 272, 272, 303,  303, 334,
  334, 365,  365, 396,  396, 427,  427, 458,  458, 489, 489, 520,  520, 551,
  551, 582,  582, 613,  613, 644,  644, 675,  675, 706, 706, 737,  737, 768,
  768, 768,  800, 800,  769, 800,  738, 769,  707, 738, 676, 707,  645, 676,
  614, 645,  583, 614,  552, 583,  521, 552,  490, 521, 459, 490,  428, 459,
  397, 428,  366, 397,  335, 366,  304, 335,  273, 304, 242, 273,  211, 242,
  180, 211,  149, 180,  118, 149,  87,  118,  56,  87,  25,  56,   25,  25,
  26,  26,   26,  57,   57,  88,   88,  119,  119, 150, 150, 181,  181, 212,
  212, 243,  243, 274,  274, 305,  305, 336,  336, 367, 367, 398,  398, 429,
  429, 460,  460, 491,  491, 522,  522, 553,  553, 584, 584, 615,  615, 646,
  646, 677,  677, 708,  708, 739,  739, 770,  770, 801, 801, 832,  832, 832,
  864, 864,  833, 864,  802, 833,  771, 802,  740, 771, 709, 740,  678, 709,
  647, 678,  616, 647,  585, 616,  554, 585,  523, 554, 492, 523,  461, 492,
  430, 461,  399, 430,  368, 399,  337, 368,  306, 337, 275, 306,  244, 275,
  213, 244,  182, 213,  151, 182,  120, 151,  89,  120, 58,  89,   27,  58,
  27,  27,   28,  28,   28,  59,   59,  90,   90,  121, 121, 152,  152, 183,
  183, 214,  214, 245,  245, 276,  276, 307,  307, 338, 338, 369,  369, 400,
  400, 431,  431, 462,  462, 493,  493, 524,  524, 555, 555, 586,  586, 617,
  617, 648,  648, 679,  679, 710,  710, 741,  741, 772, 772, 803,  803, 834,
  834, 865,  865, 896,  896, 896,  928, 928,  897, 928, 866, 897,  835, 866,
  804, 835,  773, 804,  742, 773,  711, 742,  680, 711, 649, 680,  618, 649,
  587, 618,  556, 587,  525, 556,  494, 525,  463, 494, 432, 463,  401, 432,
  370, 401,  339, 370,  308, 339,  277, 308,  246, 277, 215, 246,  184, 215,
  153, 184,  122, 153,  91,  122,  60,  91,   29,  60,  29,  29,   30,  30,
  30,  61,   61,  92,   92,  123,  123, 154,  154, 185, 185, 216,  216, 247,
  247, 278,  278, 309,  309, 340,  340, 371,  371, 402, 402, 433,  433, 464,
  464, 495,  495, 526,  526, 557,  557, 588,  588, 619, 619, 650,  650, 681,
  681, 712,  712, 743,  743, 774,  774, 805,  805, 836, 836, 867,  867, 898,
  898, 929,  929, 960,  960, 960,  961, 992,  930, 961, 899, 930,  868, 899,
  837, 868,  806, 837,  775, 806,  744, 775,  713, 744, 682, 713,  651, 682,
  620, 651,  589, 620,  558, 589,  527, 558,  496, 527, 465, 496,  434, 465,
  403, 434,  372, 403,  341, 372,  310, 341,  279, 310, 248, 279,  217, 248,
  186, 217,  155, 186,  124, 155,  93,  124,  62,  93,  31,  62,   63,  94,
  94,  125,  125, 156,  156, 187,  187, 218,  218, 249, 249, 280,  280, 311,
  311, 342,  342, 373,  373, 404,  404, 435,  435, 466, 466, 497,  497, 528,
  528, 559,  559, 590,  590, 621,  621, 652,  652, 683, 683, 714,  714, 745,
  745, 776,  776, 807,  807, 838,  838, 869,  869, 900, 900, 931,  931, 962,
  962, 993,  963, 994,  932, 963,  901, 932,  870, 901, 839, 870,  808, 839,
  777, 808,  746, 777,  715, 746,  684, 715,  653, 684, 622, 653,  591, 622,
  560, 591,  529, 560,  498, 529,  467, 498,  436, 467, 405, 436,  374, 405,
  343, 374,  312, 343,  281, 312,  250, 281,  219, 250, 188, 219,  157, 188,
  126, 157,  95,  126,  127, 158,  158, 189,  189, 220, 220, 251,  251, 282,
  282, 313,  313, 344,  344, 375,  375, 406,  406, 437, 437, 468,  468, 499,
  499, 530,  530, 561,  561, 592,  592, 623,  623, 654, 654, 685,  685, 716,
  716, 747,  747, 778,  778, 809,  809, 840,  840, 871, 871, 902,  902, 933,
  933, 964,  964, 995,  965, 996,  934, 965,  903, 934, 872, 903,  841, 872,
  810, 841,  779, 810,  748, 779,  717, 748,  686, 717, 655, 686,  624, 655,
  593, 624,  562, 593,  531, 562,  500, 531,  469, 500, 438, 469,  407, 438,
  376, 407,  345, 376,  314, 345,  283, 314,  252, 283, 221, 252,  190, 221,
  159, 190,  191, 222,  222, 253,  253, 284,  284, 315, 315, 346,  346, 377,
  377, 408,  408, 439,  439, 470,  470, 501,  501, 532, 532, 563,  563, 594,
  594, 625,  625, 656,  656, 687,  687, 718,  718, 749, 749, 780,  780, 811,
  811, 842,  842, 873,  873, 904,  904, 935,  935, 966, 966, 997,  967, 998,
  936, 967,  905, 936,  874, 905,  843, 874,  812, 843, 781, 812,  750, 781,
  719, 750,  688, 719,  657, 688,  626, 657,  595, 626, 564, 595,  533, 564,
  502, 533,  471, 502,  440, 471,  409, 440,  378, 409, 347, 378,  316, 347,
  285, 316,  254, 285,  223, 254,  255, 286,  286, 317, 317, 348,  348, 379,
  379, 410,  410, 441,  441, 472,  472, 503,  503, 534, 534, 565,  565, 596,
  596, 627,  627, 658,  658, 689,  689, 720,  720, 751, 751, 782,  782, 813,
  813, 844,  844, 875,  875, 906,  906, 937,  937, 968, 968, 999,  969, 1000,
  938, 969,  907, 938,  876, 907,  845, 876,  814, 845, 783, 814,  752, 783,
  721, 752,  690, 721,  659, 690,  628, 659,  597, 628, 566, 597,  535, 566,
  504, 535,  473, 504,  442, 473,  411, 442,  380, 411, 349, 380,  318, 349,
  287, 318,  319, 350,  350, 381,  381, 412,  412, 443, 443, 474,  474, 505,
  505, 536,  536, 567,  567, 598,  598, 629,  629, 660, 660, 691,  691, 722,
  722, 753,  753, 784,  784, 815,  815, 846,  846, 877, 877, 908,  908, 939,
  939, 970,  970, 1001, 971, 1002, 940, 971,  909, 940, 878, 909,  847, 878,
  816, 847,  785, 816,  754, 785,  723, 754,  692, 723, 661, 692,  630, 661,
  599, 630,  568, 599,  537, 568,  506, 537,  475, 506, 444, 475,  413, 444,
  382, 413,  351, 382,  383, 414,  414, 445,  445, 476, 476, 507,  507, 538,
  538, 569,  569, 600,  600, 631,  631, 662,  662, 693, 693, 724,  724, 755,
  755, 786,  786, 817,  817, 848,  848, 879,  879, 910, 910, 941,  941, 972,
  972, 1003, 973, 1004, 942, 973,  911, 942,  880, 911, 849, 880,  818, 849,
  787, 818,  756, 787,  725, 756,  694, 725,  663, 694, 632, 663,  601, 632,
  570, 601,  539, 570,  508, 539,  477, 508,  446, 477, 415, 446,  447, 478,
  478, 509,  509, 540,  540, 571,  571, 602,  602, 633, 633, 664,  664, 695,
  695, 726,  726, 757,  757, 788,  788, 819,  819, 850, 850, 881,  881, 912,
  912, 943,  943, 974,  974, 1005, 975, 1006, 944, 975, 913, 944,  882, 913,
  851, 882,  820, 851,  789, 820,  758, 789,  727, 758, 696, 727,  665, 696,
  634, 665,  603, 634,  572, 603,  541, 572,  510, 541, 479, 510,  511, 542,
  542, 573,  573, 604,  604, 635,  635, 666,  666, 697, 697, 728,  728, 759,
  759, 790,  790, 821,  821, 852,  852, 883,  883, 914, 914, 945,  945, 976,
  976, 1007, 977, 1008, 946, 977,  915, 946,  884, 915, 853, 884,  822, 853,
  791, 822,  760, 791,  729, 760,  698, 729,  667, 698, 636, 667,  605, 636,
  574, 605,  543, 574,  575, 606,  606, 637,  637, 668, 668, 699,  699, 730,
  730, 761,  761, 792,  792, 823,  823, 854,  854, 885, 885, 916,  916, 947,
  947, 978,  978, 1009, 979, 1010, 948, 979,  917, 948, 886, 917,  855, 886,
  824, 855,  793, 824,  762, 793,  731, 762,  700, 731, 669, 700,  638, 669,
  607, 638,  639, 670,  670, 701,  701, 732,  732, 763, 763, 794,  794, 825,
  825, 856,  856, 887,  887, 918,  918, 949,  949, 980, 980, 1011, 981, 1012,
  950, 981,  919, 950,  888, 919,  857, 888,  826, 857, 795, 826,  764, 795,
  733, 764,  702, 733,  671, 702,  703, 734,  734, 765, 765, 796,  796, 827,
  827, 858,  858, 889,  889, 920,  920, 951,  951, 982, 982, 1013, 983, 1014,
  952, 983,  921, 952,  890, 921,  859, 890,  828, 859, 797, 828,  766, 797,
  735, 766,  767, 798,  798, 829,  829, 860,  860, 891, 891, 922,  922, 953,
  953, 984,  984, 1015, 985, 1016, 954, 985,  923, 954, 892, 923,  861, 892,
  830, 861,  799, 830,  831, 862,  862, 893,  893, 924, 924, 955,  955, 986,
  986, 1017, 987, 1018, 956, 987,  925, 956,  894, 925, 863, 894,  895, 926,
  926, 957,  957, 988,  988, 1019, 989, 1020, 958, 989, 927, 958,  959, 990,
  990, 1021, 991, 1022, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x4[16]) = {
  0, 1, 5, 6, 2, 4, 7, 12, 3, 8, 11, 13, 9, 10, 14, 15
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x4[16]) = {
  0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x4[16]) = {
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x8[32]) = {
  0,  1,  3,  6,  2,  4,  7,  10, 5,  8,  11, 14, 9,  12, 15, 18,
  13, 16, 19, 22, 17, 20, 23, 26, 21, 24, 27, 29, 25, 28, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x8[32]) = {
  0, 8,  16, 24, 1, 9,  17, 25, 2, 10, 18, 26, 3, 11, 19, 27,
  4, 12, 20, 28, 5, 13, 21, 29, 6, 14, 22, 30, 7, 15, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x8[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x4[32]) = {
  0, 2, 5,  9,  13, 17, 21, 25, 1, 4,  8,  12, 16, 20, 24, 28,
  3, 7, 11, 15, 19, 23, 27, 30, 6, 10, 14, 18, 22, 26, 29, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x4[32]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 1, 5, 9,  13, 17, 21, 25, 29,
  2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x4[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x16[64]) = {
  0,  1,  3,  6,  2,  4,  7,  10, 5,  8,  11, 14, 9,  12, 15, 18,
  13, 16, 19, 22, 17, 20, 23, 26, 21, 24, 27, 30, 25, 28, 31, 34,
  29, 32, 35, 38, 33, 36, 39, 42, 37, 40, 43, 46, 41, 44, 47, 50,
  45, 48, 51, 54, 49, 52, 55, 58, 53, 56, 59, 61, 57, 60, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x4[64]) = {
  0, 2,  5,  9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57,
  1, 4,  8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  3, 7,  11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 62,
  6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 61, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x16[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x4[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x16[64]) = {
  0,  16, 32, 48, 1,  17, 33, 49, 2,  18, 34, 50, 3,  19, 35, 51,
  4,  20, 36, 52, 5,  21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x4[64]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  1, 5, 9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x32[256]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  2,   4,   7,   11,  16,  22,  29,
  36,  5,   8,   12,  17,  23,  30,  37,  44,  9,   13,  18,  24,  31,  38,
  45,  52,  14,  19,  25,  32,  39,  46,  53,  60,  20,  26,  33,  40,  47,
  54,  61,  68,  27,  34,  41,  48,  55,  62,  69,  76,  35,  42,  49,  56,
  63,  70,  77,  84,  43,  50,  57,  64,  71,  78,  85,  92,  51,  58,  65,
  72,  79,  86,  93,  100, 59,  66,  73,  80,  87,  94,  101, 108, 67,  74,
  81,  88,  95,  102, 109, 116, 75,  82,  89,  96,  103, 110, 117, 124, 83,
  90,  97,  104, 111, 118, 125, 132, 91,  98,  105, 112, 119, 126, 133, 140,
  99,  106, 113, 120, 127, 134, 141, 148, 107, 114, 121, 128, 135, 142, 149,
  156, 115, 122, 129, 136, 143, 150, 157, 164, 123, 130, 137, 144, 151, 158,
  165, 172, 131, 138, 145, 152, 159, 166, 173, 180, 139, 146, 153, 160, 167,
  174, 181, 188, 147, 154, 161, 168, 175, 182, 189, 196, 155, 162, 169, 176,
  183, 190, 197, 204, 163, 170, 177, 184, 191, 198, 205, 212, 171, 178, 185,
  192, 199, 206, 213, 220, 179, 186, 193, 200, 207, 214, 221, 228, 187, 194,
  201, 208, 215, 222, 229, 235, 195, 202, 209, 216, 223, 230, 236, 241, 203,
  210, 217, 224, 231, 237, 242, 246, 211, 218, 225, 232, 238, 243, 247, 250,
  219, 226, 233, 239, 244, 248, 251, 253, 227, 234, 240, 245, 249, 252, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x8[256]) = {
  0,   2,   5,   9,   14,  20,  27,  35,  43,  51,  59,  67,  75,  83,  91,
  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187, 195, 203, 211,
  219, 227, 1,   4,   8,   13,  19,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 3,   7,   12,  18,  25,  33,  41,  49,  57,  65,  73,
  81,  89,  97,  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193,
  201, 209, 217, 225, 233, 240, 6,   11,  17,  24,  32,  40,  48,  56,  64,
  72,  80,  88,  96,  104, 112, 120, 128, 136, 144, 152, 160, 168, 176, 184,
  192, 200, 208, 216, 224, 232, 239, 245, 10,  16,  23,  31,  39,  47,  55,
  63,  71,  79,  87,  95,  103, 111, 119, 127, 135, 143, 151, 159, 167, 175,
  183, 191, 199, 207, 215, 223, 231, 238, 244, 249, 15,  22,  30,  38,  46,
  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142, 150, 158, 166,
  174, 182, 190, 198, 206, 214, 222, 230, 237, 243, 248, 252, 21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 236, 242, 247, 251, 254, 28,
  36,  44,  52,  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148,
  156, 164, 172, 180, 188, 196, 204, 212, 220, 228, 235, 241, 246, 250, 253,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x32[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x8[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x32[256]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 1,  33, 65, 97,  129, 161, 193, 225,
  2,  34, 66, 98,  130, 162, 194, 226, 3,  35, 67, 99,  131, 163, 195, 227,
  4,  36, 68, 100, 132, 164, 196, 228, 5,  37, 69, 101, 133, 165, 197, 229,
  6,  38, 70, 102, 134, 166, 198, 230, 7,  39, 71, 103, 135, 167, 199, 231,
  8,  40, 72, 104, 136, 168, 200, 232, 9,  41, 73, 105, 137, 169, 201, 233,
  10, 42, 74, 106, 138, 170, 202, 234, 11, 43, 75, 107, 139, 171, 203, 235,
  12, 44, 76, 108, 140, 172, 204, 236, 13, 45, 77, 109, 141, 173, 205, 237,
  14, 46, 78, 110, 142, 174, 206, 238, 15, 47, 79, 111, 143, 175, 207, 239,
  16, 48, 80, 112, 144, 176, 208, 240, 17, 49, 81, 113, 145, 177, 209, 241,
  18, 50, 82, 114, 146, 178, 210, 242, 19, 51, 83, 115, 147, 179, 211, 243,
  20, 52, 84, 116, 148, 180, 212, 244, 21, 53, 85, 117, 149, 181, 213, 245,
  22, 54, 86, 118, 150, 182, 214, 246, 23, 55, 87, 119, 151, 183, 215, 247,
  24, 56, 88, 120, 152, 184, 216, 248, 25, 57, 89, 121, 153, 185, 217, 249,
  26, 58, 90, 122, 154, 186, 218, 250, 27, 59, 91, 123, 155, 187, 219, 251,
  28, 60, 92, 124, 156, 188, 220, 252, 29, 61, 93, 125, 157, 189, 221, 253,
  30, 62, 94, 126, 158, 190, 222, 254, 31, 63, 95, 127, 159, 191, 223, 255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x8[256]) = {
  0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96,  104, 112,
  120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232,
  240, 248, 1,   9,   17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  97,
  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193, 201, 209, 217,
  225, 233, 241, 249, 2,   10,  18,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 242, 250, 3,   11,  19,  27,  35,  43,  51,  59,  67,
  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187,
  195, 203, 211, 219, 227, 235, 243, 251, 4,   12,  20,  28,  36,  44,  52,
  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172,
  180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 5,   13,  21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 237, 245, 253, 6,   14,  22,
  30,  38,  46,  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142,
  150, 158, 166, 174, 182, 190, 198, 206, 214, 222, 230, 238, 246, 254, 7,
  15,  23,  31,  39,  47,  55,  63,  71,  79,  87,  95,  103, 111, 119, 127,
  135, 143, 151, 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 239, 247,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x8[64]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 1, 9,  17, 25, 33, 41, 49, 57,
  2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
  4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
  6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x8[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x8[64]) = {
  0,  1,  5,  6,  14, 15, 27, 28, 2,  4,  7,  13, 16, 26, 29, 42,
  3,  8,  12, 17, 25, 30, 41, 43, 9,  11, 18, 24, 31, 40, 44, 53,
  10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60,
  21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x16[128]) = {
  0,  1,  3,   6,   10,  15,  21,  28,  2,  4,   7,   11,  16,  22,  29,  36,
  5,  8,  12,  17,  23,  30,  37,  44,  9,  13,  18,  24,  31,  38,  45,  52,
  14, 19, 25,  32,  39,  46,  53,  60,  20, 26,  33,  40,  47,  54,  61,  68,
  27, 34, 41,  48,  55,  62,  69,  76,  35, 42,  49,  56,  63,  70,  77,  84,
  43, 50, 57,  64,  71,  78,  85,  92,  51, 58,  65,  72,  79,  86,  93,  100,
  59, 66, 73,  80,  87,  94,  101, 107, 67, 74,  81,  88,  95,  102, 108, 113,
  75, 82, 89,  96,  103, 109, 114, 118, 83, 90,  97,  104, 110, 115, 119, 122,
  91, 98, 105, 111, 116, 120, 123, 125, 99, 106, 112, 117, 121, 124, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x8[128]) = {
  0,  2,  5,  9,  14, 20, 27, 35, 43, 51,  59,  67,  75,  83,  91,  99,
  1,  4,  8,  13, 19, 26, 34, 42, 50, 58,  66,  74,  82,  90,  98,  106,
  3,  7,  12, 18, 25, 33, 41, 49, 57, 65,  73,  81,  89,  97,  105, 112,
  6,  11, 17, 24, 32, 40, 48, 56, 64, 72,  80,  88,  96,  104, 111, 117,
  10, 16, 23, 31, 39, 47, 55, 63, 71, 79,  87,  95,  103, 110, 116, 121,
  15, 22, 30, 38, 46, 54, 62, 70, 78, 86,  94,  102, 109, 115, 120, 124,
  21, 29, 37, 45, 53, 61, 69, 77, 85, 93,  101, 108, 114, 119, 123, 126,
  28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 107, 113, 118, 122, 125, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x16[128]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 1,  17, 33, 49, 65, 81, 97,  113,
  2,  18, 34, 50, 66, 82, 98,  114, 3,  19, 35, 51, 67, 83, 99,  115,
  4,  20, 36, 52, 68, 84, 100, 116, 5,  21, 37, 53, 69, 85, 101, 117,
  6,  22, 38, 54, 70, 86, 102, 118, 7,  23, 39, 55, 71, 87, 103, 119,
  8,  24, 40, 56, 72, 88, 104, 120, 9,  25, 41, 57, 73, 89, 105, 121,
  10, 26, 42, 58, 74, 90, 106, 122, 11, 27, 43, 59, 75, 91, 107, 123,
  12, 28, 44, 60, 76, 92, 108, 124, 13, 29, 45, 61, 77, 93, 109, 125,
  14, 30, 46, 62, 78, 94, 110, 126, 15, 31, 47, 63, 79, 95, 111, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x8[128]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96,  104, 112, 120,
  1, 9,  17, 25, 33, 41, 49, 57, 65, 73, 81, 89, 97,  105, 113, 121,
  2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98,  106, 114, 122,
  3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 99,  107, 115, 123,
  4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 108, 116, 124,
  5, 13, 21, 29, 37, 45, 53, 61, 69, 77, 85, 93, 101, 109, 117, 125,
  6, 14, 22, 30, 38, 46, 54, 62, 70, 78, 86, 94, 102, 110, 118, 126,
  7, 15, 23, 31, 39, 47, 55, 63, 71, 79, 87, 95, 103, 111, 119, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x16[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x8[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x32[512]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  36,  45,  55,  66,  78,  91,  105,
  120, 2,   4,   7,   11,  16,  22,  29,  37,  46,  56,  67,  79,  92,  106,
  121, 136, 5,   8,   12,  17,  23,  30,  38,  47,  57,  68,  80,  93,  107,
  122, 137, 152, 9,   13,  18,  24,  31,  39,  48,  58,  69,  81,  94,  108,
  123, 138, 153, 168, 14,  19,  25,  32,  40,  49,  59,  70,  82,  95,  109,
  124, 139, 154, 169, 184, 20,  26,  33,  41,  50,  60,  71,  83,  96,  110,
  125, 140, 155, 170, 185, 200, 27,  34,  42,  51,  61,  72,  84,  97,  111,
  126, 141, 156, 171, 186, 201, 216, 35,  43,  52,  62,  73,  85,  98,  112,
  127, 142, 157, 172, 187, 202, 217, 232, 44,  53,  63,  74,  86,  99,  113,
  128, 143, 158, 173, 188, 203, 218, 233, 248, 54,  64,  75,  87,  100, 114,
  129, 144, 159, 174, 189, 204, 219, 234, 249, 264, 65,  76,  88,  101, 115,
  130, 145, 160, 175, 190, 205, 220, 235, 250, 265, 280, 77,  89,  102, 116,
  131, 146, 161, 176, 191, 206, 221, 236, 251, 266, 281, 296, 90,  103, 117,
  132, 147, 162, 177, 192, 207, 222, 237, 252, 267, 282, 297, 312, 104, 118,
  133, 148, 163, 178, 193, 208, 223, 238, 253, 268, 283, 298, 313, 328, 119,
  134, 149, 164, 179, 194, 209, 224, 239, 254, 269, 284, 299, 314, 329, 344,
  135, 150, 165, 180, 195, 210, 225, 240, 255, 270, 285, 300, 315, 330, 345,
  360, 151, 166, 181, 196, 211, 226, 241, 256, 271, 286, 301, 316, 331, 346,
  361, 376, 167, 182, 197, 212, 227, 242, 257, 272, 287, 302, 317, 332, 347,
  362, 377, 392, 183, 198, 213, 228, 243, 258, 273, 288, 303, 318, 333, 348,
  363, 378, 393, 407, 199, 214, 229, 244, 259, 274, 289, 304, 319, 334, 349,
  364, 379, 394, 408, 421, 215, 230, 245, 260, 275, 290, 305, 320, 335, 350,
  365, 380, 395, 409, 422, 434, 231, 246, 261, 276, 291, 306, 321, 336, 351,
  366, 381, 396, 410, 423, 435, 446, 247, 262, 277, 292, 307, 322, 337, 352,
  367, 382, 397, 411, 424, 436, 447, 457, 263, 278, 293, 308, 323, 338, 353,
  368, 383, 398, 412, 425, 437, 448, 458, 467, 279, 294, 309, 324, 339, 354,
  369, 384, 399, 413, 426, 438, 449, 459, 468, 476, 295, 310, 325, 340, 355,
  370, 385, 400, 414, 427, 439, 450, 460, 469, 477, 484, 311, 326, 341, 356,
  371, 386, 401, 415, 428, 440, 451, 461, 470, 478, 485, 491, 327, 342, 357,
  372, 387, 402, 416, 429, 441, 452, 462, 471, 479, 486, 492, 497, 343, 358,
  373, 388, 403, 417, 430, 442, 453, 463, 472, 480, 487, 493, 498, 502, 359,
  374, 389, 404, 418, 431, 443, 454, 464, 473, 481, 488, 494, 499, 503, 506,
  375, 390, 405, 419, 432, 444, 455, 465, 474, 482, 489, 495, 500, 504, 507,
  509, 391, 406, 420, 433, 445, 456, 466, 475, 483, 490, 496, 501, 505, 508,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x16[512]) = {
  0,   2,   5,   9,   14,  20,  27,  35,  44,  54,  65,  77,  90,  104, 119,
  135, 151, 167, 183, 199, 215, 231, 247, 263, 279, 295, 311, 327, 343, 359,
  375, 391, 1,   4,   8,   13,  19,  26,  34,  43,  53,  64,  76,  89,  103,
  118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278, 294, 310, 326, 342,
  358, 374, 390, 406, 3,   7,   12,  18,  25,  33,  42,  52,  63,  75,  88,
  102, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309, 325,
  341, 357, 373, 389, 405, 420, 6,   11,  17,  24,  32,  41,  51,  62,  74,
  87,  101, 116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308,
  324, 340, 356, 372, 388, 404, 419, 433, 10,  16,  23,  31,  40,  50,  61,
  73,  86,  100, 115, 131, 147, 163, 179, 195, 211, 227, 243, 259, 275, 291,
  307, 323, 339, 355, 371, 387, 403, 418, 432, 445, 15,  22,  30,  39,  49,
  60,  72,  85,  99,  114, 130, 146, 162, 178, 194, 210, 226, 242, 258, 274,
  290, 306, 322, 338, 354, 370, 386, 402, 417, 431, 444, 456, 21,  29,  38,
  48,  59,  71,  84,  98,  113, 129, 145, 161, 177, 193, 209, 225, 241, 257,
  273, 289, 305, 321, 337, 353, 369, 385, 401, 416, 430, 443, 455, 466, 28,
  37,  47,  58,  70,  83,  97,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 415, 429, 442, 454, 465,
  475, 36,  46,  57,  69,  82,  96,  111, 127, 143, 159, 175, 191, 207, 223,
  239, 255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 414, 428, 441, 453,
  464, 474, 483, 45,  56,  68,  81,  95,  110, 126, 142, 158, 174, 190, 206,
  222, 238, 254, 270, 286, 302, 318, 334, 350, 366, 382, 398, 413, 427, 440,
  452, 463, 473, 482, 490, 55,  67,  80,  94,  109, 125, 141, 157, 173, 189,
  205, 221, 237, 253, 269, 285, 301, 317, 333, 349, 365, 381, 397, 412, 426,
  439, 451, 462, 472, 481, 489, 496, 66,  79,  93,  108, 124, 140, 156, 172,
  188, 204, 220, 236, 252, 268, 284, 300, 316, 332, 348, 364, 380, 396, 411,
  425, 438, 450, 461, 471, 480, 488, 495, 501, 78,  92,  107, 123, 139, 155,
  171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363, 379, 395,
  410, 424, 437, 449, 460, 470, 479, 487, 494, 500, 505, 91,  106, 122, 138,
  154, 170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378,
  394, 409, 423, 436, 448, 459, 469, 478, 486, 493, 499, 504, 508, 105, 121,
  137, 153, 169, 185, 201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361,
  377, 393, 408, 422, 435, 447, 458, 468, 477, 485, 492, 498, 503, 507, 510,
  120, 136, 152, 168, 184, 200, 216, 232, 248, 264, 280, 296, 312, 328, 344,
  360, 376, 392, 407, 421, 434, 446, 457, 467, 476, 484, 491, 497, 502, 506,
  509, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x32[512]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480,
  1,  33, 65, 97,  129, 161, 193, 225, 257, 289, 321, 353, 385, 417, 449, 481,
  2,  34, 66, 98,  130, 162, 194, 226, 258, 290, 322, 354, 386, 418, 450, 482,
  3,  35, 67, 99,  131, 163, 195, 227, 259, 291, 323, 355, 387, 419, 451, 483,
  4,  36, 68, 100, 132, 164, 196, 228, 260, 292, 324, 356, 388, 420, 452, 484,
  5,  37, 69, 101, 133, 165, 197, 229, 261, 293, 325, 357, 389, 421, 453, 485,
  6,  38, 70, 102, 134, 166, 198, 230, 262, 294, 326, 358, 390, 422, 454, 486,
  7,  39, 71, 103, 135, 167, 199, 231, 263, 295, 327, 359, 391, 423, 455, 487,
  8,  40, 72, 104, 136, 168, 200, 232, 264, 296, 328, 360, 392, 424, 456, 488,
  9,  41, 73, 105, 137, 169, 201, 233, 265, 297, 329, 361, 393, 425, 457, 489,
  10, 42, 74, 106, 138, 170, 202, 234, 266, 298, 330, 362, 394, 426, 458, 490,
  11, 43, 75, 107, 139, 171, 203, 235, 267, 299, 331, 363, 395, 427, 459, 491,
  12, 44, 76, 108, 140, 172, 204, 236, 268, 300, 332, 364, 396, 428, 460, 492,
  13, 45, 77, 109, 141, 173, 205, 237, 269, 301, 333, 365, 397, 429, 461, 493,
  14, 46, 78, 110, 142, 174, 206, 238, 270, 302, 334, 366, 398, 430, 462, 494,
  15, 47, 79, 111, 143, 175, 207, 239, 271, 303, 335, 367, 399, 431, 463, 495,
  16, 48, 80, 112, 144, 176, 208, 240, 272, 304, 336, 368, 400, 432, 464, 496,
  17, 49, 81, 113, 145, 177, 209, 241, 273, 305, 337, 369, 401, 433, 465, 497,
  18, 50, 82, 114, 146, 178, 210, 242, 274, 306, 338, 370, 402, 434, 466, 498,
  19, 51, 83, 115, 147, 179, 211, 243, 275, 307, 339, 371, 403, 435, 467, 499,
  20, 52, 84, 116, 148, 180, 212, 244, 276, 308, 340, 372, 404, 436, 468, 500,
  21, 53, 85, 117, 149, 181, 213, 245, 277, 309, 341, 373, 405, 437, 469, 501,
  22, 54, 86, 118, 150, 182, 214, 246, 278, 310, 342, 374, 406, 438, 470, 502,
  23, 55, 87, 119, 151, 183, 215, 247, 279, 311, 343, 375, 407, 439, 471, 503,
  24, 56, 88, 120, 152, 184, 216, 248, 280, 312, 344, 376, 408, 440, 472, 504,
  25, 57, 89, 121, 153, 185, 217, 249, 281, 313, 345, 377, 409, 441, 473, 505,
  26, 58, 90, 122, 154, 186, 218, 250, 282, 314, 346, 378, 410, 442, 474, 506,
  27, 59, 91, 123, 155, 187, 219, 251, 283, 315, 347, 379, 411, 443, 475, 507,
  28, 60, 92, 124, 156, 188, 220, 252, 284, 316, 348, 380, 412, 444, 476, 508,
  29, 61, 93, 125, 157, 189, 221, 253, 285, 317, 349, 381, 413, 445, 477, 509,
  30, 62, 94, 126, 158, 190, 222, 254, 286, 318, 350, 382, 414, 446, 478, 510,
  31, 63, 95, 127, 159, 191, 223, 255, 287, 319, 351, 383, 415, 447, 479, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x16[512]) = {
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464,
  480, 496, 1,   17,  33,  49,  65,  81,  97,  113, 129, 145, 161, 177, 193,
  209, 225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433,
  449, 465, 481, 497, 2,   18,  34,  50,  66,  82,  98,  114, 130, 146, 162,
  178, 194, 210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 402,
  418, 434, 450, 466, 482, 498, 3,   19,  35,  51,  67,  83,  99,  115, 131,
  147, 163, 179, 195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371,
  387, 403, 419, 435, 451, 467, 483, 499, 4,   20,  36,  52,  68,  84,  100,
  116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340,
  356, 372, 388, 404, 420, 436, 452, 468, 484, 500, 5,   21,  37,  53,  69,
  85,  101, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309,
  325, 341, 357, 373, 389, 405, 421, 437, 453, 469, 485, 501, 6,   22,  38,
  54,  70,  86,  102, 118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278,
  294, 310, 326, 342, 358, 374, 390, 406, 422, 438, 454, 470, 486, 502, 7,
  23,  39,  55,  71,  87,  103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  263, 279, 295, 311, 327, 343, 359, 375, 391, 407, 423, 439, 455, 471, 487,
  503, 8,   24,  40,  56,  72,  88,  104, 120, 136, 152, 168, 184, 200, 216,
  232, 248, 264, 280, 296, 312, 328, 344, 360, 376, 392, 408, 424, 440, 456,
  472, 488, 504, 9,   25,  41,  57,  73,  89,  105, 121, 137, 153, 169, 185,
  201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361, 377, 393, 409, 425,
  441, 457, 473, 489, 505, 10,  26,  42,  58,  74,  90,  106, 122, 138, 154,
  170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378, 394,
  410, 426, 442, 458, 474, 490, 506, 11,  27,  43,  59,  75,  91,  107, 123,
  139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363,
  379, 395, 411, 427, 443, 459, 475, 491, 507, 12,  28,  44,  60,  76,  92,
  108, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284, 300, 316, 332,
  348, 364, 380, 396, 412, 428, 444, 460, 476, 492, 508, 13,  29,  45,  61,
  77,  93,  109, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269, 285, 301,
  317, 333, 349, 365, 381, 397, 413, 429, 445, 461, 477, 493, 509, 14,  30,
  46,  62,  78,  94,  110, 126, 142, 158, 174, 190, 206, 222, 238, 254, 270,
  286, 302, 318, 334, 350, 366, 382, 398, 414, 430, 446, 462, 478, 494, 510,
  15,  31,  47,  63,  79,  95,  111, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479,
  495, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x32[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x16[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x16[256]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  1,  17, 33, 49, 65, 81, 97,  113, 129, 145, 161, 177, 193, 209, 225, 241,
  2,  18, 34, 50, 66, 82, 98,  114, 130, 146, 162, 178, 194, 210, 226, 242,
  3,  19, 35, 51, 67, 83, 99,  115, 131, 147, 163, 179, 195, 211, 227, 243,
  4,  20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244,
  5,  21, 37, 53, 69, 85, 101, 117, 133, 149, 165, 181, 197, 213, 229, 245,
  6,  22, 38, 54, 70, 86, 102, 118, 134, 150, 166, 182, 198, 214, 230, 246,
  7,  23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  8,  24, 40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232, 248,
  9,  25, 41, 57, 73, 89, 105, 121, 137, 153, 169, 185, 201, 217, 233, 249,
  10, 26, 42, 58, 74, 90, 106, 122, 138, 154, 170, 186, 202, 218, 234, 250,
  11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251,
  12, 28, 44, 60, 76, 92, 108, 124, 140, 156, 172, 188, 204, 220, 236, 252,
  13, 29, 45, 61, 77, 93, 109, 125, 141, 157, 173, 189, 205, 221, 237, 253,
  14, 30, 46, 62, 78, 94, 110, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x16[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x16[256]) = {
  0,   1,   5,   6,   14,  15,  27,  28,  44,  45,  65,  66,  90,  91,  119,
  120, 2,   4,   7,   13,  16,  26,  29,  43,  46,  64,  67,  89,  92,  118,
  121, 150, 3,   8,   12,  17,  25,  30,  42,  47,  63,  68,  88,  93,  117,
  122, 149, 151, 9,   11,  18,  24,  31,  41,  48,  62,  69,  87,  94,  116,
  123, 148, 152, 177, 10,  19,  23,  32,  40,  49,  61,  70,  86,  95,  115,
  124, 147, 153, 176, 178, 20,  22,  33,  39,  50,  60,  71,  85,  96,  114,
  125, 146, 154, 175, 179, 200, 21,  34,  38,  51,  59,  72,  84,  97,  113,
  126, 145, 155, 174, 180, 199, 201, 35,  37,  52,  58,  73,  83,  98,  112,
  127, 144, 156, 173, 181, 198, 202, 219, 36,  53,  57,  74,  82,  99,  111,
  128, 143, 157, 172, 182, 197, 203, 218, 220, 54,  56,  75,  81,  100, 110,
  129, 142, 158, 171, 183, 196, 204, 217, 221, 234, 55,  76,  80,  101, 109,
  130, 141, 159, 170, 184, 195, 205, 216, 222, 233, 235, 77,  79,  102, 108,
  131, 140, 160, 169, 185, 194, 206, 215, 223, 232, 236, 245, 78,  103, 107,
  132, 139, 161, 168, 186, 193, 207, 214, 224, 231, 237, 244, 246, 104, 106,
  133, 138, 162, 167, 187, 192, 208, 213, 225, 230, 238, 243, 247, 252, 105,
  134, 137, 163, 166, 188, 191, 209, 212, 226, 229, 239, 242, 248, 251, 253,
  135, 136, 164, 165, 189, 190, 210, 211, 227, 228, 240, 241, 249, 250, 254,
  255
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x32[1024]) = {
  0,   32,   64,  96,   128, 160,  192, 224,  256, 288,  320, 352,  384, 416,
  448, 480,  512, 544,  576, 608,  640, 672,  704, 736,  768, 800,  832, 864,
  896, 928,  960, 992,  1,   33,   65,  97,   129, 161,  193, 225,  257, 289,
  321, 353,  385, 417,  449, 481,  513, 545,  577, 609,  641, 673,  705, 737,
  769, 801,  833, 865,  897, 929,  961, 993,  2,   34,   66,  98,   130, 162,
  194, 226,  258, 290,  322, 354,  386, 418,  450, 482,  514, 546,  578, 610,
  642, 674,  706, 738,  770, 802,  834, 866,  898, 930,  962, 994,  3,   35,
  67,  99,   131, 163,  195, 227,  259, 291,  323, 355,  387, 419,  451, 483,
  515, 547,  579, 611,  643, 675,  707, 739,  771, 803,  835, 867,  899, 931,
  963, 995,  4,   36,   68,  100,  132, 164,  196, 228,  260, 292,  324, 356,
  388, 420,  452, 484,  516, 548,  580, 612,  644, 676,  708, 740,  772, 804,
  836, 868,  900, 932,  964, 996,  5,   37,   69,  101,  133, 165,  197, 229,
  261, 293,  325, 357,  389, 421,  453, 485,  517, 549,  581, 613,  645, 677,
  709, 741,  773, 805,  837, 869,  901, 933,  965, 997,  6,   38,   70,  102,
  134, 166,  198, 230,  262, 294,  326, 358,  390, 422,  454, 486,  518, 550,
  582, 614,  646, 678,  710, 742,  774, 806,  838, 870,  902, 934,  966, 998,
  7,   39,   71,  103,  135, 167,  199, 231,  263, 295,  327, 359,  391, 423,
  455, 487,  519, 551,  583, 615,  647, 679,  711, 743,  775, 807,  839, 871,
  903, 935,  967, 999,  8,   40,   72,  104,  136, 168,  200, 232,  264, 296,
  328, 360,  392, 424,  456, 488,  520, 552,  584, 616,  648, 680,  712, 744,
  776, 808,  840, 872,  904, 936,  968, 1000, 9,   41,   73,  105,  137, 169,
  201, 233,  265, 297,  329, 361,  393, 425,  457, 489,  521, 553,  585, 617,
  649, 681,  713, 745,  777, 809,  841, 873,  905, 937,  969, 1001, 10,  42,
  74,  106,  138, 170,  202, 234,  266, 298,  330, 362,  394, 426,  458, 490,
  522, 554,  586, 618,  650, 682,  714, 746,  778, 810,  842, 874,  906, 938,
  970, 1002, 11,  43,   75,  107,  139, 171,  203, 235,  267, 299,  331, 363,
  395, 427,  459, 491,  523, 555,  587, 619,  651, 683,  715, 747,  779, 811,
  843, 875,  907, 939,  971, 1003, 12,  44,   76,  108,  140, 172,  204, 236,
  268, 300,  332, 364,  396, 428,  460, 492,  524, 556,  588, 620,  652, 684,
  716, 748,  780, 812,  844, 876,  908, 940,  972, 1004, 13,  45,   77,  109,
  141, 173,  205, 237,  269, 301,  333, 365,  397, 429,  461, 493,  525, 557,
  589, 621,  653, 685,  717, 749,  781, 813,  845, 877,  909, 941,  973, 1005,
  14,  46,   78,  110,  142, 174,  206, 238,  270, 302,  334, 366,  398, 430,
  462, 494,  526, 558,  590, 622,  654, 686,  718, 750,  782, 814,  846, 878,
  910, 942,  974, 1006, 15,  47,   79,  111,  143, 175,  207, 239,  271, 303,
  335, 367,  399, 431,  463, 495,  527, 559,  591, 623,  655, 687,  719, 751,
  783, 815,  847, 879,  911, 943,  975, 1007, 16,  48,   80,  112,  144, 176,
  208, 240,  272, 304,  336, 368,  400, 432,  464, 496,  528, 560,  592, 624,
  656, 688,  720, 752,  784, 816,  848, 880,  912, 944,  976, 1008, 17,  49,
  81,  113,  145, 177,  209, 241,  273, 305,  337, 369,  401, 433,  465, 497,
  529, 561,  593, 625,  657, 689,  721, 753,  785, 817,  849, 881,  913, 945,
  977, 1009, 18,  50,   82,  114,  146, 178,  210, 242,  274, 306,  338, 370,
  402, 434,  466, 498,  530, 562,  594, 626,  658, 690,  722, 754,  786, 818,
  850, 882,  914, 946,  978, 1010, 19,  51,   83,  115,  147, 179,  211, 243,
  275, 307,  339, 371,  403, 435,  467, 499,  531, 563,  595, 627,  659, 691,
  723, 755,  787, 819,  851, 883,  915, 947,  979, 1011, 20,  52,   84,  116,
  148, 180,  212, 244,  276, 308,  340, 372,  404, 436,  468, 500,  532, 564,
  596, 628,  660, 692,  724, 756,  788, 820,  852, 884,  916, 948,  980, 1012,
  21,  53,   85,  117,  149, 181,  213, 245,  277, 309,  341, 373,  405, 437,
  469, 501,  533, 565,  597, 629,  661, 693,  725, 757,  789, 821,  853, 885,
  917, 949,  981, 1013, 22,  54,   86,  118,  150, 182,  214, 246,  278, 310,
  342, 374,  406, 438,  470, 502,  534, 566,  598, 630,  662, 694,  726, 758,
  790, 822,  854, 886,  918, 950,  982, 1014, 23,  55,   87,  119,  151, 183,
  215, 247,  279, 311,  343, 375,  407, 439,  471, 503,  535, 567,  599, 631,
  663, 695,  727, 759,  791, 823,  855, 887,  919, 951,  983, 1015, 24,  56,
  88,  120,  152, 184,  216, 248,  280, 312,  344, 376,  408, 440,  472, 504,
  536, 568,  600, 632,  664, 696,  728, 760,  792, 824,  856, 888,  920, 952,
  984, 1016, 25,  57,   89,  121,  153, 185,  217, 249,  281, 313,  345, 377,
  409, 441,  473, 505,  537, 569,  601, 633,  665, 697,  729, 761,  793, 825,
  857, 889,  921, 953,  985, 1017, 26,  58,   90,  122,  154, 186,  218, 250,
  282, 314,  346, 378,  410, 442,  474, 506,  538, 570,  602, 634,  666, 698,
  730, 762,  794, 826,  858, 890,  922, 954,  986, 1018, 27,  59,   91,  123,
  155, 187,  219, 251,  283, 315,  347, 379,  411, 443,  475, 507,  539, 571,
  603, 635,  667, 699,  731, 763,  795, 827,  859, 891,  923, 955,  987, 1019,
  28,  60,   92,  124,  156, 188,  220, 252,  284, 316,  348, 380,  412, 444,
  476, 508,  540, 572,  604, 636,  668, 700,  732, 764,  796, 828,  860, 892,
  924, 956,  988, 1020, 29,  61,   93,  125,  157, 189,  221, 253,  285, 317,
  349, 381,  413, 445,  477, 509,  541, 573,  605, 637,  669, 701,  733, 765,
  797, 829,  861, 893,  925, 957,  989, 1021, 30,  62,   94,  126,  158, 190,
  222, 254,  286, 318,  350, 382,  414, 446,  478, 510,  542, 574,  606, 638,
  670, 702,  734, 766,  798, 830,  862, 894,  926, 958,  990, 1022, 31,  63,
  95,  127,  159, 191,  223, 255,  287, 319,  351, 383,  415, 447,  479, 511,
  543, 575,  607, 639,  671, 703,  735, 767,  799, 831,  863, 895,  927, 959,
  991, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x32[1024]) = {
  0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,
  13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
  26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
  39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
  52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
  65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
  78,   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
  91,   92,   93,   94,   95,   96,   97,   98,   99,   100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,
  156,  157,  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,  168,
  169,  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
  208,  209,  210,  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  249,  250,  251,  252,  253,  254,  255,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  420,  421,  422,  423,  424,  425,  426,  427,  428,
  429,  430,  431,  432,  433,  434,  435,  436,  437,  438,  439,  440,  441,
  442,  443,  444,  445,  446,  447,  448,  449,  450,  451,  452,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,  465,  466,  467,
  468,  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,  479,  480,
  481,  482,  483,  484,  485,  486,  487,  488,  489,  490,  491,  492,  493,
  494,  495,  496,  497,  498,  499,  500,  501,  502,  503,  504,  505,  506,
  507,  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,  518,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,  532,
  533,  534,  535,  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  551,  552,  553,  554,  555,  556,  557,  558,
  559,  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,  573,  574,  575,  576,  577,  578,  579,  580,  581,  582,  583,  584,
  585,  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,  610,
  611,  612,  613,  614,  615,  616,  617,  618,  619,  620,  621,  622,  623,
  624,  625,  626,  627,  628,  629,  630,  631,  632,  633,  634,  635,  636,
  637,  638,  639,  640,  641,  642,  643,  644,  645,  646,  647,  648,  649,
  650,  651,  652,  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
  676,  677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,
  689,  690,  691,  692,  693,  694,  695,  696,  697,  698,  699,  700,  701,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,  712,  713,  714,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,  727,
  728,  729,  730,  731,  732,  733,  734,  735,  736,  737,  738,  739,  740,
  741,  742,  743,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,
  754,  755,  756,  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  767,  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,  778,  779,
  780,  781,  782,  783,  784,  785,  786,  787,  788,  789,  790,  791,  792,
  793,  794,  795,  796,  797,  798,  799,  800,  801,  802,  803,  804,  805,
  806,  807,  808,  809,  810,  811,  812,  813,  814,  815,  816,  817,  818,
  819,  820,  821,  822,  823,  824,  825,  826,  827,  828,  829,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,  842,  843,  844,
  845,  846,  847,  848,  849,  850,  851,  852,  853,  854,  855,  856,  857,
  858,  859,  860,  861,  862,  863,  864,  865,  866,  867,  868,  869,  870,
  871,  872,  873,  874,  875,  876,  877,  878,  879,  880,  881,  882,  883,
  884,  885,  886,  887,  888,  889,  890,  891,  892,  893,  894,  895,  896,
  897,  898,  899,  900,  901,  902,  903,  904,  905,  906,  907,  908,  909,
  910,  911,  912,  913,  914,  915,  916,  917,  918,  919,  920,  921,  922,
  923,  924,  925,  926,  927,  928,  929,  930,  931,  932,  933,  934,  935,
  936,  937,  938,  939,  940,  941,  942,  943,  944,  945,  946,  947,  948,
  949,  950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,
  962,  963,  964,  965,  966,  967,  968,  969,  970,  971,  972,  973,  974,
  975,  976,  977,  978,  979,  980,  981,  982,  983,  984,  985,  986,  987,
  988,  989,  990,  991,  992,  993,  994,  995,  996,  997,  998,  999,  1000,
  1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
  1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x32[1024]) = {
  0,    1,    5,    6,    14,   15,   27,   28,   44,   45,   65,   66,   90,
  91,   119,  120,  152,  153,  189,  190,  230,  231,  275,  276,  324,  325,
  377,  378,  434,  435,  495,  496,  2,    4,    7,    13,   16,   26,   29,
  43,   46,   64,   67,   89,   92,   118,  121,  151,  154,  188,  191,  229,
  232,  274,  277,  323,  326,  376,  379,  433,  436,  494,  497,  558,  3,
  8,    12,   17,   25,   30,   42,   47,   63,   68,   88,   93,   117,  122,
  150,  155,  187,  192,  228,  233,  273,  278,  322,  327,  375,  380,  432,
  437,  493,  498,  557,  559,  9,    11,   18,   24,   31,   41,   48,   62,
  69,   87,   94,   116,  123,  149,  156,  186,  193,  227,  234,  272,  279,
  321,  328,  374,  381,  431,  438,  492,  499,  556,  560,  617,  10,   19,
  23,   32,   40,   49,   61,   70,   86,   95,   115,  124,  148,  157,  185,
  194,  226,  235,  271,  280,  320,  329,  373,  382,  430,  439,  491,  500,
  555,  561,  616,  618,  20,   22,   33,   39,   50,   60,   71,   85,   96,
  114,  125,  147,  158,  184,  195,  225,  236,  270,  281,  319,  330,  372,
  383,  429,  440,  490,  501,  554,  562,  615,  619,  672,  21,   34,   38,
  51,   59,   72,   84,   97,   113,  126,  146,  159,  183,  196,  224,  237,
  269,  282,  318,  331,  371,  384,  428,  441,  489,  502,  553,  563,  614,
  620,  671,  673,  35,   37,   52,   58,   73,   83,   98,   112,  127,  145,
  160,  182,  197,  223,  238,  268,  283,  317,  332,  370,  385,  427,  442,
  488,  503,  552,  564,  613,  621,  670,  674,  723,  36,   53,   57,   74,
  82,   99,   111,  128,  144,  161,  181,  198,  222,  239,  267,  284,  316,
  333,  369,  386,  426,  443,  487,  504,  551,  565,  612,  622,  669,  675,
  722,  724,  54,   56,   75,   81,   100,  110,  129,  143,  162,  180,  199,
  221,  240,  266,  285,  315,  334,  368,  387,  425,  444,  486,  505,  550,
  566,  611,  623,  668,  676,  721,  725,  770,  55,   76,   80,   101,  109,
  130,  142,  163,  179,  200,  220,  241,  265,  286,  314,  335,  367,  388,
  424,  445,  485,  506,  549,  567,  610,  624,  667,  677,  720,  726,  769,
  771,  77,   79,   102,  108,  131,  141,  164,  178,  201,  219,  242,  264,
  287,  313,  336,  366,  389,  423,  446,  484,  507,  548,  568,  609,  625,
  666,  678,  719,  727,  768,  772,  813,  78,   103,  107,  132,  140,  165,
  177,  202,  218,  243,  263,  288,  312,  337,  365,  390,  422,  447,  483,
  508,  547,  569,  608,  626,  665,  679,  718,  728,  767,  773,  812,  814,
  104,  106,  133,  139,  166,  176,  203,  217,  244,  262,  289,  311,  338,
  364,  391,  421,  448,  482,  509,  546,  570,  607,  627,  664,  680,  717,
  729,  766,  774,  811,  815,  852,  105,  134,  138,  167,  175,  204,  216,
  245,  261,  290,  310,  339,  363,  392,  420,  449,  481,  510,  545,  571,
  606,  628,  663,  681,  716,  730,  765,  775,  810,  816,  851,  853,  135,
  137,  168,  174,  205,  215,  246,  260,  291,  309,  340,  362,  393,  419,
  450,  480,  511,  544,  572,  605,  629,  662,  682,  715,  731,  764,  776,
  809,  817,  850,  854,  887,  136,  169,  173,  206,  214,  247,  259,  292,
  308,  341,  361,  394,  418,  451,  479,  512,  543,  573,  604,  630,  661,
  683,  714,  732,  763,  777,  808,  818,  849,  855,  886,  888,  170,  172,
  207,  213,  248,  258,  293,  307,  342,  360,  395,  417,  452,  478,  513,
  542,  574,  603,  631,  660,  684,  713,  733,  762,  778,  807,  819,  848,
  856,  885,  889,  918,  171,  208,  212,  249,  257,  294,  306,  343,  359,
  396,  416,  453,  477,  514,  541,  575,  602,  632,  659,  685,  712,  734,
  761,  779,  806,  820,  847,  857,  884,  890,  917,  919,  209,  211,  250,
  256,  295,  305,  344,  358,  397,  415,  454,  476,  515,  540,  576,  601,
  633,  658,  686,  711,  735,  760,  780,  805,  821,  846,  858,  883,  891,
  916,  920,  945,  210,  251,  255,  296,  304,  345,  357,  398,  414,  455,
  475,  516,  539,  577,  600,  634,  657,  687,  710,  736,  759,  781,  804,
  822,  845,  859,  882,  892,  915,  921,  944,  946,  252,  254,  297,  303,
  346,  356,  399,  413,  456,  474,  517,  538,  578,  599,  635,  656,  688,
  709,  737,  758,  782,  803,  823,  844,  860,  881,  893,  914,  922,  943,
  947,  968,  253,  298,  302,  347,  355,  400,  412,  457,  473,  518,  537,
  579,  598,  636,  655,  689,  708,  738,  757,  783,  802,  824,  843,  861,
  880,  894,  913,  923,  942,  948,  967,  969,  299,  301,  348,  354,  401,
  411,  458,  472,  519,  536,  580,  597,  637,  654,  690,  707,  739,  756,
  784,  801,  825,  842,  862,  879,  895,  912,  924,  941,  949,  966,  970,
  987,  300,  349,  353,  402,  410,  459,  471,  520,  535,  581,  596,  638,
  653,  691,  706,  740,  755,  785,  800,  826,  841,  863,  878,  896,  911,
  925,  940,  950,  965,  971,  986,  988,  350,  352,  403,  409,  460,  470,
  521,  534,  582,  595,  639,  652,  692,  705,  741,  754,  786,  799,  827,
  840,  864,  877,  897,  910,  926,  939,  951,  964,  972,  985,  989,  1002,
  351,  404,  408,  461,  469,  522,  533,  583,  594,  640,  651,  693,  704,
  742,  753,  787,  798,  828,  839,  865,  876,  898,  909,  927,  938,  952,
  963,  973,  984,  990,  1001, 1003, 405,  407,  462,  468,  523,  532,  584,
  593,  641,  650,  694,  703,  743,  752,  788,  797,  829,  838,  866,  875,
  899,  908,  928,  937,  953,  962,  974,  983,  991,  1000, 1004, 1013, 406,
  463,  467,  524,  531,  585,  592,  642,  649,  695,  702,  744,  751,  789,
  796,  830,  837,  867,  874,  900,  907,  929,  936,  954,  961,  975,  982,
  992,  999,  1005, 1012, 1014, 464,  466,  525,  530,  586,  591,  643,  648,
  696,  701,  745,  750,  790,  795,  831,  836,  868,  873,  901,  906,  930,
  935,  955,  960,  976,  981,  993,  998,  1006, 1011, 1015, 1020, 465,  526,
  529,  587,  590,  644,  647,  697,  700,  746,  749,  791,  794,  832,  835,
  869,  872,  902,  905,  931,  934,  956,  959,  977,  980,  994,  997,  1007,
  1010, 1016, 1019, 1021, 527,  528,  588,  589,  645,  646,  698,  699,  747,
  748,  792,  793,  833,  834,  870,  871,  903,  904,  932,  933,  957,  958,
  978,  979,  995,  996,  1008, 1009, 1017, 1018, 1022, 1023
};

const SCAN_ORDER av1_default_scan_orders[TX_SIZES] = {
  { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
  { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
  { default_scan_16x16, av1_default_iscan_16x16, default_scan_16x16_neighbors },
  { default_scan_32x32, av1_default_iscan_32x32, default_scan_32x32_neighbors },
  // Half of the coefficients of tx64 at higher frequencies are set to
  // zeros. So tx32's scan order is used.
  { default_scan_32x32, av1_default_iscan_32x32, default_scan_32x32_neighbors },
};

const SCAN_ORDER av1_scan_orders[TX_SIZES_ALL][TX_TYPES] = {
  {
      // TX_4X4
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
  },
  {
      // TX_8X8
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
  },
  {
      // TX_16X16
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
  },
  {
      // TX_32X32
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
  },
  {
      // TX_64X64
      // Half of the coefficients of tx64 at higher frequencies are set to
      // zeros. So tx32's scan order is used.
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
  },
  {
      // TX_4X8
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
  },
  {
      // TX_8X4
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
  },
  {
      // TX_8X16
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
  },
  {
      // TX_16X8
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
  },
  {
      // TX_16X32
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
  },
  {
      // TX_32X16
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
  },
  {
      // TX_32X64
      // Half of the coefficients of tx64 at higher frequencies are set to
      // zeros. So tx32's scan order is used.
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
  },
  {
      // TX_64X32
      // Half of the coefficients of tx64 at higher frequencies are set to
      // zeros. So tx32's scan order is used.
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
  },
  {
      // TX_4X16
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
  },
  {
      // TX_16X4
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
  },
  {
      // TX_8X32
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
  },
  {
      // TX_32X8
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
  },
  {
      // TX_16X64
      // Half of the coefficients of tx64 at higher frequencies are set to
      // zeros. So tx32's scan order is used.
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
  },
  {
      // TX_64X16
      // Half of the coefficients of tx64 at higher frequencies are set to
      // zeros. So tx32's scan order is used.
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
  },
};
