/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:41:44 GMT 2018
 */

package uk.ac.sanger.artemis.cramtools.ref;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ReferenceRegion_ESTest extends ReferenceRegion_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (-2601), "", 1L);
      // Undeclared exception!
      try { 
        referenceRegion0.md5((-2601), 1406);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, (byte)0, "", 4805L, (byte)0);
      assertEquals(0, referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      byte[] byteArray1 = ReferenceRegion.copySafe(byteArray0, 0L, (int) (byte)0, 86);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)0}, byteArray1);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      byte[] byteArray0 = new byte[20];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      byte[] byteArray1 = referenceRegion0.copySafe((long) (byte)4, 0);
      assertArrayEquals(new byte[] {}, byteArray1);
      assertEquals((-1439), referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      byte[] byteArray0 = new byte[20];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      byte[] byteArray1 = referenceRegion0.copy((byte)2, 0);
      assertEquals((-1439), referenceRegion0.index);
      assertArrayEquals(new byte[] {}, byteArray1);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      byteArray0[0] = (byte)2;
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      referenceRegion0.alignmentStart = (long) (byte)4;
      referenceRegion0.alignmentStart = (long) (byte)0;
      byte byte0 = referenceRegion0.base(0L);
      assertEquals((byte)2, byte0);
      assertEquals((-1439), referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-2);
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)0, "", (byte)77);
      byte byte0 = referenceRegion0.base((byte)77);
      assertEquals(0, referenceRegion0.index);
      assertEquals((byte) (-2), byte0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 2074, "");
      ReferenceRegion referenceRegion1 = ReferenceRegion.wrap(referenceRegion0.array, (-1), "o63Hwei,`j");
      referenceRegion1.alignmentStart = (long) (byte) (-1);
      int int0 = referenceRegion1.arrayPosition(1L);
      assertEquals((-1), referenceRegion1.index);
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 944, "<> Q");
      // Undeclared exception!
      try { 
        referenceRegion0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 5690, "");
      // Undeclared exception!
      try { 
        referenceRegion0.md5(1, 1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe((byte[]) null, 0L, 10, 10);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ReferenceRegion referenceRegion0 = new ReferenceRegion((byte[]) null, 78, "ReferenceRegion [index=", (byte)2);
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe(433L, (int) (byte) (-118));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 1872, "=ABCDGHKMNRSTVWY");
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe((-1L), (int) (byte) (-90));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // -2 > -92
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)0, "htsjdk.samtools.SAMException");
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe((long) (byte)0, 1188);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion((byte[]) null, 0, "-So1]", (-304L), (-1L));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      byte[] byteArray0 = new byte[8];
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion(byteArray0, (byte)0, "", 0L, (-1788L));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // -1 > -1788
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion(byteArray0, 0, "Sz,w>mi", 0, 0L);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 887, "y<xcN{q8@i");
      // Undeclared exception!
      try { 
        referenceRegion0.copy(887, 887);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      byte[] byteArray0 = new byte[20];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      // Undeclared exception!
      try { 
        referenceRegion0.copy((byte)2, (byte) (-1));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // 1 > 0
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, 2146412049, "", 48);
      // Undeclared exception!
      try { 
        referenceRegion0.copy(48, 2146412049);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 48, 2146412097, 0, 2146412049
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      ReferenceRegion referenceRegion0 = new ReferenceRegion((byte[]) null, 269, "PAMN$x%*]-DJi:4 tq", 269);
      // Undeclared exception!
      try { 
        referenceRegion0.base(269);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, (-569), "");
      // Undeclared exception!
      try { 
        referenceRegion0.arrayPosition((-569));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      byte[] byteArray0 = new byte[6];
      ReferenceRegion referenceRegion0 = null;
      try {
        referenceRegion0 = new ReferenceRegion(byteArray0, (byte)0, (String) null, (byte)0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Invalid reference region1: null, 0, 6.
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, 48, "]", 48, 48);
      // Undeclared exception!
      try { 
        referenceRegion0.md5(4, 4);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe(byteArray0, (long) (byte) (-60), (int) (byte) (-60), (int) (byte) (-60));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // 0 > -60
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      byte[] byteArray1 = ReferenceRegion.copySafe(byteArray0, 1L, 3450, 1493);
      assertArrayEquals(new byte[] {}, byteArray1);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1341), "ZV )j(j");
      // Undeclared exception!
      try { 
        referenceRegion0.arrayPosition(529L);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 1, 529, 0, 528
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 2074, "");
      assertEquals(1L, referenceRegion0.alignmentStart);
      
      int int0 = referenceRegion0.arrayPosition(1L);
      assertEquals(0, int0);
      assertEquals(2074, referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 2074, "");
      String string0 = referenceRegion0.toString();
      assertEquals("ReferenceRegion [index=2074, name=, alignmentStart=1, array length=3]", string0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 2074, "");
      String string0 = referenceRegion0.md5(7, 86);
      assertEquals("d41d8cd98f00b204e9800998ecf8427e", string0);
      assertEquals(2074, referenceRegion0.index);
      assertEquals(1L, referenceRegion0.alignmentStart);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe(byteArray0, (long) (byte)3, 0, 68);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      ReferenceRegion referenceRegion0 = null;
      try {
        referenceRegion0 = new ReferenceRegion((byte[]) null, 2193, "In files ", (-1L));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      byte[] byteArray0 = new byte[29];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      byte[] byteArray1 = referenceRegion0.copySafe((long) (byte)28, (int) (byte)2);
      assertArrayEquals(new byte[] {(byte)0, (byte)0}, byteArray1);
      assertEquals(1L, referenceRegion0.alignmentStart);
      assertEquals((-1439), referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, (byte)117, "", (byte)117, (byte)117);
      String string0 = referenceRegion0.md5((byte)117, 2);
      assertEquals(117, referenceRegion0.index);
      assertEquals("d41d8cd98f00b204e9800998ecf8427e", string0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      byte[] byteArray0 = new byte[29];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1439), "GF+{fz[%I{B6@#=};");
      byte[] byteArray1 = referenceRegion0.copy((byte)2, (byte)2);
      assertEquals(1L, referenceRegion0.alignmentStart);
      assertEquals((-1439), referenceRegion0.index);
      assertArrayEquals(new byte[] {(byte)0, (byte)0}, byteArray1);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)0, "", (byte)77);
      // Undeclared exception!
      try { 
        referenceRegion0.base(1367L);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 77, 1367, 0, 1290
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)0, "", (byte)77);
      assertEquals(77L, referenceRegion0.alignmentStart);
      
      referenceRegion0.base((byte)77);
      assertEquals(0, referenceRegion0.index);
  }
}
