/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.JiapiField;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.Loader;
import net.sf.jiapi.tool.re.ControlFlowGraph;
import net.sf.jiapi.tool.re.Statement;
import net.sf.jiapi.tool.re.StatementBuilder;

public class Decompiler {
    private JiapiClass clazz;

    public static void main(String[] args) throws Exception {
        Decompiler re = new Decompiler();
        long l1 = System.currentTimeMillis();
        if (args.length > 0) {
            re.loadClass(args[0]);
        } else {
            re.loadClass("test.RETest");
        }
        long l2 = System.currentTimeMillis();
        long clTime = l2 - l1;
        l1 = System.currentTimeMillis();
        re.decompile();
        l2 = System.currentTimeMillis();
        System.out.println("Class loading in " + clTime + " ms");
        System.out.println("Decompiled in " + (l2 - l1) + " ms");
    }

    private void decompile() throws ClassNotFoundException {
        String pkg = this.clazz.getPackageName();
        if (pkg != null) {
            System.out.println("package " + pkg + ";\n");
        }
        for (ConstantPool.Entry e : this.clazz.getConstantPool()) {
            ConstantPool.ClassInfo ci;
            String refName;
            if (!(e instanceof ConstantPool.ClassInfo) || (refName = (ci = (ConstantPool.ClassInfo)e).getName()).startsWith("java/lang") || refName.startsWith(this.clazz.getPackageName() + "/")) continue;
            System.out.println("import " + ci.getName().replace('/', '.') + ";");
        }
        System.out.println();
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.clazz.getModifiers() & 0xFFDF));
        sb.append(" class ");
        sb.append(this.clazz.getName());
        String[] interfaces = this.clazz.getInterfaceNames();
        if (interfaces.length > 0) {
            sb.append(" implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                sb.append(interfaces[i]);
                if (i >= interfaces.length - 1) continue;
                sb.append(", ");
            }
        }
        System.out.println(sb);
        JiapiField[] fields = this.clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.printField(fields[i]);
        }
        System.out.println();
        JiapiMethod[] methods = this.clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.printMethod(methods[i]);
        }
    }

    private void printMethod(JiapiMethod jm) {
        StringBuffer sb = new StringBuffer("------------------------------\n");
        sb.append("   " + Modifier.toString(jm.getModifiers() & 0xFFDF));
        if (jm.getName().equals("<clinit>")) {
            sb.append(" {");
        } else if (jm.getName().equals("<init>")) {
            sb.append(" " + jm.getDeclaringClass().getName() + "(");
        } else {
            sb.append(" " + jm.getReturnType() + " " + jm.getName() + "(");
        }
        String[] params = jm.getParameterTypeNames();
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i] + " arg" + i);
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        if (!jm.getName().equals("<clinit>")) {
            sb.append(")");
        }
        System.out.println(sb);
        this.printInstructions(jm);
    }

    private void printInstructions(JiapiMethod jm) {
        InstructionList il = jm.getInstructionList();
        int offset = 0;
        for (int i = 0; i < il.size(); ++i) {
            System.out.println("      // " + i + ", (" + offset + ") " + il.get(i));
            offset += il.get(i).length();
        }
        ControlFlowGraph cfg = new ControlFlowGraph(jm.getInstructionList().getBasicBlocks());
        System.out.println(cfg);
        Method method = jm.getMethod();
        StackMapTableAttribute smt = (StackMapTableAttribute)method.getAttribute("StackMapTable");
        if (smt != null) {
            System.out.println("StackMapTable:");
            for (StackMapTableAttribute.StackMapFrame smf : smt.getEntries()) {
                System.out.println("  " + smf);
            }
        } else {
            System.out.println("No StackMapTable");
        }
        System.out.println("Loops detected: " + cfg.getLoopList());
        StatementBuilder sBuilder = new StatementBuilder(cfg);
        List<Statement> stmts = sBuilder.structure();
        System.out.println("Statements:");
        for (Statement stmt : stmts) {
            System.out.println(stmt.toString(3));
        }
    }

    private void printField(JiapiField jiapiField) {
        StringBuffer sb = new StringBuffer();
        sb.append("   " + Modifier.toString(jiapiField.getModifiers() & 0xFFDF));
        sb.append(" " + jiapiField.getTypeName() + " " + jiapiField.getName() + ";");
        System.out.println(sb);
    }

    private void loadClass(String classOrFileName) throws IOException, ClassNotFoundException {
        Loader l = new Loader();
        File f = new File(classOrFileName);
        this.clazz = f.exists() ? l.loadClass(new FileInputStream(f)) : l.loadClass(classOrFileName);
        if (this.clazz == null) {
            throw new FileNotFoundException("Could not load class " + classOrFileName);
        }
    }

    private static void usage() {
        System.out.println("Usage: " + Decompiler.class.getName() + " <class-file>");
    }
}

