//
// BAGEL - Parallel electron correlation program.
// Filename: _sphusp_8.cc
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Hai-Anh Le <anh@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/ecp/sphusplist.h>

using namespace std;
using namespace bagel;

vector<double> SphUSPList::sphusp_8(const int m) {

  vector<double> c;
  constexpr double coeff[765] = {   0.000000000000000e+00,   5.831413281398638e+00,   0.000000000000000e+00,  -4.081989296979047e+01,   0.000000000000000e+00,
   4.081989296979047e+01,   0.000000000000000e+00,  -5.831413281398638e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.040994648489523e+01,   0.000000000000000e+00,  -1.020497324244762e+02,   0.000000000000000e+00,   6.122983945468570e+01,
   0.000000000000000e+00,  -2.915706640699319e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -3.193996596357255e+00,   0.000000000000000e+00,   7.452658724833596e+00,   0.000000000000000e+00,
   7.452658724833596e+00,   0.000000000000000e+00,  -3.193996596357255e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   4.471595234900158e+01,   0.000000000000000e+00,
  -1.490531744966719e+02,   0.000000000000000e+00,   4.471595234900158e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -1.724955311049054e+01,   0.000000000000000e+00,   1.724955311049054e+01,   0.000000000000000e+00,   3.104919559888297e+01,
   0.000000000000000e+00,  -3.449910622098108e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   6.899821244196217e+01,   0.000000000000000e+00,  -1.379964248839243e+02,   0.000000000000000e+00,   1.379964248839243e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.913666099037323e+00,   0.000000000000000e+00,   1.913666099037323e+00,   0.000000000000000e+00,
  -1.913666099037323e+00,   0.000000000000000e+00,  -1.913666099037323e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -4.592798637689575e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   4.592798637689575e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   7.654664396149290e+01,   0.000000000000000e+00,  -7.654664396149290e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.111739539765990e+01,   0.000000000000000e+00,   1.852899232943317e+01,   0.000000000000000e+00,   3.705798465886633e+00,
   0.000000000000000e+00,  -3.705798465886633e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -7.411596931773266e+01,   0.000000000000000e+00,  -4.941064621182177e+01,   0.000000000000000e+00,   2.470532310591089e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   5.929277545418613e+01,   0.000000000000000e+00,  -1.976425848472871e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -9.123045168698189e-01,   0.000000000000000e+00,  -2.736913550609457e+00,   0.000000000000000e+00,
  -2.736913550609457e+00,   0.000000000000000e+00,  -9.123045168698189e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.736913550609457e+01,   0.000000000000000e+00,
   5.473827101218914e+01,   0.000000000000000e+00,   2.736913550609457e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -7.298436134958551e+01,   0.000000000000000e+00,  -7.298436134958551e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.919374453983421e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -3.816443606457299e+00,   0.000000000000000e+00,  -1.144933081937190e+01,   0.000000000000000e+00,  -1.144933081937190e+01,
   0.000000000000000e+00,  -3.816443606457299e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   3.053154885165839e+01,   0.000000000000000e+00,   6.106309770331678e+01,   0.000000000000000e+00,   3.053154885165839e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -3.663785862199007e+01,   0.000000000000000e+00,  -3.663785862199007e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   6.978639737521918e+00,   0.000000000000000e+00,
   3.180369672047749e-01,   0.000000000000000e+00,   1.272147868819099e+00,   0.000000000000000e+00,   1.908221803228649e+00,
   0.000000000000000e+00,   1.272147868819099e+00,   0.000000000000000e+00,   3.180369672047749e-01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -1.017718295055280e+01,   0.000000000000000e+00,  -3.053154885165839e+01,
   0.000000000000000e+00,  -3.053154885165839e+01,   0.000000000000000e+00,  -1.017718295055280e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   3.053154885165839e+01,   0.000000000000000e+00,   6.106309770331677e+01,   0.000000000000000e+00,   3.053154885165839e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -1.628349272088447e+01,
   0.000000000000000e+00,  -1.628349272088447e+01,   0.000000000000000e+00,   0.000000000000000e+00,   1.163106622920319e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -3.816443606457299e+00,
   0.000000000000000e+00,  -1.144933081937190e+01,   0.000000000000000e+00,  -1.144933081937190e+01,   0.000000000000000e+00,
  -3.816443606457299e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.053154885165839e+01,
   0.000000000000000e+00,   6.106309770331678e+01,   0.000000000000000e+00,   3.053154885165839e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -3.663785862199007e+01,   0.000000000000000e+00,  -3.663785862199007e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   6.978639737521918e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -4.561522584349095e-01,   0.000000000000000e+00,  -9.123045168698189e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   9.123045168698189e-01,   0.000000000000000e+00,   4.561522584349095e-01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   1.368456775304728e+01,   0.000000000000000e+00,   1.368456775304728e+01,
   0.000000000000000e+00,  -1.368456775304728e+01,   0.000000000000000e+00,  -1.368456775304728e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -3.649218067479276e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.649218067479276e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.459687226991710e+01,
   0.000000000000000e+00,  -1.459687226991710e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.705798465886633e+00,
   0.000000000000000e+00,  -3.705798465886633e+00,   0.000000000000000e+00,  -1.852899232943317e+01,   0.000000000000000e+00,
  -1.111739539765990e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -2.470532310591089e+01,
   0.000000000000000e+00,   4.941064621182177e+01,   0.000000000000000e+00,   7.411596931773266e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.976425848472871e+01,   0.000000000000000e+00,  -5.929277545418613e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   4.784165247593307e-01,   0.000000000000000e+00,  -1.913666099037323e+00,   0.000000000000000e+00,  -4.784165247593307e+00,
   0.000000000000000e+00,  -1.913666099037323e+00,   0.000000000000000e+00,   4.784165247593307e-01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -1.148199659422394e+01,   0.000000000000000e+00,   5.740998297111968e+01,
   0.000000000000000e+00,   5.740998297111968e+01,   0.000000000000000e+00,  -1.148199659422394e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.913666099037323e+01,   0.000000000000000e+00,  -1.148199659422393e+02,   0.000000000000000e+00,   1.913666099037323e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -3.449910622098108e+00,
   0.000000000000000e+00,   3.104919559888297e+01,   0.000000000000000e+00,   1.724955311049054e+01,   0.000000000000000e+00,
  -1.724955311049054e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.379964248839243e+01,
   0.000000000000000e+00,  -1.379964248839243e+02,   0.000000000000000e+00,   6.899821244196217e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -5.323327660595426e-01,   0.000000000000000e+00,   7.452658724833596e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -7.452658724833596e+00,   0.000000000000000e+00,   5.323327660595426e-01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   7.452658724833596e+00,   0.000000000000000e+00,  -1.117898808725039e+02,
   0.000000000000000e+00,   1.117898808725039e+02,   0.000000000000000e+00,  -7.452658724833596e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.915706640699319e+00,
   0.000000000000000e+00,  -6.122983945468570e+01,   0.000000000000000e+00,   1.020497324244762e+02,   0.000000000000000e+00,
  -2.040994648489523e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   7.289266601748298e-01,   0.000000000000000e+00,  -2.040994648489523e+01,   0.000000000000000e+00,   5.102486621223808e+01,
   0.000000000000000e+00,  -2.040994648489523e+01,   0.000000000000000e+00,   7.289266601748298e-01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00
};

  assert(abs(m) <= 8);
  const int size_c = (8 + 1) * (8 + 2) / 2;
  const int mu = m + 8;
  const int i0 = mu * size_c;
  for (int i = i0; i != i0 + size_c; ++i) c.push_back(coeff[i]);
  return c;

}
