
Notable changes in 0.33.3 since 0.33.2
======================================

General
-------

* The performance of `bup ls` when columnating a large number of
  results should be *much* better.

Bugs
----

* `bup fuse` should no longer linger after its mount point has been
  unmounted: https://bugs.debian.org/cgi-bin/1050040

* `bup --version` should work again.

* `bup gc` should no longer remove stale packfiles before it creates
  the new midx at the end of a run.  This could cause midx to complain
  about missing files, e.g.:

        warning: index pack-....idx missing

* `bup` will no longer (since 0.33) ignore `BUP_DIR` looking for a
  `pack.packSizeLimit`.

* A VFS optimization of the handling of requests for specific names
  within a given tree has been restored.

* Incorrect uses of some exception handling code designed for
  compatibility with Python 2 have been replaced with the built-in
  Python 3 equivalents.

* Some client calls to `super(CLASS, self)` have been replaced by
  `super()` to avoid errors during `__del__`.

Build system
------------

* `test-help` should no longer hang when run interactively, and should
  no longer be affected by the current locale.  Previously it might
  fail in a non-C locale.

* The `bup damage` invocation in `test-fsck` has been made much more
  aggressive in order to avoid transient failures caused both by
  unpredictable `par2` behavior and the (currently) probabilstic
  nature of the damage.

* OpenBSD builds should no longer fail on `-Werror` related issues
  involving `PROC_SELF_EXE`.

Thanks to (at least)
====================

Alain Cochard, Austin Schuh, Johannes Berg, Julian Smith, Lucas
Nussbaum, Nix, Rob Browning, Rob Leslie, and Robert Edmonds
