/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _MACOPMACDRIVERS_H_

//====================================================================
// This header file contains declarations for the MacOperator mac projection
// driver routines
//====================================================================


// the driver functions for the MAC solves
void mac_level_driver( const MacBndry &mac_bndry,
                       const BoxArray &grids,
                       int use_cg_solve, int level, int Density,
                       const Real *dx, Real dt,
                       Real mac_tol, Real mac_abs_tol, Real rhs_scale,
                       MultiFab *area,  MultiFab &volume,
                       MultiFab &S,     MultiFab &Rhs,
                       MultiFab *u_mac, MultiFab *mac_phi );

// a driver function for computing a sync MAC solve
void mac_sync_driver( const MacBndry &mac_bndry,
                      const BoxArray &grids,
                      int use_cg_solve, int level, 
                      const Real *dx, Real dt,
                      Real mac_sync_tol, Real mac_abs_tol, Real rhs_scale,
                      MultiFab *area,  MultiFab &volume,
                      MultiFab &Rhs,   MultiFab *rho_half,
                      MultiFab *mac_sync_phi );


// apply the mac pressure gradient to a velocity field
// init, means that velocities are initialized here
void mac_vel_update( int init,
                     FArrayBox &uvel,
                     FArrayBox &vvel,
#if (BL_SPACEDIM == 3 )
                     FArrayBox &wvel,
#endif
                     const FArrayBox &phi,
                     const FArrayBox *rho, int rho_comp,  
                     const Box &grd, int level, int n,
                     const Real *dx, Real scale );

#endif
