/*
 * Decompiled with CFR 0.152.
 */
package dumphd.gui;

import dumphd.core.DiscSet;
import dumphd.gui.ManagedJob;
import dumphd.gui.Manager;
import dumphd.gui.SourceTab;
import dumphd.util.MessagePrinter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class MainFrame {
    private static final String NO_SOURCE_SET = "No source selected";
    private static final String NO_DESTINATION_SET = "No destination selected";
    private static final String BROWSE = "Browse";
    private static final String DUMP = "Dump";
    private static final UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
    private Manager manager = null;
    private MessagePrinter out = null;
    private boolean locked = false;
    private JFrame mainFrame = null;
    private JSplitPane horizontalSplitPane = null;
    private JSplitPane verticalSplitPane = null;
    private JLabel sourceLabel = null;
    private JButton sourceButton = null;
    private JPanel gridPanel = null;
    private JLabel[] sourceTypeImage = null;
    private JCheckBox[] sourceTypeCheckBox = null;
    private boolean[] sourceTypeSelectable = null;
    private int sourceTypesSelected = 0;
    private DiscSet[] discSets = null;
    private JFileChooser sourceChooser = null;
    private JLabel destinationLabel = null;
    private JButton destinationButton = null;
    private JFileChooser destinationChooser = null;
    private File destinationDirectory = null;
    private JButton dumpButton = null;
    private JTabbedPane tabPane = null;
    private LinkedList<SourceTab> sourceTabs = new LinkedList();
    private JTextArea logArea = null;

    public MainFrame(Manager manager) {
        this.manager = manager;
        JMenuBar menuBar = null;
        JMenu menu = null;
        JMenuItem menuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem radioButtonMenuItem = null;
        JPanel panel = null;
        String systemLafClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(systemLafClassName);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainFrame = new JFrame("DumpHD 0.61");
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new MainFrameWindowAdapter());
        menuBar = new JMenuBar();
        menu = new JMenu("File");
        menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.close();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Look & Feel");
        LafActionListener lal = new LafActionListener();
        buttonGroup = new ButtonGroup();
        int i = 0;
        while (i < laf.length) {
            String lafClassName = laf[i].getClassName();
            radioButtonMenuItem = lafClassName.equals(systemLafClassName) ? new JRadioButtonMenuItem(laf[i].getName(), true) : new JRadioButtonMenuItem(laf[i].getName(), false);
            radioButtonMenuItem.setActionCommand(lafClassName);
            radioButtonMenuItem.addActionListener(lal);
            buttonGroup.add(radioButtonMenuItem);
            menu.add(radioButtonMenuItem);
            ++i;
        }
        menuBar.add(menu);
        menu = new JMenu("Help");
        menuItem = new JMenuItem("About");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainFrame.this.mainFrame, "DumpHD 0.61\n\nThis is the about box.\n\nWhen the time has come, it will be filled with content.\n\nKenD00", "About", 1);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        this.mainFrame.setJMenuBar(menuBar);
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(true);
        controlPanel.setBorder(Manager.createEmptyBorder());
        controlPanel.setLayout(new BoxLayout(controlPanel, 3));
        JPanel sourcePanel = new JPanel();
        sourcePanel.setBorder(Manager.createTitledBorder("Source"));
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 3));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        this.sourceLabel = new JLabel(NO_SOURCE_SET);
        this.sourceLabel.setBorder(Manager.createLabelBorder());
        this.sourceLabel.setToolTipText(NO_SOURCE_SET);
        this.sourceButton = new JButton(BROWSE);
        this.sourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = MainFrame.this.sourceChooser.showOpenDialog(MainFrame.this.mainFrame);
                if (returnVal == 0) {
                    final File selectedFile = MainFrame.this.sourceChooser.getSelectedFile().getAbsoluteFile();
                    String selectedFilePath = selectedFile.getPath();
                    MainFrame.this.sourceLabel.setText(selectedFilePath);
                    MainFrame.this.sourceLabel.setToolTipText(selectedFilePath);
                    MainFrame.this.clear();
                    ManagedJob workload = new ManagedJob(){

                        @Override
                        public Object run(Object input) {
                            try {
                                MainFrame.this.manager.getDumpHD().initSource(selectedFile, null, null);
                                Collection<DiscSet> result = MainFrame.this.manager.getDumpHD().identifySource();
                                if (result.size() == 0) {
                                    result = null;
                                }
                                return result;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                    };
                    ManagedJob guiJob = new ManagedJob(){

                        @Override
                        public Object run(Object input) {
                            if (input != null) {
                                MainFrame.this.init((Collection)input);
                            }
                            MainFrame.this.unlock();
                            return null;
                        }
                    };
                    MainFrame.this.lock();
                    MainFrame.this.manager.execute(workload, guiJob);
                }
            }
        });
        Manager.equalizeLabelButtonHeight(this.sourceLabel, this.sourceButton);
        panel.add(this.sourceLabel);
        panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_BIG_SPACING));
        panel.add(this.sourceButton);
        sourcePanel.add(panel);
        sourcePanel.add(Box.createRigidArea(Manager.BOX_VERTICAL_BIG_SPACING));
        this.gridPanel = new JPanel(new GridLayout(1, 0, 10, 0));
        JPanel checkBoxPanel = null;
        SourceTypeCheckBoxActionListener cbal = new SourceTypeCheckBoxActionListener();
        this.sourceTypeImage = new JLabel[3];
        this.sourceTypeCheckBox = new JCheckBox[6];
        this.sourceTypeSelectable = new boolean[6];
        this.discSets = new DiscSet[6];
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 3));
        checkBoxPanel.setAlignmentX(0.5f);
        this.sourceTypeImage[0] = new JLabel(new ImageIcon(Manager.getResource("icons/hdsc_logo.png")));
        this.sourceTypeImage[0].setDisabledIcon(new ImageIcon(Manager.getResource("icons/hdsc_logo_disabled.png")));
        this.sourceTypeImage[0].setAlignmentX(0.5f);
        this.sourceTypeCheckBox[0] = new JCheckBox("Video");
        this.sourceTypeCheckBox[0].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[0].addActionListener(cbal);
        this.sourceTypeCheckBox[1] = new JCheckBox("Audio");
        this.sourceTypeCheckBox[1].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[1].addActionListener(cbal);
        panel.add(this.sourceTypeImage[0]);
        panel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        checkBoxPanel.add(this.sourceTypeCheckBox[0]);
        checkBoxPanel.add(this.sourceTypeCheckBox[1]);
        panel.add(checkBoxPanel);
        this.gridPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 3));
        checkBoxPanel.setAlignmentX(0.5f);
        this.sourceTypeImage[1] = new JLabel(new ImageIcon(Manager.getResource("icons/hdac_logo.png")));
        this.sourceTypeImage[1].setDisabledIcon(new ImageIcon(Manager.getResource("icons/hdac_logo_disabled.png")));
        this.sourceTypeImage[1].setAlignmentX(0.5f);
        this.sourceTypeCheckBox[2] = new JCheckBox("Video");
        this.sourceTypeCheckBox[2].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[2].addActionListener(cbal);
        this.sourceTypeCheckBox[3] = new JCheckBox("Audio");
        this.sourceTypeCheckBox[3].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[3].addActionListener(cbal);
        panel.add(this.sourceTypeImage[1]);
        panel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        checkBoxPanel.add(this.sourceTypeCheckBox[2]);
        checkBoxPanel.add(this.sourceTypeCheckBox[3]);
        panel.add(checkBoxPanel);
        this.gridPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 3));
        checkBoxPanel.setAlignmentX(0.5f);
        this.sourceTypeImage[2] = new JLabel(new ImageIcon(Manager.getResource("icons/bd_logo.png")));
        this.sourceTypeImage[2].setDisabledIcon(new ImageIcon(Manager.getResource("icons/bd_logo_disabled.png")));
        this.sourceTypeImage[2].setAlignmentX(0.5f);
        this.sourceTypeCheckBox[4] = new JCheckBox("BDMV");
        this.sourceTypeCheckBox[4].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[4].addActionListener(cbal);
        this.sourceTypeCheckBox[5] = new JCheckBox("BDAV");
        this.sourceTypeCheckBox[5].setAlignmentX(0.0f);
        this.sourceTypeCheckBox[5].addActionListener(cbal);
        panel.add(this.sourceTypeImage[2]);
        panel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        checkBoxPanel.add(this.sourceTypeCheckBox[4]);
        checkBoxPanel.add(this.sourceTypeCheckBox[5]);
        panel.add(checkBoxPanel);
        this.gridPanel.add(panel);
        this.gridPanel.setPreferredSize(this.gridPanel.getMinimumSize());
        this.gridPanel.setMaximumSize(new Dimension(this.gridPanel.getMaximumSize().width, this.gridPanel.getPreferredSize().height));
        sourcePanel.add(this.gridPanel);
        int i2 = 0;
        while (i2 < this.sourceTypeImage.length) {
            this.sourceTypeImage[i2].setEnabled(false);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.sourceTypeCheckBox.length) {
            this.sourceTypeCheckBox[i2].setEnabled(false);
            this.sourceTypeSelectable[i2] = false;
            this.discSets[i2] = null;
            ++i2;
        }
        controlPanel.add(sourcePanel);
        this.sourceChooser = new JFileChooser();
        this.sourceChooser.setFileSelectionMode(1);
        this.sourceChooser.setMultiSelectionEnabled(false);
        panel = new JPanel();
        panel.setBorder(Manager.createTitledBorder("Destination"));
        panel.setLayout(new BoxLayout(panel, 2));
        this.destinationLabel = new JLabel(NO_DESTINATION_SET);
        this.destinationLabel.setBorder(Manager.createLabelBorder());
        this.destinationLabel.setToolTipText(NO_DESTINATION_SET);
        this.destinationButton = new JButton(BROWSE);
        this.destinationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = MainFrame.this.destinationChooser.showSaveDialog(MainFrame.this.mainFrame);
                if (returnVal == 0) {
                    MainFrame.this.destinationDirectory = MainFrame.this.destinationChooser.getSelectedFile().getAbsoluteFile();
                    String selectedFilePath = MainFrame.this.destinationDirectory.getPath();
                    MainFrame.this.destinationLabel.setText(selectedFilePath);
                    MainFrame.this.destinationLabel.setToolTipText(selectedFilePath);
                    int i = 0;
                    while (i < MainFrame.this.discSets.length) {
                        if (MainFrame.this.discSets[i] != null) {
                            ((MainFrame)MainFrame.this).discSets[i].dstDir = MainFrame.this.destinationDirectory;
                        }
                        ++i;
                    }
                    MainFrame.this.updateDumpButtonEnabledState();
                }
            }
        });
        Manager.equalizeLabelButtonHeight(this.destinationLabel, this.destinationButton);
        panel.add(this.destinationLabel);
        panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_BIG_SPACING));
        panel.add(this.destinationButton);
        controlPanel.add(panel);
        controlPanel.add(Box.createVerticalGlue());
        controlPanel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        this.destinationChooser = new JFileChooser();
        this.destinationChooser.setFileSelectionMode(1);
        this.destinationChooser.setMultiSelectionEnabled(false);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        this.dumpButton = new JButton(DUMP);
        this.dumpButton.setEnabled(false);
        this.dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagedJob workload = new ManagedJob(){

                    @Override
                    public Object run(Object input) {
                        MainFrame.this.manager.getDumpHD().dumpSource();
                        return null;
                    }
                };
                ManagedJob guiJob = new ManagedJob(){

                    @Override
                    public Object run(Object input) {
                        MainFrame.this.unlock();
                        return null;
                    }
                };
                MainFrame.this.lock();
                MainFrame.this.manager.execute(workload, guiJob);
            }
        });
        panel.add(this.dumpButton);
        controlPanel.add(panel);
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.setOpaque(true);
        viewPanel.setBorder(Manager.createEmptyBorder());
        this.tabPane = new JTabbedPane(1, 1);
        this.tabPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        SourceTab tab = new SourceTab(manager);
        this.sourceTabs.add(tab);
        this.tabPane.addTab(tab.getTabTitle(), tab.getTabIcon(), tab.getTabComponent());
        viewPanel.add((Component)this.tabPane, "Center");
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setOpaque(true);
        menuBar = new JMenuBar();
        menu = new JMenu("Log");
        menuItem = new JMenuItem("Clear");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Document logDocument = MainFrame.this.logArea.getDocument();
                try {
                    logDocument.remove(0, logDocument.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        logPanel.add((Component)menuBar, "First");
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.logArea, 22, 30);
        scrollPane.setMinimumSize(new Dimension(64, 64));
        logPanel.add((Component)scrollPane, "Center");
        this.out = new TextAreaMessagePrinter();
        this.horizontalSplitPane = new JSplitPane(1, true);
        this.horizontalSplitPane.setResizeWeight(0.75);
        this.verticalSplitPane = new JSplitPane(0, true);
        this.verticalSplitPane.setResizeWeight(0.25);
        this.horizontalSplitPane.setLeftComponent(viewPanel);
        this.horizontalSplitPane.setRightComponent(controlPanel);
        this.verticalSplitPane.setTopComponent(this.horizontalSplitPane);
        this.verticalSplitPane.setBottomComponent(logPanel);
        this.mainFrame.setContentPane(this.verticalSplitPane);
        this.mainFrame.setSize(800, 600);
    }

    public void show() {
        this.mainFrame.setVisible(true);
    }

    public void dispose() {
        this.mainFrame.dispose();
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    private void close() {
        int returnVal;
        if (this.manager.isWorking() && (returnVal = JOptionPane.showConfirmDialog(this.mainFrame, "There is currently an operation running, exit anyway?", "Question", 2, 3)) != 0) {
            return;
        }
        this.manager.exit();
    }

    public MessagePrinter getMessagePrinter() {
        return this.out;
    }

    public void init(Collection<DiscSet> discSets) {
        int i = discSets.size() - this.sourceTabs.size();
        while (i > 0) {
            this.sourceTabs.add(new SourceTab(this.manager));
            --i;
        }
        boolean firstTab = true;
        Iterator<DiscSet> dsIt = discSets.iterator();
        Iterator tabIt = this.sourceTabs.iterator();
        while (dsIt.hasNext()) {
            DiscSet ds = dsIt.next();
            SourceTab tab = (SourceTab)tabIt.next();
            if (!ds.isRecordable()) {
                this.discSets[ds.contentType - 1] = ds;
            } else {
                this.discSets[ds.contentType - 2] = ds;
            }
            if (this.destinationDirectory != null) {
                ds.dstDir = this.destinationDirectory;
            }
            if (!ds.isRecordable()) {
                this.sourceTypeImage[(ds.contentType - 1) / 2].setEnabled(true);
                this.sourceTypeCheckBox[ds.contentType - 1].setSelected(ds.selected);
                this.sourceTypeSelectable[ds.contentType - 1] = ds.selected;
            } else {
                this.sourceTypeImage[(ds.contentType - 2) / 2].setEnabled(true);
                this.sourceTypeCheckBox[ds.contentType - 2].setSelected(ds.selected);
                this.sourceTypeSelectable[ds.contentType - 2] = ds.selected;
            }
            if (ds.selected) {
                ++this.sourceTypesSelected;
            }
            tab.init(ds);
            if (firstTab) {
                firstTab = false;
                this.tabPane.setTitleAt(0, tab.getTabTitle());
                this.tabPane.setIconAt(0, tab.getTabIcon());
                continue;
            }
            this.tabPane.addTab(tab.getTabTitle(), tab.getTabIcon(), tab.getTabComponent());
        }
        this.updateEnabledState(false);
        this.updateDumpButtonEnabledState();
    }

    public void clear() {
        int tabsInPane = this.tabPane.getTabCount();
        Iterator tabIt = this.sourceTabs.iterator();
        int i = 0;
        while (i < tabsInPane) {
            SourceTab tab = (SourceTab)tabIt.next();
            tab.clear();
            if (i != 0) {
                tabIt.remove();
                this.tabPane.removeTabAt(i);
            } else {
                this.tabPane.setTitleAt(0, tab.getTabTitle());
                this.tabPane.setIconAt(0, tab.getTabIcon());
            }
            ++i;
        }
        i = 0;
        while (i < this.sourceTypeCheckBox.length) {
            this.sourceTypeCheckBox[i].setSelected(false);
            this.sourceTypeSelectable[i] = false;
            this.discSets[i] = null;
            ++i;
        }
        this.sourceTypesSelected = 0;
        i = 0;
        while (i < this.sourceTypeImage.length) {
            this.sourceTypeImage[i].setEnabled(false);
            ++i;
        }
        this.updateEnabledState(false);
        this.updateDumpButtonEnabledState();
    }

    private void updateDumpButtonEnabledState() {
        if (!this.locked) {
            if (this.destinationDirectory != null && this.sourceTypesSelected > 0) {
                if (!this.dumpButton.isEnabled()) {
                    this.dumpButton.setEnabled(true);
                }
            } else if (this.dumpButton.isEnabled()) {
                this.dumpButton.setEnabled(false);
            }
        }
    }

    private void updateEnabledState(boolean forced) {
        if (!this.locked) {
            int i = 0;
            while (i < this.sourceTypeCheckBox.length) {
                this.sourceTypeCheckBox[i].setEnabled(this.sourceTypeSelectable[i]);
                ++i;
            }
            if (forced) {
                this.sourceButton.setEnabled(true);
                this.destinationButton.setEnabled(true);
                this.updateDumpButtonEnabledState();
            }
        } else if (forced) {
            int i = 0;
            while (i < this.sourceTypeCheckBox.length) {
                this.sourceTypeCheckBox[i].setEnabled(false);
                ++i;
            }
            this.sourceButton.setEnabled(false);
            this.destinationButton.setEnabled(false);
            this.dumpButton.setEnabled(false);
        }
    }

    public void lock() {
        this.locked = true;
        this.updateEnabledState(true);
        Iterator it = this.sourceTabs.iterator();
        while (it.hasNext()) {
            ((SourceTab)it.next()).lock();
        }
    }

    public void unlock() {
        this.locked = false;
        this.updateEnabledState(true);
        Iterator it = this.sourceTabs.iterator();
        while (it.hasNext()) {
            ((SourceTab)it.next()).unlock();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void updateFixedSizedComponentsSize() {
        this.sourceLabel.setMinimumSize(null);
        this.sourceLabel.setMaximumSize(null);
        this.sourceLabel.setPreferredSize(null);
        this.sourceButton.setMinimumSize(null);
        this.sourceButton.setMaximumSize(null);
        this.sourceButton.setPreferredSize(null);
        Manager.equalizeLabelButtonHeight(this.sourceLabel, this.sourceButton);
        this.gridPanel.setMaximumSize(null);
        this.gridPanel.setPreferredSize(null);
        this.gridPanel.setPreferredSize(this.gridPanel.getMinimumSize());
        this.gridPanel.setMaximumSize(new Dimension(this.gridPanel.getMaximumSize().width, this.gridPanel.getPreferredSize().height));
        this.destinationLabel.setMinimumSize(null);
        this.destinationLabel.setMaximumSize(null);
        this.destinationLabel.setPreferredSize(null);
        this.destinationButton.setMinimumSize(null);
        this.destinationButton.setMaximumSize(null);
        this.destinationButton.setPreferredSize(null);
        Manager.equalizeLabelButtonHeight(this.destinationLabel, this.destinationButton);
        this.sourceButton.invalidate();
        this.destinationButton.invalidate();
        this.gridPanel.invalidate();
        Iterator it = this.sourceTabs.iterator();
        while (it.hasNext()) {
            ((SourceTab)it.next()).updateFixedSizedComponentsSize();
        }
    }

    private class LafActionListener
    implements ActionListener {
        private LafActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lafClassName = e.getActionCommand();
            try {
                UIManager.setLookAndFeel(lafClassName);
                SwingUtilities.updateComponentTreeUI(MainFrame.this.mainFrame);
                SwingUtilities.updateComponentTreeUI(MainFrame.this.sourceChooser);
                SwingUtilities.updateComponentTreeUI(MainFrame.this.destinationChooser);
                MainFrame.this.logArea.setCaretPosition(MainFrame.this.logArea.getDocument().getLength());
                MainFrame.this.updateFixedSizedComponentsSize();
                MainFrame.this.horizontalSplitPane.resetToPreferredSizes();
                MainFrame.this.verticalSplitPane.resetToPreferredSizes();
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MainFrameWindowAdapter
    extends WindowAdapter {
        private MainFrameWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MainFrame.this.close();
        }
    }

    private class SourceTypeCheckBoxActionListener
    implements ActionListener {
        private SourceTypeCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            boolean selected = source.isSelected();
            if (selected) {
                MainFrame mainFrame = MainFrame.this;
                mainFrame.sourceTypesSelected = mainFrame.sourceTypesSelected + 1;
            } else {
                MainFrame mainFrame = MainFrame.this;
                mainFrame.sourceTypesSelected = mainFrame.sourceTypesSelected - 1;
            }
            int i = 0;
            while (i < MainFrame.this.sourceTypeCheckBox.length) {
                if (source == MainFrame.this.sourceTypeCheckBox[i]) {
                    ((MainFrame)MainFrame.this).discSets[i].selected = selected;
                    break;
                }
                ++i;
            }
            MainFrame.this.updateDumpButtonEnabledState();
        }
    }

    private class TextAreaMessagePrinter
    implements MessagePrinter {
        private TextAreaMessagePrinter() {
        }

        @Override
        public void print(final String msg) {
            Runnable runMe = new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.logArea.append(msg);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runMe.run();
            } else {
                SwingUtilities.invokeLater(runMe);
            }
        }

        @Override
        public void println() {
            Runnable runMe = new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.logArea.append("\n");
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runMe.run();
            } else {
                SwingUtilities.invokeLater(runMe);
            }
        }

        @Override
        public void println(final String msg) {
            Runnable runMe = new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.logArea.append(msg);
                    MainFrame.this.logArea.append("\n");
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runMe.run();
            } else {
                SwingUtilities.invokeLater(runMe);
            }
        }
    }
}

