/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/src/Logger.cc
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and Ren Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */
#include "Logger.hh"
#include <time.h>
#include <iostream>

namespace Utility
{ // Exports
  bool basic_log_device_initialized = false;
  extern BasicLogDevice::timestamp_t BasicLogDevice::current;
  extern BasicLogDevice::direction BasicLogDevice::last_direction;
  extern BasicLogDevice* BasicLogDevice::last_device;
  std::ostream& wrap_cout = std::cout;
  std::ostream& wrap_cerr = std::cerr;
}

using namespace Utility;

BasicLogDevice::BasicLogDevice ()
{
  if (!basic_log_device_initialized)
    {
      current = true;
      last_device = this;
      basic_log_device_initialized = true;
    }
}

void BasicLogDevice::PrintPrelude ()
{
  time_t t;
  time (&t);
  (*log_file) << "log opened " << ctime(&t) << std::endl;
}

void BasicLogDevice::PrintTimeStamp (std::ostream* str)
{
  (*str) << "[@t" << current++ << "] ";
}

void BasicLogDevice::AllocateSplitStreams ()
{
  split_buffer_cout = new SplitStreamBuffer (std::cout, *log_file);
  split_buffer_cerr = new SplitStreamBuffer (std::cerr, *log_file);
  split_stream_cout = new std::ostream (split_buffer_cout);
  split_stream_cerr = new std::ostream (split_buffer_cerr);
}

void BasicLogDevice::DeallocateSplitStreams ()
{
  delete split_stream_cout;
  delete split_stream_cerr;
  delete split_buffer_cout;
  delete split_buffer_cerr;
}

