/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1991-1994, 1998-2000, 2002, 2008, 2010 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#include <common/ac/stdlib.h>
#include <libexplain/output.h>

#include <common/error.h>

/*
 *  NAME
 *      assert - make an assertion
 *
 *  SYNOPSIS
 *      void assert(int condition);
 *
 *  DESCRIPTION
 *      Assert is a handy tool for a programmer to guarantee the internal
 *      consistency of their program. If "-DDEBUG" is specified on
 *      the compiler's command line, then assert will generate code to verify
 *      the assertios made. If no DEBUG is defined, assertions will generate
 *      no code.
 *
 *  CAVEAT
 *      If the assertion fails, a fatal diagnostic is issued.
 *
 *      The #define's which control the compilation may be found in "error.h".
 *
 */

#ifdef my_assert
#undef my_assert
#endif

void
my_assert(int c, char *s, char *file, int line)
{
    if (c)
        return;
    explain_output_error
    (
        "%s: %d: assertion \"%s\" failed (bug)",
        file,
        line,
        s
    );
    abort();
}
