drop database if exists lrc1000;
create database lrc1000;

use lrc1000;

create table t_lfn (
  id int not null auto_increment primary key,
  name varchar(500) not null,
  ref int default 0 not null
) type = innodb;
create unique index t_lfn_name on t_lfn(name);

create table t_pfn (
  id int not null auto_increment primary key,
  name varchar(500) not null,
  ref int default 0 not null
) type = innodb;
create unique index t_pfn_name on t_pfn(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  pfn_id int not null references t_pfn(id)
) type = innodb;
alter table t_map add constraint pk_map primary key(lfn_id, pfn_id);
create index t_map_pfn_id on t_map(pfn_id);

create table t_rli (
  id int not null auto_increment primary key,
  flags int default 0 not null,
  name varchar(500) not null
) type = innodb;
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(500) not null
) type = innodb;
alter table t_rlipartition add constraint pk_rlipartition primary key(rli_id, pattern);
create index t_rlipartition_pattern on t_rlipartition(pattern);

create table t_attribute (
  id int not null auto_increment primary key,
  name varchar(500) not null,
  objtype int not null,
  type int not null
) type = innodb;
create unique index t_attribute_name_objtype on t_attribute(name, objtype);

create table t_date_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value timestamp not null
) type = innodb;
create index t_date_attr_attr_id on t_date_attr(attr_id);
create index t_date_attr_value on t_date_attr(value);
create unique index t_date_obj_id_attr_id on t_date_attr(obj_id, attr_id);

create table t_flt_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value float not null
) type = innodb;
create index t_flt_attr_attr_id on t_flt_attr(attr_id);
create index t_flt_attr_value on t_flt_attr(value);
create unique index t_flt_obj_id_attr_id on t_flt_attr(obj_id, attr_id);

create table t_int_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value int not null
) type = innodb;
create index t_int_attr_attr_id on t_int_attr(attr_id);
create index t_int_attr_value on t_int_attr(value);
create unique index t_int_obj_id_attr_id on t_int_attr(obj_id, attr_id);

create table t_str_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value varchar(500) not null
) type = innodb;
create index t_str_attr_attr_id on t_str_attr(attr_id);
create index t_str_attr_value on t_str_attr(value);
create unique index t_str_obj_id_attr_id on t_str_attr(obj_id, attr_id);
