package vmware

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/vmware/mgmt/2019-08-09-preview/vmware"

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// Cancelled ...
	Cancelled ClusterProvisioningState = "Cancelled"
	// Failed ...
	Failed ClusterProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ClusterProvisioningState = "Succeeded"
	// Updating ...
	Updating ClusterProvisioningState = "Updating"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{Cancelled, Failed, Succeeded, Updating}
}

// InternetEnum enumerates the values for internet enum.
type InternetEnum string

const (
	// Disabled ...
	Disabled InternetEnum = "Disabled"
	// Enabled ...
	Enabled InternetEnum = "Enabled"
)

// PossibleInternetEnumValues returns an array of possible values for the InternetEnum const type.
func PossibleInternetEnumValues() []InternetEnum {
	return []InternetEnum{Disabled, Enabled}
}

// PrivateCloudProvisioningState enumerates the values for private cloud provisioning state.
type PrivateCloudProvisioningState string

const (
	// PrivateCloudProvisioningStateBuilding ...
	PrivateCloudProvisioningStateBuilding PrivateCloudProvisioningState = "Building"
	// PrivateCloudProvisioningStateCancelled ...
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = "Cancelled"
	// PrivateCloudProvisioningStateFailed ...
	PrivateCloudProvisioningStateFailed PrivateCloudProvisioningState = "Failed"
	// PrivateCloudProvisioningStatePending ...
	PrivateCloudProvisioningStatePending PrivateCloudProvisioningState = "Pending"
	// PrivateCloudProvisioningStateSucceeded ...
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = "Succeeded"
	// PrivateCloudProvisioningStateUpdating ...
	PrivateCloudProvisioningStateUpdating PrivateCloudProvisioningState = "Updating"
)

// PossiblePrivateCloudProvisioningStateValues returns an array of possible values for the PrivateCloudProvisioningState const type.
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return []PrivateCloudProvisioningState{PrivateCloudProvisioningStateBuilding, PrivateCloudProvisioningStateCancelled, PrivateCloudProvisioningStateFailed, PrivateCloudProvisioningStatePending, PrivateCloudProvisioningStateSucceeded, PrivateCloudProvisioningStateUpdating}
}

// QuotaEnabled enumerates the values for quota enabled.
type QuotaEnabled string

const (
	// QuotaEnabledDisabled ...
	QuotaEnabledDisabled QuotaEnabled = "Disabled"
	// QuotaEnabledEnabled ...
	QuotaEnabledEnabled QuotaEnabled = "Enabled"
)

// PossibleQuotaEnabledValues returns an array of possible values for the QuotaEnabled const type.
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return []QuotaEnabled{QuotaEnabledDisabled, QuotaEnabledEnabled}
}

// SslEnum enumerates the values for ssl enum.
type SslEnum string

const (
	// SslEnumDisabled ...
	SslEnumDisabled SslEnum = "Disabled"
	// SslEnumEnabled ...
	SslEnumEnabled SslEnum = "Enabled"
)

// PossibleSslEnumValues returns an array of possible values for the SslEnum const type.
func PossibleSslEnumValues() []SslEnum {
	return []SslEnum{SslEnumDisabled, SslEnumEnabled}
}

// Status enumerates the values for status.
type Status string

const (
	// TrialAvailable ...
	TrialAvailable Status = "TrialAvailable"
	// TrialDisabled ...
	TrialDisabled Status = "TrialDisabled"
	// TrialUsed ...
	TrialUsed Status = "TrialUsed"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{TrialAvailable, TrialDisabled, TrialUsed}
}

// AdminCredentials administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	autorest.Response `json:"-"`
	// NsxtUsername - READ-ONLY; NSX-T Manager username
	NsxtUsername *string `json:"nsxtUsername,omitempty"`
	// NsxtPassword - READ-ONLY; NSX-T Manager password
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterUsername - READ-ONLY; vCenter admin username
	VcenterUsername *string `json:"vcenterUsername,omitempty"`
	// VcenterPassword - READ-ONLY; vCenter admin password
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
}

// APIError API error response
type APIError struct {
	// Error - An error returned by the API
	Error *APIErrorBase `json:"error,omitempty"`
}

// APIErrorBase api error.
type APIErrorBase struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message *string `json:"message,omitempty"`
}

// Circuit an ExpressRoute Circuit
type Circuit struct {
	// PrimarySubnet - READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string `json:"primarySubnet,omitempty"`
	// SecondarySubnet - READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string `json:"secondarySubnet,omitempty"`
	// ExpressRouteID - READ-ONLY; Identifier of the ExpressRoute (Microsoft Colo only)
	ExpressRouteID *string `json:"expressRouteID,omitempty"`
	// Authorizations - Authorizations for the ExpressRoute (Microsoft Colo only)
	Authorizations *[]ExpressRouteAuthorization `json:"authorizations,omitempty"`
	// ExpressRoutePrivatePeeringID - READ-ONLY; ExpressRoute private peering identifier
	ExpressRoutePrivatePeeringID *string `json:"expressRoutePrivatePeeringID,omitempty"`
}

// Cluster a cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// Properties - The properties of a cluster resource
	Properties *ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ClusterList a paged list of clusters
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{fn: getNextPage}
}

// ClusterProperties the properties of a cluster
type ClusterProperties struct {
	// ProvisioningState - READ-ONLY; The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateOrUpdateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "vmware.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersDeleteFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersUpdateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "vmware.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DefaultClusterProperties the properties of a default cluster
type DefaultClusterProperties struct {
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// Endpoints endpoint addresses
type Endpoints struct {
	// NsxtManager - READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string `json:"nsxtManager,omitempty"`
	// Vcsa - READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string `json:"vcsa,omitempty"`
}

// ExpressRouteAuthorization authorization for an ExpressRoute
type ExpressRouteAuthorization struct {
	// Name - The name of the ExpressRoute
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the ExpressRoute
	ID *string `json:"id,omitempty"`
	// Key - READ-ONLY; The key of the ExpressRoute
	Key *string `json:"key,omitempty"`
}

// IdentitySource vCenter Single Sign On Identity Source
type IdentitySource struct {
	// Name - The name of the identity source
	Name *string `json:"name,omitempty"`
	// Alias - The domain's NetBIOS name
	Alias *string `json:"alias,omitempty"`
	// Domain - The domain's dns name
	Domain *string `json:"domain,omitempty"`
	// BaseUserDN - The base distinguished name for users
	BaseUserDN *string `json:"baseUserDN,omitempty"`
	// BaseGroupDN - The base distinguished name for groups
	BaseGroupDN *string `json:"baseGroupDN,omitempty"`
	// PrimaryServer - Primary server URL
	PrimaryServer *string `json:"primaryServer,omitempty"`
	// SecondaryServer - Secondary server URL
	SecondaryServer *string `json:"secondaryServer,omitempty"`
	// Ssl - Protect LDAP communication using SSL certificate (LDAPS). Possible values include: 'SslEnumEnabled', 'SslEnumDisabled'
	Ssl SslEnum `json:"ssl,omitempty"`
	// Username - The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string `json:"username,omitempty"`
	// Password - The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string `json:"password,omitempty"`
}

// Operation a REST API operation
type Operation struct {
	// Name - READ-ONLY; Name of the operation being performed on this object
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay contains the localized display information for this operation
type OperationDisplay struct {
	// Provider - READ-ONLY; Localized friendly form of the resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationList pageable list of operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// PrivateCloud a private cloud resource
type PrivateCloud struct {
	autorest.Response `json:"-"`
	// Sku - The private cloud SKU
	Sku *Sku `json:"sku,omitempty"`
	// Properties - The properties of a private cloud resource
	Properties *PrivateCloudProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloud.
func (pc PrivateCloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Sku != nil {
		objectMap["sku"] = pc.Sku
	}
	if pc.Properties != nil {
		objectMap["properties"] = pc.Properties
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	if pc.Tags != nil {
		objectMap["tags"] = pc.Tags
	}
	return json.Marshal(objectMap)
}

// PrivateCloudList a paged list of private clouds
type PrivateCloudList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]PrivateCloud `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateCloudListIterator provides access to a complete listing of PrivateCloud values.
type PrivateCloudListIterator struct {
	i    int
	page PrivateCloudListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateCloudListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateCloudListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateCloudListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateCloudListIterator) Response() PrivateCloudList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateCloudListIterator) Value() PrivateCloud {
	if !iter.page.NotDone() {
		return PrivateCloud{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateCloudListIterator type.
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return PrivateCloudListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcl PrivateCloudList) IsEmpty() bool {
	return pcl.Value == nil || len(*pcl.Value) == 0
}

// privateCloudListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcl PrivateCloudList) privateCloudListPreparer(ctx context.Context) (*http.Request, error) {
	if pcl.NextLink == nil || len(to.String(pcl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcl.NextLink)))
}

// PrivateCloudListPage contains a page of PrivateCloud values.
type PrivateCloudListPage struct {
	fn  func(context.Context, PrivateCloudList) (PrivateCloudList, error)
	pcl PrivateCloudList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateCloudListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcl)
	if err != nil {
		return err
	}
	page.pcl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateCloudListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateCloudListPage) NotDone() bool {
	return !page.pcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateCloudListPage) Response() PrivateCloudList {
	return page.pcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateCloudListPage) Values() []PrivateCloud {
	if page.pcl.IsEmpty() {
		return nil
	}
	return *page.pcl.Value
}

// Creates a new instance of the PrivateCloudListPage type.
func NewPrivateCloudListPage(getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return PrivateCloudListPage{fn: getNextPage}
}

// PrivateCloudProperties the properties of a private cloud resource
type PrivateCloudProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PrivateCloudProvisioningStateSucceeded', 'PrivateCloudProvisioningStateFailed', 'PrivateCloudProvisioningStateCancelled', 'PrivateCloudProvisioningStatePending', 'PrivateCloudProvisioningStateBuilding', 'PrivateCloudProvisioningStateUpdating'
	ProvisioningState PrivateCloudProvisioningState `json:"provisioningState,omitempty"`
	// Circuit - An ExpressRoute Circuit
	Circuit *Circuit `json:"circuit,omitempty"`
	// Cluster - The default cluster used for management
	Cluster *DefaultClusterProperties `json:"cluster,omitempty"`
	// Clusters - READ-ONLY; The clusters
	Clusters *[]string `json:"clusters,omitempty"`
	// Endpoints - READ-ONLY; The endpoints
	Endpoints *Endpoints `json:"endpoints,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
	// NetworkBlock - The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
	NetworkBlock *string `json:"networkBlock,omitempty"`
	// ManagementNetwork - READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string `json:"managementNetwork,omitempty"`
	// ProvisioningNetwork - READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string `json:"provisioningNetwork,omitempty"`
	// VmotionNetwork - READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string `json:"vmotionNetwork,omitempty"`
	// VcenterPassword - Optionally, set the vCenter admin password when the private cloud is created
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
	// NsxtPassword - Optionally, set the NSX-T Manager password when the private cloud is created
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterCertificateThumbprint - READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string `json:"vcenterCertificateThumbprint,omitempty"`
	// NsxtCertificateThumbprint - READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string `json:"nsxtCertificateThumbprint,omitempty"`
}

// PrivateCloudsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateCloudsCreateOrUpdateFuture) Result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.PrivateCloudsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.PrivateCloudsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.CreateOrUpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "vmware.PrivateCloudsCreateOrUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateCloudsDeleteFuture) Result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.PrivateCloudsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.PrivateCloudsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateCloudsUpdateFuture) Result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmware.PrivateCloudsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("vmware.PrivateCloudsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.UpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "vmware.PrivateCloudsUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Quota subscription quotas
type Quota struct {
	autorest.Response `json:"-"`
	// HostsRemaining - READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32 `json:"hostsRemaining"`
	// QuotaEnabled - Host quota is active for current subscription. Possible values include: 'QuotaEnabledEnabled', 'QuotaEnabledDisabled'
	QuotaEnabled QuotaEnabled `json:"quotaEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for Quota.
func (q Quota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.QuotaEnabled != "" {
		objectMap["quotaEnabled"] = q.QuotaEnabled
	}
	return json.Marshal(objectMap)
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Trial subscription trial availability
type Trial struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; Trial status. Possible values include: 'TrialAvailable', 'TrialUsed', 'TrialDisabled'
	Status Status `json:"status,omitempty"`
	// AvailableHosts - READ-ONLY; Number of trial hosts available
	AvailableHosts *int32 `json:"availableHosts,omitempty"`
}
