package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/avs/mgmt/2021-12-01/avs"

// Addon an addon resource
type Addon struct {
	autorest.Response `json:"-"`
	// Properties - The properties of an addon resource
	Properties BasicAddonProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Addon.
func (a Addon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = a.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Addon struct.
func (a *Addon) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicAddonProperties(*v)
				if err != nil {
					return err
				}
				a.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AddonHcxProperties the properties of an HCX addon
type AddonHcxProperties struct {
	// Offer - The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
	Offer *string `json:"offer,omitempty"`
	// ProvisioningState - READ-ONLY; The state of the addon provisioning. Possible values include: 'AddonProvisioningStateSucceeded', 'AddonProvisioningStateFailed', 'AddonProvisioningStateCancelled', 'AddonProvisioningStateBuilding', 'AddonProvisioningStateDeleting', 'AddonProvisioningStateUpdating'
	ProvisioningState AddonProvisioningState `json:"provisioningState,omitempty"`
	// AddonType - Possible values include: 'AddonTypeAddonProperties', 'AddonTypeSRM', 'AddonTypeVR', 'AddonTypeHCX'
	AddonType AddonType `json:"addonType,omitempty"`
}

// MarshalJSON is the custom marshaler for AddonHcxProperties.
func (ahp AddonHcxProperties) MarshalJSON() ([]byte, error) {
	ahp.AddonType = AddonTypeHCX
	objectMap := make(map[string]interface{})
	if ahp.Offer != nil {
		objectMap["offer"] = ahp.Offer
	}
	if ahp.AddonType != "" {
		objectMap["addonType"] = ahp.AddonType
	}
	return json.Marshal(objectMap)
}

// AsAddonSrmProperties is the BasicAddonProperties implementation for AddonHcxProperties.
func (ahp AddonHcxProperties) AsAddonSrmProperties() (*AddonSrmProperties, bool) {
	return nil, false
}

// AsAddonVrProperties is the BasicAddonProperties implementation for AddonHcxProperties.
func (ahp AddonHcxProperties) AsAddonVrProperties() (*AddonVrProperties, bool) {
	return nil, false
}

// AsAddonHcxProperties is the BasicAddonProperties implementation for AddonHcxProperties.
func (ahp AddonHcxProperties) AsAddonHcxProperties() (*AddonHcxProperties, bool) {
	return &ahp, true
}

// AsAddonProperties is the BasicAddonProperties implementation for AddonHcxProperties.
func (ahp AddonHcxProperties) AsAddonProperties() (*AddonProperties, bool) {
	return nil, false
}

// AsBasicAddonProperties is the BasicAddonProperties implementation for AddonHcxProperties.
func (ahp AddonHcxProperties) AsBasicAddonProperties() (BasicAddonProperties, bool) {
	return &ahp, true
}

// AddonList a paged list of addons
type AddonList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Addon `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AddonList.
func (al AddonList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AddonListIterator provides access to a complete listing of Addon values.
type AddonListIterator struct {
	i    int
	page AddonListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AddonListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddonListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AddonListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AddonListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AddonListIterator) Response() AddonList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AddonListIterator) Value() Addon {
	if !iter.page.NotDone() {
		return Addon{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AddonListIterator type.
func NewAddonListIterator(page AddonListPage) AddonListIterator {
	return AddonListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AddonList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AddonList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// addonListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AddonList) addonListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AddonListPage contains a page of Addon values.
type AddonListPage struct {
	fn func(context.Context, AddonList) (AddonList, error)
	al AddonList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AddonListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddonListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AddonListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AddonListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AddonListPage) Response() AddonList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AddonListPage) Values() []Addon {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AddonListPage type.
func NewAddonListPage(cur AddonList, getNextPage func(context.Context, AddonList) (AddonList, error)) AddonListPage {
	return AddonListPage{
		fn: getNextPage,
		al: cur,
	}
}

// BasicAddonProperties the properties of an addon
type BasicAddonProperties interface {
	AsAddonSrmProperties() (*AddonSrmProperties, bool)
	AsAddonVrProperties() (*AddonVrProperties, bool)
	AsAddonHcxProperties() (*AddonHcxProperties, bool)
	AsAddonProperties() (*AddonProperties, bool)
}

// AddonProperties the properties of an addon
type AddonProperties struct {
	// ProvisioningState - READ-ONLY; The state of the addon provisioning. Possible values include: 'AddonProvisioningStateSucceeded', 'AddonProvisioningStateFailed', 'AddonProvisioningStateCancelled', 'AddonProvisioningStateBuilding', 'AddonProvisioningStateDeleting', 'AddonProvisioningStateUpdating'
	ProvisioningState AddonProvisioningState `json:"provisioningState,omitempty"`
	// AddonType - Possible values include: 'AddonTypeAddonProperties', 'AddonTypeSRM', 'AddonTypeVR', 'AddonTypeHCX'
	AddonType AddonType `json:"addonType,omitempty"`
}

func unmarshalBasicAddonProperties(body []byte) (BasicAddonProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["addonType"] {
	case string(AddonTypeSRM):
		var asp AddonSrmProperties
		err := json.Unmarshal(body, &asp)
		return asp, err
	case string(AddonTypeVR):
		var avp AddonVrProperties
		err := json.Unmarshal(body, &avp)
		return avp, err
	case string(AddonTypeHCX):
		var ahp AddonHcxProperties
		err := json.Unmarshal(body, &ahp)
		return ahp, err
	default:
		var ap AddonProperties
		err := json.Unmarshal(body, &ap)
		return ap, err
	}
}
func unmarshalBasicAddonPropertiesArray(body []byte) ([]BasicAddonProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	apArray := make([]BasicAddonProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ap, err := unmarshalBasicAddonProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		apArray[index] = ap
	}
	return apArray, nil
}

// MarshalJSON is the custom marshaler for AddonProperties.
func (ap AddonProperties) MarshalJSON() ([]byte, error) {
	ap.AddonType = AddonTypeAddonProperties
	objectMap := make(map[string]interface{})
	if ap.AddonType != "" {
		objectMap["addonType"] = ap.AddonType
	}
	return json.Marshal(objectMap)
}

// AsAddonSrmProperties is the BasicAddonProperties implementation for AddonProperties.
func (ap AddonProperties) AsAddonSrmProperties() (*AddonSrmProperties, bool) {
	return nil, false
}

// AsAddonVrProperties is the BasicAddonProperties implementation for AddonProperties.
func (ap AddonProperties) AsAddonVrProperties() (*AddonVrProperties, bool) {
	return nil, false
}

// AsAddonHcxProperties is the BasicAddonProperties implementation for AddonProperties.
func (ap AddonProperties) AsAddonHcxProperties() (*AddonHcxProperties, bool) {
	return nil, false
}

// AsAddonProperties is the BasicAddonProperties implementation for AddonProperties.
func (ap AddonProperties) AsAddonProperties() (*AddonProperties, bool) {
	return &ap, true
}

// AsBasicAddonProperties is the BasicAddonProperties implementation for AddonProperties.
func (ap AddonProperties) AsBasicAddonProperties() (BasicAddonProperties, bool) {
	return &ap, true
}

// AddonsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AddonsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AddonsClient) (Addon, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AddonsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AddonsCreateOrUpdateFuture.Result.
func (future *AddonsCreateOrUpdateFuture) result(client AddonsClient) (a Addon, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AddonsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AddonsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.AddonsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AddonsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AddonsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AddonsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AddonsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AddonsDeleteFuture.Result.
func (future *AddonsDeleteFuture) result(client AddonsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AddonsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AddonsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AddonSrmProperties the properties of a Site Recovery Manager (SRM) addon
type AddonSrmProperties struct {
	// LicenseKey - The Site Recovery Manager (SRM) license
	LicenseKey *string `json:"licenseKey,omitempty"`
	// ProvisioningState - READ-ONLY; The state of the addon provisioning. Possible values include: 'AddonProvisioningStateSucceeded', 'AddonProvisioningStateFailed', 'AddonProvisioningStateCancelled', 'AddonProvisioningStateBuilding', 'AddonProvisioningStateDeleting', 'AddonProvisioningStateUpdating'
	ProvisioningState AddonProvisioningState `json:"provisioningState,omitempty"`
	// AddonType - Possible values include: 'AddonTypeAddonProperties', 'AddonTypeSRM', 'AddonTypeVR', 'AddonTypeHCX'
	AddonType AddonType `json:"addonType,omitempty"`
}

// MarshalJSON is the custom marshaler for AddonSrmProperties.
func (asp AddonSrmProperties) MarshalJSON() ([]byte, error) {
	asp.AddonType = AddonTypeSRM
	objectMap := make(map[string]interface{})
	if asp.LicenseKey != nil {
		objectMap["licenseKey"] = asp.LicenseKey
	}
	if asp.AddonType != "" {
		objectMap["addonType"] = asp.AddonType
	}
	return json.Marshal(objectMap)
}

// AsAddonSrmProperties is the BasicAddonProperties implementation for AddonSrmProperties.
func (asp AddonSrmProperties) AsAddonSrmProperties() (*AddonSrmProperties, bool) {
	return &asp, true
}

// AsAddonVrProperties is the BasicAddonProperties implementation for AddonSrmProperties.
func (asp AddonSrmProperties) AsAddonVrProperties() (*AddonVrProperties, bool) {
	return nil, false
}

// AsAddonHcxProperties is the BasicAddonProperties implementation for AddonSrmProperties.
func (asp AddonSrmProperties) AsAddonHcxProperties() (*AddonHcxProperties, bool) {
	return nil, false
}

// AsAddonProperties is the BasicAddonProperties implementation for AddonSrmProperties.
func (asp AddonSrmProperties) AsAddonProperties() (*AddonProperties, bool) {
	return nil, false
}

// AsBasicAddonProperties is the BasicAddonProperties implementation for AddonSrmProperties.
func (asp AddonSrmProperties) AsBasicAddonProperties() (BasicAddonProperties, bool) {
	return &asp, true
}

// AddonVrProperties the properties of a vSphere Replication (VR) addon
type AddonVrProperties struct {
	// VrsCount - The vSphere Replication Server (VRS) count
	VrsCount *int32 `json:"vrsCount,omitempty"`
	// ProvisioningState - READ-ONLY; The state of the addon provisioning. Possible values include: 'AddonProvisioningStateSucceeded', 'AddonProvisioningStateFailed', 'AddonProvisioningStateCancelled', 'AddonProvisioningStateBuilding', 'AddonProvisioningStateDeleting', 'AddonProvisioningStateUpdating'
	ProvisioningState AddonProvisioningState `json:"provisioningState,omitempty"`
	// AddonType - Possible values include: 'AddonTypeAddonProperties', 'AddonTypeSRM', 'AddonTypeVR', 'AddonTypeHCX'
	AddonType AddonType `json:"addonType,omitempty"`
}

// MarshalJSON is the custom marshaler for AddonVrProperties.
func (avp AddonVrProperties) MarshalJSON() ([]byte, error) {
	avp.AddonType = AddonTypeVR
	objectMap := make(map[string]interface{})
	if avp.VrsCount != nil {
		objectMap["vrsCount"] = avp.VrsCount
	}
	if avp.AddonType != "" {
		objectMap["addonType"] = avp.AddonType
	}
	return json.Marshal(objectMap)
}

// AsAddonSrmProperties is the BasicAddonProperties implementation for AddonVrProperties.
func (avp AddonVrProperties) AsAddonSrmProperties() (*AddonSrmProperties, bool) {
	return nil, false
}

// AsAddonVrProperties is the BasicAddonProperties implementation for AddonVrProperties.
func (avp AddonVrProperties) AsAddonVrProperties() (*AddonVrProperties, bool) {
	return &avp, true
}

// AsAddonHcxProperties is the BasicAddonProperties implementation for AddonVrProperties.
func (avp AddonVrProperties) AsAddonHcxProperties() (*AddonHcxProperties, bool) {
	return nil, false
}

// AsAddonProperties is the BasicAddonProperties implementation for AddonVrProperties.
func (avp AddonVrProperties) AsAddonProperties() (*AddonProperties, bool) {
	return nil, false
}

// AsBasicAddonProperties is the BasicAddonProperties implementation for AddonVrProperties.
func (avp AddonVrProperties) AsBasicAddonProperties() (BasicAddonProperties, bool) {
	return &avp, true
}

// AdminCredentials administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	autorest.Response `json:"-"`
	// NsxtUsername - READ-ONLY; NSX-T Manager username
	NsxtUsername *string `json:"nsxtUsername,omitempty"`
	// NsxtPassword - READ-ONLY; NSX-T Manager password
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterUsername - READ-ONLY; vCenter admin username
	VcenterUsername *string `json:"vcenterUsername,omitempty"`
	// VcenterPassword - READ-ONLY; vCenter admin password
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
}

// MarshalJSON is the custom marshaler for AdminCredentials.
func (ac AdminCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (ExpressRouteAuthorization, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsCreateOrUpdateFuture.Result.
func (future *AuthorizationsCreateOrUpdateFuture) result(client AuthorizationsClient) (era ExpressRouteAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		era.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if era.Response.Response, err = future.GetResult(sender); err == nil && era.Response.Response.StatusCode != http.StatusNoContent {
		era, err = client.CreateOrUpdateResponder(era.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", era.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsDeleteFuture.Result.
func (future *AuthorizationsDeleteFuture) result(client AuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AvailabilityProperties the properties describing private cloud availability zone distribution
type AvailabilityProperties struct {
	// Strategy - The availability strategy for the private cloud. Possible values include: 'AvailabilityStrategySingleZone', 'AvailabilityStrategyDualZone'
	Strategy AvailabilityStrategy `json:"strategy,omitempty"`
	// Zone - The primary availability zone for the private cloud
	Zone *int32 `json:"zone,omitempty"`
	// SecondaryZone - The secondary availability zone for the private cloud
	SecondaryZone *int32 `json:"secondaryZone,omitempty"`
}

// Circuit an ExpressRoute Circuit
type Circuit struct {
	// PrimarySubnet - READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string `json:"primarySubnet,omitempty"`
	// SecondarySubnet - READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string `json:"secondarySubnet,omitempty"`
	// ExpressRouteID - READ-ONLY; Identifier of the ExpressRoute Circuit (Microsoft Colo only)
	ExpressRouteID *string `json:"expressRouteID,omitempty"`
	// ExpressRoutePrivatePeeringID - READ-ONLY; ExpressRoute Circuit private peering identifier
	ExpressRoutePrivatePeeringID *string `json:"expressRoutePrivatePeeringID,omitempty"`
}

// MarshalJSON is the custom marshaler for Circuit.
func (c Circuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError API error response
type CloudError struct {
	// Error - An error returned by the API
	Error *ErrorResponse `json:"error,omitempty"`
}

// CloudLink a cloud link resource
type CloudLink struct {
	autorest.Response `json:"-"`
	// CloudLinkProperties - The properties of a cloud link.
	*CloudLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudLink.
func (cl CloudLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.CloudLinkProperties != nil {
		objectMap["properties"] = cl.CloudLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudLink struct.
func (cl *CloudLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudLinkProperties CloudLinkProperties
				err = json.Unmarshal(*v, &cloudLinkProperties)
				if err != nil {
					return err
				}
				cl.CloudLinkProperties = &cloudLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cl.Type = &typeVar
			}
		}
	}

	return nil
}

// CloudLinkList a paged list of cloud links
type CloudLinkList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]CloudLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudLinkList.
func (cll CloudLinkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudLinkListIterator provides access to a complete listing of CloudLink values.
type CloudLinkListIterator struct {
	i    int
	page CloudLinkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudLinkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudLinkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudLinkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudLinkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudLinkListIterator) Response() CloudLinkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudLinkListIterator) Value() CloudLink {
	if !iter.page.NotDone() {
		return CloudLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudLinkListIterator type.
func NewCloudLinkListIterator(page CloudLinkListPage) CloudLinkListIterator {
	return CloudLinkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cll CloudLinkList) IsEmpty() bool {
	return cll.Value == nil || len(*cll.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cll CloudLinkList) hasNextLink() bool {
	return cll.NextLink != nil && len(*cll.NextLink) != 0
}

// cloudLinkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cll CloudLinkList) cloudLinkListPreparer(ctx context.Context) (*http.Request, error) {
	if !cll.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cll.NextLink)))
}

// CloudLinkListPage contains a page of CloudLink values.
type CloudLinkListPage struct {
	fn  func(context.Context, CloudLinkList) (CloudLinkList, error)
	cll CloudLinkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudLinkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudLinkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cll)
		if err != nil {
			return err
		}
		page.cll = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudLinkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudLinkListPage) NotDone() bool {
	return !page.cll.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudLinkListPage) Response() CloudLinkList {
	return page.cll
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudLinkListPage) Values() []CloudLink {
	if page.cll.IsEmpty() {
		return nil
	}
	return *page.cll.Value
}

// Creates a new instance of the CloudLinkListPage type.
func NewCloudLinkListPage(cur CloudLinkList, getNextPage func(context.Context, CloudLinkList) (CloudLinkList, error)) CloudLinkListPage {
	return CloudLinkListPage{
		fn:  getNextPage,
		cll: cur,
	}
}

// CloudLinkProperties the properties of a cloud link.
type CloudLinkProperties struct {
	// Status - READ-ONLY; The state of the cloud link. Possible values include: 'CloudLinkStatusActive', 'CloudLinkStatusBuilding', 'CloudLinkStatusDeleting', 'CloudLinkStatusFailed', 'CloudLinkStatusDisconnected'
	Status CloudLinkStatus `json:"status,omitempty"`
	// LinkedCloud - Identifier of the other private cloud participating in the link.
	LinkedCloud *string `json:"linkedCloud,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudLinkProperties.
func (clp CloudLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clp.LinkedCloud != nil {
		objectMap["linkedCloud"] = clp.LinkedCloud
	}
	return json.Marshal(objectMap)
}

// CloudLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudLinksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudLinksClient) (CloudLink, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudLinksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudLinksCreateOrUpdateFuture.Result.
func (future *CloudLinksCreateOrUpdateFuture) result(client CloudLinksClient) (cl CloudLink, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.CloudLinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cl.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.CloudLinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cl.Response.Response, err = future.GetResult(sender); err == nil && cl.Response.Response.StatusCode != http.StatusNoContent {
		cl, err = client.CreateOrUpdateResponder(cl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.CloudLinksCreateOrUpdateFuture", "Result", cl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CloudLinksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudLinksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudLinksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudLinksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudLinksDeleteFuture.Result.
func (future *CloudLinksDeleteFuture) result(client CloudLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.CloudLinksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.CloudLinksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Cluster a cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The cluster SKU
	Sku *Sku `json:"sku,omitempty"`
	// ClusterProperties - The properties of a cluster resource
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterList a paged list of clusters
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterList.
func (cl ClusterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ClusterList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(cur ClusterList, getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ClusterProperties the properties of a cluster
type ClusterProperties struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ProvisioningState - The state of the cluster provisioning. Possible values include: 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateCancelled', 'ClusterProvisioningStateDeleting', 'ClusterProvisioningStateUpdating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ClusterSize != nil {
		objectMap["clusterSize"] = cp.ClusterSize
	}
	if cp.ProvisioningState != "" {
		objectMap["provisioningState"] = cp.ProvisioningState
	}
	if cp.Hosts != nil {
		objectMap["hosts"] = cp.Hosts
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate an update of a cluster resource
type ClusterUpdate struct {
	// ClusterUpdateProperties - The properties of a cluster resource that may be updated
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.ClusterUpdateProperties != nil {
		objectMap["properties"] = cu.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cu.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a cluster that may be updated
type ClusterUpdateProperties struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// Hosts - The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// CommonClusterProperties the common properties of a cluster
type CommonClusterProperties struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ProvisioningState - The state of the cluster provisioning. Possible values include: 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateCancelled', 'ClusterProvisioningStateDeleting', 'ClusterProvisioningStateUpdating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonClusterProperties.
func (ccp CommonClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.ClusterSize != nil {
		objectMap["clusterSize"] = ccp.ClusterSize
	}
	if ccp.ProvisioningState != "" {
		objectMap["provisioningState"] = ccp.ProvisioningState
	}
	if ccp.Hosts != nil {
		objectMap["hosts"] = ccp.Hosts
	}
	return json.Marshal(objectMap)
}

// Datastore a datastore resource
type Datastore struct {
	autorest.Response `json:"-"`
	// DatastoreProperties - The properties of a datastore resource
	*DatastoreProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Datastore.
func (d Datastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatastoreProperties != nil {
		objectMap["properties"] = d.DatastoreProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Datastore struct.
func (d *Datastore) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var datastoreProperties DatastoreProperties
				err = json.Unmarshal(*v, &datastoreProperties)
				if err != nil {
					return err
				}
				d.DatastoreProperties = &datastoreProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatastoreList a paged list of datastores
type DatastoreList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Datastore `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatastoreList.
func (dl DatastoreList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatastoreListIterator provides access to a complete listing of Datastore values.
type DatastoreListIterator struct {
	i    int
	page DatastoreListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatastoreListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatastoreListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatastoreListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatastoreListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatastoreListIterator) Response() DatastoreList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatastoreListIterator) Value() Datastore {
	if !iter.page.NotDone() {
		return Datastore{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatastoreListIterator type.
func NewDatastoreListIterator(page DatastoreListPage) DatastoreListIterator {
	return DatastoreListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DatastoreList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DatastoreList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// datastoreListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DatastoreList) datastoreListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DatastoreListPage contains a page of Datastore values.
type DatastoreListPage struct {
	fn func(context.Context, DatastoreList) (DatastoreList, error)
	dl DatastoreList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatastoreListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatastoreListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatastoreListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatastoreListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatastoreListPage) Response() DatastoreList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatastoreListPage) Values() []Datastore {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DatastoreListPage type.
func NewDatastoreListPage(cur DatastoreList, getNextPage func(context.Context, DatastoreList) (DatastoreList, error)) DatastoreListPage {
	return DatastoreListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DatastoreProperties the properties of a datastore
type DatastoreProperties struct {
	// ProvisioningState - READ-ONLY; The state of the datastore provisioning. Possible values include: 'DatastoreProvisioningStateSucceeded', 'DatastoreProvisioningStateFailed', 'DatastoreProvisioningStateCancelled', 'DatastoreProvisioningStatePending', 'DatastoreProvisioningStateCreating', 'DatastoreProvisioningStateUpdating', 'DatastoreProvisioningStateDeleting'
	ProvisioningState DatastoreProvisioningState `json:"provisioningState,omitempty"`
	// NetAppVolume - An Azure NetApp Files volume
	NetAppVolume *NetAppVolume `json:"netAppVolume,omitempty"`
	// DiskPoolVolume - An iSCSI volume
	DiskPoolVolume *DiskPoolVolume `json:"diskPoolVolume,omitempty"`
	// Status - READ-ONLY; The operational status of the datastore. Possible values include: 'DatastoreStatusUnknown', 'DatastoreStatusAccessible', 'DatastoreStatusInaccessible', 'DatastoreStatusAttached', 'DatastoreStatusDetached', 'DatastoreStatusLostCommunication', 'DatastoreStatusDeadOrError'
	Status DatastoreStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for DatastoreProperties.
func (dp DatastoreProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.NetAppVolume != nil {
		objectMap["netAppVolume"] = dp.NetAppVolume
	}
	if dp.DiskPoolVolume != nil {
		objectMap["diskPoolVolume"] = dp.DiskPoolVolume
	}
	return json.Marshal(objectMap)
}

// DatastoresCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatastoresCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatastoresClient) (Datastore, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatastoresCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatastoresCreateOrUpdateFuture.Result.
func (future *DatastoresCreateOrUpdateFuture) result(client DatastoresClient) (d Datastore, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.DatastoresCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.DatastoresCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.DatastoresCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatastoresDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatastoresDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatastoresClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatastoresDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatastoresDeleteFuture.Result.
func (future *DatastoresDeleteFuture) result(client DatastoresClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.DatastoresDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.DatastoresDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskPoolVolume an iSCSI volume from Microsoft.StoragePool provider
type DiskPoolVolume struct {
	// TargetID - Azure resource ID of the iSCSI target
	TargetID *string `json:"targetId,omitempty"`
	// LunName - Name of the LUN to be used for datastore
	LunName *string `json:"lunName,omitempty"`
	// MountOption - Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN. Possible values include: 'MountOptionEnumMOUNT', 'MountOptionEnumATTACH'
	MountOption MountOptionEnum `json:"mountOption,omitempty"`
	// Path - READ-ONLY; Device path
	Path *string `json:"path,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolVolume.
func (dpv DiskPoolVolume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpv.TargetID != nil {
		objectMap["targetId"] = dpv.TargetID
	}
	if dpv.LunName != nil {
		objectMap["lunName"] = dpv.LunName
	}
	if dpv.MountOption != "" {
		objectMap["mountOption"] = dpv.MountOption
	}
	return json.Marshal(objectMap)
}

// Encryption the properties of customer managed encryption key
type Encryption struct {
	// Status - Status of customer managed encryption key. Possible values include: 'EncryptionStateEnabled', 'EncryptionStateDisabled'
	Status EncryptionState `json:"status,omitempty"`
	// KeyVaultProperties - The key vault where the encryption key is stored
	KeyVaultProperties *EncryptionKeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// EncryptionKeyVaultProperties an Encryption Key
type EncryptionKeyVaultProperties struct {
	// KeyName - The name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The version of the key.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// KeyVaultURL - The URL of the vault.
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`
	// KeyState - READ-ONLY; The state of key provided. Possible values include: 'EncryptionKeyStatusConnected', 'EncryptionKeyStatusAccessDenied'
	KeyState EncryptionKeyStatus `json:"keyState,omitempty"`
	// VersionType - READ-ONLY; Property of the key if user provided or auto detected. Possible values include: 'EncryptionVersionTypeFixed', 'EncryptionVersionTypeAutoDetected'
	VersionType EncryptionVersionType `json:"versionType,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionKeyVaultProperties.
func (ekvp EncryptionKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ekvp.KeyName != nil {
		objectMap["keyName"] = ekvp.KeyName
	}
	if ekvp.KeyVersion != nil {
		objectMap["keyVersion"] = ekvp.KeyVersion
	}
	if ekvp.KeyVaultURL != nil {
		objectMap["keyVaultUrl"] = ekvp.KeyVaultURL
	}
	return json.Marshal(objectMap)
}

// Endpoints endpoint addresses
type Endpoints struct {
	// NsxtManager - READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string `json:"nsxtManager,omitempty"`
	// Vcsa - READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string `json:"vcsa,omitempty"`
	// HcxCloudManager - READ-ONLY; Endpoint for the HCX Cloud Manager
	HcxCloudManager *string `json:"hcxCloudManager,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoints.
func (e Endpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExpressRouteAuthorization expressRoute Circuit Authorization
type ExpressRouteAuthorization struct {
	autorest.Response `json:"-"`
	// ExpressRouteAuthorizationProperties - READ-ONLY; The properties of an ExpressRoute Circuit Authorization resource
	*ExpressRouteAuthorizationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteAuthorization.
func (era ExpressRouteAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteAuthorization struct.
func (era *ExpressRouteAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteAuthorizationProperties ExpressRouteAuthorizationProperties
				err = json.Unmarshal(*v, &expressRouteAuthorizationProperties)
				if err != nil {
					return err
				}
				era.ExpressRouteAuthorizationProperties = &expressRouteAuthorizationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				era.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				era.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				era.Type = &typeVar
			}
		}
	}

	return nil
}

// ExpressRouteAuthorizationList a paged list of ExpressRoute Circuit Authorizations
type ExpressRouteAuthorizationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]ExpressRouteAuthorization `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteAuthorizationList.
func (eral ExpressRouteAuthorizationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExpressRouteAuthorizationListIterator provides access to a complete listing of ExpressRouteAuthorization
// values.
type ExpressRouteAuthorizationListIterator struct {
	i    int
	page ExpressRouteAuthorizationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteAuthorizationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteAuthorizationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteAuthorizationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteAuthorizationListIterator) Response() ExpressRouteAuthorizationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteAuthorizationListIterator) Value() ExpressRouteAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteAuthorizationListIterator type.
func NewExpressRouteAuthorizationListIterator(page ExpressRouteAuthorizationListPage) ExpressRouteAuthorizationListIterator {
	return ExpressRouteAuthorizationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eral ExpressRouteAuthorizationList) IsEmpty() bool {
	return eral.Value == nil || len(*eral.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eral ExpressRouteAuthorizationList) hasNextLink() bool {
	return eral.NextLink != nil && len(*eral.NextLink) != 0
}

// expressRouteAuthorizationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eral ExpressRouteAuthorizationList) expressRouteAuthorizationListPreparer(ctx context.Context) (*http.Request, error) {
	if !eral.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eral.NextLink)))
}

// ExpressRouteAuthorizationListPage contains a page of ExpressRouteAuthorization values.
type ExpressRouteAuthorizationListPage struct {
	fn   func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)
	eral ExpressRouteAuthorizationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteAuthorizationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eral)
		if err != nil {
			return err
		}
		page.eral = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteAuthorizationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteAuthorizationListPage) NotDone() bool {
	return !page.eral.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteAuthorizationListPage) Response() ExpressRouteAuthorizationList {
	return page.eral
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteAuthorizationListPage) Values() []ExpressRouteAuthorization {
	if page.eral.IsEmpty() {
		return nil
	}
	return *page.eral.Value
}

// Creates a new instance of the ExpressRouteAuthorizationListPage type.
func NewExpressRouteAuthorizationListPage(cur ExpressRouteAuthorizationList, getNextPage func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)) ExpressRouteAuthorizationListPage {
	return ExpressRouteAuthorizationListPage{
		fn:   getNextPage,
		eral: cur,
	}
}

// ExpressRouteAuthorizationProperties the properties of an ExpressRoute Circuit Authorization resource
type ExpressRouteAuthorizationProperties struct {
	// ProvisioningState - READ-ONLY; The state of the  ExpressRoute Circuit Authorization provisioning. Possible values include: 'ExpressRouteAuthorizationProvisioningStateSucceeded', 'ExpressRouteAuthorizationProvisioningStateFailed', 'ExpressRouteAuthorizationProvisioningStateUpdating'
	ProvisioningState ExpressRouteAuthorizationProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteAuthorizationID - READ-ONLY; The ID of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationID *string `json:"expressRouteAuthorizationId,omitempty"`
	// ExpressRouteAuthorizationKey - READ-ONLY; The key of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationKey *string `json:"expressRouteAuthorizationKey,omitempty"`
	// ExpressRouteID - The ID of the ExpressRoute Circuit
	ExpressRouteID *string `json:"expressRouteId,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteAuthorizationProperties.
func (erap ExpressRouteAuthorizationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erap.ExpressRouteID != nil {
		objectMap["expressRouteId"] = erap.ExpressRouteID
	}
	return json.Marshal(objectMap)
}

// GlobalReachConnection a global reach connection resource
type GlobalReachConnection struct {
	autorest.Response `json:"-"`
	// GlobalReachConnectionProperties - The properties of a global reach connection resource
	*GlobalReachConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalReachConnection.
func (grc GlobalReachConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grc.GlobalReachConnectionProperties != nil {
		objectMap["properties"] = grc.GlobalReachConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GlobalReachConnection struct.
func (grc *GlobalReachConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var globalReachConnectionProperties GlobalReachConnectionProperties
				err = json.Unmarshal(*v, &globalReachConnectionProperties)
				if err != nil {
					return err
				}
				grc.GlobalReachConnectionProperties = &globalReachConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				grc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				grc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				grc.Type = &typeVar
			}
		}
	}

	return nil
}

// GlobalReachConnectionList a paged list of global reach connections
type GlobalReachConnectionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]GlobalReachConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalReachConnectionList.
func (grcl GlobalReachConnectionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GlobalReachConnectionListIterator provides access to a complete listing of GlobalReachConnection values.
type GlobalReachConnectionListIterator struct {
	i    int
	page GlobalReachConnectionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GlobalReachConnectionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalReachConnectionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GlobalReachConnectionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GlobalReachConnectionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GlobalReachConnectionListIterator) Response() GlobalReachConnectionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GlobalReachConnectionListIterator) Value() GlobalReachConnection {
	if !iter.page.NotDone() {
		return GlobalReachConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GlobalReachConnectionListIterator type.
func NewGlobalReachConnectionListIterator(page GlobalReachConnectionListPage) GlobalReachConnectionListIterator {
	return GlobalReachConnectionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grcl GlobalReachConnectionList) IsEmpty() bool {
	return grcl.Value == nil || len(*grcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grcl GlobalReachConnectionList) hasNextLink() bool {
	return grcl.NextLink != nil && len(*grcl.NextLink) != 0
}

// globalReachConnectionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grcl GlobalReachConnectionList) globalReachConnectionListPreparer(ctx context.Context) (*http.Request, error) {
	if !grcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grcl.NextLink)))
}

// GlobalReachConnectionListPage contains a page of GlobalReachConnection values.
type GlobalReachConnectionListPage struct {
	fn   func(context.Context, GlobalReachConnectionList) (GlobalReachConnectionList, error)
	grcl GlobalReachConnectionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GlobalReachConnectionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalReachConnectionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grcl)
		if err != nil {
			return err
		}
		page.grcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GlobalReachConnectionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GlobalReachConnectionListPage) NotDone() bool {
	return !page.grcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GlobalReachConnectionListPage) Response() GlobalReachConnectionList {
	return page.grcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GlobalReachConnectionListPage) Values() []GlobalReachConnection {
	if page.grcl.IsEmpty() {
		return nil
	}
	return *page.grcl.Value
}

// Creates a new instance of the GlobalReachConnectionListPage type.
func NewGlobalReachConnectionListPage(cur GlobalReachConnectionList, getNextPage func(context.Context, GlobalReachConnectionList) (GlobalReachConnectionList, error)) GlobalReachConnectionListPage {
	return GlobalReachConnectionListPage{
		fn:   getNextPage,
		grcl: cur,
	}
}

// GlobalReachConnectionProperties the properties of a global reach connection
type GlobalReachConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The state of the  ExpressRoute Circuit Authorization provisioning. Possible values include: 'GlobalReachConnectionProvisioningStateSucceeded', 'GlobalReachConnectionProvisioningStateFailed', 'GlobalReachConnectionProvisioningStateUpdating'
	ProvisioningState GlobalReachConnectionProvisioningState `json:"provisioningState,omitempty"`
	// AddressPrefix - READ-ONLY; The network used for global reach carved out from the original network block provided for the private cloud
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AuthorizationKey - Authorization key from the peer express route used for the global reach connection
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// CircuitConnectionStatus - READ-ONLY; The connection status of the global reach connection. Possible values include: 'GlobalReachConnectionStatusConnected', 'GlobalReachConnectionStatusConnecting', 'GlobalReachConnectionStatusDisconnected'
	CircuitConnectionStatus GlobalReachConnectionStatus `json:"circuitConnectionStatus,omitempty"`
	// PeerExpressRouteCircuit - Identifier of the ExpressRoute Circuit to peer with in the global reach connection
	PeerExpressRouteCircuit *string `json:"peerExpressRouteCircuit,omitempty"`
	// ExpressRouteID - The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
	ExpressRouteID *string `json:"expressRouteId,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalReachConnectionProperties.
func (grcp GlobalReachConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grcp.AuthorizationKey != nil {
		objectMap["authorizationKey"] = grcp.AuthorizationKey
	}
	if grcp.PeerExpressRouteCircuit != nil {
		objectMap["peerExpressRouteCircuit"] = grcp.PeerExpressRouteCircuit
	}
	if grcp.ExpressRouteID != nil {
		objectMap["expressRouteId"] = grcp.ExpressRouteID
	}
	return json.Marshal(objectMap)
}

// GlobalReachConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalReachConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalReachConnectionsClient) (GlobalReachConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalReachConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalReachConnectionsCreateOrUpdateFuture.Result.
func (future *GlobalReachConnectionsCreateOrUpdateFuture) result(client GlobalReachConnectionsClient) (grc GlobalReachConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		grc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.GlobalReachConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if grc.Response.Response, err = future.GetResult(sender); err == nil && grc.Response.Response.StatusCode != http.StatusNoContent {
		grc, err = client.CreateOrUpdateResponder(grc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsCreateOrUpdateFuture", "Result", grc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GlobalReachConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalReachConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalReachConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalReachConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalReachConnectionsDeleteFuture.Result.
func (future *GlobalReachConnectionsDeleteFuture) result(client GlobalReachConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.GlobalReachConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HcxEnterpriseSite an HCX Enterprise Site resource
type HcxEnterpriseSite struct {
	autorest.Response `json:"-"`
	// HcxEnterpriseSiteProperties - READ-ONLY; The properties of an HCX Enterprise Site resource
	*HcxEnterpriseSiteProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HcxEnterpriseSite.
func (hes HcxEnterpriseSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HcxEnterpriseSite struct.
func (hes *HcxEnterpriseSite) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hcxEnterpriseSiteProperties HcxEnterpriseSiteProperties
				err = json.Unmarshal(*v, &hcxEnterpriseSiteProperties)
				if err != nil {
					return err
				}
				hes.HcxEnterpriseSiteProperties = &hcxEnterpriseSiteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hes.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hes.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hes.Type = &typeVar
			}
		}
	}

	return nil
}

// HcxEnterpriseSiteList a paged list of HCX Enterprise Sites
type HcxEnterpriseSiteList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]HcxEnterpriseSite `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HcxEnterpriseSiteList.
func (hesl HcxEnterpriseSiteList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HcxEnterpriseSiteListIterator provides access to a complete listing of HcxEnterpriseSite values.
type HcxEnterpriseSiteListIterator struct {
	i    int
	page HcxEnterpriseSiteListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HcxEnterpriseSiteListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HcxEnterpriseSiteListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HcxEnterpriseSiteListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HcxEnterpriseSiteListIterator) Response() HcxEnterpriseSiteList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HcxEnterpriseSiteListIterator) Value() HcxEnterpriseSite {
	if !iter.page.NotDone() {
		return HcxEnterpriseSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HcxEnterpriseSiteListIterator type.
func NewHcxEnterpriseSiteListIterator(page HcxEnterpriseSiteListPage) HcxEnterpriseSiteListIterator {
	return HcxEnterpriseSiteListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hesl HcxEnterpriseSiteList) IsEmpty() bool {
	return hesl.Value == nil || len(*hesl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hesl HcxEnterpriseSiteList) hasNextLink() bool {
	return hesl.NextLink != nil && len(*hesl.NextLink) != 0
}

// hcxEnterpriseSiteListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hesl HcxEnterpriseSiteList) hcxEnterpriseSiteListPreparer(ctx context.Context) (*http.Request, error) {
	if !hesl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hesl.NextLink)))
}

// HcxEnterpriseSiteListPage contains a page of HcxEnterpriseSite values.
type HcxEnterpriseSiteListPage struct {
	fn   func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)
	hesl HcxEnterpriseSiteList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HcxEnterpriseSiteListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hesl)
		if err != nil {
			return err
		}
		page.hesl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HcxEnterpriseSiteListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HcxEnterpriseSiteListPage) NotDone() bool {
	return !page.hesl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HcxEnterpriseSiteListPage) Response() HcxEnterpriseSiteList {
	return page.hesl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HcxEnterpriseSiteListPage) Values() []HcxEnterpriseSite {
	if page.hesl.IsEmpty() {
		return nil
	}
	return *page.hesl.Value
}

// Creates a new instance of the HcxEnterpriseSiteListPage type.
func NewHcxEnterpriseSiteListPage(cur HcxEnterpriseSiteList, getNextPage func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)) HcxEnterpriseSiteListPage {
	return HcxEnterpriseSiteListPage{
		fn:   getNextPage,
		hesl: cur,
	}
}

// HcxEnterpriseSiteProperties the properties of an HCX Enterprise Site
type HcxEnterpriseSiteProperties struct {
	// ActivationKey - READ-ONLY; The activation key
	ActivationKey *string `json:"activationKey,omitempty"`
	// Status - READ-ONLY; The status of the HCX Enterprise Site. Possible values include: 'HcxEnterpriseSiteStatusAvailable', 'HcxEnterpriseSiteStatusConsumed', 'HcxEnterpriseSiteStatusDeactivated', 'HcxEnterpriseSiteStatusDeleted'
	Status HcxEnterpriseSiteStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for HcxEnterpriseSiteProperties.
func (hesp HcxEnterpriseSiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IdentitySource vCenter Single Sign On Identity Source
type IdentitySource struct {
	// Name - The name of the identity source
	Name *string `json:"name,omitempty"`
	// Alias - The domain's NetBIOS name
	Alias *string `json:"alias,omitempty"`
	// Domain - The domain's dns name
	Domain *string `json:"domain,omitempty"`
	// BaseUserDN - The base distinguished name for users
	BaseUserDN *string `json:"baseUserDN,omitempty"`
	// BaseGroupDN - The base distinguished name for groups
	BaseGroupDN *string `json:"baseGroupDN,omitempty"`
	// PrimaryServer - Primary server URL
	PrimaryServer *string `json:"primaryServer,omitempty"`
	// SecondaryServer - Secondary server URL
	SecondaryServer *string `json:"secondaryServer,omitempty"`
	// Ssl - Protect LDAP communication using SSL certificate (LDAPS). Possible values include: 'SslEnumEnabled', 'SslEnumDisabled'
	Ssl SslEnum `json:"ssl,omitempty"`
	// Username - The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string `json:"username,omitempty"`
	// Password - The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string `json:"password,omitempty"`
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagementCluster the properties of a management cluster
type ManagementCluster struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ProvisioningState - The state of the cluster provisioning. Possible values include: 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateCancelled', 'ClusterProvisioningStateDeleting', 'ClusterProvisioningStateUpdating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementCluster.
func (mc ManagementCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.ClusterSize != nil {
		objectMap["clusterSize"] = mc.ClusterSize
	}
	if mc.ProvisioningState != "" {
		objectMap["provisioningState"] = mc.ProvisioningState
	}
	if mc.Hosts != nil {
		objectMap["hosts"] = mc.Hosts
	}
	return json.Marshal(objectMap)
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - Name of the dimension as it appears in MDM
	InternalName *string `json:"internalName,omitempty"`
	// ToBeExportedForShoebox - A boolean flag indicating whether this dimension should be included for the shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// EnableRegionalMdmAccount - Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - The name of the MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - The name of the MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
}

// NetAppVolume an Azure NetApp Files volume from Microsoft.NetApp provider
type NetAppVolume struct {
	// ID - Azure resource ID of the NetApp volume
	ID *string `json:"id,omitempty"`
}

// Operation a REST API operation
type Operation struct {
	// Name - READ-ONLY; Name of the operation being performed on this object
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Gets or sets a value indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.Properties != nil {
		objectMap["properties"] = o.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay contains the localized display information for this operation
type OperationDisplay struct {
	// Provider - READ-ONLY; Localized friendly form of the resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationList pageable list of operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationList.
func (ol OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PlacementPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PlacementPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PlacementPoliciesClient) (PlacementPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PlacementPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PlacementPoliciesCreateOrUpdateFuture.Result.
func (future *PlacementPoliciesCreateOrUpdateFuture) result(client PlacementPoliciesClient) (pp PlacementPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PlacementPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PlacementPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pp.Response.Response, err = future.GetResult(sender); err == nil && pp.Response.Response.StatusCode != http.StatusNoContent {
		pp, err = client.CreateOrUpdateResponder(pp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PlacementPoliciesCreateOrUpdateFuture", "Result", pp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PlacementPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PlacementPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PlacementPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PlacementPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PlacementPoliciesDeleteFuture.Result.
func (future *PlacementPoliciesDeleteFuture) result(client PlacementPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PlacementPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PlacementPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PlacementPoliciesList represents list of placement policies
type PlacementPoliciesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]PlacementPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PlacementPoliciesList.
func (ppl PlacementPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PlacementPoliciesListIterator provides access to a complete listing of PlacementPolicy values.
type PlacementPoliciesListIterator struct {
	i    int
	page PlacementPoliciesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PlacementPoliciesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PlacementPoliciesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PlacementPoliciesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PlacementPoliciesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PlacementPoliciesListIterator) Response() PlacementPoliciesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PlacementPoliciesListIterator) Value() PlacementPolicy {
	if !iter.page.NotDone() {
		return PlacementPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PlacementPoliciesListIterator type.
func NewPlacementPoliciesListIterator(page PlacementPoliciesListPage) PlacementPoliciesListIterator {
	return PlacementPoliciesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ppl PlacementPoliciesList) IsEmpty() bool {
	return ppl.Value == nil || len(*ppl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ppl PlacementPoliciesList) hasNextLink() bool {
	return ppl.NextLink != nil && len(*ppl.NextLink) != 0
}

// placementPoliciesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ppl PlacementPoliciesList) placementPoliciesListPreparer(ctx context.Context) (*http.Request, error) {
	if !ppl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ppl.NextLink)))
}

// PlacementPoliciesListPage contains a page of PlacementPolicy values.
type PlacementPoliciesListPage struct {
	fn  func(context.Context, PlacementPoliciesList) (PlacementPoliciesList, error)
	ppl PlacementPoliciesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PlacementPoliciesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PlacementPoliciesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ppl)
		if err != nil {
			return err
		}
		page.ppl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PlacementPoliciesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PlacementPoliciesListPage) NotDone() bool {
	return !page.ppl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PlacementPoliciesListPage) Response() PlacementPoliciesList {
	return page.ppl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PlacementPoliciesListPage) Values() []PlacementPolicy {
	if page.ppl.IsEmpty() {
		return nil
	}
	return *page.ppl.Value
}

// Creates a new instance of the PlacementPoliciesListPage type.
func NewPlacementPoliciesListPage(cur PlacementPoliciesList, getNextPage func(context.Context, PlacementPoliciesList) (PlacementPoliciesList, error)) PlacementPoliciesListPage {
	return PlacementPoliciesListPage{
		fn:  getNextPage,
		ppl: cur,
	}
}

// PlacementPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PlacementPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PlacementPoliciesClient) (PlacementPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PlacementPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PlacementPoliciesUpdateFuture.Result.
func (future *PlacementPoliciesUpdateFuture) result(client PlacementPoliciesClient) (pp PlacementPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PlacementPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PlacementPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pp.Response.Response, err = future.GetResult(sender); err == nil && pp.Response.Response.StatusCode != http.StatusNoContent {
		pp, err = client.UpdateResponder(pp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PlacementPoliciesUpdateFuture", "Result", pp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PlacementPolicy a vSphere Distributed Resource Scheduler (DRS) placement policy
type PlacementPolicy struct {
	autorest.Response `json:"-"`
	// Properties - placement policy properties
	Properties BasicPlacementPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PlacementPolicy.
func (pp PlacementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pp.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PlacementPolicy struct.
func (pp *PlacementPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicPlacementPolicyProperties(*v)
				if err != nil {
					return err
				}
				pp.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pp.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicPlacementPolicyProperties abstract placement policy properties
type BasicPlacementPolicyProperties interface {
	AsVMVMPlacementPolicyProperties() (*VMVMPlacementPolicyProperties, bool)
	AsVMHostPlacementPolicyProperties() (*VMHostPlacementPolicyProperties, bool)
	AsPlacementPolicyProperties() (*PlacementPolicyProperties, bool)
}

// PlacementPolicyProperties abstract placement policy properties
type PlacementPolicyProperties struct {
	// State - Whether the placement policy is enabled or disabled. Possible values include: 'PlacementPolicyStateEnabled', 'PlacementPolicyStateDisabled'
	State PlacementPolicyState `json:"state,omitempty"`
	// DisplayName - Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PlacementPolicyProvisioningStateSucceeded', 'PlacementPolicyProvisioningStateFailed', 'PlacementPolicyProvisioningStateBuilding', 'PlacementPolicyProvisioningStateDeleting', 'PlacementPolicyProvisioningStateUpdating'
	ProvisioningState PlacementPolicyProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypePlacementPolicyProperties', 'TypeVMVM', 'TypeVMHost'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicPlacementPolicyProperties(body []byte) (BasicPlacementPolicyProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeVMVM):
		var vvppp VMVMPlacementPolicyProperties
		err := json.Unmarshal(body, &vvppp)
		return vvppp, err
	case string(TypeVMHost):
		var vhppp VMHostPlacementPolicyProperties
		err := json.Unmarshal(body, &vhppp)
		return vhppp, err
	default:
		var ppp PlacementPolicyProperties
		err := json.Unmarshal(body, &ppp)
		return ppp, err
	}
}
func unmarshalBasicPlacementPolicyPropertiesArray(body []byte) ([]BasicPlacementPolicyProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pppArray := make([]BasicPlacementPolicyProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppp, err := unmarshalBasicPlacementPolicyProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		pppArray[index] = ppp
	}
	return pppArray, nil
}

// MarshalJSON is the custom marshaler for PlacementPolicyProperties.
func (ppp PlacementPolicyProperties) MarshalJSON() ([]byte, error) {
	ppp.Type = TypePlacementPolicyProperties
	objectMap := make(map[string]interface{})
	if ppp.State != "" {
		objectMap["state"] = ppp.State
	}
	if ppp.DisplayName != nil {
		objectMap["displayName"] = ppp.DisplayName
	}
	if ppp.Type != "" {
		objectMap["type"] = ppp.Type
	}
	return json.Marshal(objectMap)
}

// AsVMVMPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for PlacementPolicyProperties.
func (ppp PlacementPolicyProperties) AsVMVMPlacementPolicyProperties() (*VMVMPlacementPolicyProperties, bool) {
	return nil, false
}

// AsVMHostPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for PlacementPolicyProperties.
func (ppp PlacementPolicyProperties) AsVMHostPlacementPolicyProperties() (*VMHostPlacementPolicyProperties, bool) {
	return nil, false
}

// AsPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for PlacementPolicyProperties.
func (ppp PlacementPolicyProperties) AsPlacementPolicyProperties() (*PlacementPolicyProperties, bool) {
	return &ppp, true
}

// AsBasicPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for PlacementPolicyProperties.
func (ppp PlacementPolicyProperties) AsBasicPlacementPolicyProperties() (BasicPlacementPolicyProperties, bool) {
	return &ppp, true
}

// PlacementPolicyUpdate an update of a DRS placement policy resource
type PlacementPolicyUpdate struct {
	// PlacementPolicyUpdateProperties - The properties of a placement policy resource that may be updated
	*PlacementPolicyUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PlacementPolicyUpdate.
func (ppu PlacementPolicyUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppu.PlacementPolicyUpdateProperties != nil {
		objectMap["properties"] = ppu.PlacementPolicyUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PlacementPolicyUpdate struct.
func (ppu *PlacementPolicyUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var placementPolicyUpdateProperties PlacementPolicyUpdateProperties
				err = json.Unmarshal(*v, &placementPolicyUpdateProperties)
				if err != nil {
					return err
				}
				ppu.PlacementPolicyUpdateProperties = &placementPolicyUpdateProperties
			}
		}
	}

	return nil
}

// PlacementPolicyUpdateProperties the properties of a placement policy resource that may be updated
type PlacementPolicyUpdateProperties struct {
	// State - Whether the placement policy is enabled or disabled. Possible values include: 'PlacementPolicyStateEnabled', 'PlacementPolicyStateDisabled'
	State PlacementPolicyState `json:"state,omitempty"`
	// VMMembers - Virtual machine members list
	VMMembers *[]string `json:"vmMembers,omitempty"`
	// HostMembers - Host members list
	HostMembers *[]string `json:"hostMembers,omitempty"`
}

// PrivateCloud a private cloud resource
type PrivateCloud struct {
	autorest.Response `json:"-"`
	// Sku - The private cloud SKU
	Sku *Sku `json:"sku,omitempty"`
	// PrivateCloudProperties - The properties of a private cloud resource
	*PrivateCloudProperties `json:"properties,omitempty"`
	// Identity - The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity `json:"identity,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloud.
func (pc PrivateCloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Sku != nil {
		objectMap["sku"] = pc.Sku
	}
	if pc.PrivateCloudProperties != nil {
		objectMap["properties"] = pc.PrivateCloudProperties
	}
	if pc.Identity != nil {
		objectMap["identity"] = pc.Identity
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	if pc.Tags != nil {
		objectMap["tags"] = pc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloud struct.
func (pc *PrivateCloud) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var privateCloudProperties PrivateCloudProperties
				err = json.Unmarshal(*v, &privateCloudProperties)
				if err != nil {
					return err
				}
				pc.PrivateCloudProperties = &privateCloudProperties
			}
		case "identity":
			if v != nil {
				var identity PrivateCloudIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				pc.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateCloudIdentity identity for the virtual machine.
type PrivateCloudIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudIdentity.
func (pci PrivateCloudIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pci.Type != "" {
		objectMap["type"] = pci.Type
	}
	return json.Marshal(objectMap)
}

// PrivateCloudList a paged list of private clouds
type PrivateCloudList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]PrivateCloud `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudList.
func (pcl PrivateCloudList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateCloudListIterator provides access to a complete listing of PrivateCloud values.
type PrivateCloudListIterator struct {
	i    int
	page PrivateCloudListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateCloudListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateCloudListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateCloudListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateCloudListIterator) Response() PrivateCloudList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateCloudListIterator) Value() PrivateCloud {
	if !iter.page.NotDone() {
		return PrivateCloud{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateCloudListIterator type.
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return PrivateCloudListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcl PrivateCloudList) IsEmpty() bool {
	return pcl.Value == nil || len(*pcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcl PrivateCloudList) hasNextLink() bool {
	return pcl.NextLink != nil && len(*pcl.NextLink) != 0
}

// privateCloudListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcl PrivateCloudList) privateCloudListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcl.NextLink)))
}

// PrivateCloudListPage contains a page of PrivateCloud values.
type PrivateCloudListPage struct {
	fn  func(context.Context, PrivateCloudList) (PrivateCloudList, error)
	pcl PrivateCloudList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateCloudListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcl)
		if err != nil {
			return err
		}
		page.pcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateCloudListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateCloudListPage) NotDone() bool {
	return !page.pcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateCloudListPage) Response() PrivateCloudList {
	return page.pcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateCloudListPage) Values() []PrivateCloud {
	if page.pcl.IsEmpty() {
		return nil
	}
	return *page.pcl.Value
}

// Creates a new instance of the PrivateCloudListPage type.
func NewPrivateCloudListPage(cur PrivateCloudList, getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return PrivateCloudListPage{
		fn:  getNextPage,
		pcl: cur,
	}
}

// PrivateCloudProperties the properties of a private cloud resource
type PrivateCloudProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PrivateCloudProvisioningStateSucceeded', 'PrivateCloudProvisioningStateFailed', 'PrivateCloudProvisioningStateCancelled', 'PrivateCloudProvisioningStatePending', 'PrivateCloudProvisioningStateBuilding', 'PrivateCloudProvisioningStateDeleting', 'PrivateCloudProvisioningStateUpdating'
	ProvisioningState PrivateCloudProvisioningState `json:"provisioningState,omitempty"`
	// Circuit - An ExpressRoute Circuit
	Circuit *Circuit `json:"circuit,omitempty"`
	// Endpoints - READ-ONLY; The endpoints
	Endpoints *Endpoints `json:"endpoints,omitempty"`
	// NetworkBlock - The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
	NetworkBlock *string `json:"networkBlock,omitempty"`
	// ManagementNetwork - READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string `json:"managementNetwork,omitempty"`
	// ProvisioningNetwork - READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string `json:"provisioningNetwork,omitempty"`
	// VmotionNetwork - READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string `json:"vmotionNetwork,omitempty"`
	// VcenterPassword - Optionally, set the vCenter admin password when the private cloud is created
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
	// NsxtPassword - Optionally, set the NSX-T Manager password when the private cloud is created
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterCertificateThumbprint - READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string `json:"vcenterCertificateThumbprint,omitempty"`
	// NsxtCertificateThumbprint - READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string `json:"nsxtCertificateThumbprint,omitempty"`
	// ExternalCloudLinks - READ-ONLY; Array of cloud link IDs from other clouds that connect to this one
	ExternalCloudLinks *[]string `json:"externalCloudLinks,omitempty"`
	// SecondaryCircuit - A secondary expressRoute circuit from a separate AZ. Only present in a stretched private cloud
	SecondaryCircuit *Circuit `json:"secondaryCircuit,omitempty"`
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'InternetEnumEnabled', 'InternetEnumDisabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
	// Availability - Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties `json:"availability,omitempty"`
	// Encryption - Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudProperties.
func (pcp PrivateCloudProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcp.Circuit != nil {
		objectMap["circuit"] = pcp.Circuit
	}
	if pcp.NetworkBlock != nil {
		objectMap["networkBlock"] = pcp.NetworkBlock
	}
	if pcp.VcenterPassword != nil {
		objectMap["vcenterPassword"] = pcp.VcenterPassword
	}
	if pcp.NsxtPassword != nil {
		objectMap["nsxtPassword"] = pcp.NsxtPassword
	}
	if pcp.SecondaryCircuit != nil {
		objectMap["secondaryCircuit"] = pcp.SecondaryCircuit
	}
	if pcp.ManagementCluster != nil {
		objectMap["managementCluster"] = pcp.ManagementCluster
	}
	if pcp.Internet != "" {
		objectMap["internet"] = pcp.Internet
	}
	if pcp.IdentitySources != nil {
		objectMap["identitySources"] = pcp.IdentitySources
	}
	if pcp.Availability != nil {
		objectMap["availability"] = pcp.Availability
	}
	if pcp.Encryption != nil {
		objectMap["encryption"] = pcp.Encryption
	}
	return json.Marshal(objectMap)
}

// PrivateCloudsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsCreateOrUpdateFuture.Result.
func (future *PrivateCloudsCreateOrUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.CreateOrUpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsDeleteFuture.Result.
func (future *PrivateCloudsDeleteFuture) result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsRotateNsxtPasswordFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsRotateNsxtPasswordFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsRotateNsxtPasswordFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsRotateNsxtPasswordFuture.Result.
func (future *PrivateCloudsRotateNsxtPasswordFuture) result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsRotateNsxtPasswordFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsRotateNsxtPasswordFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsRotateVcenterPasswordFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsRotateVcenterPasswordFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsRotateVcenterPasswordFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsRotateVcenterPasswordFuture.Result.
func (future *PrivateCloudsRotateVcenterPasswordFuture) result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsRotateVcenterPasswordFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsRotateVcenterPasswordFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsUpdateFuture.Result.
func (future *PrivateCloudsUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.UpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudUpdate an update to a private cloud resource
type PrivateCloudUpdate struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// PrivateCloudUpdateProperties - The updatable properties of a private cloud resource
	*PrivateCloudUpdateProperties `json:"properties,omitempty"`
	// Identity - The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudUpdate.
func (pcu PrivateCloudUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcu.Tags != nil {
		objectMap["tags"] = pcu.Tags
	}
	if pcu.PrivateCloudUpdateProperties != nil {
		objectMap["properties"] = pcu.PrivateCloudUpdateProperties
	}
	if pcu.Identity != nil {
		objectMap["identity"] = pcu.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloudUpdate struct.
func (pcu *PrivateCloudUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcu.Tags = tags
			}
		case "properties":
			if v != nil {
				var privateCloudUpdateProperties PrivateCloudUpdateProperties
				err = json.Unmarshal(*v, &privateCloudUpdateProperties)
				if err != nil {
					return err
				}
				pcu.PrivateCloudUpdateProperties = &privateCloudUpdateProperties
			}
		case "identity":
			if v != nil {
				var identity PrivateCloudIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				pcu.Identity = &identity
			}
		}
	}

	return nil
}

// PrivateCloudUpdateProperties the properties of a private cloud resource that may be updated
type PrivateCloudUpdateProperties struct {
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'InternetEnumEnabled', 'InternetEnumDisabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
	// Availability - Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties `json:"availability,omitempty"`
	// Encryption - Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption `json:"encryption,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PSCredentialExecutionParameter a powershell credential object
type PSCredentialExecutionParameter struct {
	// Username - username for login
	Username *string `json:"username,omitempty"`
	// Password - password for login
	Password *string `json:"password,omitempty"`
	// Name - The parameter name
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeBasicScriptExecutionParameterTypeScriptExecutionParameter', 'TypeBasicScriptExecutionParameterTypeSecureValue', 'TypeBasicScriptExecutionParameterTypeValue', 'TypeBasicScriptExecutionParameterTypeCredential'
	Type TypeBasicScriptExecutionParameter `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) MarshalJSON() ([]byte, error) {
	pcep.Type = TypeBasicScriptExecutionParameterTypeCredential
	objectMap := make(map[string]interface{})
	if pcep.Username != nil {
		objectMap["username"] = pcep.Username
	}
	if pcep.Password != nil {
		objectMap["password"] = pcep.Password
	}
	if pcep.Name != nil {
		objectMap["name"] = pcep.Name
	}
	if pcep.Type != "" {
		objectMap["type"] = pcep.Type
	}
	return json.Marshal(objectMap)
}

// AsScriptSecureStringExecutionParameter is the BasicScriptExecutionParameter implementation for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) AsScriptSecureStringExecutionParameter() (*ScriptSecureStringExecutionParameter, bool) {
	return nil, false
}

// AsScriptStringExecutionParameter is the BasicScriptExecutionParameter implementation for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) AsScriptStringExecutionParameter() (*ScriptStringExecutionParameter, bool) {
	return nil, false
}

// AsPSCredentialExecutionParameter is the BasicScriptExecutionParameter implementation for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) AsPSCredentialExecutionParameter() (*PSCredentialExecutionParameter, bool) {
	return &pcep, true
}

// AsScriptExecutionParameter is the BasicScriptExecutionParameter implementation for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) AsScriptExecutionParameter() (*ScriptExecutionParameter, bool) {
	return nil, false
}

// AsBasicScriptExecutionParameter is the BasicScriptExecutionParameter implementation for PSCredentialExecutionParameter.
func (pcep PSCredentialExecutionParameter) AsBasicScriptExecutionParameter() (BasicScriptExecutionParameter, bool) {
	return &pcep, true
}

// Quota subscription quotas
type Quota struct {
	autorest.Response `json:"-"`
	// HostsRemaining - READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32 `json:"hostsRemaining"`
	// QuotaEnabled - READ-ONLY; Host quota is active for current subscription. Possible values include: 'QuotaEnabledEnabled', 'QuotaEnabledDisabled'
	QuotaEnabled QuotaEnabled `json:"quotaEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for Quota.
func (q Quota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptCmdlet a cmdlet available for script execution
type ScriptCmdlet struct {
	autorest.Response `json:"-"`
	// ScriptCmdletProperties - The properties of a script cmdlet resource
	*ScriptCmdletProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptCmdlet.
func (sc ScriptCmdlet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.ScriptCmdletProperties != nil {
		objectMap["properties"] = sc.ScriptCmdletProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScriptCmdlet struct.
func (sc *ScriptCmdlet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scriptCmdletProperties ScriptCmdletProperties
				err = json.Unmarshal(*v, &scriptCmdletProperties)
				if err != nil {
					return err
				}
				sc.ScriptCmdletProperties = &scriptCmdletProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// ScriptCmdletProperties properties of a pre-canned script
type ScriptCmdletProperties struct {
	// Description - READ-ONLY; Description of the scripts functionality
	Description *string `json:"description,omitempty"`
	// Timeout - READ-ONLY; Recommended time limit for execution
	Timeout *string `json:"timeout,omitempty"`
	// Parameters - READ-ONLY; Parameters the script will accept
	Parameters *[]ScriptParameter `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptCmdletProperties.
func (scp ScriptCmdletProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptCmdletsList pageable list of scripts/cmdlets
type ScriptCmdletsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of scripts
	Value *[]ScriptCmdlet `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptCmdletsList.
func (scl ScriptCmdletsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptCmdletsListIterator provides access to a complete listing of ScriptCmdlet values.
type ScriptCmdletsListIterator struct {
	i    int
	page ScriptCmdletsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptCmdletsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptCmdletsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptCmdletsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptCmdletsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptCmdletsListIterator) Response() ScriptCmdletsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptCmdletsListIterator) Value() ScriptCmdlet {
	if !iter.page.NotDone() {
		return ScriptCmdlet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptCmdletsListIterator type.
func NewScriptCmdletsListIterator(page ScriptCmdletsListPage) ScriptCmdletsListIterator {
	return ScriptCmdletsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scl ScriptCmdletsList) IsEmpty() bool {
	return scl.Value == nil || len(*scl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scl ScriptCmdletsList) hasNextLink() bool {
	return scl.NextLink != nil && len(*scl.NextLink) != 0
}

// scriptCmdletsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scl ScriptCmdletsList) scriptCmdletsListPreparer(ctx context.Context) (*http.Request, error) {
	if !scl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scl.NextLink)))
}

// ScriptCmdletsListPage contains a page of ScriptCmdlet values.
type ScriptCmdletsListPage struct {
	fn  func(context.Context, ScriptCmdletsList) (ScriptCmdletsList, error)
	scl ScriptCmdletsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptCmdletsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptCmdletsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scl)
		if err != nil {
			return err
		}
		page.scl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptCmdletsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptCmdletsListPage) NotDone() bool {
	return !page.scl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptCmdletsListPage) Response() ScriptCmdletsList {
	return page.scl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptCmdletsListPage) Values() []ScriptCmdlet {
	if page.scl.IsEmpty() {
		return nil
	}
	return *page.scl.Value
}

// Creates a new instance of the ScriptCmdletsListPage type.
func NewScriptCmdletsListPage(cur ScriptCmdletsList, getNextPage func(context.Context, ScriptCmdletsList) (ScriptCmdletsList, error)) ScriptCmdletsListPage {
	return ScriptCmdletsListPage{
		fn:  getNextPage,
		scl: cur,
	}
}

// ScriptExecution an instance of a script executed by a user - custom or AVS
type ScriptExecution struct {
	autorest.Response `json:"-"`
	// ScriptExecutionProperties - The properties of a script execution resource
	*ScriptExecutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptExecution.
func (se ScriptExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.ScriptExecutionProperties != nil {
		objectMap["properties"] = se.ScriptExecutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScriptExecution struct.
func (se *ScriptExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scriptExecutionProperties ScriptExecutionProperties
				err = json.Unmarshal(*v, &scriptExecutionProperties)
				if err != nil {
					return err
				}
				se.ScriptExecutionProperties = &scriptExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				se.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				se.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				se.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicScriptExecutionParameter the arguments passed in to the execution
type BasicScriptExecutionParameter interface {
	AsScriptSecureStringExecutionParameter() (*ScriptSecureStringExecutionParameter, bool)
	AsScriptStringExecutionParameter() (*ScriptStringExecutionParameter, bool)
	AsPSCredentialExecutionParameter() (*PSCredentialExecutionParameter, bool)
	AsScriptExecutionParameter() (*ScriptExecutionParameter, bool)
}

// ScriptExecutionParameter the arguments passed in to the execution
type ScriptExecutionParameter struct {
	// Name - The parameter name
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeBasicScriptExecutionParameterTypeScriptExecutionParameter', 'TypeBasicScriptExecutionParameterTypeSecureValue', 'TypeBasicScriptExecutionParameterTypeValue', 'TypeBasicScriptExecutionParameterTypeCredential'
	Type TypeBasicScriptExecutionParameter `json:"type,omitempty"`
}

func unmarshalBasicScriptExecutionParameter(body []byte) (BasicScriptExecutionParameter, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicScriptExecutionParameterTypeSecureValue):
		var sssep ScriptSecureStringExecutionParameter
		err := json.Unmarshal(body, &sssep)
		return sssep, err
	case string(TypeBasicScriptExecutionParameterTypeValue):
		var ssep ScriptStringExecutionParameter
		err := json.Unmarshal(body, &ssep)
		return ssep, err
	case string(TypeBasicScriptExecutionParameterTypeCredential):
		var pcep PSCredentialExecutionParameter
		err := json.Unmarshal(body, &pcep)
		return pcep, err
	default:
		var sep ScriptExecutionParameter
		err := json.Unmarshal(body, &sep)
		return sep, err
	}
}
func unmarshalBasicScriptExecutionParameterArray(body []byte) ([]BasicScriptExecutionParameter, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sepArray := make([]BasicScriptExecutionParameter, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sep, err := unmarshalBasicScriptExecutionParameter(*rawMessage)
		if err != nil {
			return nil, err
		}
		sepArray[index] = sep
	}
	return sepArray, nil
}

// MarshalJSON is the custom marshaler for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) MarshalJSON() ([]byte, error) {
	sep.Type = TypeBasicScriptExecutionParameterTypeScriptExecutionParameter
	objectMap := make(map[string]interface{})
	if sep.Name != nil {
		objectMap["name"] = sep.Name
	}
	if sep.Type != "" {
		objectMap["type"] = sep.Type
	}
	return json.Marshal(objectMap)
}

// AsScriptSecureStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) AsScriptSecureStringExecutionParameter() (*ScriptSecureStringExecutionParameter, bool) {
	return nil, false
}

// AsScriptStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) AsScriptStringExecutionParameter() (*ScriptStringExecutionParameter, bool) {
	return nil, false
}

// AsPSCredentialExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) AsPSCredentialExecutionParameter() (*PSCredentialExecutionParameter, bool) {
	return nil, false
}

// AsScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) AsScriptExecutionParameter() (*ScriptExecutionParameter, bool) {
	return &sep, true
}

// AsBasicScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptExecutionParameter.
func (sep ScriptExecutionParameter) AsBasicScriptExecutionParameter() (BasicScriptExecutionParameter, bool) {
	return &sep, true
}

// ScriptExecutionProperties properties of a user-invoked script
type ScriptExecutionProperties struct {
	// ScriptCmdletID - A reference to the script cmdlet resource if user is running a AVS script
	ScriptCmdletID *string `json:"scriptCmdletId,omitempty"`
	// Parameters - Parameters the script will accept
	Parameters *[]BasicScriptExecutionParameter `json:"parameters,omitempty"`
	// HiddenParameters - Parameters that will be hidden/not visible to ARM, such as passwords and credentials
	HiddenParameters *[]BasicScriptExecutionParameter `json:"hiddenParameters,omitempty"`
	// FailureReason - Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
	FailureReason *string `json:"failureReason,omitempty"`
	// Timeout - Time limit for execution
	Timeout *string `json:"timeout,omitempty"`
	// Retention - Time to live for the resource. If not provided, will be available for 60 days
	Retention *string `json:"retention,omitempty"`
	// SubmittedAt - READ-ONLY; Time the script execution was submitted
	SubmittedAt *date.Time `json:"submittedAt,omitempty"`
	// StartedAt - READ-ONLY; Time the script execution was started
	StartedAt *date.Time `json:"startedAt,omitempty"`
	// FinishedAt - READ-ONLY; Time the script execution was finished
	FinishedAt *date.Time `json:"finishedAt,omitempty"`
	// ProvisioningState - READ-ONLY; The state of the script execution resource. Possible values include: 'ScriptExecutionProvisioningStatePending', 'ScriptExecutionProvisioningStateRunning', 'ScriptExecutionProvisioningStateSucceeded', 'ScriptExecutionProvisioningStateFailed', 'ScriptExecutionProvisioningStateCancelling', 'ScriptExecutionProvisioningStateCancelled', 'ScriptExecutionProvisioningStateDeleting'
	ProvisioningState ScriptExecutionProvisioningState `json:"provisioningState,omitempty"`
	// Output - Standard output stream from the powershell execution
	Output *[]string `json:"output,omitempty"`
	// NamedOutputs - User-defined dictionary.
	NamedOutputs map[string]interface{} `json:"namedOutputs"`
	// Information - READ-ONLY; Standard information out stream from the powershell execution
	Information *[]string `json:"information,omitempty"`
	// Warnings - READ-ONLY; Standard warning out stream from the powershell execution
	Warnings *[]string `json:"warnings,omitempty"`
	// Errors - READ-ONLY; Standard error output stream from the powershell execution
	Errors *[]string `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptExecutionProperties.
func (sep ScriptExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sep.ScriptCmdletID != nil {
		objectMap["scriptCmdletId"] = sep.ScriptCmdletID
	}
	if sep.Parameters != nil {
		objectMap["parameters"] = sep.Parameters
	}
	if sep.HiddenParameters != nil {
		objectMap["hiddenParameters"] = sep.HiddenParameters
	}
	if sep.FailureReason != nil {
		objectMap["failureReason"] = sep.FailureReason
	}
	if sep.Timeout != nil {
		objectMap["timeout"] = sep.Timeout
	}
	if sep.Retention != nil {
		objectMap["retention"] = sep.Retention
	}
	if sep.Output != nil {
		objectMap["output"] = sep.Output
	}
	if sep.NamedOutputs != nil {
		objectMap["namedOutputs"] = sep.NamedOutputs
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScriptExecutionProperties struct.
func (sep *ScriptExecutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "scriptCmdletId":
			if v != nil {
				var scriptCmdletID string
				err = json.Unmarshal(*v, &scriptCmdletID)
				if err != nil {
					return err
				}
				sep.ScriptCmdletID = &scriptCmdletID
			}
		case "parameters":
			if v != nil {
				parameters, err := unmarshalBasicScriptExecutionParameterArray(*v)
				if err != nil {
					return err
				}
				sep.Parameters = &parameters
			}
		case "hiddenParameters":
			if v != nil {
				hiddenParameters, err := unmarshalBasicScriptExecutionParameterArray(*v)
				if err != nil {
					return err
				}
				sep.HiddenParameters = &hiddenParameters
			}
		case "failureReason":
			if v != nil {
				var failureReason string
				err = json.Unmarshal(*v, &failureReason)
				if err != nil {
					return err
				}
				sep.FailureReason = &failureReason
			}
		case "timeout":
			if v != nil {
				var timeout string
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				sep.Timeout = &timeout
			}
		case "retention":
			if v != nil {
				var retention string
				err = json.Unmarshal(*v, &retention)
				if err != nil {
					return err
				}
				sep.Retention = &retention
			}
		case "submittedAt":
			if v != nil {
				var submittedAt date.Time
				err = json.Unmarshal(*v, &submittedAt)
				if err != nil {
					return err
				}
				sep.SubmittedAt = &submittedAt
			}
		case "startedAt":
			if v != nil {
				var startedAt date.Time
				err = json.Unmarshal(*v, &startedAt)
				if err != nil {
					return err
				}
				sep.StartedAt = &startedAt
			}
		case "finishedAt":
			if v != nil {
				var finishedAt date.Time
				err = json.Unmarshal(*v, &finishedAt)
				if err != nil {
					return err
				}
				sep.FinishedAt = &finishedAt
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ScriptExecutionProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				sep.ProvisioningState = provisioningState
			}
		case "output":
			if v != nil {
				var output []string
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				sep.Output = &output
			}
		case "namedOutputs":
			if v != nil {
				var namedOutputs map[string]interface{}
				err = json.Unmarshal(*v, &namedOutputs)
				if err != nil {
					return err
				}
				sep.NamedOutputs = namedOutputs
			}
		case "information":
			if v != nil {
				var information []string
				err = json.Unmarshal(*v, &information)
				if err != nil {
					return err
				}
				sep.Information = &information
			}
		case "warnings":
			if v != nil {
				var warnings []string
				err = json.Unmarshal(*v, &warnings)
				if err != nil {
					return err
				}
				sep.Warnings = &warnings
			}
		case "errors":
			if v != nil {
				var errorsVar []string
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				sep.Errors = &errorsVar
			}
		}
	}

	return nil
}

// ScriptExecutionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ScriptExecutionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScriptExecutionsClient) (ScriptExecution, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScriptExecutionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScriptExecutionsCreateOrUpdateFuture.Result.
func (future *ScriptExecutionsCreateOrUpdateFuture) result(client ScriptExecutionsClient) (se ScriptExecution, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ScriptExecutionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		se.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ScriptExecutionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if se.Response.Response, err = future.GetResult(sender); err == nil && se.Response.Response.StatusCode != http.StatusNoContent {
		se, err = client.CreateOrUpdateResponder(se.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ScriptExecutionsCreateOrUpdateFuture", "Result", se.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ScriptExecutionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScriptExecutionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScriptExecutionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScriptExecutionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScriptExecutionsDeleteFuture.Result.
func (future *ScriptExecutionsDeleteFuture) result(client ScriptExecutionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ScriptExecutionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ScriptExecutionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScriptExecutionsList pageable list of script executions
type ScriptExecutionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of scripts
	Value *[]ScriptExecution `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptExecutionsList.
func (sel ScriptExecutionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptExecutionsListIterator provides access to a complete listing of ScriptExecution values.
type ScriptExecutionsListIterator struct {
	i    int
	page ScriptExecutionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptExecutionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptExecutionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptExecutionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptExecutionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptExecutionsListIterator) Response() ScriptExecutionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptExecutionsListIterator) Value() ScriptExecution {
	if !iter.page.NotDone() {
		return ScriptExecution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptExecutionsListIterator type.
func NewScriptExecutionsListIterator(page ScriptExecutionsListPage) ScriptExecutionsListIterator {
	return ScriptExecutionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sel ScriptExecutionsList) IsEmpty() bool {
	return sel.Value == nil || len(*sel.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sel ScriptExecutionsList) hasNextLink() bool {
	return sel.NextLink != nil && len(*sel.NextLink) != 0
}

// scriptExecutionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sel ScriptExecutionsList) scriptExecutionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !sel.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sel.NextLink)))
}

// ScriptExecutionsListPage contains a page of ScriptExecution values.
type ScriptExecutionsListPage struct {
	fn  func(context.Context, ScriptExecutionsList) (ScriptExecutionsList, error)
	sel ScriptExecutionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptExecutionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptExecutionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sel)
		if err != nil {
			return err
		}
		page.sel = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptExecutionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptExecutionsListPage) NotDone() bool {
	return !page.sel.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptExecutionsListPage) Response() ScriptExecutionsList {
	return page.sel
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptExecutionsListPage) Values() []ScriptExecution {
	if page.sel.IsEmpty() {
		return nil
	}
	return *page.sel.Value
}

// Creates a new instance of the ScriptExecutionsListPage type.
func NewScriptExecutionsListPage(cur ScriptExecutionsList, getNextPage func(context.Context, ScriptExecutionsList) (ScriptExecutionsList, error)) ScriptExecutionsListPage {
	return ScriptExecutionsListPage{
		fn:  getNextPage,
		sel: cur,
	}
}

// ScriptPackage script Package resources available for execution
type ScriptPackage struct {
	autorest.Response `json:"-"`
	// ScriptPackageProperties - ScriptPackage resource properties
	*ScriptPackageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptPackage.
func (sp ScriptPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ScriptPackageProperties != nil {
		objectMap["properties"] = sp.ScriptPackageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScriptPackage struct.
func (sp *ScriptPackage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scriptPackageProperties ScriptPackageProperties
				err = json.Unmarshal(*v, &scriptPackageProperties)
				if err != nil {
					return err
				}
				sp.ScriptPackageProperties = &scriptPackageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// ScriptPackageProperties properties of a Script Package subresource
type ScriptPackageProperties struct {
	// Description - READ-ONLY; User friendly description of the package
	Description *string `json:"description,omitempty"`
	// Version - READ-ONLY; Module version
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptPackageProperties.
func (spp ScriptPackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptPackagesList a list of the available script packages
type ScriptPackagesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of script package resources
	Value *[]ScriptPackage `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptPackagesList.
func (spl ScriptPackagesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ScriptPackagesListIterator provides access to a complete listing of ScriptPackage values.
type ScriptPackagesListIterator struct {
	i    int
	page ScriptPackagesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptPackagesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptPackagesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptPackagesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptPackagesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptPackagesListIterator) Response() ScriptPackagesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptPackagesListIterator) Value() ScriptPackage {
	if !iter.page.NotDone() {
		return ScriptPackage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptPackagesListIterator type.
func NewScriptPackagesListIterator(page ScriptPackagesListPage) ScriptPackagesListIterator {
	return ScriptPackagesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spl ScriptPackagesList) IsEmpty() bool {
	return spl.Value == nil || len(*spl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spl ScriptPackagesList) hasNextLink() bool {
	return spl.NextLink != nil && len(*spl.NextLink) != 0
}

// scriptPackagesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spl ScriptPackagesList) scriptPackagesListPreparer(ctx context.Context) (*http.Request, error) {
	if !spl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spl.NextLink)))
}

// ScriptPackagesListPage contains a page of ScriptPackage values.
type ScriptPackagesListPage struct {
	fn  func(context.Context, ScriptPackagesList) (ScriptPackagesList, error)
	spl ScriptPackagesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptPackagesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptPackagesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spl)
		if err != nil {
			return err
		}
		page.spl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptPackagesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptPackagesListPage) NotDone() bool {
	return !page.spl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptPackagesListPage) Response() ScriptPackagesList {
	return page.spl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptPackagesListPage) Values() []ScriptPackage {
	if page.spl.IsEmpty() {
		return nil
	}
	return *page.spl.Value
}

// Creates a new instance of the ScriptPackagesListPage type.
func NewScriptPackagesListPage(cur ScriptPackagesList, getNextPage func(context.Context, ScriptPackagesList) (ScriptPackagesList, error)) ScriptPackagesListPage {
	return ScriptPackagesListPage{
		fn:  getNextPage,
		spl: cur,
	}
}

// ScriptParameter an parameter that the script will accept
type ScriptParameter struct {
	// Type - READ-ONLY; The type of parameter the script is expecting. psCredential is a PSCredentialObject. Possible values include: 'ScriptParameterTypesString', 'ScriptParameterTypesSecureString', 'ScriptParameterTypesCredential', 'ScriptParameterTypesInt', 'ScriptParameterTypesBool', 'ScriptParameterTypesFloat'
	Type ScriptParameterTypes `json:"type,omitempty"`
	// Name - The parameter name that the script will expect a parameter value for
	Name *string `json:"name,omitempty"`
	// Description - READ-ONLY; User friendly description of the parameter
	Description *string `json:"description,omitempty"`
	// Visibility - READ-ONLY; Should this parameter be visible to arm and passed in the parameters argument when executing. Possible values include: 'VisibilityParameterEnumVisible', 'VisibilityParameterEnumHidden'
	Visibility VisibilityParameterEnum `json:"visibility,omitempty"`
	// Optional - READ-ONLY; Is this parameter required or optional. Possible values include: 'OptionalParamEnumOptional', 'OptionalParamEnumRequired'
	Optional OptionalParamEnum `json:"optional,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptParameter.
func (sp ScriptParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Name != nil {
		objectMap["name"] = sp.Name
	}
	return json.Marshal(objectMap)
}

// ScriptSecureStringExecutionParameter a plain text value execution parameter
type ScriptSecureStringExecutionParameter struct {
	// SecureValue - A secure value for the passed parameter, not to be stored in logs
	SecureValue *string `json:"secureValue,omitempty"`
	// Name - The parameter name
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeBasicScriptExecutionParameterTypeScriptExecutionParameter', 'TypeBasicScriptExecutionParameterTypeSecureValue', 'TypeBasicScriptExecutionParameterTypeValue', 'TypeBasicScriptExecutionParameterTypeCredential'
	Type TypeBasicScriptExecutionParameter `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) MarshalJSON() ([]byte, error) {
	sssep.Type = TypeBasicScriptExecutionParameterTypeSecureValue
	objectMap := make(map[string]interface{})
	if sssep.SecureValue != nil {
		objectMap["secureValue"] = sssep.SecureValue
	}
	if sssep.Name != nil {
		objectMap["name"] = sssep.Name
	}
	if sssep.Type != "" {
		objectMap["type"] = sssep.Type
	}
	return json.Marshal(objectMap)
}

// AsScriptSecureStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) AsScriptSecureStringExecutionParameter() (*ScriptSecureStringExecutionParameter, bool) {
	return &sssep, true
}

// AsScriptStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) AsScriptStringExecutionParameter() (*ScriptStringExecutionParameter, bool) {
	return nil, false
}

// AsPSCredentialExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) AsPSCredentialExecutionParameter() (*PSCredentialExecutionParameter, bool) {
	return nil, false
}

// AsScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) AsScriptExecutionParameter() (*ScriptExecutionParameter, bool) {
	return nil, false
}

// AsBasicScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptSecureStringExecutionParameter.
func (sssep ScriptSecureStringExecutionParameter) AsBasicScriptExecutionParameter() (BasicScriptExecutionParameter, bool) {
	return &sssep, true
}

// ScriptStringExecutionParameter a plain text value execution parameter
type ScriptStringExecutionParameter struct {
	// Value - The value for the passed parameter
	Value *string `json:"value,omitempty"`
	// Name - The parameter name
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeBasicScriptExecutionParameterTypeScriptExecutionParameter', 'TypeBasicScriptExecutionParameterTypeSecureValue', 'TypeBasicScriptExecutionParameterTypeValue', 'TypeBasicScriptExecutionParameterTypeCredential'
	Type TypeBasicScriptExecutionParameter `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) MarshalJSON() ([]byte, error) {
	ssep.Type = TypeBasicScriptExecutionParameterTypeValue
	objectMap := make(map[string]interface{})
	if ssep.Value != nil {
		objectMap["value"] = ssep.Value
	}
	if ssep.Name != nil {
		objectMap["name"] = ssep.Name
	}
	if ssep.Type != "" {
		objectMap["type"] = ssep.Type
	}
	return json.Marshal(objectMap)
}

// AsScriptSecureStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) AsScriptSecureStringExecutionParameter() (*ScriptSecureStringExecutionParameter, bool) {
	return nil, false
}

// AsScriptStringExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) AsScriptStringExecutionParameter() (*ScriptStringExecutionParameter, bool) {
	return &ssep, true
}

// AsPSCredentialExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) AsPSCredentialExecutionParameter() (*PSCredentialExecutionParameter, bool) {
	return nil, false
}

// AsScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) AsScriptExecutionParameter() (*ScriptExecutionParameter, bool) {
	return nil, false
}

// AsBasicScriptExecutionParameter is the BasicScriptExecutionParameter implementation for ScriptStringExecutionParameter.
func (ssep ScriptStringExecutionParameter) AsBasicScriptExecutionParameter() (BasicScriptExecutionParameter, bool) {
	return &ssep, true
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Trial subscription trial availability
type Trial struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; Trial status. Possible values include: 'TrialStatusTrialAvailable', 'TrialStatusTrialUsed', 'TrialStatusTrialDisabled'
	Status TrialStatus `json:"status,omitempty"`
	// AvailableHosts - READ-ONLY; Number of trial hosts available
	AvailableHosts *int32 `json:"availableHosts,omitempty"`
}

// MarshalJSON is the custom marshaler for Trial.
func (t Trial) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachine virtual Machine
type VirtualMachine struct {
	autorest.Response `json:"-"`
	// VirtualMachineProperties - Virtual machine properties.
	*VirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if VM.VirtualMachineProperties != nil {
		objectMap["properties"] = VM.VirtualMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachine struct.
func (VM *VirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualMachineProperties VirtualMachineProperties
				err = json.Unmarshal(*v, &virtualMachineProperties)
				if err != nil {
					return err
				}
				VM.VirtualMachineProperties = &virtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				VM.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				VM.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				VM.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualMachineProperties virtual Machine Properties
type VirtualMachineProperties struct {
	// DisplayName - READ-ONLY; Display name of the VM.
	DisplayName *string `json:"displayName,omitempty"`
	// MoRefID - READ-ONLY; Virtual machine managed object reference id
	MoRefID *string `json:"moRefId,omitempty"`
	// FolderPath - READ-ONLY; Path to virtual machine's folder starting from datacenter virtual machine folder
	FolderPath *string `json:"folderPath,omitempty"`
	// RestrictMovement - READ-ONLY; Possible values include: 'VirtualMachineRestrictMovementStateEnabled', 'VirtualMachineRestrictMovementStateDisabled'
	RestrictMovement VirtualMachineRestrictMovementState `json:"restrictMovement,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineProperties.
func (vmp VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachineRestrictMovement set VM DRS-driven movement to restricted (enabled) or not (disabled)
type VirtualMachineRestrictMovement struct {
	// RestrictMovement - Possible values include: 'VirtualMachineRestrictMovementStateEnabled', 'VirtualMachineRestrictMovementStateDisabled'
	RestrictMovement VirtualMachineRestrictMovementState `json:"restrictMovement,omitempty"`
}

// VirtualMachinesList a list of Virtual Machines
type VirtualMachinesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items to be displayed on the page
	Value *[]VirtualMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachinesList.
func (vml VirtualMachinesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachinesListIterator provides access to a complete listing of VirtualMachine values.
type VirtualMachinesListIterator struct {
	i    int
	page VirtualMachinesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachinesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachinesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachinesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachinesListIterator) Response() VirtualMachinesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachinesListIterator) Value() VirtualMachine {
	if !iter.page.NotDone() {
		return VirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachinesListIterator type.
func NewVirtualMachinesListIterator(page VirtualMachinesListPage) VirtualMachinesListIterator {
	return VirtualMachinesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vml VirtualMachinesList) IsEmpty() bool {
	return vml.Value == nil || len(*vml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vml VirtualMachinesList) hasNextLink() bool {
	return vml.NextLink != nil && len(*vml.NextLink) != 0
}

// virtualMachinesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vml VirtualMachinesList) virtualMachinesListPreparer(ctx context.Context) (*http.Request, error) {
	if !vml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vml.NextLink)))
}

// VirtualMachinesListPage contains a page of VirtualMachine values.
type VirtualMachinesListPage struct {
	fn  func(context.Context, VirtualMachinesList) (VirtualMachinesList, error)
	vml VirtualMachinesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachinesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachinesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vml)
		if err != nil {
			return err
		}
		page.vml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachinesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachinesListPage) NotDone() bool {
	return !page.vml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachinesListPage) Response() VirtualMachinesList {
	return page.vml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachinesListPage) Values() []VirtualMachine {
	if page.vml.IsEmpty() {
		return nil
	}
	return *page.vml.Value
}

// Creates a new instance of the VirtualMachinesListPage type.
func NewVirtualMachinesListPage(cur VirtualMachinesList, getNextPage func(context.Context, VirtualMachinesList) (VirtualMachinesList, error)) VirtualMachinesListPage {
	return VirtualMachinesListPage{
		fn:  getNextPage,
		vml: cur,
	}
}

// VirtualMachinesRestrictMovementFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesRestrictMovementFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRestrictMovementFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRestrictMovementFuture.Result.
func (future *VirtualMachinesRestrictMovementFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.VirtualMachinesRestrictMovementFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.VirtualMachinesRestrictMovementFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VMHostPlacementPolicyProperties VM-Host placement policy properties
type VMHostPlacementPolicyProperties struct {
	// VMMembers - Virtual machine members list
	VMMembers *[]string `json:"vmMembers,omitempty"`
	// HostMembers - Host members list
	HostMembers *[]string `json:"hostMembers,omitempty"`
	// AffinityType - placement policy affinity type. Possible values include: 'AffinityTypeAffinity', 'AffinityTypeAntiAffinity'
	AffinityType AffinityType `json:"affinityType,omitempty"`
	// State - Whether the placement policy is enabled or disabled. Possible values include: 'PlacementPolicyStateEnabled', 'PlacementPolicyStateDisabled'
	State PlacementPolicyState `json:"state,omitempty"`
	// DisplayName - Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PlacementPolicyProvisioningStateSucceeded', 'PlacementPolicyProvisioningStateFailed', 'PlacementPolicyProvisioningStateBuilding', 'PlacementPolicyProvisioningStateDeleting', 'PlacementPolicyProvisioningStateUpdating'
	ProvisioningState PlacementPolicyProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypePlacementPolicyProperties', 'TypeVMVM', 'TypeVMHost'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VMHostPlacementPolicyProperties.
func (vhppp VMHostPlacementPolicyProperties) MarshalJSON() ([]byte, error) {
	vhppp.Type = TypeVMHost
	objectMap := make(map[string]interface{})
	if vhppp.VMMembers != nil {
		objectMap["vmMembers"] = vhppp.VMMembers
	}
	if vhppp.HostMembers != nil {
		objectMap["hostMembers"] = vhppp.HostMembers
	}
	if vhppp.AffinityType != "" {
		objectMap["affinityType"] = vhppp.AffinityType
	}
	if vhppp.State != "" {
		objectMap["state"] = vhppp.State
	}
	if vhppp.DisplayName != nil {
		objectMap["displayName"] = vhppp.DisplayName
	}
	if vhppp.Type != "" {
		objectMap["type"] = vhppp.Type
	}
	return json.Marshal(objectMap)
}

// AsVMVMPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMHostPlacementPolicyProperties.
func (vhppp VMHostPlacementPolicyProperties) AsVMVMPlacementPolicyProperties() (*VMVMPlacementPolicyProperties, bool) {
	return nil, false
}

// AsVMHostPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMHostPlacementPolicyProperties.
func (vhppp VMHostPlacementPolicyProperties) AsVMHostPlacementPolicyProperties() (*VMHostPlacementPolicyProperties, bool) {
	return &vhppp, true
}

// AsPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMHostPlacementPolicyProperties.
func (vhppp VMHostPlacementPolicyProperties) AsPlacementPolicyProperties() (*PlacementPolicyProperties, bool) {
	return nil, false
}

// AsBasicPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMHostPlacementPolicyProperties.
func (vhppp VMHostPlacementPolicyProperties) AsBasicPlacementPolicyProperties() (BasicPlacementPolicyProperties, bool) {
	return &vhppp, true
}

// VMVMPlacementPolicyProperties VM-VM placement policy properties
type VMVMPlacementPolicyProperties struct {
	// VMMembers - Virtual machine members list
	VMMembers *[]string `json:"vmMembers,omitempty"`
	// AffinityType - placement policy affinity type. Possible values include: 'AffinityTypeAffinity', 'AffinityTypeAntiAffinity'
	AffinityType AffinityType `json:"affinityType,omitempty"`
	// State - Whether the placement policy is enabled or disabled. Possible values include: 'PlacementPolicyStateEnabled', 'PlacementPolicyStateDisabled'
	State PlacementPolicyState `json:"state,omitempty"`
	// DisplayName - Display name of the placement policy
	DisplayName *string `json:"displayName,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PlacementPolicyProvisioningStateSucceeded', 'PlacementPolicyProvisioningStateFailed', 'PlacementPolicyProvisioningStateBuilding', 'PlacementPolicyProvisioningStateDeleting', 'PlacementPolicyProvisioningStateUpdating'
	ProvisioningState PlacementPolicyProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypePlacementPolicyProperties', 'TypeVMVM', 'TypeVMHost'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VMVMPlacementPolicyProperties.
func (vvppp VMVMPlacementPolicyProperties) MarshalJSON() ([]byte, error) {
	vvppp.Type = TypeVMVM
	objectMap := make(map[string]interface{})
	if vvppp.VMMembers != nil {
		objectMap["vmMembers"] = vvppp.VMMembers
	}
	if vvppp.AffinityType != "" {
		objectMap["affinityType"] = vvppp.AffinityType
	}
	if vvppp.State != "" {
		objectMap["state"] = vvppp.State
	}
	if vvppp.DisplayName != nil {
		objectMap["displayName"] = vvppp.DisplayName
	}
	if vvppp.Type != "" {
		objectMap["type"] = vvppp.Type
	}
	return json.Marshal(objectMap)
}

// AsVMVMPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMVMPlacementPolicyProperties.
func (vvppp VMVMPlacementPolicyProperties) AsVMVMPlacementPolicyProperties() (*VMVMPlacementPolicyProperties, bool) {
	return &vvppp, true
}

// AsVMHostPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMVMPlacementPolicyProperties.
func (vvppp VMVMPlacementPolicyProperties) AsVMHostPlacementPolicyProperties() (*VMHostPlacementPolicyProperties, bool) {
	return nil, false
}

// AsPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMVMPlacementPolicyProperties.
func (vvppp VMVMPlacementPolicyProperties) AsPlacementPolicyProperties() (*PlacementPolicyProperties, bool) {
	return nil, false
}

// AsBasicPlacementPolicyProperties is the BasicPlacementPolicyProperties implementation for VMVMPlacementPolicyProperties.
func (vvppp VMVMPlacementPolicyProperties) AsBasicPlacementPolicyProperties() (BasicPlacementPolicyProperties, bool) {
	return &vvppp, true
}

// WorkloadNetworkDhcp NSX DHCP
type WorkloadNetworkDhcp struct {
	autorest.Response `json:"-"`
	// Properties - DHCP properties.
	Properties BasicWorkloadNetworkDhcpEntity `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcp.
func (wnd WorkloadNetworkDhcp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wnd.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkDhcp struct.
func (wnd *WorkloadNetworkDhcp) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadNetworkDhcpEntity(*v)
				if err != nil {
					return err
				}
				wnd.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnd.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicWorkloadNetworkDhcpEntity base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit from
type BasicWorkloadNetworkDhcpEntity interface {
	AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool)
	AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool)
	AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool)
}

// WorkloadNetworkDhcpEntity base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit
// from
type WorkloadNetworkDhcpEntity struct {
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

func unmarshalBasicWorkloadNetworkDhcpEntity(body []byte) (BasicWorkloadNetworkDhcpEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["dhcpType"] {
	case string(DhcpTypeSERVER):
		var wnds WorkloadNetworkDhcpServer
		err := json.Unmarshal(body, &wnds)
		return wnds, err
	case string(DhcpTypeRELAY):
		var wndr WorkloadNetworkDhcpRelay
		err := json.Unmarshal(body, &wndr)
		return wndr, err
	default:
		var wnde WorkloadNetworkDhcpEntity
		err := json.Unmarshal(body, &wnde)
		return wnde, err
	}
}
func unmarshalBasicWorkloadNetworkDhcpEntityArray(body []byte) ([]BasicWorkloadNetworkDhcpEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wndeArray := make([]BasicWorkloadNetworkDhcpEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wnde, err := unmarshalBasicWorkloadNetworkDhcpEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		wndeArray[index] = wnde
	}
	return wndeArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) MarshalJSON() ([]byte, error) {
	wnde.DhcpType = DhcpTypeWorkloadNetworkDhcpEntity
	objectMap := make(map[string]interface{})
	if wnde.DisplayName != nil {
		objectMap["displayName"] = wnde.DisplayName
	}
	if wnde.Revision != nil {
		objectMap["revision"] = wnde.Revision
	}
	if wnde.DhcpType != "" {
		objectMap["dhcpType"] = wnde.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return &wnde, true
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wnde, true
}

// WorkloadNetworkDhcpList a list of NSX dhcp entities
type WorkloadNetworkDhcpList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkDhcp `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpList.
func (wndl WorkloadNetworkDhcpList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkDhcpListIterator provides access to a complete listing of WorkloadNetworkDhcp values.
type WorkloadNetworkDhcpListIterator struct {
	i    int
	page WorkloadNetworkDhcpListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkDhcpListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDhcpListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkDhcpListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkDhcpListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkDhcpListIterator) Response() WorkloadNetworkDhcpList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkDhcpListIterator) Value() WorkloadNetworkDhcp {
	if !iter.page.NotDone() {
		return WorkloadNetworkDhcp{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkDhcpListIterator type.
func NewWorkloadNetworkDhcpListIterator(page WorkloadNetworkDhcpListPage) WorkloadNetworkDhcpListIterator {
	return WorkloadNetworkDhcpListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wndl WorkloadNetworkDhcpList) IsEmpty() bool {
	return wndl.Value == nil || len(*wndl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wndl WorkloadNetworkDhcpList) hasNextLink() bool {
	return wndl.NextLink != nil && len(*wndl.NextLink) != 0
}

// workloadNetworkDhcpListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wndl WorkloadNetworkDhcpList) workloadNetworkDhcpListPreparer(ctx context.Context) (*http.Request, error) {
	if !wndl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wndl.NextLink)))
}

// WorkloadNetworkDhcpListPage contains a page of WorkloadNetworkDhcp values.
type WorkloadNetworkDhcpListPage struct {
	fn   func(context.Context, WorkloadNetworkDhcpList) (WorkloadNetworkDhcpList, error)
	wndl WorkloadNetworkDhcpList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkDhcpListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDhcpListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wndl)
		if err != nil {
			return err
		}
		page.wndl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkDhcpListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkDhcpListPage) NotDone() bool {
	return !page.wndl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkDhcpListPage) Response() WorkloadNetworkDhcpList {
	return page.wndl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkDhcpListPage) Values() []WorkloadNetworkDhcp {
	if page.wndl.IsEmpty() {
		return nil
	}
	return *page.wndl.Value
}

// Creates a new instance of the WorkloadNetworkDhcpListPage type.
func NewWorkloadNetworkDhcpListPage(cur WorkloadNetworkDhcpList, getNextPage func(context.Context, WorkloadNetworkDhcpList) (WorkloadNetworkDhcpList, error)) WorkloadNetworkDhcpListPage {
	return WorkloadNetworkDhcpListPage{
		fn:   getNextPage,
		wndl: cur,
	}
}

// WorkloadNetworkDhcpRelay NSX DHCP Relay
type WorkloadNetworkDhcpRelay struct {
	// ServerAddresses - DHCP Relay Addresses. Max 3.
	ServerAddresses *[]string `json:"serverAddresses,omitempty"`
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) MarshalJSON() ([]byte, error) {
	wndr.DhcpType = DhcpTypeRELAY
	objectMap := make(map[string]interface{})
	if wndr.ServerAddresses != nil {
		objectMap["serverAddresses"] = wndr.ServerAddresses
	}
	if wndr.DisplayName != nil {
		objectMap["displayName"] = wndr.DisplayName
	}
	if wndr.Revision != nil {
		objectMap["revision"] = wndr.Revision
	}
	if wndr.DhcpType != "" {
		objectMap["dhcpType"] = wndr.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return &wndr, true
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return nil, false
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wndr, true
}

// WorkloadNetworkDhcpServer NSX DHCP Server
type WorkloadNetworkDhcpServer struct {
	// ServerAddress - DHCP Server Address.
	ServerAddress *string `json:"serverAddress,omitempty"`
	// LeaseTime - DHCP Server Lease Time.
	LeaseTime *int64 `json:"leaseTime,omitempty"`
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) MarshalJSON() ([]byte, error) {
	wnds.DhcpType = DhcpTypeSERVER
	objectMap := make(map[string]interface{})
	if wnds.ServerAddress != nil {
		objectMap["serverAddress"] = wnds.ServerAddress
	}
	if wnds.LeaseTime != nil {
		objectMap["leaseTime"] = wnds.LeaseTime
	}
	if wnds.DisplayName != nil {
		objectMap["displayName"] = wnds.DisplayName
	}
	if wnds.Revision != nil {
		objectMap["revision"] = wnds.Revision
	}
	if wnds.DhcpType != "" {
		objectMap["dhcpType"] = wnds.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return &wnds, true
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return nil, false
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wnds, true
}

// WorkloadNetworkDNSService NSX DNS Service
type WorkloadNetworkDNSService struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkDNSServiceProperties - DNS Service properties
	*WorkloadNetworkDNSServiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSService.
func (wnds WorkloadNetworkDNSService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnds.WorkloadNetworkDNSServiceProperties != nil {
		objectMap["properties"] = wnds.WorkloadNetworkDNSServiceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkDNSService struct.
func (wnds *WorkloadNetworkDNSService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkDNSServiceProperties WorkloadNetworkDNSServiceProperties
				err = json.Unmarshal(*v, &workloadNetworkDNSServiceProperties)
				if err != nil {
					return err
				}
				wnds.WorkloadNetworkDNSServiceProperties = &workloadNetworkDNSServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnds.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnds.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkDNSServiceProperties NSX DNS Service Properties
type WorkloadNetworkDNSServiceProperties struct {
	// DisplayName - Display name of the DNS Service.
	DisplayName *string `json:"displayName,omitempty"`
	// DNSServiceIP - DNS service IP of the DNS Service.
	DNSServiceIP *string `json:"dnsServiceIp,omitempty"`
	// DefaultDNSZone - Default DNS zone of the DNS Service.
	DefaultDNSZone *string `json:"defaultDnsZone,omitempty"`
	// FqdnZones - FQDN zones of the DNS Service.
	FqdnZones *[]string `json:"fqdnZones,omitempty"`
	// LogLevel - DNS Service log level. Possible values include: 'DNSServiceLogLevelEnumDEBUG', 'DNSServiceLogLevelEnumINFO', 'DNSServiceLogLevelEnumWARNING', 'DNSServiceLogLevelEnumERROR', 'DNSServiceLogLevelEnumFATAL'
	LogLevel DNSServiceLogLevelEnum `json:"logLevel,omitempty"`
	// Status - READ-ONLY; DNS Service status. Possible values include: 'DNSServiceStatusEnumSUCCESS', 'DNSServiceStatusEnumFAILURE'
	Status DNSServiceStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDNSServiceProvisioningStateSucceeded', 'WorkloadNetworkDNSServiceProvisioningStateFailed', 'WorkloadNetworkDNSServiceProvisioningStateBuilding', 'WorkloadNetworkDNSServiceProvisioningStateDeleting', 'WorkloadNetworkDNSServiceProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDNSServiceProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSServiceProperties.
func (wndsp WorkloadNetworkDNSServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wndsp.DisplayName != nil {
		objectMap["displayName"] = wndsp.DisplayName
	}
	if wndsp.DNSServiceIP != nil {
		objectMap["dnsServiceIp"] = wndsp.DNSServiceIP
	}
	if wndsp.DefaultDNSZone != nil {
		objectMap["defaultDnsZone"] = wndsp.DefaultDNSZone
	}
	if wndsp.FqdnZones != nil {
		objectMap["fqdnZones"] = wndsp.FqdnZones
	}
	if wndsp.LogLevel != "" {
		objectMap["logLevel"] = wndsp.LogLevel
	}
	if wndsp.Revision != nil {
		objectMap["revision"] = wndsp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkDNSServicesList a list of NSX DNS Services
type WorkloadNetworkDNSServicesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkDNSService `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSServicesList.
func (wndsl WorkloadNetworkDNSServicesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkDNSServicesListIterator provides access to a complete listing of
// WorkloadNetworkDNSService values.
type WorkloadNetworkDNSServicesListIterator struct {
	i    int
	page WorkloadNetworkDNSServicesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkDNSServicesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDNSServicesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkDNSServicesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkDNSServicesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkDNSServicesListIterator) Response() WorkloadNetworkDNSServicesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkDNSServicesListIterator) Value() WorkloadNetworkDNSService {
	if !iter.page.NotDone() {
		return WorkloadNetworkDNSService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkDNSServicesListIterator type.
func NewWorkloadNetworkDNSServicesListIterator(page WorkloadNetworkDNSServicesListPage) WorkloadNetworkDNSServicesListIterator {
	return WorkloadNetworkDNSServicesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wndsl WorkloadNetworkDNSServicesList) IsEmpty() bool {
	return wndsl.Value == nil || len(*wndsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wndsl WorkloadNetworkDNSServicesList) hasNextLink() bool {
	return wndsl.NextLink != nil && len(*wndsl.NextLink) != 0
}

// workloadNetworkDNSServicesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wndsl WorkloadNetworkDNSServicesList) workloadNetworkDNSServicesListPreparer(ctx context.Context) (*http.Request, error) {
	if !wndsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wndsl.NextLink)))
}

// WorkloadNetworkDNSServicesListPage contains a page of WorkloadNetworkDNSService values.
type WorkloadNetworkDNSServicesListPage struct {
	fn    func(context.Context, WorkloadNetworkDNSServicesList) (WorkloadNetworkDNSServicesList, error)
	wndsl WorkloadNetworkDNSServicesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkDNSServicesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDNSServicesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wndsl)
		if err != nil {
			return err
		}
		page.wndsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkDNSServicesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkDNSServicesListPage) NotDone() bool {
	return !page.wndsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkDNSServicesListPage) Response() WorkloadNetworkDNSServicesList {
	return page.wndsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkDNSServicesListPage) Values() []WorkloadNetworkDNSService {
	if page.wndsl.IsEmpty() {
		return nil
	}
	return *page.wndsl.Value
}

// Creates a new instance of the WorkloadNetworkDNSServicesListPage type.
func NewWorkloadNetworkDNSServicesListPage(cur WorkloadNetworkDNSServicesList, getNextPage func(context.Context, WorkloadNetworkDNSServicesList) (WorkloadNetworkDNSServicesList, error)) WorkloadNetworkDNSServicesListPage {
	return WorkloadNetworkDNSServicesListPage{
		fn:    getNextPage,
		wndsl: cur,
	}
}

// WorkloadNetworkDNSZone NSX DNS Zone
type WorkloadNetworkDNSZone struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkDNSZoneProperties - DNS Zone properties
	*WorkloadNetworkDNSZoneProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSZone.
func (wndz WorkloadNetworkDNSZone) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wndz.WorkloadNetworkDNSZoneProperties != nil {
		objectMap["properties"] = wndz.WorkloadNetworkDNSZoneProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkDNSZone struct.
func (wndz *WorkloadNetworkDNSZone) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkDNSZoneProperties WorkloadNetworkDNSZoneProperties
				err = json.Unmarshal(*v, &workloadNetworkDNSZoneProperties)
				if err != nil {
					return err
				}
				wndz.WorkloadNetworkDNSZoneProperties = &workloadNetworkDNSZoneProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wndz.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wndz.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wndz.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkDNSZoneProperties NSX DNS Zone Properties
type WorkloadNetworkDNSZoneProperties struct {
	// DisplayName - Display name of the DNS Zone.
	DisplayName *string `json:"displayName,omitempty"`
	// Domain - Domain names of the DNS Zone.
	Domain *[]string `json:"domain,omitempty"`
	// DNSServerIps - DNS Server IP array of the DNS Zone.
	DNSServerIps *[]string `json:"dnsServerIps,omitempty"`
	// SourceIP - Source IP of the DNS Zone.
	SourceIP *string `json:"sourceIp,omitempty"`
	// DNSServices - Number of DNS Services using the DNS zone.
	DNSServices *int64 `json:"dnsServices,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDNSZoneProvisioningStateSucceeded', 'WorkloadNetworkDNSZoneProvisioningStateFailed', 'WorkloadNetworkDNSZoneProvisioningStateBuilding', 'WorkloadNetworkDNSZoneProvisioningStateDeleting', 'WorkloadNetworkDNSZoneProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDNSZoneProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSZoneProperties.
func (wndzp WorkloadNetworkDNSZoneProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wndzp.DisplayName != nil {
		objectMap["displayName"] = wndzp.DisplayName
	}
	if wndzp.Domain != nil {
		objectMap["domain"] = wndzp.Domain
	}
	if wndzp.DNSServerIps != nil {
		objectMap["dnsServerIps"] = wndzp.DNSServerIps
	}
	if wndzp.SourceIP != nil {
		objectMap["sourceIp"] = wndzp.SourceIP
	}
	if wndzp.DNSServices != nil {
		objectMap["dnsServices"] = wndzp.DNSServices
	}
	if wndzp.Revision != nil {
		objectMap["revision"] = wndzp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkDNSZonesList a list of NSX DNS Zones
type WorkloadNetworkDNSZonesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkDNSZone `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDNSZonesList.
func (wndzl WorkloadNetworkDNSZonesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkDNSZonesListIterator provides access to a complete listing of WorkloadNetworkDNSZone
// values.
type WorkloadNetworkDNSZonesListIterator struct {
	i    int
	page WorkloadNetworkDNSZonesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkDNSZonesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDNSZonesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkDNSZonesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkDNSZonesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkDNSZonesListIterator) Response() WorkloadNetworkDNSZonesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkDNSZonesListIterator) Value() WorkloadNetworkDNSZone {
	if !iter.page.NotDone() {
		return WorkloadNetworkDNSZone{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkDNSZonesListIterator type.
func NewWorkloadNetworkDNSZonesListIterator(page WorkloadNetworkDNSZonesListPage) WorkloadNetworkDNSZonesListIterator {
	return WorkloadNetworkDNSZonesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wndzl WorkloadNetworkDNSZonesList) IsEmpty() bool {
	return wndzl.Value == nil || len(*wndzl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wndzl WorkloadNetworkDNSZonesList) hasNextLink() bool {
	return wndzl.NextLink != nil && len(*wndzl.NextLink) != 0
}

// workloadNetworkDNSZonesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wndzl WorkloadNetworkDNSZonesList) workloadNetworkDNSZonesListPreparer(ctx context.Context) (*http.Request, error) {
	if !wndzl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wndzl.NextLink)))
}

// WorkloadNetworkDNSZonesListPage contains a page of WorkloadNetworkDNSZone values.
type WorkloadNetworkDNSZonesListPage struct {
	fn    func(context.Context, WorkloadNetworkDNSZonesList) (WorkloadNetworkDNSZonesList, error)
	wndzl WorkloadNetworkDNSZonesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkDNSZonesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDNSZonesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wndzl)
		if err != nil {
			return err
		}
		page.wndzl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkDNSZonesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkDNSZonesListPage) NotDone() bool {
	return !page.wndzl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkDNSZonesListPage) Response() WorkloadNetworkDNSZonesList {
	return page.wndzl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkDNSZonesListPage) Values() []WorkloadNetworkDNSZone {
	if page.wndzl.IsEmpty() {
		return nil
	}
	return *page.wndzl.Value
}

// Creates a new instance of the WorkloadNetworkDNSZonesListPage type.
func NewWorkloadNetworkDNSZonesListPage(cur WorkloadNetworkDNSZonesList, getNextPage func(context.Context, WorkloadNetworkDNSZonesList) (WorkloadNetworkDNSZonesList, error)) WorkloadNetworkDNSZonesListPage {
	return WorkloadNetworkDNSZonesListPage{
		fn:    getNextPage,
		wndzl: cur,
	}
}

// WorkloadNetworkGateway NSX Gateway.
type WorkloadNetworkGateway struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkGatewayProperties - Gateway properties.
	*WorkloadNetworkGatewayProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkGateway.
func (wng WorkloadNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wng.WorkloadNetworkGatewayProperties != nil {
		objectMap["properties"] = wng.WorkloadNetworkGatewayProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkGateway struct.
func (wng *WorkloadNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkGatewayProperties WorkloadNetworkGatewayProperties
				err = json.Unmarshal(*v, &workloadNetworkGatewayProperties)
				if err != nil {
					return err
				}
				wng.WorkloadNetworkGatewayProperties = &workloadNetworkGatewayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wng.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkGatewayList a list of NSX Gateways
type WorkloadNetworkGatewayList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkGateway `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkGatewayList.
func (wngl WorkloadNetworkGatewayList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkGatewayListIterator provides access to a complete listing of WorkloadNetworkGateway
// values.
type WorkloadNetworkGatewayListIterator struct {
	i    int
	page WorkloadNetworkGatewayListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkGatewayListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkGatewayListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkGatewayListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkGatewayListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkGatewayListIterator) Response() WorkloadNetworkGatewayList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkGatewayListIterator) Value() WorkloadNetworkGateway {
	if !iter.page.NotDone() {
		return WorkloadNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkGatewayListIterator type.
func NewWorkloadNetworkGatewayListIterator(page WorkloadNetworkGatewayListPage) WorkloadNetworkGatewayListIterator {
	return WorkloadNetworkGatewayListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wngl WorkloadNetworkGatewayList) IsEmpty() bool {
	return wngl.Value == nil || len(*wngl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wngl WorkloadNetworkGatewayList) hasNextLink() bool {
	return wngl.NextLink != nil && len(*wngl.NextLink) != 0
}

// workloadNetworkGatewayListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wngl WorkloadNetworkGatewayList) workloadNetworkGatewayListPreparer(ctx context.Context) (*http.Request, error) {
	if !wngl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wngl.NextLink)))
}

// WorkloadNetworkGatewayListPage contains a page of WorkloadNetworkGateway values.
type WorkloadNetworkGatewayListPage struct {
	fn   func(context.Context, WorkloadNetworkGatewayList) (WorkloadNetworkGatewayList, error)
	wngl WorkloadNetworkGatewayList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkGatewayListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkGatewayListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wngl)
		if err != nil {
			return err
		}
		page.wngl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkGatewayListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkGatewayListPage) NotDone() bool {
	return !page.wngl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkGatewayListPage) Response() WorkloadNetworkGatewayList {
	return page.wngl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkGatewayListPage) Values() []WorkloadNetworkGateway {
	if page.wngl.IsEmpty() {
		return nil
	}
	return *page.wngl.Value
}

// Creates a new instance of the WorkloadNetworkGatewayListPage type.
func NewWorkloadNetworkGatewayListPage(cur WorkloadNetworkGatewayList, getNextPage func(context.Context, WorkloadNetworkGatewayList) (WorkloadNetworkGatewayList, error)) WorkloadNetworkGatewayListPage {
	return WorkloadNetworkGatewayListPage{
		fn:   getNextPage,
		wngl: cur,
	}
}

// WorkloadNetworkGatewayProperties properties of a NSX Gateway.
type WorkloadNetworkGatewayProperties struct {
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Path - READ-ONLY; NSX Gateway Path.
	Path *string `json:"path,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkGatewayProperties.
func (wngp WorkloadNetworkGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wngp.DisplayName != nil {
		objectMap["displayName"] = wngp.DisplayName
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkPortMirroring NSX Port Mirroring
type WorkloadNetworkPortMirroring struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkPortMirroringProperties - Port Mirroring Properties.
	*WorkloadNetworkPortMirroringProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPortMirroring.
func (wnpm WorkloadNetworkPortMirroring) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpm.WorkloadNetworkPortMirroringProperties != nil {
		objectMap["properties"] = wnpm.WorkloadNetworkPortMirroringProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkPortMirroring struct.
func (wnpm *WorkloadNetworkPortMirroring) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkPortMirroringProperties WorkloadNetworkPortMirroringProperties
				err = json.Unmarshal(*v, &workloadNetworkPortMirroringProperties)
				if err != nil {
					return err
				}
				wnpm.WorkloadNetworkPortMirroringProperties = &workloadNetworkPortMirroringProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnpm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnpm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnpm.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkPortMirroringList a list of NSX Port Mirroring
type WorkloadNetworkPortMirroringList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkPortMirroring `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPortMirroringList.
func (wnpml WorkloadNetworkPortMirroringList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkPortMirroringListIterator provides access to a complete listing of
// WorkloadNetworkPortMirroring values.
type WorkloadNetworkPortMirroringListIterator struct {
	i    int
	page WorkloadNetworkPortMirroringListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkPortMirroringListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPortMirroringListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkPortMirroringListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkPortMirroringListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkPortMirroringListIterator) Response() WorkloadNetworkPortMirroringList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkPortMirroringListIterator) Value() WorkloadNetworkPortMirroring {
	if !iter.page.NotDone() {
		return WorkloadNetworkPortMirroring{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkPortMirroringListIterator type.
func NewWorkloadNetworkPortMirroringListIterator(page WorkloadNetworkPortMirroringListPage) WorkloadNetworkPortMirroringListIterator {
	return WorkloadNetworkPortMirroringListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnpml WorkloadNetworkPortMirroringList) IsEmpty() bool {
	return wnpml.Value == nil || len(*wnpml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnpml WorkloadNetworkPortMirroringList) hasNextLink() bool {
	return wnpml.NextLink != nil && len(*wnpml.NextLink) != 0
}

// workloadNetworkPortMirroringListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnpml WorkloadNetworkPortMirroringList) workloadNetworkPortMirroringListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnpml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnpml.NextLink)))
}

// WorkloadNetworkPortMirroringListPage contains a page of WorkloadNetworkPortMirroring values.
type WorkloadNetworkPortMirroringListPage struct {
	fn    func(context.Context, WorkloadNetworkPortMirroringList) (WorkloadNetworkPortMirroringList, error)
	wnpml WorkloadNetworkPortMirroringList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkPortMirroringListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPortMirroringListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnpml)
		if err != nil {
			return err
		}
		page.wnpml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkPortMirroringListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkPortMirroringListPage) NotDone() bool {
	return !page.wnpml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkPortMirroringListPage) Response() WorkloadNetworkPortMirroringList {
	return page.wnpml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkPortMirroringListPage) Values() []WorkloadNetworkPortMirroring {
	if page.wnpml.IsEmpty() {
		return nil
	}
	return *page.wnpml.Value
}

// Creates a new instance of the WorkloadNetworkPortMirroringListPage type.
func NewWorkloadNetworkPortMirroringListPage(cur WorkloadNetworkPortMirroringList, getNextPage func(context.Context, WorkloadNetworkPortMirroringList) (WorkloadNetworkPortMirroringList, error)) WorkloadNetworkPortMirroringListPage {
	return WorkloadNetworkPortMirroringListPage{
		fn:    getNextPage,
		wnpml: cur,
	}
}

// WorkloadNetworkPortMirroringProperties NSX Port Mirroring Properties
type WorkloadNetworkPortMirroringProperties struct {
	// DisplayName - Display name of the port mirroring profile.
	DisplayName *string `json:"displayName,omitempty"`
	// Direction - Direction of port mirroring profile. Possible values include: 'PortMirroringDirectionEnumINGRESS', 'PortMirroringDirectionEnumEGRESS', 'PortMirroringDirectionEnumBIDIRECTIONAL'
	Direction PortMirroringDirectionEnum `json:"direction,omitempty"`
	// Source - Source VM Group.
	Source *string `json:"source,omitempty"`
	// Destination - Destination VM Group.
	Destination *string `json:"destination,omitempty"`
	// Status - READ-ONLY; Port Mirroring Status. Possible values include: 'PortMirroringStatusEnumSUCCESS', 'PortMirroringStatusEnumFAILURE'
	Status PortMirroringStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkPortMirroringProvisioningStateSucceeded', 'WorkloadNetworkPortMirroringProvisioningStateFailed', 'WorkloadNetworkPortMirroringProvisioningStateBuilding', 'WorkloadNetworkPortMirroringProvisioningStateDeleting', 'WorkloadNetworkPortMirroringProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkPortMirroringProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPortMirroringProperties.
func (wnpmp WorkloadNetworkPortMirroringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpmp.DisplayName != nil {
		objectMap["displayName"] = wnpmp.DisplayName
	}
	if wnpmp.Direction != "" {
		objectMap["direction"] = wnpmp.Direction
	}
	if wnpmp.Source != nil {
		objectMap["source"] = wnpmp.Source
	}
	if wnpmp.Destination != nil {
		objectMap["destination"] = wnpmp.Destination
	}
	if wnpmp.Revision != nil {
		objectMap["revision"] = wnpmp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkPublicIP NSX Public IP Block
type WorkloadNetworkPublicIP struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkPublicIPProperties - Public IP Block properties
	*WorkloadNetworkPublicIPProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPublicIP.
func (wnpi WorkloadNetworkPublicIP) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpi.WorkloadNetworkPublicIPProperties != nil {
		objectMap["properties"] = wnpi.WorkloadNetworkPublicIPProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkPublicIP struct.
func (wnpi *WorkloadNetworkPublicIP) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkPublicIPProperties WorkloadNetworkPublicIPProperties
				err = json.Unmarshal(*v, &workloadNetworkPublicIPProperties)
				if err != nil {
					return err
				}
				wnpi.WorkloadNetworkPublicIPProperties = &workloadNetworkPublicIPProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnpi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnpi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnpi.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkPublicIPProperties NSX Public IP Block Properties
type WorkloadNetworkPublicIPProperties struct {
	// DisplayName - Display name of the Public IP Block.
	DisplayName *string `json:"displayName,omitempty"`
	// NumberOfPublicIPs - Number of Public IPs requested.
	NumberOfPublicIPs *int64 `json:"numberOfPublicIPs,omitempty"`
	// PublicIPBlock - READ-ONLY; CIDR Block of the Public IP Block.
	PublicIPBlock *string `json:"publicIPBlock,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkPublicIPProvisioningStateSucceeded', 'WorkloadNetworkPublicIPProvisioningStateFailed', 'WorkloadNetworkPublicIPProvisioningStateBuilding', 'WorkloadNetworkPublicIPProvisioningStateDeleting', 'WorkloadNetworkPublicIPProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkPublicIPProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPublicIPProperties.
func (wnpip WorkloadNetworkPublicIPProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpip.DisplayName != nil {
		objectMap["displayName"] = wnpip.DisplayName
	}
	if wnpip.NumberOfPublicIPs != nil {
		objectMap["numberOfPublicIPs"] = wnpip.NumberOfPublicIPs
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkPublicIPsList a list of NSX Public IP Blocks
type WorkloadNetworkPublicIPsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkPublicIP `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPublicIPsList.
func (wnpipl WorkloadNetworkPublicIPsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkPublicIPsListIterator provides access to a complete listing of WorkloadNetworkPublicIP
// values.
type WorkloadNetworkPublicIPsListIterator struct {
	i    int
	page WorkloadNetworkPublicIPsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkPublicIPsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPublicIPsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkPublicIPsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkPublicIPsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkPublicIPsListIterator) Response() WorkloadNetworkPublicIPsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkPublicIPsListIterator) Value() WorkloadNetworkPublicIP {
	if !iter.page.NotDone() {
		return WorkloadNetworkPublicIP{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkPublicIPsListIterator type.
func NewWorkloadNetworkPublicIPsListIterator(page WorkloadNetworkPublicIPsListPage) WorkloadNetworkPublicIPsListIterator {
	return WorkloadNetworkPublicIPsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnpipl WorkloadNetworkPublicIPsList) IsEmpty() bool {
	return wnpipl.Value == nil || len(*wnpipl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnpipl WorkloadNetworkPublicIPsList) hasNextLink() bool {
	return wnpipl.NextLink != nil && len(*wnpipl.NextLink) != 0
}

// workloadNetworkPublicIPsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnpipl WorkloadNetworkPublicIPsList) workloadNetworkPublicIPsListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnpipl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnpipl.NextLink)))
}

// WorkloadNetworkPublicIPsListPage contains a page of WorkloadNetworkPublicIP values.
type WorkloadNetworkPublicIPsListPage struct {
	fn     func(context.Context, WorkloadNetworkPublicIPsList) (WorkloadNetworkPublicIPsList, error)
	wnpipl WorkloadNetworkPublicIPsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkPublicIPsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPublicIPsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnpipl)
		if err != nil {
			return err
		}
		page.wnpipl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkPublicIPsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkPublicIPsListPage) NotDone() bool {
	return !page.wnpipl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkPublicIPsListPage) Response() WorkloadNetworkPublicIPsList {
	return page.wnpipl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkPublicIPsListPage) Values() []WorkloadNetworkPublicIP {
	if page.wnpipl.IsEmpty() {
		return nil
	}
	return *page.wnpipl.Value
}

// Creates a new instance of the WorkloadNetworkPublicIPsListPage type.
func NewWorkloadNetworkPublicIPsListPage(cur WorkloadNetworkPublicIPsList, getNextPage func(context.Context, WorkloadNetworkPublicIPsList) (WorkloadNetworkPublicIPsList, error)) WorkloadNetworkPublicIPsListPage {
	return WorkloadNetworkPublicIPsListPage{
		fn:     getNextPage,
		wnpipl: cur,
	}
}

// WorkloadNetworksCreateDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDhcp, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateDhcpFuture.Result.
func (future *WorkloadNetworksCreateDhcpFuture) result(client WorkloadNetworksClient) (wnd WorkloadNetworkDhcp, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateDhcpFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnd.Response.Response, err = future.GetResult(sender); err == nil && wnd.Response.Response.StatusCode != http.StatusNoContent {
		wnd, err = client.CreateDhcpResponder(wnd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDhcpFuture", "Result", wnd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateDNSServiceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateDNSServiceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDNSService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateDNSServiceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateDNSServiceFuture.Result.
func (future *WorkloadNetworksCreateDNSServiceFuture) result(client WorkloadNetworksClient) (wnds WorkloadNetworkDNSService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDNSServiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnds.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateDNSServiceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnds.Response.Response, err = future.GetResult(sender); err == nil && wnds.Response.Response.StatusCode != http.StatusNoContent {
		wnds, err = client.CreateDNSServiceResponder(wnds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDNSServiceFuture", "Result", wnds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateDNSZoneFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateDNSZoneFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDNSZone, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateDNSZoneFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateDNSZoneFuture.Result.
func (future *WorkloadNetworksCreateDNSZoneFuture) result(client WorkloadNetworksClient) (wndz WorkloadNetworkDNSZone, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDNSZoneFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wndz.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateDNSZoneFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wndz.Response.Response, err = future.GetResult(sender); err == nil && wndz.Response.Response.StatusCode != http.StatusNoContent {
		wndz, err = client.CreateDNSZoneResponder(wndz.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDNSZoneFuture", "Result", wndz.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreatePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreatePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkPortMirroring, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreatePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreatePortMirroringFuture.Result.
func (future *WorkloadNetworksCreatePortMirroringFuture) result(client WorkloadNetworksClient) (wnpm WorkloadNetworkPortMirroring, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnpm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreatePortMirroringFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnpm.Response.Response, err = future.GetResult(sender); err == nil && wnpm.Response.Response.StatusCode != http.StatusNoContent {
		wnpm, err = client.CreatePortMirroringResponder(wnpm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePortMirroringFuture", "Result", wnpm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreatePublicIPFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreatePublicIPFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkPublicIP, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreatePublicIPFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreatePublicIPFuture.Result.
func (future *WorkloadNetworksCreatePublicIPFuture) result(client WorkloadNetworksClient) (wnpi WorkloadNetworkPublicIP, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePublicIPFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnpi.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreatePublicIPFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnpi.Response.Response, err = future.GetResult(sender); err == nil && wnpi.Response.Response.StatusCode != http.StatusNoContent {
		wnpi, err = client.CreatePublicIPResponder(wnpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePublicIPFuture", "Result", wnpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateSegmentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateSegmentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkSegment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateSegmentsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateSegmentsFuture.Result.
func (future *WorkloadNetworksCreateSegmentsFuture) result(client WorkloadNetworksClient) (wns WorkloadNetworkSegment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateSegmentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wns.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateSegmentsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wns.Response.Response, err = future.GetResult(sender); err == nil && wns.Response.Response.StatusCode != http.StatusNoContent {
		wns, err = client.CreateSegmentsResponder(wns.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateSegmentsFuture", "Result", wns.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkVMGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateVMGroupFuture.Result.
func (future *WorkloadNetworksCreateVMGroupFuture) result(client WorkloadNetworksClient) (wnvg WorkloadNetworkVMGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnvg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateVMGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnvg.Response.Response, err = future.GetResult(sender); err == nil && wnvg.Response.Response.StatusCode != http.StatusNoContent {
		wnvg, err = client.CreateVMGroupResponder(wnvg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateVMGroupFuture", "Result", wnvg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksDeleteDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteDhcpFuture.Result.
func (future *WorkloadNetworksDeleteDhcpFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteDhcpFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteDNSServiceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteDNSServiceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteDNSServiceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteDNSServiceFuture.Result.
func (future *WorkloadNetworksDeleteDNSServiceFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteDNSServiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteDNSServiceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteDNSZoneFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteDNSZoneFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteDNSZoneFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteDNSZoneFuture.Result.
func (future *WorkloadNetworksDeleteDNSZoneFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteDNSZoneFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteDNSZoneFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeletePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeletePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeletePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeletePortMirroringFuture.Result.
func (future *WorkloadNetworksDeletePortMirroringFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeletePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeletePortMirroringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeletePublicIPFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeletePublicIPFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeletePublicIPFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeletePublicIPFuture.Result.
func (future *WorkloadNetworksDeletePublicIPFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeletePublicIPFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeletePublicIPFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteSegmentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteSegmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteSegmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteSegmentFuture.Result.
func (future *WorkloadNetworksDeleteSegmentFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteSegmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteSegmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteVMGroupFuture.Result.
func (future *WorkloadNetworksDeleteVMGroupFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteVMGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworkSegment NSX Segment
type WorkloadNetworkSegment struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkSegmentProperties - The properties of a Workload Segment proxy resource.
	*WorkloadNetworkSegmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkSegment.
func (wns WorkloadNetworkSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wns.WorkloadNetworkSegmentProperties != nil {
		objectMap["properties"] = wns.WorkloadNetworkSegmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkSegment struct.
func (wns *WorkloadNetworkSegment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkSegmentProperties WorkloadNetworkSegmentProperties
				err = json.Unmarshal(*v, &workloadNetworkSegmentProperties)
				if err != nil {
					return err
				}
				wns.WorkloadNetworkSegmentProperties = &workloadNetworkSegmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wns.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkSegmentPortVif ports and any VIF attached to segment.
type WorkloadNetworkSegmentPortVif struct {
	// PortName - Name of port or VIF attached to segment.
	PortName *string `json:"portName,omitempty"`
}

// WorkloadNetworkSegmentProperties NSX Segment Properties
type WorkloadNetworkSegmentProperties struct {
	// DisplayName - Display name of the segment.
	DisplayName *string `json:"displayName,omitempty"`
	// ConnectedGateway - Gateway which to connect segment to.
	ConnectedGateway *string `json:"connectedGateway,omitempty"`
	// Subnet - Subnet which to connect segment to.
	Subnet *WorkloadNetworkSegmentSubnet `json:"subnet,omitempty"`
	// PortVif - READ-ONLY; Port Vif which segment is associated with.
	PortVif *[]WorkloadNetworkSegmentPortVif `json:"portVif,omitempty"`
	// Status - READ-ONLY; Segment status. Possible values include: 'SegmentStatusEnumSUCCESS', 'SegmentStatusEnumFAILURE'
	Status SegmentStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkSegmentProvisioningStateSucceeded', 'WorkloadNetworkSegmentProvisioningStateFailed', 'WorkloadNetworkSegmentProvisioningStateBuilding', 'WorkloadNetworkSegmentProvisioningStateDeleting', 'WorkloadNetworkSegmentProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkSegmentProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkSegmentProperties.
func (wnsp WorkloadNetworkSegmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnsp.DisplayName != nil {
		objectMap["displayName"] = wnsp.DisplayName
	}
	if wnsp.ConnectedGateway != nil {
		objectMap["connectedGateway"] = wnsp.ConnectedGateway
	}
	if wnsp.Subnet != nil {
		objectMap["subnet"] = wnsp.Subnet
	}
	if wnsp.Revision != nil {
		objectMap["revision"] = wnsp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkSegmentsList a list of NSX Segments
type WorkloadNetworkSegmentsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkSegment `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkSegmentsList.
func (wnsl WorkloadNetworkSegmentsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkSegmentsListIterator provides access to a complete listing of WorkloadNetworkSegment
// values.
type WorkloadNetworkSegmentsListIterator struct {
	i    int
	page WorkloadNetworkSegmentsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkSegmentsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkSegmentsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkSegmentsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkSegmentsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkSegmentsListIterator) Response() WorkloadNetworkSegmentsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkSegmentsListIterator) Value() WorkloadNetworkSegment {
	if !iter.page.NotDone() {
		return WorkloadNetworkSegment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkSegmentsListIterator type.
func NewWorkloadNetworkSegmentsListIterator(page WorkloadNetworkSegmentsListPage) WorkloadNetworkSegmentsListIterator {
	return WorkloadNetworkSegmentsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnsl WorkloadNetworkSegmentsList) IsEmpty() bool {
	return wnsl.Value == nil || len(*wnsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnsl WorkloadNetworkSegmentsList) hasNextLink() bool {
	return wnsl.NextLink != nil && len(*wnsl.NextLink) != 0
}

// workloadNetworkSegmentsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnsl WorkloadNetworkSegmentsList) workloadNetworkSegmentsListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnsl.NextLink)))
}

// WorkloadNetworkSegmentsListPage contains a page of WorkloadNetworkSegment values.
type WorkloadNetworkSegmentsListPage struct {
	fn   func(context.Context, WorkloadNetworkSegmentsList) (WorkloadNetworkSegmentsList, error)
	wnsl WorkloadNetworkSegmentsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkSegmentsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkSegmentsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnsl)
		if err != nil {
			return err
		}
		page.wnsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkSegmentsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkSegmentsListPage) NotDone() bool {
	return !page.wnsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkSegmentsListPage) Response() WorkloadNetworkSegmentsList {
	return page.wnsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkSegmentsListPage) Values() []WorkloadNetworkSegment {
	if page.wnsl.IsEmpty() {
		return nil
	}
	return *page.wnsl.Value
}

// Creates a new instance of the WorkloadNetworkSegmentsListPage type.
func NewWorkloadNetworkSegmentsListPage(cur WorkloadNetworkSegmentsList, getNextPage func(context.Context, WorkloadNetworkSegmentsList) (WorkloadNetworkSegmentsList, error)) WorkloadNetworkSegmentsListPage {
	return WorkloadNetworkSegmentsListPage{
		fn:   getNextPage,
		wnsl: cur,
	}
}

// WorkloadNetworkSegmentSubnet subnet configuration for segment
type WorkloadNetworkSegmentSubnet struct {
	// DhcpRanges - DHCP Range assigned for subnet.
	DhcpRanges *[]string `json:"dhcpRanges,omitempty"`
	// GatewayAddress - Gateway address.
	GatewayAddress *string `json:"gatewayAddress,omitempty"`
}

// WorkloadNetworksUpdateDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDhcp, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateDhcpFuture.Result.
func (future *WorkloadNetworksUpdateDhcpFuture) result(client WorkloadNetworksClient) (wnd WorkloadNetworkDhcp, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateDhcpFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnd.Response.Response, err = future.GetResult(sender); err == nil && wnd.Response.Response.StatusCode != http.StatusNoContent {
		wnd, err = client.UpdateDhcpResponder(wnd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDhcpFuture", "Result", wnd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateDNSServiceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateDNSServiceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDNSService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateDNSServiceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateDNSServiceFuture.Result.
func (future *WorkloadNetworksUpdateDNSServiceFuture) result(client WorkloadNetworksClient) (wnds WorkloadNetworkDNSService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDNSServiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnds.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateDNSServiceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnds.Response.Response, err = future.GetResult(sender); err == nil && wnds.Response.Response.StatusCode != http.StatusNoContent {
		wnds, err = client.UpdateDNSServiceResponder(wnds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDNSServiceFuture", "Result", wnds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateDNSZoneFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateDNSZoneFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDNSZone, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateDNSZoneFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateDNSZoneFuture.Result.
func (future *WorkloadNetworksUpdateDNSZoneFuture) result(client WorkloadNetworksClient) (wndz WorkloadNetworkDNSZone, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDNSZoneFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wndz.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateDNSZoneFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wndz.Response.Response, err = future.GetResult(sender); err == nil && wndz.Response.Response.StatusCode != http.StatusNoContent {
		wndz, err = client.UpdateDNSZoneResponder(wndz.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDNSZoneFuture", "Result", wndz.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdatePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdatePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkPortMirroring, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdatePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdatePortMirroringFuture.Result.
func (future *WorkloadNetworksUpdatePortMirroringFuture) result(client WorkloadNetworksClient) (wnpm WorkloadNetworkPortMirroring, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdatePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnpm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdatePortMirroringFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnpm.Response.Response, err = future.GetResult(sender); err == nil && wnpm.Response.Response.StatusCode != http.StatusNoContent {
		wnpm, err = client.UpdatePortMirroringResponder(wnpm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdatePortMirroringFuture", "Result", wnpm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateSegmentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateSegmentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkSegment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateSegmentsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateSegmentsFuture.Result.
func (future *WorkloadNetworksUpdateSegmentsFuture) result(client WorkloadNetworksClient) (wns WorkloadNetworkSegment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateSegmentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wns.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateSegmentsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wns.Response.Response, err = future.GetResult(sender); err == nil && wns.Response.Response.StatusCode != http.StatusNoContent {
		wns, err = client.UpdateSegmentsResponder(wns.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateSegmentsFuture", "Result", wns.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkVMGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateVMGroupFuture.Result.
func (future *WorkloadNetworksUpdateVMGroupFuture) result(client WorkloadNetworksClient) (wnvg WorkloadNetworkVMGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnvg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateVMGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnvg.Response.Response, err = future.GetResult(sender); err == nil && wnvg.Response.Response.StatusCode != http.StatusNoContent {
		wnvg, err = client.UpdateVMGroupResponder(wnvg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateVMGroupFuture", "Result", wnvg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworkVirtualMachine NSX Virtual Machine
type WorkloadNetworkVirtualMachine struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkVirtualMachineProperties - Virtual machine properties.
	*WorkloadNetworkVirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVirtualMachine.
func (wnvm WorkloadNetworkVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvm.WorkloadNetworkVirtualMachineProperties != nil {
		objectMap["properties"] = wnvm.WorkloadNetworkVirtualMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkVirtualMachine struct.
func (wnvm *WorkloadNetworkVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkVirtualMachineProperties WorkloadNetworkVirtualMachineProperties
				err = json.Unmarshal(*v, &workloadNetworkVirtualMachineProperties)
				if err != nil {
					return err
				}
				wnvm.WorkloadNetworkVirtualMachineProperties = &workloadNetworkVirtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnvm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnvm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnvm.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkVirtualMachineProperties NSX Virtual Machine Properties
type WorkloadNetworkVirtualMachineProperties struct {
	// DisplayName - Display name of the VM.
	DisplayName *string `json:"displayName,omitempty"`
	// VMType - READ-ONLY; Virtual machine type. Possible values include: 'VMTypeEnumREGULAR', 'VMTypeEnumEDGE', 'VMTypeEnumSERVICE'
	VMType VMTypeEnum `json:"vmType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVirtualMachineProperties.
func (wnvmp WorkloadNetworkVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvmp.DisplayName != nil {
		objectMap["displayName"] = wnvmp.DisplayName
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkVirtualMachinesList a list of NSX Virtual Machines
type WorkloadNetworkVirtualMachinesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkVirtualMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVirtualMachinesList.
func (wnvml WorkloadNetworkVirtualMachinesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkVirtualMachinesListIterator provides access to a complete listing of
// WorkloadNetworkVirtualMachine values.
type WorkloadNetworkVirtualMachinesListIterator struct {
	i    int
	page WorkloadNetworkVirtualMachinesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkVirtualMachinesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVirtualMachinesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkVirtualMachinesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkVirtualMachinesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkVirtualMachinesListIterator) Response() WorkloadNetworkVirtualMachinesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkVirtualMachinesListIterator) Value() WorkloadNetworkVirtualMachine {
	if !iter.page.NotDone() {
		return WorkloadNetworkVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkVirtualMachinesListIterator type.
func NewWorkloadNetworkVirtualMachinesListIterator(page WorkloadNetworkVirtualMachinesListPage) WorkloadNetworkVirtualMachinesListIterator {
	return WorkloadNetworkVirtualMachinesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnvml WorkloadNetworkVirtualMachinesList) IsEmpty() bool {
	return wnvml.Value == nil || len(*wnvml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnvml WorkloadNetworkVirtualMachinesList) hasNextLink() bool {
	return wnvml.NextLink != nil && len(*wnvml.NextLink) != 0
}

// workloadNetworkVirtualMachinesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnvml WorkloadNetworkVirtualMachinesList) workloadNetworkVirtualMachinesListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnvml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnvml.NextLink)))
}

// WorkloadNetworkVirtualMachinesListPage contains a page of WorkloadNetworkVirtualMachine values.
type WorkloadNetworkVirtualMachinesListPage struct {
	fn    func(context.Context, WorkloadNetworkVirtualMachinesList) (WorkloadNetworkVirtualMachinesList, error)
	wnvml WorkloadNetworkVirtualMachinesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkVirtualMachinesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVirtualMachinesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnvml)
		if err != nil {
			return err
		}
		page.wnvml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkVirtualMachinesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkVirtualMachinesListPage) NotDone() bool {
	return !page.wnvml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkVirtualMachinesListPage) Response() WorkloadNetworkVirtualMachinesList {
	return page.wnvml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkVirtualMachinesListPage) Values() []WorkloadNetworkVirtualMachine {
	if page.wnvml.IsEmpty() {
		return nil
	}
	return *page.wnvml.Value
}

// Creates a new instance of the WorkloadNetworkVirtualMachinesListPage type.
func NewWorkloadNetworkVirtualMachinesListPage(cur WorkloadNetworkVirtualMachinesList, getNextPage func(context.Context, WorkloadNetworkVirtualMachinesList) (WorkloadNetworkVirtualMachinesList, error)) WorkloadNetworkVirtualMachinesListPage {
	return WorkloadNetworkVirtualMachinesListPage{
		fn:    getNextPage,
		wnvml: cur,
	}
}

// WorkloadNetworkVMGroup NSX VM Group
type WorkloadNetworkVMGroup struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkVMGroupProperties - VM Group properties.
	*WorkloadNetworkVMGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVMGroup.
func (wnvg WorkloadNetworkVMGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvg.WorkloadNetworkVMGroupProperties != nil {
		objectMap["properties"] = wnvg.WorkloadNetworkVMGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkVMGroup struct.
func (wnvg *WorkloadNetworkVMGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkVMGroupProperties WorkloadNetworkVMGroupProperties
				err = json.Unmarshal(*v, &workloadNetworkVMGroupProperties)
				if err != nil {
					return err
				}
				wnvg.WorkloadNetworkVMGroupProperties = &workloadNetworkVMGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnvg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnvg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnvg.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkVMGroupProperties NSX VM Group Properties
type WorkloadNetworkVMGroupProperties struct {
	// DisplayName - Display name of the VM group.
	DisplayName *string `json:"displayName,omitempty"`
	// Members - Virtual machine members of this group.
	Members *[]string `json:"members,omitempty"`
	// Status - READ-ONLY; VM Group status. Possible values include: 'VMGroupStatusEnumSUCCESS', 'VMGroupStatusEnumFAILURE'
	Status VMGroupStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkVMGroupProvisioningStateSucceeded', 'WorkloadNetworkVMGroupProvisioningStateFailed', 'WorkloadNetworkVMGroupProvisioningStateBuilding', 'WorkloadNetworkVMGroupProvisioningStateDeleting', 'WorkloadNetworkVMGroupProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkVMGroupProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVMGroupProperties.
func (wnvgp WorkloadNetworkVMGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvgp.DisplayName != nil {
		objectMap["displayName"] = wnvgp.DisplayName
	}
	if wnvgp.Members != nil {
		objectMap["members"] = wnvgp.Members
	}
	if wnvgp.Revision != nil {
		objectMap["revision"] = wnvgp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkVMGroupsList a list of NSX VM Groups
type WorkloadNetworkVMGroupsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkVMGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVMGroupsList.
func (wnvgl WorkloadNetworkVMGroupsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkloadNetworkVMGroupsListIterator provides access to a complete listing of WorkloadNetworkVMGroup
// values.
type WorkloadNetworkVMGroupsListIterator struct {
	i    int
	page WorkloadNetworkVMGroupsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkVMGroupsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVMGroupsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkVMGroupsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkVMGroupsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkVMGroupsListIterator) Response() WorkloadNetworkVMGroupsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkVMGroupsListIterator) Value() WorkloadNetworkVMGroup {
	if !iter.page.NotDone() {
		return WorkloadNetworkVMGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkVMGroupsListIterator type.
func NewWorkloadNetworkVMGroupsListIterator(page WorkloadNetworkVMGroupsListPage) WorkloadNetworkVMGroupsListIterator {
	return WorkloadNetworkVMGroupsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnvgl WorkloadNetworkVMGroupsList) IsEmpty() bool {
	return wnvgl.Value == nil || len(*wnvgl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnvgl WorkloadNetworkVMGroupsList) hasNextLink() bool {
	return wnvgl.NextLink != nil && len(*wnvgl.NextLink) != 0
}

// workloadNetworkVMGroupsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnvgl WorkloadNetworkVMGroupsList) workloadNetworkVMGroupsListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnvgl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnvgl.NextLink)))
}

// WorkloadNetworkVMGroupsListPage contains a page of WorkloadNetworkVMGroup values.
type WorkloadNetworkVMGroupsListPage struct {
	fn    func(context.Context, WorkloadNetworkVMGroupsList) (WorkloadNetworkVMGroupsList, error)
	wnvgl WorkloadNetworkVMGroupsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkVMGroupsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVMGroupsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnvgl)
		if err != nil {
			return err
		}
		page.wnvgl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkVMGroupsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkVMGroupsListPage) NotDone() bool {
	return !page.wnvgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkVMGroupsListPage) Response() WorkloadNetworkVMGroupsList {
	return page.wnvgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkVMGroupsListPage) Values() []WorkloadNetworkVMGroup {
	if page.wnvgl.IsEmpty() {
		return nil
	}
	return *page.wnvgl.Value
}

// Creates a new instance of the WorkloadNetworkVMGroupsListPage type.
func NewWorkloadNetworkVMGroupsListPage(cur WorkloadNetworkVMGroupsList, getNextPage func(context.Context, WorkloadNetworkVMGroupsList) (WorkloadNetworkVMGroupsList, error)) WorkloadNetworkVMGroupsListPage {
	return WorkloadNetworkVMGroupsListPage{
		fn:    getNextPage,
		wnvgl: cur,
	}
}
