/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "k8s.io/api/apps/v1beta1"
	appsv1beta1 "k8s.io/client-go/applyconfigurations/apps/v1beta1"
	gentype "k8s.io/client-go/gentype"
	typedappsv1beta1 "k8s.io/client-go/kubernetes/typed/apps/v1beta1"
)

// fakeStatefulSets implements StatefulSetInterface
type fakeStatefulSets struct {
	*gentype.FakeClientWithListAndApply[*v1beta1.StatefulSet, *v1beta1.StatefulSetList, *appsv1beta1.StatefulSetApplyConfiguration]
	Fake *FakeAppsV1beta1
}

func newFakeStatefulSets(fake *FakeAppsV1beta1, namespace string) typedappsv1beta1.StatefulSetInterface {
	return &fakeStatefulSets{
		gentype.NewFakeClientWithListAndApply[*v1beta1.StatefulSet, *v1beta1.StatefulSetList, *appsv1beta1.StatefulSetApplyConfiguration](
			fake.Fake,
			namespace,
			v1beta1.SchemeGroupVersion.WithResource("statefulsets"),
			v1beta1.SchemeGroupVersion.WithKind("StatefulSet"),
			func() *v1beta1.StatefulSet { return &v1beta1.StatefulSet{} },
			func() *v1beta1.StatefulSetList { return &v1beta1.StatefulSetList{} },
			func(dst, src *v1beta1.StatefulSetList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta1.StatefulSetList) []*v1beta1.StatefulSet { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta1.StatefulSetList, items []*v1beta1.StatefulSet) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
