/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ISHELLFACTORY_H
#define ISHELLFACTORY_H


#include "istring.h"

class iControlModule;
class iControlScript;
class iEventObserver;
class iRenderTool;
class iScript;
class iShell;
class iString;
class iViewModule;

class vtkRenderWindow;
class vtkRenderWindowInteractor;


class iShellFactory
{
	
	friend class iAbortRenderEventObserver;
	friend class iAnimatorEventObserver;
	friend class iAnimatorScript;
	friend class iControlScript;
	friend class iFileLoader;
	friend class iMarkerEventObserver;
	friend class iParallelUpdateEventObserver;
	friend class iPickEventObserver;
	friend class iProgressEventObserver;
	friend class iRenderTool;
	friend class iShell;

	friend class hDataReader;

public:

	static void GetSupportedShells(iString &list, iString &help);

protected:
		
	static iShell* CreateShell(const iString &type, int argc, char **argv);

	static iEventObserver* CreateEventObserver(const iString &type, iControlModule *cm);
	static iEventObserver* CreateEventObserver(const iString &type, iViewModule *vm);
	static iControlScript* CreateControlScript(iControlModule *cm, iScript *parent);

	static vtkRenderWindow* CreateRenderWindow(iRenderTool *rv);
	static vtkRenderWindowInteractor* CreateRenderWindowInteractor(iRenderTool *rv);

private:

	static const iString qt, cl, fx;
};

#endif // ISHELLFACTORY_H
