/***************************************************************************
    File                 : NSLIntTest.h
    Project              : LabPlot
    Description          : NSL Tests for numerical integration
    --------------------------------------------------------------------
    Copyright            : (C) 2019 Stefan Gerlach (stefan.gerlach@uni.kn)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/
#ifndef NSLINTTEST_H
#define NSLINTTEST_H

#include "../NSLTest.h"

class NSLIntTest : public NSLTest {
	Q_OBJECT

private slots:
	// rules integral/area
	void testRectangle_integral();
	void testRectangle_area();
	void testTrapezoid_integral();
	void testTrapezoid_area();
	void test3Point_integral();
	void test4Point_integral();
	// performance
	void testPerformanceRectangle();
	void testPerformanceTrapezoid();
	void testPerformance3Point();
	void testPerformance4Point();
private:
	QString m_dataDir;
};
#endif
