BEGIN {
    print "/*";
    print " *  Copyright 1994-2022 Olivier Girondel";
    print " *";
    print " *  This file is part of lebiniou.";
    print " *";
    print " *  lebiniou is free software: you can redistribute it and/or modify";
    print " *  it under the terms of the GNU General Public License as published by";
    print " *  the Free Software Foundation, either version 2 of the License, or";
    print " *  (at your option) any later version.";
    print " *";
    print " *  lebiniou is distributed in the hope that it will be useful,";
    print " *  but WITHOUT ANY WARRANTY; without even the implied warranty of";
    print " *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
    print " *  GNU General Public License for more details.";
    print " *";
    print " *  You should have received a copy of the GNU General Public License";
    print " *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.";
    print " */";
    print;
    print "#include \"commands_key.h\"";
    print;
    print "/*";
    print " * Automagically generated from commands.c.in";
    print " * DO NOT EDIT !!!";
    print " */";
    print;
    print "void";
    print "on_key(Context_t *ctx, const BKey_t *k)";
    print "{";
}


function pmod(mod) {
    if (mod == "-")
	return;
    if (mod == "A")
	return "Alt-";
    if (mod == "C")
	return "Ctrl-";
    if (mod == "CA")
	return "Ctrl-Alt-";
    if (mod == "S")
	return "Shift-";
    if (mod == "CS")
	return "Ctrl-Shift-";
    if (mod == "AS")
	return "Alt-Shift-";
    if (mod == "CAS")
	return "Ctrl-Alt-Shift-";
}


function cmod(mod) {
    if (mod == "-")
	return "BKEY";
    if (mod == "A")
	return "BALT";
    if (mod == "C")
	return "BCTRL";
    if (mod == "CA")
	return "BCTRLALT";
    if (mod == "S")
	return "BSHIFT";
    if (mod == "CS")
	return "BCTRLSHIFT";
    if (mod == "AS")
	return "BALTSHIFT";
    if (mod == "CAS")
	return "BCTRLALTSHIFT";
}


{
    if (($1 == "#") || ($0 == "") || ($1 == "-") || ($1 == "**"))
	next;
  
    if ($1 == "*") {
	print "";
	print "  /* =============== "$2" =============== */";
    } else {
        if ($3 != "-") {
            print "";
            tail = substr($0, (length($1 $2 $3 $4) + 5));

            if (tail != "")
                printf "  /* [%s%s] - %s */\n", pmod($2), $3, tail;
            else
                printf "  /* [%s%s] */\n", pmod($2), $3;

            printf "  if (%s(k, SDLK_%s)) {\n", cmod($2), $3;
            printf "    Command_t *cmd = Command_new(CT_SDL2, %s, NULL, NULL);\n", $4;
            printf "    Context_push_command(ctx, cmd);\n";
            printf "    return;\n"
            printf "  }\n"
        }
    }
}


END {
    print "}";
}
