#ifndef _KEYBOARD_H
#define _KEYBOARD_H

#include <string>
#include <vector>

#include "keymap.h"
#include "applet.h"

struct KeyboardForegroundColors {
    std::vector<XColor> transparent;
    int cur_transparent;
    std::vector<XColor> opaque;
    int cur_opaque;

    KeyboardForegroundColors():cur_transparent(0), cur_opaque(0){}
};

class Keyboard : public Applet {
  public:
    Keyboard(AppletWindowParams params, 
	     const std::string& layout_landscape,
	     const std::string& layout_portrait,
	     KeyboardForegroundColors colors);
    virtual ~Keyboard(){}
    virtual AppAction OnMousePress(int x, int y);
    virtual AppAction OnMouseMove(int x, int y);
    virtual AppAction OnMouseRelease(int x, int y);

    virtual void OnRotate(Rotation rot);
    void Load(const std::string& layout);

  private:
    void DrawKey(MyWindow* win, Keymap::Key k, bool highlite = false);
    void DrawSym(MyWindow* win, int x, int y, Keymap::Key k, bool highlite);
    void DrawKeys();

    std::string layout_landscape,
		layout_portrait;
    Keymap keymap;
    KeyboardForegroundColors colors;
    int lastkeyx, lastkeyy;
    int lastpressx, lastpressy;
};

#endif 
