; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd,-avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512CD
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd,+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512CDBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,-avx512cd,+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,-avx512cd,-avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512DQ

define <8 x i64> @testv8i64(<8 x i64> %in) nounwind {
; AVX512CD-LABEL: testv8i64:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv8i64:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $1, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $2, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $16, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $32, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512BW-NEXT:    vpshufb %zmm2, %zmm3, %zmm2
; AVX512BW-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv8i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsrlq $1, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $4, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $16, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $32, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm3
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %out = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %in, i1 0)
  ret <8 x i64> %out
}

define <8 x i64> @testv8i64u(<8 x i64> %in) nounwind {
; AVX512CD-LABEL: testv8i64u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv8i64u:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv8i64u:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $1, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $2, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $16, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlq $32, %zmm0, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512BW-NEXT:    vpshufb %zmm2, %zmm3, %zmm2
; AVX512BW-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv8i64u:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsrlq $1, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $4, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $16, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrlq $32, %zmm0, %zmm1
; AVX512DQ-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm3
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %out = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %in, i1 -1)
  ret <8 x i64> %out
}

define <16 x i32> @testv16i32(<16 x i32> %in) nounwind {
; AVX512CD-LABEL: testv16i32:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv16i32:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $1, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512BW-NEXT:    vpshufb %zmm2, %zmm3, %zmm2
; AVX512BW-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm2, %zmm2
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv16i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsrld $1, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $4, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm3
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[6],ymm3[6],ymm1[7],ymm3[7]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[4],ymm3[4],ymm1[5],ymm3[5]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackuswb %ymm5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm3[2],ymm0[3],ymm3[3],ymm0[6],ymm3[6],ymm0[7],ymm3[7]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[1],ymm3[1],ymm0[4],ymm3[4],ymm0[5],ymm3[5]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %out = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %in, i1 0)
  ret <16 x i32> %out
}

define <16 x i32> @testv16i32u(<16 x i32> %in) nounwind {
; AVX512CD-LABEL: testv16i32u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv16i32u:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv16i32u:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $1, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $8, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512BW-NEXT:    vpshufb %zmm2, %zmm3, %zmm2
; AVX512BW-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpunpckhdq {{.*#+}} zmm2 = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm2, %zmm2
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; AVX512BW-NEXT:    vpsadbw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv16i32u:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsrld $1, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $4, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpternlogq $15, %zmm0, %zmm0, %zmm0
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm3
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[6],ymm3[6],ymm1[7],ymm3[7]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[4],ymm3[4],ymm1[5],ymm3[5]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackuswb %ymm5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpshufb %ymm5, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm3[2],ymm0[3],ymm3[3],ymm0[6],ymm3[6],ymm0[7],ymm3[7]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[1],ymm3[1],ymm0[4],ymm3[4],ymm0[5],ymm3[5]
; AVX512DQ-NEXT:    vpsadbw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %out = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %in, i1 -1)
  ret <16 x i32> %out
}

define <32 x i16> @testv32i16(<32 x i16> %in) nounwind {
; AVX512CD-LABEL: testv32i16:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512CD-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512CD-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CD-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512CD-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv32i16:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512CDBW-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512CDBW-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CDBW-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512CDBW-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512CDBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512CDBW-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CDBW-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512CDBW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vptestnmb %zmm4, %zmm3, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm5
; AVX512BW-NEXT:    vpandq %zmm5, %zmm2, %zmm2
; AVX512BW-NEXT:    vpandq %zmm4, %zmm3, %zmm3
; AVX512BW-NEXT:    vpshufb %zmm3, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm4, %ymm7
; AVX512DQ-NEXT:    vpand %ymm7, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm2, %ymm4
; AVX512DQ-NEXT:    vpaddb %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpaddw %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpand %ymm5, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddw %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    retq
  %out = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %in, i1 0)
  ret <32 x i16> %out
}

define <32 x i16> @testv32i16u(<32 x i16> %in) nounwind {
; AVX512CD-LABEL: testv32i16u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CD-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512CD-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512CD-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CD-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512CD-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv32i16u:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512CDBW-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512CDBW-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CDBW-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512CDBW-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512CDBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512CDBW-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CDBW-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512CDBW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv32i16u:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vptestnmb %zmm4, %zmm3, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm5
; AVX512BW-NEXT:    vpandq %zmm5, %zmm2, %zmm2
; AVX512BW-NEXT:    vpandq %zmm4, %zmm3, %zmm3
; AVX512BW-NEXT:    vpshufb %zmm3, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv32i16u:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm4, %ymm7
; AVX512DQ-NEXT:    vpand %ymm7, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm2, %ymm4
; AVX512DQ-NEXT:    vpaddb %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpand %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpaddw %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpand %ymm5, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpcmpeqb %ymm6, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpaddw %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    retq
  %out = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %in, i1 -1)
  ret <32 x i16> %out
}

define <64 x i8> @testv64i8(<64 x i8> %in) nounwind {
; AVX512CD-LABEL: testv64i8:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CD-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} xmm3 = [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24]
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm0, %xmm0
; AVX512CD-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CD-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CD-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm1, %xmm1
; AVX512CD-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv64i8:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512CDBW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CDBW-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CDBW-NEXT:    vmovdqa {{.*#+}} xmm3 = [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24]
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CDBW-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm1, %xmm1
; AVX512CDBW-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512CDBW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CDBW-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm0, %xmm0
; AVX512CDBW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512CDBW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vptestnmb %zmm3, %zmm0, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm4
; AVX512BW-NEXT:    vpandq %zmm4, %zmm2, %zmm2
; AVX512BW-NEXT:    vpandq %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512DQ-NEXT:    vpcmpeqb %ymm5, %ymm0, %ymm6
; AVX512DQ-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpcmpeqb %ymm5, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm3, %ymm1
; AVX512DQ-NEXT:    retq
  %out = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %in, i1 0)
  ret <64 x i8> %out
}

define <64 x i8> @testv64i8u(<64 x i8> %in) nounwind {
; AVX512CD-LABEL: testv64i8u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CD-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CD-NEXT:    vmovdqa {{.*#+}} xmm3 = [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24]
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm0, %xmm0
; AVX512CD-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512CD-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CD-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CD-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512CD-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CD-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512CD-NEXT:    vpsubb %xmm3, %xmm1, %xmm1
; AVX512CD-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512CD-NEXT:    retq
;
; AVX512CDBW-LABEL: testv64i8u:
; AVX512CDBW:       # %bb.0:
; AVX512CDBW-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512CDBW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CDBW-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CDBW-NEXT:    vmovdqa {{.*#+}} xmm3 = [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24]
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512CDBW-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm1, %xmm1
; AVX512CDBW-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512CDBW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm2, %zmm2
; AVX512CDBW-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm2, %xmm2
; AVX512CDBW-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512CDBW-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CDBW-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512CDBW-NEXT:    vpsubb %xmm3, %xmm0, %xmm0
; AVX512CDBW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512CDBW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512CDBW-NEXT:    retq
;
; AVX512BW-LABEL: testv64i8u:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vptestnmb %zmm3, %zmm0, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm4
; AVX512BW-NEXT:    vpandq %zmm4, %zmm2, %zmm2
; AVX512BW-NEXT:    vpandq %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: testv64i8u:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512DQ-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX512DQ-NEXT:    vpcmpeqb %ymm5, %ymm0, %ymm6
; AVX512DQ-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vpaddb %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpcmpeqb %ymm5, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpaddb %ymm1, %ymm3, %ymm1
; AVX512DQ-NEXT:    retq
  %out = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %in, i1 -1)
  ret <64 x i8> %out
}

declare <8 x i64> @llvm.ctlz.v8i64(<8 x i64>, i1)
declare <16 x i32> @llvm.ctlz.v16i32(<16 x i32>, i1)
declare <32 x i16> @llvm.ctlz.v32i16(<32 x i16>, i1)
declare <64 x i8> @llvm.ctlz.v64i8(<64 x i8>, i1)
