/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.List;

/**
 * An XML element with namespace information.
 */
public class ElementNS
	extends Element
{
	private String namespaceURI;
	private String prefix;
	private String localName;

	/**
	 * Constructs an element from a {@link Namespace} and list of attributes,
	 * either as open or closed.
	 * Note:  For performance reasons, the passed in List object is not
	 * copied.
	 * @param namespace Namespace of element;
	 * fields from the this object are copied internally
	 * @param attributes List of attributes, or null if no attributes
	 * @param open If this tag is open or closed 
	 */
	public ElementNS(Namespace namespace, List<Attribute> attr, boolean open)
	{
		super(namespace.getName(), attr, open);
		this.namespaceURI = namespace.getNamespaceURI();
		this.prefix = namespace.getPrefix();
		this.localName = namespace.getLocalName();
	}

	/**
	 * Sets the namespace of this Element.
	 */
	public void setNamespace(Namespace namespace) {
		setName(namespace.getName());
		this.namespaceURI = namespace.getNamespaceURI();
		this.prefix = namespace.getPrefix();
		this.localName = namespace.getLocalName();
	}	

	/**
	 * Returns the namespace URI of this Element.
	 * By default, returns null.
	 */
	@Override
	public String getNamespaceURI() {
		return namespaceURI;
	}

	/**
	 * Returns the prefix of this Element.
	 */
	@Override
	public String getPrefix() {
		return prefix;
	}

	/**
	 * Returns the local name of this Element.
	 */
	@Override
	public String getLocalName() {
		return localName;
	}
}
