package org.jboss.cache.marshall;

import org.jboss.cache.Fqn;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.factories.CommandsFactory;
import static org.testng.AssertJUnit.assertEquals;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
@Test(groups = {"functional"})
public class MethodIdPreservationTest
{
   private Marshaller m;
   private ObjectOutputStream stream;
   private ByteArrayOutputStream byteStream;
   private ReversibleCommand command1;
   private List<ReversibleCommand> list = new ArrayList<ReversibleCommand>(2);
   private PrepareCommand prepareComand;

   @BeforeMethod(alwaysRun = true)
   public void setUp() throws Exception
   {

      byteStream = new ByteArrayOutputStream();
      stream = new ObjectOutputStream(byteStream);
      command1 = new PutDataMapCommand(null, Fqn.ROOT, null);

      list.clear();
      list.add(command1);
      list.add(new PutDataMapCommand(null, Fqn.ROOT, null));
      prepareComand = new PrepareCommand(null, list, null, true);

      CacheMarshaller210 cm210 = new CacheMarshaller210();
      CommandsFactory factory = new CommandsFactory();
      cm210.injectCommandsFactory(factory);

      m = cm210;
   }

   public void testSingleMethodCall() throws Exception
   {
      m.objectToObjectStream(command1, stream);
      stream.close();
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteStream.toByteArray()));
      Object result = m.objectFromObjectStream(in);
      assertEquals(command1.getClass(), result.getClass());
   }

   public void testListOfMethodCalls() throws Exception
   {
      m.objectToObjectStream(list, stream);
      stream.close();
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteStream.toByteArray()));
      Object result = m.objectFromObjectStream(in);
      assertEquals(list.getClass(), result.getClass());
      assertEquals(list.size(), ((List) result).size());
      assert ((List) result).get(0) instanceof PutDataMapCommand;
      assert ((List) result).get(1) instanceof PutDataMapCommand;
   }

   public void testMethodCallsInPrepare() throws Exception
   {
      m.objectToObjectStream(prepareComand, stream);
      stream.close();
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteStream.toByteArray()));
      Object result = m.objectFromObjectStream(in);

      assertEquals(prepareComand.getClass(), result.getClass());
      PrepareCommand prepareCallRes = (PrepareCommand) result;
      List listResult = prepareCallRes.getModifications();

      assertEquals(list.size(), listResult.size());

      assert listResult.get(0) instanceof PutDataMapCommand;
      assert listResult.get(1) instanceof PutDataMapCommand;
   }
}
