//start of BitInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * BitInputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.InputStream;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;

/**
 * rbg͂̂߂̃[eBeBNXB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: BitInputStream.java,v $
 * Revision 1.5  2002/12/07 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.4  2002/11/15 00:00:00  dangan
 * [improvement]
 *     prefetchBits()   32bit ̓ǂݍ݂ۏ؂悤ɏC
 * [change]
 *     \bh̕ύX
 *     prefetchBit     -> peekBit
 *     prefetchBoolean -> peekBoolean
 *     prefetchBits    -> peekBits
 *
 * Revision 1.3  2002/11/02 00:00:00  dangan
 * [bug fix]
 *     available() availableBits() 
 *     ubNɓǂݍ߂ʂ傫lԂĂB
 *
 * Revision 1.2  2002/09/05 00:00:00  dangan
 * [change]
 *     EndOfStream ɒB read( new byte[0] )  
 *     read( byte[] buf, int off, 0 ) ̖߂l
 *     InputStream Ɠ 0 ɂȂ悤ɂ
 *
 * Revision 1.1  2002/09/04 00:00:00  dangan
 * [bug fix]
 *     skip( len )  skipBits( len )  len  0 ̂Ƃ
 *     łĂȂB
 *
 * Revision 1.0  2002/09/03 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     mark()  ڑꂽ in ɓn readLimit ̌vZÂ߁A
 *     vꂽ readLimit ɒBOɃ}[Nʒuj鎖B
 *     EndOfStream ɒB skip()  skip( 0 )  -1 ԂĂB
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.5 $
 */
public class BitInputStream extends InputStream{

    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  default
    //------------------------------------------------------------------
    //  private static final int DefaultCacheSize
    //------------------------------------------------------------------
    /**
     * ftHg̃LbVTCY
     */
    private static final int DefaultCacheSize = 1024;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[
     */
    private InputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  cache
    //------------------------------------------------------------------
    //  private byte[] cache
    //  private int    cacheLimit
    //  private int    cachePosition
    //------------------------------------------------------------------
    /**
     * xቺ}~poCgz
     */
    private byte[] cache;

    /**
     * cache ̗LoCg
     */
    private int    cacheLimit;

    /**
     * cache ̌ݏʒu
     */
    private int    cachePosition;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  bit buffer
    //------------------------------------------------------------------
    //  private int    bitBuffer
    //  private int    bitCount
    //------------------------------------------------------------------
    /**
     * rbgobt@B
     * rbgf[^͍ŏʃrbg bitCount i[ĂB
     */
    private int    bitBuffer;

    /**
     * bitBuffer  Lrbg
     */
    private int    bitCount;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private boolean markPositionIsInCache
    //  private byte[] markCache
    //  private int    markCacheLimit
    //  private int    markCachePosition
    //  private int    markBitBuffer
    //  private int    markBitCount
    //------------------------------------------------------------------
    /**
     * markʒuLbV͈͓̔ɂ邩B
     * markꂽƂ true ɐݒ肳A
     *  in  LbVւ̓ǂݍ݂
     * sꂽƂ false ɐݒ肳B
     */
    private boolean markPositionIsInCache;

    /** cache  obNAbvp */
    private byte[] markCache;

    /** cacheLimit ̃obNAbvp */
    private int    markCacheLimit;

    /** cachePosition ̃obNAbvp */
    private int    markCachePosition;

    /** bitBuffer ̃obNAbvp */
    private int    markBitBuffer;

    /** bitCount ̃obNAbvp */
    private int    markBitCount;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private BitInputStream()
    //  public BitInputStream( InputStream in )
    //  public BitInputStream( InputStream in, int CacheSize )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private BitInputStream(){ }

    /**
     * ̓Xg[ in ̃f[^rbgPʂ
     * ǂݍ߂悤ȃXg[\zB<br>
     * 
     * @param in ̓Xg[
     */
    public BitInputStream( InputStream in ){
        this( in, BitInputStream.DefaultCacheSize );
    }

    /**
     * ̓Xg[ in ̃f[^rbgPʂ
     * ǂݍ߂悤ȃXg[\zB<br>
     * 
     * @param in        ̓Xg[
     * @param CacheSize obt@TCY
     */
    public BitInputStream( InputStream in, int CacheSize ){
        if( in != null && 4 <= CacheSize ){
            this.in                    = in;
            this.cache                 = new byte[ CacheSize ];
            this.cacheLimit            = 0;
            this.cachePosition         = 0;
            this.bitBuffer             = 0;
            this.bitCount              = 0;

            this.markPositionIsInCache = false;
            this.markCache             = null;
            this.markCacheLimit        = 0;
            this.markCachePosition     = 0;
            this.markBitBuffer         = 0;
            this.markBitCount          = 0;
        }else if( in == null ){
            throw new NullPointerException( "in" );
        }else{
            throw new IllegalArgumentException( "CacheSize must be 4 or more." );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * ڑꂽXg[ 8rbg̃f[^ǂݍށB<br>
     * 
     * @return ǂݏoꂽ 8rbg̃f[^B<br>
     *          EndOfStream ɒBĂꍇ -1
     * 
     * @exception IOException
     *               ڑꂽ̓Xg[
     *               o̓G[ꍇ
     * @exception BitDataBrokenException 
     *               EndOfStreamɒB
     *               vꂽrbg̃f[^
     *               ǂݍ݂ɎsꍇB<br>
     */
    public int read() throws IOException {
        try{
            return this.readBits( 8 );                                          //throws LocalEOFException BitDataBrokenException IOException
        }catch( LocalEOFException exception ){
            if( exception.thrownBy( this ) ) return -1;
            else                             throw exception;
        }
    }

    /**
     * ڑꂽ̓Xg[ oCgz buffer 
     * 悤Ƀf[^ǂݍށB<br>
     * f[^͕K buffer 𖞂Ƃ͌ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ܂ꂽf[^i[邽߂̃oCgz
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStream ɒBĂꍇ -1 ԂB<br>
     * 
     * @exception IOException
     *               ڑꂽ̓Xg[
     *               o̓G[ꍇ
     * @exception BitDataBrokenException 
     *               EndOfStreamɒB
     *               vꂽrbg̃f[^
     *               ǂݍ݂ɎsꍇB<br>
     */
    public int read( byte[] buffer ) throws IOException {
        return this.read( buffer, 0, buffer.length );                           //throws BitDataBrokenException IOException
    }

    /**
     * ڑꂽ̓Xg[ oCgz buffer 
     * index Ŏw肳ꂽʒu length oCg̃f[^
     * ǂݍށB<br>
     * ̃\bh lengthoCgǂݍނA
     * EndOfStream ɓB܂ŃubNB<br>
     * f[^͕K length oCgǂݍ܂Ƃ͌
     * ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ܂ꂽf[^i[邽߂̃oCgz
     * @param index  buffer̃f[^ǂݍ݊Jnʒu
     * @param length bufferɓǂݍރf[^
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStream ɒBĂꍇ -1 ԂB<br>
     * 
     * @exception IOException
     *               ڑꂽ̓Xg[
     *               o̓G[ꍇ
     * @exception BitDataBrokenException 
     *               EndOfStreamɒB
     *               vꂽrbg̃f[^
     *               ǂݍ݂ɎsꍇB<br>
     */
    public int read( byte[] buffer, int index, int length ) throws IOException {
        final int requested = length;
        try{
            while( 0 < length ){
                buffer[index++] = (byte)this.readBits( 8 );                     //throws LocalEOFException BitDataBrokenException IOException
                length--;
            }
            return requested;
        }catch( LocalEOFException exception ){
            if( exception.thrownBy( this ) ){
                if( requested != length ) return requested - length;
                else                      return -1;
            }else{
                throw exception;
            }
        }catch( BitDataBrokenException exception ){
            if( exception.getCause() instanceof LocalEOFException 
             && ((LocalEOFException)exception.getCause()).thrownBy( this ) ){
                this.bitBuffer >>>= exception.getBitCount();
                this.bitCount  +=   exception.getBitCount();
                this.bitBuffer |= exception.getBitData() <<
                                    ( 32 - exception.getBitCount() );

                return requested - length;
            }else{
                throw exception;
            }
        }
    }

    /**
     * ڑꂽ̓Xg[̃f[^ length oCg
     * ǂݔ΂B<br>
     * ̃\bh lengthoCgǂݔ΂A
     * EndOfStream ɓB܂ŃubNB<br>
     * f[^͕K length oCgǂݔ΂Ƃ͌
     * ȂƂɒӁB<br>
     * 
     * @param length ǂݔ΂oCgB<br>
     * 
     * @return ۂɓǂݔ΂ꂽoCgB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {
        length = ( 0 < length ? length : 0 );
        final long requested = length;
        try{
            while( 0 < length ){
                this.readBits( 8 );
                length--;
            }
            return requested;
        }catch( LocalEOFException exception ){
            return requested - length;
        }catch( BitDataBrokenException exception ){
            if( exception.getCause() instanceof LocalEOFException 
             && ((LocalEOFException)exception.getCause()).thrownBy( this ) ){
                this.bitBuffer >>>= exception.getBitCount();
                this.bitCount  +=   exception.getBitCount();
                this.bitBuffer |=   exception.getBitData() <<
                                      ( 32 - exception.getBitCount() );
                return requested - length;
            }else{
                throw exception;
            }
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     */
    public void mark( int readLimit ){
        readLimit -= this.cacheLimit - this.cachePosition;
        readLimit -= this.bitCount / 8;
        readLimit += 4;
        readLimit  = ( ( readLimit / this.cache.length ) * this.cache.length
                     + ( readLimit % this.cache.length == 0 ? 0 : this.cache.length ) );

        this.in.mark( readLimit );

        if( this.markCache == null ){
            this.markCache = (byte[])this.cache.clone();
        }else{
            System.arraycopy( this.cache, 0, 
                              this.markCache, 0, 
                              this.cacheLimit );
        }
        this.markCacheLimit        = this.cacheLimit;
        this.markCachePosition     = this.cachePosition;
        this.markBitBuffer         = this.bitBuffer;
        this.markBitCount          = this.bitCount;
        this.markPositionIsInCache = true;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     *              (1) BitInputStream  mark ȂĂȂꍇB<br>
     *              (2) ڑꂽ̓Xg[ markSupported()
     *                  false ԂꍇB<br>
     *              (3) ڑꂽ̓Xg[
     *                  o̓G[ꍇB<br>
     *              ̉ꂩB
     */
    public void reset() throws IOException {
        if( this.markPositionIsInCache ){
            this.cachePosition = this.markCachePosition;
            this.bitBuffer     = this.markBitBuffer;
            this.bitCount      = this.markBitCount;
        }else if( !this.in.markSupported() ){
            throw new IOException( "not support mark()/reset()." );
        }else if( this.markCache == null ){ //͖̏Ƀ}[NĂȂƂBRXgN^ markCache  null ɐݒ肳̂𗘗pB 
            throw new IOException( "not marked." );
        }else{
            //in  reset() łȂꍇ
            //ŏ̍s this.in.reset() 
            //IOException 𓊂邱Ƃ҂ĂB
            this.in.reset();                                                    //throws IOException
            System.arraycopy( this.markCache, 0, 
                              this.cache, 0, 
                              this.markCacheLimit );
            this.cacheLimit    = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer     = this.markBitBuffer;
            this.bitCount      = this.markBitCount;
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łoCg𓾂B<br>
     * 
     * @return ubNȂœǂݏooCgB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int available() throws IOException {
        return this.availableBits() / 8;                                        //throws IOException
    }

    /**
     * ̓̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException
        this.in                    = null;

        this.cache                 = null;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;
        this.bitBuffer             = 0;
        this.bitCount              = 0;

        this.markCache             = null;
        this.markCacheLimit        = 0;
        this.markCachePosition     = 0;
        this.markBitBuffer         = 0;
        this.markBitCount          = 0;
        this.markPositionIsInCache = false;
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readBit()
    //  public boolean readBoolean()
    //  public int readBits( int count )
    //  public int skipBits( int count )
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ 1rbg̃f[^
     * ǂݍށB<br>
     * 
     * @return ǂݍ܂ꂽ1rbg̃f[^B<br>
     *         EndOfStreamɒBĂꍇ -1B<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int readBit() throws IOException {
        if( 0 < this.bitCount ){
            int bit = this.bitBuffer >>> 31;
            this.bitBuffer <<= 1;
            this.bitCount   -= 1;
            return bit;
        }else{
            try{
                this.fillBitBuffer();
                int bit = this.bitBuffer >>> 31;
                this.bitBuffer <<= 1;
                this.bitCount   -= 1;
                return bit;
            }catch( LocalEOFException exception ){
                if( exception.thrownBy( this ) ){
                    return -1;
                }else{
                    throw exception;
                }
            }
        }
    }

    /**
     * ڑꂽ̓Xg[ 1rbg̃f[^
     * ^UlƂēǂݍށB<br>
     * 
     * @return ǂݍ܂ꂽ1rbg̃f[^ 
     *         1ł trueA0ł false ԂB<br>
     * 
     * @exception EOFException EndOfStreamɒBĂꍇ
     * @exception IOException  ڑꂽ̓Xg[
     *                         o̓G[ꍇ
     */
    public boolean readBoolean() throws IOException {
        if( 0 < this.bitCount ){
            boolean bool = ( this.bitBuffer < 0 );
            this.bitBuffer <<= 1;
            this.bitCount   -= 1;
            return bool;
        }else{
            this.fillBitBuffer();
            boolean bool = ( this.bitBuffer < 0 );
            this.bitBuffer <<= 1;
            this.bitCount   -= 1;
            return bool;
        }
    }

    /**
     * ڑꂽ̓Xg[ count rbg̃f[^
     * ǂݍށB ߂l intlł鎖悤
     * ǂݍނƂ̂ł őLrbg 32rbg
     * 邪Acount 32ȏ̒lݒ肵Ă`FbN
     * 󂯂Ȃ ȏ̒lݒ肵ꍇ rbg
     * f[^ǂݎ̂ĂB<br>
     * Ƃ readBits( 33 ) ƂƂ ܂1rbg
     * f[^ǂݎ̂āǍ 32rbg̃f[^ԂB<br>
     * ܂ count  0ȉ̐ݒ肵ČĂяoꍇA
     * f[^ǂݍޓ𔺂Ȃ ߂l 0A
     * EndOfStream ɒBĂĂ EOFException 
     * Ȃ_ɒӂ邱ƁB<br>
     * 
     * @param count  ǂݍރf[^̃rbg
     * 
     * @return ǂݍ܂ꂽrbgf[^B<br>
     * 
     * @exception IOException 
     *               ڑꂽ̓Xg[
     *               o̓G[ꍇ
     * @exception EOFException 
     *               EndOfStreamɒBĂꍇ
     * @exception BitDataBrokenException 
     *               ǂݍݓr EndOfStreamɒB
     *               vꂽrbg̃f[^̓ǂݍ
     *               ɎsꍇB<br>
     */
    public int readBits( int count ) throws IOException {
        if( 0 < count ){
            if( count <= this.bitCount ){
                int bits = this.bitBuffer >>> ( 32 - count );
                this.bitBuffer <<= count;
                this.bitCount   -= count;
                return bits;
            }else{
                final int requested = count;
                int bits = 0;
                try{
                    this.fillBitBuffer();                                       //throws LocalEOFException IOException
                    while( this.bitCount < count ){
                        count -= this.bitCount;
                        if( count < 32 ){
                            bits |= ( this.bitBuffer >>> ( 32 - this.bitCount ) ) << count;
                        }
                        this.bitBuffer = 0;
                        this.bitCount  = 0;
                        this.fillBitBuffer();                                   //throws LocalEOFException IOException
                    }
                    bits |= this.bitBuffer >>> ( 32 - count );
                    this.bitBuffer <<= count;
                    this.bitCount   -= count;
                    return bits;
                }catch( LocalEOFException exception ){
                    if( exception.thrownBy( this ) && count < requested ){
                        throw new BitDataBrokenException( exception, bits >>> count, requested - count );
                    }else{
                        throw exception;
                    }
                }
            }
        }else{
            return 0;
        }
    }

    /**
     * ڑꂽXg[ count rbg̃f[^
     * ǂݔ΂B<br>
     * 
     * @param count ǂݔ΂Ăقrbg
     * 
     * @return ۂɓǂݔтrbg
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int skipBits( int count ) throws IOException {
        count = Math.max( count, 0 );

        if( count < this.bitCount ){
            this.bitBuffer <<= count;
            this.bitCount  -=  count;
            return count;
        }else{
            final int requested = count;
            count -= this.bitCount;
            this.bitCount  = 0;
            this.bitBuffer = 0;
            try{
                while( ( this.cacheLimit - this.cachePosition ) * 8 <= count ){
                    count -= ( this.cacheLimit - this.cachePosition ) * 8;
                    this.cachePosition = this.cacheLimit;
                    this.fillCache();
                    if( this.cacheLimit == this.cachePosition ){
                        throw new LocalEOFException( this );
                    }
                }
                this.cachePosition += ( count >> 3 );
                count = count & 0x07;
                if( 0 < count ){
                    this.bitCount  = 8 - count;
                    this.bitBuffer = this.cache[ this.cachePosition++ ] << ( 24 + count );
                    count = 0;
                }
            }catch( LocalEOFException exception ){
            }
            return requested - count;
        }
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  prefetch
    //------------------------------------------------------------------
    //  public int peekBit()
    //  public boolean peekBoolean()
    //  public int peekBits( int count )
    //------------------------------------------------------------------
    /**
     * ǂݍ݈ʒuς 1rbg̃f[^ǂ݂B<br>
     * 
     * @return ǂݍ܂ꂽ1rbg̃f[^B<br>
     *         EndOfStreamɒBĂꍇ -1B<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int peekBit() throws IOException {
        if( 0 < this.bitCount ){
            return this.bitBuffer >>> 31;
        }else{
            try{
                this.fillBitBuffer();                                           //throws LocalEOFException IOException
                return this.bitBuffer >>> 31;
            }catch( LocalEOFException exception ){
                if( exception.thrownBy( this ) ){
                    return -1;
                }else{
                    throw exception;
                }
            }

        }
    }

    /**
     * ǂݍ݈ʒuς 1rbg̃f[^
     * ^UlƂĐǂ݂B<br>
     * 
     * @return ǂݍ܂ꂽ1rbg̃f[^ 
     *         1ł trueA0ł false ԂB<br>
     * 
     * @exception EOFException EndOfStreamɒBĂꍇ
     * @exception IOException  ڑꂽ̓Xg[
     *                         o̓G[ꍇ
     */
    public boolean peekBoolean() throws IOException {
        if( 0 < this.bitCount ){
            return ( this.bitBuffer < 0 );
        }else{
            this.fillBitBuffer();                                               //throws LocalEOFException IOException
            return ( this.bitBuffer < 0 );
        }
    }

    /**
     * ǂݍ݈ʒuς count rbg̃f[^ǂ݂B<br>
     * ߂l int^ł邱Ƃ킩悤
     * őLrbg 32rbgłB<br>
     * EndOfStream t߂āAǂݏo邱ƂۏႳ̂
     * 32rbgłB(rbgobt@̑傫 32rbgł邽)<br>
     *  32rbgȏ̐ǂ݋@\K{ƂȂꍇ
     * ̓sx mark()AreadBits()Areset() JԂA
     * ̃NXgp邱Ƃ߂邱ƁB<br>
     * 
     * @param count ǂݍރrbg
     * 
     * @return ǂ݂ count rbg̃rbgf[^
     * 
     * @exception EOFException
     *                    EndOfStreamɒBĂꍇ
     * @exception IOException
     *                    ڑꂽ̓Xg[
     *                    o̓G[ꍇ
     * @exception NotEnoughBitsException
     *                    count ǂ݉\Ȕ͈͊Ȍꍇ
     */
    public int peekBits( int count ) throws IOException {
        if( 0 < count ){
            if( count <= this.bitCount ){
                return this.bitBuffer >>> ( 32 - count );
            }else{
                this.fillBitBuffer();                                           //throws LocalEOFException, IOException
                if( count <= this.bitCount ){
                    return this.bitBuffer >>> ( 32 - count );
                }else if( count <= this.cachedBits() ){
                    if( count <= 32 ){
                        int bits = this.bitBuffer;
                        bits |= ( this.cache[ this.cachePosition ] & 0xFF ) 
                                                  >> ( this.bitCount - 24 );
                        return bits >>> ( 32 - count );
                    }else if( count - 32 < this.bitCount ){
                        int bits  = this.bitBuffer << ( count - 32 );;
                        int bcnt = this.bitCount - ( count - 32 );
                        int pos   = this.cachePosition;
                        while( bcnt < 25 ){
                            bits  |= ( this.cache[ pos++ ] & 0xFF ) << ( 24 - bcnt );
                            bcnt += 8; 
                        }
                        if( bcnt < 32 ){
                            bits  |= ( this.cache[ pos ] & 0xFF ) >> ( bcnt - 24 );
                        }
                        return bits;
                    }else{
                        count  -= this.bitCount;
                        count  -= 32;
                        int pos = this.cachePosition + ( count >> 3 );
                        count  &= 0x07;
                        if( 0 < count ){
                            return   (   this.cache[ pos ]              << ( 24 + count ) )
                                   | ( ( this.cache[ pos + 1 ] & 0xFF ) << ( 16 + count ) )
                                   | ( ( this.cache[ pos + 2 ] & 0xFF ) << (  8 + count ) )
                                   | ( ( this.cache[ pos + 3 ] & 0xFF ) << count )
                                   | ( ( this.cache[ pos + 4 ] & 0xFF ) >> (  8 - count ) );
                        }else{
                            return   (   this.cache[ pos ]              << 24 )
                                   | ( ( this.cache[ pos + 1 ] & 0xFF ) << 16 )
                                   | ( ( this.cache[ pos + 2 ] & 0xFF ) <<  8 )
                                   |   ( this.cache[ pos + 3 ] & 0xFF );
                        }
                    }
                }else{
                    throw new NotEnoughBitsException( this.cachedBits() );
                }
            }
        }else{
            return 0;
        }
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int availableBits()
    //  private int cachedBits()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łrbg𓾂B<br>
     * 
     * @return ubNȂœǂݏorbgB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int availableBits() throws IOException {
        int avail = ( this.cacheLimit - this.cachePosition )
                  + this.in.available() / this.cache.length * this.cache.length;//throws IOException
        avail += this.bitCount - 32;

        return Math.max( avail, 0 );
    }

    /**
     *  BitInputStream ɒ~Ărbg𓾂B<br>
     * 
     * @return  BitInputStream ɒ~ĂrbgB<br>
     */
    private int cachedBits(){
        return this.bitCount + ( ( this.cacheLimit - this.cachePosition ) << 3 );
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  fill
    //------------------------------------------------------------------
    //  private void fillBitBuffer()
    //  private void fillCache()
    //------------------------------------------------------------------
    /**
     * bitBuffer Ƀf[^𖞂B
     * EndOfStream t߂ bitBuffer ɂ
     * 25bit ̃f[^mۂ邱ƂۏႷB
     * 
     * @exception IOException       o̓G[ꍇ
     * @exception LocalEOFException bitBuffer ̏Ԃ EndOfStream ɒBꍇ
     */
    private void fillBitBuffer() throws IOException {
        if( 32 <= this.cachedBits() ){
            if( this.bitCount <= 24 ){
                if( this.bitCount <= 16 ){
                    if( this.bitCount <= 8 ){
                        if( this.bitCount <= 0 ){
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount  = 8;
                        }
                        this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                            << ( 24 - this.bitCount );
                        this.bitCount  += 8;
                    }
                    this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                        << ( 24 - this.bitCount );
                    this.bitCount  += 8;
                }
                this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                    << ( 24 - this.bitCount );
                this.bitCount  += 8;
            }
        }else if( this.bitCount < 25 ){
            if( this.bitCount == 0 ){
                this.bitBuffer = 0;
            }

            int count = Math.min( ( 32 - this.bitCount ) >> 3, 
                                  this.cacheLimit - this.cachePosition );
            while( 0 < count-- ){
                this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                    << ( 24 - this.bitCount );
                this.bitCount  += 8;
            }
            this.fillCache();                                                   //throws IOException
            if( this.cachePosition < this.cacheLimit ){
                count = Math.min( ( 32 - this.bitCount ) >> 3, 
                                  this.cacheLimit - this.cachePosition );
                while( 0 < count-- ){
                    this.bitBuffer |= ( this.cache[this.cachePosition++] & 0xFF )
                                                        << ( 24 - this.bitCount );
                    this.bitCount  += 8;
                }
            }else if( this.bitCount <= 0 ){
                throw new LocalEOFException( this );
            }
        }
    }

    /**
     * cache ɂȂ cache Ƀf[^ǂݍށB
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;

        //cache Ƀf[^ǂݍ
        int read = 0;
        while( 0 <= read && this.cacheLimit < this.cache.length ){
            read = this.in.read( this.cache,
                                 this.cacheLimit, 
                                 this.cache.length - this.cacheLimit );         //throws IOException

            if( 0 < read ) this.cacheLimit += read;
        }
    }


    //------------------------------------------------------------------
    //  inner classes
    //------------------------------------------------------------------
    //  private static class LocalEOFException
    //------------------------------------------------------------------
    /**
     * BitInputStream  EndOfStream ̌o
     * EOFException gp̂͏X肪̂
     * [J EOFException `B
     */
    private static class LocalEOFException extends EOFException {


        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private Object owner
        //------------------------------------------------------------------
        /**
         * ̗O𓊂IuWFNg
         */
        private Object owner;

        //------------------------------------------------------------------
        //  constructer
        //------------------------------------------------------------------
        //  public LocalEOFException( Object object )
        //------------------------------------------------------------------
        /**
         * RXgN^B
         * 
         * @param object ̗O𓊂IuWFNg
         */
        public LocalEOFException( Object object ){
            super();
            this.owner = object;
        }

        //------------------------------------------------------------------
        //  access method
        //------------------------------------------------------------------
        //  public boolean thrownBy( Object object )
        //------------------------------------------------------------------
        /**
         * ̗O object ɂēꂽǂ𓾂B<br>
         * 
         * @param object IuWFNg
         * 
         * @return ̗O objectɂ
         *         ꂽOł true<br>
         *         Ⴆ false<br>
         */
        public boolean thrownBy( Object object ){
            return this.owner == object;
        }
    }

}
//end of BitInputStream.java
