/* tape_set.c: 'set' functions for libspectrum_tape_block
   Copyright (c) 2003 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* NB: this file is autogenerated from ./tape_accessors.txt by ./tape_set.pl */

#include <config.h>

#include "internals.h"
#include "tape_block.h"

libspectrum_error
libspectrum_tape_block_set_bit_length( libspectrum_tape_block *block, libspectrum_dword bit_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.bit_length = bit_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit0_length( libspectrum_tape_block *block, libspectrum_dword bit0_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.bit0_length = bit0_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.bit0_length = bit0_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit1_length( libspectrum_tape_block *block, libspectrum_dword bit1_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.bit1_length = bit1_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.bit1_length = bit1_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bits_in_last_byte( libspectrum_tape_block *block, size_t bits_in_last_byte )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.bits_in_last_byte = bits_in_last_byte; break;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.bits_in_last_byte = bits_in_last_byte; break;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.bits_in_last_byte = bits_in_last_byte; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.bits_in_last_byte = bits_in_last_byte; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bits_per_data_symbol( libspectrum_tape_block *block, size_t bits_per_data_symbol )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.bits_per_data_symbol = bits_per_data_symbol; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_count( libspectrum_tape_block *block, size_t count )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: block->types.pure_tone.pulses = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_PULSES: block->types.pulses.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_LOOP_START: block->types.loop_start.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: block->types.select.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: block->types.archive_info.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: block->types.hardware.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_PULSE_SEQUENCE: block->types.pulse_sequence.count = count; break;
    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.count = count; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_data( libspectrum_tape_block *block, libspectrum_byte* data )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: block->types.custom.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: block->types.rle_pulse.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: block->types.rom.data = data; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.data = data; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_data_length( libspectrum_tape_block *block, size_t data_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: block->types.custom.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: block->types.rle_pulse.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: block->types.rom.length = data_length; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.length = data_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_data_table( libspectrum_tape_block *block, libspectrum_tape_generalised_data_symbol_table* data_table )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.data_table = *data_table; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_ids( libspectrum_tape_block *block, int *ids )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: block->types.archive_info.ids = ids; break;
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: block->types.hardware.ids = ids; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_offset( libspectrum_tape_block *block, int offset )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_JUMP: block->types.jump.offset = offset; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_offsets( libspectrum_tape_block *block, int *offsets )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_SELECT: block->types.select.offsets = offsets; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pause( libspectrum_tape_block *block, libspectrum_dword pause )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.pause = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: block->types.message.time = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_PAUSE: block->types.pause.length = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.pause = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.pause = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: block->types.rom.pause = pause; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.pause = pause; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pause_tstates( libspectrum_tape_block *block, libspectrum_dword pause_tstates )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.pause_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: block->types.message.time_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_PAUSE: block->types.pause.length_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: block->types.pure_data.pause_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: block->types.raw_data.pause_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: block->types.rom.pause_tstates = pause_tstates; break;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.pause_tstates = pause_tstates; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pilot_length( libspectrum_tape_block *block, libspectrum_dword pilot_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.pilot_length = pilot_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pilot_pulses( libspectrum_tape_block *block, size_t pilot_pulses )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.pilot_pulses = pilot_pulses; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pilot_repeats( libspectrum_tape_block *block, libspectrum_word *pilot_repeats )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.pilot_repeats = pilot_repeats; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pilot_symbols( libspectrum_tape_block *block, libspectrum_byte *pilot_symbols )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.pilot_symbols = pilot_symbols; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pilot_table( libspectrum_tape_block *block, libspectrum_tape_generalised_data_symbol_table* pilot_table )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: block->types.generalised_data.pilot_table = *pilot_table; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pulse_length( libspectrum_tape_block *block, libspectrum_dword pulse_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: block->types.pure_tone.length = pulse_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_scale( libspectrum_tape_block *block, libspectrum_dword scale )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: block->types.rle_pulse.scale = scale; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pulse_lengths( libspectrum_tape_block *block, libspectrum_dword *pulse_lengths )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PULSES: block->types.pulses.lengths = pulse_lengths; break;
    case LIBSPECTRUM_TAPE_BLOCK_PULSE_SEQUENCE: block->types.pulse_sequence.lengths = pulse_lengths; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_pulse_repeats( libspectrum_tape_block *block, size_t *pulse_repeats )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PULSE_SEQUENCE: block->types.pulse_sequence.pulse_repeats = pulse_repeats; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_sync1_length( libspectrum_tape_block *block, libspectrum_dword sync1_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.sync1_length = sync1_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_sync2_length( libspectrum_tape_block *block, libspectrum_dword sync2_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: block->types.turbo.sync2_length = sync2_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_tail_length( libspectrum_tape_block *block, libspectrum_dword tail_length )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.tail_length = tail_length; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_text( libspectrum_tape_block *block, char* text )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GROUP_START: block->types.group_start.name = text; break;
    case LIBSPECTRUM_TAPE_BLOCK_COMMENT: block->types.comment.text = text; break;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: block->types.message.text = text; break;
    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: block->types.custom.description = text; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_texts( libspectrum_tape_block *block, char* *texts )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: block->types.archive_info.strings = texts; break;
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: block->types.select.descriptions = texts; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_types( libspectrum_tape_block *block, int *types )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: block->types.hardware.types = types; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_values( libspectrum_tape_block *block, int *values )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: block->types.hardware.values = values; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_level( libspectrum_tape_block *block, int level )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PAUSE: block->types.pause.level = level; break;
    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.initial_level = level; break;
    case LIBSPECTRUM_TAPE_BLOCK_SET_SIGNAL_LEVEL: block->types.set_signal_level.level = level; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit0_pulse_count( libspectrum_tape_block *block, libspectrum_byte bit0_pulse_count )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.bit0_pulse_count = bit0_pulse_count; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit1_pulse_count( libspectrum_tape_block *block, libspectrum_byte bit1_pulse_count )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.bit1_pulse_count = bit1_pulse_count; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit0_pulses( libspectrum_tape_block *block, libspectrum_word *bit0_pulses )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.bit0_pulses = bit0_pulses; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_tape_block_set_bit1_pulses( libspectrum_tape_block *block, libspectrum_word *bit1_pulses )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_DATA_BLOCK: block->types.data_block.bit1_pulses = bit1_pulses; break;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%2x given to %s", block->type, __func__
      );
      return LIBSPECTRUM_ERROR_INVALID;
  }

  return LIBSPECTRUM_ERROR_NONE;
}

