package org.apache.maven.scm.provider.synergy.consumer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.log.DefaultLog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @author <a href="mailto:jan.malcomess@steria-mummert.de">Jan Malcomess</a>
 */
public class SynergyShowDefaultTaskConsumerTest
    extends ScmTestCase
{
    public void testShowDefaultTaskSet()
        throws IOException
    {
        InputStream inputStream = getResourceAsStream( "/synergy/consumer/showDefaultTaskSet.txt" );

        try
        {
            BufferedReader in = new BufferedReader( new InputStreamReader( inputStream ) );

            String s = in.readLine();

            SynergyShowDefaultTaskConsumer consumer = new SynergyShowDefaultTaskConsumer( new DefaultLog() );

            while ( s != null )
            {
                consumer.consumeLine( s );

                s = in.readLine();
            }
            assertEquals( 52885, consumer.getTask() );
        }
        finally
        {
            inputStream.close();
        }
    }

    public void testShowDefaultTaskNotSet()
        throws IOException
    {
        InputStream inputStream = getResourceAsStream( "/synergy/consumer/showDefaultTaskNotSet.txt" );

        try
        {
            BufferedReader in = new BufferedReader( new InputStreamReader( inputStream ) );

            String s = in.readLine();

            SynergyShowDefaultTaskConsumer consumer = new SynergyShowDefaultTaskConsumer( new DefaultLog() );

            while ( s != null )
            {
                consumer.consumeLine( s );

                s = in.readLine();
            }
            assertEquals( 0, consumer.getTask() );
        }
        finally
        {
            inputStream.close();
        }
    }
}
