/* Settings.c generated by valac 0.28.1, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

struct _SettingsPrivate {
	gchar* _device;
	gint _baudRate;
	gint _dataBits;
	gint _stopBits;
	SettingsParity _parity;
	SettingsHandshake _handshake;
	SettingsAccessMode _accessMode;
	gboolean _localEcho;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer settings_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;
gchar* settings_DEFAULT_DEVICEFILE = NULL;
extern gint settings_DEFAULT_BAUDRATE;
gint settings_DEFAULT_BAUDRATE = 1200;
extern gint settings_DEFAULT_DATABITS;
gint settings_DEFAULT_DATABITS = 8;
extern gint settings_DEFAULT_STOPBITS;
gint settings_DEFAULT_STOPBITS = 1;
extern SettingsParity settings_DEFAULT_PARITY;
SettingsParity settings_DEFAULT_PARITY = SETTINGS_PARITY_NONE;
extern SettingsHandshake settings_DEFAULT_HANDSHAKE;
SettingsHandshake settings_DEFAULT_HANDSHAKE = SETTINGS_HANDSHAKE_HARDWARE;
extern SettingsAccessMode settings_DEFAULT_ACCESSMODE;
SettingsAccessMode settings_DEFAULT_ACCESSMODE = SETTINGS_ACCESS_MODE_READWRITE;
extern gboolean settings_DEFAULT_LOCAL_ECHO;
gboolean settings_DEFAULT_LOCAL_ECHO = FALSE;

GType settings_get_type (void) G_GNUC_CONST;
GType settings_parity_get_type (void) G_GNUC_CONST;
GType settings_handshake_get_type (void) G_GNUC_CONST;
GType settings_access_mode_get_type (void) G_GNUC_CONST;
#define SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS, SettingsPrivate))
enum  {
	SETTINGS_DUMMY_PROPERTY,
	SETTINGS_DEVICE,
	SETTINGS_BAUD_RATE,
	SETTINGS_DATA_BITS,
	SETTINGS_STOP_BITS,
	SETTINGS_PARITY,
	SETTINGS_HANDSHAKE,
	SETTINGS_ACCESS_MODE,
	SETTINGS_LOCAL_ECHO
};
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
gchar* settings_parityToChar (Settings* self);
SettingsParity settings_get_parity (Settings* self);
gchar* settings_getStatusbarString (Settings* self, gboolean open);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType profile_get_type (void) G_GNUC_CONST;
void settings_saveToProfile (Settings* self, Profile* profile);
SettingsHandshake settings_get_handshake (Settings* self);
SettingsAccessMode settings_get_accessMode (Settings* self);
gboolean settings_get_localEcho (Settings* self);
Settings* settings_loadFromProfile (Profile* profile);
gchar* mo_utils_getKeyString (Profile* profile, const gchar* group, const gchar* key);
gint mo_utils_getKeyInteger (Profile* profile, const gchar* group, const gchar* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const gchar* group, const gchar* key, gboolean default_val);
static void settings_set_device (Settings* self, const gchar* value);
static void settings_set_baudRate (Settings* self, gint value);
static void settings_set_dataBits (Settings* self, gint value);
static void settings_set_stopBits (Settings* self, gint value);
static void settings_set_parity (Settings* self, SettingsParity value);
static void settings_set_handshake (Settings* self, SettingsHandshake value);
static void settings_set_accessMode (Settings* self, SettingsAccessMode value);
static void settings_set_localEcho (Settings* self, gboolean value);
static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void settings_finalize (GObject* obj);
static void _vala_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

const gchar* SETTINGS_ParityModeStrings[5] = {"None", "Odd", "Even", "Mark", "Space"};
const gchar* SETTINGS_AccessModeStrings[3] = {"Read and Write", "Read Only", "Write Only"};
const gchar* SETTINGS_DataBitItems[4] = {"5", "6", "7", "8"};
const gchar* SETTINGS_StopBitItems[2] = {"1", "2"};
const gchar* SETTINGS_BaudRateItems[16] = {"300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200", "230400", "460800", "576000", "927600", "1000000", "2000000"};

GType settings_parity_get_type (void) {
	static volatile gsize settings_parity_type_id__volatile = 0;
	if (g_once_init_enter (&settings_parity_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_PARITY_NONE, "SETTINGS_PARITY_NONE", "none"}, {SETTINGS_PARITY_ODD, "SETTINGS_PARITY_ODD", "odd"}, {SETTINGS_PARITY_EVEN, "SETTINGS_PARITY_EVEN", "even"}, {SETTINGS_PARITY_MARK, "SETTINGS_PARITY_MARK", "mark"}, {SETTINGS_PARITY_SPACE, "SETTINGS_PARITY_SPACE", "space"}, {0, NULL, NULL}};
		GType settings_parity_type_id;
		settings_parity_type_id = g_enum_register_static ("SettingsParity", values);
		g_once_init_leave (&settings_parity_type_id__volatile, settings_parity_type_id);
	}
	return settings_parity_type_id__volatile;
}


GType settings_handshake_get_type (void) {
	static volatile gsize settings_handshake_type_id__volatile = 0;
	if (g_once_init_enter (&settings_handshake_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_HANDSHAKE_NONE, "SETTINGS_HANDSHAKE_NONE", "none"}, {SETTINGS_HANDSHAKE_HARDWARE, "SETTINGS_HANDSHAKE_HARDWARE", "hardware"}, {SETTINGS_HANDSHAKE_SOFTWARE, "SETTINGS_HANDSHAKE_SOFTWARE", "software"}, {SETTINGS_HANDSHAKE_BOTH, "SETTINGS_HANDSHAKE_BOTH", "both"}, {0, NULL, NULL}};
		GType settings_handshake_type_id;
		settings_handshake_type_id = g_enum_register_static ("SettingsHandshake", values);
		g_once_init_leave (&settings_handshake_type_id__volatile, settings_handshake_type_id);
	}
	return settings_handshake_type_id__volatile;
}


GType settings_access_mode_get_type (void) {
	static volatile gsize settings_access_mode_type_id__volatile = 0;
	if (g_once_init_enter (&settings_access_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_ACCESS_MODE_READWRITE, "SETTINGS_ACCESS_MODE_READWRITE", "readwrite"}, {SETTINGS_ACCESS_MODE_READONLY, "SETTINGS_ACCESS_MODE_READONLY", "readonly"}, {SETTINGS_ACCESS_MODE_WRITEONLY, "SETTINGS_ACCESS_MODE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
		GType settings_access_mode_type_id;
		settings_access_mode_type_id = g_enum_register_static ("SettingsAccessMode", values);
		g_once_init_leave (&settings_access_mode_type_id__volatile, settings_access_mode_type_id);
	}
	return settings_access_mode_type_id__volatile;
}


Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	Settings * self = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	SettingsParity _tmp4_ = 0;
	SettingsHandshake _tmp5_ = 0;
	SettingsAccessMode _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	_tmp0_ = device;
	_tmp1_ = baudRate;
	_tmp2_ = dataBits;
	_tmp3_ = stopBits;
	_tmp4_ = parity;
	_tmp5_ = handshake;
	_tmp6_ = accessMode;
	_tmp7_ = localEcho;
	self = (Settings*) g_object_new (object_type, "device", _tmp0_, "baudRate", _tmp1_, "dataBits", _tmp2_, "stopBits", _tmp3_, "parity", _tmp4_, "handshake", _tmp5_, "accessMode", _tmp6_, "localEcho", _tmp7_, NULL);
	return self;
}


Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	return settings_construct (TYPE_SETTINGS, device, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
}


gchar* settings_parityToChar (Settings* self) {
	gchar* result = NULL;
	SettingsParity _tmp0_ = 0;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parity;
	switch (_tmp0_) {
		case SETTINGS_PARITY_NONE:
		{
			{
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_ = NULL;
				_tmp1_ = _ ("N");
				_tmp2_ = g_strdup (_tmp1_);
				result = _tmp2_;
				return result;
			}
		}
		case SETTINGS_PARITY_ODD:
		{
			{
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				_tmp3_ = _ ("O");
				_tmp4_ = g_strdup (_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
		case SETTINGS_PARITY_EVEN:
		{
			{
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				_tmp5_ = _ ("E");
				_tmp6_ = g_strdup (_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
		case SETTINGS_PARITY_MARK:
		{
			{
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp7_ = _ ("M");
				_tmp8_ = g_strdup (_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
		case SETTINGS_PARITY_SPACE:
		{
			{
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				_tmp9_ = _ ("S");
				_tmp10_ = g_strdup (_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
		default:
		break;
	}
	_tmp11_ = g_strdup ("?");
	result = _tmp11_;
	return result;
}


gchar* settings_getStatusbarString (Settings* self, gboolean open) {
	gchar* result = NULL;
	gchar* r = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = g_strdup_printf ("%s", _tmp0_);
	_g_free0 (r);
	r = _tmp1_;
	_tmp2_ = open;
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp3_ = r;
		_tmp4_ = g_strconcat (_tmp3_, " ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("OPEN");
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, " ", NULL);
		_g_free0 (r);
		r = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
	} else {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp10_ = r;
		_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = _ ("CLOSED");
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, " ", NULL);
		_g_free0 (r);
		r = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
	}
	_tmp17_ = r;
	_tmp18_ = self->priv->_baudRate;
	_tmp19_ = self->priv->_dataBits;
	_tmp20_ = settings_parityToChar (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_stopBits;
	_tmp23_ = g_strdup_printf ("%i,%i%s%i", _tmp18_, _tmp19_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp17_, _tmp24_, NULL);
	_g_free0 (r);
	r = _tmp25_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	result = r;
	return result;
}


void settings_saveToProfile (Settings* self, Profile* profile) {
	Profile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Profile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Profile* _tmp6_ = NULL;
	GKeyFile* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Profile* _tmp9_ = NULL;
	GKeyFile* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	Profile* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	SettingsParity _tmp14_ = 0;
	Profile* _tmp15_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	SettingsHandshake _tmp17_ = 0;
	Profile* _tmp18_ = NULL;
	GKeyFile* _tmp19_ = NULL;
	SettingsAccessMode _tmp20_ = 0;
	Profile* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	_tmp0_ = profile;
	_tmp1_ = _tmp0_->keyFile;
	_tmp2_ = self->priv->_device;
	g_key_file_set_string (_tmp1_, "port_settings", "device", _tmp2_);
	_tmp3_ = profile;
	_tmp4_ = _tmp3_->keyFile;
	_tmp5_ = self->priv->_baudRate;
	g_key_file_set_integer (_tmp4_, "port_settings", "baud_rate", _tmp5_);
	_tmp6_ = profile;
	_tmp7_ = _tmp6_->keyFile;
	_tmp8_ = self->priv->_dataBits;
	g_key_file_set_integer (_tmp7_, "port_settings", "data_bits", _tmp8_);
	_tmp9_ = profile;
	_tmp10_ = _tmp9_->keyFile;
	_tmp11_ = self->priv->_stopBits;
	g_key_file_set_integer (_tmp10_, "port_settings", "stop_bits", _tmp11_);
	_tmp12_ = profile;
	_tmp13_ = _tmp12_->keyFile;
	_tmp14_ = self->priv->_parity;
	g_key_file_set_integer (_tmp13_, "port_settings", "parity", (gint) _tmp14_);
	_tmp15_ = profile;
	_tmp16_ = _tmp15_->keyFile;
	_tmp17_ = self->priv->_handshake;
	g_key_file_set_integer (_tmp16_, "port_settings", "handshake", (gint) _tmp17_);
	_tmp18_ = profile;
	_tmp19_ = _tmp18_->keyFile;
	_tmp20_ = self->priv->_accessMode;
	g_key_file_set_integer (_tmp19_, "port_settings", "access_mode", (gint) _tmp20_);
	_tmp21_ = profile;
	_tmp22_ = _tmp21_->keyFile;
	_tmp23_ = self->priv->_localEcho;
	g_key_file_set_boolean (_tmp22_, "port_settings", "local_echo", _tmp23_);
}


Settings* settings_loadFromProfile (Profile* profile) {
	Settings* result = NULL;
	gchar* device = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean localEcho = FALSE;
	Profile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Profile* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Profile* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Profile* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	Profile* _tmp13_ = NULL;
	SettingsParity _tmp14_ = 0;
	gint _tmp15_ = 0;
	Profile* _tmp16_ = NULL;
	SettingsHandshake _tmp17_ = 0;
	gint _tmp18_ = 0;
	Profile* _tmp19_ = NULL;
	SettingsAccessMode _tmp20_ = 0;
	gint _tmp21_ = 0;
	Profile* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	Settings* _tmp26_ = NULL;
	g_return_val_if_fail (profile != NULL, NULL);
	_tmp0_ = settings_DEFAULT_DEVICEFILE;
	_tmp1_ = g_strdup (_tmp0_);
	device = _tmp1_;
	_tmp2_ = profile;
	_tmp3_ = mo_utils_getKeyString (_tmp2_, "port_settings", "device");
	_g_free0 (device);
	device = _tmp3_;
	_tmp4_ = profile;
	_tmp5_ = settings_DEFAULT_BAUDRATE;
	_tmp6_ = mo_utils_getKeyInteger (_tmp4_, "port_settings", "baud_rate", _tmp5_);
	baudRate = _tmp6_;
	_tmp7_ = profile;
	_tmp8_ = settings_DEFAULT_DATABITS;
	_tmp9_ = mo_utils_getKeyInteger (_tmp7_, "port_settings", "data_bits", _tmp8_);
	dataBits = _tmp9_;
	_tmp10_ = profile;
	_tmp11_ = settings_DEFAULT_STOPBITS;
	_tmp12_ = mo_utils_getKeyInteger (_tmp10_, "port_settings", "stop_bits", _tmp11_);
	stopBits = _tmp12_;
	_tmp13_ = profile;
	_tmp14_ = settings_DEFAULT_PARITY;
	_tmp15_ = mo_utils_getKeyInteger (_tmp13_, "port_settings", "parity", (gint) _tmp14_);
	parity = (SettingsParity) _tmp15_;
	_tmp16_ = profile;
	_tmp17_ = settings_DEFAULT_HANDSHAKE;
	_tmp18_ = mo_utils_getKeyInteger (_tmp16_, "port_settings", "handshake", (gint) _tmp17_);
	handshake = (SettingsHandshake) _tmp18_;
	_tmp19_ = profile;
	_tmp20_ = settings_DEFAULT_ACCESSMODE;
	_tmp21_ = mo_utils_getKeyInteger (_tmp19_, "port_settings", "access_mode", (gint) _tmp20_);
	accessMode = (SettingsAccessMode) _tmp21_;
	_tmp22_ = profile;
	_tmp23_ = settings_DEFAULT_LOCAL_ECHO;
	_tmp24_ = mo_utils_getKeyBoolean (_tmp22_, "port_settings", "local_echo", _tmp23_);
	localEcho = _tmp24_;
	_tmp25_ = device;
	_tmp26_ = settings_new (_tmp25_, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
	result = _tmp26_;
	_g_free0 (device);
	return result;
}


const gchar* settings_get_device (Settings* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void settings_set_device (Settings* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp1_;
	g_object_notify ((GObject *) self, "device");
}


gint settings_get_baudRate (Settings* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_baudRate;
	result = _tmp0_;
	return result;
}


static void settings_set_baudRate (Settings* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_baudRate = _tmp0_;
	g_object_notify ((GObject *) self, "baudRate");
}


gint settings_get_dataBits (Settings* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dataBits;
	result = _tmp0_;
	return result;
}


static void settings_set_dataBits (Settings* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_dataBits = _tmp0_;
	g_object_notify ((GObject *) self, "dataBits");
}


gint settings_get_stopBits (Settings* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_stopBits;
	result = _tmp0_;
	return result;
}


static void settings_set_stopBits (Settings* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_stopBits = _tmp0_;
	g_object_notify ((GObject *) self, "stopBits");
}


SettingsParity settings_get_parity (Settings* self) {
	SettingsParity result;
	SettingsParity _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_parity;
	result = _tmp0_;
	return result;
}


static void settings_set_parity (Settings* self, SettingsParity value) {
	SettingsParity _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parity = _tmp0_;
	g_object_notify ((GObject *) self, "parity");
}


SettingsHandshake settings_get_handshake (Settings* self) {
	SettingsHandshake result;
	SettingsHandshake _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_handshake;
	result = _tmp0_;
	return result;
}


static void settings_set_handshake (Settings* self, SettingsHandshake value) {
	SettingsHandshake _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_handshake = _tmp0_;
	g_object_notify ((GObject *) self, "handshake");
}


SettingsAccessMode settings_get_accessMode (Settings* self) {
	SettingsAccessMode result;
	SettingsAccessMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_accessMode;
	result = _tmp0_;
	return result;
}


static void settings_set_accessMode (Settings* self, SettingsAccessMode value) {
	SettingsAccessMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_accessMode = _tmp0_;
	g_object_notify ((GObject *) self, "accessMode");
}


gboolean settings_get_localEcho (Settings* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_localEcho;
	result = _tmp0_;
	return result;
}


static void settings_set_localEcho (Settings* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_localEcho = _tmp0_;
	g_object_notify ((GObject *) self, "localEcho");
}


static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Settings * self;
	const gchar* _tmp0_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	parent_class = G_OBJECT_CLASS (settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_tmp0_ = self->priv->_device;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = settings_DEFAULT_DEVICEFILE;
		settings_set_device (self, _tmp1_);
	}
	_tmp2_ = self->priv->_baudRate;
	if (_tmp2_ == 0) {
		gint _tmp3_ = 0;
		_tmp3_ = settings_DEFAULT_BAUDRATE;
		settings_set_baudRate (self, _tmp3_);
	}
	_tmp4_ = self->priv->_dataBits;
	if (_tmp4_ == 0) {
		gint _tmp5_ = 0;
		_tmp5_ = settings_DEFAULT_DATABITS;
		settings_set_dataBits (self, _tmp5_);
	}
	_tmp6_ = self->priv->_stopBits;
	if (_tmp6_ == 0) {
		gint _tmp7_ = 0;
		_tmp7_ = settings_DEFAULT_STOPBITS;
		settings_set_stopBits (self, _tmp7_);
	}
	return obj;
}


static void settings_class_init (SettingsClass * klass) {
	gchar* _tmp0_ = NULL;
	settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DEVICE, g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_BAUD_RATE, g_param_spec_int ("baudRate", "baudRate", "baudRate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DATA_BITS, g_param_spec_int ("dataBits", "dataBits", "dataBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_STOP_BITS, g_param_spec_int ("stopBits", "stopBits", "stopBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_PARITY, g_param_spec_enum ("parity", "parity", "parity", SETTINGS_TYPE_PARITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_HANDSHAKE, g_param_spec_enum ("handshake", "handshake", "handshake", SETTINGS_TYPE_HANDSHAKE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_ACCESS_MODE, g_param_spec_enum ("accessMode", "accessMode", "accessMode", SETTINGS_TYPE_ACCESS_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_LOCAL_ECHO, g_param_spec_boolean ("localEcho", "localEcho", "localEcho", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("/dev/ttyS0");
	settings_DEFAULT_DEVICEFILE = _tmp0_;
}


static void settings_instance_init (Settings * self) {
	self->priv = SETTINGS_GET_PRIVATE (self);
}


static void settings_finalize (GObject* obj) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (settings_parent_class)->finalize (obj);
}


GType settings_get_type (void) {
	static volatile gsize settings_type_id__volatile = 0;
	if (g_once_init_enter (&settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Settings), 0, (GInstanceInitFunc) settings_instance_init, NULL };
		GType settings_type_id;
		settings_type_id = g_type_register_static (G_TYPE_OBJECT, "Settings", &g_define_type_info, 0);
		g_once_init_leave (&settings_type_id__volatile, settings_type_id);
	}
	return settings_type_id__volatile;
}


static void _vala_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE:
		g_value_set_string (value, settings_get_device (self));
		break;
		case SETTINGS_BAUD_RATE:
		g_value_set_int (value, settings_get_baudRate (self));
		break;
		case SETTINGS_DATA_BITS:
		g_value_set_int (value, settings_get_dataBits (self));
		break;
		case SETTINGS_STOP_BITS:
		g_value_set_int (value, settings_get_stopBits (self));
		break;
		case SETTINGS_PARITY:
		g_value_set_enum (value, settings_get_parity (self));
		break;
		case SETTINGS_HANDSHAKE:
		g_value_set_enum (value, settings_get_handshake (self));
		break;
		case SETTINGS_ACCESS_MODE:
		g_value_set_enum (value, settings_get_accessMode (self));
		break;
		case SETTINGS_LOCAL_ECHO:
		g_value_set_boolean (value, settings_get_localEcho (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE:
		settings_set_device (self, g_value_get_string (value));
		break;
		case SETTINGS_BAUD_RATE:
		settings_set_baudRate (self, g_value_get_int (value));
		break;
		case SETTINGS_DATA_BITS:
		settings_set_dataBits (self, g_value_get_int (value));
		break;
		case SETTINGS_STOP_BITS:
		settings_set_stopBits (self, g_value_get_int (value));
		break;
		case SETTINGS_PARITY:
		settings_set_parity (self, g_value_get_enum (value));
		break;
		case SETTINGS_HANDSHAKE:
		settings_set_handshake (self, g_value_get_enum (value));
		break;
		case SETTINGS_ACCESS_MODE:
		settings_set_accessMode (self, g_value_get_enum (value));
		break;
		case SETTINGS_LOCAL_ECHO:
		settings_set_localEcho (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



