Summary: A help for laptop users in different network environments
Name: netenv
Version: 0.94
Release: 3
Copyright: GPL
Group: System Environment/Base
Packager: Gerd Bavendiek <bav@epost.de>
Source: netenv-0.94-2.tar.gz
Buildroot: /tmp/%{name}-root

%description
Do you use your laptop in different network environments ?
At home ? In the office ? At a customers site ?

If yes, the small package "netenv" might be useful for you. When 
booting your laptop it provides you with a simple interface from 
which you can choose the current network environment. If you are 
the first time in an environment, you can enter the basic data
for later reuse.

%prep

%setup -c netenv

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS -DUSE_LOCALE"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/etc/netenv
cp -p netenv $RPM_BUILD_ROOT/usr/sbin
cp -p trpnc $RPM_BUILD_ROOT/usr/bin

%files
%doc README
%doc doc/*
/usr/sbin/netenv
/usr/bin/trpnc
%config /etc/netenv

%pre
if ! type gdialog > /dev/null 2>&1; then
   if ! type dialog > /dev/null 2>&1; then
      echo Neither gdialog nor dialog found, aborting installation ...
      echo Install packages gnome-utils or dialog to fix !
      exit 1
   fi
fi

%post
if grep 'SuSE Linux' /etc/issue > /dev/null; then
   echo seems to be a SuSE ...
   if grep '^/usr/sbin/netenv' /etc/rc.d/boot.local > /dev/null; then
      echo Found a call to netenv in /etc/rc.d/boot.local ...
   else
      echo Installing call to netenv in /etc/rc.d/boot.local ...
      echo '# Added by package netenv on '`date '+%x %X'` >> /etc/rc.d/boot.local
      echo /usr/sbin/netenv >> /etc/rc.d/boot.local
   fi
   NETWORK_CONFIG_BASEDIR=/etc/sysconfig/network
elif grep -i Red /etc/issue | grep -i Hat  > /dev/null; then
   echo seems to be a Redhat ...
   if grep '^/usr/sbin/netenv' /etc/rc.d/rc.sysinit > /dev/null; then
      echo Found a call to netenv in /etc/rc.d/rc.sysinit ...
   else
      echo Installing call to netenv in /etc/rc.d/rc.sysinit ...
      echo '# Added by package netenv on '`date '+%x %X'` >> /etc/rc.d/rc.sysinit
      echo /usr/sbin/netenv >> /etc/rc.d/rc.sysinit
   fi
   NETWORK_CONFIG_BASEDIR=/etc/sysconfig/network-scripts
else
   echo Neither SuSE nor RedHat - Please read the docs in /usr/share/doc/packages/netenv
   exit 1
fi

# Check for multiple NIC's
if dmesg | grep eth1 > /dev/null 2>&1; then
   echo according to dmesg you have two or more NICS
   echo netenv assumes eth0 to be active. Fix manually if this is wrong !
fi

# Step 2 - Make the netenv-data (in /tmp/netenv) available to the
# system's network configuration procedure
if grep '. /tmp/netenv' $NETWORK_CONFIG_BASEDIR/ifcfg-eth0 > /dev/null; then
   echo /tmp/netenv seems to be already sourced from $NETWORK_CONFIG_BASEDIR/ifcfg-eth0 ...
else
   echo Installing sourcing /tmp/netenv in $NETWORK_CONFIG_BASEDIR/ifcfg-eth0 ...
   echo '# Added by package netenv on '`date '+%x %X'` >> $NETWORK_CONFIG_BASEDIR/ifcfg-eth0
   echo 'if [ -r /tmp/netenv ]; then . /tmp/netenv; fi' >> $NETWORK_CONFIG_BASEDIR/ifcfg-eth0
fi
%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Mon Oct  6 2003 Gerd Bavendiek <bav@epost.de> 0.94-3
- Smarter grepping for Red Hat /etc/issue
* Fri Aug 01 2003 Gerd Bavendiek <bav@epost.de>
- Minor cleanups, new rpm built
* Mon Mar 10 2003 Gerd Bavendiek <bav@epost.de>
- New version 0.94
* Fri Sep 20 2002 Gerd Bavendiek <bav@epost.de>
- New version 0.93
* Sat Feb 10 2001 Gerd Bavendiek <bav@epost.de>
- Complete rewrite of the english manual
* Wed Jan 22 2001 Gerd Bavendiek <bav@epost.de>
- Reworking docs + adding german manual
- SuSe support
* Wed Mar  1 2000 Gerd Bavendiek <bav@esn.sbs.de>
- Initial RPM-Package

# Local Variables:
# rcpbuf-todo: ("/r@scp:root@coca:/usr/src/redhat/SPECS")
# End:
