/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import "Constants.js" as Const

Item {
    property alias date: noteDate.text

    Image {
        id: bottomFade
        anchors {
            bottom: parent.bottom
            left: parent.left
            right: parent.right
        }
        height: units.gu(5)
        source: "graphics/note_bottom_fade.png"
    }

    Label {
        id: noteDate
        anchors {
            bottom: parent.bottom
            right: parent.right
            margins: units.gu(1)
        }
        fontSize: "x-small"
        color: "#c7af87"
    }

    Behavior on opacity {
        NumberAnimation { duration: Const.animationDuration }
    }
}
